<?php

namespace Database\Seeders;

use App\Models\Chemical;
use Illuminate\Database\Seeder;

class ChemiCsvSeeder_old extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $existingCasNos = [];
        $csvFile = storage_path('chemical_fix.csv');
        $errorCsvFile = storage_path('chemicalbase_errors.csv');
        $batchData = [];
        $batchSize = 500;

        $csvData = array_map('str_getcsv', file($csvFile));
        // foreach ($csvData as $index => $row) {
        //     if (count($row) < 73) {
        //         echo "Row $index has fewer columns than expected: " . count($row) . "\n";
        //     }
        // }
        $errorCsv = fopen($errorCsvFile, 'w');


        $header = array_shift($csvData);
        fputcsv($errorCsv, $header);

        foreach ($csvData as $row) {
            $casNo = $row[array_search('bs_casno', $header)];
            if ($casNo === '' || in_array($casNo, $existingCasNos)) {
                $row[] = 'cas_no空值';
                fputcsv($errorCsv, $row);
                continue;
            }

            $existingChemical = Chemical::where('cas_no', $casNo)->first();
            if ($existingChemical) {
                $row[] = 'casNo 重複';
                fputcsv($errorCsv, $row);
                continue;
            }
            if (!$existingChemical) {
                $aFields = [
                    $row[array_search('bs_a201', $header)],
                    $row[array_search('bs_a202', $header)],
                    $row[array_search('bs_a203', $header)],
                    $row[array_search('bs_a204', $header)],
                    $row[array_search('bs_a205', $header)],
                    $row[array_search('bs_a206', $header)],
                    $row[array_search('bs_a207', $header)],
                    $row[array_search('bs_a208', $header)],
                    $row[array_search('bs_a209', $header)],
                    $row[array_search('bs_a210', $header)],
                    $row[array_search('bs_a211', $header)],
                    $row[array_search('bs_a212', $header)],
                    $row[array_search('bs_a213', $header)],
                    $row[array_search('bs_a214', $header)],
                    $row[array_search('bs_a215', $header)],
                    $row[array_search('bs_a216', $header)],
                    $row[array_search('bs_a217', $header)],
                    $row[array_search('bs_a217a', $header)],
                    $row[array_search('bs_a217b', $header)],
                    $row[array_search('bs_a217c', $header)],
                    $row[array_search('bs_a218', $header)],
                    $row[array_search('bs_a219', $header)],
                    $row[array_search('bs_a220a', $header)],
                    $row[array_search('bs_a220b', $header)],
                    $row[array_search('bs_a221', $header)],
                    $row[array_search('bs_a222', $header)],
                    $row[array_search('bs_a223a', $header)],
                    $row[array_search('bs_a223b', $header)],
                    $row[array_search('bs_a224', $header)],
                    $row[array_search('bs_a224b', $header)],
                    $row[array_search('bs_a225', $header)],
                    $row[array_search('bs_a225b', $header)],
                    $row[array_search('bs_a226', $header)],
                    $row[array_search('bs_a227a', $header)],
                    $row[array_search('bs_a227b', $header)],
                ];

                $countOnes = array_count_values($aFields)[1] ?? 0;
                if ($countOnes >= 2) {
                    $row[] = 'GHS複選';
                    fputcsv($errorCsv, $row);
                    continue;
                }

                $batchData[] = [
                    'cas_no' =>  trim($row[array_search('bs_casno', $header)]),
                    'ch_name' => trim($row[array_search('bs_cshort', $header)]),
                    'en_name' => trim($row[array_search('bs_eshort', $header)]),
                    'hazards' => $this->convertYN($row[array_search('bs_risk', $header)]) ?? null,
                    'priority' => $this->convertYN($row[array_search('bs_first', $header)]) ?? null,
                    'list_priority' => $row[array_search('bs_first_extension', $header)],
                    'control' => $this->convertYN($row[array_search('bs_control', $header)]) ?? null,
                    'pioneer' => $this->convertYN($row[array_search('bs_env', $header)]) ?? null,
                    'water_poll' => $this->convertYN($row[array_search('bs_isnowater', $header)]) ?? null,
                    'concerned' => $this->convertYN($row[array_search('bs_concern', $header)]) ?? null,
                    'list_concerned' => $row[array_search('bs_concern_extension', $header)] ?? null,
                    'toxic_moenv' => $this->convertYN($row[array_search('bs_poich', $header)]) ?? null,
                    'listNo' => $row[array_search('bs_poichno', $header)] ?? null,
                    'toxic_class' => $row[array_search('bs_poichtype', $header)] ?? null,
                    'conc' => $row[array_search('bs_poichthick', $header)] ?? null,
                    'graded' => $row[array_search('bs_maxWeight', $header)] ?? null,
                    'boil' => $row[array_search('bs_boiling', $header)] ?? null,
                    'melt' => $row[array_search('bs_fusion', $header)] ?? null,
                    'formula' => $row[array_search('bs_molfm', $header)] ?? null,
                    'molecular' => $row[array_search('bs_molecular', $header)] ?? null,
                    'ingredient' => $row[array_search('bs_element', $header)] ?? null,
                    'pub_hazard' => $this->convertYN($row[array_search('bs_danger', $header)]) ?? null,
                    'solv' => $this->convertYN($row[array_search('bs_organic', $header)]) ?? null,
                    'monitor' => $this->convertYN($row[array_search('bs_envmonitor', $header)]) ?? null,
                    'chem_spec' => $this->convertYN($row[array_search('bs_special', $header)]) ?? null,
                    'lead' => $this->convertYN($row[array_search('bs_pb', $header)]) ?? null,
                    'four_lead' => $this->convertYN($row[array_search('bs_pb4', $header)]) ?? null,
                    'ccd_health' => $this->convertYN($row[array_search('bs_ccb', $header)]),
                    'expose_conc' => $this->convertYN($row[array_search('bs_expose', $header)]) ?? null,
                    'pel_solide' => $row[array_search('bs_pelsolid', $header)] ?? null,
                    'pel_liquid' => $row[array_search('bs_pelliquid', $header)] ?? null,
                    'a201' => $this->convertBool($row[array_search('bs_a201', $header)]) ?? null,
                    'a202' => $this->convertBool($row[array_search('bs_a202', $header)]) ?? null,
                    'a203' => $this->convertBool($row[array_search('bs_a203', $header)]) ?? null,
                    'a204' => $this->convertBool($row[array_search('bs_a204', $header)]) ?? null,
                    'a205' => $this->convertBool($row[array_search('bs_a205', $header)]) ?? null,
                    'a206' => $this->convertBool($row[array_search('bs_a206', $header)]) ?? null,
                    'a207' => $this->convertBool($row[array_search('bs_a207', $header)]) ?? null,
                    'a208' => $this->convertBool($row[array_search('bs_a208', $header)]) ?? null,
                    'a209' => $this->convertBool($row[array_search('bs_a209', $header)]) ?? null,
                    'a210' => $this->convertBool($row[array_search('bs_a210', $header)]) ?? null,
                    'a211' => $this->convertBool($row[array_search('bs_a211', $header)]) ?? null,
                    'a212' => $this->convertBool($row[array_search('bs_a212', $header)]) ?? null,
                    'a213' => $this->convertBool($row[array_search('bs_a213', $header)]) ?? null,
                    'a214' => $this->convertBool($row[array_search('bs_a214', $header)]) ?? null,
                    'a215' => $this->convertBool($row[array_search('bs_a215', $header)]) ?? null,
                    'a216' => $this->convertBool($row[array_search('bs_a216', $header)]) ?? null,
                    'a217' => $this->convertBool($row[array_search('bs_a217', $header)]) ?? null,
                    'a217a' => $this->convertBool($row[array_search('bs_a217a', $header)]) ?? null,
                    'a217b' => $this->convertBool($row[array_search('bs_a217b', $header)]) ?? null,
                    'a217c' => $this->convertBool($row[array_search('bs_a217c', $header)]) ?? null,
                    'a218' => $this->convertBool($row[array_search('bs_a218', $header)]) ?? null,
                    'a219' => $this->convertBool($row[array_search('bs_a219', $header)]) ?? null,
                    'a220' => $this->convertBool($row[array_search('bs_a220a', $header)]) ?? null,
                    'a221' => $this->convertBool($row[array_search('bs_a220b', $header)]) ?? null,
                    'a222' => $this->convertBool($row[array_search('bs_a221', $header)]) ?? null,
                    'a223' => $this->convertBool($row[array_search('bs_a222', $header)]) ?? null,
                    'a224a' => $this->convertBool($row[array_search('bs_a223a', $header)]) ?? null,
                    'a224b' => $this->convertBool($row[array_search('bs_a223b', $header)]) ?? null,
                    'a225' => $this->convertBool($row[array_search('bs_a224', $header)]) ?? null,
                    'a225a' => $this->convertBool($row[array_search('bs_a224b', $header)]) ?? null,
                    'a226' => $this->convertBool($row[array_search('bs_a225', $header)]) ?? null,
                    'a226a' => $this->convertBool($row[array_search('bs_a225b', $header)]) ?? null,
                    'a227' => $this->convertBool($row[array_search('bs_a226', $header)]) ?? null,
                    'a228' => $this->convertBool($row[array_search('bs_a227a', $header)]) ?? null,
                    'a229' => $this->convertBool($row[array_search('bs_a227b', $header)]) ?? null,
                    'transport_icon' => ($row[array_search('bs_label', $header)]) ?? null,
                ];
                $existingCasNos[] = $casNo;
                if (count($batchData) >= $batchSize) {
                    Chemical::insert($batchData);
                    $batchData = [];
                }
            }
        }

        if (!empty($batchData)) {
            Chemical::insert($batchData);
        }

        fclose($errorCsv);
    }
    private function convertYN($value)
    {
        return $value === 'Y' ? 1 : ($value === 'N' ? 0 : $value);
    }

    private function convertBool($value)
    {
        $postion = strpos($value, '1');

        if ($postion !== false) {
            return $postion + 1;
        }
        return 0;
    }
}
