/**
 * @license
 * Cesium - https://github.com/CesiumGS/cesium
 * Version 1.97
 *
 * Copyright 2011-2022 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/CesiumGS/cesium/blob/main/LICENSE.md for full licensing details.
 */
define(["exports","./Transforms-0c3fa360","./Matrix2-276d97d2","./ComponentDatatype-7f6d9570","./defaultValue-a6eb9f34","./GeometryAttribute-54019f82","./GeometryAttributes-aff51037","./GeometryOffsetAttribute-102da468","./VertexFormat-31cdbccc"],(function(t,e,n,a,r,i,o,m,u){"use strict";const s=new n.Cartesian3;function y(t){const e=(t=r.defaultValue(t,r.defaultValue.EMPTY_OBJECT)).minimum,a=t.maximum,i=r.defaultValue(t.vertexFormat,u.VertexFormat.DEFAULT);this._minimum=n.Cartesian3.clone(e),this._maximum=n.Cartesian3.clone(a),this._vertexFormat=i,this._offsetAttribute=t.offsetAttribute,this._workerName="createBoxGeometry"}y.fromDimensions=function(t){const e=(t=r.defaultValue(t,r.defaultValue.EMPTY_OBJECT)).dimensions,a=n.Cartesian3.multiplyByScalar(e,.5,new n.Cartesian3);return new y({minimum:n.Cartesian3.negate(a,new n.Cartesian3),maximum:a,vertexFormat:t.vertexFormat,offsetAttribute:t.offsetAttribute})},y.fromAxisAlignedBoundingBox=function(t){return new y({minimum:t.minimum,maximum:t.maximum})},y.packedLength=2*n.Cartesian3.packedLength+u.VertexFormat.packedLength+1,y.pack=function(t,e,a){return a=r.defaultValue(a,0),n.Cartesian3.pack(t._minimum,e,a),n.Cartesian3.pack(t._maximum,e,a+n.Cartesian3.packedLength),u.VertexFormat.pack(t._vertexFormat,e,a+2*n.Cartesian3.packedLength),e[a+2*n.Cartesian3.packedLength+u.VertexFormat.packedLength]=r.defaultValue(t._offsetAttribute,-1),e};const c=new n.Cartesian3,f=new n.Cartesian3,p=new u.VertexFormat,x={minimum:c,maximum:f,vertexFormat:p,offsetAttribute:void 0};let l;y.unpack=function(t,e,a){e=r.defaultValue(e,0);const i=n.Cartesian3.unpack(t,e,c),o=n.Cartesian3.unpack(t,e+n.Cartesian3.packedLength,f),m=u.VertexFormat.unpack(t,e+2*n.Cartesian3.packedLength,p),s=t[e+2*n.Cartesian3.packedLength+u.VertexFormat.packedLength];return r.defined(a)?(a._minimum=n.Cartesian3.clone(i,a._minimum),a._maximum=n.Cartesian3.clone(o,a._maximum),a._vertexFormat=u.VertexFormat.clone(m,a._vertexFormat),a._offsetAttribute=-1===s?void 0:s,a):(x.offsetAttribute=-1===s?void 0:s,new y(x))},y.createGeometry=function(t){const u=t._minimum,y=t._maximum,c=t._vertexFormat;if(n.Cartesian3.equals(u,y))return;const f=new o.GeometryAttributes;let p,x;if(c.position&&(c.st||c.normal||c.tangent||c.bitangent)){if(c.position&&(x=new Float64Array(72),x[0]=u.x,x[1]=u.y,x[2]=y.z,x[3]=y.x,x[4]=u.y,x[5]=y.z,x[6]=y.x,x[7]=y.y,x[8]=y.z,x[9]=u.x,x[10]=y.y,x[11]=y.z,x[12]=u.x,x[13]=u.y,x[14]=u.z,x[15]=y.x,x[16]=u.y,x[17]=u.z,x[18]=y.x,x[19]=y.y,x[20]=u.z,x[21]=u.x,x[22]=y.y,x[23]=u.z,x[24]=y.x,x[25]=u.y,x[26]=u.z,x[27]=y.x,x[28]=y.y,x[29]=u.z,x[30]=y.x,x[31]=y.y,x[32]=y.z,x[33]=y.x,x[34]=u.y,x[35]=y.z,x[36]=u.x,x[37]=u.y,x[38]=u.z,x[39]=u.x,x[40]=y.y,x[41]=u.z,x[42]=u.x,x[43]=y.y,x[44]=y.z,x[45]=u.x,x[46]=u.y,x[47]=y.z,x[48]=u.x,x[49]=y.y,x[50]=u.z,x[51]=y.x,x[52]=y.y,x[53]=u.z,x[54]=y.x,x[55]=y.y,x[56]=y.z,x[57]=u.x,x[58]=y.y,x[59]=y.z,x[60]=u.x,x[61]=u.y,x[62]=u.z,x[63]=y.x,x[64]=u.y,x[65]=u.z,x[66]=y.x,x[67]=u.y,x[68]=y.z,x[69]=u.x,x[70]=u.y,x[71]=y.z,f.position=new i.GeometryAttribute({componentDatatype:a.ComponentDatatype.DOUBLE,componentsPerAttribute:3,values:x})),c.normal){const t=new Float32Array(72);t[0]=0,t[1]=0,t[2]=1,t[3]=0,t[4]=0,t[5]=1,t[6]=0,t[7]=0,t[8]=1,t[9]=0,t[10]=0,t[11]=1,t[12]=0,t[13]=0,t[14]=-1,t[15]=0,t[16]=0,t[17]=-1,t[18]=0,t[19]=0,t[20]=-1,t[21]=0,t[22]=0,t[23]=-1,t[24]=1,t[25]=0,t[26]=0,t[27]=1,t[28]=0,t[29]=0,t[30]=1,t[31]=0,t[32]=0,t[33]=1,t[34]=0,t[35]=0,t[36]=-1,t[37]=0,t[38]=0,t[39]=-1,t[40]=0,t[41]=0,t[42]=-1,t[43]=0,t[44]=0,t[45]=-1,t[46]=0,t[47]=0,t[48]=0,t[49]=1,t[50]=0,t[51]=0,t[52]=1,t[53]=0,t[54]=0,t[55]=1,t[56]=0,t[57]=0,t[58]=1,t[59]=0,t[60]=0,t[61]=-1,t[62]=0,t[63]=0,t[64]=-1,t[65]=0,t[66]=0,t[67]=-1,t[68]=0,t[69]=0,t[70]=-1,t[71]=0,f.normal=new i.GeometryAttribute({componentDatatype:a.ComponentDatatype.FLOAT,componentsPerAttribute:3,values:t})}if(c.st){const t=new Float32Array(48);t[0]=0,t[1]=0,t[2]=1,t[3]=0,t[4]=1,t[5]=1,t[6]=0,t[7]=1,t[8]=1,t[9]=0,t[10]=0,t[11]=0,t[12]=0,t[13]=1,t[14]=1,t[15]=1,t[16]=0,t[17]=0,t[18]=1,t[19]=0,t[20]=1,t[21]=1,t[22]=0,t[23]=1,t[24]=1,t[25]=0,t[26]=0,t[27]=0,t[28]=0,t[29]=1,t[30]=1,t[31]=1,t[32]=1,t[33]=0,t[34]=0,t[35]=0,t[36]=0,t[37]=1,t[38]=1,t[39]=1,t[40]=0,t[41]=0,t[42]=1,t[43]=0,t[44]=1,t[45]=1,t[46]=0,t[47]=1,f.st=new i.GeometryAttribute({componentDatatype:a.ComponentDatatype.FLOAT,componentsPerAttribute:2,values:t})}if(c.tangent){const t=new Float32Array(72);t[0]=1,t[1]=0,t[2]=0,t[3]=1,t[4]=0,t[5]=0,t[6]=1,t[7]=0,t[8]=0,t[9]=1,t[10]=0,t[11]=0,t[12]=-1,t[13]=0,t[14]=0,t[15]=-1,t[16]=0,t[17]=0,t[18]=-1,t[19]=0,t[20]=0,t[21]=-1,t[22]=0,t[23]=0,t[24]=0,t[25]=1,t[26]=0,t[27]=0,t[28]=1,t[29]=0,t[30]=0,t[31]=1,t[32]=0,t[33]=0,t[34]=1,t[35]=0,t[36]=0,t[37]=-1,t[38]=0,t[39]=0,t[40]=-1,t[41]=0,t[42]=0,t[43]=-1,t[44]=0,t[45]=0,t[46]=-1,t[47]=0,t[48]=-1,t[49]=0,t[50]=0,t[51]=-1,t[52]=0,t[53]=0,t[54]=-1,t[55]=0,t[56]=0,t[57]=-1,t[58]=0,t[59]=0,t[60]=1,t[61]=0,t[62]=0,t[63]=1,t[64]=0,t[65]=0,t[66]=1,t[67]=0,t[68]=0,t[69]=1,t[70]=0,t[71]=0,f.tangent=new i.GeometryAttribute({componentDatatype:a.ComponentDatatype.FLOAT,componentsPerAttribute:3,values:t})}if(c.bitangent){const t=new Float32Array(72);t[0]=0,t[1]=1,t[2]=0,t[3]=0,t[4]=1,t[5]=0,t[6]=0,t[7]=1,t[8]=0,t[9]=0,t[10]=1,t[11]=0,t[12]=0,t[13]=1,t[14]=0,t[15]=0,t[16]=1,t[17]=0,t[18]=0,t[19]=1,t[20]=0,t[21]=0,t[22]=1,t[23]=0,t[24]=0,t[25]=0,t[26]=1,t[27]=0,t[28]=0,t[29]=1,t[30]=0,t[31]=0,t[32]=1,t[33]=0,t[34]=0,t[35]=1,t[36]=0,t[37]=0,t[38]=1,t[39]=0,t[40]=0,t[41]=1,t[42]=0,t[43]=0,t[44]=1,t[45]=0,t[46]=0,t[47]=1,t[48]=0,t[49]=0,t[50]=1,t[51]=0,t[52]=0,t[53]=1,t[54]=0,t[55]=0,t[56]=1,t[57]=0,t[58]=0,t[59]=1,t[60]=0,t[61]=0,t[62]=1,t[63]=0,t[64]=0,t[65]=1,t[66]=0,t[67]=0,t[68]=1,t[69]=0,t[70]=0,t[71]=1,f.bitangent=new i.GeometryAttribute({componentDatatype:a.ComponentDatatype.FLOAT,componentsPerAttribute:3,values:t})}p=new Uint16Array(36),p[0]=0,p[1]=1,p[2]=2,p[3]=0,p[4]=2,p[5]=3,p[6]=6,p[7]=5,p[8]=4,p[9]=7,p[10]=6,p[11]=4,p[12]=8,p[13]=9,p[14]=10,p[15]=8,p[16]=10,p[17]=11,p[18]=14,p[19]=13,p[20]=12,p[21]=15,p[22]=14,p[23]=12,p[24]=18,p[25]=17,p[26]=16,p[27]=19,p[28]=18,p[29]=16,p[30]=20,p[31]=21,p[32]=22,p[33]=20,p[34]=22,p[35]=23}else x=new Float64Array(24),x[0]=u.x,x[1]=u.y,x[2]=u.z,x[3]=y.x,x[4]=u.y,x[5]=u.z,x[6]=y.x,x[7]=y.y,x[8]=u.z,x[9]=u.x,x[10]=y.y,x[11]=u.z,x[12]=u.x,x[13]=u.y,x[14]=y.z,x[15]=y.x,x[16]=u.y,x[17]=y.z,x[18]=y.x,x[19]=y.y,x[20]=y.z,x[21]=u.x,x[22]=y.y,x[23]=y.z,f.position=new i.GeometryAttribute({componentDatatype:a.ComponentDatatype.DOUBLE,componentsPerAttribute:3,values:x}),p=new Uint16Array(36),p[0]=4,p[1]=5,p[2]=6,p[3]=4,p[4]=6,p[5]=7,p[6]=1,p[7]=0,p[8]=3,p[9]=1,p[10]=3,p[11]=2,p[12]=1,p[13]=6,p[14]=5,p[15]=1,p[16]=2,p[17]=6,p[18]=2,p[19]=3,p[20]=7,p[21]=2,p[22]=7,p[23]=6,p[24]=3,p[25]=0,p[26]=4,p[27]=3,p[28]=4,p[29]=7,p[30]=0,p[31]=1,p[32]=5,p[33]=0,p[34]=5,p[35]=4;const l=n.Cartesian3.subtract(y,u,s),A=.5*n.Cartesian3.magnitude(l);if(r.defined(t._offsetAttribute)){const e=x.length,n=t._offsetAttribute===m.GeometryOffsetAttribute.NONE?0:1,r=new Uint8Array(e/3).fill(n);f.applyOffset=new i.GeometryAttribute({componentDatatype:a.ComponentDatatype.UNSIGNED_BYTE,componentsPerAttribute:1,values:r})}return new i.Geometry({attributes:f,indices:p,primitiveType:i.PrimitiveType.TRIANGLES,boundingSphere:new e.BoundingSphere(n.Cartesian3.ZERO,A),offsetAttribute:t._offsetAttribute})},y.getUnitBox=function(){return r.defined(l)||(l=y.createGeometry(y.fromDimensions({dimensions:new n.Cartesian3(1,1,1),vertexFormat:u.VertexFormat.POSITION_ONLY}))),l},t.BoxGeometry=y}));
