/**
 * @license
 * Cesium - https://github.com/CesiumGS/cesium
 * Version 1.97
 *
 * Copyright 2011-2022 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/CesiumGS/cesium/blob/main/LICENSE.md for full licensing details.
 */

var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __commonJS = (cb, mod2) => function __require() {
  return mod2 || (0, cb[__getOwnPropNames(cb)[0]])((mod2 = { exports: {} }).exports, mod2), mod2.exports;
};
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod2, isNodeMode, target) => (target = mod2 != null ? __create(__getProtoOf(mod2)) : {}, __copyProps(
  isNodeMode || !mod2 || !mod2.__esModule ? __defProp(target, "default", { value: mod2, enumerable: true }) : target,
  mod2
));
var __toCommonJS = (mod2) => __copyProps(__defProp({}, "__esModule", { value: true }), mod2);

// node_modules/mersenne-twister/src/mersenne-twister.js
var require_mersenne_twister = __commonJS({
  "node_modules/mersenne-twister/src/mersenne-twister.js"(exports2, module2) {
    var MersenneTwister4 = function(seed) {
      if (seed == void 0) {
        seed = new Date().getTime();
      }
      this.N = 624;
      this.M = 397;
      this.MATRIX_A = 2567483615;
      this.UPPER_MASK = 2147483648;
      this.LOWER_MASK = 2147483647;
      this.mt = new Array(this.N);
      this.mti = this.N + 1;
      if (seed.constructor == Array) {
        this.init_by_array(seed, seed.length);
      } else {
        this.init_seed(seed);
      }
    };
    MersenneTwister4.prototype.init_seed = function(s) {
      this.mt[0] = s >>> 0;
      for (this.mti = 1; this.mti < this.N; this.mti++) {
        var s = this.mt[this.mti - 1] ^ this.mt[this.mti - 1] >>> 30;
        this.mt[this.mti] = (((s & 4294901760) >>> 16) * 1812433253 << 16) + (s & 65535) * 1812433253 + this.mti;
        this.mt[this.mti] >>>= 0;
      }
    };
    MersenneTwister4.prototype.init_by_array = function(init_key, key_length) {
      var i, j, k;
      this.init_seed(19650218);
      i = 1;
      j = 0;
      k = this.N > key_length ? this.N : key_length;
      for (; k; k--) {
        var s = this.mt[i - 1] ^ this.mt[i - 1] >>> 30;
        this.mt[i] = (this.mt[i] ^ (((s & 4294901760) >>> 16) * 1664525 << 16) + (s & 65535) * 1664525) + init_key[j] + j;
        this.mt[i] >>>= 0;
        i++;
        j++;
        if (i >= this.N) {
          this.mt[0] = this.mt[this.N - 1];
          i = 1;
        }
        if (j >= key_length)
          j = 0;
      }
      for (k = this.N - 1; k; k--) {
        var s = this.mt[i - 1] ^ this.mt[i - 1] >>> 30;
        this.mt[i] = (this.mt[i] ^ (((s & 4294901760) >>> 16) * 1566083941 << 16) + (s & 65535) * 1566083941) - i;
        this.mt[i] >>>= 0;
        i++;
        if (i >= this.N) {
          this.mt[0] = this.mt[this.N - 1];
          i = 1;
        }
      }
      this.mt[0] = 2147483648;
    };
    MersenneTwister4.prototype.random_int = function() {
      var y;
      var mag01 = new Array(0, this.MATRIX_A);
      if (this.mti >= this.N) {
        var kk;
        if (this.mti == this.N + 1)
          this.init_seed(5489);
        for (kk = 0; kk < this.N - this.M; kk++) {
          y = this.mt[kk] & this.UPPER_MASK | this.mt[kk + 1] & this.LOWER_MASK;
          this.mt[kk] = this.mt[kk + this.M] ^ y >>> 1 ^ mag01[y & 1];
        }
        for (; kk < this.N - 1; kk++) {
          y = this.mt[kk] & this.UPPER_MASK | this.mt[kk + 1] & this.LOWER_MASK;
          this.mt[kk] = this.mt[kk + (this.M - this.N)] ^ y >>> 1 ^ mag01[y & 1];
        }
        y = this.mt[this.N - 1] & this.UPPER_MASK | this.mt[0] & this.LOWER_MASK;
        this.mt[this.N - 1] = this.mt[this.M - 1] ^ y >>> 1 ^ mag01[y & 1];
        this.mti = 0;
      }
      y = this.mt[this.mti++];
      y ^= y >>> 11;
      y ^= y << 7 & 2636928640;
      y ^= y << 15 & 4022730752;
      y ^= y >>> 18;
      return y >>> 0;
    };
    MersenneTwister4.prototype.random_int31 = function() {
      return this.random_int() >>> 1;
    };
    MersenneTwister4.prototype.random_incl = function() {
      return this.random_int() * (1 / 4294967295);
    };
    MersenneTwister4.prototype.random = function() {
      return this.random_int() * (1 / 4294967296);
    };
    MersenneTwister4.prototype.random_excl = function() {
      return (this.random_int() + 0.5) * (1 / 4294967296);
    };
    MersenneTwister4.prototype.random_long = function() {
      var a3 = this.random_int() >>> 5, b = this.random_int() >>> 6;
      return (a3 * 67108864 + b) * (1 / 9007199254740992);
    };
    module2.exports = MersenneTwister4;
  }
});

// node_modules/urijs/src/punycode.js
var require_punycode = __commonJS({
  "node_modules/urijs/src/punycode.js"(exports2, module2) {
    /*! https://mths.be/punycode v1.4.0 by @mathias */
    (function(root) {
      var freeExports = typeof exports2 == "object" && exports2 && !exports2.nodeType && exports2;
      var freeModule = typeof module2 == "object" && module2 && !module2.nodeType && module2;
      var freeGlobal = typeof global == "object" && global;
      if (freeGlobal.global === freeGlobal || freeGlobal.window === freeGlobal || freeGlobal.self === freeGlobal) {
        root = freeGlobal;
      }
      var punycode, maxInt = 2147483647, base = 36, tMin = 1, tMax = 26, skew = 38, damp = 700, initialBias = 72, initialN = 128, delimiter = "-", regexPunycode = /^xn--/, regexNonASCII = /[^\x20-\x7E]/, regexSeparators = /[\x2E\u3002\uFF0E\uFF61]/g, errors = {
        "overflow": "Overflow: input needs wider integers to process",
        "not-basic": "Illegal input >= 0x80 (not a basic code point)",
        "invalid-input": "Invalid input"
      }, baseMinusTMin = base - tMin, floor = Math.floor, stringFromCharCode = String.fromCharCode, key;
      function error(type) {
        throw new RangeError(errors[type]);
      }
      function map(array, fn) {
        var length3 = array.length;
        var result = [];
        while (length3--) {
          result[length3] = fn(array[length3]);
        }
        return result;
      }
      function mapDomain(string, fn) {
        var parts = string.split("@");
        var result = "";
        if (parts.length > 1) {
          result = parts[0] + "@";
          string = parts[1];
        }
        string = string.replace(regexSeparators, ".");
        var labels = string.split(".");
        var encoded = map(labels, fn).join(".");
        return result + encoded;
      }
      function ucs2decode(string) {
        var output = [], counter = 0, length3 = string.length, value, extra;
        while (counter < length3) {
          value = string.charCodeAt(counter++);
          if (value >= 55296 && value <= 56319 && counter < length3) {
            extra = string.charCodeAt(counter++);
            if ((extra & 64512) == 56320) {
              output.push(((value & 1023) << 10) + (extra & 1023) + 65536);
            } else {
              output.push(value);
              counter--;
            }
          } else {
            output.push(value);
          }
        }
        return output;
      }
      function ucs2encode(array) {
        return map(array, function(value) {
          var output = "";
          if (value > 65535) {
            value -= 65536;
            output += stringFromCharCode(value >>> 10 & 1023 | 55296);
            value = 56320 | value & 1023;
          }
          output += stringFromCharCode(value);
          return output;
        }).join("");
      }
      function basicToDigit(codePoint) {
        if (codePoint - 48 < 10) {
          return codePoint - 22;
        }
        if (codePoint - 65 < 26) {
          return codePoint - 65;
        }
        if (codePoint - 97 < 26) {
          return codePoint - 97;
        }
        return base;
      }
      function digitToBasic(digit, flag) {
        return digit + 22 + 75 * (digit < 26) - ((flag != 0) << 5);
      }
      function adapt(delta, numPoints, firstTime) {
        var k = 0;
        delta = firstTime ? floor(delta / damp) : delta >> 1;
        delta += floor(delta / numPoints);
        for (; delta > baseMinusTMin * tMax >> 1; k += base) {
          delta = floor(delta / baseMinusTMin);
        }
        return floor(k + (baseMinusTMin + 1) * delta / (delta + skew));
      }
      function decode(input) {
        var output = [], inputLength = input.length, out, i = 0, n = initialN, bias = initialBias, basic, j, index, oldi, w, k, digit, t, baseMinusT;
        basic = input.lastIndexOf(delimiter);
        if (basic < 0) {
          basic = 0;
        }
        for (j = 0; j < basic; ++j) {
          if (input.charCodeAt(j) >= 128) {
            error("not-basic");
          }
          output.push(input.charCodeAt(j));
        }
        for (index = basic > 0 ? basic + 1 : 0; index < inputLength; ) {
          for (oldi = i, w = 1, k = base; ; k += base) {
            if (index >= inputLength) {
              error("invalid-input");
            }
            digit = basicToDigit(input.charCodeAt(index++));
            if (digit >= base || digit > floor((maxInt - i) / w)) {
              error("overflow");
            }
            i += digit * w;
            t = k <= bias ? tMin : k >= bias + tMax ? tMax : k - bias;
            if (digit < t) {
              break;
            }
            baseMinusT = base - t;
            if (w > floor(maxInt / baseMinusT)) {
              error("overflow");
            }
            w *= baseMinusT;
          }
          out = output.length + 1;
          bias = adapt(i - oldi, out, oldi == 0);
          if (floor(i / out) > maxInt - n) {
            error("overflow");
          }
          n += floor(i / out);
          i %= out;
          output.splice(i++, 0, n);
        }
        return ucs2encode(output);
      }
      function encode(input) {
        var n, delta, handledCPCount, basicLength, bias, j, m, q, k, t, currentValue, output = [], inputLength, handledCPCountPlusOne, baseMinusT, qMinusT;
        input = ucs2decode(input);
        inputLength = input.length;
        n = initialN;
        delta = 0;
        bias = initialBias;
        for (j = 0; j < inputLength; ++j) {
          currentValue = input[j];
          if (currentValue < 128) {
            output.push(stringFromCharCode(currentValue));
          }
        }
        handledCPCount = basicLength = output.length;
        if (basicLength) {
          output.push(delimiter);
        }
        while (handledCPCount < inputLength) {
          for (m = maxInt, j = 0; j < inputLength; ++j) {
            currentValue = input[j];
            if (currentValue >= n && currentValue < m) {
              m = currentValue;
            }
          }
          handledCPCountPlusOne = handledCPCount + 1;
          if (m - n > floor((maxInt - delta) / handledCPCountPlusOne)) {
            error("overflow");
          }
          delta += (m - n) * handledCPCountPlusOne;
          n = m;
          for (j = 0; j < inputLength; ++j) {
            currentValue = input[j];
            if (currentValue < n && ++delta > maxInt) {
              error("overflow");
            }
            if (currentValue == n) {
              for (q = delta, k = base; ; k += base) {
                t = k <= bias ? tMin : k >= bias + tMax ? tMax : k - bias;
                if (q < t) {
                  break;
                }
                qMinusT = q - t;
                baseMinusT = base - t;
                output.push(
                  stringFromCharCode(digitToBasic(t + qMinusT % baseMinusT, 0))
                );
                q = floor(qMinusT / baseMinusT);
              }
              output.push(stringFromCharCode(digitToBasic(q, 0)));
              bias = adapt(delta, handledCPCountPlusOne, handledCPCount == basicLength);
              delta = 0;
              ++handledCPCount;
            }
          }
          ++delta;
          ++n;
        }
        return output.join("");
      }
      function toUnicode(input) {
        return mapDomain(input, function(string) {
          return regexPunycode.test(string) ? decode(string.slice(4).toLowerCase()) : string;
        });
      }
      function toASCII(input) {
        return mapDomain(input, function(string) {
          return regexNonASCII.test(string) ? "xn--" + encode(string) : string;
        });
      }
      punycode = {
        "version": "1.3.2",
        "ucs2": {
          "decode": ucs2decode,
          "encode": ucs2encode
        },
        "decode": decode,
        "encode": encode,
        "toASCII": toASCII,
        "toUnicode": toUnicode
      };
      if (typeof define == "function" && typeof define.amd == "object" && define.amd) {
        define("punycode", function() {
          return punycode;
        });
      } else if (freeExports && freeModule) {
        if (module2.exports == freeExports) {
          freeModule.exports = punycode;
        } else {
          for (key in punycode) {
            punycode.hasOwnProperty(key) && (freeExports[key] = punycode[key]);
          }
        }
      } else {
        root.punycode = punycode;
      }
    })(exports2);
  }
});

// node_modules/urijs/src/IPv6.js
var require_IPv6 = __commonJS({
  "node_modules/urijs/src/IPv6.js"(exports2, module2) {
    /*!
     * URI.js - Mutating URLs
     * IPv6 Support
     *
     * Version: 1.19.11
     *
     * Author: Rodney Rehm
     * Web: http://medialize.github.io/URI.js/
     *
     * Licensed under
     *   MIT License http://www.opensource.org/licenses/mit-license
     *
     */
    (function(root, factory) {
      "use strict";
      if (typeof module2 === "object" && module2.exports) {
        module2.exports = factory();
      } else if (typeof define === "function" && define.amd) {
        define(factory);
      } else {
        root.IPv6 = factory(root);
      }
    })(exports2, function(root) {
      "use strict";
      var _IPv6 = root && root.IPv6;
      function bestPresentation(address) {
        var _address = address.toLowerCase();
        var segments = _address.split(":");
        var length3 = segments.length;
        var total = 8;
        if (segments[0] === "" && segments[1] === "" && segments[2] === "") {
          segments.shift();
          segments.shift();
        } else if (segments[0] === "" && segments[1] === "") {
          segments.shift();
        } else if (segments[length3 - 1] === "" && segments[length3 - 2] === "") {
          segments.pop();
        }
        length3 = segments.length;
        if (segments[length3 - 1].indexOf(".") !== -1) {
          total = 7;
        }
        var pos;
        for (pos = 0; pos < length3; pos++) {
          if (segments[pos] === "") {
            break;
          }
        }
        if (pos < total) {
          segments.splice(pos, 1, "0000");
          while (segments.length < total) {
            segments.splice(pos, 0, "0000");
          }
        }
        var _segments;
        for (var i = 0; i < total; i++) {
          _segments = segments[i].split("");
          for (var j = 0; j < 3; j++) {
            if (_segments[0] === "0" && _segments.length > 1) {
              _segments.splice(0, 1);
            } else {
              break;
            }
          }
          segments[i] = _segments.join("");
        }
        var best = -1;
        var _best = 0;
        var _current = 0;
        var current = -1;
        var inzeroes = false;
        for (i = 0; i < total; i++) {
          if (inzeroes) {
            if (segments[i] === "0") {
              _current += 1;
            } else {
              inzeroes = false;
              if (_current > _best) {
                best = current;
                _best = _current;
              }
            }
          } else {
            if (segments[i] === "0") {
              inzeroes = true;
              current = i;
              _current = 1;
            }
          }
        }
        if (_current > _best) {
          best = current;
          _best = _current;
        }
        if (_best > 1) {
          segments.splice(best, _best, "");
        }
        length3 = segments.length;
        var result = "";
        if (segments[0] === "") {
          result = ":";
        }
        for (i = 0; i < length3; i++) {
          result += segments[i];
          if (i === length3 - 1) {
            break;
          }
          result += ":";
        }
        if (segments[length3 - 1] === "") {
          result += ":";
        }
        return result;
      }
      function noConflict() {
        if (root.IPv6 === this) {
          root.IPv6 = _IPv6;
        }
        return this;
      }
      return {
        best: bestPresentation,
        noConflict
      };
    });
  }
});

// node_modules/urijs/src/SecondLevelDomains.js
var require_SecondLevelDomains = __commonJS({
  "node_modules/urijs/src/SecondLevelDomains.js"(exports2, module2) {
    /*!
     * URI.js - Mutating URLs
     * Second Level Domain (SLD) Support
     *
     * Version: 1.19.11
     *
     * Author: Rodney Rehm
     * Web: http://medialize.github.io/URI.js/
     *
     * Licensed under
     *   MIT License http://www.opensource.org/licenses/mit-license
     *
     */
    (function(root, factory) {
      "use strict";
      if (typeof module2 === "object" && module2.exports) {
        module2.exports = factory();
      } else if (typeof define === "function" && define.amd) {
        define(factory);
      } else {
        root.SecondLevelDomains = factory(root);
      }
    })(exports2, function(root) {
      "use strict";
      var _SecondLevelDomains = root && root.SecondLevelDomains;
      var SLD = {
        list: {
          "ac": " com gov mil net org ",
          "ae": " ac co gov mil name net org pro sch ",
          "af": " com edu gov net org ",
          "al": " com edu gov mil net org ",
          "ao": " co ed gv it og pb ",
          "ar": " com edu gob gov int mil net org tur ",
          "at": " ac co gv or ",
          "au": " asn com csiro edu gov id net org ",
          "ba": " co com edu gov mil net org rs unbi unmo unsa untz unze ",
          "bb": " biz co com edu gov info net org store tv ",
          "bh": " biz cc com edu gov info net org ",
          "bn": " com edu gov net org ",
          "bo": " com edu gob gov int mil net org tv ",
          "br": " adm adv agr am arq art ato b bio blog bmd cim cng cnt com coop ecn edu eng esp etc eti far flog fm fnd fot fst g12 ggf gov imb ind inf jor jus lel mat med mil mus net nom not ntr odo org ppg pro psc psi qsl rec slg srv tmp trd tur tv vet vlog wiki zlg ",
          "bs": " com edu gov net org ",
          "bz": " du et om ov rg ",
          "ca": " ab bc mb nb nf nl ns nt nu on pe qc sk yk ",
          "ck": " biz co edu gen gov info net org ",
          "cn": " ac ah bj com cq edu fj gd gov gs gx gz ha hb he hi hl hn jl js jx ln mil net nm nx org qh sc sd sh sn sx tj tw xj xz yn zj ",
          "co": " com edu gov mil net nom org ",
          "cr": " ac c co ed fi go or sa ",
          "cy": " ac biz com ekloges gov ltd name net org parliament press pro tm ",
          "do": " art com edu gob gov mil net org sld web ",
          "dz": " art asso com edu gov net org pol ",
          "ec": " com edu fin gov info med mil net org pro ",
          "eg": " com edu eun gov mil name net org sci ",
          "er": " com edu gov ind mil net org rochest w ",
          "es": " com edu gob nom org ",
          "et": " biz com edu gov info name net org ",
          "fj": " ac biz com info mil name net org pro ",
          "fk": " ac co gov net nom org ",
          "fr": " asso com f gouv nom prd presse tm ",
          "gg": " co net org ",
          "gh": " com edu gov mil org ",
          "gn": " ac com gov net org ",
          "gr": " com edu gov mil net org ",
          "gt": " com edu gob ind mil net org ",
          "gu": " com edu gov net org ",
          "hk": " com edu gov idv net org ",
          "hu": " 2000 agrar bolt casino city co erotica erotika film forum games hotel info ingatlan jogasz konyvelo lakas media news org priv reklam sex shop sport suli szex tm tozsde utazas video ",
          "id": " ac co go mil net or sch web ",
          "il": " ac co gov idf k12 muni net org ",
          "in": " ac co edu ernet firm gen gov i ind mil net nic org res ",
          "iq": " com edu gov i mil net org ",
          "ir": " ac co dnssec gov i id net org sch ",
          "it": " edu gov ",
          "je": " co net org ",
          "jo": " com edu gov mil name net org sch ",
          "jp": " ac ad co ed go gr lg ne or ",
          "ke": " ac co go info me mobi ne or sc ",
          "kh": " com edu gov mil net org per ",
          "ki": " biz com de edu gov info mob net org tel ",
          "km": " asso com coop edu gouv k medecin mil nom notaires pharmaciens presse tm veterinaire ",
          "kn": " edu gov net org ",
          "kr": " ac busan chungbuk chungnam co daegu daejeon es gangwon go gwangju gyeongbuk gyeonggi gyeongnam hs incheon jeju jeonbuk jeonnam k kg mil ms ne or pe re sc seoul ulsan ",
          "kw": " com edu gov net org ",
          "ky": " com edu gov net org ",
          "kz": " com edu gov mil net org ",
          "lb": " com edu gov net org ",
          "lk": " assn com edu gov grp hotel int ltd net ngo org sch soc web ",
          "lr": " com edu gov net org ",
          "lv": " asn com conf edu gov id mil net org ",
          "ly": " com edu gov id med net org plc sch ",
          "ma": " ac co gov m net org press ",
          "mc": " asso tm ",
          "me": " ac co edu gov its net org priv ",
          "mg": " com edu gov mil nom org prd tm ",
          "mk": " com edu gov inf name net org pro ",
          "ml": " com edu gov net org presse ",
          "mn": " edu gov org ",
          "mo": " com edu gov net org ",
          "mt": " com edu gov net org ",
          "mv": " aero biz com coop edu gov info int mil museum name net org pro ",
          "mw": " ac co com coop edu gov int museum net org ",
          "mx": " com edu gob net org ",
          "my": " com edu gov mil name net org sch ",
          "nf": " arts com firm info net other per rec store web ",
          "ng": " biz com edu gov mil mobi name net org sch ",
          "ni": " ac co com edu gob mil net nom org ",
          "np": " com edu gov mil net org ",
          "nr": " biz com edu gov info net org ",
          "om": " ac biz co com edu gov med mil museum net org pro sch ",
          "pe": " com edu gob mil net nom org sld ",
          "ph": " com edu gov i mil net ngo org ",
          "pk": " biz com edu fam gob gok gon gop gos gov net org web ",
          "pl": " art bialystok biz com edu gda gdansk gorzow gov info katowice krakow lodz lublin mil net ngo olsztyn org poznan pwr radom slupsk szczecin torun warszawa waw wroc wroclaw zgora ",
          "pr": " ac biz com edu est gov info isla name net org pro prof ",
          "ps": " com edu gov net org plo sec ",
          "pw": " belau co ed go ne or ",
          "ro": " arts com firm info nom nt org rec store tm www ",
          "rs": " ac co edu gov in org ",
          "sb": " com edu gov net org ",
          "sc": " com edu gov net org ",
          "sh": " co com edu gov net nom org ",
          "sl": " com edu gov net org ",
          "st": " co com consulado edu embaixada gov mil net org principe saotome store ",
          "sv": " com edu gob org red ",
          "sz": " ac co org ",
          "tr": " av bbs bel biz com dr edu gen gov info k12 name net org pol tel tsk tv web ",
          "tt": " aero biz cat co com coop edu gov info int jobs mil mobi museum name net org pro tel travel ",
          "tw": " club com ebiz edu game gov idv mil net org ",
          "mu": " ac co com gov net or org ",
          "mz": " ac co edu gov org ",
          "na": " co com ",
          "nz": " ac co cri geek gen govt health iwi maori mil net org parliament school ",
          "pa": " abo ac com edu gob ing med net nom org sld ",
          "pt": " com edu gov int net nome org publ ",
          "py": " com edu gov mil net org ",
          "qa": " com edu gov mil net org ",
          "re": " asso com nom ",
          "ru": " ac adygeya altai amur arkhangelsk astrakhan bashkiria belgorod bir bryansk buryatia cbg chel chelyabinsk chita chukotka chuvashia com dagestan e-burg edu gov grozny int irkutsk ivanovo izhevsk jar joshkar-ola kalmykia kaluga kamchatka karelia kazan kchr kemerovo khabarovsk khakassia khv kirov koenig komi kostroma kranoyarsk kuban kurgan kursk lipetsk magadan mari mari-el marine mil mordovia mosreg msk murmansk nalchik net nnov nov novosibirsk nsk omsk orenburg org oryol penza perm pp pskov ptz rnd ryazan sakhalin samara saratov simbirsk smolensk spb stavropol stv surgut tambov tatarstan tom tomsk tsaritsyn tsk tula tuva tver tyumen udm udmurtia ulan-ude vladikavkaz vladimir vladivostok volgograd vologda voronezh vrn vyatka yakutia yamal yekaterinburg yuzhno-sakhalinsk ",
          "rw": " ac co com edu gouv gov int mil net ",
          "sa": " com edu gov med net org pub sch ",
          "sd": " com edu gov info med net org tv ",
          "se": " a ac b bd c d e f g h i k l m n o org p parti pp press r s t tm u w x y z ",
          "sg": " com edu gov idn net org per ",
          "sn": " art com edu gouv org perso univ ",
          "sy": " com edu gov mil net news org ",
          "th": " ac co go in mi net or ",
          "tj": " ac biz co com edu go gov info int mil name net nic org test web ",
          "tn": " agrinet com defense edunet ens fin gov ind info intl mincom nat net org perso rnrt rns rnu tourism ",
          "tz": " ac co go ne or ",
          "ua": " biz cherkassy chernigov chernovtsy ck cn co com crimea cv dn dnepropetrovsk donetsk dp edu gov if in ivano-frankivsk kh kharkov kherson khmelnitskiy kiev kirovograd km kr ks kv lg lugansk lutsk lviv me mk net nikolaev od odessa org pl poltava pp rovno rv sebastopol sumy te ternopil uzhgorod vinnica vn zaporizhzhe zhitomir zp zt ",
          "ug": " ac co go ne or org sc ",
          "uk": " ac bl british-library co cym gov govt icnet jet lea ltd me mil mod national-library-scotland nel net nhs nic nls org orgn parliament plc police sch scot soc ",
          "us": " dni fed isa kids nsn ",
          "uy": " com edu gub mil net org ",
          "ve": " co com edu gob info mil net org web ",
          "vi": " co com k12 net org ",
          "vn": " ac biz com edu gov health info int name net org pro ",
          "ye": " co com gov ltd me net org plc ",
          "yu": " ac co edu gov org ",
          "za": " ac agric alt bourse city co cybernet db edu gov grondar iaccess imt inca landesign law mil net ngo nis nom olivetti org pix school tm web ",
          "zm": " ac co com edu gov net org sch ",
          "com": "ar br cn de eu gb gr hu jpn kr no qc ru sa se uk us uy za ",
          "net": "gb jp se uk ",
          "org": "ae",
          "de": "com "
        },
        has: function(domain) {
          var tldOffset = domain.lastIndexOf(".");
          if (tldOffset <= 0 || tldOffset >= domain.length - 1) {
            return false;
          }
          var sldOffset = domain.lastIndexOf(".", tldOffset - 1);
          if (sldOffset <= 0 || sldOffset >= tldOffset - 1) {
            return false;
          }
          var sldList = SLD.list[domain.slice(tldOffset + 1)];
          if (!sldList) {
            return false;
          }
          return sldList.indexOf(" " + domain.slice(sldOffset + 1, tldOffset) + " ") >= 0;
        },
        is: function(domain) {
          var tldOffset = domain.lastIndexOf(".");
          if (tldOffset <= 0 || tldOffset >= domain.length - 1) {
            return false;
          }
          var sldOffset = domain.lastIndexOf(".", tldOffset - 1);
          if (sldOffset >= 0) {
            return false;
          }
          var sldList = SLD.list[domain.slice(tldOffset + 1)];
          if (!sldList) {
            return false;
          }
          return sldList.indexOf(" " + domain.slice(0, tldOffset) + " ") >= 0;
        },
        get: function(domain) {
          var tldOffset = domain.lastIndexOf(".");
          if (tldOffset <= 0 || tldOffset >= domain.length - 1) {
            return null;
          }
          var sldOffset = domain.lastIndexOf(".", tldOffset - 1);
          if (sldOffset <= 0 || sldOffset >= tldOffset - 1) {
            return null;
          }
          var sldList = SLD.list[domain.slice(tldOffset + 1)];
          if (!sldList) {
            return null;
          }
          if (sldList.indexOf(" " + domain.slice(sldOffset + 1, tldOffset) + " ") < 0) {
            return null;
          }
          return domain.slice(sldOffset + 1);
        },
        noConflict: function() {
          if (root.SecondLevelDomains === this) {
            root.SecondLevelDomains = _SecondLevelDomains;
          }
          return this;
        }
      };
      return SLD;
    });
  }
});

// node_modules/urijs/src/URI.js
var require_URI = __commonJS({
  "node_modules/urijs/src/URI.js"(exports2, module2) {
    /*!
     * URI.js - Mutating URLs
     *
     * Version: 1.19.11
     *
     * Author: Rodney Rehm
     * Web: http://medialize.github.io/URI.js/
     *
     * Licensed under
     *   MIT License http://www.opensource.org/licenses/mit-license
     *
     */
    (function(root, factory) {
      "use strict";
      if (typeof module2 === "object" && module2.exports) {
        module2.exports = factory(require_punycode(), require_IPv6(), require_SecondLevelDomains());
      } else if (typeof define === "function" && define.amd) {
        define(["./punycode", "./IPv6", "./SecondLevelDomains"], factory);
      } else {
        root.URI = factory(root.punycode, root.IPv6, root.SecondLevelDomains, root);
      }
    })(exports2, function(punycode, IPv6, SLD, root) {
      "use strict";
      var _URI = root && root.URI;
      function URI(url2, base) {
        var _urlSupplied = arguments.length >= 1;
        var _baseSupplied = arguments.length >= 2;
        if (!(this instanceof URI)) {
          if (_urlSupplied) {
            if (_baseSupplied) {
              return new URI(url2, base);
            }
            return new URI(url2);
          }
          return new URI();
        }
        if (url2 === void 0) {
          if (_urlSupplied) {
            throw new TypeError("undefined is not a valid argument for URI");
          }
          if (typeof location !== "undefined") {
            url2 = location.href + "";
          } else {
            url2 = "";
          }
        }
        if (url2 === null) {
          if (_urlSupplied) {
            throw new TypeError("null is not a valid argument for URI");
          }
        }
        this.href(url2);
        if (base !== void 0) {
          return this.absoluteTo(base);
        }
        return this;
      }
      function isInteger(value) {
        return /^[0-9]+$/.test(value);
      }
      URI.version = "1.19.11";
      var p = URI.prototype;
      var hasOwn = Object.prototype.hasOwnProperty;
      function escapeRegEx(string) {
        return string.replace(/([.*+?^=!:${}()|[\]\/\\])/g, "\\$1");
      }
      function getType(value) {
        if (value === void 0) {
          return "Undefined";
        }
        return String(Object.prototype.toString.call(value)).slice(8, -1);
      }
      function isArray(obj) {
        return getType(obj) === "Array";
      }
      function filterArrayValues(data, value) {
        var lookup = {};
        var i, length3;
        if (getType(value) === "RegExp") {
          lookup = null;
        } else if (isArray(value)) {
          for (i = 0, length3 = value.length; i < length3; i++) {
            lookup[value[i]] = true;
          }
        } else {
          lookup[value] = true;
        }
        for (i = 0, length3 = data.length; i < length3; i++) {
          var _match = lookup && lookup[data[i]] !== void 0 || !lookup && value.test(data[i]);
          if (_match) {
            data.splice(i, 1);
            length3--;
            i--;
          }
        }
        return data;
      }
      function arrayContains(list, value) {
        var i, length3;
        if (isArray(value)) {
          for (i = 0, length3 = value.length; i < length3; i++) {
            if (!arrayContains(list, value[i])) {
              return false;
            }
          }
          return true;
        }
        var _type = getType(value);
        for (i = 0, length3 = list.length; i < length3; i++) {
          if (_type === "RegExp") {
            if (typeof list[i] === "string" && list[i].match(value)) {
              return true;
            }
          } else if (list[i] === value) {
            return true;
          }
        }
        return false;
      }
      function arraysEqual(one, two) {
        if (!isArray(one) || !isArray(two)) {
          return false;
        }
        if (one.length !== two.length) {
          return false;
        }
        one.sort();
        two.sort();
        for (var i = 0, l = one.length; i < l; i++) {
          if (one[i] !== two[i]) {
            return false;
          }
        }
        return true;
      }
      function trimSlashes(text) {
        var trim_expression = /^\/+|\/+$/g;
        return text.replace(trim_expression, "");
      }
      URI._parts = function() {
        return {
          protocol: null,
          username: null,
          password: null,
          hostname: null,
          urn: null,
          port: null,
          path: null,
          query: null,
          fragment: null,
          preventInvalidHostname: URI.preventInvalidHostname,
          duplicateQueryParameters: URI.duplicateQueryParameters,
          escapeQuerySpace: URI.escapeQuerySpace
        };
      };
      URI.preventInvalidHostname = false;
      URI.duplicateQueryParameters = false;
      URI.escapeQuerySpace = true;
      URI.protocol_expression = /^[a-z][a-z0-9.+-]*$/i;
      URI.idn_expression = /[^a-z0-9\._-]/i;
      URI.punycode_expression = /(xn--)/i;
      URI.ip4_expression = /^\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}$/;
      URI.ip6_expression = /^\s*((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:)))(%.+)?\s*$/;
      URI.find_uri_expression = /\b((?:[a-z][\w-]+:(?:\/{1,3}|[a-z0-9%])|www\d{0,3}[.]|[a-z0-9.\-]+[.][a-z]{2,4}\/)(?:[^\s()<>]+|\(([^\s()<>]+|(\([^\s()<>]+\)))*\))+(?:\(([^\s()<>]+|(\([^\s()<>]+\)))*\)|[^\s`!()\[\]{};:'".,<>?«»“”‘’]))/ig;
      URI.findUri = {
        start: /\b(?:([a-z][a-z0-9.+-]*:\/\/)|www\.)/gi,
        end: /[\s\r\n]|$/,
        trim: /[`!()\[\]{};:'".,<>?«»“”„‘’]+$/,
        parens: /(\([^\)]*\)|\[[^\]]*\]|\{[^}]*\}|<[^>]*>)/g
      };
      URI.leading_whitespace_expression = /^[\x00-\x20\u00a0\u1680\u2000-\u200a\u2028\u2029\u202f\u205f\u3000\ufeff]+/;
      URI.ascii_tab_whitespace = /[\u0009\u000A\u000D]+/g;
      URI.defaultPorts = {
        http: "80",
        https: "443",
        ftp: "21",
        gopher: "70",
        ws: "80",
        wss: "443"
      };
      URI.hostProtocols = [
        "http",
        "https"
      ];
      URI.invalid_hostname_characters = /[^a-zA-Z0-9\.\-:_]/;
      URI.domAttributes = {
        "a": "href",
        "blockquote": "cite",
        "link": "href",
        "base": "href",
        "script": "src",
        "form": "action",
        "img": "src",
        "area": "href",
        "iframe": "src",
        "embed": "src",
        "source": "src",
        "track": "src",
        "input": "src",
        "audio": "src",
        "video": "src"
      };
      URI.getDomAttribute = function(node) {
        if (!node || !node.nodeName) {
          return void 0;
        }
        var nodeName = node.nodeName.toLowerCase();
        if (nodeName === "input" && node.type !== "image") {
          return void 0;
        }
        return URI.domAttributes[nodeName];
      };
      function escapeForDumbFirefox36(value) {
        return escape(value);
      }
      function strictEncodeURIComponent(string) {
        return encodeURIComponent(string).replace(/[!'()*]/g, escapeForDumbFirefox36).replace(/\*/g, "%2A");
      }
      URI.encode = strictEncodeURIComponent;
      URI.decode = decodeURIComponent;
      URI.iso8859 = function() {
        URI.encode = escape;
        URI.decode = unescape;
      };
      URI.unicode = function() {
        URI.encode = strictEncodeURIComponent;
        URI.decode = decodeURIComponent;
      };
      URI.characters = {
        pathname: {
          encode: {
            expression: /%(24|26|2B|2C|3B|3D|3A|40)/ig,
            map: {
              "%24": "$",
              "%26": "&",
              "%2B": "+",
              "%2C": ",",
              "%3B": ";",
              "%3D": "=",
              "%3A": ":",
              "%40": "@"
            }
          },
          decode: {
            expression: /[\/\?#]/g,
            map: {
              "/": "%2F",
              "?": "%3F",
              "#": "%23"
            }
          }
        },
        reserved: {
          encode: {
            expression: /%(21|23|24|26|27|28|29|2A|2B|2C|2F|3A|3B|3D|3F|40|5B|5D)/ig,
            map: {
              "%3A": ":",
              "%2F": "/",
              "%3F": "?",
              "%23": "#",
              "%5B": "[",
              "%5D": "]",
              "%40": "@",
              "%21": "!",
              "%24": "$",
              "%26": "&",
              "%27": "'",
              "%28": "(",
              "%29": ")",
              "%2A": "*",
              "%2B": "+",
              "%2C": ",",
              "%3B": ";",
              "%3D": "="
            }
          }
        },
        urnpath: {
          encode: {
            expression: /%(21|24|27|28|29|2A|2B|2C|3B|3D|40)/ig,
            map: {
              "%21": "!",
              "%24": "$",
              "%27": "'",
              "%28": "(",
              "%29": ")",
              "%2A": "*",
              "%2B": "+",
              "%2C": ",",
              "%3B": ";",
              "%3D": "=",
              "%40": "@"
            }
          },
          decode: {
            expression: /[\/\?#:]/g,
            map: {
              "/": "%2F",
              "?": "%3F",
              "#": "%23",
              ":": "%3A"
            }
          }
        }
      };
      URI.encodeQuery = function(string, escapeQuerySpace) {
        var escaped = URI.encode(string + "");
        if (escapeQuerySpace === void 0) {
          escapeQuerySpace = URI.escapeQuerySpace;
        }
        return escapeQuerySpace ? escaped.replace(/%20/g, "+") : escaped;
      };
      URI.decodeQuery = function(string, escapeQuerySpace) {
        string += "";
        if (escapeQuerySpace === void 0) {
          escapeQuerySpace = URI.escapeQuerySpace;
        }
        try {
          return URI.decode(escapeQuerySpace ? string.replace(/\+/g, "%20") : string);
        } catch (e) {
          return string;
        }
      };
      var _parts = { "encode": "encode", "decode": "decode" };
      var _part;
      var generateAccessor = function(_group, _part2) {
        return function(string) {
          try {
            return URI[_part2](string + "").replace(URI.characters[_group][_part2].expression, function(c) {
              return URI.characters[_group][_part2].map[c];
            });
          } catch (e) {
            return string;
          }
        };
      };
      for (_part in _parts) {
        URI[_part + "PathSegment"] = generateAccessor("pathname", _parts[_part]);
        URI[_part + "UrnPathSegment"] = generateAccessor("urnpath", _parts[_part]);
      }
      var generateSegmentedPathFunction = function(_sep, _codingFuncName, _innerCodingFuncName) {
        return function(string) {
          var actualCodingFunc;
          if (!_innerCodingFuncName) {
            actualCodingFunc = URI[_codingFuncName];
          } else {
            actualCodingFunc = function(string2) {
              return URI[_codingFuncName](URI[_innerCodingFuncName](string2));
            };
          }
          var segments = (string + "").split(_sep);
          for (var i = 0, length3 = segments.length; i < length3; i++) {
            segments[i] = actualCodingFunc(segments[i]);
          }
          return segments.join(_sep);
        };
      };
      URI.decodePath = generateSegmentedPathFunction("/", "decodePathSegment");
      URI.decodeUrnPath = generateSegmentedPathFunction(":", "decodeUrnPathSegment");
      URI.recodePath = generateSegmentedPathFunction("/", "encodePathSegment", "decode");
      URI.recodeUrnPath = generateSegmentedPathFunction(":", "encodeUrnPathSegment", "decode");
      URI.encodeReserved = generateAccessor("reserved", "encode");
      URI.parse = function(string, parts) {
        var pos;
        if (!parts) {
          parts = {
            preventInvalidHostname: URI.preventInvalidHostname
          };
        }
        string = string.replace(URI.leading_whitespace_expression, "");
        string = string.replace(URI.ascii_tab_whitespace, "");
        pos = string.indexOf("#");
        if (pos > -1) {
          parts.fragment = string.substring(pos + 1) || null;
          string = string.substring(0, pos);
        }
        pos = string.indexOf("?");
        if (pos > -1) {
          parts.query = string.substring(pos + 1) || null;
          string = string.substring(0, pos);
        }
        string = string.replace(/^(https?|ftp|wss?)?:+[/\\]*/i, "$1://");
        string = string.replace(/^[/\\]{2,}/i, "//");
        if (string.substring(0, 2) === "//") {
          parts.protocol = null;
          string = string.substring(2);
          string = URI.parseAuthority(string, parts);
        } else {
          pos = string.indexOf(":");
          if (pos > -1) {
            parts.protocol = string.substring(0, pos) || null;
            if (parts.protocol && !parts.protocol.match(URI.protocol_expression)) {
              parts.protocol = void 0;
            } else if (string.substring(pos + 1, pos + 3).replace(/\\/g, "/") === "//") {
              string = string.substring(pos + 3);
              string = URI.parseAuthority(string, parts);
            } else {
              string = string.substring(pos + 1);
              parts.urn = true;
            }
          }
        }
        parts.path = string;
        return parts;
      };
      URI.parseHost = function(string, parts) {
        if (!string) {
          string = "";
        }
        string = string.replace(/\\/g, "/");
        var pos = string.indexOf("/");
        var bracketPos;
        var t;
        if (pos === -1) {
          pos = string.length;
        }
        if (string.charAt(0) === "[") {
          bracketPos = string.indexOf("]");
          parts.hostname = string.substring(1, bracketPos) || null;
          parts.port = string.substring(bracketPos + 2, pos) || null;
          if (parts.port === "/") {
            parts.port = null;
          }
        } else {
          var firstColon = string.indexOf(":");
          var firstSlash = string.indexOf("/");
          var nextColon = string.indexOf(":", firstColon + 1);
          if (nextColon !== -1 && (firstSlash === -1 || nextColon < firstSlash)) {
            parts.hostname = string.substring(0, pos) || null;
            parts.port = null;
          } else {
            t = string.substring(0, pos).split(":");
            parts.hostname = t[0] || null;
            parts.port = t[1] || null;
          }
        }
        if (parts.hostname && string.substring(pos).charAt(0) !== "/") {
          pos++;
          string = "/" + string;
        }
        if (parts.preventInvalidHostname) {
          URI.ensureValidHostname(parts.hostname, parts.protocol);
        }
        if (parts.port) {
          URI.ensureValidPort(parts.port);
        }
        return string.substring(pos) || "/";
      };
      URI.parseAuthority = function(string, parts) {
        string = URI.parseUserinfo(string, parts);
        return URI.parseHost(string, parts);
      };
      URI.parseUserinfo = function(string, parts) {
        var _string = string;
        var firstBackSlash = string.indexOf("\\");
        if (firstBackSlash !== -1) {
          string = string.replace(/\\/g, "/");
        }
        var firstSlash = string.indexOf("/");
        var pos = string.lastIndexOf("@", firstSlash > -1 ? firstSlash : string.length - 1);
        var t;
        if (pos > -1 && (firstSlash === -1 || pos < firstSlash)) {
          t = string.substring(0, pos).split(":");
          parts.username = t[0] ? URI.decode(t[0]) : null;
          t.shift();
          parts.password = t[0] ? URI.decode(t.join(":")) : null;
          string = _string.substring(pos + 1);
        } else {
          parts.username = null;
          parts.password = null;
        }
        return string;
      };
      URI.parseQuery = function(string, escapeQuerySpace) {
        if (!string) {
          return {};
        }
        string = string.replace(/&+/g, "&").replace(/^\?*&*|&+$/g, "");
        if (!string) {
          return {};
        }
        var items = {};
        var splits = string.split("&");
        var length3 = splits.length;
        var v7, name, value;
        for (var i = 0; i < length3; i++) {
          v7 = splits[i].split("=");
          name = URI.decodeQuery(v7.shift(), escapeQuerySpace);
          value = v7.length ? URI.decodeQuery(v7.join("="), escapeQuerySpace) : null;
          if (name === "__proto__") {
            continue;
          } else if (hasOwn.call(items, name)) {
            if (typeof items[name] === "string" || items[name] === null) {
              items[name] = [items[name]];
            }
            items[name].push(value);
          } else {
            items[name] = value;
          }
        }
        return items;
      };
      URI.build = function(parts) {
        var t = "";
        var requireAbsolutePath = false;
        if (parts.protocol) {
          t += parts.protocol + ":";
        }
        if (!parts.urn && (t || parts.hostname)) {
          t += "//";
          requireAbsolutePath = true;
        }
        t += URI.buildAuthority(parts) || "";
        if (typeof parts.path === "string") {
          if (parts.path.charAt(0) !== "/" && requireAbsolutePath) {
            t += "/";
          }
          t += parts.path;
        }
        if (typeof parts.query === "string" && parts.query) {
          t += "?" + parts.query;
        }
        if (typeof parts.fragment === "string" && parts.fragment) {
          t += "#" + parts.fragment;
        }
        return t;
      };
      URI.buildHost = function(parts) {
        var t = "";
        if (!parts.hostname) {
          return "";
        } else if (URI.ip6_expression.test(parts.hostname)) {
          t += "[" + parts.hostname + "]";
        } else {
          t += parts.hostname;
        }
        if (parts.port) {
          t += ":" + parts.port;
        }
        return t;
      };
      URI.buildAuthority = function(parts) {
        return URI.buildUserinfo(parts) + URI.buildHost(parts);
      };
      URI.buildUserinfo = function(parts) {
        var t = "";
        if (parts.username) {
          t += URI.encode(parts.username);
        }
        if (parts.password) {
          t += ":" + URI.encode(parts.password);
        }
        if (t) {
          t += "@";
        }
        return t;
      };
      URI.buildQuery = function(data, duplicateQueryParameters, escapeQuerySpace) {
        var t = "";
        var unique, key, i, length3;
        for (key in data) {
          if (key === "__proto__") {
            continue;
          } else if (hasOwn.call(data, key)) {
            if (isArray(data[key])) {
              unique = {};
              for (i = 0, length3 = data[key].length; i < length3; i++) {
                if (data[key][i] !== void 0 && unique[data[key][i] + ""] === void 0) {
                  t += "&" + URI.buildQueryParameter(key, data[key][i], escapeQuerySpace);
                  if (duplicateQueryParameters !== true) {
                    unique[data[key][i] + ""] = true;
                  }
                }
              }
            } else if (data[key] !== void 0) {
              t += "&" + URI.buildQueryParameter(key, data[key], escapeQuerySpace);
            }
          }
        }
        return t.substring(1);
      };
      URI.buildQueryParameter = function(name, value, escapeQuerySpace) {
        return URI.encodeQuery(name, escapeQuerySpace) + (value !== null ? "=" + URI.encodeQuery(value, escapeQuerySpace) : "");
      };
      URI.addQuery = function(data, name, value) {
        if (typeof name === "object") {
          for (var key in name) {
            if (hasOwn.call(name, key)) {
              URI.addQuery(data, key, name[key]);
            }
          }
        } else if (typeof name === "string") {
          if (data[name] === void 0) {
            data[name] = value;
            return;
          } else if (typeof data[name] === "string") {
            data[name] = [data[name]];
          }
          if (!isArray(value)) {
            value = [value];
          }
          data[name] = (data[name] || []).concat(value);
        } else {
          throw new TypeError("URI.addQuery() accepts an object, string as the name parameter");
        }
      };
      URI.setQuery = function(data, name, value) {
        if (typeof name === "object") {
          for (var key in name) {
            if (hasOwn.call(name, key)) {
              URI.setQuery(data, key, name[key]);
            }
          }
        } else if (typeof name === "string") {
          data[name] = value === void 0 ? null : value;
        } else {
          throw new TypeError("URI.setQuery() accepts an object, string as the name parameter");
        }
      };
      URI.removeQuery = function(data, name, value) {
        var i, length3, key;
        if (isArray(name)) {
          for (i = 0, length3 = name.length; i < length3; i++) {
            data[name[i]] = void 0;
          }
        } else if (getType(name) === "RegExp") {
          for (key in data) {
            if (name.test(key)) {
              data[key] = void 0;
            }
          }
        } else if (typeof name === "object") {
          for (key in name) {
            if (hasOwn.call(name, key)) {
              URI.removeQuery(data, key, name[key]);
            }
          }
        } else if (typeof name === "string") {
          if (value !== void 0) {
            if (getType(value) === "RegExp") {
              if (!isArray(data[name]) && value.test(data[name])) {
                data[name] = void 0;
              } else {
                data[name] = filterArrayValues(data[name], value);
              }
            } else if (data[name] === String(value) && (!isArray(value) || value.length === 1)) {
              data[name] = void 0;
            } else if (isArray(data[name])) {
              data[name] = filterArrayValues(data[name], value);
            }
          } else {
            data[name] = void 0;
          }
        } else {
          throw new TypeError("URI.removeQuery() accepts an object, string, RegExp as the first parameter");
        }
      };
      URI.hasQuery = function(data, name, value, withinArray) {
        switch (getType(name)) {
          case "String":
            break;
          case "RegExp":
            for (var key in data) {
              if (hasOwn.call(data, key)) {
                if (name.test(key) && (value === void 0 || URI.hasQuery(data, key, value))) {
                  return true;
                }
              }
            }
            return false;
          case "Object":
            for (var _key in name) {
              if (hasOwn.call(name, _key)) {
                if (!URI.hasQuery(data, _key, name[_key])) {
                  return false;
                }
              }
            }
            return true;
          default:
            throw new TypeError("URI.hasQuery() accepts a string, regular expression or object as the name parameter");
        }
        switch (getType(value)) {
          case "Undefined":
            return name in data;
          case "Boolean":
            var _booly = Boolean(isArray(data[name]) ? data[name].length : data[name]);
            return value === _booly;
          case "Function":
            return !!value(data[name], name, data);
          case "Array":
            if (!isArray(data[name])) {
              return false;
            }
            var op = withinArray ? arrayContains : arraysEqual;
            return op(data[name], value);
          case "RegExp":
            if (!isArray(data[name])) {
              return Boolean(data[name] && data[name].match(value));
            }
            if (!withinArray) {
              return false;
            }
            return arrayContains(data[name], value);
          case "Number":
            value = String(value);
          case "String":
            if (!isArray(data[name])) {
              return data[name] === value;
            }
            if (!withinArray) {
              return false;
            }
            return arrayContains(data[name], value);
          default:
            throw new TypeError("URI.hasQuery() accepts undefined, boolean, string, number, RegExp, Function as the value parameter");
        }
      };
      URI.joinPaths = function() {
        var input = [];
        var segments = [];
        var nonEmptySegments = 0;
        for (var i = 0; i < arguments.length; i++) {
          var url2 = new URI(arguments[i]);
          input.push(url2);
          var _segments = url2.segment();
          for (var s = 0; s < _segments.length; s++) {
            if (typeof _segments[s] === "string") {
              segments.push(_segments[s]);
            }
            if (_segments[s]) {
              nonEmptySegments++;
            }
          }
        }
        if (!segments.length || !nonEmptySegments) {
          return new URI("");
        }
        var uri = new URI("").segment(segments);
        if (input[0].path() === "" || input[0].path().slice(0, 1) === "/") {
          uri.path("/" + uri.path());
        }
        return uri.normalize();
      };
      URI.commonPath = function(one, two) {
        var length3 = Math.min(one.length, two.length);
        var pos;
        for (pos = 0; pos < length3; pos++) {
          if (one.charAt(pos) !== two.charAt(pos)) {
            pos--;
            break;
          }
        }
        if (pos < 1) {
          return one.charAt(0) === two.charAt(0) && one.charAt(0) === "/" ? "/" : "";
        }
        if (one.charAt(pos) !== "/" || two.charAt(pos) !== "/") {
          pos = one.substring(0, pos).lastIndexOf("/");
        }
        return one.substring(0, pos + 1);
      };
      URI.withinString = function(string, callback, options) {
        options || (options = {});
        var _start = options.start || URI.findUri.start;
        var _end = options.end || URI.findUri.end;
        var _trim = options.trim || URI.findUri.trim;
        var _parens = options.parens || URI.findUri.parens;
        var _attributeOpen = /[a-z0-9-]=["']?$/i;
        _start.lastIndex = 0;
        while (true) {
          var match = _start.exec(string);
          if (!match) {
            break;
          }
          var start = match.index;
          if (options.ignoreHtml) {
            var attributeOpen = string.slice(Math.max(start - 3, 0), start);
            if (attributeOpen && _attributeOpen.test(attributeOpen)) {
              continue;
            }
          }
          var end = start + string.slice(start).search(_end);
          var slice = string.slice(start, end);
          var parensEnd = -1;
          while (true) {
            var parensMatch = _parens.exec(slice);
            if (!parensMatch) {
              break;
            }
            var parensMatchEnd = parensMatch.index + parensMatch[0].length;
            parensEnd = Math.max(parensEnd, parensMatchEnd);
          }
          if (parensEnd > -1) {
            slice = slice.slice(0, parensEnd) + slice.slice(parensEnd).replace(_trim, "");
          } else {
            slice = slice.replace(_trim, "");
          }
          if (slice.length <= match[0].length) {
            continue;
          }
          if (options.ignore && options.ignore.test(slice)) {
            continue;
          }
          end = start + slice.length;
          var result = callback(slice, start, end, string);
          if (result === void 0) {
            _start.lastIndex = end;
            continue;
          }
          result = String(result);
          string = string.slice(0, start) + result + string.slice(end);
          _start.lastIndex = start + result.length;
        }
        _start.lastIndex = 0;
        return string;
      };
      URI.ensureValidHostname = function(v7, protocol) {
        var hasHostname = !!v7;
        var hasProtocol = !!protocol;
        var rejectEmptyHostname = false;
        if (hasProtocol) {
          rejectEmptyHostname = arrayContains(URI.hostProtocols, protocol);
        }
        if (rejectEmptyHostname && !hasHostname) {
          throw new TypeError("Hostname cannot be empty, if protocol is " + protocol);
        } else if (v7 && v7.match(URI.invalid_hostname_characters)) {
          if (!punycode) {
            throw new TypeError('Hostname "' + v7 + '" contains characters other than [A-Z0-9.-:_] and Punycode.js is not available');
          }
          if (punycode.toASCII(v7).match(URI.invalid_hostname_characters)) {
            throw new TypeError('Hostname "' + v7 + '" contains characters other than [A-Z0-9.-:_]');
          }
        }
      };
      URI.ensureValidPort = function(v7) {
        if (!v7) {
          return;
        }
        var port = Number(v7);
        if (isInteger(port) && port > 0 && port < 65536) {
          return;
        }
        throw new TypeError('Port "' + v7 + '" is not a valid port');
      };
      URI.noConflict = function(removeAll) {
        if (removeAll) {
          var unconflicted = {
            URI: this.noConflict()
          };
          if (root.URITemplate && typeof root.URITemplate.noConflict === "function") {
            unconflicted.URITemplate = root.URITemplate.noConflict();
          }
          if (root.IPv6 && typeof root.IPv6.noConflict === "function") {
            unconflicted.IPv6 = root.IPv6.noConflict();
          }
          if (root.SecondLevelDomains && typeof root.SecondLevelDomains.noConflict === "function") {
            unconflicted.SecondLevelDomains = root.SecondLevelDomains.noConflict();
          }
          return unconflicted;
        } else if (root.URI === this) {
          root.URI = _URI;
        }
        return this;
      };
      p.build = function(deferBuild) {
        if (deferBuild === true) {
          this._deferred_build = true;
        } else if (deferBuild === void 0 || this._deferred_build) {
          this._string = URI.build(this._parts);
          this._deferred_build = false;
        }
        return this;
      };
      p.clone = function() {
        return new URI(this);
      };
      p.valueOf = p.toString = function() {
        return this.build(false)._string;
      };
      function generateSimpleAccessor(_part2) {
        return function(v7, build) {
          if (v7 === void 0) {
            return this._parts[_part2] || "";
          } else {
            this._parts[_part2] = v7 || null;
            this.build(!build);
            return this;
          }
        };
      }
      function generatePrefixAccessor(_part2, _key) {
        return function(v7, build) {
          if (v7 === void 0) {
            return this._parts[_part2] || "";
          } else {
            if (v7 !== null) {
              v7 = v7 + "";
              if (v7.charAt(0) === _key) {
                v7 = v7.substring(1);
              }
            }
            this._parts[_part2] = v7;
            this.build(!build);
            return this;
          }
        };
      }
      p.protocol = generateSimpleAccessor("protocol");
      p.username = generateSimpleAccessor("username");
      p.password = generateSimpleAccessor("password");
      p.hostname = generateSimpleAccessor("hostname");
      p.port = generateSimpleAccessor("port");
      p.query = generatePrefixAccessor("query", "?");
      p.fragment = generatePrefixAccessor("fragment", "#");
      p.search = function(v7, build) {
        var t = this.query(v7, build);
        return typeof t === "string" && t.length ? "?" + t : t;
      };
      p.hash = function(v7, build) {
        var t = this.fragment(v7, build);
        return typeof t === "string" && t.length ? "#" + t : t;
      };
      p.pathname = function(v7, build) {
        if (v7 === void 0 || v7 === true) {
          var res = this._parts.path || (this._parts.hostname ? "/" : "");
          return v7 ? (this._parts.urn ? URI.decodeUrnPath : URI.decodePath)(res) : res;
        } else {
          if (this._parts.urn) {
            this._parts.path = v7 ? URI.recodeUrnPath(v7) : "";
          } else {
            this._parts.path = v7 ? URI.recodePath(v7) : "/";
          }
          this.build(!build);
          return this;
        }
      };
      p.path = p.pathname;
      p.href = function(href, build) {
        var key;
        if (href === void 0) {
          return this.toString();
        }
        this._string = "";
        this._parts = URI._parts();
        var _URI2 = href instanceof URI;
        var _object = typeof href === "object" && (href.hostname || href.path || href.pathname);
        if (href.nodeName) {
          var attribute = URI.getDomAttribute(href);
          href = href[attribute] || "";
          _object = false;
        }
        if (!_URI2 && _object && href.pathname !== void 0) {
          href = href.toString();
        }
        if (typeof href === "string" || href instanceof String) {
          this._parts = URI.parse(String(href), this._parts);
        } else if (_URI2 || _object) {
          var src = _URI2 ? href._parts : href;
          for (key in src) {
            if (key === "query") {
              continue;
            }
            if (hasOwn.call(this._parts, key)) {
              this._parts[key] = src[key];
            }
          }
          if (src.query) {
            this.query(src.query, false);
          }
        } else {
          throw new TypeError("invalid input");
        }
        this.build(!build);
        return this;
      };
      p.is = function(what) {
        var ip = false;
        var ip4 = false;
        var ip6 = false;
        var name = false;
        var sld = false;
        var idn = false;
        var punycode2 = false;
        var relative = !this._parts.urn;
        if (this._parts.hostname) {
          relative = false;
          ip4 = URI.ip4_expression.test(this._parts.hostname);
          ip6 = URI.ip6_expression.test(this._parts.hostname);
          ip = ip4 || ip6;
          name = !ip;
          sld = name && SLD && SLD.has(this._parts.hostname);
          idn = name && URI.idn_expression.test(this._parts.hostname);
          punycode2 = name && URI.punycode_expression.test(this._parts.hostname);
        }
        switch (what.toLowerCase()) {
          case "relative":
            return relative;
          case "absolute":
            return !relative;
          case "domain":
          case "name":
            return name;
          case "sld":
            return sld;
          case "ip":
            return ip;
          case "ip4":
          case "ipv4":
          case "inet4":
            return ip4;
          case "ip6":
          case "ipv6":
          case "inet6":
            return ip6;
          case "idn":
            return idn;
          case "url":
            return !this._parts.urn;
          case "urn":
            return !!this._parts.urn;
          case "punycode":
            return punycode2;
        }
        return null;
      };
      var _protocol = p.protocol;
      var _port = p.port;
      var _hostname = p.hostname;
      p.protocol = function(v7, build) {
        if (v7) {
          v7 = v7.replace(/:(\/\/)?$/, "");
          if (!v7.match(URI.protocol_expression)) {
            throw new TypeError('Protocol "' + v7 + `" contains characters other than [A-Z0-9.+-] or doesn't start with [A-Z]`);
          }
        }
        return _protocol.call(this, v7, build);
      };
      p.scheme = p.protocol;
      p.port = function(v7, build) {
        if (this._parts.urn) {
          return v7 === void 0 ? "" : this;
        }
        if (v7 !== void 0) {
          if (v7 === 0) {
            v7 = null;
          }
          if (v7) {
            v7 += "";
            if (v7.charAt(0) === ":") {
              v7 = v7.substring(1);
            }
            URI.ensureValidPort(v7);
          }
        }
        return _port.call(this, v7, build);
      };
      p.hostname = function(v7, build) {
        if (this._parts.urn) {
          return v7 === void 0 ? "" : this;
        }
        if (v7 !== void 0) {
          var x = { preventInvalidHostname: this._parts.preventInvalidHostname };
          var res = URI.parseHost(v7, x);
          if (res !== "/") {
            throw new TypeError('Hostname "' + v7 + '" contains characters other than [A-Z0-9.-]');
          }
          v7 = x.hostname;
          if (this._parts.preventInvalidHostname) {
            URI.ensureValidHostname(v7, this._parts.protocol);
          }
        }
        return _hostname.call(this, v7, build);
      };
      p.origin = function(v7, build) {
        if (this._parts.urn) {
          return v7 === void 0 ? "" : this;
        }
        if (v7 === void 0) {
          var protocol = this.protocol();
          var authority = this.authority();
          if (!authority) {
            return "";
          }
          return (protocol ? protocol + "://" : "") + this.authority();
        } else {
          var origin = URI(v7);
          this.protocol(origin.protocol()).authority(origin.authority()).build(!build);
          return this;
        }
      };
      p.host = function(v7, build) {
        if (this._parts.urn) {
          return v7 === void 0 ? "" : this;
        }
        if (v7 === void 0) {
          return this._parts.hostname ? URI.buildHost(this._parts) : "";
        } else {
          var res = URI.parseHost(v7, this._parts);
          if (res !== "/") {
            throw new TypeError('Hostname "' + v7 + '" contains characters other than [A-Z0-9.-]');
          }
          this.build(!build);
          return this;
        }
      };
      p.authority = function(v7, build) {
        if (this._parts.urn) {
          return v7 === void 0 ? "" : this;
        }
        if (v7 === void 0) {
          return this._parts.hostname ? URI.buildAuthority(this._parts) : "";
        } else {
          var res = URI.parseAuthority(v7, this._parts);
          if (res !== "/") {
            throw new TypeError('Hostname "' + v7 + '" contains characters other than [A-Z0-9.-]');
          }
          this.build(!build);
          return this;
        }
      };
      p.userinfo = function(v7, build) {
        if (this._parts.urn) {
          return v7 === void 0 ? "" : this;
        }
        if (v7 === void 0) {
          var t = URI.buildUserinfo(this._parts);
          return t ? t.substring(0, t.length - 1) : t;
        } else {
          if (v7[v7.length - 1] !== "@") {
            v7 += "@";
          }
          URI.parseUserinfo(v7, this._parts);
          this.build(!build);
          return this;
        }
      };
      p.resource = function(v7, build) {
        var parts;
        if (v7 === void 0) {
          return this.path() + this.search() + this.hash();
        }
        parts = URI.parse(v7);
        this._parts.path = parts.path;
        this._parts.query = parts.query;
        this._parts.fragment = parts.fragment;
        this.build(!build);
        return this;
      };
      p.subdomain = function(v7, build) {
        if (this._parts.urn) {
          return v7 === void 0 ? "" : this;
        }
        if (v7 === void 0) {
          if (!this._parts.hostname || this.is("IP")) {
            return "";
          }
          var end = this._parts.hostname.length - this.domain().length - 1;
          return this._parts.hostname.substring(0, end) || "";
        } else {
          var e = this._parts.hostname.length - this.domain().length;
          var sub = this._parts.hostname.substring(0, e);
          var replace = new RegExp("^" + escapeRegEx(sub));
          if (v7 && v7.charAt(v7.length - 1) !== ".") {
            v7 += ".";
          }
          if (v7.indexOf(":") !== -1) {
            throw new TypeError("Domains cannot contain colons");
          }
          if (v7) {
            URI.ensureValidHostname(v7, this._parts.protocol);
          }
          this._parts.hostname = this._parts.hostname.replace(replace, v7);
          this.build(!build);
          return this;
        }
      };
      p.domain = function(v7, build) {
        if (this._parts.urn) {
          return v7 === void 0 ? "" : this;
        }
        if (typeof v7 === "boolean") {
          build = v7;
          v7 = void 0;
        }
        if (v7 === void 0) {
          if (!this._parts.hostname || this.is("IP")) {
            return "";
          }
          var t = this._parts.hostname.match(/\./g);
          if (t && t.length < 2) {
            return this._parts.hostname;
          }
          var end = this._parts.hostname.length - this.tld(build).length - 1;
          end = this._parts.hostname.lastIndexOf(".", end - 1) + 1;
          return this._parts.hostname.substring(end) || "";
        } else {
          if (!v7) {
            throw new TypeError("cannot set domain empty");
          }
          if (v7.indexOf(":") !== -1) {
            throw new TypeError("Domains cannot contain colons");
          }
          URI.ensureValidHostname(v7, this._parts.protocol);
          if (!this._parts.hostname || this.is("IP")) {
            this._parts.hostname = v7;
          } else {
            var replace = new RegExp(escapeRegEx(this.domain()) + "$");
            this._parts.hostname = this._parts.hostname.replace(replace, v7);
          }
          this.build(!build);
          return this;
        }
      };
      p.tld = function(v7, build) {
        if (this._parts.urn) {
          return v7 === void 0 ? "" : this;
        }
        if (typeof v7 === "boolean") {
          build = v7;
          v7 = void 0;
        }
        if (v7 === void 0) {
          if (!this._parts.hostname || this.is("IP")) {
            return "";
          }
          var pos = this._parts.hostname.lastIndexOf(".");
          var tld = this._parts.hostname.substring(pos + 1);
          if (build !== true && SLD && SLD.list[tld.toLowerCase()]) {
            return SLD.get(this._parts.hostname) || tld;
          }
          return tld;
        } else {
          var replace;
          if (!v7) {
            throw new TypeError("cannot set TLD empty");
          } else if (v7.match(/[^a-zA-Z0-9-]/)) {
            if (SLD && SLD.is(v7)) {
              replace = new RegExp(escapeRegEx(this.tld()) + "$");
              this._parts.hostname = this._parts.hostname.replace(replace, v7);
            } else {
              throw new TypeError('TLD "' + v7 + '" contains characters other than [A-Z0-9]');
            }
          } else if (!this._parts.hostname || this.is("IP")) {
            throw new ReferenceError("cannot set TLD on non-domain host");
          } else {
            replace = new RegExp(escapeRegEx(this.tld()) + "$");
            this._parts.hostname = this._parts.hostname.replace(replace, v7);
          }
          this.build(!build);
          return this;
        }
      };
      p.directory = function(v7, build) {
        if (this._parts.urn) {
          return v7 === void 0 ? "" : this;
        }
        if (v7 === void 0 || v7 === true) {
          if (!this._parts.path && !this._parts.hostname) {
            return "";
          }
          if (this._parts.path === "/") {
            return "/";
          }
          var end = this._parts.path.length - this.filename().length - 1;
          var res = this._parts.path.substring(0, end) || (this._parts.hostname ? "/" : "");
          return v7 ? URI.decodePath(res) : res;
        } else {
          var e = this._parts.path.length - this.filename().length;
          var directory = this._parts.path.substring(0, e);
          var replace = new RegExp("^" + escapeRegEx(directory));
          if (!this.is("relative")) {
            if (!v7) {
              v7 = "/";
            }
            if (v7.charAt(0) !== "/") {
              v7 = "/" + v7;
            }
          }
          if (v7 && v7.charAt(v7.length - 1) !== "/") {
            v7 += "/";
          }
          v7 = URI.recodePath(v7);
          this._parts.path = this._parts.path.replace(replace, v7);
          this.build(!build);
          return this;
        }
      };
      p.filename = function(v7, build) {
        if (this._parts.urn) {
          return v7 === void 0 ? "" : this;
        }
        if (typeof v7 !== "string") {
          if (!this._parts.path || this._parts.path === "/") {
            return "";
          }
          var pos = this._parts.path.lastIndexOf("/");
          var res = this._parts.path.substring(pos + 1);
          return v7 ? URI.decodePathSegment(res) : res;
        } else {
          var mutatedDirectory = false;
          if (v7.charAt(0) === "/") {
            v7 = v7.substring(1);
          }
          if (v7.match(/\.?\//)) {
            mutatedDirectory = true;
          }
          var replace = new RegExp(escapeRegEx(this.filename()) + "$");
          v7 = URI.recodePath(v7);
          this._parts.path = this._parts.path.replace(replace, v7);
          if (mutatedDirectory) {
            this.normalizePath(build);
          } else {
            this.build(!build);
          }
          return this;
        }
      };
      p.suffix = function(v7, build) {
        if (this._parts.urn) {
          return v7 === void 0 ? "" : this;
        }
        if (v7 === void 0 || v7 === true) {
          if (!this._parts.path || this._parts.path === "/") {
            return "";
          }
          var filename = this.filename();
          var pos = filename.lastIndexOf(".");
          var s, res;
          if (pos === -1) {
            return "";
          }
          s = filename.substring(pos + 1);
          res = /^[a-z0-9%]+$/i.test(s) ? s : "";
          return v7 ? URI.decodePathSegment(res) : res;
        } else {
          if (v7.charAt(0) === ".") {
            v7 = v7.substring(1);
          }
          var suffix = this.suffix();
          var replace;
          if (!suffix) {
            if (!v7) {
              return this;
            }
            this._parts.path += "." + URI.recodePath(v7);
          } else if (!v7) {
            replace = new RegExp(escapeRegEx("." + suffix) + "$");
          } else {
            replace = new RegExp(escapeRegEx(suffix) + "$");
          }
          if (replace) {
            v7 = URI.recodePath(v7);
            this._parts.path = this._parts.path.replace(replace, v7);
          }
          this.build(!build);
          return this;
        }
      };
      p.segment = function(segment, v7, build) {
        var separator = this._parts.urn ? ":" : "/";
        var path = this.path();
        var absolute = path.substring(0, 1) === "/";
        var segments = path.split(separator);
        if (segment !== void 0 && typeof segment !== "number") {
          build = v7;
          v7 = segment;
          segment = void 0;
        }
        if (segment !== void 0 && typeof segment !== "number") {
          throw new Error('Bad segment "' + segment + '", must be 0-based integer');
        }
        if (absolute) {
          segments.shift();
        }
        if (segment < 0) {
          segment = Math.max(segments.length + segment, 0);
        }
        if (v7 === void 0) {
          return segment === void 0 ? segments : segments[segment];
        } else if (segment === null || segments[segment] === void 0) {
          if (isArray(v7)) {
            segments = [];
            for (var i = 0, l = v7.length; i < l; i++) {
              if (!v7[i].length && (!segments.length || !segments[segments.length - 1].length)) {
                continue;
              }
              if (segments.length && !segments[segments.length - 1].length) {
                segments.pop();
              }
              segments.push(trimSlashes(v7[i]));
            }
          } else if (v7 || typeof v7 === "string") {
            v7 = trimSlashes(v7);
            if (segments[segments.length - 1] === "") {
              segments[segments.length - 1] = v7;
            } else {
              segments.push(v7);
            }
          }
        } else {
          if (v7) {
            segments[segment] = trimSlashes(v7);
          } else {
            segments.splice(segment, 1);
          }
        }
        if (absolute) {
          segments.unshift("");
        }
        return this.path(segments.join(separator), build);
      };
      p.segmentCoded = function(segment, v7, build) {
        var segments, i, l;
        if (typeof segment !== "number") {
          build = v7;
          v7 = segment;
          segment = void 0;
        }
        if (v7 === void 0) {
          segments = this.segment(segment, v7, build);
          if (!isArray(segments)) {
            segments = segments !== void 0 ? URI.decode(segments) : void 0;
          } else {
            for (i = 0, l = segments.length; i < l; i++) {
              segments[i] = URI.decode(segments[i]);
            }
          }
          return segments;
        }
        if (!isArray(v7)) {
          v7 = typeof v7 === "string" || v7 instanceof String ? URI.encode(v7) : v7;
        } else {
          for (i = 0, l = v7.length; i < l; i++) {
            v7[i] = URI.encode(v7[i]);
          }
        }
        return this.segment(segment, v7, build);
      };
      var q = p.query;
      p.query = function(v7, build) {
        if (v7 === true) {
          return URI.parseQuery(this._parts.query, this._parts.escapeQuerySpace);
        } else if (typeof v7 === "function") {
          var data = URI.parseQuery(this._parts.query, this._parts.escapeQuerySpace);
          var result = v7.call(this, data);
          this._parts.query = URI.buildQuery(result || data, this._parts.duplicateQueryParameters, this._parts.escapeQuerySpace);
          this.build(!build);
          return this;
        } else if (v7 !== void 0 && typeof v7 !== "string") {
          this._parts.query = URI.buildQuery(v7, this._parts.duplicateQueryParameters, this._parts.escapeQuerySpace);
          this.build(!build);
          return this;
        } else {
          return q.call(this, v7, build);
        }
      };
      p.setQuery = function(name, value, build) {
        var data = URI.parseQuery(this._parts.query, this._parts.escapeQuerySpace);
        if (typeof name === "string" || name instanceof String) {
          data[name] = value !== void 0 ? value : null;
        } else if (typeof name === "object") {
          for (var key in name) {
            if (hasOwn.call(name, key)) {
              data[key] = name[key];
            }
          }
        } else {
          throw new TypeError("URI.addQuery() accepts an object, string as the name parameter");
        }
        this._parts.query = URI.buildQuery(data, this._parts.duplicateQueryParameters, this._parts.escapeQuerySpace);
        if (typeof name !== "string") {
          build = value;
        }
        this.build(!build);
        return this;
      };
      p.addQuery = function(name, value, build) {
        var data = URI.parseQuery(this._parts.query, this._parts.escapeQuerySpace);
        URI.addQuery(data, name, value === void 0 ? null : value);
        this._parts.query = URI.buildQuery(data, this._parts.duplicateQueryParameters, this._parts.escapeQuerySpace);
        if (typeof name !== "string") {
          build = value;
        }
        this.build(!build);
        return this;
      };
      p.removeQuery = function(name, value, build) {
        var data = URI.parseQuery(this._parts.query, this._parts.escapeQuerySpace);
        URI.removeQuery(data, name, value);
        this._parts.query = URI.buildQuery(data, this._parts.duplicateQueryParameters, this._parts.escapeQuerySpace);
        if (typeof name !== "string") {
          build = value;
        }
        this.build(!build);
        return this;
      };
      p.hasQuery = function(name, value, withinArray) {
        var data = URI.parseQuery(this._parts.query, this._parts.escapeQuerySpace);
        return URI.hasQuery(data, name, value, withinArray);
      };
      p.setSearch = p.setQuery;
      p.addSearch = p.addQuery;
      p.removeSearch = p.removeQuery;
      p.hasSearch = p.hasQuery;
      p.normalize = function() {
        if (this._parts.urn) {
          return this.normalizeProtocol(false).normalizePath(false).normalizeQuery(false).normalizeFragment(false).build();
        }
        return this.normalizeProtocol(false).normalizeHostname(false).normalizePort(false).normalizePath(false).normalizeQuery(false).normalizeFragment(false).build();
      };
      p.normalizeProtocol = function(build) {
        if (typeof this._parts.protocol === "string") {
          this._parts.protocol = this._parts.protocol.toLowerCase();
          this.build(!build);
        }
        return this;
      };
      p.normalizeHostname = function(build) {
        if (this._parts.hostname) {
          if (this.is("IDN") && punycode) {
            this._parts.hostname = punycode.toASCII(this._parts.hostname);
          } else if (this.is("IPv6") && IPv6) {
            this._parts.hostname = IPv6.best(this._parts.hostname);
          }
          this._parts.hostname = this._parts.hostname.toLowerCase();
          this.build(!build);
        }
        return this;
      };
      p.normalizePort = function(build) {
        if (typeof this._parts.protocol === "string" && this._parts.port === URI.defaultPorts[this._parts.protocol]) {
          this._parts.port = null;
          this.build(!build);
        }
        return this;
      };
      p.normalizePath = function(build) {
        var _path = this._parts.path;
        if (!_path) {
          return this;
        }
        if (this._parts.urn) {
          this._parts.path = URI.recodeUrnPath(this._parts.path);
          this.build(!build);
          return this;
        }
        if (this._parts.path === "/") {
          return this;
        }
        _path = URI.recodePath(_path);
        var _was_relative;
        var _leadingParents = "";
        var _parent, _pos;
        if (_path.charAt(0) !== "/") {
          _was_relative = true;
          _path = "/" + _path;
        }
        if (_path.slice(-3) === "/.." || _path.slice(-2) === "/.") {
          _path += "/";
        }
        _path = _path.replace(/(\/(\.\/)+)|(\/\.$)/g, "/").replace(/\/{2,}/g, "/");
        if (_was_relative) {
          _leadingParents = _path.substring(1).match(/^(\.\.\/)+/) || "";
          if (_leadingParents) {
            _leadingParents = _leadingParents[0];
          }
        }
        while (true) {
          _parent = _path.search(/\/\.\.(\/|$)/);
          if (_parent === -1) {
            break;
          } else if (_parent === 0) {
            _path = _path.substring(3);
            continue;
          }
          _pos = _path.substring(0, _parent).lastIndexOf("/");
          if (_pos === -1) {
            _pos = _parent;
          }
          _path = _path.substring(0, _pos) + _path.substring(_parent + 3);
        }
        if (_was_relative && this.is("relative")) {
          _path = _leadingParents + _path.substring(1);
        }
        this._parts.path = _path;
        this.build(!build);
        return this;
      };
      p.normalizePathname = p.normalizePath;
      p.normalizeQuery = function(build) {
        if (typeof this._parts.query === "string") {
          if (!this._parts.query.length) {
            this._parts.query = null;
          } else {
            this.query(URI.parseQuery(this._parts.query, this._parts.escapeQuerySpace));
          }
          this.build(!build);
        }
        return this;
      };
      p.normalizeFragment = function(build) {
        if (!this._parts.fragment) {
          this._parts.fragment = null;
          this.build(!build);
        }
        return this;
      };
      p.normalizeSearch = p.normalizeQuery;
      p.normalizeHash = p.normalizeFragment;
      p.iso8859 = function() {
        var e = URI.encode;
        var d = URI.decode;
        URI.encode = escape;
        URI.decode = decodeURIComponent;
        try {
          this.normalize();
        } finally {
          URI.encode = e;
          URI.decode = d;
        }
        return this;
      };
      p.unicode = function() {
        var e = URI.encode;
        var d = URI.decode;
        URI.encode = strictEncodeURIComponent;
        URI.decode = unescape;
        try {
          this.normalize();
        } finally {
          URI.encode = e;
          URI.decode = d;
        }
        return this;
      };
      p.readable = function() {
        var uri = this.clone();
        uri.username("").password("").normalize();
        var t = "";
        if (uri._parts.protocol) {
          t += uri._parts.protocol + "://";
        }
        if (uri._parts.hostname) {
          if (uri.is("punycode") && punycode) {
            t += punycode.toUnicode(uri._parts.hostname);
            if (uri._parts.port) {
              t += ":" + uri._parts.port;
            }
          } else {
            t += uri.host();
          }
        }
        if (uri._parts.hostname && uri._parts.path && uri._parts.path.charAt(0) !== "/") {
          t += "/";
        }
        t += uri.path(true);
        if (uri._parts.query) {
          var q3 = "";
          for (var i = 0, qp = uri._parts.query.split("&"), l = qp.length; i < l; i++) {
            var kv = (qp[i] || "").split("=");
            q3 += "&" + URI.decodeQuery(kv[0], this._parts.escapeQuerySpace).replace(/&/g, "%26");
            if (kv[1] !== void 0) {
              q3 += "=" + URI.decodeQuery(kv[1], this._parts.escapeQuerySpace).replace(/&/g, "%26");
            }
          }
          t += "?" + q3.substring(1);
        }
        t += URI.decodeQuery(uri.hash(), true);
        return t;
      };
      p.absoluteTo = function(base) {
        var resolved = this.clone();
        var properties = ["protocol", "username", "password", "hostname", "port"];
        var basedir, i, p2;
        if (this._parts.urn) {
          throw new Error("URNs do not have any generally defined hierarchical components");
        }
        if (!(base instanceof URI)) {
          base = new URI(base);
        }
        if (resolved._parts.protocol) {
          return resolved;
        } else {
          resolved._parts.protocol = base._parts.protocol;
        }
        if (this._parts.hostname) {
          return resolved;
        }
        for (i = 0; p2 = properties[i]; i++) {
          resolved._parts[p2] = base._parts[p2];
        }
        if (!resolved._parts.path) {
          resolved._parts.path = base._parts.path;
          if (!resolved._parts.query) {
            resolved._parts.query = base._parts.query;
          }
        } else {
          if (resolved._parts.path.substring(-2) === "..") {
            resolved._parts.path += "/";
          }
          if (resolved.path().charAt(0) !== "/") {
            basedir = base.directory();
            basedir = basedir ? basedir : base.path().indexOf("/") === 0 ? "/" : "";
            resolved._parts.path = (basedir ? basedir + "/" : "") + resolved._parts.path;
            resolved.normalizePath();
          }
        }
        resolved.build();
        return resolved;
      };
      p.relativeTo = function(base) {
        var relative = this.clone().normalize();
        var relativeParts, baseParts, common, relativePath, basePath;
        if (relative._parts.urn) {
          throw new Error("URNs do not have any generally defined hierarchical components");
        }
        base = new URI(base).normalize();
        relativeParts = relative._parts;
        baseParts = base._parts;
        relativePath = relative.path();
        basePath = base.path();
        if (relativePath.charAt(0) !== "/") {
          throw new Error("URI is already relative");
        }
        if (basePath.charAt(0) !== "/") {
          throw new Error("Cannot calculate a URI relative to another relative URI");
        }
        if (relativeParts.protocol === baseParts.protocol) {
          relativeParts.protocol = null;
        }
        if (relativeParts.username !== baseParts.username || relativeParts.password !== baseParts.password) {
          return relative.build();
        }
        if (relativeParts.protocol !== null || relativeParts.username !== null || relativeParts.password !== null) {
          return relative.build();
        }
        if (relativeParts.hostname === baseParts.hostname && relativeParts.port === baseParts.port) {
          relativeParts.hostname = null;
          relativeParts.port = null;
        } else {
          return relative.build();
        }
        if (relativePath === basePath) {
          relativeParts.path = "";
          return relative.build();
        }
        common = URI.commonPath(relativePath, basePath);
        if (!common) {
          return relative.build();
        }
        var parents = baseParts.path.substring(common.length).replace(/[^\/]*$/, "").replace(/.*?\//g, "../");
        relativeParts.path = parents + relativeParts.path.substring(common.length) || "./";
        return relative.build();
      };
      p.equals = function(uri) {
        var one = this.clone();
        var two = new URI(uri);
        var one_map = {};
        var two_map = {};
        var checked = {};
        var one_query, two_query, key;
        one.normalize();
        two.normalize();
        if (one.toString() === two.toString()) {
          return true;
        }
        one_query = one.query();
        two_query = two.query();
        one.query("");
        two.query("");
        if (one.toString() !== two.toString()) {
          return false;
        }
        if (one_query.length !== two_query.length) {
          return false;
        }
        one_map = URI.parseQuery(one_query, this._parts.escapeQuerySpace);
        two_map = URI.parseQuery(two_query, this._parts.escapeQuerySpace);
        for (key in one_map) {
          if (hasOwn.call(one_map, key)) {
            if (!isArray(one_map[key])) {
              if (one_map[key] !== two_map[key]) {
                return false;
              }
            } else if (!arraysEqual(one_map[key], two_map[key])) {
              return false;
            }
            checked[key] = true;
          }
        }
        for (key in two_map) {
          if (hasOwn.call(two_map, key)) {
            if (!checked[key]) {
              return false;
            }
          }
        }
        return true;
      };
      p.preventInvalidHostname = function(v7) {
        this._parts.preventInvalidHostname = !!v7;
        return this;
      };
      p.duplicateQueryParameters = function(v7) {
        this._parts.duplicateQueryParameters = !!v7;
        return this;
      };
      p.escapeQuerySpace = function(v7) {
        this._parts.escapeQuerySpace = !!v7;
        return this;
      };
      return URI;
    });
  }
});

// node_modules/dompurify/dist/purify.cjs.js
var require_purify_cjs = __commonJS({
  "node_modules/dompurify/dist/purify.cjs.js"(exports2, module2) {
    "use strict";
    /*! @license DOMPurify 2.4.0 | (c) Cure53 and other contributors | Released under the Apache license 2.0 and Mozilla Public License 2.0 | github.com/cure53/DOMPurify/blob/2.4.0/LICENSE */
    function _typeof(obj) {
      "@babel/helpers - typeof";
      return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(obj2) {
        return typeof obj2;
      } : function(obj2) {
        return obj2 && "function" == typeof Symbol && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
      }, _typeof(obj);
    }
    function _setPrototypeOf(o, p) {
      _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf2(o2, p2) {
        o2.__proto__ = p2;
        return o2;
      };
      return _setPrototypeOf(o, p);
    }
    function _isNativeReflectConstruct() {
      if (typeof Reflect === "undefined" || !Reflect.construct)
        return false;
      if (Reflect.construct.sham)
        return false;
      if (typeof Proxy === "function")
        return true;
      try {
        Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function() {
        }));
        return true;
      } catch (e) {
        return false;
      }
    }
    function _construct(Parent, args, Class) {
      if (_isNativeReflectConstruct()) {
        _construct = Reflect.construct;
      } else {
        _construct = function _construct2(Parent2, args2, Class2) {
          var a3 = [null];
          a3.push.apply(a3, args2);
          var Constructor = Function.bind.apply(Parent2, a3);
          var instance = new Constructor();
          if (Class2)
            _setPrototypeOf(instance, Class2.prototype);
          return instance;
        };
      }
      return _construct.apply(null, arguments);
    }
    function _toConsumableArray(arr) {
      return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread();
    }
    function _arrayWithoutHoles(arr) {
      if (Array.isArray(arr))
        return _arrayLikeToArray(arr);
    }
    function _iterableToArray(iter) {
      if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null)
        return Array.from(iter);
    }
    function _unsupportedIterableToArray(o, minLen) {
      if (!o)
        return;
      if (typeof o === "string")
        return _arrayLikeToArray(o, minLen);
      var n = Object.prototype.toString.call(o).slice(8, -1);
      if (n === "Object" && o.constructor)
        n = o.constructor.name;
      if (n === "Map" || n === "Set")
        return Array.from(o);
      if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n))
        return _arrayLikeToArray(o, minLen);
    }
    function _arrayLikeToArray(arr, len) {
      if (len == null || len > arr.length)
        len = arr.length;
      for (var i = 0, arr2 = new Array(len); i < len; i++)
        arr2[i] = arr[i];
      return arr2;
    }
    function _nonIterableSpread() {
      throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
    }
    var hasOwnProperty = Object.hasOwnProperty;
    var setPrototypeOf = Object.setPrototypeOf;
    var isFrozen = Object.isFrozen;
    var getPrototypeOf = Object.getPrototypeOf;
    var getOwnPropertyDescriptor = Object.getOwnPropertyDescriptor;
    var freeze = Object.freeze;
    var seal = Object.seal;
    var create = Object.create;
    var _ref = typeof Reflect !== "undefined" && Reflect;
    var apply = _ref.apply;
    var construct = _ref.construct;
    if (!apply) {
      apply = function apply2(fun, thisValue, args) {
        return fun.apply(thisValue, args);
      };
    }
    if (!freeze) {
      freeze = function freeze2(x) {
        return x;
      };
    }
    if (!seal) {
      seal = function seal2(x) {
        return x;
      };
    }
    if (!construct) {
      construct = function construct2(Func, args) {
        return _construct(Func, _toConsumableArray(args));
      };
    }
    var arrayForEach = unapply(Array.prototype.forEach);
    var arrayPop = unapply(Array.prototype.pop);
    var arrayPush = unapply(Array.prototype.push);
    var stringToLowerCase = unapply(String.prototype.toLowerCase);
    var stringMatch = unapply(String.prototype.match);
    var stringReplace = unapply(String.prototype.replace);
    var stringIndexOf = unapply(String.prototype.indexOf);
    var stringTrim = unapply(String.prototype.trim);
    var regExpTest = unapply(RegExp.prototype.test);
    var typeErrorCreate = unconstruct(TypeError);
    function unapply(func) {
      return function(thisArg) {
        for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
          args[_key - 1] = arguments[_key];
        }
        return apply(func, thisArg, args);
      };
    }
    function unconstruct(func) {
      return function() {
        for (var _len2 = arguments.length, args = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
          args[_key2] = arguments[_key2];
        }
        return construct(func, args);
      };
    }
    function addToSet(set2, array, transformCaseFunc) {
      transformCaseFunc = transformCaseFunc ? transformCaseFunc : stringToLowerCase;
      if (setPrototypeOf) {
        setPrototypeOf(set2, null);
      }
      var l = array.length;
      while (l--) {
        var element = array[l];
        if (typeof element === "string") {
          var lcElement = transformCaseFunc(element);
          if (lcElement !== element) {
            if (!isFrozen(array)) {
              array[l] = lcElement;
            }
            element = lcElement;
          }
        }
        set2[element] = true;
      }
      return set2;
    }
    function clone2(object) {
      var newObject = create(null);
      var property;
      for (property in object) {
        if (apply(hasOwnProperty, object, [property])) {
          newObject[property] = object[property];
        }
      }
      return newObject;
    }
    function lookupGetter(object, prop) {
      while (object !== null) {
        var desc = getOwnPropertyDescriptor(object, prop);
        if (desc) {
          if (desc.get) {
            return unapply(desc.get);
          }
          if (typeof desc.value === "function") {
            return unapply(desc.value);
          }
        }
        object = getPrototypeOf(object);
      }
      function fallbackValue(element) {
        console.warn("fallback value for", element);
        return null;
      }
      return fallbackValue;
    }
    var html$1 = freeze(["a", "abbr", "acronym", "address", "area", "article", "aside", "audio", "b", "bdi", "bdo", "big", "blink", "blockquote", "body", "br", "button", "canvas", "caption", "center", "cite", "code", "col", "colgroup", "content", "data", "datalist", "dd", "decorator", "del", "details", "dfn", "dialog", "dir", "div", "dl", "dt", "element", "em", "fieldset", "figcaption", "figure", "font", "footer", "form", "h1", "h2", "h3", "h4", "h5", "h6", "head", "header", "hgroup", "hr", "html", "i", "img", "input", "ins", "kbd", "label", "legend", "li", "main", "map", "mark", "marquee", "menu", "menuitem", "meter", "nav", "nobr", "ol", "optgroup", "option", "output", "p", "picture", "pre", "progress", "q", "rp", "rt", "ruby", "s", "samp", "section", "select", "shadow", "small", "source", "spacer", "span", "strike", "strong", "style", "sub", "summary", "sup", "table", "tbody", "td", "template", "textarea", "tfoot", "th", "thead", "time", "tr", "track", "tt", "u", "ul", "var", "video", "wbr"]);
    var svg$1 = freeze(["svg", "a", "altglyph", "altglyphdef", "altglyphitem", "animatecolor", "animatemotion", "animatetransform", "circle", "clippath", "defs", "desc", "ellipse", "filter", "font", "g", "glyph", "glyphref", "hkern", "image", "line", "lineargradient", "marker", "mask", "metadata", "mpath", "path", "pattern", "polygon", "polyline", "radialgradient", "rect", "stop", "style", "switch", "symbol", "text", "textpath", "title", "tref", "tspan", "view", "vkern"]);
    var svgFilters = freeze(["feBlend", "feColorMatrix", "feComponentTransfer", "feComposite", "feConvolveMatrix", "feDiffuseLighting", "feDisplacementMap", "feDistantLight", "feFlood", "feFuncA", "feFuncB", "feFuncG", "feFuncR", "feGaussianBlur", "feImage", "feMerge", "feMergeNode", "feMorphology", "feOffset", "fePointLight", "feSpecularLighting", "feSpotLight", "feTile", "feTurbulence"]);
    var svgDisallowed = freeze(["animate", "color-profile", "cursor", "discard", "fedropshadow", "font-face", "font-face-format", "font-face-name", "font-face-src", "font-face-uri", "foreignobject", "hatch", "hatchpath", "mesh", "meshgradient", "meshpatch", "meshrow", "missing-glyph", "script", "set", "solidcolor", "unknown", "use"]);
    var mathMl$1 = freeze(["math", "menclose", "merror", "mfenced", "mfrac", "mglyph", "mi", "mlabeledtr", "mmultiscripts", "mn", "mo", "mover", "mpadded", "mphantom", "mroot", "mrow", "ms", "mspace", "msqrt", "mstyle", "msub", "msup", "msubsup", "mtable", "mtd", "mtext", "mtr", "munder", "munderover"]);
    var mathMlDisallowed = freeze(["maction", "maligngroup", "malignmark", "mlongdiv", "mscarries", "mscarry", "msgroup", "mstack", "msline", "msrow", "semantics", "annotation", "annotation-xml", "mprescripts", "none"]);
    var text = freeze(["#text"]);
    var html = freeze(["accept", "action", "align", "alt", "autocapitalize", "autocomplete", "autopictureinpicture", "autoplay", "background", "bgcolor", "border", "capture", "cellpadding", "cellspacing", "checked", "cite", "class", "clear", "color", "cols", "colspan", "controls", "controlslist", "coords", "crossorigin", "datetime", "decoding", "default", "dir", "disabled", "disablepictureinpicture", "disableremoteplayback", "download", "draggable", "enctype", "enterkeyhint", "face", "for", "headers", "height", "hidden", "high", "href", "hreflang", "id", "inputmode", "integrity", "ismap", "kind", "label", "lang", "list", "loading", "loop", "low", "max", "maxlength", "media", "method", "min", "minlength", "multiple", "muted", "name", "nonce", "noshade", "novalidate", "nowrap", "open", "optimum", "pattern", "placeholder", "playsinline", "poster", "preload", "pubdate", "radiogroup", "readonly", "rel", "required", "rev", "reversed", "role", "rows", "rowspan", "spellcheck", "scope", "selected", "shape", "size", "sizes", "span", "srclang", "start", "src", "srcset", "step", "style", "summary", "tabindex", "title", "translate", "type", "usemap", "valign", "value", "width", "xmlns", "slot"]);
    var svg = freeze(["accent-height", "accumulate", "additive", "alignment-baseline", "ascent", "attributename", "attributetype", "azimuth", "basefrequency", "baseline-shift", "begin", "bias", "by", "class", "clip", "clippathunits", "clip-path", "clip-rule", "color", "color-interpolation", "color-interpolation-filters", "color-profile", "color-rendering", "cx", "cy", "d", "dx", "dy", "diffuseconstant", "direction", "display", "divisor", "dur", "edgemode", "elevation", "end", "fill", "fill-opacity", "fill-rule", "filter", "filterunits", "flood-color", "flood-opacity", "font-family", "font-size", "font-size-adjust", "font-stretch", "font-style", "font-variant", "font-weight", "fx", "fy", "g1", "g2", "glyph-name", "glyphref", "gradientunits", "gradienttransform", "height", "href", "id", "image-rendering", "in", "in2", "k", "k1", "k2", "k3", "k4", "kerning", "keypoints", "keysplines", "keytimes", "lang", "lengthadjust", "letter-spacing", "kernelmatrix", "kernelunitlength", "lighting-color", "local", "marker-end", "marker-mid", "marker-start", "markerheight", "markerunits", "markerwidth", "maskcontentunits", "maskunits", "max", "mask", "media", "method", "mode", "min", "name", "numoctaves", "offset", "operator", "opacity", "order", "orient", "orientation", "origin", "overflow", "paint-order", "path", "pathlength", "patterncontentunits", "patterntransform", "patternunits", "points", "preservealpha", "preserveaspectratio", "primitiveunits", "r", "rx", "ry", "radius", "refx", "refy", "repeatcount", "repeatdur", "restart", "result", "rotate", "scale", "seed", "shape-rendering", "specularconstant", "specularexponent", "spreadmethod", "startoffset", "stddeviation", "stitchtiles", "stop-color", "stop-opacity", "stroke-dasharray", "stroke-dashoffset", "stroke-linecap", "stroke-linejoin", "stroke-miterlimit", "stroke-opacity", "stroke", "stroke-width", "style", "surfacescale", "systemlanguage", "tabindex", "targetx", "targety", "transform", "transform-origin", "text-anchor", "text-decoration", "text-rendering", "textlength", "type", "u1", "u2", "unicode", "values", "viewbox", "visibility", "version", "vert-adv-y", "vert-origin-x", "vert-origin-y", "width", "word-spacing", "wrap", "writing-mode", "xchannelselector", "ychannelselector", "x", "x1", "x2", "xmlns", "y", "y1", "y2", "z", "zoomandpan"]);
    var mathMl = freeze(["accent", "accentunder", "align", "bevelled", "close", "columnsalign", "columnlines", "columnspan", "denomalign", "depth", "dir", "display", "displaystyle", "encoding", "fence", "frame", "height", "href", "id", "largeop", "length", "linethickness", "lspace", "lquote", "mathbackground", "mathcolor", "mathsize", "mathvariant", "maxsize", "minsize", "movablelimits", "notation", "numalign", "open", "rowalign", "rowlines", "rowspacing", "rowspan", "rspace", "rquote", "scriptlevel", "scriptminsize", "scriptsizemultiplier", "selection", "separator", "separators", "stretchy", "subscriptshift", "supscriptshift", "symmetric", "voffset", "width", "xmlns"]);
    var xml = freeze(["xlink:href", "xml:id", "xlink:title", "xml:space", "xmlns:xlink"]);
    var MUSTACHE_EXPR = seal(/\{\{[\w\W]*|[\w\W]*\}\}/gm);
    var ERB_EXPR = seal(/<%[\w\W]*|[\w\W]*%>/gm);
    var DATA_ATTR = seal(/^data-[\-\w.\u00B7-\uFFFF]/);
    var ARIA_ATTR = seal(/^aria-[\-\w]+$/);
    var IS_ALLOWED_URI = seal(
      /^(?:(?:(?:f|ht)tps?|mailto|tel|callto|cid|xmpp):|[^a-z]|[a-z+.\-]+(?:[^a-z+.\-:]|$))/i
    );
    var IS_SCRIPT_OR_DATA = seal(/^(?:\w+script|data):/i);
    var ATTR_WHITESPACE = seal(
      /[\u0000-\u0020\u00A0\u1680\u180E\u2000-\u2029\u205F\u3000]/g
    );
    var DOCTYPE_NAME = seal(/^html$/i);
    var getGlobal = function getGlobal2() {
      return typeof window === "undefined" ? null : window;
    };
    var _createTrustedTypesPolicy = function _createTrustedTypesPolicy2(trustedTypes, document2) {
      if (_typeof(trustedTypes) !== "object" || typeof trustedTypes.createPolicy !== "function") {
        return null;
      }
      var suffix = null;
      var ATTR_NAME = "data-tt-policy-suffix";
      if (document2.currentScript && document2.currentScript.hasAttribute(ATTR_NAME)) {
        suffix = document2.currentScript.getAttribute(ATTR_NAME);
      }
      var policyName = "dompurify" + (suffix ? "#" + suffix : "");
      try {
        return trustedTypes.createPolicy(policyName, {
          createHTML: function createHTML(html2) {
            return html2;
          },
          createScriptURL: function createScriptURL(scriptUrl) {
            return scriptUrl;
          }
        });
      } catch (_) {
        console.warn("TrustedTypes policy " + policyName + " could not be created.");
        return null;
      }
    };
    function createDOMPurify() {
      var window2 = arguments.length > 0 && arguments[0] !== void 0 ? arguments[0] : getGlobal();
      var DOMPurify2 = function DOMPurify3(root) {
        return createDOMPurify(root);
      };
      DOMPurify2.version = "2.4.0";
      DOMPurify2.removed = [];
      if (!window2 || !window2.document || window2.document.nodeType !== 9) {
        DOMPurify2.isSupported = false;
        return DOMPurify2;
      }
      var originalDocument = window2.document;
      var document2 = window2.document;
      var DocumentFragment2 = window2.DocumentFragment, HTMLTemplateElement = window2.HTMLTemplateElement, Node6 = window2.Node, Element2 = window2.Element, NodeFilter = window2.NodeFilter, _window$NamedNodeMap = window2.NamedNodeMap, NamedNodeMap = _window$NamedNodeMap === void 0 ? window2.NamedNodeMap || window2.MozNamedAttrMap : _window$NamedNodeMap, HTMLFormElement = window2.HTMLFormElement, DOMParser2 = window2.DOMParser, trustedTypes = window2.trustedTypes;
      var ElementPrototype = Element2.prototype;
      var cloneNode = lookupGetter(ElementPrototype, "cloneNode");
      var getNextSibling = lookupGetter(ElementPrototype, "nextSibling");
      var getChildNodes = lookupGetter(ElementPrototype, "childNodes");
      var getParentNode = lookupGetter(ElementPrototype, "parentNode");
      if (typeof HTMLTemplateElement === "function") {
        var template = document2.createElement("template");
        if (template.content && template.content.ownerDocument) {
          document2 = template.content.ownerDocument;
        }
      }
      var trustedTypesPolicy = _createTrustedTypesPolicy(trustedTypes, originalDocument);
      var emptyHTML = trustedTypesPolicy ? trustedTypesPolicy.createHTML("") : "";
      var _document = document2, implementation4 = _document.implementation, createNodeIterator = _document.createNodeIterator, createDocumentFragment = _document.createDocumentFragment, getElementsByTagName = _document.getElementsByTagName;
      var importNode = originalDocument.importNode;
      var documentMode = {};
      try {
        documentMode = clone2(document2).documentMode ? document2.documentMode : {};
      } catch (_) {
      }
      var hooks = {};
      DOMPurify2.isSupported = typeof getParentNode === "function" && implementation4 && typeof implementation4.createHTMLDocument !== "undefined" && documentMode !== 9;
      var MUSTACHE_EXPR$1 = MUSTACHE_EXPR, ERB_EXPR$1 = ERB_EXPR, DATA_ATTR$1 = DATA_ATTR, ARIA_ATTR$1 = ARIA_ATTR, IS_SCRIPT_OR_DATA$1 = IS_SCRIPT_OR_DATA, ATTR_WHITESPACE$1 = ATTR_WHITESPACE;
      var IS_ALLOWED_URI$1 = IS_ALLOWED_URI;
      var ALLOWED_TAGS = null;
      var DEFAULT_ALLOWED_TAGS = addToSet({}, [].concat(_toConsumableArray(html$1), _toConsumableArray(svg$1), _toConsumableArray(svgFilters), _toConsumableArray(mathMl$1), _toConsumableArray(text)));
      var ALLOWED_ATTR = null;
      var DEFAULT_ALLOWED_ATTR = addToSet({}, [].concat(_toConsumableArray(html), _toConsumableArray(svg), _toConsumableArray(mathMl), _toConsumableArray(xml)));
      var CUSTOM_ELEMENT_HANDLING = Object.seal(Object.create(null, {
        tagNameCheck: {
          writable: true,
          configurable: false,
          enumerable: true,
          value: null
        },
        attributeNameCheck: {
          writable: true,
          configurable: false,
          enumerable: true,
          value: null
        },
        allowCustomizedBuiltInElements: {
          writable: true,
          configurable: false,
          enumerable: true,
          value: false
        }
      }));
      var FORBID_TAGS = null;
      var FORBID_ATTR = null;
      var ALLOW_ARIA_ATTR = true;
      var ALLOW_DATA_ATTR = true;
      var ALLOW_UNKNOWN_PROTOCOLS = false;
      var SAFE_FOR_TEMPLATES = false;
      var WHOLE_DOCUMENT = false;
      var SET_CONFIG = false;
      var FORCE_BODY = false;
      var RETURN_DOM = false;
      var RETURN_DOM_FRAGMENT = false;
      var RETURN_TRUSTED_TYPE = false;
      var SANITIZE_DOM = true;
      var SANITIZE_NAMED_PROPS = false;
      var SANITIZE_NAMED_PROPS_PREFIX = "user-content-";
      var KEEP_CONTENT = true;
      var IN_PLACE = false;
      var USE_PROFILES = {};
      var FORBID_CONTENTS = null;
      var DEFAULT_FORBID_CONTENTS = addToSet({}, ["annotation-xml", "audio", "colgroup", "desc", "foreignobject", "head", "iframe", "math", "mi", "mn", "mo", "ms", "mtext", "noembed", "noframes", "noscript", "plaintext", "script", "style", "svg", "template", "thead", "title", "video", "xmp"]);
      var DATA_URI_TAGS = null;
      var DEFAULT_DATA_URI_TAGS = addToSet({}, ["audio", "video", "img", "source", "image", "track"]);
      var URI_SAFE_ATTRIBUTES = null;
      var DEFAULT_URI_SAFE_ATTRIBUTES = addToSet({}, ["alt", "class", "for", "id", "label", "name", "pattern", "placeholder", "role", "summary", "title", "value", "style", "xmlns"]);
      var MATHML_NAMESPACE = "http://www.w3.org/1998/Math/MathML";
      var SVG_NAMESPACE = "http://www.w3.org/2000/svg";
      var HTML_NAMESPACE = "http://www.w3.org/1999/xhtml";
      var NAMESPACE = HTML_NAMESPACE;
      var IS_EMPTY_INPUT = false;
      var PARSER_MEDIA_TYPE;
      var SUPPORTED_PARSER_MEDIA_TYPES = ["application/xhtml+xml", "text/html"];
      var DEFAULT_PARSER_MEDIA_TYPE = "text/html";
      var transformCaseFunc;
      var CONFIG = null;
      var formElement = document2.createElement("form");
      var isRegexOrFunction = function isRegexOrFunction2(testValue) {
        return testValue instanceof RegExp || testValue instanceof Function;
      };
      var _parseConfig = function _parseConfig2(cfg) {
        if (CONFIG && CONFIG === cfg) {
          return;
        }
        if (!cfg || _typeof(cfg) !== "object") {
          cfg = {};
        }
        cfg = clone2(cfg);
        PARSER_MEDIA_TYPE = SUPPORTED_PARSER_MEDIA_TYPES.indexOf(cfg.PARSER_MEDIA_TYPE) === -1 ? PARSER_MEDIA_TYPE = DEFAULT_PARSER_MEDIA_TYPE : PARSER_MEDIA_TYPE = cfg.PARSER_MEDIA_TYPE;
        transformCaseFunc = PARSER_MEDIA_TYPE === "application/xhtml+xml" ? function(x) {
          return x;
        } : stringToLowerCase;
        ALLOWED_TAGS = "ALLOWED_TAGS" in cfg ? addToSet({}, cfg.ALLOWED_TAGS, transformCaseFunc) : DEFAULT_ALLOWED_TAGS;
        ALLOWED_ATTR = "ALLOWED_ATTR" in cfg ? addToSet({}, cfg.ALLOWED_ATTR, transformCaseFunc) : DEFAULT_ALLOWED_ATTR;
        URI_SAFE_ATTRIBUTES = "ADD_URI_SAFE_ATTR" in cfg ? addToSet(
          clone2(DEFAULT_URI_SAFE_ATTRIBUTES),
          cfg.ADD_URI_SAFE_ATTR,
          transformCaseFunc
        ) : DEFAULT_URI_SAFE_ATTRIBUTES;
        DATA_URI_TAGS = "ADD_DATA_URI_TAGS" in cfg ? addToSet(
          clone2(DEFAULT_DATA_URI_TAGS),
          cfg.ADD_DATA_URI_TAGS,
          transformCaseFunc
        ) : DEFAULT_DATA_URI_TAGS;
        FORBID_CONTENTS = "FORBID_CONTENTS" in cfg ? addToSet({}, cfg.FORBID_CONTENTS, transformCaseFunc) : DEFAULT_FORBID_CONTENTS;
        FORBID_TAGS = "FORBID_TAGS" in cfg ? addToSet({}, cfg.FORBID_TAGS, transformCaseFunc) : {};
        FORBID_ATTR = "FORBID_ATTR" in cfg ? addToSet({}, cfg.FORBID_ATTR, transformCaseFunc) : {};
        USE_PROFILES = "USE_PROFILES" in cfg ? cfg.USE_PROFILES : false;
        ALLOW_ARIA_ATTR = cfg.ALLOW_ARIA_ATTR !== false;
        ALLOW_DATA_ATTR = cfg.ALLOW_DATA_ATTR !== false;
        ALLOW_UNKNOWN_PROTOCOLS = cfg.ALLOW_UNKNOWN_PROTOCOLS || false;
        SAFE_FOR_TEMPLATES = cfg.SAFE_FOR_TEMPLATES || false;
        WHOLE_DOCUMENT = cfg.WHOLE_DOCUMENT || false;
        RETURN_DOM = cfg.RETURN_DOM || false;
        RETURN_DOM_FRAGMENT = cfg.RETURN_DOM_FRAGMENT || false;
        RETURN_TRUSTED_TYPE = cfg.RETURN_TRUSTED_TYPE || false;
        FORCE_BODY = cfg.FORCE_BODY || false;
        SANITIZE_DOM = cfg.SANITIZE_DOM !== false;
        SANITIZE_NAMED_PROPS = cfg.SANITIZE_NAMED_PROPS || false;
        KEEP_CONTENT = cfg.KEEP_CONTENT !== false;
        IN_PLACE = cfg.IN_PLACE || false;
        IS_ALLOWED_URI$1 = cfg.ALLOWED_URI_REGEXP || IS_ALLOWED_URI$1;
        NAMESPACE = cfg.NAMESPACE || HTML_NAMESPACE;
        if (cfg.CUSTOM_ELEMENT_HANDLING && isRegexOrFunction(cfg.CUSTOM_ELEMENT_HANDLING.tagNameCheck)) {
          CUSTOM_ELEMENT_HANDLING.tagNameCheck = cfg.CUSTOM_ELEMENT_HANDLING.tagNameCheck;
        }
        if (cfg.CUSTOM_ELEMENT_HANDLING && isRegexOrFunction(cfg.CUSTOM_ELEMENT_HANDLING.attributeNameCheck)) {
          CUSTOM_ELEMENT_HANDLING.attributeNameCheck = cfg.CUSTOM_ELEMENT_HANDLING.attributeNameCheck;
        }
        if (cfg.CUSTOM_ELEMENT_HANDLING && typeof cfg.CUSTOM_ELEMENT_HANDLING.allowCustomizedBuiltInElements === "boolean") {
          CUSTOM_ELEMENT_HANDLING.allowCustomizedBuiltInElements = cfg.CUSTOM_ELEMENT_HANDLING.allowCustomizedBuiltInElements;
        }
        if (SAFE_FOR_TEMPLATES) {
          ALLOW_DATA_ATTR = false;
        }
        if (RETURN_DOM_FRAGMENT) {
          RETURN_DOM = true;
        }
        if (USE_PROFILES) {
          ALLOWED_TAGS = addToSet({}, _toConsumableArray(text));
          ALLOWED_ATTR = [];
          if (USE_PROFILES.html === true) {
            addToSet(ALLOWED_TAGS, html$1);
            addToSet(ALLOWED_ATTR, html);
          }
          if (USE_PROFILES.svg === true) {
            addToSet(ALLOWED_TAGS, svg$1);
            addToSet(ALLOWED_ATTR, svg);
            addToSet(ALLOWED_ATTR, xml);
          }
          if (USE_PROFILES.svgFilters === true) {
            addToSet(ALLOWED_TAGS, svgFilters);
            addToSet(ALLOWED_ATTR, svg);
            addToSet(ALLOWED_ATTR, xml);
          }
          if (USE_PROFILES.mathMl === true) {
            addToSet(ALLOWED_TAGS, mathMl$1);
            addToSet(ALLOWED_ATTR, mathMl);
            addToSet(ALLOWED_ATTR, xml);
          }
        }
        if (cfg.ADD_TAGS) {
          if (ALLOWED_TAGS === DEFAULT_ALLOWED_TAGS) {
            ALLOWED_TAGS = clone2(ALLOWED_TAGS);
          }
          addToSet(ALLOWED_TAGS, cfg.ADD_TAGS, transformCaseFunc);
        }
        if (cfg.ADD_ATTR) {
          if (ALLOWED_ATTR === DEFAULT_ALLOWED_ATTR) {
            ALLOWED_ATTR = clone2(ALLOWED_ATTR);
          }
          addToSet(ALLOWED_ATTR, cfg.ADD_ATTR, transformCaseFunc);
        }
        if (cfg.ADD_URI_SAFE_ATTR) {
          addToSet(URI_SAFE_ATTRIBUTES, cfg.ADD_URI_SAFE_ATTR, transformCaseFunc);
        }
        if (cfg.FORBID_CONTENTS) {
          if (FORBID_CONTENTS === DEFAULT_FORBID_CONTENTS) {
            FORBID_CONTENTS = clone2(FORBID_CONTENTS);
          }
          addToSet(FORBID_CONTENTS, cfg.FORBID_CONTENTS, transformCaseFunc);
        }
        if (KEEP_CONTENT) {
          ALLOWED_TAGS["#text"] = true;
        }
        if (WHOLE_DOCUMENT) {
          addToSet(ALLOWED_TAGS, ["html", "head", "body"]);
        }
        if (ALLOWED_TAGS.table) {
          addToSet(ALLOWED_TAGS, ["tbody"]);
          delete FORBID_TAGS.tbody;
        }
        if (freeze) {
          freeze(cfg);
        }
        CONFIG = cfg;
      };
      var MATHML_TEXT_INTEGRATION_POINTS = addToSet({}, ["mi", "mo", "mn", "ms", "mtext"]);
      var HTML_INTEGRATION_POINTS = addToSet({}, ["foreignobject", "desc", "title", "annotation-xml"]);
      var COMMON_SVG_AND_HTML_ELEMENTS = addToSet({}, ["title", "style", "font", "a", "script"]);
      var ALL_SVG_TAGS = addToSet({}, svg$1);
      addToSet(ALL_SVG_TAGS, svgFilters);
      addToSet(ALL_SVG_TAGS, svgDisallowed);
      var ALL_MATHML_TAGS = addToSet({}, mathMl$1);
      addToSet(ALL_MATHML_TAGS, mathMlDisallowed);
      var _checkValidNamespace = function _checkValidNamespace2(element) {
        var parent = getParentNode(element);
        if (!parent || !parent.tagName) {
          parent = {
            namespaceURI: HTML_NAMESPACE,
            tagName: "template"
          };
        }
        var tagName = stringToLowerCase(element.tagName);
        var parentTagName = stringToLowerCase(parent.tagName);
        if (element.namespaceURI === SVG_NAMESPACE) {
          if (parent.namespaceURI === HTML_NAMESPACE) {
            return tagName === "svg";
          }
          if (parent.namespaceURI === MATHML_NAMESPACE) {
            return tagName === "svg" && (parentTagName === "annotation-xml" || MATHML_TEXT_INTEGRATION_POINTS[parentTagName]);
          }
          return Boolean(ALL_SVG_TAGS[tagName]);
        }
        if (element.namespaceURI === MATHML_NAMESPACE) {
          if (parent.namespaceURI === HTML_NAMESPACE) {
            return tagName === "math";
          }
          if (parent.namespaceURI === SVG_NAMESPACE) {
            return tagName === "math" && HTML_INTEGRATION_POINTS[parentTagName];
          }
          return Boolean(ALL_MATHML_TAGS[tagName]);
        }
        if (element.namespaceURI === HTML_NAMESPACE) {
          if (parent.namespaceURI === SVG_NAMESPACE && !HTML_INTEGRATION_POINTS[parentTagName]) {
            return false;
          }
          if (parent.namespaceURI === MATHML_NAMESPACE && !MATHML_TEXT_INTEGRATION_POINTS[parentTagName]) {
            return false;
          }
          return !ALL_MATHML_TAGS[tagName] && (COMMON_SVG_AND_HTML_ELEMENTS[tagName] || !ALL_SVG_TAGS[tagName]);
        }
        return false;
      };
      var _forceRemove = function _forceRemove2(node) {
        arrayPush(DOMPurify2.removed, {
          element: node
        });
        try {
          node.parentNode.removeChild(node);
        } catch (_) {
          try {
            node.outerHTML = emptyHTML;
          } catch (_2) {
            node.remove();
          }
        }
      };
      var _removeAttribute = function _removeAttribute2(name, node) {
        try {
          arrayPush(DOMPurify2.removed, {
            attribute: node.getAttributeNode(name),
            from: node
          });
        } catch (_) {
          arrayPush(DOMPurify2.removed, {
            attribute: null,
            from: node
          });
        }
        node.removeAttribute(name);
        if (name === "is" && !ALLOWED_ATTR[name]) {
          if (RETURN_DOM || RETURN_DOM_FRAGMENT) {
            try {
              _forceRemove(node);
            } catch (_) {
            }
          } else {
            try {
              node.setAttribute(name, "");
            } catch (_) {
            }
          }
        }
      };
      var _initDocument = function _initDocument2(dirty) {
        var doc;
        var leadingWhitespace;
        if (FORCE_BODY) {
          dirty = "<remove></remove>" + dirty;
        } else {
          var matches = stringMatch(dirty, /^[\r\n\t ]+/);
          leadingWhitespace = matches && matches[0];
        }
        if (PARSER_MEDIA_TYPE === "application/xhtml+xml") {
          dirty = '<html xmlns="http://www.w3.org/1999/xhtml"><head></head><body>' + dirty + "</body></html>";
        }
        var dirtyPayload = trustedTypesPolicy ? trustedTypesPolicy.createHTML(dirty) : dirty;
        if (NAMESPACE === HTML_NAMESPACE) {
          try {
            doc = new DOMParser2().parseFromString(dirtyPayload, PARSER_MEDIA_TYPE);
          } catch (_) {
          }
        }
        if (!doc || !doc.documentElement) {
          doc = implementation4.createDocument(NAMESPACE, "template", null);
          try {
            doc.documentElement.innerHTML = IS_EMPTY_INPUT ? "" : dirtyPayload;
          } catch (_) {
          }
        }
        var body = doc.body || doc.documentElement;
        if (dirty && leadingWhitespace) {
          body.insertBefore(document2.createTextNode(leadingWhitespace), body.childNodes[0] || null);
        }
        if (NAMESPACE === HTML_NAMESPACE) {
          return getElementsByTagName.call(doc, WHOLE_DOCUMENT ? "html" : "body")[0];
        }
        return WHOLE_DOCUMENT ? doc.documentElement : body;
      };
      var _createIterator = function _createIterator2(root) {
        return createNodeIterator.call(
          root.ownerDocument || root,
          root,
          NodeFilter.SHOW_ELEMENT | NodeFilter.SHOW_COMMENT | NodeFilter.SHOW_TEXT,
          null,
          false
        );
      };
      var _isClobbered = function _isClobbered2(elm) {
        return elm instanceof HTMLFormElement && (typeof elm.nodeName !== "string" || typeof elm.textContent !== "string" || typeof elm.removeChild !== "function" || !(elm.attributes instanceof NamedNodeMap) || typeof elm.removeAttribute !== "function" || typeof elm.setAttribute !== "function" || typeof elm.namespaceURI !== "string" || typeof elm.insertBefore !== "function");
      };
      var _isNode = function _isNode2(object) {
        return _typeof(Node6) === "object" ? object instanceof Node6 : object && _typeof(object) === "object" && typeof object.nodeType === "number" && typeof object.nodeName === "string";
      };
      var _executeHook = function _executeHook2(entryPoint, currentNode, data) {
        if (!hooks[entryPoint]) {
          return;
        }
        arrayForEach(hooks[entryPoint], function(hook) {
          hook.call(DOMPurify2, currentNode, data, CONFIG);
        });
      };
      var _sanitizeElements = function _sanitizeElements2(currentNode) {
        var content;
        _executeHook("beforeSanitizeElements", currentNode, null);
        if (_isClobbered(currentNode)) {
          _forceRemove(currentNode);
          return true;
        }
        if (regExpTest(/[\u0080-\uFFFF]/, currentNode.nodeName)) {
          _forceRemove(currentNode);
          return true;
        }
        var tagName = transformCaseFunc(currentNode.nodeName);
        _executeHook("uponSanitizeElement", currentNode, {
          tagName,
          allowedTags: ALLOWED_TAGS
        });
        if (currentNode.hasChildNodes() && !_isNode(currentNode.firstElementChild) && (!_isNode(currentNode.content) || !_isNode(currentNode.content.firstElementChild)) && regExpTest(/<[/\w]/g, currentNode.innerHTML) && regExpTest(/<[/\w]/g, currentNode.textContent)) {
          _forceRemove(currentNode);
          return true;
        }
        if (tagName === "select" && regExpTest(/<template/i, currentNode.innerHTML)) {
          _forceRemove(currentNode);
          return true;
        }
        if (!ALLOWED_TAGS[tagName] || FORBID_TAGS[tagName]) {
          if (!FORBID_TAGS[tagName] && _basicCustomElementTest(tagName)) {
            if (CUSTOM_ELEMENT_HANDLING.tagNameCheck instanceof RegExp && regExpTest(CUSTOM_ELEMENT_HANDLING.tagNameCheck, tagName))
              return false;
            if (CUSTOM_ELEMENT_HANDLING.tagNameCheck instanceof Function && CUSTOM_ELEMENT_HANDLING.tagNameCheck(tagName))
              return false;
          }
          if (KEEP_CONTENT && !FORBID_CONTENTS[tagName]) {
            var parentNode = getParentNode(currentNode) || currentNode.parentNode;
            var childNodes = getChildNodes(currentNode) || currentNode.childNodes;
            if (childNodes && parentNode) {
              var childCount = childNodes.length;
              for (var i = childCount - 1; i >= 0; --i) {
                parentNode.insertBefore(cloneNode(childNodes[i], true), getNextSibling(currentNode));
              }
            }
          }
          _forceRemove(currentNode);
          return true;
        }
        if (currentNode instanceof Element2 && !_checkValidNamespace(currentNode)) {
          _forceRemove(currentNode);
          return true;
        }
        if ((tagName === "noscript" || tagName === "noembed") && regExpTest(/<\/no(script|embed)/i, currentNode.innerHTML)) {
          _forceRemove(currentNode);
          return true;
        }
        if (SAFE_FOR_TEMPLATES && currentNode.nodeType === 3) {
          content = currentNode.textContent;
          content = stringReplace(content, MUSTACHE_EXPR$1, " ");
          content = stringReplace(content, ERB_EXPR$1, " ");
          if (currentNode.textContent !== content) {
            arrayPush(DOMPurify2.removed, {
              element: currentNode.cloneNode()
            });
            currentNode.textContent = content;
          }
        }
        _executeHook("afterSanitizeElements", currentNode, null);
        return false;
      };
      var _isValidAttribute = function _isValidAttribute2(lcTag, lcName, value) {
        if (SANITIZE_DOM && (lcName === "id" || lcName === "name") && (value in document2 || value in formElement)) {
          return false;
        }
        if (ALLOW_DATA_ATTR && !FORBID_ATTR[lcName] && regExpTest(DATA_ATTR$1, lcName))
          ;
        else if (ALLOW_ARIA_ATTR && regExpTest(ARIA_ATTR$1, lcName))
          ;
        else if (!ALLOWED_ATTR[lcName] || FORBID_ATTR[lcName]) {
          if (_basicCustomElementTest(lcTag) && (CUSTOM_ELEMENT_HANDLING.tagNameCheck instanceof RegExp && regExpTest(CUSTOM_ELEMENT_HANDLING.tagNameCheck, lcTag) || CUSTOM_ELEMENT_HANDLING.tagNameCheck instanceof Function && CUSTOM_ELEMENT_HANDLING.tagNameCheck(lcTag)) && (CUSTOM_ELEMENT_HANDLING.attributeNameCheck instanceof RegExp && regExpTest(CUSTOM_ELEMENT_HANDLING.attributeNameCheck, lcName) || CUSTOM_ELEMENT_HANDLING.attributeNameCheck instanceof Function && CUSTOM_ELEMENT_HANDLING.attributeNameCheck(lcName)) || lcName === "is" && CUSTOM_ELEMENT_HANDLING.allowCustomizedBuiltInElements && (CUSTOM_ELEMENT_HANDLING.tagNameCheck instanceof RegExp && regExpTest(CUSTOM_ELEMENT_HANDLING.tagNameCheck, value) || CUSTOM_ELEMENT_HANDLING.tagNameCheck instanceof Function && CUSTOM_ELEMENT_HANDLING.tagNameCheck(value)))
            ;
          else {
            return false;
          }
        } else if (URI_SAFE_ATTRIBUTES[lcName])
          ;
        else if (regExpTest(IS_ALLOWED_URI$1, stringReplace(value, ATTR_WHITESPACE$1, "")))
          ;
        else if ((lcName === "src" || lcName === "xlink:href" || lcName === "href") && lcTag !== "script" && stringIndexOf(value, "data:") === 0 && DATA_URI_TAGS[lcTag])
          ;
        else if (ALLOW_UNKNOWN_PROTOCOLS && !regExpTest(IS_SCRIPT_OR_DATA$1, stringReplace(value, ATTR_WHITESPACE$1, "")))
          ;
        else if (!value)
          ;
        else {
          return false;
        }
        return true;
      };
      var _basicCustomElementTest = function _basicCustomElementTest2(tagName) {
        return tagName.indexOf("-") > 0;
      };
      var _sanitizeAttributes = function _sanitizeAttributes2(currentNode) {
        var attr;
        var value;
        var lcName;
        var l;
        _executeHook("beforeSanitizeAttributes", currentNode, null);
        var attributes = currentNode.attributes;
        if (!attributes) {
          return;
        }
        var hookEvent = {
          attrName: "",
          attrValue: "",
          keepAttr: true,
          allowedAttributes: ALLOWED_ATTR
        };
        l = attributes.length;
        while (l--) {
          attr = attributes[l];
          var _attr = attr, name = _attr.name, namespaceURI = _attr.namespaceURI;
          value = name === "value" ? attr.value : stringTrim(attr.value);
          lcName = transformCaseFunc(name);
          hookEvent.attrName = lcName;
          hookEvent.attrValue = value;
          hookEvent.keepAttr = true;
          hookEvent.forceKeepAttr = void 0;
          _executeHook("uponSanitizeAttribute", currentNode, hookEvent);
          value = hookEvent.attrValue;
          if (hookEvent.forceKeepAttr) {
            continue;
          }
          _removeAttribute(name, currentNode);
          if (!hookEvent.keepAttr) {
            continue;
          }
          if (regExpTest(/\/>/i, value)) {
            _removeAttribute(name, currentNode);
            continue;
          }
          if (SAFE_FOR_TEMPLATES) {
            value = stringReplace(value, MUSTACHE_EXPR$1, " ");
            value = stringReplace(value, ERB_EXPR$1, " ");
          }
          var lcTag = transformCaseFunc(currentNode.nodeName);
          if (!_isValidAttribute(lcTag, lcName, value)) {
            continue;
          }
          if (SANITIZE_NAMED_PROPS && (lcName === "id" || lcName === "name")) {
            _removeAttribute(name, currentNode);
            value = SANITIZE_NAMED_PROPS_PREFIX + value;
          }
          if (trustedTypesPolicy && _typeof(trustedTypes) === "object" && typeof trustedTypes.getAttributeType === "function") {
            if (namespaceURI)
              ;
            else {
              switch (trustedTypes.getAttributeType(lcTag, lcName)) {
                case "TrustedHTML":
                  value = trustedTypesPolicy.createHTML(value);
                  break;
                case "TrustedScriptURL":
                  value = trustedTypesPolicy.createScriptURL(value);
                  break;
              }
            }
          }
          try {
            if (namespaceURI) {
              currentNode.setAttributeNS(namespaceURI, name, value);
            } else {
              currentNode.setAttribute(name, value);
            }
            arrayPop(DOMPurify2.removed);
          } catch (_) {
          }
        }
        _executeHook("afterSanitizeAttributes", currentNode, null);
      };
      var _sanitizeShadowDOM = function _sanitizeShadowDOM2(fragment) {
        var shadowNode;
        var shadowIterator = _createIterator(fragment);
        _executeHook("beforeSanitizeShadowDOM", fragment, null);
        while (shadowNode = shadowIterator.nextNode()) {
          _executeHook("uponSanitizeShadowNode", shadowNode, null);
          if (_sanitizeElements(shadowNode)) {
            continue;
          }
          if (shadowNode.content instanceof DocumentFragment2) {
            _sanitizeShadowDOM2(shadowNode.content);
          }
          _sanitizeAttributes(shadowNode);
        }
        _executeHook("afterSanitizeShadowDOM", fragment, null);
      };
      DOMPurify2.sanitize = function(dirty) {
        var cfg = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
        var body;
        var importedNode;
        var currentNode;
        var oldNode;
        var returnNode;
        IS_EMPTY_INPUT = !dirty;
        if (IS_EMPTY_INPUT) {
          dirty = "<!-->";
        }
        if (typeof dirty !== "string" && !_isNode(dirty)) {
          if (typeof dirty.toString !== "function") {
            throw typeErrorCreate("toString is not a function");
          } else {
            dirty = dirty.toString();
            if (typeof dirty !== "string") {
              throw typeErrorCreate("dirty is not a string, aborting");
            }
          }
        }
        if (!DOMPurify2.isSupported) {
          if (_typeof(window2.toStaticHTML) === "object" || typeof window2.toStaticHTML === "function") {
            if (typeof dirty === "string") {
              return window2.toStaticHTML(dirty);
            }
            if (_isNode(dirty)) {
              return window2.toStaticHTML(dirty.outerHTML);
            }
          }
          return dirty;
        }
        if (!SET_CONFIG) {
          _parseConfig(cfg);
        }
        DOMPurify2.removed = [];
        if (typeof dirty === "string") {
          IN_PLACE = false;
        }
        if (IN_PLACE) {
          if (dirty.nodeName) {
            var tagName = transformCaseFunc(dirty.nodeName);
            if (!ALLOWED_TAGS[tagName] || FORBID_TAGS[tagName]) {
              throw typeErrorCreate("root node is forbidden and cannot be sanitized in-place");
            }
          }
        } else if (dirty instanceof Node6) {
          body = _initDocument("<!---->");
          importedNode = body.ownerDocument.importNode(dirty, true);
          if (importedNode.nodeType === 1 && importedNode.nodeName === "BODY") {
            body = importedNode;
          } else if (importedNode.nodeName === "HTML") {
            body = importedNode;
          } else {
            body.appendChild(importedNode);
          }
        } else {
          if (!RETURN_DOM && !SAFE_FOR_TEMPLATES && !WHOLE_DOCUMENT && dirty.indexOf("<") === -1) {
            return trustedTypesPolicy && RETURN_TRUSTED_TYPE ? trustedTypesPolicy.createHTML(dirty) : dirty;
          }
          body = _initDocument(dirty);
          if (!body) {
            return RETURN_DOM ? null : RETURN_TRUSTED_TYPE ? emptyHTML : "";
          }
        }
        if (body && FORCE_BODY) {
          _forceRemove(body.firstChild);
        }
        var nodeIterator = _createIterator(IN_PLACE ? dirty : body);
        while (currentNode = nodeIterator.nextNode()) {
          if (currentNode.nodeType === 3 && currentNode === oldNode) {
            continue;
          }
          if (_sanitizeElements(currentNode)) {
            continue;
          }
          if (currentNode.content instanceof DocumentFragment2) {
            _sanitizeShadowDOM(currentNode.content);
          }
          _sanitizeAttributes(currentNode);
          oldNode = currentNode;
        }
        oldNode = null;
        if (IN_PLACE) {
          return dirty;
        }
        if (RETURN_DOM) {
          if (RETURN_DOM_FRAGMENT) {
            returnNode = createDocumentFragment.call(body.ownerDocument);
            while (body.firstChild) {
              returnNode.appendChild(body.firstChild);
            }
          } else {
            returnNode = body;
          }
          if (ALLOWED_ATTR.shadowroot) {
            returnNode = importNode.call(originalDocument, returnNode, true);
          }
          return returnNode;
        }
        var serializedHTML = WHOLE_DOCUMENT ? body.outerHTML : body.innerHTML;
        if (WHOLE_DOCUMENT && ALLOWED_TAGS["!doctype"] && body.ownerDocument && body.ownerDocument.doctype && body.ownerDocument.doctype.name && regExpTest(DOCTYPE_NAME, body.ownerDocument.doctype.name)) {
          serializedHTML = "<!DOCTYPE " + body.ownerDocument.doctype.name + ">\n" + serializedHTML;
        }
        if (SAFE_FOR_TEMPLATES) {
          serializedHTML = stringReplace(serializedHTML, MUSTACHE_EXPR$1, " ");
          serializedHTML = stringReplace(serializedHTML, ERB_EXPR$1, " ");
        }
        return trustedTypesPolicy && RETURN_TRUSTED_TYPE ? trustedTypesPolicy.createHTML(serializedHTML) : serializedHTML;
      };
      DOMPurify2.setConfig = function(cfg) {
        _parseConfig(cfg);
        SET_CONFIG = true;
      };
      DOMPurify2.clearConfig = function() {
        CONFIG = null;
        SET_CONFIG = false;
      };
      DOMPurify2.isValidAttribute = function(tag, attr, value) {
        if (!CONFIG) {
          _parseConfig({});
        }
        var lcTag = transformCaseFunc(tag);
        var lcName = transformCaseFunc(attr);
        return _isValidAttribute(lcTag, lcName, value);
      };
      DOMPurify2.addHook = function(entryPoint, hookFunction) {
        if (typeof hookFunction !== "function") {
          return;
        }
        hooks[entryPoint] = hooks[entryPoint] || [];
        arrayPush(hooks[entryPoint], hookFunction);
      };
      DOMPurify2.removeHook = function(entryPoint) {
        if (hooks[entryPoint]) {
          return arrayPop(hooks[entryPoint]);
        }
      };
      DOMPurify2.removeHooks = function(entryPoint) {
        if (hooks[entryPoint]) {
          hooks[entryPoint] = [];
        }
      };
      DOMPurify2.removeAllHooks = function() {
        hooks = {};
      };
      return DOMPurify2;
    }
    var purify = createDOMPurify();
    module2.exports = purify;
  }
});

// node_modules/earcut/src/earcut.js
var require_earcut = __commonJS({
  "node_modules/earcut/src/earcut.js"(exports2, module2) {
    "use strict";
    module2.exports = earcut2;
    module2.exports.default = earcut2;
    function earcut2(data, holeIndices, dim) {
      dim = dim || 2;
      var hasHoles = holeIndices && holeIndices.length, outerLen = hasHoles ? holeIndices[0] * dim : data.length, outerNode = linkedList(data, 0, outerLen, dim, true), triangles = [];
      if (!outerNode || outerNode.next === outerNode.prev)
        return triangles;
      var minX, minY, maxX, maxY, x, y, invSize;
      if (hasHoles)
        outerNode = eliminateHoles(data, holeIndices, outerNode, dim);
      if (data.length > 80 * dim) {
        minX = maxX = data[0];
        minY = maxY = data[1];
        for (var i = dim; i < outerLen; i += dim) {
          x = data[i];
          y = data[i + 1];
          if (x < minX)
            minX = x;
          if (y < minY)
            minY = y;
          if (x > maxX)
            maxX = x;
          if (y > maxY)
            maxY = y;
        }
        invSize = Math.max(maxX - minX, maxY - minY);
        invSize = invSize !== 0 ? 32767 / invSize : 0;
      }
      earcutLinked(outerNode, triangles, dim, minX, minY, invSize, 0);
      return triangles;
    }
    function linkedList(data, start, end, dim, clockwise) {
      var i, last;
      if (clockwise === signedArea(data, start, end, dim) > 0) {
        for (i = start; i < end; i += dim)
          last = insertNode(i, data[i], data[i + 1], last);
      } else {
        for (i = end - dim; i >= start; i -= dim)
          last = insertNode(i, data[i], data[i + 1], last);
      }
      if (last && equals(last, last.next)) {
        removeNode(last);
        last = last.next;
      }
      return last;
    }
    function filterPoints(start, end) {
      if (!start)
        return start;
      if (!end)
        end = start;
      var p = start, again;
      do {
        again = false;
        if (!p.steiner && (equals(p, p.next) || area(p.prev, p, p.next) === 0)) {
          removeNode(p);
          p = end = p.prev;
          if (p === p.next)
            break;
          again = true;
        } else {
          p = p.next;
        }
      } while (again || p !== end);
      return end;
    }
    function earcutLinked(ear, triangles, dim, minX, minY, invSize, pass) {
      if (!ear)
        return;
      if (!pass && invSize)
        indexCurve(ear, minX, minY, invSize);
      var stop2 = ear, prev, next;
      while (ear.prev !== ear.next) {
        prev = ear.prev;
        next = ear.next;
        if (invSize ? isEarHashed(ear, minX, minY, invSize) : isEar(ear)) {
          triangles.push(prev.i / dim | 0);
          triangles.push(ear.i / dim | 0);
          triangles.push(next.i / dim | 0);
          removeNode(ear);
          ear = next.next;
          stop2 = next.next;
          continue;
        }
        ear = next;
        if (ear === stop2) {
          if (!pass) {
            earcutLinked(filterPoints(ear), triangles, dim, minX, minY, invSize, 1);
          } else if (pass === 1) {
            ear = cureLocalIntersections(filterPoints(ear), triangles, dim);
            earcutLinked(ear, triangles, dim, minX, minY, invSize, 2);
          } else if (pass === 2) {
            splitEarcut(ear, triangles, dim, minX, minY, invSize);
          }
          break;
        }
      }
    }
    function isEar(ear) {
      var a3 = ear.prev, b = ear, c = ear.next;
      if (area(a3, b, c) >= 0)
        return false;
      var ax = a3.x, bx = b.x, cx = c.x, ay = a3.y, by = b.y, cy = c.y;
      var x0 = ax < bx ? ax < cx ? ax : cx : bx < cx ? bx : cx, y0 = ay < by ? ay < cy ? ay : cy : by < cy ? by : cy, x1 = ax > bx ? ax > cx ? ax : cx : bx > cx ? bx : cx, y1 = ay > by ? ay > cy ? ay : cy : by > cy ? by : cy;
      var p = c.next;
      while (p !== a3) {
        if (p.x >= x0 && p.x <= x1 && p.y >= y0 && p.y <= y1 && pointInTriangle(ax, ay, bx, by, cx, cy, p.x, p.y) && area(p.prev, p, p.next) >= 0)
          return false;
        p = p.next;
      }
      return true;
    }
    function isEarHashed(ear, minX, minY, invSize) {
      var a3 = ear.prev, b = ear, c = ear.next;
      if (area(a3, b, c) >= 0)
        return false;
      var ax = a3.x, bx = b.x, cx = c.x, ay = a3.y, by = b.y, cy = c.y;
      var x0 = ax < bx ? ax < cx ? ax : cx : bx < cx ? bx : cx, y0 = ay < by ? ay < cy ? ay : cy : by < cy ? by : cy, x1 = ax > bx ? ax > cx ? ax : cx : bx > cx ? bx : cx, y1 = ay > by ? ay > cy ? ay : cy : by > cy ? by : cy;
      var minZ = zOrder(x0, y0, minX, minY, invSize), maxZ = zOrder(x1, y1, minX, minY, invSize);
      var p = ear.prevZ, n = ear.nextZ;
      while (p && p.z >= minZ && n && n.z <= maxZ) {
        if (p.x >= x0 && p.x <= x1 && p.y >= y0 && p.y <= y1 && p !== a3 && p !== c && pointInTriangle(ax, ay, bx, by, cx, cy, p.x, p.y) && area(p.prev, p, p.next) >= 0)
          return false;
        p = p.prevZ;
        if (n.x >= x0 && n.x <= x1 && n.y >= y0 && n.y <= y1 && n !== a3 && n !== c && pointInTriangle(ax, ay, bx, by, cx, cy, n.x, n.y) && area(n.prev, n, n.next) >= 0)
          return false;
        n = n.nextZ;
      }
      while (p && p.z >= minZ) {
        if (p.x >= x0 && p.x <= x1 && p.y >= y0 && p.y <= y1 && p !== a3 && p !== c && pointInTriangle(ax, ay, bx, by, cx, cy, p.x, p.y) && area(p.prev, p, p.next) >= 0)
          return false;
        p = p.prevZ;
      }
      while (n && n.z <= maxZ) {
        if (n.x >= x0 && n.x <= x1 && n.y >= y0 && n.y <= y1 && n !== a3 && n !== c && pointInTriangle(ax, ay, bx, by, cx, cy, n.x, n.y) && area(n.prev, n, n.next) >= 0)
          return false;
        n = n.nextZ;
      }
      return true;
    }
    function cureLocalIntersections(start, triangles, dim) {
      var p = start;
      do {
        var a3 = p.prev, b = p.next.next;
        if (!equals(a3, b) && intersects(a3, p, p.next, b) && locallyInside(a3, b) && locallyInside(b, a3)) {
          triangles.push(a3.i / dim | 0);
          triangles.push(p.i / dim | 0);
          triangles.push(b.i / dim | 0);
          removeNode(p);
          removeNode(p.next);
          p = start = b;
        }
        p = p.next;
      } while (p !== start);
      return filterPoints(p);
    }
    function splitEarcut(start, triangles, dim, minX, minY, invSize) {
      var a3 = start;
      do {
        var b = a3.next.next;
        while (b !== a3.prev) {
          if (a3.i !== b.i && isValidDiagonal(a3, b)) {
            var c = splitPolygon(a3, b);
            a3 = filterPoints(a3, a3.next);
            c = filterPoints(c, c.next);
            earcutLinked(a3, triangles, dim, minX, minY, invSize, 0);
            earcutLinked(c, triangles, dim, minX, minY, invSize, 0);
            return;
          }
          b = b.next;
        }
        a3 = a3.next;
      } while (a3 !== start);
    }
    function eliminateHoles(data, holeIndices, outerNode, dim) {
      var queue = [], i, len, start, end, list;
      for (i = 0, len = holeIndices.length; i < len; i++) {
        start = holeIndices[i] * dim;
        end = i < len - 1 ? holeIndices[i + 1] * dim : data.length;
        list = linkedList(data, start, end, dim, false);
        if (list === list.next)
          list.steiner = true;
        queue.push(getLeftmost(list));
      }
      queue.sort(compareX);
      for (i = 0; i < queue.length; i++) {
        outerNode = eliminateHole(queue[i], outerNode);
      }
      return outerNode;
    }
    function compareX(a3, b) {
      return a3.x - b.x;
    }
    function eliminateHole(hole, outerNode) {
      var bridge = findHoleBridge(hole, outerNode);
      if (!bridge) {
        return outerNode;
      }
      var bridgeReverse = splitPolygon(bridge, hole);
      filterPoints(bridgeReverse, bridgeReverse.next);
      return filterPoints(bridge, bridge.next);
    }
    function findHoleBridge(hole, outerNode) {
      var p = outerNode, hx = hole.x, hy = hole.y, qx = -Infinity, m;
      do {
        if (hy <= p.y && hy >= p.next.y && p.next.y !== p.y) {
          var x = p.x + (hy - p.y) * (p.next.x - p.x) / (p.next.y - p.y);
          if (x <= hx && x > qx) {
            qx = x;
            m = p.x < p.next.x ? p : p.next;
            if (x === hx)
              return m;
          }
        }
        p = p.next;
      } while (p !== outerNode);
      if (!m)
        return null;
      var stop2 = m, mx = m.x, my = m.y, tanMin = Infinity, tan;
      p = m;
      do {
        if (hx >= p.x && p.x >= mx && hx !== p.x && pointInTriangle(hy < my ? hx : qx, hy, mx, my, hy < my ? qx : hx, hy, p.x, p.y)) {
          tan = Math.abs(hy - p.y) / (hx - p.x);
          if (locallyInside(p, hole) && (tan < tanMin || tan === tanMin && (p.x > m.x || p.x === m.x && sectorContainsSector(m, p)))) {
            m = p;
            tanMin = tan;
          }
        }
        p = p.next;
      } while (p !== stop2);
      return m;
    }
    function sectorContainsSector(m, p) {
      return area(m.prev, m, p.prev) < 0 && area(p.next, m, m.next) < 0;
    }
    function indexCurve(start, minX, minY, invSize) {
      var p = start;
      do {
        if (p.z === 0)
          p.z = zOrder(p.x, p.y, minX, minY, invSize);
        p.prevZ = p.prev;
        p.nextZ = p.next;
        p = p.next;
      } while (p !== start);
      p.prevZ.nextZ = null;
      p.prevZ = null;
      sortLinked(p);
    }
    function sortLinked(list) {
      var i, p, q, e, tail, numMerges, pSize, qSize, inSize = 1;
      do {
        p = list;
        list = null;
        tail = null;
        numMerges = 0;
        while (p) {
          numMerges++;
          q = p;
          pSize = 0;
          for (i = 0; i < inSize; i++) {
            pSize++;
            q = q.nextZ;
            if (!q)
              break;
          }
          qSize = inSize;
          while (pSize > 0 || qSize > 0 && q) {
            if (pSize !== 0 && (qSize === 0 || !q || p.z <= q.z)) {
              e = p;
              p = p.nextZ;
              pSize--;
            } else {
              e = q;
              q = q.nextZ;
              qSize--;
            }
            if (tail)
              tail.nextZ = e;
            else
              list = e;
            e.prevZ = tail;
            tail = e;
          }
          p = q;
        }
        tail.nextZ = null;
        inSize *= 2;
      } while (numMerges > 1);
      return list;
    }
    function zOrder(x, y, minX, minY, invSize) {
      x = (x - minX) * invSize | 0;
      y = (y - minY) * invSize | 0;
      x = (x | x << 8) & 16711935;
      x = (x | x << 4) & 252645135;
      x = (x | x << 2) & 858993459;
      x = (x | x << 1) & 1431655765;
      y = (y | y << 8) & 16711935;
      y = (y | y << 4) & 252645135;
      y = (y | y << 2) & 858993459;
      y = (y | y << 1) & 1431655765;
      return x | y << 1;
    }
    function getLeftmost(start) {
      var p = start, leftmost = start;
      do {
        if (p.x < leftmost.x || p.x === leftmost.x && p.y < leftmost.y)
          leftmost = p;
        p = p.next;
      } while (p !== start);
      return leftmost;
    }
    function pointInTriangle(ax, ay, bx, by, cx, cy, px, py) {
      return (cx - px) * (ay - py) >= (ax - px) * (cy - py) && (ax - px) * (by - py) >= (bx - px) * (ay - py) && (bx - px) * (cy - py) >= (cx - px) * (by - py);
    }
    function isValidDiagonal(a3, b) {
      return a3.next.i !== b.i && a3.prev.i !== b.i && !intersectsPolygon(a3, b) && (locallyInside(a3, b) && locallyInside(b, a3) && middleInside(a3, b) && (area(a3.prev, a3, b.prev) || area(a3, b.prev, b)) || equals(a3, b) && area(a3.prev, a3, a3.next) > 0 && area(b.prev, b, b.next) > 0);
    }
    function area(p, q, r) {
      return (q.y - p.y) * (r.x - q.x) - (q.x - p.x) * (r.y - q.y);
    }
    function equals(p1, p2) {
      return p1.x === p2.x && p1.y === p2.y;
    }
    function intersects(p1, q12, p2, q22) {
      var o1 = sign2(area(p1, q12, p2));
      var o2 = sign2(area(p1, q12, q22));
      var o3 = sign2(area(p2, q22, p1));
      var o4 = sign2(area(p2, q22, q12));
      if (o1 !== o2 && o3 !== o4)
        return true;
      if (o1 === 0 && onSegment(p1, p2, q12))
        return true;
      if (o2 === 0 && onSegment(p1, q22, q12))
        return true;
      if (o3 === 0 && onSegment(p2, p1, q22))
        return true;
      if (o4 === 0 && onSegment(p2, q12, q22))
        return true;
      return false;
    }
    function onSegment(p, q, r) {
      return q.x <= Math.max(p.x, r.x) && q.x >= Math.min(p.x, r.x) && q.y <= Math.max(p.y, r.y) && q.y >= Math.min(p.y, r.y);
    }
    function sign2(num) {
      return num > 0 ? 1 : num < 0 ? -1 : 0;
    }
    function intersectsPolygon(a3, b) {
      var p = a3;
      do {
        if (p.i !== a3.i && p.next.i !== a3.i && p.i !== b.i && p.next.i !== b.i && intersects(p, p.next, a3, b))
          return true;
        p = p.next;
      } while (p !== a3);
      return false;
    }
    function locallyInside(a3, b) {
      return area(a3.prev, a3, a3.next) < 0 ? area(a3, b, a3.next) >= 0 && area(a3, a3.prev, b) >= 0 : area(a3, b, a3.prev) < 0 || area(a3, a3.next, b) < 0;
    }
    function middleInside(a3, b) {
      var p = a3, inside = false, px = (a3.x + b.x) / 2, py = (a3.y + b.y) / 2;
      do {
        if (p.y > py !== p.next.y > py && p.next.y !== p.y && px < (p.next.x - p.x) * (py - p.y) / (p.next.y - p.y) + p.x)
          inside = !inside;
        p = p.next;
      } while (p !== a3);
      return inside;
    }
    function splitPolygon(a3, b) {
      var a22 = new Node6(a3.i, a3.x, a3.y), b2 = new Node6(b.i, b.x, b.y), an = a3.next, bp = b.prev;
      a3.next = b;
      b.prev = a3;
      a22.next = an;
      an.prev = a22;
      b2.next = a22;
      a22.prev = b2;
      bp.next = b2;
      b2.prev = bp;
      return b2;
    }
    function insertNode(i, x, y, last) {
      var p = new Node6(i, x, y);
      if (!last) {
        p.prev = p;
        p.next = p;
      } else {
        p.next = last.next;
        p.prev = last;
        last.next.prev = p;
        last.next = p;
      }
      return p;
    }
    function removeNode(p) {
      p.next.prev = p.prev;
      p.prev.next = p.next;
      if (p.prevZ)
        p.prevZ.nextZ = p.nextZ;
      if (p.nextZ)
        p.nextZ.prevZ = p.prevZ;
    }
    function Node6(i, x, y) {
      this.i = i;
      this.x = x;
      this.y = y;
      this.prev = null;
      this.next = null;
      this.z = 0;
      this.prevZ = null;
      this.nextZ = null;
      this.steiner = false;
    }
    earcut2.deviation = function(data, holeIndices, dim, triangles) {
      var hasHoles = holeIndices && holeIndices.length;
      var outerLen = hasHoles ? holeIndices[0] * dim : data.length;
      var polygonArea = Math.abs(signedArea(data, 0, outerLen, dim));
      if (hasHoles) {
        for (var i = 0, len = holeIndices.length; i < len; i++) {
          var start = holeIndices[i] * dim;
          var end = i < len - 1 ? holeIndices[i + 1] * dim : data.length;
          polygonArea -= Math.abs(signedArea(data, start, end, dim));
        }
      }
      var trianglesArea = 0;
      for (i = 0; i < triangles.length; i += 3) {
        var a3 = triangles[i] * dim;
        var b = triangles[i + 1] * dim;
        var c = triangles[i + 2] * dim;
        trianglesArea += Math.abs(
          (data[a3] - data[c]) * (data[b + 1] - data[a3 + 1]) - (data[a3] - data[b]) * (data[c + 1] - data[a3 + 1])
        );
      }
      return polygonArea === 0 && trianglesArea === 0 ? 0 : Math.abs((trianglesArea - polygonArea) / polygonArea);
    };
    function signedArea(data, start, end, dim) {
      var sum = 0;
      for (var i = start, j = end - dim; i < end; i += dim) {
        sum += (data[j] - data[i]) * (data[i + 1] + data[j + 1]);
        j = i;
      }
      return sum;
    }
    earcut2.flatten = function(data) {
      var dim = data[0][0].length, result = { vertices: [], holes: [], dimensions: dim }, holeIndex = 0;
      for (var i = 0; i < data.length; i++) {
        for (var j = 0; j < data[i].length; j++) {
          for (var d = 0; d < dim; d++)
            result.vertices.push(data[i][j][d]);
        }
        if (i > 0) {
          holeIndex += data[i - 1].length;
          result.holes.push(holeIndex);
        }
      }
      return result;
    };
  }
});

// node_modules/@tweenjs/tween.js/dist/tween.cjs.js
var require_tween_cjs = __commonJS({
  "node_modules/@tweenjs/tween.js/dist/tween.cjs.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    var Easing2 = {
      Linear: {
        None: function(amount) {
          return amount;
        }
      },
      Quadratic: {
        In: function(amount) {
          return amount * amount;
        },
        Out: function(amount) {
          return amount * (2 - amount);
        },
        InOut: function(amount) {
          if ((amount *= 2) < 1) {
            return 0.5 * amount * amount;
          }
          return -0.5 * (--amount * (amount - 2) - 1);
        }
      },
      Cubic: {
        In: function(amount) {
          return amount * amount * amount;
        },
        Out: function(amount) {
          return --amount * amount * amount + 1;
        },
        InOut: function(amount) {
          if ((amount *= 2) < 1) {
            return 0.5 * amount * amount * amount;
          }
          return 0.5 * ((amount -= 2) * amount * amount + 2);
        }
      },
      Quartic: {
        In: function(amount) {
          return amount * amount * amount * amount;
        },
        Out: function(amount) {
          return 1 - --amount * amount * amount * amount;
        },
        InOut: function(amount) {
          if ((amount *= 2) < 1) {
            return 0.5 * amount * amount * amount * amount;
          }
          return -0.5 * ((amount -= 2) * amount * amount * amount - 2);
        }
      },
      Quintic: {
        In: function(amount) {
          return amount * amount * amount * amount * amount;
        },
        Out: function(amount) {
          return --amount * amount * amount * amount * amount + 1;
        },
        InOut: function(amount) {
          if ((amount *= 2) < 1) {
            return 0.5 * amount * amount * amount * amount * amount;
          }
          return 0.5 * ((amount -= 2) * amount * amount * amount * amount + 2);
        }
      },
      Sinusoidal: {
        In: function(amount) {
          return 1 - Math.cos(amount * Math.PI / 2);
        },
        Out: function(amount) {
          return Math.sin(amount * Math.PI / 2);
        },
        InOut: function(amount) {
          return 0.5 * (1 - Math.cos(Math.PI * amount));
        }
      },
      Exponential: {
        In: function(amount) {
          return amount === 0 ? 0 : Math.pow(1024, amount - 1);
        },
        Out: function(amount) {
          return amount === 1 ? 1 : 1 - Math.pow(2, -10 * amount);
        },
        InOut: function(amount) {
          if (amount === 0) {
            return 0;
          }
          if (amount === 1) {
            return 1;
          }
          if ((amount *= 2) < 1) {
            return 0.5 * Math.pow(1024, amount - 1);
          }
          return 0.5 * (-Math.pow(2, -10 * (amount - 1)) + 2);
        }
      },
      Circular: {
        In: function(amount) {
          return 1 - Math.sqrt(1 - amount * amount);
        },
        Out: function(amount) {
          return Math.sqrt(1 - --amount * amount);
        },
        InOut: function(amount) {
          if ((amount *= 2) < 1) {
            return -0.5 * (Math.sqrt(1 - amount * amount) - 1);
          }
          return 0.5 * (Math.sqrt(1 - (amount -= 2) * amount) + 1);
        }
      },
      Elastic: {
        In: function(amount) {
          if (amount === 0) {
            return 0;
          }
          if (amount === 1) {
            return 1;
          }
          return -Math.pow(2, 10 * (amount - 1)) * Math.sin((amount - 1.1) * 5 * Math.PI);
        },
        Out: function(amount) {
          if (amount === 0) {
            return 0;
          }
          if (amount === 1) {
            return 1;
          }
          return Math.pow(2, -10 * amount) * Math.sin((amount - 0.1) * 5 * Math.PI) + 1;
        },
        InOut: function(amount) {
          if (amount === 0) {
            return 0;
          }
          if (amount === 1) {
            return 1;
          }
          amount *= 2;
          if (amount < 1) {
            return -0.5 * Math.pow(2, 10 * (amount - 1)) * Math.sin((amount - 1.1) * 5 * Math.PI);
          }
          return 0.5 * Math.pow(2, -10 * (amount - 1)) * Math.sin((amount - 1.1) * 5 * Math.PI) + 1;
        }
      },
      Back: {
        In: function(amount) {
          var s = 1.70158;
          return amount * amount * ((s + 1) * amount - s);
        },
        Out: function(amount) {
          var s = 1.70158;
          return --amount * amount * ((s + 1) * amount + s) + 1;
        },
        InOut: function(amount) {
          var s = 1.70158 * 1.525;
          if ((amount *= 2) < 1) {
            return 0.5 * (amount * amount * ((s + 1) * amount - s));
          }
          return 0.5 * ((amount -= 2) * amount * ((s + 1) * amount + s) + 2);
        }
      },
      Bounce: {
        In: function(amount) {
          return 1 - Easing2.Bounce.Out(1 - amount);
        },
        Out: function(amount) {
          if (amount < 1 / 2.75) {
            return 7.5625 * amount * amount;
          } else if (amount < 2 / 2.75) {
            return 7.5625 * (amount -= 1.5 / 2.75) * amount + 0.75;
          } else if (amount < 2.5 / 2.75) {
            return 7.5625 * (amount -= 2.25 / 2.75) * amount + 0.9375;
          } else {
            return 7.5625 * (amount -= 2.625 / 2.75) * amount + 0.984375;
          }
        },
        InOut: function(amount) {
          if (amount < 0.5) {
            return Easing2.Bounce.In(amount * 2) * 0.5;
          }
          return Easing2.Bounce.Out(amount * 2 - 1) * 0.5 + 0.5;
        }
      }
    };
    var now;
    if (typeof self === "undefined" && typeof process !== "undefined" && process.hrtime) {
      now = function() {
        var time = process.hrtime();
        return time[0] * 1e3 + time[1] / 1e6;
      };
    } else if (typeof self !== "undefined" && self.performance !== void 0 && self.performance.now !== void 0) {
      now = self.performance.now.bind(self.performance);
    } else if (Date.now !== void 0) {
      now = Date.now;
    } else {
      now = function() {
        return new Date().getTime();
      };
    }
    var now$1 = now;
    var Group = function() {
      function Group2() {
        this._tweens = {};
        this._tweensAddedDuringUpdate = {};
      }
      Group2.prototype.getAll = function() {
        var _this = this;
        return Object.keys(this._tweens).map(function(tweenId) {
          return _this._tweens[tweenId];
        });
      };
      Group2.prototype.removeAll = function() {
        this._tweens = {};
      };
      Group2.prototype.add = function(tween) {
        this._tweens[tween.getId()] = tween;
        this._tweensAddedDuringUpdate[tween.getId()] = tween;
      };
      Group2.prototype.remove = function(tween) {
        delete this._tweens[tween.getId()];
        delete this._tweensAddedDuringUpdate[tween.getId()];
      };
      Group2.prototype.update = function(time, preserve) {
        if (time === void 0) {
          time = now$1();
        }
        if (preserve === void 0) {
          preserve = false;
        }
        var tweenIds = Object.keys(this._tweens);
        if (tweenIds.length === 0) {
          return false;
        }
        while (tweenIds.length > 0) {
          this._tweensAddedDuringUpdate = {};
          for (var i = 0; i < tweenIds.length; i++) {
            var tween = this._tweens[tweenIds[i]];
            var autoStart = !preserve;
            if (tween && tween.update(time, autoStart) === false && !preserve) {
              delete this._tweens[tweenIds[i]];
            }
          }
          tweenIds = Object.keys(this._tweensAddedDuringUpdate);
        }
        return true;
      };
      return Group2;
    }();
    var Interpolation = {
      Linear: function(v7, k) {
        var m = v7.length - 1;
        var f = m * k;
        var i = Math.floor(f);
        var fn = Interpolation.Utils.Linear;
        if (k < 0) {
          return fn(v7[0], v7[1], f);
        }
        if (k > 1) {
          return fn(v7[m], v7[m - 1], m - f);
        }
        return fn(v7[i], v7[i + 1 > m ? m : i + 1], f - i);
      },
      Bezier: function(v7, k) {
        var b = 0;
        var n = v7.length - 1;
        var pw = Math.pow;
        var bn = Interpolation.Utils.Bernstein;
        for (var i = 0; i <= n; i++) {
          b += pw(1 - k, n - i) * pw(k, i) * v7[i] * bn(n, i);
        }
        return b;
      },
      CatmullRom: function(v7, k) {
        var m = v7.length - 1;
        var f = m * k;
        var i = Math.floor(f);
        var fn = Interpolation.Utils.CatmullRom;
        if (v7[0] === v7[m]) {
          if (k < 0) {
            i = Math.floor(f = m * (1 + k));
          }
          return fn(v7[(i - 1 + m) % m], v7[i], v7[(i + 1) % m], v7[(i + 2) % m], f - i);
        } else {
          if (k < 0) {
            return v7[0] - (fn(v7[0], v7[0], v7[1], v7[1], -f) - v7[0]);
          }
          if (k > 1) {
            return v7[m] - (fn(v7[m], v7[m], v7[m - 1], v7[m - 1], f - m) - v7[m]);
          }
          return fn(v7[i ? i - 1 : 0], v7[i], v7[m < i + 1 ? m : i + 1], v7[m < i + 2 ? m : i + 2], f - i);
        }
      },
      Utils: {
        Linear: function(p0, p1, t) {
          return (p1 - p0) * t + p0;
        },
        Bernstein: function(n, i) {
          var fc = Interpolation.Utils.Factorial;
          return fc(n) / fc(i) / fc(n - i);
        },
        Factorial: function() {
          var a3 = [1];
          return function(n) {
            var s = 1;
            if (a3[n]) {
              return a3[n];
            }
            for (var i = n; i > 1; i--) {
              s *= i;
            }
            a3[n] = s;
            return s;
          };
        }(),
        CatmullRom: function(p0, p1, p2, p3, t) {
          var v02 = (p2 - p0) * 0.5;
          var v13 = (p3 - p1) * 0.5;
          var t2 = t * t;
          var t3 = t * t2;
          return (2 * p1 - 2 * p2 + v02 + v13) * t3 + (-3 * p1 + 3 * p2 - 2 * v02 - v13) * t2 + v02 * t + p1;
        }
      }
    };
    var Sequence = function() {
      function Sequence2() {
      }
      Sequence2.nextId = function() {
        return Sequence2._nextId++;
      };
      Sequence2._nextId = 0;
      return Sequence2;
    }();
    var mainGroup = new Group();
    var Tween2 = function() {
      function Tween3(_object, _group) {
        if (_group === void 0) {
          _group = mainGroup;
        }
        this._object = _object;
        this._group = _group;
        this._isPaused = false;
        this._pauseStart = 0;
        this._valuesStart = {};
        this._valuesEnd = {};
        this._valuesStartRepeat = {};
        this._duration = 1e3;
        this._initialRepeat = 0;
        this._repeat = 0;
        this._yoyo = false;
        this._isPlaying = false;
        this._reversed = false;
        this._delayTime = 0;
        this._startTime = 0;
        this._easingFunction = Easing2.Linear.None;
        this._interpolationFunction = Interpolation.Linear;
        this._chainedTweens = [];
        this._onStartCallbackFired = false;
        this._id = Sequence.nextId();
        this._isChainStopped = false;
        this._goToEnd = false;
      }
      Tween3.prototype.getId = function() {
        return this._id;
      };
      Tween3.prototype.isPlaying = function() {
        return this._isPlaying;
      };
      Tween3.prototype.isPaused = function() {
        return this._isPaused;
      };
      Tween3.prototype.to = function(properties, duration) {
        this._valuesEnd = Object.create(properties);
        if (duration !== void 0) {
          this._duration = duration;
        }
        return this;
      };
      Tween3.prototype.duration = function(d) {
        this._duration = d;
        return this;
      };
      Tween3.prototype.start = function(time) {
        if (this._isPlaying) {
          return this;
        }
        this._group && this._group.add(this);
        this._repeat = this._initialRepeat;
        if (this._reversed) {
          this._reversed = false;
          for (var property in this._valuesStartRepeat) {
            this._swapEndStartRepeatValues(property);
            this._valuesStart[property] = this._valuesStartRepeat[property];
          }
        }
        this._isPlaying = true;
        this._isPaused = false;
        this._onStartCallbackFired = false;
        this._isChainStopped = false;
        this._startTime = time !== void 0 ? typeof time === "string" ? now$1() + parseFloat(time) : time : now$1();
        this._startTime += this._delayTime;
        this._setupProperties(this._object, this._valuesStart, this._valuesEnd, this._valuesStartRepeat);
        return this;
      };
      Tween3.prototype._setupProperties = function(_object, _valuesStart, _valuesEnd, _valuesStartRepeat) {
        for (var property in _valuesEnd) {
          var startValue = _object[property];
          var startValueIsArray = Array.isArray(startValue);
          var propType = startValueIsArray ? "array" : typeof startValue;
          var isInterpolationList = !startValueIsArray && Array.isArray(_valuesEnd[property]);
          if (propType === "undefined" || propType === "function") {
            continue;
          }
          if (isInterpolationList) {
            var endValues = _valuesEnd[property];
            if (endValues.length === 0) {
              continue;
            }
            endValues = endValues.map(this._handleRelativeValue.bind(this, startValue));
            _valuesEnd[property] = [startValue].concat(endValues);
          }
          if ((propType === "object" || startValueIsArray) && startValue && !isInterpolationList) {
            _valuesStart[property] = startValueIsArray ? [] : {};
            for (var prop in startValue) {
              _valuesStart[property][prop] = startValue[prop];
            }
            _valuesStartRepeat[property] = startValueIsArray ? [] : {};
            this._setupProperties(startValue, _valuesStart[property], _valuesEnd[property], _valuesStartRepeat[property]);
          } else {
            if (typeof _valuesStart[property] === "undefined") {
              _valuesStart[property] = startValue;
            }
            if (!startValueIsArray) {
              _valuesStart[property] *= 1;
            }
            if (isInterpolationList) {
              _valuesStartRepeat[property] = _valuesEnd[property].slice().reverse();
            } else {
              _valuesStartRepeat[property] = _valuesStart[property] || 0;
            }
          }
        }
      };
      Tween3.prototype.stop = function() {
        if (!this._isChainStopped) {
          this._isChainStopped = true;
          this.stopChainedTweens();
        }
        if (!this._isPlaying) {
          return this;
        }
        this._group && this._group.remove(this);
        this._isPlaying = false;
        this._isPaused = false;
        if (this._onStopCallback) {
          this._onStopCallback(this._object);
        }
        return this;
      };
      Tween3.prototype.end = function() {
        this._goToEnd = true;
        this.update(Infinity);
        return this;
      };
      Tween3.prototype.pause = function(time) {
        if (time === void 0) {
          time = now$1();
        }
        if (this._isPaused || !this._isPlaying) {
          return this;
        }
        this._isPaused = true;
        this._pauseStart = time;
        this._group && this._group.remove(this);
        return this;
      };
      Tween3.prototype.resume = function(time) {
        if (time === void 0) {
          time = now$1();
        }
        if (!this._isPaused || !this._isPlaying) {
          return this;
        }
        this._isPaused = false;
        this._startTime += time - this._pauseStart;
        this._pauseStart = 0;
        this._group && this._group.add(this);
        return this;
      };
      Tween3.prototype.stopChainedTweens = function() {
        for (var i = 0, numChainedTweens = this._chainedTweens.length; i < numChainedTweens; i++) {
          this._chainedTweens[i].stop();
        }
        return this;
      };
      Tween3.prototype.group = function(group) {
        this._group = group;
        return this;
      };
      Tween3.prototype.delay = function(amount) {
        this._delayTime = amount;
        return this;
      };
      Tween3.prototype.repeat = function(times) {
        this._initialRepeat = times;
        this._repeat = times;
        return this;
      };
      Tween3.prototype.repeatDelay = function(amount) {
        this._repeatDelayTime = amount;
        return this;
      };
      Tween3.prototype.yoyo = function(yoyo) {
        this._yoyo = yoyo;
        return this;
      };
      Tween3.prototype.easing = function(easingFunction) {
        this._easingFunction = easingFunction;
        return this;
      };
      Tween3.prototype.interpolation = function(interpolationFunction) {
        this._interpolationFunction = interpolationFunction;
        return this;
      };
      Tween3.prototype.chain = function() {
        var tweens = [];
        for (var _i = 0; _i < arguments.length; _i++) {
          tweens[_i] = arguments[_i];
        }
        this._chainedTweens = tweens;
        return this;
      };
      Tween3.prototype.onStart = function(callback) {
        this._onStartCallback = callback;
        return this;
      };
      Tween3.prototype.onUpdate = function(callback) {
        this._onUpdateCallback = callback;
        return this;
      };
      Tween3.prototype.onRepeat = function(callback) {
        this._onRepeatCallback = callback;
        return this;
      };
      Tween3.prototype.onComplete = function(callback) {
        this._onCompleteCallback = callback;
        return this;
      };
      Tween3.prototype.onStop = function(callback) {
        this._onStopCallback = callback;
        return this;
      };
      Tween3.prototype.update = function(time, autoStart) {
        if (time === void 0) {
          time = now$1();
        }
        if (autoStart === void 0) {
          autoStart = true;
        }
        if (this._isPaused)
          return true;
        var property;
        var elapsed;
        var endTime = this._startTime + this._duration;
        if (!this._goToEnd && !this._isPlaying) {
          if (time > endTime)
            return false;
          if (autoStart)
            this.start(time);
        }
        this._goToEnd = false;
        if (time < this._startTime) {
          return true;
        }
        if (this._onStartCallbackFired === false) {
          if (this._onStartCallback) {
            this._onStartCallback(this._object);
          }
          this._onStartCallbackFired = true;
        }
        elapsed = (time - this._startTime) / this._duration;
        elapsed = this._duration === 0 || elapsed > 1 ? 1 : elapsed;
        var value = this._easingFunction(elapsed);
        this._updateProperties(this._object, this._valuesStart, this._valuesEnd, value);
        if (this._onUpdateCallback) {
          this._onUpdateCallback(this._object, elapsed);
        }
        if (elapsed === 1) {
          if (this._repeat > 0) {
            if (isFinite(this._repeat)) {
              this._repeat--;
            }
            for (property in this._valuesStartRepeat) {
              if (!this._yoyo && typeof this._valuesEnd[property] === "string") {
                this._valuesStartRepeat[property] = this._valuesStartRepeat[property] + parseFloat(this._valuesEnd[property]);
              }
              if (this._yoyo) {
                this._swapEndStartRepeatValues(property);
              }
              this._valuesStart[property] = this._valuesStartRepeat[property];
            }
            if (this._yoyo) {
              this._reversed = !this._reversed;
            }
            if (this._repeatDelayTime !== void 0) {
              this._startTime = time + this._repeatDelayTime;
            } else {
              this._startTime = time + this._delayTime;
            }
            if (this._onRepeatCallback) {
              this._onRepeatCallback(this._object);
            }
            return true;
          } else {
            if (this._onCompleteCallback) {
              this._onCompleteCallback(this._object);
            }
            for (var i = 0, numChainedTweens = this._chainedTweens.length; i < numChainedTweens; i++) {
              this._chainedTweens[i].start(this._startTime + this._duration);
            }
            this._isPlaying = false;
            return false;
          }
        }
        return true;
      };
      Tween3.prototype._updateProperties = function(_object, _valuesStart, _valuesEnd, value) {
        for (var property in _valuesEnd) {
          if (_valuesStart[property] === void 0) {
            continue;
          }
          var start = _valuesStart[property] || 0;
          var end = _valuesEnd[property];
          var startIsArray = Array.isArray(_object[property]);
          var endIsArray = Array.isArray(end);
          var isInterpolationList = !startIsArray && endIsArray;
          if (isInterpolationList) {
            _object[property] = this._interpolationFunction(end, value);
          } else if (typeof end === "object" && end) {
            this._updateProperties(_object[property], start, end, value);
          } else {
            end = this._handleRelativeValue(start, end);
            if (typeof end === "number") {
              _object[property] = start + (end - start) * value;
            }
          }
        }
      };
      Tween3.prototype._handleRelativeValue = function(start, end) {
        if (typeof end !== "string") {
          return end;
        }
        if (end.charAt(0) === "+" || end.charAt(0) === "-") {
          return start + parseFloat(end);
        } else {
          return parseFloat(end);
        }
      };
      Tween3.prototype._swapEndStartRepeatValues = function(property) {
        var tmp2 = this._valuesStartRepeat[property];
        var endValue = this._valuesEnd[property];
        if (typeof endValue === "string") {
          this._valuesStartRepeat[property] = this._valuesStartRepeat[property] + parseFloat(endValue);
        } else {
          this._valuesStartRepeat[property] = this._valuesEnd[property];
        }
        this._valuesEnd[property] = tmp2;
      };
      return Tween3;
    }();
    var VERSION2 = "18.6.4";
    var nextId = Sequence.nextId;
    var TWEEN = mainGroup;
    var getAll = TWEEN.getAll.bind(TWEEN);
    var removeAll = TWEEN.removeAll.bind(TWEEN);
    var add = TWEEN.add.bind(TWEEN);
    var remove3 = TWEEN.remove.bind(TWEEN);
    var update7 = TWEEN.update.bind(TWEEN);
    var exports$1 = {
      Easing: Easing2,
      Group,
      Interpolation,
      now: now$1,
      Sequence,
      nextId,
      Tween: Tween2,
      VERSION: VERSION2,
      getAll,
      removeAll,
      add,
      remove: remove3,
      update: update7
    };
    exports2.Easing = Easing2;
    exports2.Group = Group;
    exports2.Interpolation = Interpolation;
    exports2.Sequence = Sequence;
    exports2.Tween = Tween2;
    exports2.VERSION = VERSION2;
    exports2.add = add;
    exports2.default = exports$1;
    exports2.getAll = getAll;
    exports2.nextId = nextId;
    exports2.now = now$1;
    exports2.remove = remove3;
    exports2.removeAll = removeAll;
    exports2.update = update7;
  }
});

// node_modules/protobufjs/dist/minimal/protobuf.js
var require_protobuf = __commonJS({
  "node_modules/protobufjs/dist/minimal/protobuf.js"(exports, module) {
    /*!
     * protobuf.js v6.10.2 (c) 2016, daniel wirtz
     * compiled fri, 08 jul 2022 16:17:13 utc
     * licensed under the bsd-3-clause license
     * see: https://github.com/dcodeio/protobuf.js for details
     */
    (function(undefined) {
      "use strict";
      (function prelude(modules, cache, entries) {
        function $require(name) {
          var $module = cache[name];
          if (!$module)
            modules[name][0].call($module = cache[name] = { exports: {} }, $require, $module, $module.exports);
          return $module.exports;
        }
        var protobuf3 = $require(entries[0]);
        protobuf3.util.global.protobuf = protobuf3;
        if (typeof define === "function" && define.amd)
          define(["long"], function(Long) {
            if (Long && Long.isLong) {
              protobuf3.util.Long = Long;
              protobuf3.configure();
            }
            return protobuf3;
          });
        if (typeof module === "object" && module && module.exports)
          module.exports = protobuf3;
      })({ 1: [function(require2, module2, exports2) {
        "use strict";
        module2.exports = asPromise;
        function asPromise(fn, ctx) {
          var params = new Array(arguments.length - 1), offset2 = 0, index = 2, pending = true;
          while (index < arguments.length)
            params[offset2++] = arguments[index++];
          return new Promise(function executor(resolve2, reject) {
            params[offset2] = function callback(err) {
              if (pending) {
                pending = false;
                if (err)
                  reject(err);
                else {
                  var params2 = new Array(arguments.length - 1), offset3 = 0;
                  while (offset3 < params2.length)
                    params2[offset3++] = arguments[offset3];
                  resolve2.apply(null, params2);
                }
              }
            };
            try {
              fn.apply(ctx || null, params);
            } catch (err) {
              if (pending) {
                pending = false;
                reject(err);
              }
            }
          });
        }
      }, {}], 2: [function(require2, module2, exports2) {
        "use strict";
        var base64 = exports2;
        base64.length = function length3(string) {
          var p = string.length;
          if (!p)
            return 0;
          var n = 0;
          while (--p % 4 > 1 && string.charAt(p) === "=")
            ++n;
          return Math.ceil(string.length * 3) / 4 - n;
        };
        var b64 = new Array(64);
        var s64 = new Array(123);
        for (var i = 0; i < 64; )
          s64[b64[i] = i < 26 ? i + 65 : i < 52 ? i + 71 : i < 62 ? i - 4 : i - 59 | 43] = i++;
        base64.encode = function encode(buffer, start, end) {
          var parts = null, chunk = [];
          var i2 = 0, j = 0, t;
          while (start < end) {
            var b = buffer[start++];
            switch (j) {
              case 0:
                chunk[i2++] = b64[b >> 2];
                t = (b & 3) << 4;
                j = 1;
                break;
              case 1:
                chunk[i2++] = b64[t | b >> 4];
                t = (b & 15) << 2;
                j = 2;
                break;
              case 2:
                chunk[i2++] = b64[t | b >> 6];
                chunk[i2++] = b64[b & 63];
                j = 0;
                break;
            }
            if (i2 > 8191) {
              (parts || (parts = [])).push(String.fromCharCode.apply(String, chunk));
              i2 = 0;
            }
          }
          if (j) {
            chunk[i2++] = b64[t];
            chunk[i2++] = 61;
            if (j === 1)
              chunk[i2++] = 61;
          }
          if (parts) {
            if (i2)
              parts.push(String.fromCharCode.apply(String, chunk.slice(0, i2)));
            return parts.join("");
          }
          return String.fromCharCode.apply(String, chunk.slice(0, i2));
        };
        var invalidEncoding = "invalid encoding";
        base64.decode = function decode(string, buffer, offset2) {
          var start = offset2;
          var j = 0, t;
          for (var i2 = 0; i2 < string.length; ) {
            var c = string.charCodeAt(i2++);
            if (c === 61 && j > 1)
              break;
            if ((c = s64[c]) === undefined)
              throw Error(invalidEncoding);
            switch (j) {
              case 0:
                t = c;
                j = 1;
                break;
              case 1:
                buffer[offset2++] = t << 2 | (c & 48) >> 4;
                t = c;
                j = 2;
                break;
              case 2:
                buffer[offset2++] = (t & 15) << 4 | (c & 60) >> 2;
                t = c;
                j = 3;
                break;
              case 3:
                buffer[offset2++] = (t & 3) << 6 | c;
                j = 0;
                break;
            }
          }
          if (j === 1)
            throw Error(invalidEncoding);
          return offset2 - start;
        };
        base64.test = function test(string) {
          return /^(?:[A-Za-z0-9+/]{4})*(?:[A-Za-z0-9+/]{2}==|[A-Za-z0-9+/]{3}=)?$/.test(string);
        };
      }, {}], 3: [function(require2, module2, exports2) {
        "use strict";
        module2.exports = EventEmitter;
        function EventEmitter() {
          this._listeners = {};
        }
        EventEmitter.prototype.on = function on(evt, fn, ctx) {
          (this._listeners[evt] || (this._listeners[evt] = [])).push({
            fn,
            ctx: ctx || this
          });
          return this;
        };
        EventEmitter.prototype.off = function off(evt, fn) {
          if (evt === undefined)
            this._listeners = {};
          else {
            if (fn === undefined)
              this._listeners[evt] = [];
            else {
              var listeners = this._listeners[evt];
              for (var i = 0; i < listeners.length; )
                if (listeners[i].fn === fn)
                  listeners.splice(i, 1);
                else
                  ++i;
            }
          }
          return this;
        };
        EventEmitter.prototype.emit = function emit(evt) {
          var listeners = this._listeners[evt];
          if (listeners) {
            var args = [], i = 1;
            for (; i < arguments.length; )
              args.push(arguments[i++]);
            for (i = 0; i < listeners.length; )
              listeners[i].fn.apply(listeners[i++].ctx, args);
          }
          return this;
        };
      }, {}], 4: [function(require2, module2, exports2) {
        "use strict";
        module2.exports = factory(factory);
        function factory(exports3) {
          if (typeof Float32Array !== "undefined")
            (function() {
              var f32 = new Float32Array([-0]), f8b = new Uint8Array(f32.buffer), le = f8b[3] === 128;
              function writeFloat_f32_cpy(val, buf, pos) {
                f32[0] = val;
                buf[pos] = f8b[0];
                buf[pos + 1] = f8b[1];
                buf[pos + 2] = f8b[2];
                buf[pos + 3] = f8b[3];
              }
              function writeFloat_f32_rev(val, buf, pos) {
                f32[0] = val;
                buf[pos] = f8b[3];
                buf[pos + 1] = f8b[2];
                buf[pos + 2] = f8b[1];
                buf[pos + 3] = f8b[0];
              }
              exports3.writeFloatLE = le ? writeFloat_f32_cpy : writeFloat_f32_rev;
              exports3.writeFloatBE = le ? writeFloat_f32_rev : writeFloat_f32_cpy;
              function readFloat_f32_cpy(buf, pos) {
                f8b[0] = buf[pos];
                f8b[1] = buf[pos + 1];
                f8b[2] = buf[pos + 2];
                f8b[3] = buf[pos + 3];
                return f32[0];
              }
              function readFloat_f32_rev(buf, pos) {
                f8b[3] = buf[pos];
                f8b[2] = buf[pos + 1];
                f8b[1] = buf[pos + 2];
                f8b[0] = buf[pos + 3];
                return f32[0];
              }
              exports3.readFloatLE = le ? readFloat_f32_cpy : readFloat_f32_rev;
              exports3.readFloatBE = le ? readFloat_f32_rev : readFloat_f32_cpy;
            })();
          else
            (function() {
              function writeFloat_ieee754(writeUint, val, buf, pos) {
                var sign2 = val < 0 ? 1 : 0;
                if (sign2)
                  val = -val;
                if (val === 0)
                  writeUint(1 / val > 0 ? 0 : 2147483648, buf, pos);
                else if (isNaN(val))
                  writeUint(2143289344, buf, pos);
                else if (val > 34028234663852886e22)
                  writeUint((sign2 << 31 | 2139095040) >>> 0, buf, pos);
                else if (val < 11754943508222875e-54)
                  writeUint((sign2 << 31 | Math.round(val / 1401298464324817e-60)) >>> 0, buf, pos);
                else {
                  var exponent = Math.floor(Math.log(val) / Math.LN2), mantissa = Math.round(val * Math.pow(2, -exponent) * 8388608) & 8388607;
                  writeUint((sign2 << 31 | exponent + 127 << 23 | mantissa) >>> 0, buf, pos);
                }
              }
              exports3.writeFloatLE = writeFloat_ieee754.bind(null, writeUintLE);
              exports3.writeFloatBE = writeFloat_ieee754.bind(null, writeUintBE);
              function readFloat_ieee754(readUint, buf, pos) {
                var uint = readUint(buf, pos), sign2 = (uint >> 31) * 2 + 1, exponent = uint >>> 23 & 255, mantissa = uint & 8388607;
                return exponent === 255 ? mantissa ? NaN : sign2 * Infinity : exponent === 0 ? sign2 * 1401298464324817e-60 * mantissa : sign2 * Math.pow(2, exponent - 150) * (mantissa + 8388608);
              }
              exports3.readFloatLE = readFloat_ieee754.bind(null, readUintLE);
              exports3.readFloatBE = readFloat_ieee754.bind(null, readUintBE);
            })();
          if (typeof Float64Array !== "undefined")
            (function() {
              var f64 = new Float64Array([-0]), f8b = new Uint8Array(f64.buffer), le = f8b[7] === 128;
              function writeDouble_f64_cpy(val, buf, pos) {
                f64[0] = val;
                buf[pos] = f8b[0];
                buf[pos + 1] = f8b[1];
                buf[pos + 2] = f8b[2];
                buf[pos + 3] = f8b[3];
                buf[pos + 4] = f8b[4];
                buf[pos + 5] = f8b[5];
                buf[pos + 6] = f8b[6];
                buf[pos + 7] = f8b[7];
              }
              function writeDouble_f64_rev(val, buf, pos) {
                f64[0] = val;
                buf[pos] = f8b[7];
                buf[pos + 1] = f8b[6];
                buf[pos + 2] = f8b[5];
                buf[pos + 3] = f8b[4];
                buf[pos + 4] = f8b[3];
                buf[pos + 5] = f8b[2];
                buf[pos + 6] = f8b[1];
                buf[pos + 7] = f8b[0];
              }
              exports3.writeDoubleLE = le ? writeDouble_f64_cpy : writeDouble_f64_rev;
              exports3.writeDoubleBE = le ? writeDouble_f64_rev : writeDouble_f64_cpy;
              function readDouble_f64_cpy(buf, pos) {
                f8b[0] = buf[pos];
                f8b[1] = buf[pos + 1];
                f8b[2] = buf[pos + 2];
                f8b[3] = buf[pos + 3];
                f8b[4] = buf[pos + 4];
                f8b[5] = buf[pos + 5];
                f8b[6] = buf[pos + 6];
                f8b[7] = buf[pos + 7];
                return f64[0];
              }
              function readDouble_f64_rev(buf, pos) {
                f8b[7] = buf[pos];
                f8b[6] = buf[pos + 1];
                f8b[5] = buf[pos + 2];
                f8b[4] = buf[pos + 3];
                f8b[3] = buf[pos + 4];
                f8b[2] = buf[pos + 5];
                f8b[1] = buf[pos + 6];
                f8b[0] = buf[pos + 7];
                return f64[0];
              }
              exports3.readDoubleLE = le ? readDouble_f64_cpy : readDouble_f64_rev;
              exports3.readDoubleBE = le ? readDouble_f64_rev : readDouble_f64_cpy;
            })();
          else
            (function() {
              function writeDouble_ieee754(writeUint, off0, off1, val, buf, pos) {
                var sign2 = val < 0 ? 1 : 0;
                if (sign2)
                  val = -val;
                if (val === 0) {
                  writeUint(0, buf, pos + off0);
                  writeUint(1 / val > 0 ? 0 : 2147483648, buf, pos + off1);
                } else if (isNaN(val)) {
                  writeUint(0, buf, pos + off0);
                  writeUint(2146959360, buf, pos + off1);
                } else if (val > 17976931348623157e292) {
                  writeUint(0, buf, pos + off0);
                  writeUint((sign2 << 31 | 2146435072) >>> 0, buf, pos + off1);
                } else {
                  var mantissa;
                  if (val < 22250738585072014e-324) {
                    mantissa = val / 5e-324;
                    writeUint(mantissa >>> 0, buf, pos + off0);
                    writeUint((sign2 << 31 | mantissa / 4294967296) >>> 0, buf, pos + off1);
                  } else {
                    var exponent = Math.floor(Math.log(val) / Math.LN2);
                    if (exponent === 1024)
                      exponent = 1023;
                    mantissa = val * Math.pow(2, -exponent);
                    writeUint(mantissa * 4503599627370496 >>> 0, buf, pos + off0);
                    writeUint((sign2 << 31 | exponent + 1023 << 20 | mantissa * 1048576 & 1048575) >>> 0, buf, pos + off1);
                  }
                }
              }
              exports3.writeDoubleLE = writeDouble_ieee754.bind(null, writeUintLE, 0, 4);
              exports3.writeDoubleBE = writeDouble_ieee754.bind(null, writeUintBE, 4, 0);
              function readDouble_ieee754(readUint, off0, off1, buf, pos) {
                var lo = readUint(buf, pos + off0), hi = readUint(buf, pos + off1);
                var sign2 = (hi >> 31) * 2 + 1, exponent = hi >>> 20 & 2047, mantissa = 4294967296 * (hi & 1048575) + lo;
                return exponent === 2047 ? mantissa ? NaN : sign2 * Infinity : exponent === 0 ? sign2 * 5e-324 * mantissa : sign2 * Math.pow(2, exponent - 1075) * (mantissa + 4503599627370496);
              }
              exports3.readDoubleLE = readDouble_ieee754.bind(null, readUintLE, 0, 4);
              exports3.readDoubleBE = readDouble_ieee754.bind(null, readUintBE, 4, 0);
            })();
          return exports3;
        }
        function writeUintLE(val, buf, pos) {
          buf[pos] = val & 255;
          buf[pos + 1] = val >>> 8 & 255;
          buf[pos + 2] = val >>> 16 & 255;
          buf[pos + 3] = val >>> 24;
        }
        function writeUintBE(val, buf, pos) {
          buf[pos] = val >>> 24;
          buf[pos + 1] = val >>> 16 & 255;
          buf[pos + 2] = val >>> 8 & 255;
          buf[pos + 3] = val & 255;
        }
        function readUintLE(buf, pos) {
          return (buf[pos] | buf[pos + 1] << 8 | buf[pos + 2] << 16 | buf[pos + 3] << 24) >>> 0;
        }
        function readUintBE(buf, pos) {
          return (buf[pos] << 24 | buf[pos + 1] << 16 | buf[pos + 2] << 8 | buf[pos + 3]) >>> 0;
        }
      }, {}], 5: [function(require, module, exports) {
        "use strict";
        module.exports = inquire;
        function inquire(moduleName) {
          try {
            var mod = eval("quire".replace(/^/, "re"))(moduleName);
            if (mod && (mod.length || Object.keys(mod).length))
              return mod;
          } catch (e) {
          }
          return null;
        }
      }, {}], 6: [function(require2, module2, exports2) {
        "use strict";
        module2.exports = pool2;
        function pool2(alloc, slice, size) {
          var SIZE = size || 8192;
          var MAX = SIZE >>> 1;
          var slab = null;
          var offset2 = SIZE;
          return function pool_alloc(size2) {
            if (size2 < 1 || size2 > MAX)
              return alloc(size2);
            if (offset2 + size2 > SIZE) {
              slab = alloc(SIZE);
              offset2 = 0;
            }
            var buf = slice.call(slab, offset2, offset2 += size2);
            if (offset2 & 7)
              offset2 = (offset2 | 7) + 1;
            return buf;
          };
        }
      }, {}], 7: [function(require2, module2, exports2) {
        "use strict";
        var utf8 = exports2;
        utf8.length = function utf8_length(string) {
          var len = 0, c = 0;
          for (var i = 0; i < string.length; ++i) {
            c = string.charCodeAt(i);
            if (c < 128)
              len += 1;
            else if (c < 2048)
              len += 2;
            else if ((c & 64512) === 55296 && (string.charCodeAt(i + 1) & 64512) === 56320) {
              ++i;
              len += 4;
            } else
              len += 3;
          }
          return len;
        };
        utf8.read = function utf8_read(buffer, start, end) {
          var len = end - start;
          if (len < 1)
            return "";
          var parts = null, chunk = [], i = 0, t;
          while (start < end) {
            t = buffer[start++];
            if (t < 128)
              chunk[i++] = t;
            else if (t > 191 && t < 224)
              chunk[i++] = (t & 31) << 6 | buffer[start++] & 63;
            else if (t > 239 && t < 365) {
              t = ((t & 7) << 18 | (buffer[start++] & 63) << 12 | (buffer[start++] & 63) << 6 | buffer[start++] & 63) - 65536;
              chunk[i++] = 55296 + (t >> 10);
              chunk[i++] = 56320 + (t & 1023);
            } else
              chunk[i++] = (t & 15) << 12 | (buffer[start++] & 63) << 6 | buffer[start++] & 63;
            if (i > 8191) {
              (parts || (parts = [])).push(String.fromCharCode.apply(String, chunk));
              i = 0;
            }
          }
          if (parts) {
            if (i)
              parts.push(String.fromCharCode.apply(String, chunk.slice(0, i)));
            return parts.join("");
          }
          return String.fromCharCode.apply(String, chunk.slice(0, i));
        };
        utf8.write = function utf8_write(string, buffer, offset2) {
          var start = offset2, c14, c22;
          for (var i = 0; i < string.length; ++i) {
            c14 = string.charCodeAt(i);
            if (c14 < 128) {
              buffer[offset2++] = c14;
            } else if (c14 < 2048) {
              buffer[offset2++] = c14 >> 6 | 192;
              buffer[offset2++] = c14 & 63 | 128;
            } else if ((c14 & 64512) === 55296 && ((c22 = string.charCodeAt(i + 1)) & 64512) === 56320) {
              c14 = 65536 + ((c14 & 1023) << 10) + (c22 & 1023);
              ++i;
              buffer[offset2++] = c14 >> 18 | 240;
              buffer[offset2++] = c14 >> 12 & 63 | 128;
              buffer[offset2++] = c14 >> 6 & 63 | 128;
              buffer[offset2++] = c14 & 63 | 128;
            } else {
              buffer[offset2++] = c14 >> 12 | 224;
              buffer[offset2++] = c14 >> 6 & 63 | 128;
              buffer[offset2++] = c14 & 63 | 128;
            }
          }
          return offset2 - start;
        };
      }, {}], 8: [function(require2, module2, exports2) {
        "use strict";
        var protobuf3 = exports2;
        protobuf3.build = "minimal";
        protobuf3.Writer = require2(16);
        protobuf3.BufferWriter = require2(17);
        protobuf3.Reader = require2(9);
        protobuf3.BufferReader = require2(10);
        protobuf3.util = require2(15);
        protobuf3.rpc = require2(12);
        protobuf3.roots = require2(11);
        protobuf3.configure = configure2;
        function configure2() {
          protobuf3.util._configure();
          protobuf3.Writer._configure(protobuf3.BufferWriter);
          protobuf3.Reader._configure(protobuf3.BufferReader);
        }
        configure2();
      }, { "10": 10, "11": 11, "12": 12, "15": 15, "16": 16, "17": 17, "9": 9 }], 9: [function(require2, module2, exports2) {
        "use strict";
        module2.exports = Reader3;
        var util = require2(15);
        var BufferReader;
        var LongBits = util.LongBits, utf8 = util.utf8;
        function indexOutOfRange(reader, writeLength) {
          return RangeError("index out of range: " + reader.pos + " + " + (writeLength || 1) + " > " + reader.len);
        }
        function Reader3(buffer) {
          this.buf = buffer;
          this.pos = 0;
          this.len = buffer.length;
        }
        var create_array = typeof Uint8Array !== "undefined" ? function create_typed_array(buffer) {
          if (buffer instanceof Uint8Array || Array.isArray(buffer))
            return new Reader3(buffer);
          throw Error("illegal buffer");
        } : function create_array2(buffer) {
          if (Array.isArray(buffer))
            return new Reader3(buffer);
          throw Error("illegal buffer");
        };
        var create = function create2() {
          return util.Buffer ? function create_buffer_setup(buffer) {
            return (Reader3.create = function create_buffer(buffer2) {
              return util.Buffer.isBuffer(buffer2) ? new BufferReader(buffer2) : create_array(buffer2);
            })(buffer);
          } : create_array;
        };
        Reader3.create = create();
        Reader3.prototype._slice = util.Array.prototype.subarray || util.Array.prototype.slice;
        Reader3.prototype.uint32 = function read_uint32_setup() {
          var value = 4294967295;
          return function read_uint32() {
            value = (this.buf[this.pos] & 127) >>> 0;
            if (this.buf[this.pos++] < 128)
              return value;
            value = (value | (this.buf[this.pos] & 127) << 7) >>> 0;
            if (this.buf[this.pos++] < 128)
              return value;
            value = (value | (this.buf[this.pos] & 127) << 14) >>> 0;
            if (this.buf[this.pos++] < 128)
              return value;
            value = (value | (this.buf[this.pos] & 127) << 21) >>> 0;
            if (this.buf[this.pos++] < 128)
              return value;
            value = (value | (this.buf[this.pos] & 15) << 28) >>> 0;
            if (this.buf[this.pos++] < 128)
              return value;
            if ((this.pos += 5) > this.len) {
              this.pos = this.len;
              throw indexOutOfRange(this, 10);
            }
            return value;
          };
        }();
        Reader3.prototype.int32 = function read_int32() {
          return this.uint32() | 0;
        };
        Reader3.prototype.sint32 = function read_sint32() {
          var value = this.uint32();
          return value >>> 1 ^ -(value & 1) | 0;
        };
        function readLongVarint() {
          var bits = new LongBits(0, 0);
          var i = 0;
          if (this.len - this.pos > 4) {
            for (; i < 4; ++i) {
              bits.lo = (bits.lo | (this.buf[this.pos] & 127) << i * 7) >>> 0;
              if (this.buf[this.pos++] < 128)
                return bits;
            }
            bits.lo = (bits.lo | (this.buf[this.pos] & 127) << 28) >>> 0;
            bits.hi = (bits.hi | (this.buf[this.pos] & 127) >> 4) >>> 0;
            if (this.buf[this.pos++] < 128)
              return bits;
            i = 0;
          } else {
            for (; i < 3; ++i) {
              if (this.pos >= this.len)
                throw indexOutOfRange(this);
              bits.lo = (bits.lo | (this.buf[this.pos] & 127) << i * 7) >>> 0;
              if (this.buf[this.pos++] < 128)
                return bits;
            }
            bits.lo = (bits.lo | (this.buf[this.pos++] & 127) << i * 7) >>> 0;
            return bits;
          }
          if (this.len - this.pos > 4) {
            for (; i < 5; ++i) {
              bits.hi = (bits.hi | (this.buf[this.pos] & 127) << i * 7 + 3) >>> 0;
              if (this.buf[this.pos++] < 128)
                return bits;
            }
          } else {
            for (; i < 5; ++i) {
              if (this.pos >= this.len)
                throw indexOutOfRange(this);
              bits.hi = (bits.hi | (this.buf[this.pos] & 127) << i * 7 + 3) >>> 0;
              if (this.buf[this.pos++] < 128)
                return bits;
            }
          }
          throw Error("invalid varint encoding");
        }
        Reader3.prototype.bool = function read_bool() {
          return this.uint32() !== 0;
        };
        function readFixed32_end(buf, end) {
          return (buf[end - 4] | buf[end - 3] << 8 | buf[end - 2] << 16 | buf[end - 1] << 24) >>> 0;
        }
        Reader3.prototype.fixed32 = function read_fixed32() {
          if (this.pos + 4 > this.len)
            throw indexOutOfRange(this, 4);
          return readFixed32_end(this.buf, this.pos += 4);
        };
        Reader3.prototype.sfixed32 = function read_sfixed32() {
          if (this.pos + 4 > this.len)
            throw indexOutOfRange(this, 4);
          return readFixed32_end(this.buf, this.pos += 4) | 0;
        };
        function readFixed64() {
          if (this.pos + 8 > this.len)
            throw indexOutOfRange(this, 8);
          return new LongBits(readFixed32_end(this.buf, this.pos += 4), readFixed32_end(this.buf, this.pos += 4));
        }
        Reader3.prototype.float = function read_float() {
          if (this.pos + 4 > this.len)
            throw indexOutOfRange(this, 4);
          var value = util.float.readFloatLE(this.buf, this.pos);
          this.pos += 4;
          return value;
        };
        Reader3.prototype.double = function read_double() {
          if (this.pos + 8 > this.len)
            throw indexOutOfRange(this, 4);
          var value = util.float.readDoubleLE(this.buf, this.pos);
          this.pos += 8;
          return value;
        };
        Reader3.prototype.bytes = function read_bytes() {
          var length3 = this.uint32(), start = this.pos, end = this.pos + length3;
          if (end > this.len)
            throw indexOutOfRange(this, length3);
          this.pos += length3;
          if (Array.isArray(this.buf))
            return this.buf.slice(start, end);
          return start === end ? new this.buf.constructor(0) : this._slice.call(this.buf, start, end);
        };
        Reader3.prototype.string = function read_string() {
          var bytes = this.bytes();
          return utf8.read(bytes, 0, bytes.length);
        };
        Reader3.prototype.skip = function skip(length3) {
          if (typeof length3 === "number") {
            if (this.pos + length3 > this.len)
              throw indexOutOfRange(this, length3);
            this.pos += length3;
          } else {
            do {
              if (this.pos >= this.len)
                throw indexOutOfRange(this);
            } while (this.buf[this.pos++] & 128);
          }
          return this;
        };
        Reader3.prototype.skipType = function(wireType) {
          switch (wireType) {
            case 0:
              this.skip();
              break;
            case 1:
              this.skip(8);
              break;
            case 2:
              this.skip(this.uint32());
              break;
            case 3:
              while ((wireType = this.uint32() & 7) !== 4) {
                this.skipType(wireType);
              }
              break;
            case 5:
              this.skip(4);
              break;
            default:
              throw Error("invalid wire type " + wireType + " at offset " + this.pos);
          }
          return this;
        };
        Reader3._configure = function(BufferReader_) {
          BufferReader = BufferReader_;
          Reader3.create = create();
          BufferReader._configure();
          var fn = util.Long ? "toLong" : "toNumber";
          util.merge(Reader3.prototype, {
            int64: function read_int64() {
              return readLongVarint.call(this)[fn](false);
            },
            uint64: function read_uint64() {
              return readLongVarint.call(this)[fn](true);
            },
            sint64: function read_sint64() {
              return readLongVarint.call(this).zzDecode()[fn](false);
            },
            fixed64: function read_fixed64() {
              return readFixed64.call(this)[fn](true);
            },
            sfixed64: function read_sfixed64() {
              return readFixed64.call(this)[fn](false);
            }
          });
        };
      }, { "15": 15 }], 10: [function(require2, module2, exports2) {
        "use strict";
        module2.exports = BufferReader;
        var Reader3 = require2(9);
        (BufferReader.prototype = Object.create(Reader3.prototype)).constructor = BufferReader;
        var util = require2(15);
        function BufferReader(buffer) {
          Reader3.call(this, buffer);
        }
        BufferReader._configure = function() {
          if (util.Buffer)
            BufferReader.prototype._slice = util.Buffer.prototype.slice;
        };
        BufferReader.prototype.string = function read_string_buffer() {
          var len = this.uint32();
          return this.buf.utf8Slice ? this.buf.utf8Slice(this.pos, this.pos = Math.min(this.pos + len, this.len)) : this.buf.toString("utf-8", this.pos, this.pos = Math.min(this.pos + len, this.len));
        };
        BufferReader._configure();
      }, { "15": 15, "9": 9 }], 11: [function(require2, module2, exports2) {
        "use strict";
        module2.exports = {};
      }, {}], 12: [function(require2, module2, exports2) {
        "use strict";
        var rpc = exports2;
        rpc.Service = require2(13);
      }, { "13": 13 }], 13: [function(require2, module2, exports2) {
        "use strict";
        module2.exports = Service;
        var util = require2(15);
        (Service.prototype = Object.create(util.EventEmitter.prototype)).constructor = Service;
        function Service(rpcImpl, requestDelimited, responseDelimited) {
          if (typeof rpcImpl !== "function")
            throw TypeError("rpcImpl must be a function");
          util.EventEmitter.call(this);
          this.rpcImpl = rpcImpl;
          this.requestDelimited = Boolean(requestDelimited);
          this.responseDelimited = Boolean(responseDelimited);
        }
        Service.prototype.rpcCall = function rpcCall(method, requestCtor, responseCtor, request, callback) {
          if (!request)
            throw TypeError("request must be specified");
          var self2 = this;
          if (!callback)
            return util.asPromise(rpcCall, self2, method, requestCtor, responseCtor, request);
          if (!self2.rpcImpl) {
            setTimeout(function() {
              callback(Error("already ended"));
            }, 0);
            return undefined;
          }
          try {
            return self2.rpcImpl(
              method,
              requestCtor[self2.requestDelimited ? "encodeDelimited" : "encode"](request).finish(),
              function rpcCallback(err, response) {
                if (err) {
                  self2.emit("error", err, method);
                  return callback(err);
                }
                if (response === null) {
                  self2.end(true);
                  return undefined;
                }
                if (!(response instanceof responseCtor)) {
                  try {
                    response = responseCtor[self2.responseDelimited ? "decodeDelimited" : "decode"](response);
                  } catch (err2) {
                    self2.emit("error", err2, method);
                    return callback(err2);
                  }
                }
                self2.emit("data", response, method);
                return callback(null, response);
              }
            );
          } catch (err) {
            self2.emit("error", err, method);
            setTimeout(function() {
              callback(err);
            }, 0);
            return undefined;
          }
        };
        Service.prototype.end = function end(endedByRPC) {
          if (this.rpcImpl) {
            if (!endedByRPC)
              this.rpcImpl(null, null, null);
            this.rpcImpl = null;
            this.emit("end").off();
          }
          return this;
        };
      }, { "15": 15 }], 14: [function(require2, module2, exports2) {
        "use strict";
        module2.exports = LongBits;
        var util = require2(15);
        function LongBits(lo, hi) {
          this.lo = lo >>> 0;
          this.hi = hi >>> 0;
        }
        var zero = LongBits.zero = new LongBits(0, 0);
        zero.toNumber = function() {
          return 0;
        };
        zero.zzEncode = zero.zzDecode = function() {
          return this;
        };
        zero.length = function() {
          return 1;
        };
        var zeroHash = LongBits.zeroHash = "\0\0\0\0\0\0\0\0";
        LongBits.fromNumber = function fromNumber(value) {
          if (value === 0)
            return zero;
          var sign2 = value < 0;
          if (sign2)
            value = -value;
          var lo = value >>> 0, hi = (value - lo) / 4294967296 >>> 0;
          if (sign2) {
            hi = ~hi >>> 0;
            lo = ~lo >>> 0;
            if (++lo > 4294967295) {
              lo = 0;
              if (++hi > 4294967295)
                hi = 0;
            }
          }
          return new LongBits(lo, hi);
        };
        LongBits.from = function from(value) {
          if (typeof value === "number")
            return LongBits.fromNumber(value);
          if (util.isString(value)) {
            if (util.Long)
              value = util.Long.fromString(value);
            else
              return LongBits.fromNumber(parseInt(value, 10));
          }
          return value.low || value.high ? new LongBits(value.low >>> 0, value.high >>> 0) : zero;
        };
        LongBits.prototype.toNumber = function toNumber(unsigned) {
          if (!unsigned && this.hi >>> 31) {
            var lo = ~this.lo + 1 >>> 0, hi = ~this.hi >>> 0;
            if (!lo)
              hi = hi + 1 >>> 0;
            return -(lo + hi * 4294967296);
          }
          return this.lo + this.hi * 4294967296;
        };
        LongBits.prototype.toLong = function toLong(unsigned) {
          return util.Long ? new util.Long(this.lo | 0, this.hi | 0, Boolean(unsigned)) : { low: this.lo | 0, high: this.hi | 0, unsigned: Boolean(unsigned) };
        };
        var charCodeAt = String.prototype.charCodeAt;
        LongBits.fromHash = function fromHash(hash2) {
          if (hash2 === zeroHash)
            return zero;
          return new LongBits(
            (charCodeAt.call(hash2, 0) | charCodeAt.call(hash2, 1) << 8 | charCodeAt.call(hash2, 2) << 16 | charCodeAt.call(hash2, 3) << 24) >>> 0,
            (charCodeAt.call(hash2, 4) | charCodeAt.call(hash2, 5) << 8 | charCodeAt.call(hash2, 6) << 16 | charCodeAt.call(hash2, 7) << 24) >>> 0
          );
        };
        LongBits.prototype.toHash = function toHash() {
          return String.fromCharCode(
            this.lo & 255,
            this.lo >>> 8 & 255,
            this.lo >>> 16 & 255,
            this.lo >>> 24,
            this.hi & 255,
            this.hi >>> 8 & 255,
            this.hi >>> 16 & 255,
            this.hi >>> 24
          );
        };
        LongBits.prototype.zzEncode = function zzEncode() {
          var mask = this.hi >> 31;
          this.hi = ((this.hi << 1 | this.lo >>> 31) ^ mask) >>> 0;
          this.lo = (this.lo << 1 ^ mask) >>> 0;
          return this;
        };
        LongBits.prototype.zzDecode = function zzDecode() {
          var mask = -(this.lo & 1);
          this.lo = ((this.lo >>> 1 | this.hi << 31) ^ mask) >>> 0;
          this.hi = (this.hi >>> 1 ^ mask) >>> 0;
          return this;
        };
        LongBits.prototype.length = function length3() {
          var part0 = this.lo, part1 = (this.lo >>> 28 | this.hi << 4) >>> 0, part2 = this.hi >>> 24;
          return part2 === 0 ? part1 === 0 ? part0 < 16384 ? part0 < 128 ? 1 : 2 : part0 < 2097152 ? 3 : 4 : part1 < 16384 ? part1 < 128 ? 5 : 6 : part1 < 2097152 ? 7 : 8 : part2 < 128 ? 9 : 10;
        };
      }, { "15": 15 }], 15: [function(require2, module2, exports2) {
        "use strict";
        var util = exports2;
        util.asPromise = require2(1);
        util.base64 = require2(2);
        util.EventEmitter = require2(3);
        util.float = require2(4);
        util.inquire = require2(5);
        util.utf8 = require2(7);
        util.pool = require2(6);
        util.LongBits = require2(14);
        util.isNode = Boolean(typeof global !== "undefined" && global && global.process && global.process.versions && global.process.versions.node);
        util.global = util.isNode && global || typeof window !== "undefined" && window || typeof self !== "undefined" && self || this;
        util.emptyArray = Object.freeze ? Object.freeze([]) : [];
        util.emptyObject = Object.freeze ? Object.freeze({}) : {};
        util.isInteger = Number.isInteger || function isInteger(value) {
          return typeof value === "number" && isFinite(value) && Math.floor(value) === value;
        };
        util.isString = function isString(value) {
          return typeof value === "string" || value instanceof String;
        };
        util.isObject = function isObject(value) {
          return value && typeof value === "object";
        };
        util.isset = util.isSet = function isSet(obj, prop) {
          var value = obj[prop];
          if (value != null && obj.hasOwnProperty(prop))
            return typeof value !== "object" || (Array.isArray(value) ? value.length : Object.keys(value).length) > 0;
          return false;
        };
        util.Buffer = function() {
          try {
            var Buffer3 = util.inquire("buffer").Buffer;
            return Buffer3.prototype.utf8Write ? Buffer3 : null;
          } catch (e) {
            return null;
          }
        }();
        util._Buffer_from = null;
        util._Buffer_allocUnsafe = null;
        util.newBuffer = function newBuffer(sizeOrArray) {
          return typeof sizeOrArray === "number" ? util.Buffer ? util._Buffer_allocUnsafe(sizeOrArray) : new util.Array(sizeOrArray) : util.Buffer ? util._Buffer_from(sizeOrArray) : typeof Uint8Array === "undefined" ? sizeOrArray : new Uint8Array(sizeOrArray);
        };
        util.Array = typeof Uint8Array !== "undefined" ? Uint8Array : Array;
        util.Long = util.global.dcodeIO && util.global.dcodeIO.Long || util.global.Long || util.inquire("long");
        util.key2Re = /^true|false|0|1$/;
        util.key32Re = /^-?(?:0|[1-9][0-9]*)$/;
        util.key64Re = /^(?:[\\x00-\\xff]{8}|-?(?:0|[1-9][0-9]*))$/;
        util.longToHash = function longToHash(value) {
          return value ? util.LongBits.from(value).toHash() : util.LongBits.zeroHash;
        };
        util.longFromHash = function longFromHash(hash2, unsigned) {
          var bits = util.LongBits.fromHash(hash2);
          if (util.Long)
            return util.Long.fromBits(bits.lo, bits.hi, unsigned);
          return bits.toNumber(Boolean(unsigned));
        };
        function merge2(dst, src, ifNotSet) {
          for (var keys = Object.keys(src), i = 0; i < keys.length; ++i)
            if (dst[keys[i]] === undefined || !ifNotSet)
              dst[keys[i]] = src[keys[i]];
          return dst;
        }
        util.merge = merge2;
        util.lcFirst = function lcFirst(str) {
          return str.charAt(0).toLowerCase() + str.substring(1);
        };
        function newError(name) {
          function CustomError(message, properties) {
            if (!(this instanceof CustomError))
              return new CustomError(message, properties);
            Object.defineProperty(this, "message", { get: function() {
              return message;
            } });
            if (Error.captureStackTrace)
              Error.captureStackTrace(this, CustomError);
            else
              Object.defineProperty(this, "stack", { value: new Error().stack || "" });
            if (properties)
              merge2(this, properties);
          }
          CustomError.prototype = Object.create(Error.prototype, {
            constructor: {
              value: CustomError,
              writable: true,
              enumerable: false,
              configurable: true
            },
            name: {
              get() {
                return name;
              },
              set: undefined,
              enumerable: false,
              configurable: true
            },
            toString: {
              value() {
                return this.name + ": " + this.message;
              },
              writable: true,
              enumerable: false,
              configurable: true
            }
          });
          return CustomError;
        }
        util.newError = newError;
        util.ProtocolError = newError("ProtocolError");
        util.oneOfGetter = function getOneOf(fieldNames) {
          var fieldMap = {};
          for (var i = 0; i < fieldNames.length; ++i)
            fieldMap[fieldNames[i]] = 1;
          return function() {
            for (var keys = Object.keys(this), i2 = keys.length - 1; i2 > -1; --i2)
              if (fieldMap[keys[i2]] === 1 && this[keys[i2]] !== undefined && this[keys[i2]] !== null)
                return keys[i2];
          };
        };
        util.oneOfSetter = function setOneOf(fieldNames) {
          return function(name) {
            for (var i = 0; i < fieldNames.length; ++i)
              if (fieldNames[i] !== name)
                delete this[fieldNames[i]];
          };
        };
        util.toJSONOptions = {
          longs: String,
          enums: String,
          bytes: String,
          json: true
        };
        util._configure = function() {
          var Buffer3 = util.Buffer;
          if (!Buffer3) {
            util._Buffer_from = util._Buffer_allocUnsafe = null;
            return;
          }
          util._Buffer_from = Buffer3.from !== Uint8Array.from && Buffer3.from || function Buffer_from(value, encoding) {
            return new Buffer3(value, encoding);
          };
          util._Buffer_allocUnsafe = Buffer3.allocUnsafe || function Buffer_allocUnsafe(size) {
            return new Buffer3(size);
          };
        };
      }, { "1": 1, "14": 14, "2": 2, "3": 3, "4": 4, "5": 5, "6": 6, "7": 7 }], 16: [function(require2, module2, exports2) {
        "use strict";
        module2.exports = Writer2;
        var util = require2(15);
        var BufferWriter;
        var LongBits = util.LongBits, base64 = util.base64, utf8 = util.utf8;
        function Op(fn, len, val) {
          this.fn = fn;
          this.len = len;
          this.next = undefined;
          this.val = val;
        }
        function noop() {
        }
        function State(writer) {
          this.head = writer.head;
          this.tail = writer.tail;
          this.len = writer.len;
          this.next = writer.states;
        }
        function Writer2() {
          this.len = 0;
          this.head = new Op(noop, 0, 0);
          this.tail = this.head;
          this.states = null;
        }
        var create = function create2() {
          return util.Buffer ? function create_buffer_setup() {
            return (Writer2.create = function create_buffer() {
              return new BufferWriter();
            })();
          } : function create_array() {
            return new Writer2();
          };
        };
        Writer2.create = create();
        Writer2.alloc = function alloc(size) {
          return new util.Array(size);
        };
        if (util.Array !== Array)
          Writer2.alloc = util.pool(Writer2.alloc, util.Array.prototype.subarray);
        Writer2.prototype._push = function push(fn, len, val) {
          this.tail = this.tail.next = new Op(fn, len, val);
          this.len += len;
          return this;
        };
        function writeByte(val, buf, pos) {
          buf[pos] = val & 255;
        }
        function writeVarint32(val, buf, pos) {
          while (val > 127) {
            buf[pos++] = val & 127 | 128;
            val >>>= 7;
          }
          buf[pos] = val;
        }
        function VarintOp(len, val) {
          this.len = len;
          this.next = undefined;
          this.val = val;
        }
        VarintOp.prototype = Object.create(Op.prototype);
        VarintOp.prototype.fn = writeVarint32;
        Writer2.prototype.uint32 = function write_uint32(value) {
          this.len += (this.tail = this.tail.next = new VarintOp(
            (value = value >>> 0) < 128 ? 1 : value < 16384 ? 2 : value < 2097152 ? 3 : value < 268435456 ? 4 : 5,
            value
          )).len;
          return this;
        };
        Writer2.prototype.int32 = function write_int32(value) {
          return value < 0 ? this._push(writeVarint64, 10, LongBits.fromNumber(value)) : this.uint32(value);
        };
        Writer2.prototype.sint32 = function write_sint32(value) {
          return this.uint32((value << 1 ^ value >> 31) >>> 0);
        };
        function writeVarint64(val, buf, pos) {
          while (val.hi) {
            buf[pos++] = val.lo & 127 | 128;
            val.lo = (val.lo >>> 7 | val.hi << 25) >>> 0;
            val.hi >>>= 7;
          }
          while (val.lo > 127) {
            buf[pos++] = val.lo & 127 | 128;
            val.lo = val.lo >>> 7;
          }
          buf[pos++] = val.lo;
        }
        Writer2.prototype.uint64 = function write_uint64(value) {
          var bits = LongBits.from(value);
          return this._push(writeVarint64, bits.length(), bits);
        };
        Writer2.prototype.int64 = Writer2.prototype.uint64;
        Writer2.prototype.sint64 = function write_sint64(value) {
          var bits = LongBits.from(value).zzEncode();
          return this._push(writeVarint64, bits.length(), bits);
        };
        Writer2.prototype.bool = function write_bool(value) {
          return this._push(writeByte, 1, value ? 1 : 0);
        };
        function writeFixed32(val, buf, pos) {
          buf[pos] = val & 255;
          buf[pos + 1] = val >>> 8 & 255;
          buf[pos + 2] = val >>> 16 & 255;
          buf[pos + 3] = val >>> 24;
        }
        Writer2.prototype.fixed32 = function write_fixed32(value) {
          return this._push(writeFixed32, 4, value >>> 0);
        };
        Writer2.prototype.sfixed32 = Writer2.prototype.fixed32;
        Writer2.prototype.fixed64 = function write_fixed64(value) {
          var bits = LongBits.from(value);
          return this._push(writeFixed32, 4, bits.lo)._push(writeFixed32, 4, bits.hi);
        };
        Writer2.prototype.sfixed64 = Writer2.prototype.fixed64;
        Writer2.prototype.float = function write_float(value) {
          return this._push(util.float.writeFloatLE, 4, value);
        };
        Writer2.prototype.double = function write_double(value) {
          return this._push(util.float.writeDoubleLE, 8, value);
        };
        var writeBytes = util.Array.prototype.set ? function writeBytes_set(val, buf, pos) {
          buf.set(val, pos);
        } : function writeBytes_for(val, buf, pos) {
          for (var i = 0; i < val.length; ++i)
            buf[pos + i] = val[i];
        };
        Writer2.prototype.bytes = function write_bytes(value) {
          var len = value.length >>> 0;
          if (!len)
            return this._push(writeByte, 1, 0);
          if (util.isString(value)) {
            var buf = Writer2.alloc(len = base64.length(value));
            base64.decode(value, buf, 0);
            value = buf;
          }
          return this.uint32(len)._push(writeBytes, len, value);
        };
        Writer2.prototype.string = function write_string(value) {
          var len = utf8.length(value);
          return len ? this.uint32(len)._push(utf8.write, len, value) : this._push(writeByte, 1, 0);
        };
        Writer2.prototype.fork = function fork() {
          this.states = new State(this);
          this.head = this.tail = new Op(noop, 0, 0);
          this.len = 0;
          return this;
        };
        Writer2.prototype.reset = function reset() {
          if (this.states) {
            this.head = this.states.head;
            this.tail = this.states.tail;
            this.len = this.states.len;
            this.states = this.states.next;
          } else {
            this.head = this.tail = new Op(noop, 0, 0);
            this.len = 0;
          }
          return this;
        };
        Writer2.prototype.ldelim = function ldelim() {
          var head = this.head, tail = this.tail, len = this.len;
          this.reset().uint32(len);
          if (len) {
            this.tail.next = head.next;
            this.tail = tail;
            this.len += len;
          }
          return this;
        };
        Writer2.prototype.finish = function finish() {
          var head = this.head.next, buf = this.constructor.alloc(this.len), pos = 0;
          while (head) {
            head.fn(head.val, buf, pos);
            pos += head.len;
            head = head.next;
          }
          return buf;
        };
        Writer2._configure = function(BufferWriter_) {
          BufferWriter = BufferWriter_;
          Writer2.create = create();
          BufferWriter._configure();
        };
      }, { "15": 15 }], 17: [function(require2, module2, exports2) {
        "use strict";
        module2.exports = BufferWriter;
        var Writer2 = require2(16);
        (BufferWriter.prototype = Object.create(Writer2.prototype)).constructor = BufferWriter;
        var util = require2(15);
        function BufferWriter() {
          Writer2.call(this);
        }
        BufferWriter._configure = function() {
          BufferWriter.alloc = util._Buffer_allocUnsafe;
          BufferWriter.writeBytesBuffer = util.Buffer && util.Buffer.prototype instanceof Uint8Array && util.Buffer.prototype.set.name === "set" ? function writeBytesBuffer_set(val, buf, pos) {
            buf.set(val, pos);
          } : function writeBytesBuffer_copy(val, buf, pos) {
            if (val.copy)
              val.copy(buf, pos, 0, val.length);
            else
              for (var i = 0; i < val.length; )
                buf[pos++] = val[i++];
          };
        };
        BufferWriter.prototype.bytes = function write_bytes_buffer(value) {
          if (util.isString(value))
            value = util._Buffer_from(value, "base64");
          var len = value.length >>> 0;
          this.uint32(len);
          if (len)
            this._push(BufferWriter.writeBytesBuffer, len, value);
          return this;
        };
        function writeStringBuffer(val, buf, pos) {
          if (val.length < 40)
            util.utf8.write(val, buf, pos);
          else if (buf.utf8Write)
            buf.utf8Write(val, pos);
          else
            buf.write(val, pos);
        }
        BufferWriter.prototype.string = function write_string_buffer(value) {
          var len = util.Buffer.byteLength(value);
          this.uint32(len);
          if (len)
            this._push(writeStringBuffer, len, value);
          return this;
        };
        BufferWriter._configure();
      }, { "15": 15, "16": 16 }] }, {}, [8]);
    })();
  }
});

// node_modules/rbush/rbush.js
var require_rbush = __commonJS({
  "node_modules/rbush/rbush.js"(exports2, module2) {
    (function(global2, factory) {
      typeof exports2 === "object" && typeof module2 !== "undefined" ? module2.exports = factory() : typeof define === "function" && define.amd ? define(factory) : (global2 = global2 || self, global2.RBush = factory());
    })(exports2, function() {
      "use strict";
      function quickselect(arr, k, left, right, compare) {
        quickselectStep(arr, k, left || 0, right || arr.length - 1, compare || defaultCompare);
      }
      function quickselectStep(arr, k, left, right, compare) {
        while (right > left) {
          if (right - left > 600) {
            var n = right - left + 1;
            var m = k - left + 1;
            var z = Math.log(n);
            var s = 0.5 * Math.exp(2 * z / 3);
            var sd = 0.5 * Math.sqrt(z * s * (n - s) / n) * (m - n / 2 < 0 ? -1 : 1);
            var newLeft = Math.max(left, Math.floor(k - m * s / n + sd));
            var newRight = Math.min(right, Math.floor(k + (n - m) * s / n + sd));
            quickselectStep(arr, k, newLeft, newRight, compare);
          }
          var t = arr[k];
          var i = left;
          var j = right;
          swap3(arr, left, k);
          if (compare(arr[right], t) > 0) {
            swap3(arr, left, right);
          }
          while (i < j) {
            swap3(arr, i, j);
            i++;
            j--;
            while (compare(arr[i], t) < 0) {
              i++;
            }
            while (compare(arr[j], t) > 0) {
              j--;
            }
          }
          if (compare(arr[left], t) === 0) {
            swap3(arr, left, j);
          } else {
            j++;
            swap3(arr, j, right);
          }
          if (j <= k) {
            left = j + 1;
          }
          if (k <= j) {
            right = j - 1;
          }
        }
      }
      function swap3(arr, i, j) {
        var tmp2 = arr[i];
        arr[i] = arr[j];
        arr[j] = tmp2;
      }
      function defaultCompare(a3, b) {
        return a3 < b ? -1 : a3 > b ? 1 : 0;
      }
      var RBush2 = function RBush3(maxEntries) {
        if (maxEntries === void 0)
          maxEntries = 9;
        this._maxEntries = Math.max(4, maxEntries);
        this._minEntries = Math.max(2, Math.ceil(this._maxEntries * 0.4));
        this.clear();
      };
      RBush2.prototype.all = function all() {
        return this._all(this.data, []);
      };
      RBush2.prototype.search = function search(bbox) {
        var node = this.data;
        var result = [];
        if (!intersects(bbox, node)) {
          return result;
        }
        var toBBox = this.toBBox;
        var nodesToSearch = [];
        while (node) {
          for (var i = 0; i < node.children.length; i++) {
            var child = node.children[i];
            var childBBox = node.leaf ? toBBox(child) : child;
            if (intersects(bbox, childBBox)) {
              if (node.leaf) {
                result.push(child);
              } else if (contains2(bbox, childBBox)) {
                this._all(child, result);
              } else {
                nodesToSearch.push(child);
              }
            }
          }
          node = nodesToSearch.pop();
        }
        return result;
      };
      RBush2.prototype.collides = function collides(bbox) {
        var node = this.data;
        if (!intersects(bbox, node)) {
          return false;
        }
        var nodesToSearch = [];
        while (node) {
          for (var i = 0; i < node.children.length; i++) {
            var child = node.children[i];
            var childBBox = node.leaf ? this.toBBox(child) : child;
            if (intersects(bbox, childBBox)) {
              if (node.leaf || contains2(bbox, childBBox)) {
                return true;
              }
              nodesToSearch.push(child);
            }
          }
          node = nodesToSearch.pop();
        }
        return false;
      };
      RBush2.prototype.load = function load5(data) {
        if (!(data && data.length)) {
          return this;
        }
        if (data.length < this._minEntries) {
          for (var i = 0; i < data.length; i++) {
            this.insert(data[i]);
          }
          return this;
        }
        var node = this._build(data.slice(), 0, data.length - 1, 0);
        if (!this.data.children.length) {
          this.data = node;
        } else if (this.data.height === node.height) {
          this._splitRoot(this.data, node);
        } else {
          if (this.data.height < node.height) {
            var tmpNode = this.data;
            this.data = node;
            node = tmpNode;
          }
          this._insert(node, this.data.height - node.height - 1, true);
        }
        return this;
      };
      RBush2.prototype.insert = function insert(item) {
        if (item) {
          this._insert(item, this.data.height - 1);
        }
        return this;
      };
      RBush2.prototype.clear = function clear2() {
        this.data = createNode([]);
        return this;
      };
      RBush2.prototype.remove = function remove3(item, equalsFn) {
        if (!item) {
          return this;
        }
        var node = this.data;
        var bbox = this.toBBox(item);
        var path = [];
        var indexes = [];
        var i, parent, goingUp;
        while (node || path.length) {
          if (!node) {
            node = path.pop();
            parent = path[path.length - 1];
            i = indexes.pop();
            goingUp = true;
          }
          if (node.leaf) {
            var index = findItem(item, node.children, equalsFn);
            if (index !== -1) {
              node.children.splice(index, 1);
              path.push(node);
              this._condense(path);
              return this;
            }
          }
          if (!goingUp && !node.leaf && contains2(node, bbox)) {
            path.push(node);
            indexes.push(i);
            i = 0;
            parent = node;
            node = node.children[0];
          } else if (parent) {
            i++;
            node = parent.children[i];
            goingUp = false;
          } else {
            node = null;
          }
        }
        return this;
      };
      RBush2.prototype.toBBox = function toBBox(item) {
        return item;
      };
      RBush2.prototype.compareMinX = function compareMinX(a3, b) {
        return a3.minX - b.minX;
      };
      RBush2.prototype.compareMinY = function compareMinY(a3, b) {
        return a3.minY - b.minY;
      };
      RBush2.prototype.toJSON = function toJSON() {
        return this.data;
      };
      RBush2.prototype.fromJSON = function fromJSON(data) {
        this.data = data;
        return this;
      };
      RBush2.prototype._all = function _all(node, result) {
        var nodesToSearch = [];
        while (node) {
          if (node.leaf) {
            result.push.apply(result, node.children);
          } else {
            nodesToSearch.push.apply(nodesToSearch, node.children);
          }
          node = nodesToSearch.pop();
        }
        return result;
      };
      RBush2.prototype._build = function _build(items, left, right, height) {
        var N = right - left + 1;
        var M = this._maxEntries;
        var node;
        if (N <= M) {
          node = createNode(items.slice(left, right + 1));
          calcBBox(node, this.toBBox);
          return node;
        }
        if (!height) {
          height = Math.ceil(Math.log(N) / Math.log(M));
          M = Math.ceil(N / Math.pow(M, height - 1));
        }
        node = createNode([]);
        node.leaf = false;
        node.height = height;
        var N2 = Math.ceil(N / M);
        var N1 = N2 * Math.ceil(Math.sqrt(M));
        multiSelect(items, left, right, N1, this.compareMinX);
        for (var i = left; i <= right; i += N1) {
          var right2 = Math.min(i + N1 - 1, right);
          multiSelect(items, i, right2, N2, this.compareMinY);
          for (var j = i; j <= right2; j += N2) {
            var right3 = Math.min(j + N2 - 1, right2);
            node.children.push(this._build(items, j, right3, height - 1));
          }
        }
        calcBBox(node, this.toBBox);
        return node;
      };
      RBush2.prototype._chooseSubtree = function _chooseSubtree(bbox, node, level, path) {
        while (true) {
          path.push(node);
          if (node.leaf || path.length - 1 === level) {
            break;
          }
          var minArea = Infinity;
          var minEnlargement = Infinity;
          var targetNode = void 0;
          for (var i = 0; i < node.children.length; i++) {
            var child = node.children[i];
            var area = bboxArea(child);
            var enlargement = enlargedArea(bbox, child) - area;
            if (enlargement < minEnlargement) {
              minEnlargement = enlargement;
              minArea = area < minArea ? area : minArea;
              targetNode = child;
            } else if (enlargement === minEnlargement) {
              if (area < minArea) {
                minArea = area;
                targetNode = child;
              }
            }
          }
          node = targetNode || node.children[0];
        }
        return node;
      };
      RBush2.prototype._insert = function _insert(item, level, isNode) {
        var bbox = isNode ? item : this.toBBox(item);
        var insertPath = [];
        var node = this._chooseSubtree(bbox, this.data, level, insertPath);
        node.children.push(item);
        extend(node, bbox);
        while (level >= 0) {
          if (insertPath[level].children.length > this._maxEntries) {
            this._split(insertPath, level);
            level--;
          } else {
            break;
          }
        }
        this._adjustParentBBoxes(bbox, insertPath, level);
      };
      RBush2.prototype._split = function _split(insertPath, level) {
        var node = insertPath[level];
        var M = node.children.length;
        var m = this._minEntries;
        this._chooseSplitAxis(node, m, M);
        var splitIndex = this._chooseSplitIndex(node, m, M);
        var newNode = createNode(node.children.splice(splitIndex, node.children.length - splitIndex));
        newNode.height = node.height;
        newNode.leaf = node.leaf;
        calcBBox(node, this.toBBox);
        calcBBox(newNode, this.toBBox);
        if (level) {
          insertPath[level - 1].children.push(newNode);
        } else {
          this._splitRoot(node, newNode);
        }
      };
      RBush2.prototype._splitRoot = function _splitRoot(node, newNode) {
        this.data = createNode([node, newNode]);
        this.data.height = node.height + 1;
        this.data.leaf = false;
        calcBBox(this.data, this.toBBox);
      };
      RBush2.prototype._chooseSplitIndex = function _chooseSplitIndex(node, m, M) {
        var index;
        var minOverlap = Infinity;
        var minArea = Infinity;
        for (var i = m; i <= M - m; i++) {
          var bbox1 = distBBox(node, 0, i, this.toBBox);
          var bbox2 = distBBox(node, i, M, this.toBBox);
          var overlap = intersectionArea(bbox1, bbox2);
          var area = bboxArea(bbox1) + bboxArea(bbox2);
          if (overlap < minOverlap) {
            minOverlap = overlap;
            index = i;
            minArea = area < minArea ? area : minArea;
          } else if (overlap === minOverlap) {
            if (area < minArea) {
              minArea = area;
              index = i;
            }
          }
        }
        return index || M - m;
      };
      RBush2.prototype._chooseSplitAxis = function _chooseSplitAxis(node, m, M) {
        var compareMinX = node.leaf ? this.compareMinX : compareNodeMinX;
        var compareMinY = node.leaf ? this.compareMinY : compareNodeMinY;
        var xMargin = this._allDistMargin(node, m, M, compareMinX);
        var yMargin = this._allDistMargin(node, m, M, compareMinY);
        if (xMargin < yMargin) {
          node.children.sort(compareMinX);
        }
      };
      RBush2.prototype._allDistMargin = function _allDistMargin(node, m, M, compare) {
        node.children.sort(compare);
        var toBBox = this.toBBox;
        var leftBBox = distBBox(node, 0, m, toBBox);
        var rightBBox = distBBox(node, M - m, M, toBBox);
        var margin = bboxMargin(leftBBox) + bboxMargin(rightBBox);
        for (var i = m; i < M - m; i++) {
          var child = node.children[i];
          extend(leftBBox, node.leaf ? toBBox(child) : child);
          margin += bboxMargin(leftBBox);
        }
        for (var i$1 = M - m - 1; i$1 >= m; i$1--) {
          var child$1 = node.children[i$1];
          extend(rightBBox, node.leaf ? toBBox(child$1) : child$1);
          margin += bboxMargin(rightBBox);
        }
        return margin;
      };
      RBush2.prototype._adjustParentBBoxes = function _adjustParentBBoxes(bbox, path, level) {
        for (var i = level; i >= 0; i--) {
          extend(path[i], bbox);
        }
      };
      RBush2.prototype._condense = function _condense(path) {
        for (var i = path.length - 1, siblings = void 0; i >= 0; i--) {
          if (path[i].children.length === 0) {
            if (i > 0) {
              siblings = path[i - 1].children;
              siblings.splice(siblings.indexOf(path[i]), 1);
            } else {
              this.clear();
            }
          } else {
            calcBBox(path[i], this.toBBox);
          }
        }
      };
      function findItem(item, items, equalsFn) {
        if (!equalsFn) {
          return items.indexOf(item);
        }
        for (var i = 0; i < items.length; i++) {
          if (equalsFn(item, items[i])) {
            return i;
          }
        }
        return -1;
      }
      function calcBBox(node, toBBox) {
        distBBox(node, 0, node.children.length, toBBox, node);
      }
      function distBBox(node, k, p, toBBox, destNode) {
        if (!destNode) {
          destNode = createNode(null);
        }
        destNode.minX = Infinity;
        destNode.minY = Infinity;
        destNode.maxX = -Infinity;
        destNode.maxY = -Infinity;
        for (var i = k; i < p; i++) {
          var child = node.children[i];
          extend(destNode, node.leaf ? toBBox(child) : child);
        }
        return destNode;
      }
      function extend(a3, b) {
        a3.minX = Math.min(a3.minX, b.minX);
        a3.minY = Math.min(a3.minY, b.minY);
        a3.maxX = Math.max(a3.maxX, b.maxX);
        a3.maxY = Math.max(a3.maxY, b.maxY);
        return a3;
      }
      function compareNodeMinX(a3, b) {
        return a3.minX - b.minX;
      }
      function compareNodeMinY(a3, b) {
        return a3.minY - b.minY;
      }
      function bboxArea(a3) {
        return (a3.maxX - a3.minX) * (a3.maxY - a3.minY);
      }
      function bboxMargin(a3) {
        return a3.maxX - a3.minX + (a3.maxY - a3.minY);
      }
      function enlargedArea(a3, b) {
        return (Math.max(b.maxX, a3.maxX) - Math.min(b.minX, a3.minX)) * (Math.max(b.maxY, a3.maxY) - Math.min(b.minY, a3.minY));
      }
      function intersectionArea(a3, b) {
        var minX = Math.max(a3.minX, b.minX);
        var minY = Math.max(a3.minY, b.minY);
        var maxX = Math.min(a3.maxX, b.maxX);
        var maxY = Math.min(a3.maxY, b.maxY);
        return Math.max(0, maxX - minX) * Math.max(0, maxY - minY);
      }
      function contains2(a3, b) {
        return a3.minX <= b.minX && a3.minY <= b.minY && b.maxX <= a3.maxX && b.maxY <= a3.maxY;
      }
      function intersects(a3, b) {
        return b.minX <= a3.maxX && b.minY <= a3.maxY && b.maxX >= a3.minX && b.maxY >= a3.minY;
      }
      function createNode(children) {
        return {
          children,
          height: 1,
          leaf: true,
          minX: Infinity,
          minY: Infinity,
          maxX: -Infinity,
          maxY: -Infinity
        };
      }
      function multiSelect(arr, left, right, n, compare) {
        var stack = [left, right];
        while (stack.length) {
          right = stack.pop();
          left = stack.pop();
          if (right - left <= n) {
            continue;
          }
          var mid = left + Math.ceil((right - left) / n / 2) * n;
          quickselect(arr, mid, left, right, compare);
          stack.push(left, mid, mid, right);
        }
      }
      return RBush2;
    });
  }
});

// node_modules/jsep/build/jsep.js
var require_jsep = __commonJS({
  "node_modules/jsep/build/jsep.js"(exports2, module2) {
    (function(root) {
      "use strict";
      var COMPOUND = "Compound", IDENTIFIER = "Identifier", MEMBER_EXP = "MemberExpression", LITERAL = "Literal", THIS_EXP = "ThisExpression", CALL_EXP = "CallExpression", UNARY_EXP = "UnaryExpression", BINARY_EXP = "BinaryExpression", LOGICAL_EXP = "LogicalExpression", CONDITIONAL_EXP = "ConditionalExpression", ARRAY_EXP = "ArrayExpression", PERIOD_CODE = 46, COMMA_CODE = 44, SQUOTE_CODE = 39, DQUOTE_CODE = 34, OPAREN_CODE = 40, CPAREN_CODE = 41, OBRACK_CODE = 91, CBRACK_CODE = 93, QUMARK_CODE = 63, SEMCOL_CODE = 59, COLON_CODE = 58, throwError = function(message, index) {
        var error = new Error(message + " at character " + index);
        error.index = index;
        error.description = message;
        throw error;
      }, t = true, unary_ops = { "-": t, "!": t, "~": t, "+": t }, binary_ops = {
        "||": 1,
        "&&": 2,
        "|": 3,
        "^": 4,
        "&": 5,
        "==": 6,
        "!=": 6,
        "===": 6,
        "!==": 6,
        "<": 7,
        ">": 7,
        "<=": 7,
        ">=": 7,
        "<<": 8,
        ">>": 8,
        ">>>": 8,
        "+": 9,
        "-": 9,
        "*": 10,
        "/": 10,
        "%": 10
      }, getMaxKeyLen = function(obj) {
        var max_len = 0, len;
        for (var key in obj) {
          if ((len = key.length) > max_len && obj.hasOwnProperty(key)) {
            max_len = len;
          }
        }
        return max_len;
      }, max_unop_len = getMaxKeyLen(unary_ops), max_binop_len = getMaxKeyLen(binary_ops), literals = {
        "true": true,
        "false": false,
        "null": null
      }, this_str = "this", binaryPrecedence = function(op_val) {
        return binary_ops[op_val] || 0;
      }, createBinaryExpression = function(operator, left, right) {
        var type = operator === "||" || operator === "&&" ? LOGICAL_EXP : BINARY_EXP;
        return {
          type,
          operator,
          left,
          right
        };
      }, isDecimalDigit = function(ch) {
        return ch >= 48 && ch <= 57;
      }, isIdentifierStart = function(ch) {
        return ch === 36 || ch === 95 || ch >= 65 && ch <= 90 || ch >= 97 && ch <= 122 || ch >= 128 && !binary_ops[String.fromCharCode(ch)];
      }, isIdentifierPart = function(ch) {
        return ch === 36 || ch === 95 || ch >= 65 && ch <= 90 || ch >= 97 && ch <= 122 || ch >= 48 && ch <= 57 || ch >= 128 && !binary_ops[String.fromCharCode(ch)];
      }, jsep2 = function(expr) {
        var index = 0, charAtFunc = expr.charAt, charCodeAtFunc = expr.charCodeAt, exprI = function(i) {
          return charAtFunc.call(expr, i);
        }, exprICode = function(i) {
          return charCodeAtFunc.call(expr, i);
        }, length3 = expr.length, gobbleSpaces = function() {
          var ch = exprICode(index);
          while (ch === 32 || ch === 9 || ch === 10 || ch === 13) {
            ch = exprICode(++index);
          }
        }, gobbleExpression = function() {
          var test = gobbleBinaryExpression(), consequent, alternate;
          gobbleSpaces();
          if (exprICode(index) === QUMARK_CODE) {
            index++;
            consequent = gobbleExpression();
            if (!consequent) {
              throwError("Expected expression", index);
            }
            gobbleSpaces();
            if (exprICode(index) === COLON_CODE) {
              index++;
              alternate = gobbleExpression();
              if (!alternate) {
                throwError("Expected expression", index);
              }
              return {
                type: CONDITIONAL_EXP,
                test,
                consequent,
                alternate
              };
            } else {
              throwError("Expected :", index);
            }
          } else {
            return test;
          }
        }, gobbleBinaryOp = function() {
          gobbleSpaces();
          var biop, to_check = expr.substr(index, max_binop_len), tc_len = to_check.length;
          while (tc_len > 0) {
            if (binary_ops.hasOwnProperty(to_check) && (!isIdentifierStart(exprICode(index)) || index + to_check.length < expr.length && !isIdentifierPart(exprICode(index + to_check.length)))) {
              index += tc_len;
              return to_check;
            }
            to_check = to_check.substr(0, --tc_len);
          }
          return false;
        }, gobbleBinaryExpression = function() {
          var ch_i2, node2, biop, prec, stack, biop_info, left, right, i, cur_biop;
          left = gobbleToken();
          biop = gobbleBinaryOp();
          if (!biop) {
            return left;
          }
          biop_info = { value: biop, prec: binaryPrecedence(biop) };
          right = gobbleToken();
          if (!right) {
            throwError("Expected expression after " + biop, index);
          }
          stack = [left, biop_info, right];
          while (biop = gobbleBinaryOp()) {
            prec = binaryPrecedence(biop);
            if (prec === 0) {
              break;
            }
            biop_info = { value: biop, prec };
            cur_biop = biop;
            while (stack.length > 2 && prec <= stack[stack.length - 2].prec) {
              right = stack.pop();
              biop = stack.pop().value;
              left = stack.pop();
              node2 = createBinaryExpression(biop, left, right);
              stack.push(node2);
            }
            node2 = gobbleToken();
            if (!node2) {
              throwError("Expected expression after " + cur_biop, index);
            }
            stack.push(biop_info, node2);
          }
          i = stack.length - 1;
          node2 = stack[i];
          while (i > 1) {
            node2 = createBinaryExpression(stack[i - 1].value, stack[i - 2], node2);
            i -= 2;
          }
          return node2;
        }, gobbleToken = function() {
          var ch, to_check, tc_len;
          gobbleSpaces();
          ch = exprICode(index);
          if (isDecimalDigit(ch) || ch === PERIOD_CODE) {
            return gobbleNumericLiteral();
          } else if (ch === SQUOTE_CODE || ch === DQUOTE_CODE) {
            return gobbleStringLiteral();
          } else if (ch === OBRACK_CODE) {
            return gobbleArray();
          } else {
            to_check = expr.substr(index, max_unop_len);
            tc_len = to_check.length;
            while (tc_len > 0) {
              if (unary_ops.hasOwnProperty(to_check) && (!isIdentifierStart(exprICode(index)) || index + to_check.length < expr.length && !isIdentifierPart(exprICode(index + to_check.length)))) {
                index += tc_len;
                return {
                  type: UNARY_EXP,
                  operator: to_check,
                  argument: gobbleToken(),
                  prefix: true
                };
              }
              to_check = to_check.substr(0, --tc_len);
            }
            if (isIdentifierStart(ch) || ch === OPAREN_CODE) {
              return gobbleVariable();
            }
          }
          return false;
        }, gobbleNumericLiteral = function() {
          var number = "", ch, chCode;
          while (isDecimalDigit(exprICode(index))) {
            number += exprI(index++);
          }
          if (exprICode(index) === PERIOD_CODE) {
            number += exprI(index++);
            while (isDecimalDigit(exprICode(index))) {
              number += exprI(index++);
            }
          }
          ch = exprI(index);
          if (ch === "e" || ch === "E") {
            number += exprI(index++);
            ch = exprI(index);
            if (ch === "+" || ch === "-") {
              number += exprI(index++);
            }
            while (isDecimalDigit(exprICode(index))) {
              number += exprI(index++);
            }
            if (!isDecimalDigit(exprICode(index - 1))) {
              throwError("Expected exponent (" + number + exprI(index) + ")", index);
            }
          }
          chCode = exprICode(index);
          if (isIdentifierStart(chCode)) {
            throwError("Variable names cannot start with a number (" + number + exprI(index) + ")", index);
          } else if (chCode === PERIOD_CODE) {
            throwError("Unexpected period", index);
          }
          return {
            type: LITERAL,
            value: parseFloat(number),
            raw: number
          };
        }, gobbleStringLiteral = function() {
          var str = "", quote = exprI(index++), closed = false, ch;
          while (index < length3) {
            ch = exprI(index++);
            if (ch === quote) {
              closed = true;
              break;
            } else if (ch === "\\") {
              ch = exprI(index++);
              switch (ch) {
                case "n":
                  str += "\n";
                  break;
                case "r":
                  str += "\r";
                  break;
                case "t":
                  str += "	";
                  break;
                case "b":
                  str += "\b";
                  break;
                case "f":
                  str += "\f";
                  break;
                case "v":
                  str += "\v";
                  break;
                default:
                  str += ch;
              }
            } else {
              str += ch;
            }
          }
          if (!closed) {
            throwError('Unclosed quote after "' + str + '"', index);
          }
          return {
            type: LITERAL,
            value: str,
            raw: quote + str + quote
          };
        }, gobbleIdentifier = function() {
          var ch = exprICode(index), start = index, identifier;
          if (isIdentifierStart(ch)) {
            index++;
          } else {
            throwError("Unexpected " + exprI(index), index);
          }
          while (index < length3) {
            ch = exprICode(index);
            if (isIdentifierPart(ch)) {
              index++;
            } else {
              break;
            }
          }
          identifier = expr.slice(start, index);
          if (literals.hasOwnProperty(identifier)) {
            return {
              type: LITERAL,
              value: literals[identifier],
              raw: identifier
            };
          } else if (identifier === this_str) {
            return { type: THIS_EXP };
          } else {
            return {
              type: IDENTIFIER,
              name: identifier
            };
          }
        }, gobbleArguments = function(termination) {
          var ch_i2, args = [], node2, closed = false;
          var separator_count = 0;
          while (index < length3) {
            gobbleSpaces();
            ch_i2 = exprICode(index);
            if (ch_i2 === termination) {
              closed = true;
              index++;
              if (termination === CPAREN_CODE && separator_count && separator_count >= args.length) {
                throwError("Unexpected token " + String.fromCharCode(termination), index);
              }
              break;
            } else if (ch_i2 === COMMA_CODE) {
              index++;
              separator_count++;
              if (separator_count !== args.length) {
                if (termination === CPAREN_CODE) {
                  throwError("Unexpected token ,", index);
                } else if (termination === CBRACK_CODE) {
                  for (var arg = args.length; arg < separator_count; arg++) {
                    args.push(null);
                  }
                }
              }
            } else {
              node2 = gobbleExpression();
              if (!node2 || node2.type === COMPOUND) {
                throwError("Expected comma", index);
              }
              args.push(node2);
            }
          }
          if (!closed) {
            throwError("Expected " + String.fromCharCode(termination), index);
          }
          return args;
        }, gobbleVariable = function() {
          var ch_i2, node2;
          ch_i2 = exprICode(index);
          if (ch_i2 === OPAREN_CODE) {
            node2 = gobbleGroup();
          } else {
            node2 = gobbleIdentifier();
          }
          gobbleSpaces();
          ch_i2 = exprICode(index);
          while (ch_i2 === PERIOD_CODE || ch_i2 === OBRACK_CODE || ch_i2 === OPAREN_CODE) {
            index++;
            if (ch_i2 === PERIOD_CODE) {
              gobbleSpaces();
              node2 = {
                type: MEMBER_EXP,
                computed: false,
                object: node2,
                property: gobbleIdentifier()
              };
            } else if (ch_i2 === OBRACK_CODE) {
              node2 = {
                type: MEMBER_EXP,
                computed: true,
                object: node2,
                property: gobbleExpression()
              };
              gobbleSpaces();
              ch_i2 = exprICode(index);
              if (ch_i2 !== CBRACK_CODE) {
                throwError("Unclosed [", index);
              }
              index++;
            } else if (ch_i2 === OPAREN_CODE) {
              node2 = {
                type: CALL_EXP,
                "arguments": gobbleArguments(CPAREN_CODE),
                callee: node2
              };
            }
            gobbleSpaces();
            ch_i2 = exprICode(index);
          }
          return node2;
        }, gobbleGroup = function() {
          index++;
          var node2 = gobbleExpression();
          gobbleSpaces();
          if (exprICode(index) === CPAREN_CODE) {
            index++;
            return node2;
          } else {
            throwError("Unclosed (", index);
          }
        }, gobbleArray = function() {
          index++;
          return {
            type: ARRAY_EXP,
            elements: gobbleArguments(CBRACK_CODE)
          };
        }, nodes = [], ch_i, node;
        while (index < length3) {
          ch_i = exprICode(index);
          if (ch_i === SEMCOL_CODE || ch_i === COMMA_CODE) {
            index++;
          } else {
            if (node = gobbleExpression()) {
              nodes.push(node);
            } else if (index < length3) {
              throwError('Unexpected "' + exprI(index) + '"', index);
            }
          }
        }
        if (nodes.length === 1) {
          return nodes[0];
        } else {
          return {
            type: COMPOUND,
            body: nodes
          };
        }
      };
      jsep2.version = "0.3.5";
      jsep2.toString = function() {
        return "JavaScript Expression Parser (JSEP) v" + jsep2.version;
      };
      jsep2.addUnaryOp = function(op_name) {
        max_unop_len = Math.max(op_name.length, max_unop_len);
        unary_ops[op_name] = t;
        return this;
      };
      jsep2.addBinaryOp = function(op_name, precedence) {
        max_binop_len = Math.max(op_name.length, max_binop_len);
        binary_ops[op_name] = precedence;
        return this;
      };
      jsep2.addLiteral = function(literal_name, literal_value) {
        literals[literal_name] = literal_value;
        return this;
      };
      jsep2.removeUnaryOp = function(op_name) {
        delete unary_ops[op_name];
        if (op_name.length === max_unop_len) {
          max_unop_len = getMaxKeyLen(unary_ops);
        }
        return this;
      };
      jsep2.removeAllUnaryOps = function() {
        unary_ops = {};
        max_unop_len = 0;
        return this;
      };
      jsep2.removeBinaryOp = function(op_name) {
        delete binary_ops[op_name];
        if (op_name.length === max_binop_len) {
          max_binop_len = getMaxKeyLen(binary_ops);
        }
        return this;
      };
      jsep2.removeAllBinaryOps = function() {
        binary_ops = {};
        max_binop_len = 0;
        return this;
      };
      jsep2.removeLiteral = function(literal_name) {
        delete literals[literal_name];
        return this;
      };
      jsep2.removeAllLiterals = function() {
        literals = {};
        return this;
      };
      if (typeof exports2 === "undefined") {
        var old_jsep = root.jsep;
        root.jsep = jsep2;
        jsep2.noConflict = function() {
          if (root.jsep === jsep2) {
            root.jsep = old_jsep;
          }
          return jsep2;
        };
      } else {
        if (typeof module2 !== "undefined" && module2.exports) {
          exports2 = module2.exports = jsep2;
        } else {
          exports2.parse = jsep2;
        }
      }
    })(exports2);
  }
});

// node_modules/meshoptimizer/meshopt_encoder.js
var require_meshopt_encoder = __commonJS({
  "node_modules/meshoptimizer/meshopt_encoder.js"(exports2, module2) {
    var MeshoptEncoder = function() {
      "use strict";
      var wasm = "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";
      var wasmpack = new Uint8Array([32, 0, 65, 2, 1, 106, 34, 33, 3, 128, 11, 4, 13, 64, 6, 253, 10, 7, 15, 116, 127, 5, 8, 12, 40, 16, 19, 54, 20, 9, 27, 255, 113, 17, 42, 67, 24, 23, 146, 148, 18, 14, 22, 45, 70, 69, 56, 114, 101, 21, 25, 63, 75, 136, 108, 28, 118, 29, 73, 115]);
      if (typeof WebAssembly !== "object") {
        return {
          supported: false
        };
      }
      var instance;
      var promise = WebAssembly.instantiate(unpack(wasm), {}).then(function(result) {
        instance = result.instance;
        instance.exports.__wasm_call_ctors();
        instance.exports.meshopt_encodeVertexVersion(0);
        instance.exports.meshopt_encodeIndexVersion(1);
      });
      function unpack(data) {
        var result = new Uint8Array(data.length);
        for (var i = 0; i < data.length; ++i) {
          var ch = data.charCodeAt(i);
          result[i] = ch > 96 ? ch - 71 : ch > 64 ? ch - 65 : ch > 47 ? ch + 4 : ch > 46 ? 63 : 62;
        }
        var write = 0;
        for (var i = 0; i < data.length; ++i) {
          result[write++] = result[i] < 60 ? wasmpack[result[i]] : (result[i] - 60) * 64 + result[++i];
        }
        return result.buffer.slice(0, write);
      }
      function assert(cond) {
        if (!cond) {
          throw new Error("Assertion failed");
        }
      }
      function reorder(indices2, vertices, optf) {
        var sbrk = instance.exports.sbrk;
        var ip = sbrk(indices2.length * 4);
        var rp = sbrk(vertices * 4);
        var heap = new Uint8Array(instance.exports.memory.buffer);
        var indices8 = new Uint8Array(indices2.buffer, indices2.byteOffset, indices2.byteLength);
        heap.set(indices8, ip);
        if (optf) {
          optf(ip, ip, indices2.length, vertices);
        }
        var unique = instance.exports.meshopt_optimizeVertexFetchRemap(rp, ip, indices2.length, vertices);
        heap = new Uint8Array(instance.exports.memory.buffer);
        var remap = new Uint32Array(vertices);
        new Uint8Array(remap.buffer).set(heap.subarray(rp, rp + vertices * 4));
        indices8.set(heap.subarray(ip, ip + indices2.length * 4));
        sbrk(ip - sbrk(0));
        for (var i = 0; i < indices2.length; ++i)
          indices2[i] = remap[indices2[i]];
        return [remap, unique];
      }
      function encode(fun, bound, source, count, size) {
        var sbrk = instance.exports.sbrk;
        var tp = sbrk(bound);
        var sp = sbrk(count * size);
        var heap = new Uint8Array(instance.exports.memory.buffer);
        heap.set(new Uint8Array(source.buffer, source.byteOffset, source.byteLength), sp);
        var res = fun(tp, bound, sp, count, size);
        var target = new Uint8Array(res);
        target.set(heap.subarray(tp, tp + res));
        sbrk(tp - sbrk(0));
        return target;
      }
      function maxindex(source) {
        var result = 0;
        for (var i = 0; i < source.length; ++i) {
          var index = source[i];
          result = result < index ? index : result;
        }
        return result;
      }
      function index32(source, size) {
        assert(size == 2 || size == 4);
        if (size == 4) {
          return new Uint32Array(source.buffer, source.byteOffset, source.byteLength / 4);
        } else {
          var view = new Uint16Array(source.buffer, source.byteOffset, source.byteLength / 2);
          return new Uint32Array(view);
        }
      }
      function filter(fun, source, count, stride, bits, insize) {
        var sbrk = instance.exports.sbrk;
        var tp = sbrk(count * stride);
        var sp = sbrk(count * insize);
        var heap = new Uint8Array(instance.exports.memory.buffer);
        heap.set(new Uint8Array(source.buffer, source.byteOffset, source.byteLength), sp);
        fun(tp, count, stride, bits, sp);
        var target = new Uint8Array(count * stride);
        target.set(heap.subarray(tp, tp + count * stride));
        sbrk(tp - sbrk(0));
        return target;
      }
      return {
        ready: promise,
        supported: true,
        reorderMesh: function(indices2, triangles, optsize) {
          var optf = triangles ? optsize ? instance.exports.meshopt_optimizeVertexCacheStrip : instance.exports.meshopt_optimizeVertexCache : void 0;
          return reorder(indices2, maxindex(indices2) + 1, optf);
        },
        encodeVertexBuffer: function(source, count, size) {
          assert(size > 0 && size <= 256);
          assert(size % 4 == 0);
          var bound = instance.exports.meshopt_encodeVertexBufferBound(count, size);
          return encode(instance.exports.meshopt_encodeVertexBuffer, bound, source, count, size);
        },
        encodeIndexBuffer: function(source, count, size) {
          assert(size == 2 || size == 4);
          assert(count % 3 == 0);
          var indices2 = index32(source, size);
          var bound = instance.exports.meshopt_encodeIndexBufferBound(count, maxindex(indices2) + 1);
          return encode(instance.exports.meshopt_encodeIndexBuffer, bound, indices2, count, 4);
        },
        encodeIndexSequence: function(source, count, size) {
          assert(size == 2 || size == 4);
          var indices2 = index32(source, size);
          var bound = instance.exports.meshopt_encodeIndexSequenceBound(count, maxindex(indices2) + 1);
          return encode(instance.exports.meshopt_encodeIndexSequence, bound, indices2, count, 4);
        },
        encodeGltfBuffer: function(source, count, size, mode2) {
          var table2 = {
            ATTRIBUTES: this.encodeVertexBuffer,
            TRIANGLES: this.encodeIndexBuffer,
            INDICES: this.encodeIndexSequence
          };
          assert(table2[mode2]);
          return table2[mode2](source, count, size);
        },
        encodeFilterOct: function(source, count, stride, bits) {
          assert(stride == 4 || stride == 8);
          assert(bits >= 1 && bits <= 16);
          return filter(instance.exports.meshopt_encodeFilterOct, source, count, stride, bits, 4);
        },
        encodeFilterQuat: function(source, count, stride, bits) {
          assert(stride == 8);
          assert(bits >= 4 && bits <= 16);
          return filter(instance.exports.meshopt_encodeFilterQuat, source, count, stride, bits, 4);
        },
        encodeFilterExp: function(source, count, stride, bits) {
          assert(stride > 0 && stride % 4 == 0);
          assert(bits >= 1 && bits <= 24);
          return filter(instance.exports.meshopt_encodeFilterExp, source, count, stride, bits, stride / 4);
        }
      };
    }();
    if (typeof exports2 === "object" && typeof module2 === "object")
      module2.exports = MeshoptEncoder;
    else if (typeof define === "function" && define["amd"])
      define([], function() {
        return MeshoptEncoder;
      });
    else if (typeof exports2 === "object")
      exports2["MeshoptEncoder"] = MeshoptEncoder;
    else
      (typeof self !== "undefined" ? self : exports2).MeshoptEncoder = MeshoptEncoder;
  }
});

// node_modules/meshoptimizer/meshopt_decoder.js
var require_meshopt_decoder = __commonJS({
  "node_modules/meshoptimizer/meshopt_decoder.js"(exports2, module2) {
    var MeshoptDecoder2 = function() {
      "use strict";
      var wasm_base = "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";
      var wasm_simd = "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";
      var detector = new Uint8Array([0, 97, 115, 109, 1, 0, 0, 0, 1, 4, 1, 96, 0, 0, 3, 3, 2, 0, 0, 5, 3, 1, 0, 1, 12, 1, 0, 10, 22, 2, 12, 0, 65, 0, 65, 0, 65, 0, 252, 10, 0, 0, 11, 7, 0, 65, 0, 253, 15, 26, 11]);
      var wasmpack = new Uint8Array([32, 0, 65, 2, 1, 106, 34, 33, 3, 128, 11, 4, 13, 64, 6, 253, 10, 7, 15, 116, 127, 5, 8, 12, 40, 16, 19, 54, 20, 9, 27, 255, 113, 17, 42, 67, 24, 23, 146, 148, 18, 14, 22, 45, 70, 69, 56, 114, 101, 21, 25, 63, 75, 136, 108, 28, 118, 29, 73, 115]);
      if (typeof WebAssembly !== "object") {
        return {
          supported: false
        };
      }
      var wasm = wasm_base;
      if (WebAssembly.validate(detector)) {
        wasm = wasm_simd;
      }
      var instance;
      var promise = WebAssembly.instantiate(unpack(wasm), {}).then(function(result) {
        instance = result.instance;
        instance.exports.__wasm_call_ctors();
      });
      function unpack(data) {
        var result = new Uint8Array(data.length);
        for (var i = 0; i < data.length; ++i) {
          var ch = data.charCodeAt(i);
          result[i] = ch > 96 ? ch - 71 : ch > 64 ? ch - 65 : ch > 47 ? ch + 4 : ch > 46 ? 63 : 62;
        }
        var write = 0;
        for (var i = 0; i < data.length; ++i) {
          result[write++] = result[i] < 60 ? wasmpack[result[i]] : (result[i] - 60) * 64 + result[++i];
        }
        return result.buffer.slice(0, write);
      }
      function decode(fun, target, count, size, source, filter) {
        var sbrk = instance.exports.sbrk;
        var count4 = count + 3 & ~3;
        var tp = sbrk(count4 * size);
        var sp = sbrk(source.length);
        var heap = new Uint8Array(instance.exports.memory.buffer);
        heap.set(source, sp);
        var res = fun(tp, count, size, sp, source.length);
        if (res == 0 && filter) {
          filter(tp, count4, size);
        }
        target.set(heap.subarray(tp, tp + count * size));
        sbrk(tp - sbrk(0));
        if (res != 0) {
          throw new Error("Malformed buffer data: " + res);
        }
      }
      ;
      var filters = {
        0: "",
        1: "meshopt_decodeFilterOct",
        2: "meshopt_decodeFilterQuat",
        3: "meshopt_decodeFilterExp",
        NONE: "",
        OCTAHEDRAL: "meshopt_decodeFilterOct",
        QUATERNION: "meshopt_decodeFilterQuat",
        EXPONENTIAL: "meshopt_decodeFilterExp"
      };
      var decoders = {
        0: "meshopt_decodeVertexBuffer",
        1: "meshopt_decodeIndexBuffer",
        2: "meshopt_decodeIndexSequence",
        ATTRIBUTES: "meshopt_decodeVertexBuffer",
        TRIANGLES: "meshopt_decodeIndexBuffer",
        INDICES: "meshopt_decodeIndexSequence"
      };
      return {
        ready: promise,
        supported: true,
        decodeVertexBuffer: function(target, count, size, source, filter) {
          decode(instance.exports.meshopt_decodeVertexBuffer, target, count, size, source, instance.exports[filters[filter]]);
        },
        decodeIndexBuffer: function(target, count, size, source) {
          decode(instance.exports.meshopt_decodeIndexBuffer, target, count, size, source);
        },
        decodeIndexSequence: function(target, count, size, source) {
          decode(instance.exports.meshopt_decodeIndexSequence, target, count, size, source);
        },
        decodeGltfBuffer: function(target, count, size, source, mode2, filter) {
          decode(instance.exports[decoders[mode2]], target, count, size, source, instance.exports[filters[filter]]);
        }
      };
    }();
    if (typeof exports2 === "object" && typeof module2 === "object")
      module2.exports = MeshoptDecoder2;
    else if (typeof define === "function" && define["amd"])
      define([], function() {
        return MeshoptDecoder2;
      });
    else if (typeof exports2 === "object")
      exports2["MeshoptDecoder"] = MeshoptDecoder2;
    else
      (typeof self !== "undefined" ? self : exports2).MeshoptDecoder = MeshoptDecoder2;
  }
});

// node_modules/meshoptimizer/index.js
var require_meshoptimizer = __commonJS({
  "node_modules/meshoptimizer/index.js"(exports2, module2) {
    var MeshoptEncoder = require_meshopt_encoder();
    var MeshoptDecoder2 = require_meshopt_decoder();
    module2.exports = { MeshoptEncoder, MeshoptDecoder: MeshoptDecoder2 };
  }
});

// node_modules/bitmap-sdf/index.js
var require_bitmap_sdf = __commonJS({
  "node_modules/bitmap-sdf/index.js"(exports2, module2) {
    "use strict";
    module2.exports = calcSDF;
    var INF = 1e20;
    function calcSDF(src, options) {
      if (!options)
        options = {};
      var cutoff = options.cutoff == null ? 0.25 : options.cutoff;
      var radius = options.radius == null ? 8 : options.radius;
      var channel = options.channel || 0;
      var w, h, size, data, intData, stride, ctx, canvas, imgData, i, l;
      if (ArrayBuffer.isView(src) || Array.isArray(src)) {
        if (!options.width || !options.height)
          throw Error("For raw data width and height should be provided by options");
        w = options.width, h = options.height;
        data = src;
        if (!options.stride)
          stride = Math.floor(src.length / w / h);
        else
          stride = options.stride;
      } else {
        if (window.HTMLCanvasElement && src instanceof window.HTMLCanvasElement) {
          canvas = src;
          ctx = canvas.getContext("2d");
          w = canvas.width, h = canvas.height;
          imgData = ctx.getImageData(0, 0, w, h);
          data = imgData.data;
          stride = 4;
        } else if (window.CanvasRenderingContext2D && src instanceof window.CanvasRenderingContext2D) {
          canvas = src.canvas;
          ctx = src;
          w = canvas.width, h = canvas.height;
          imgData = ctx.getImageData(0, 0, w, h);
          data = imgData.data;
          stride = 4;
        } else if (window.ImageData && src instanceof window.ImageData) {
          imgData = src;
          w = src.width, h = src.height;
          data = imgData.data;
          stride = 4;
        }
      }
      size = Math.max(w, h);
      if (window.Uint8ClampedArray && data instanceof window.Uint8ClampedArray || window.Uint8Array && data instanceof window.Uint8Array) {
        intData = data;
        data = Array(w * h);
        for (i = 0, l = Math.floor(intData.length / stride); i < l; i++) {
          data[i] = intData[i * stride + channel] / 255;
        }
      } else {
        if (stride !== 1)
          throw Error("Raw data can have only 1 value per pixel");
      }
      var gridOuter = Array(w * h);
      var gridInner = Array(w * h);
      var f = Array(size);
      var d = Array(size);
      var z = Array(size + 1);
      var v7 = Array(size);
      for (i = 0, l = w * h; i < l; i++) {
        var a3 = data[i];
        gridOuter[i] = a3 === 1 ? 0 : a3 === 0 ? INF : Math.pow(Math.max(0, 0.5 - a3), 2);
        gridInner[i] = a3 === 1 ? INF : a3 === 0 ? 0 : Math.pow(Math.max(0, a3 - 0.5), 2);
      }
      edt(gridOuter, w, h, f, d, v7, z);
      edt(gridInner, w, h, f, d, v7, z);
      var dist = window.Float32Array ? new Float32Array(w * h) : new Array(w * h);
      for (i = 0, l = w * h; i < l; i++) {
        dist[i] = Math.min(Math.max(1 - ((gridOuter[i] - gridInner[i]) / radius + cutoff), 0), 1);
      }
      return dist;
    }
    function edt(data, width, height, f, d, v7, z) {
      for (var x = 0; x < width; x++) {
        for (var y = 0; y < height; y++) {
          f[y] = data[y * width + x];
        }
        edt1d(f, d, v7, z, height);
        for (y = 0; y < height; y++) {
          data[y * width + x] = d[y];
        }
      }
      for (y = 0; y < height; y++) {
        for (x = 0; x < width; x++) {
          f[x] = data[y * width + x];
        }
        edt1d(f, d, v7, z, width);
        for (x = 0; x < width; x++) {
          data[y * width + x] = Math.sqrt(d[x]);
        }
      }
    }
    function edt1d(f, d, v7, z, n) {
      v7[0] = 0;
      z[0] = -INF;
      z[1] = +INF;
      for (var q = 1, k = 0; q < n; q++) {
        var s = (f[q] + q * q - (f[v7[k]] + v7[k] * v7[k])) / (2 * q - 2 * v7[k]);
        while (s <= z[k]) {
          k--;
          s = (f[q] + q * q - (f[v7[k]] + v7[k] * v7[k])) / (2 * q - 2 * v7[k]);
        }
        k++;
        v7[k] = q;
        z[k] = s;
        z[k + 1] = +INF;
      }
      for (q = 0, k = 0; q < n; q++) {
        while (z[k + 1] < q)
          k++;
        d[q] = (q - v7[k]) * (q - v7[k]) + f[v7[k]];
      }
    }
  }
});

// node_modules/grapheme-splitter/index.js
var require_grapheme_splitter = __commonJS({
  "node_modules/grapheme-splitter/index.js"(exports2, module2) {
    function GraphemeSplitter2() {
      var CR = 0, LF = 1, Control = 2, Extend = 3, Regional_Indicator = 4, SpacingMark = 5, L = 6, V = 7, T = 8, LV = 9, LVT = 10, Other = 11, Prepend = 12, E_Base = 13, E_Modifier = 14, ZWJ = 15, Glue_After_Zwj = 16, E_Base_GAZ = 17;
      var NotBreak = 0, BreakStart = 1, Break = 2, BreakLastRegional = 3, BreakPenultimateRegional = 4;
      function isSurrogate(str, pos) {
        return 55296 <= str.charCodeAt(pos) && str.charCodeAt(pos) <= 56319 && 56320 <= str.charCodeAt(pos + 1) && str.charCodeAt(pos + 1) <= 57343;
      }
      function codePointAt(str, idx) {
        if (idx === void 0) {
          idx = 0;
        }
        var code = str.charCodeAt(idx);
        if (55296 <= code && code <= 56319 && idx < str.length - 1) {
          var hi = code;
          var low = str.charCodeAt(idx + 1);
          if (56320 <= low && low <= 57343) {
            return (hi - 55296) * 1024 + (low - 56320) + 65536;
          }
          return hi;
        }
        if (56320 <= code && code <= 57343 && idx >= 1) {
          var hi = str.charCodeAt(idx - 1);
          var low = code;
          if (55296 <= hi && hi <= 56319) {
            return (hi - 55296) * 1024 + (low - 56320) + 65536;
          }
          return low;
        }
        return code;
      }
      function shouldBreak(start, mid, end) {
        var all = [start].concat(mid).concat([end]);
        var previous = all[all.length - 2];
        var next = end;
        var eModifierIndex = all.lastIndexOf(E_Modifier);
        if (eModifierIndex > 1 && all.slice(1, eModifierIndex).every(function(c) {
          return c == Extend;
        }) && [Extend, E_Base, E_Base_GAZ].indexOf(start) == -1) {
          return Break;
        }
        var rIIndex = all.lastIndexOf(Regional_Indicator);
        if (rIIndex > 0 && all.slice(1, rIIndex).every(function(c) {
          return c == Regional_Indicator;
        }) && [Prepend, Regional_Indicator].indexOf(previous) == -1) {
          if (all.filter(function(c) {
            return c == Regional_Indicator;
          }).length % 2 == 1) {
            return BreakLastRegional;
          } else {
            return BreakPenultimateRegional;
          }
        }
        if (previous == CR && next == LF) {
          return NotBreak;
        } else if (previous == Control || previous == CR || previous == LF) {
          if (next == E_Modifier && mid.every(function(c) {
            return c == Extend;
          })) {
            return Break;
          } else {
            return BreakStart;
          }
        } else if (next == Control || next == CR || next == LF) {
          return BreakStart;
        } else if (previous == L && (next == L || next == V || next == LV || next == LVT)) {
          return NotBreak;
        } else if ((previous == LV || previous == V) && (next == V || next == T)) {
          return NotBreak;
        } else if ((previous == LVT || previous == T) && next == T) {
          return NotBreak;
        } else if (next == Extend || next == ZWJ) {
          return NotBreak;
        } else if (next == SpacingMark) {
          return NotBreak;
        } else if (previous == Prepend) {
          return NotBreak;
        }
        var previousNonExtendIndex = all.indexOf(Extend) != -1 ? all.lastIndexOf(Extend) - 1 : all.length - 2;
        if ([E_Base, E_Base_GAZ].indexOf(all[previousNonExtendIndex]) != -1 && all.slice(previousNonExtendIndex + 1, -1).every(function(c) {
          return c == Extend;
        }) && next == E_Modifier) {
          return NotBreak;
        }
        if (previous == ZWJ && [Glue_After_Zwj, E_Base_GAZ].indexOf(next) != -1) {
          return NotBreak;
        }
        if (mid.indexOf(Regional_Indicator) != -1) {
          return Break;
        }
        if (previous == Regional_Indicator && next == Regional_Indicator) {
          return NotBreak;
        }
        return BreakStart;
      }
      this.nextBreak = function(string, index) {
        if (index === void 0) {
          index = 0;
        }
        if (index < 0) {
          return 0;
        }
        if (index >= string.length - 1) {
          return string.length;
        }
        var prev = getGraphemeBreakProperty(codePointAt(string, index));
        var mid = [];
        for (var i = index + 1; i < string.length; i++) {
          if (isSurrogate(string, i - 1)) {
            continue;
          }
          var next = getGraphemeBreakProperty(codePointAt(string, i));
          if (shouldBreak(prev, mid, next)) {
            return i;
          }
          mid.push(next);
        }
        return string.length;
      };
      this.splitGraphemes = function(str) {
        var res = [];
        var index = 0;
        var brk;
        while ((brk = this.nextBreak(str, index)) < str.length) {
          res.push(str.slice(index, brk));
          index = brk;
        }
        if (index < str.length) {
          res.push(str.slice(index));
        }
        return res;
      };
      this.iterateGraphemes = function(str) {
        var index = 0;
        var res = {
          next: function() {
            var value;
            var brk;
            if ((brk = this.nextBreak(str, index)) < str.length) {
              value = str.slice(index, brk);
              index = brk;
              return { value, done: false };
            }
            if (index < str.length) {
              value = str.slice(index);
              index = str.length;
              return { value, done: false };
            }
            return { value: void 0, done: true };
          }.bind(this)
        };
        if (typeof Symbol !== "undefined" && Symbol.iterator) {
          res[Symbol.iterator] = function() {
            return res;
          };
        }
        return res;
      };
      this.countGraphemes = function(str) {
        var count = 0;
        var index = 0;
        var brk;
        while ((brk = this.nextBreak(str, index)) < str.length) {
          index = brk;
          count++;
        }
        if (index < str.length) {
          count++;
        }
        return count;
      };
      function getGraphemeBreakProperty(code) {
        if (1536 <= code && code <= 1541 || 1757 == code || 1807 == code || 2274 == code || 3406 == code || 69821 == code || 70082 <= code && code <= 70083 || 72250 == code || 72326 <= code && code <= 72329 || 73030 == code) {
          return Prepend;
        }
        if (13 == code) {
          return CR;
        }
        if (10 == code) {
          return LF;
        }
        if (0 <= code && code <= 9 || 11 <= code && code <= 12 || 14 <= code && code <= 31 || 127 <= code && code <= 159 || 173 == code || 1564 == code || 6158 == code || 8203 == code || 8206 <= code && code <= 8207 || 8232 == code || 8233 == code || 8234 <= code && code <= 8238 || 8288 <= code && code <= 8292 || 8293 == code || 8294 <= code && code <= 8303 || 55296 <= code && code <= 57343 || 65279 == code || 65520 <= code && code <= 65528 || 65529 <= code && code <= 65531 || 113824 <= code && code <= 113827 || 119155 <= code && code <= 119162 || 917504 == code || 917505 == code || 917506 <= code && code <= 917535 || 917632 <= code && code <= 917759 || 918e3 <= code && code <= 921599) {
          return Control;
        }
        if (768 <= code && code <= 879 || 1155 <= code && code <= 1159 || 1160 <= code && code <= 1161 || 1425 <= code && code <= 1469 || 1471 == code || 1473 <= code && code <= 1474 || 1476 <= code && code <= 1477 || 1479 == code || 1552 <= code && code <= 1562 || 1611 <= code && code <= 1631 || 1648 == code || 1750 <= code && code <= 1756 || 1759 <= code && code <= 1764 || 1767 <= code && code <= 1768 || 1770 <= code && code <= 1773 || 1809 == code || 1840 <= code && code <= 1866 || 1958 <= code && code <= 1968 || 2027 <= code && code <= 2035 || 2070 <= code && code <= 2073 || 2075 <= code && code <= 2083 || 2085 <= code && code <= 2087 || 2089 <= code && code <= 2093 || 2137 <= code && code <= 2139 || 2260 <= code && code <= 2273 || 2275 <= code && code <= 2306 || 2362 == code || 2364 == code || 2369 <= code && code <= 2376 || 2381 == code || 2385 <= code && code <= 2391 || 2402 <= code && code <= 2403 || 2433 == code || 2492 == code || 2494 == code || 2497 <= code && code <= 2500 || 2509 == code || 2519 == code || 2530 <= code && code <= 2531 || 2561 <= code && code <= 2562 || 2620 == code || 2625 <= code && code <= 2626 || 2631 <= code && code <= 2632 || 2635 <= code && code <= 2637 || 2641 == code || 2672 <= code && code <= 2673 || 2677 == code || 2689 <= code && code <= 2690 || 2748 == code || 2753 <= code && code <= 2757 || 2759 <= code && code <= 2760 || 2765 == code || 2786 <= code && code <= 2787 || 2810 <= code && code <= 2815 || 2817 == code || 2876 == code || 2878 == code || 2879 == code || 2881 <= code && code <= 2884 || 2893 == code || 2902 == code || 2903 == code || 2914 <= code && code <= 2915 || 2946 == code || 3006 == code || 3008 == code || 3021 == code || 3031 == code || 3072 == code || 3134 <= code && code <= 3136 || 3142 <= code && code <= 3144 || 3146 <= code && code <= 3149 || 3157 <= code && code <= 3158 || 3170 <= code && code <= 3171 || 3201 == code || 3260 == code || 3263 == code || 3266 == code || 3270 == code || 3276 <= code && code <= 3277 || 3285 <= code && code <= 3286 || 3298 <= code && code <= 3299 || 3328 <= code && code <= 3329 || 3387 <= code && code <= 3388 || 3390 == code || 3393 <= code && code <= 3396 || 3405 == code || 3415 == code || 3426 <= code && code <= 3427 || 3530 == code || 3535 == code || 3538 <= code && code <= 3540 || 3542 == code || 3551 == code || 3633 == code || 3636 <= code && code <= 3642 || 3655 <= code && code <= 3662 || 3761 == code || 3764 <= code && code <= 3769 || 3771 <= code && code <= 3772 || 3784 <= code && code <= 3789 || 3864 <= code && code <= 3865 || 3893 == code || 3895 == code || 3897 == code || 3953 <= code && code <= 3966 || 3968 <= code && code <= 3972 || 3974 <= code && code <= 3975 || 3981 <= code && code <= 3991 || 3993 <= code && code <= 4028 || 4038 == code || 4141 <= code && code <= 4144 || 4146 <= code && code <= 4151 || 4153 <= code && code <= 4154 || 4157 <= code && code <= 4158 || 4184 <= code && code <= 4185 || 4190 <= code && code <= 4192 || 4209 <= code && code <= 4212 || 4226 == code || 4229 <= code && code <= 4230 || 4237 == code || 4253 == code || 4957 <= code && code <= 4959 || 5906 <= code && code <= 5908 || 5938 <= code && code <= 5940 || 5970 <= code && code <= 5971 || 6002 <= code && code <= 6003 || 6068 <= code && code <= 6069 || 6071 <= code && code <= 6077 || 6086 == code || 6089 <= code && code <= 6099 || 6109 == code || 6155 <= code && code <= 6157 || 6277 <= code && code <= 6278 || 6313 == code || 6432 <= code && code <= 6434 || 6439 <= code && code <= 6440 || 6450 == code || 6457 <= code && code <= 6459 || 6679 <= code && code <= 6680 || 6683 == code || 6742 == code || 6744 <= code && code <= 6750 || 6752 == code || 6754 == code || 6757 <= code && code <= 6764 || 6771 <= code && code <= 6780 || 6783 == code || 6832 <= code && code <= 6845 || 6846 == code || 6912 <= code && code <= 6915 || 6964 == code || 6966 <= code && code <= 6970 || 6972 == code || 6978 == code || 7019 <= code && code <= 7027 || 7040 <= code && code <= 7041 || 7074 <= code && code <= 7077 || 7080 <= code && code <= 7081 || 7083 <= code && code <= 7085 || 7142 == code || 7144 <= code && code <= 7145 || 7149 == code || 7151 <= code && code <= 7153 || 7212 <= code && code <= 7219 || 7222 <= code && code <= 7223 || 7376 <= code && code <= 7378 || 7380 <= code && code <= 7392 || 7394 <= code && code <= 7400 || 7405 == code || 7412 == code || 7416 <= code && code <= 7417 || 7616 <= code && code <= 7673 || 7675 <= code && code <= 7679 || 8204 == code || 8400 <= code && code <= 8412 || 8413 <= code && code <= 8416 || 8417 == code || 8418 <= code && code <= 8420 || 8421 <= code && code <= 8432 || 11503 <= code && code <= 11505 || 11647 == code || 11744 <= code && code <= 11775 || 12330 <= code && code <= 12333 || 12334 <= code && code <= 12335 || 12441 <= code && code <= 12442 || 42607 == code || 42608 <= code && code <= 42610 || 42612 <= code && code <= 42621 || 42654 <= code && code <= 42655 || 42736 <= code && code <= 42737 || 43010 == code || 43014 == code || 43019 == code || 43045 <= code && code <= 43046 || 43204 <= code && code <= 43205 || 43232 <= code && code <= 43249 || 43302 <= code && code <= 43309 || 43335 <= code && code <= 43345 || 43392 <= code && code <= 43394 || 43443 == code || 43446 <= code && code <= 43449 || 43452 == code || 43493 == code || 43561 <= code && code <= 43566 || 43569 <= code && code <= 43570 || 43573 <= code && code <= 43574 || 43587 == code || 43596 == code || 43644 == code || 43696 == code || 43698 <= code && code <= 43700 || 43703 <= code && code <= 43704 || 43710 <= code && code <= 43711 || 43713 == code || 43756 <= code && code <= 43757 || 43766 == code || 44005 == code || 44008 == code || 44013 == code || 64286 == code || 65024 <= code && code <= 65039 || 65056 <= code && code <= 65071 || 65438 <= code && code <= 65439 || 66045 == code || 66272 == code || 66422 <= code && code <= 66426 || 68097 <= code && code <= 68099 || 68101 <= code && code <= 68102 || 68108 <= code && code <= 68111 || 68152 <= code && code <= 68154 || 68159 == code || 68325 <= code && code <= 68326 || 69633 == code || 69688 <= code && code <= 69702 || 69759 <= code && code <= 69761 || 69811 <= code && code <= 69814 || 69817 <= code && code <= 69818 || 69888 <= code && code <= 69890 || 69927 <= code && code <= 69931 || 69933 <= code && code <= 69940 || 70003 == code || 70016 <= code && code <= 70017 || 70070 <= code && code <= 70078 || 70090 <= code && code <= 70092 || 70191 <= code && code <= 70193 || 70196 == code || 70198 <= code && code <= 70199 || 70206 == code || 70367 == code || 70371 <= code && code <= 70378 || 70400 <= code && code <= 70401 || 70460 == code || 70462 == code || 70464 == code || 70487 == code || 70502 <= code && code <= 70508 || 70512 <= code && code <= 70516 || 70712 <= code && code <= 70719 || 70722 <= code && code <= 70724 || 70726 == code || 70832 == code || 70835 <= code && code <= 70840 || 70842 == code || 70845 == code || 70847 <= code && code <= 70848 || 70850 <= code && code <= 70851 || 71087 == code || 71090 <= code && code <= 71093 || 71100 <= code && code <= 71101 || 71103 <= code && code <= 71104 || 71132 <= code && code <= 71133 || 71219 <= code && code <= 71226 || 71229 == code || 71231 <= code && code <= 71232 || 71339 == code || 71341 == code || 71344 <= code && code <= 71349 || 71351 == code || 71453 <= code && code <= 71455 || 71458 <= code && code <= 71461 || 71463 <= code && code <= 71467 || 72193 <= code && code <= 72198 || 72201 <= code && code <= 72202 || 72243 <= code && code <= 72248 || 72251 <= code && code <= 72254 || 72263 == code || 72273 <= code && code <= 72278 || 72281 <= code && code <= 72283 || 72330 <= code && code <= 72342 || 72344 <= code && code <= 72345 || 72752 <= code && code <= 72758 || 72760 <= code && code <= 72765 || 72767 == code || 72850 <= code && code <= 72871 || 72874 <= code && code <= 72880 || 72882 <= code && code <= 72883 || 72885 <= code && code <= 72886 || 73009 <= code && code <= 73014 || 73018 == code || 73020 <= code && code <= 73021 || 73023 <= code && code <= 73029 || 73031 == code || 92912 <= code && code <= 92916 || 92976 <= code && code <= 92982 || 94095 <= code && code <= 94098 || 113821 <= code && code <= 113822 || 119141 == code || 119143 <= code && code <= 119145 || 119150 <= code && code <= 119154 || 119163 <= code && code <= 119170 || 119173 <= code && code <= 119179 || 119210 <= code && code <= 119213 || 119362 <= code && code <= 119364 || 121344 <= code && code <= 121398 || 121403 <= code && code <= 121452 || 121461 == code || 121476 == code || 121499 <= code && code <= 121503 || 121505 <= code && code <= 121519 || 122880 <= code && code <= 122886 || 122888 <= code && code <= 122904 || 122907 <= code && code <= 122913 || 122915 <= code && code <= 122916 || 122918 <= code && code <= 122922 || 125136 <= code && code <= 125142 || 125252 <= code && code <= 125258 || 917536 <= code && code <= 917631 || 917760 <= code && code <= 917999) {
          return Extend;
        }
        if (127462 <= code && code <= 127487) {
          return Regional_Indicator;
        }
        if (2307 == code || 2363 == code || 2366 <= code && code <= 2368 || 2377 <= code && code <= 2380 || 2382 <= code && code <= 2383 || 2434 <= code && code <= 2435 || 2495 <= code && code <= 2496 || 2503 <= code && code <= 2504 || 2507 <= code && code <= 2508 || 2563 == code || 2622 <= code && code <= 2624 || 2691 == code || 2750 <= code && code <= 2752 || 2761 == code || 2763 <= code && code <= 2764 || 2818 <= code && code <= 2819 || 2880 == code || 2887 <= code && code <= 2888 || 2891 <= code && code <= 2892 || 3007 == code || 3009 <= code && code <= 3010 || 3014 <= code && code <= 3016 || 3018 <= code && code <= 3020 || 3073 <= code && code <= 3075 || 3137 <= code && code <= 3140 || 3202 <= code && code <= 3203 || 3262 == code || 3264 <= code && code <= 3265 || 3267 <= code && code <= 3268 || 3271 <= code && code <= 3272 || 3274 <= code && code <= 3275 || 3330 <= code && code <= 3331 || 3391 <= code && code <= 3392 || 3398 <= code && code <= 3400 || 3402 <= code && code <= 3404 || 3458 <= code && code <= 3459 || 3536 <= code && code <= 3537 || 3544 <= code && code <= 3550 || 3570 <= code && code <= 3571 || 3635 == code || 3763 == code || 3902 <= code && code <= 3903 || 3967 == code || 4145 == code || 4155 <= code && code <= 4156 || 4182 <= code && code <= 4183 || 4228 == code || 6070 == code || 6078 <= code && code <= 6085 || 6087 <= code && code <= 6088 || 6435 <= code && code <= 6438 || 6441 <= code && code <= 6443 || 6448 <= code && code <= 6449 || 6451 <= code && code <= 6456 || 6681 <= code && code <= 6682 || 6741 == code || 6743 == code || 6765 <= code && code <= 6770 || 6916 == code || 6965 == code || 6971 == code || 6973 <= code && code <= 6977 || 6979 <= code && code <= 6980 || 7042 == code || 7073 == code || 7078 <= code && code <= 7079 || 7082 == code || 7143 == code || 7146 <= code && code <= 7148 || 7150 == code || 7154 <= code && code <= 7155 || 7204 <= code && code <= 7211 || 7220 <= code && code <= 7221 || 7393 == code || 7410 <= code && code <= 7411 || 7415 == code || 43043 <= code && code <= 43044 || 43047 == code || 43136 <= code && code <= 43137 || 43188 <= code && code <= 43203 || 43346 <= code && code <= 43347 || 43395 == code || 43444 <= code && code <= 43445 || 43450 <= code && code <= 43451 || 43453 <= code && code <= 43456 || 43567 <= code && code <= 43568 || 43571 <= code && code <= 43572 || 43597 == code || 43755 == code || 43758 <= code && code <= 43759 || 43765 == code || 44003 <= code && code <= 44004 || 44006 <= code && code <= 44007 || 44009 <= code && code <= 44010 || 44012 == code || 69632 == code || 69634 == code || 69762 == code || 69808 <= code && code <= 69810 || 69815 <= code && code <= 69816 || 69932 == code || 70018 == code || 70067 <= code && code <= 70069 || 70079 <= code && code <= 70080 || 70188 <= code && code <= 70190 || 70194 <= code && code <= 70195 || 70197 == code || 70368 <= code && code <= 70370 || 70402 <= code && code <= 70403 || 70463 == code || 70465 <= code && code <= 70468 || 70471 <= code && code <= 70472 || 70475 <= code && code <= 70477 || 70498 <= code && code <= 70499 || 70709 <= code && code <= 70711 || 70720 <= code && code <= 70721 || 70725 == code || 70833 <= code && code <= 70834 || 70841 == code || 70843 <= code && code <= 70844 || 70846 == code || 70849 == code || 71088 <= code && code <= 71089 || 71096 <= code && code <= 71099 || 71102 == code || 71216 <= code && code <= 71218 || 71227 <= code && code <= 71228 || 71230 == code || 71340 == code || 71342 <= code && code <= 71343 || 71350 == code || 71456 <= code && code <= 71457 || 71462 == code || 72199 <= code && code <= 72200 || 72249 == code || 72279 <= code && code <= 72280 || 72343 == code || 72751 == code || 72766 == code || 72873 == code || 72881 == code || 72884 == code || 94033 <= code && code <= 94078 || 119142 == code || 119149 == code) {
          return SpacingMark;
        }
        if (4352 <= code && code <= 4447 || 43360 <= code && code <= 43388) {
          return L;
        }
        if (4448 <= code && code <= 4519 || 55216 <= code && code <= 55238) {
          return V;
        }
        if (4520 <= code && code <= 4607 || 55243 <= code && code <= 55291) {
          return T;
        }
        if (44032 == code || 44060 == code || 44088 == code || 44116 == code || 44144 == code || 44172 == code || 44200 == code || 44228 == code || 44256 == code || 44284 == code || 44312 == code || 44340 == code || 44368 == code || 44396 == code || 44424 == code || 44452 == code || 44480 == code || 44508 == code || 44536 == code || 44564 == code || 44592 == code || 44620 == code || 44648 == code || 44676 == code || 44704 == code || 44732 == code || 44760 == code || 44788 == code || 44816 == code || 44844 == code || 44872 == code || 44900 == code || 44928 == code || 44956 == code || 44984 == code || 45012 == code || 45040 == code || 45068 == code || 45096 == code || 45124 == code || 45152 == code || 45180 == code || 45208 == code || 45236 == code || 45264 == code || 45292 == code || 45320 == code || 45348 == code || 45376 == code || 45404 == code || 45432 == code || 45460 == code || 45488 == code || 45516 == code || 45544 == code || 45572 == code || 45600 == code || 45628 == code || 45656 == code || 45684 == code || 45712 == code || 45740 == code || 45768 == code || 45796 == code || 45824 == code || 45852 == code || 45880 == code || 45908 == code || 45936 == code || 45964 == code || 45992 == code || 46020 == code || 46048 == code || 46076 == code || 46104 == code || 46132 == code || 46160 == code || 46188 == code || 46216 == code || 46244 == code || 46272 == code || 46300 == code || 46328 == code || 46356 == code || 46384 == code || 46412 == code || 46440 == code || 46468 == code || 46496 == code || 46524 == code || 46552 == code || 46580 == code || 46608 == code || 46636 == code || 46664 == code || 46692 == code || 46720 == code || 46748 == code || 46776 == code || 46804 == code || 46832 == code || 46860 == code || 46888 == code || 46916 == code || 46944 == code || 46972 == code || 47e3 == code || 47028 == code || 47056 == code || 47084 == code || 47112 == code || 47140 == code || 47168 == code || 47196 == code || 47224 == code || 47252 == code || 47280 == code || 47308 == code || 47336 == code || 47364 == code || 47392 == code || 47420 == code || 47448 == code || 47476 == code || 47504 == code || 47532 == code || 47560 == code || 47588 == code || 47616 == code || 47644 == code || 47672 == code || 47700 == code || 47728 == code || 47756 == code || 47784 == code || 47812 == code || 47840 == code || 47868 == code || 47896 == code || 47924 == code || 47952 == code || 47980 == code || 48008 == code || 48036 == code || 48064 == code || 48092 == code || 48120 == code || 48148 == code || 48176 == code || 48204 == code || 48232 == code || 48260 == code || 48288 == code || 48316 == code || 48344 == code || 48372 == code || 48400 == code || 48428 == code || 48456 == code || 48484 == code || 48512 == code || 48540 == code || 48568 == code || 48596 == code || 48624 == code || 48652 == code || 48680 == code || 48708 == code || 48736 == code || 48764 == code || 48792 == code || 48820 == code || 48848 == code || 48876 == code || 48904 == code || 48932 == code || 48960 == code || 48988 == code || 49016 == code || 49044 == code || 49072 == code || 49100 == code || 49128 == code || 49156 == code || 49184 == code || 49212 == code || 49240 == code || 49268 == code || 49296 == code || 49324 == code || 49352 == code || 49380 == code || 49408 == code || 49436 == code || 49464 == code || 49492 == code || 49520 == code || 49548 == code || 49576 == code || 49604 == code || 49632 == code || 49660 == code || 49688 == code || 49716 == code || 49744 == code || 49772 == code || 49800 == code || 49828 == code || 49856 == code || 49884 == code || 49912 == code || 49940 == code || 49968 == code || 49996 == code || 50024 == code || 50052 == code || 50080 == code || 50108 == code || 50136 == code || 50164 == code || 50192 == code || 50220 == code || 50248 == code || 50276 == code || 50304 == code || 50332 == code || 50360 == code || 50388 == code || 50416 == code || 50444 == code || 50472 == code || 50500 == code || 50528 == code || 50556 == code || 50584 == code || 50612 == code || 50640 == code || 50668 == code || 50696 == code || 50724 == code || 50752 == code || 50780 == code || 50808 == code || 50836 == code || 50864 == code || 50892 == code || 50920 == code || 50948 == code || 50976 == code || 51004 == code || 51032 == code || 51060 == code || 51088 == code || 51116 == code || 51144 == code || 51172 == code || 51200 == code || 51228 == code || 51256 == code || 51284 == code || 51312 == code || 51340 == code || 51368 == code || 51396 == code || 51424 == code || 51452 == code || 51480 == code || 51508 == code || 51536 == code || 51564 == code || 51592 == code || 51620 == code || 51648 == code || 51676 == code || 51704 == code || 51732 == code || 51760 == code || 51788 == code || 51816 == code || 51844 == code || 51872 == code || 51900 == code || 51928 == code || 51956 == code || 51984 == code || 52012 == code || 52040 == code || 52068 == code || 52096 == code || 52124 == code || 52152 == code || 52180 == code || 52208 == code || 52236 == code || 52264 == code || 52292 == code || 52320 == code || 52348 == code || 52376 == code || 52404 == code || 52432 == code || 52460 == code || 52488 == code || 52516 == code || 52544 == code || 52572 == code || 52600 == code || 52628 == code || 52656 == code || 52684 == code || 52712 == code || 52740 == code || 52768 == code || 52796 == code || 52824 == code || 52852 == code || 52880 == code || 52908 == code || 52936 == code || 52964 == code || 52992 == code || 53020 == code || 53048 == code || 53076 == code || 53104 == code || 53132 == code || 53160 == code || 53188 == code || 53216 == code || 53244 == code || 53272 == code || 53300 == code || 53328 == code || 53356 == code || 53384 == code || 53412 == code || 53440 == code || 53468 == code || 53496 == code || 53524 == code || 53552 == code || 53580 == code || 53608 == code || 53636 == code || 53664 == code || 53692 == code || 53720 == code || 53748 == code || 53776 == code || 53804 == code || 53832 == code || 53860 == code || 53888 == code || 53916 == code || 53944 == code || 53972 == code || 54e3 == code || 54028 == code || 54056 == code || 54084 == code || 54112 == code || 54140 == code || 54168 == code || 54196 == code || 54224 == code || 54252 == code || 54280 == code || 54308 == code || 54336 == code || 54364 == code || 54392 == code || 54420 == code || 54448 == code || 54476 == code || 54504 == code || 54532 == code || 54560 == code || 54588 == code || 54616 == code || 54644 == code || 54672 == code || 54700 == code || 54728 == code || 54756 == code || 54784 == code || 54812 == code || 54840 == code || 54868 == code || 54896 == code || 54924 == code || 54952 == code || 54980 == code || 55008 == code || 55036 == code || 55064 == code || 55092 == code || 55120 == code || 55148 == code || 55176 == code) {
          return LV;
        }
        if (44033 <= code && code <= 44059 || 44061 <= code && code <= 44087 || 44089 <= code && code <= 44115 || 44117 <= code && code <= 44143 || 44145 <= code && code <= 44171 || 44173 <= code && code <= 44199 || 44201 <= code && code <= 44227 || 44229 <= code && code <= 44255 || 44257 <= code && code <= 44283 || 44285 <= code && code <= 44311 || 44313 <= code && code <= 44339 || 44341 <= code && code <= 44367 || 44369 <= code && code <= 44395 || 44397 <= code && code <= 44423 || 44425 <= code && code <= 44451 || 44453 <= code && code <= 44479 || 44481 <= code && code <= 44507 || 44509 <= code && code <= 44535 || 44537 <= code && code <= 44563 || 44565 <= code && code <= 44591 || 44593 <= code && code <= 44619 || 44621 <= code && code <= 44647 || 44649 <= code && code <= 44675 || 44677 <= code && code <= 44703 || 44705 <= code && code <= 44731 || 44733 <= code && code <= 44759 || 44761 <= code && code <= 44787 || 44789 <= code && code <= 44815 || 44817 <= code && code <= 44843 || 44845 <= code && code <= 44871 || 44873 <= code && code <= 44899 || 44901 <= code && code <= 44927 || 44929 <= code && code <= 44955 || 44957 <= code && code <= 44983 || 44985 <= code && code <= 45011 || 45013 <= code && code <= 45039 || 45041 <= code && code <= 45067 || 45069 <= code && code <= 45095 || 45097 <= code && code <= 45123 || 45125 <= code && code <= 45151 || 45153 <= code && code <= 45179 || 45181 <= code && code <= 45207 || 45209 <= code && code <= 45235 || 45237 <= code && code <= 45263 || 45265 <= code && code <= 45291 || 45293 <= code && code <= 45319 || 45321 <= code && code <= 45347 || 45349 <= code && code <= 45375 || 45377 <= code && code <= 45403 || 45405 <= code && code <= 45431 || 45433 <= code && code <= 45459 || 45461 <= code && code <= 45487 || 45489 <= code && code <= 45515 || 45517 <= code && code <= 45543 || 45545 <= code && code <= 45571 || 45573 <= code && code <= 45599 || 45601 <= code && code <= 45627 || 45629 <= code && code <= 45655 || 45657 <= code && code <= 45683 || 45685 <= code && code <= 45711 || 45713 <= code && code <= 45739 || 45741 <= code && code <= 45767 || 45769 <= code && code <= 45795 || 45797 <= code && code <= 45823 || 45825 <= code && code <= 45851 || 45853 <= code && code <= 45879 || 45881 <= code && code <= 45907 || 45909 <= code && code <= 45935 || 45937 <= code && code <= 45963 || 45965 <= code && code <= 45991 || 45993 <= code && code <= 46019 || 46021 <= code && code <= 46047 || 46049 <= code && code <= 46075 || 46077 <= code && code <= 46103 || 46105 <= code && code <= 46131 || 46133 <= code && code <= 46159 || 46161 <= code && code <= 46187 || 46189 <= code && code <= 46215 || 46217 <= code && code <= 46243 || 46245 <= code && code <= 46271 || 46273 <= code && code <= 46299 || 46301 <= code && code <= 46327 || 46329 <= code && code <= 46355 || 46357 <= code && code <= 46383 || 46385 <= code && code <= 46411 || 46413 <= code && code <= 46439 || 46441 <= code && code <= 46467 || 46469 <= code && code <= 46495 || 46497 <= code && code <= 46523 || 46525 <= code && code <= 46551 || 46553 <= code && code <= 46579 || 46581 <= code && code <= 46607 || 46609 <= code && code <= 46635 || 46637 <= code && code <= 46663 || 46665 <= code && code <= 46691 || 46693 <= code && code <= 46719 || 46721 <= code && code <= 46747 || 46749 <= code && code <= 46775 || 46777 <= code && code <= 46803 || 46805 <= code && code <= 46831 || 46833 <= code && code <= 46859 || 46861 <= code && code <= 46887 || 46889 <= code && code <= 46915 || 46917 <= code && code <= 46943 || 46945 <= code && code <= 46971 || 46973 <= code && code <= 46999 || 47001 <= code && code <= 47027 || 47029 <= code && code <= 47055 || 47057 <= code && code <= 47083 || 47085 <= code && code <= 47111 || 47113 <= code && code <= 47139 || 47141 <= code && code <= 47167 || 47169 <= code && code <= 47195 || 47197 <= code && code <= 47223 || 47225 <= code && code <= 47251 || 47253 <= code && code <= 47279 || 47281 <= code && code <= 47307 || 47309 <= code && code <= 47335 || 47337 <= code && code <= 47363 || 47365 <= code && code <= 47391 || 47393 <= code && code <= 47419 || 47421 <= code && code <= 47447 || 47449 <= code && code <= 47475 || 47477 <= code && code <= 47503 || 47505 <= code && code <= 47531 || 47533 <= code && code <= 47559 || 47561 <= code && code <= 47587 || 47589 <= code && code <= 47615 || 47617 <= code && code <= 47643 || 47645 <= code && code <= 47671 || 47673 <= code && code <= 47699 || 47701 <= code && code <= 47727 || 47729 <= code && code <= 47755 || 47757 <= code && code <= 47783 || 47785 <= code && code <= 47811 || 47813 <= code && code <= 47839 || 47841 <= code && code <= 47867 || 47869 <= code && code <= 47895 || 47897 <= code && code <= 47923 || 47925 <= code && code <= 47951 || 47953 <= code && code <= 47979 || 47981 <= code && code <= 48007 || 48009 <= code && code <= 48035 || 48037 <= code && code <= 48063 || 48065 <= code && code <= 48091 || 48093 <= code && code <= 48119 || 48121 <= code && code <= 48147 || 48149 <= code && code <= 48175 || 48177 <= code && code <= 48203 || 48205 <= code && code <= 48231 || 48233 <= code && code <= 48259 || 48261 <= code && code <= 48287 || 48289 <= code && code <= 48315 || 48317 <= code && code <= 48343 || 48345 <= code && code <= 48371 || 48373 <= code && code <= 48399 || 48401 <= code && code <= 48427 || 48429 <= code && code <= 48455 || 48457 <= code && code <= 48483 || 48485 <= code && code <= 48511 || 48513 <= code && code <= 48539 || 48541 <= code && code <= 48567 || 48569 <= code && code <= 48595 || 48597 <= code && code <= 48623 || 48625 <= code && code <= 48651 || 48653 <= code && code <= 48679 || 48681 <= code && code <= 48707 || 48709 <= code && code <= 48735 || 48737 <= code && code <= 48763 || 48765 <= code && code <= 48791 || 48793 <= code && code <= 48819 || 48821 <= code && code <= 48847 || 48849 <= code && code <= 48875 || 48877 <= code && code <= 48903 || 48905 <= code && code <= 48931 || 48933 <= code && code <= 48959 || 48961 <= code && code <= 48987 || 48989 <= code && code <= 49015 || 49017 <= code && code <= 49043 || 49045 <= code && code <= 49071 || 49073 <= code && code <= 49099 || 49101 <= code && code <= 49127 || 49129 <= code && code <= 49155 || 49157 <= code && code <= 49183 || 49185 <= code && code <= 49211 || 49213 <= code && code <= 49239 || 49241 <= code && code <= 49267 || 49269 <= code && code <= 49295 || 49297 <= code && code <= 49323 || 49325 <= code && code <= 49351 || 49353 <= code && code <= 49379 || 49381 <= code && code <= 49407 || 49409 <= code && code <= 49435 || 49437 <= code && code <= 49463 || 49465 <= code && code <= 49491 || 49493 <= code && code <= 49519 || 49521 <= code && code <= 49547 || 49549 <= code && code <= 49575 || 49577 <= code && code <= 49603 || 49605 <= code && code <= 49631 || 49633 <= code && code <= 49659 || 49661 <= code && code <= 49687 || 49689 <= code && code <= 49715 || 49717 <= code && code <= 49743 || 49745 <= code && code <= 49771 || 49773 <= code && code <= 49799 || 49801 <= code && code <= 49827 || 49829 <= code && code <= 49855 || 49857 <= code && code <= 49883 || 49885 <= code && code <= 49911 || 49913 <= code && code <= 49939 || 49941 <= code && code <= 49967 || 49969 <= code && code <= 49995 || 49997 <= code && code <= 50023 || 50025 <= code && code <= 50051 || 50053 <= code && code <= 50079 || 50081 <= code && code <= 50107 || 50109 <= code && code <= 50135 || 50137 <= code && code <= 50163 || 50165 <= code && code <= 50191 || 50193 <= code && code <= 50219 || 50221 <= code && code <= 50247 || 50249 <= code && code <= 50275 || 50277 <= code && code <= 50303 || 50305 <= code && code <= 50331 || 50333 <= code && code <= 50359 || 50361 <= code && code <= 50387 || 50389 <= code && code <= 50415 || 50417 <= code && code <= 50443 || 50445 <= code && code <= 50471 || 50473 <= code && code <= 50499 || 50501 <= code && code <= 50527 || 50529 <= code && code <= 50555 || 50557 <= code && code <= 50583 || 50585 <= code && code <= 50611 || 50613 <= code && code <= 50639 || 50641 <= code && code <= 50667 || 50669 <= code && code <= 50695 || 50697 <= code && code <= 50723 || 50725 <= code && code <= 50751 || 50753 <= code && code <= 50779 || 50781 <= code && code <= 50807 || 50809 <= code && code <= 50835 || 50837 <= code && code <= 50863 || 50865 <= code && code <= 50891 || 50893 <= code && code <= 50919 || 50921 <= code && code <= 50947 || 50949 <= code && code <= 50975 || 50977 <= code && code <= 51003 || 51005 <= code && code <= 51031 || 51033 <= code && code <= 51059 || 51061 <= code && code <= 51087 || 51089 <= code && code <= 51115 || 51117 <= code && code <= 51143 || 51145 <= code && code <= 51171 || 51173 <= code && code <= 51199 || 51201 <= code && code <= 51227 || 51229 <= code && code <= 51255 || 51257 <= code && code <= 51283 || 51285 <= code && code <= 51311 || 51313 <= code && code <= 51339 || 51341 <= code && code <= 51367 || 51369 <= code && code <= 51395 || 51397 <= code && code <= 51423 || 51425 <= code && code <= 51451 || 51453 <= code && code <= 51479 || 51481 <= code && code <= 51507 || 51509 <= code && code <= 51535 || 51537 <= code && code <= 51563 || 51565 <= code && code <= 51591 || 51593 <= code && code <= 51619 || 51621 <= code && code <= 51647 || 51649 <= code && code <= 51675 || 51677 <= code && code <= 51703 || 51705 <= code && code <= 51731 || 51733 <= code && code <= 51759 || 51761 <= code && code <= 51787 || 51789 <= code && code <= 51815 || 51817 <= code && code <= 51843 || 51845 <= code && code <= 51871 || 51873 <= code && code <= 51899 || 51901 <= code && code <= 51927 || 51929 <= code && code <= 51955 || 51957 <= code && code <= 51983 || 51985 <= code && code <= 52011 || 52013 <= code && code <= 52039 || 52041 <= code && code <= 52067 || 52069 <= code && code <= 52095 || 52097 <= code && code <= 52123 || 52125 <= code && code <= 52151 || 52153 <= code && code <= 52179 || 52181 <= code && code <= 52207 || 52209 <= code && code <= 52235 || 52237 <= code && code <= 52263 || 52265 <= code && code <= 52291 || 52293 <= code && code <= 52319 || 52321 <= code && code <= 52347 || 52349 <= code && code <= 52375 || 52377 <= code && code <= 52403 || 52405 <= code && code <= 52431 || 52433 <= code && code <= 52459 || 52461 <= code && code <= 52487 || 52489 <= code && code <= 52515 || 52517 <= code && code <= 52543 || 52545 <= code && code <= 52571 || 52573 <= code && code <= 52599 || 52601 <= code && code <= 52627 || 52629 <= code && code <= 52655 || 52657 <= code && code <= 52683 || 52685 <= code && code <= 52711 || 52713 <= code && code <= 52739 || 52741 <= code && code <= 52767 || 52769 <= code && code <= 52795 || 52797 <= code && code <= 52823 || 52825 <= code && code <= 52851 || 52853 <= code && code <= 52879 || 52881 <= code && code <= 52907 || 52909 <= code && code <= 52935 || 52937 <= code && code <= 52963 || 52965 <= code && code <= 52991 || 52993 <= code && code <= 53019 || 53021 <= code && code <= 53047 || 53049 <= code && code <= 53075 || 53077 <= code && code <= 53103 || 53105 <= code && code <= 53131 || 53133 <= code && code <= 53159 || 53161 <= code && code <= 53187 || 53189 <= code && code <= 53215 || 53217 <= code && code <= 53243 || 53245 <= code && code <= 53271 || 53273 <= code && code <= 53299 || 53301 <= code && code <= 53327 || 53329 <= code && code <= 53355 || 53357 <= code && code <= 53383 || 53385 <= code && code <= 53411 || 53413 <= code && code <= 53439 || 53441 <= code && code <= 53467 || 53469 <= code && code <= 53495 || 53497 <= code && code <= 53523 || 53525 <= code && code <= 53551 || 53553 <= code && code <= 53579 || 53581 <= code && code <= 53607 || 53609 <= code && code <= 53635 || 53637 <= code && code <= 53663 || 53665 <= code && code <= 53691 || 53693 <= code && code <= 53719 || 53721 <= code && code <= 53747 || 53749 <= code && code <= 53775 || 53777 <= code && code <= 53803 || 53805 <= code && code <= 53831 || 53833 <= code && code <= 53859 || 53861 <= code && code <= 53887 || 53889 <= code && code <= 53915 || 53917 <= code && code <= 53943 || 53945 <= code && code <= 53971 || 53973 <= code && code <= 53999 || 54001 <= code && code <= 54027 || 54029 <= code && code <= 54055 || 54057 <= code && code <= 54083 || 54085 <= code && code <= 54111 || 54113 <= code && code <= 54139 || 54141 <= code && code <= 54167 || 54169 <= code && code <= 54195 || 54197 <= code && code <= 54223 || 54225 <= code && code <= 54251 || 54253 <= code && code <= 54279 || 54281 <= code && code <= 54307 || 54309 <= code && code <= 54335 || 54337 <= code && code <= 54363 || 54365 <= code && code <= 54391 || 54393 <= code && code <= 54419 || 54421 <= code && code <= 54447 || 54449 <= code && code <= 54475 || 54477 <= code && code <= 54503 || 54505 <= code && code <= 54531 || 54533 <= code && code <= 54559 || 54561 <= code && code <= 54587 || 54589 <= code && code <= 54615 || 54617 <= code && code <= 54643 || 54645 <= code && code <= 54671 || 54673 <= code && code <= 54699 || 54701 <= code && code <= 54727 || 54729 <= code && code <= 54755 || 54757 <= code && code <= 54783 || 54785 <= code && code <= 54811 || 54813 <= code && code <= 54839 || 54841 <= code && code <= 54867 || 54869 <= code && code <= 54895 || 54897 <= code && code <= 54923 || 54925 <= code && code <= 54951 || 54953 <= code && code <= 54979 || 54981 <= code && code <= 55007 || 55009 <= code && code <= 55035 || 55037 <= code && code <= 55063 || 55065 <= code && code <= 55091 || 55093 <= code && code <= 55119 || 55121 <= code && code <= 55147 || 55149 <= code && code <= 55175 || 55177 <= code && code <= 55203) {
          return LVT;
        }
        if (9757 == code || 9977 == code || 9994 <= code && code <= 9997 || 127877 == code || 127938 <= code && code <= 127940 || 127943 == code || 127946 <= code && code <= 127948 || 128066 <= code && code <= 128067 || 128070 <= code && code <= 128080 || 128110 == code || 128112 <= code && code <= 128120 || 128124 == code || 128129 <= code && code <= 128131 || 128133 <= code && code <= 128135 || 128170 == code || 128372 <= code && code <= 128373 || 128378 == code || 128400 == code || 128405 <= code && code <= 128406 || 128581 <= code && code <= 128583 || 128587 <= code && code <= 128591 || 128675 == code || 128692 <= code && code <= 128694 || 128704 == code || 128716 == code || 129304 <= code && code <= 129308 || 129310 <= code && code <= 129311 || 129318 == code || 129328 <= code && code <= 129337 || 129341 <= code && code <= 129342 || 129489 <= code && code <= 129501) {
          return E_Base;
        }
        if (127995 <= code && code <= 127999) {
          return E_Modifier;
        }
        if (8205 == code) {
          return ZWJ;
        }
        if (9792 == code || 9794 == code || 9877 <= code && code <= 9878 || 9992 == code || 10084 == code || 127752 == code || 127806 == code || 127859 == code || 127891 == code || 127908 == code || 127912 == code || 127979 == code || 127981 == code || 128139 == code || 128187 <= code && code <= 128188 || 128295 == code || 128300 == code || 128488 == code || 128640 == code || 128658 == code) {
          return Glue_After_Zwj;
        }
        if (128102 <= code && code <= 128105) {
          return E_Base_GAZ;
        }
        return Other;
      }
      return this;
    }
    if (typeof module2 != "undefined" && module2.exports) {
      module2.exports = GraphemeSplitter2;
    }
  }
});

// node_modules/kdbush/kdbush.js
var require_kdbush = __commonJS({
  "node_modules/kdbush/kdbush.js"(exports2, module2) {
    (function(global2, factory) {
      typeof exports2 === "object" && typeof module2 !== "undefined" ? module2.exports = factory() : typeof define === "function" && define.amd ? define(factory) : global2.KDBush = factory();
    })(exports2, function() {
      "use strict";
      function sortKD(ids, coords, nodeSize, left, right, depth) {
        if (right - left <= nodeSize) {
          return;
        }
        var m = left + right >> 1;
        select(ids, coords, m, left, right, depth % 2);
        sortKD(ids, coords, nodeSize, left, m - 1, depth + 1);
        sortKD(ids, coords, nodeSize, m + 1, right, depth + 1);
      }
      function select(ids, coords, k, left, right, inc) {
        while (right > left) {
          if (right - left > 600) {
            var n = right - left + 1;
            var m = k - left + 1;
            var z = Math.log(n);
            var s = 0.5 * Math.exp(2 * z / 3);
            var sd = 0.5 * Math.sqrt(z * s * (n - s) / n) * (m - n / 2 < 0 ? -1 : 1);
            var newLeft = Math.max(left, Math.floor(k - m * s / n + sd));
            var newRight = Math.min(right, Math.floor(k + (n - m) * s / n + sd));
            select(ids, coords, k, newLeft, newRight, inc);
          }
          var t = coords[2 * k + inc];
          var i = left;
          var j = right;
          swapItem(ids, coords, left, k);
          if (coords[2 * right + inc] > t) {
            swapItem(ids, coords, left, right);
          }
          while (i < j) {
            swapItem(ids, coords, i, j);
            i++;
            j--;
            while (coords[2 * i + inc] < t) {
              i++;
            }
            while (coords[2 * j + inc] > t) {
              j--;
            }
          }
          if (coords[2 * left + inc] === t) {
            swapItem(ids, coords, left, j);
          } else {
            j++;
            swapItem(ids, coords, j, right);
          }
          if (j <= k) {
            left = j + 1;
          }
          if (k <= j) {
            right = j - 1;
          }
        }
      }
      function swapItem(ids, coords, i, j) {
        swap3(ids, i, j);
        swap3(coords, 2 * i, 2 * j);
        swap3(coords, 2 * i + 1, 2 * j + 1);
      }
      function swap3(arr, i, j) {
        var tmp2 = arr[i];
        arr[i] = arr[j];
        arr[j] = tmp2;
      }
      function range(ids, coords, minX, minY, maxX, maxY, nodeSize) {
        var stack = [0, ids.length - 1, 0];
        var result = [];
        var x, y;
        while (stack.length) {
          var axis = stack.pop();
          var right = stack.pop();
          var left = stack.pop();
          if (right - left <= nodeSize) {
            for (var i = left; i <= right; i++) {
              x = coords[2 * i];
              y = coords[2 * i + 1];
              if (x >= minX && x <= maxX && y >= minY && y <= maxY) {
                result.push(ids[i]);
              }
            }
            continue;
          }
          var m = Math.floor((left + right) / 2);
          x = coords[2 * m];
          y = coords[2 * m + 1];
          if (x >= minX && x <= maxX && y >= minY && y <= maxY) {
            result.push(ids[m]);
          }
          var nextAxis = (axis + 1) % 2;
          if (axis === 0 ? minX <= x : minY <= y) {
            stack.push(left);
            stack.push(m - 1);
            stack.push(nextAxis);
          }
          if (axis === 0 ? maxX >= x : maxY >= y) {
            stack.push(m + 1);
            stack.push(right);
            stack.push(nextAxis);
          }
        }
        return result;
      }
      function within(ids, coords, qx, qy, r, nodeSize) {
        var stack = [0, ids.length - 1, 0];
        var result = [];
        var r2 = r * r;
        while (stack.length) {
          var axis = stack.pop();
          var right = stack.pop();
          var left = stack.pop();
          if (right - left <= nodeSize) {
            for (var i = left; i <= right; i++) {
              if (sqDist(coords[2 * i], coords[2 * i + 1], qx, qy) <= r2) {
                result.push(ids[i]);
              }
            }
            continue;
          }
          var m = Math.floor((left + right) / 2);
          var x = coords[2 * m];
          var y = coords[2 * m + 1];
          if (sqDist(x, y, qx, qy) <= r2) {
            result.push(ids[m]);
          }
          var nextAxis = (axis + 1) % 2;
          if (axis === 0 ? qx - r <= x : qy - r <= y) {
            stack.push(left);
            stack.push(m - 1);
            stack.push(nextAxis);
          }
          if (axis === 0 ? qx + r >= x : qy + r >= y) {
            stack.push(m + 1);
            stack.push(right);
            stack.push(nextAxis);
          }
        }
        return result;
      }
      function sqDist(ax, ay, bx, by) {
        var dx = ax - bx;
        var dy = ay - by;
        return dx * dx + dy * dy;
      }
      var defaultGetX = function(p) {
        return p[0];
      };
      var defaultGetY = function(p) {
        return p[1];
      };
      var KDBush2 = function KDBush3(points, getX2, getY2, nodeSize, ArrayType) {
        if (getX2 === void 0)
          getX2 = defaultGetX;
        if (getY2 === void 0)
          getY2 = defaultGetY;
        if (nodeSize === void 0)
          nodeSize = 64;
        if (ArrayType === void 0)
          ArrayType = Float64Array;
        this.nodeSize = nodeSize;
        this.points = points;
        var IndexArrayType = points.length < 65536 ? Uint16Array : Uint32Array;
        var ids = this.ids = new IndexArrayType(points.length);
        var coords = this.coords = new ArrayType(points.length * 2);
        for (var i = 0; i < points.length; i++) {
          ids[i] = i;
          coords[2 * i] = getX2(points[i]);
          coords[2 * i + 1] = getY2(points[i]);
        }
        sortKD(ids, coords, nodeSize, 0, ids.length - 1, 0);
      };
      KDBush2.prototype.range = function range$1(minX, minY, maxX, maxY) {
        return range(this.ids, this.coords, minX, minY, maxX, maxY, this.nodeSize);
      };
      KDBush2.prototype.within = function within$1(x, y, r) {
        return within(this.ids, this.coords, x, y, r, this.nodeSize);
      };
      return KDBush2;
    });
  }
});

// node_modules/topojson-client/dist/topojson-client.js
var require_topojson_client = __commonJS({
  "node_modules/topojson-client/dist/topojson-client.js"(exports2, module2) {
    (function(global2, factory) {
      typeof exports2 === "object" && typeof module2 !== "undefined" ? factory(exports2) : typeof define === "function" && define.amd ? define(["exports"], factory) : (global2 = global2 || self, factory(global2.topojson = global2.topojson || {}));
    })(exports2, function(exports3) {
      "use strict";
      function identity(x) {
        return x;
      }
      function transform3(transform4) {
        if (transform4 == null)
          return identity;
        var x0, y0, kx = transform4.scale[0], ky = transform4.scale[1], dx = transform4.translate[0], dy = transform4.translate[1];
        return function(input, i) {
          if (!i)
            x0 = y0 = 0;
          var j = 2, n = input.length, output = new Array(n);
          output[0] = (x0 += input[0]) * kx + dx;
          output[1] = (y0 += input[1]) * ky + dy;
          while (j < n)
            output[j] = input[j], ++j;
          return output;
        };
      }
      function bbox(topology) {
        var t = transform3(topology.transform), key, x0 = Infinity, y0 = x0, x1 = -x0, y1 = -x0;
        function bboxPoint(p) {
          p = t(p);
          if (p[0] < x0)
            x0 = p[0];
          if (p[0] > x1)
            x1 = p[0];
          if (p[1] < y0)
            y0 = p[1];
          if (p[1] > y1)
            y1 = p[1];
        }
        function bboxGeometry(o) {
          switch (o.type) {
            case "GeometryCollection":
              o.geometries.forEach(bboxGeometry);
              break;
            case "Point":
              bboxPoint(o.coordinates);
              break;
            case "MultiPoint":
              o.coordinates.forEach(bboxPoint);
              break;
          }
        }
        topology.arcs.forEach(function(arc) {
          var i = -1, n = arc.length, p;
          while (++i < n) {
            p = t(arc[i], i);
            if (p[0] < x0)
              x0 = p[0];
            if (p[0] > x1)
              x1 = p[0];
            if (p[1] < y0)
              y0 = p[1];
            if (p[1] > y1)
              y1 = p[1];
          }
        });
        for (key in topology.objects) {
          bboxGeometry(topology.objects[key]);
        }
        return [x0, y0, x1, y1];
      }
      function reverse(array, n) {
        var t, j = array.length, i = j - n;
        while (i < --j)
          t = array[i], array[i++] = array[j], array[j] = t;
      }
      function feature2(topology, o) {
        if (typeof o === "string")
          o = topology.objects[o];
        return o.type === "GeometryCollection" ? { type: "FeatureCollection", features: o.geometries.map(function(o2) {
          return feature$1(topology, o2);
        }) } : feature$1(topology, o);
      }
      function feature$1(topology, o) {
        var id = o.id, bbox2 = o.bbox, properties = o.properties == null ? {} : o.properties, geometry = object(topology, o);
        return id == null && bbox2 == null ? { type: "Feature", properties, geometry } : bbox2 == null ? { type: "Feature", id, properties, geometry } : { type: "Feature", id, bbox: bbox2, properties, geometry };
      }
      function object(topology, o) {
        var transformPoint2 = transform3(topology.transform), arcs = topology.arcs;
        function arc(i, points) {
          if (points.length)
            points.pop();
          for (var a3 = arcs[i < 0 ? ~i : i], k = 0, n = a3.length; k < n; ++k) {
            points.push(transformPoint2(a3[k], k));
          }
          if (i < 0)
            reverse(points, n);
        }
        function point(p) {
          return transformPoint2(p);
        }
        function line(arcs2) {
          var points = [];
          for (var i = 0, n = arcs2.length; i < n; ++i)
            arc(arcs2[i], points);
          if (points.length < 2)
            points.push(points[0]);
          return points;
        }
        function ring(arcs2) {
          var points = line(arcs2);
          while (points.length < 4)
            points.push(points[0]);
          return points;
        }
        function polygon(arcs2) {
          return arcs2.map(ring);
        }
        function geometry(o2) {
          var type = o2.type, coordinates;
          switch (type) {
            case "GeometryCollection":
              return { type, geometries: o2.geometries.map(geometry) };
            case "Point":
              coordinates = point(o2.coordinates);
              break;
            case "MultiPoint":
              coordinates = o2.coordinates.map(point);
              break;
            case "LineString":
              coordinates = line(o2.arcs);
              break;
            case "MultiLineString":
              coordinates = o2.arcs.map(line);
              break;
            case "Polygon":
              coordinates = polygon(o2.arcs);
              break;
            case "MultiPolygon":
              coordinates = o2.arcs.map(polygon);
              break;
            default:
              return null;
          }
          return { type, coordinates };
        }
        return geometry(o);
      }
      function stitch(topology, arcs) {
        var stitchedArcs = {}, fragmentByStart = {}, fragmentByEnd = {}, fragments = [], emptyIndex = -1;
        arcs.forEach(function(i, j) {
          var arc = topology.arcs[i < 0 ? ~i : i], t;
          if (arc.length < 3 && !arc[1][0] && !arc[1][1]) {
            t = arcs[++emptyIndex], arcs[emptyIndex] = i, arcs[j] = t;
          }
        });
        arcs.forEach(function(i) {
          var e = ends(i), start = e[0], end = e[1], f, g;
          if (f = fragmentByEnd[start]) {
            delete fragmentByEnd[f.end];
            f.push(i);
            f.end = end;
            if (g = fragmentByStart[end]) {
              delete fragmentByStart[g.start];
              var fg = g === f ? f : f.concat(g);
              fragmentByStart[fg.start = f.start] = fragmentByEnd[fg.end = g.end] = fg;
            } else {
              fragmentByStart[f.start] = fragmentByEnd[f.end] = f;
            }
          } else if (f = fragmentByStart[end]) {
            delete fragmentByStart[f.start];
            f.unshift(i);
            f.start = start;
            if (g = fragmentByEnd[start]) {
              delete fragmentByEnd[g.end];
              var gf = g === f ? f : g.concat(f);
              fragmentByStart[gf.start = g.start] = fragmentByEnd[gf.end = f.end] = gf;
            } else {
              fragmentByStart[f.start] = fragmentByEnd[f.end] = f;
            }
          } else {
            f = [i];
            fragmentByStart[f.start = start] = fragmentByEnd[f.end = end] = f;
          }
        });
        function ends(i) {
          var arc = topology.arcs[i < 0 ? ~i : i], p0 = arc[0], p1;
          if (topology.transform)
            p1 = [0, 0], arc.forEach(function(dp) {
              p1[0] += dp[0], p1[1] += dp[1];
            });
          else
            p1 = arc[arc.length - 1];
          return i < 0 ? [p1, p0] : [p0, p1];
        }
        function flush(fragmentByEnd2, fragmentByStart2) {
          for (var k in fragmentByEnd2) {
            var f = fragmentByEnd2[k];
            delete fragmentByStart2[f.start];
            delete f.start;
            delete f.end;
            f.forEach(function(i) {
              stitchedArcs[i < 0 ? ~i : i] = 1;
            });
            fragments.push(f);
          }
        }
        flush(fragmentByEnd, fragmentByStart);
        flush(fragmentByStart, fragmentByEnd);
        arcs.forEach(function(i) {
          if (!stitchedArcs[i < 0 ? ~i : i])
            fragments.push([i]);
        });
        return fragments;
      }
      function mesh(topology) {
        return object(topology, meshArcs.apply(this, arguments));
      }
      function meshArcs(topology, object2, filter) {
        var arcs, i, n;
        if (arguments.length > 1)
          arcs = extractArcs(topology, object2, filter);
        else
          for (i = 0, arcs = new Array(n = topology.arcs.length); i < n; ++i)
            arcs[i] = i;
        return { type: "MultiLineString", arcs: stitch(topology, arcs) };
      }
      function extractArcs(topology, object2, filter) {
        var arcs = [], geomsByArc = [], geom;
        function extract0(i) {
          var j = i < 0 ? ~i : i;
          (geomsByArc[j] || (geomsByArc[j] = [])).push({ i, g: geom });
        }
        function extract1(arcs2) {
          arcs2.forEach(extract0);
        }
        function extract2(arcs2) {
          arcs2.forEach(extract1);
        }
        function extract3(arcs2) {
          arcs2.forEach(extract2);
        }
        function geometry(o) {
          switch (geom = o, o.type) {
            case "GeometryCollection":
              o.geometries.forEach(geometry);
              break;
            case "LineString":
              extract1(o.arcs);
              break;
            case "MultiLineString":
            case "Polygon":
              extract2(o.arcs);
              break;
            case "MultiPolygon":
              extract3(o.arcs);
              break;
          }
        }
        geometry(object2);
        geomsByArc.forEach(filter == null ? function(geoms) {
          arcs.push(geoms[0].i);
        } : function(geoms) {
          if (filter(geoms[0].g, geoms[geoms.length - 1].g))
            arcs.push(geoms[0].i);
        });
        return arcs;
      }
      function planarRingArea(ring) {
        var i = -1, n = ring.length, a3, b = ring[n - 1], area = 0;
        while (++i < n)
          a3 = b, b = ring[i], area += a3[0] * b[1] - a3[1] * b[0];
        return Math.abs(area);
      }
      function merge2(topology) {
        return object(topology, mergeArcs.apply(this, arguments));
      }
      function mergeArcs(topology, objects) {
        var polygonsByArc = {}, polygons = [], groups = [];
        objects.forEach(geometry);
        function geometry(o) {
          switch (o.type) {
            case "GeometryCollection":
              o.geometries.forEach(geometry);
              break;
            case "Polygon":
              extract(o.arcs);
              break;
            case "MultiPolygon":
              o.arcs.forEach(extract);
              break;
          }
        }
        function extract(polygon) {
          polygon.forEach(function(ring) {
            ring.forEach(function(arc) {
              (polygonsByArc[arc = arc < 0 ? ~arc : arc] || (polygonsByArc[arc] = [])).push(polygon);
            });
          });
          polygons.push(polygon);
        }
        function area(ring) {
          return planarRingArea(object(topology, { type: "Polygon", arcs: [ring] }).coordinates[0]);
        }
        polygons.forEach(function(polygon) {
          if (!polygon._) {
            var group = [], neighbors2 = [polygon];
            polygon._ = 1;
            groups.push(group);
            while (polygon = neighbors2.pop()) {
              group.push(polygon);
              polygon.forEach(function(ring) {
                ring.forEach(function(arc) {
                  polygonsByArc[arc < 0 ? ~arc : arc].forEach(function(polygon2) {
                    if (!polygon2._) {
                      polygon2._ = 1;
                      neighbors2.push(polygon2);
                    }
                  });
                });
              });
            }
          }
        });
        polygons.forEach(function(polygon) {
          delete polygon._;
        });
        return {
          type: "MultiPolygon",
          arcs: groups.map(function(polygons2) {
            var arcs = [], n;
            polygons2.forEach(function(polygon) {
              polygon.forEach(function(ring) {
                ring.forEach(function(arc) {
                  if (polygonsByArc[arc < 0 ? ~arc : arc].length < 2) {
                    arcs.push(arc);
                  }
                });
              });
            });
            arcs = stitch(topology, arcs);
            if ((n = arcs.length) > 1) {
              for (var i = 1, k = area(arcs[0]), ki, t; i < n; ++i) {
                if ((ki = area(arcs[i])) > k) {
                  t = arcs[0], arcs[0] = arcs[i], arcs[i] = t, k = ki;
                }
              }
            }
            return arcs;
          }).filter(function(arcs) {
            return arcs.length > 0;
          })
        };
      }
      function bisect(a3, x) {
        var lo = 0, hi = a3.length;
        while (lo < hi) {
          var mid = lo + hi >>> 1;
          if (a3[mid] < x)
            lo = mid + 1;
          else
            hi = mid;
        }
        return lo;
      }
      function neighbors(objects) {
        var indexesByArc = {}, neighbors2 = objects.map(function() {
          return [];
        });
        function line(arcs, i2) {
          arcs.forEach(function(a3) {
            if (a3 < 0)
              a3 = ~a3;
            var o = indexesByArc[a3];
            if (o)
              o.push(i2);
            else
              indexesByArc[a3] = [i2];
          });
        }
        function polygon(arcs, i2) {
          arcs.forEach(function(arc) {
            line(arc, i2);
          });
        }
        function geometry(o, i2) {
          if (o.type === "GeometryCollection")
            o.geometries.forEach(function(o2) {
              geometry(o2, i2);
            });
          else if (o.type in geometryType)
            geometryType[o.type](o.arcs, i2);
        }
        var geometryType = {
          LineString: line,
          MultiLineString: polygon,
          Polygon: polygon,
          MultiPolygon: function(arcs, i2) {
            arcs.forEach(function(arc) {
              polygon(arc, i2);
            });
          }
        };
        objects.forEach(geometry);
        for (var i in indexesByArc) {
          for (var indexes = indexesByArc[i], m = indexes.length, j = 0; j < m; ++j) {
            for (var k = j + 1; k < m; ++k) {
              var ij = indexes[j], ik = indexes[k], n;
              if ((n = neighbors2[ij])[i = bisect(n, ik)] !== ik)
                n.splice(i, 0, ik);
              if ((n = neighbors2[ik])[i = bisect(n, ij)] !== ij)
                n.splice(i, 0, ij);
            }
          }
        }
        return neighbors2;
      }
      function untransform(transform4) {
        if (transform4 == null)
          return identity;
        var x0, y0, kx = transform4.scale[0], ky = transform4.scale[1], dx = transform4.translate[0], dy = transform4.translate[1];
        return function(input, i) {
          if (!i)
            x0 = y0 = 0;
          var j = 2, n = input.length, output = new Array(n), x1 = Math.round((input[0] - dx) / kx), y1 = Math.round((input[1] - dy) / ky);
          output[0] = x1 - x0, x0 = x1;
          output[1] = y1 - y0, y0 = y1;
          while (j < n)
            output[j] = input[j], ++j;
          return output;
        };
      }
      function quantize(topology, transform4) {
        if (topology.transform)
          throw new Error("already quantized");
        if (!transform4 || !transform4.scale) {
          if (!((n = Math.floor(transform4)) >= 2))
            throw new Error("n must be \u22652");
          box = topology.bbox || bbox(topology);
          var x0 = box[0], y0 = box[1], x1 = box[2], y1 = box[3], n;
          transform4 = { scale: [x1 - x0 ? (x1 - x0) / (n - 1) : 1, y1 - y0 ? (y1 - y0) / (n - 1) : 1], translate: [x0, y0] };
        } else {
          box = topology.bbox;
        }
        var t = untransform(transform4), box, key, inputs = topology.objects, outputs = {};
        function quantizePoint(point) {
          return t(point);
        }
        function quantizeGeometry(input) {
          var output;
          switch (input.type) {
            case "GeometryCollection":
              output = { type: "GeometryCollection", geometries: input.geometries.map(quantizeGeometry) };
              break;
            case "Point":
              output = { type: "Point", coordinates: quantizePoint(input.coordinates) };
              break;
            case "MultiPoint":
              output = { type: "MultiPoint", coordinates: input.coordinates.map(quantizePoint) };
              break;
            default:
              return input;
          }
          if (input.id != null)
            output.id = input.id;
          if (input.bbox != null)
            output.bbox = input.bbox;
          if (input.properties != null)
            output.properties = input.properties;
          return output;
        }
        function quantizeArc(input) {
          var i = 0, j = 1, n2 = input.length, p, output = new Array(n2);
          output[0] = t(input[0], 0);
          while (++i < n2)
            if ((p = t(input[i], i))[0] || p[1])
              output[j++] = p;
          if (j === 1)
            output[j++] = [0, 0];
          output.length = j;
          return output;
        }
        for (key in inputs)
          outputs[key] = quantizeGeometry(inputs[key]);
        return {
          type: "Topology",
          bbox: box,
          transform: transform4,
          objects: outputs,
          arcs: topology.arcs.map(quantizeArc)
        };
      }
      exports3.bbox = bbox;
      exports3.feature = feature2;
      exports3.merge = merge2;
      exports3.mergeArcs = mergeArcs;
      exports3.mesh = mesh;
      exports3.meshArcs = meshArcs;
      exports3.neighbors = neighbors;
      exports3.quantize = quantize;
      exports3.transform = transform3;
      exports3.untransform = untransform;
      Object.defineProperty(exports3, "__esModule", { value: true });
    });
  }
});

// node_modules/autolinker/dist/commonjs/version.js
var require_version = __commonJS({
  "node_modules/autolinker/dist/commonjs/version.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.version = void 0;
    exports2.version = "3.16.0";
  }
});

// node_modules/autolinker/dist/commonjs/utils.js
var require_utils = __commonJS({
  "node_modules/autolinker/dist/commonjs/utils.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.throwUnhandledCaseError = exports2.splitAndCapture = exports2.remove = exports2.indexOf = exports2.ellipsis = exports2.defaults = void 0;
    function defaults(dest, src) {
      for (var prop in src) {
        if (src.hasOwnProperty(prop) && dest[prop] === void 0) {
          dest[prop] = src[prop];
        }
      }
      return dest;
    }
    exports2.defaults = defaults;
    function ellipsis(str, truncateLen, ellipsisChars) {
      var ellipsisLength;
      if (str.length > truncateLen) {
        if (ellipsisChars == null) {
          ellipsisChars = "&hellip;";
          ellipsisLength = 3;
        } else {
          ellipsisLength = ellipsisChars.length;
        }
        str = str.substring(0, truncateLen - ellipsisLength) + ellipsisChars;
      }
      return str;
    }
    exports2.ellipsis = ellipsis;
    function indexOf2(arr, element) {
      if (Array.prototype.indexOf) {
        return arr.indexOf(element);
      } else {
        for (var i = 0, len = arr.length; i < len; i++) {
          if (arr[i] === element)
            return i;
        }
        return -1;
      }
    }
    exports2.indexOf = indexOf2;
    function remove3(arr, fn) {
      for (var i = arr.length - 1; i >= 0; i--) {
        if (fn(arr[i]) === true) {
          arr.splice(i, 1);
        }
      }
    }
    exports2.remove = remove3;
    function splitAndCapture(str, splitRegex) {
      if (!splitRegex.global)
        throw new Error("`splitRegex` must have the 'g' flag set");
      var result = [], lastIdx = 0, match;
      while (match = splitRegex.exec(str)) {
        result.push(str.substring(lastIdx, match.index));
        result.push(match[0]);
        lastIdx = match.index + match[0].length;
      }
      result.push(str.substring(lastIdx));
      return result;
    }
    exports2.splitAndCapture = splitAndCapture;
    function throwUnhandledCaseError(theValue) {
      throw new Error("Unhandled case for value: '".concat(theValue, "'"));
    }
    exports2.throwUnhandledCaseError = throwUnhandledCaseError;
  }
});

// node_modules/autolinker/dist/commonjs/html-tag.js
var require_html_tag = __commonJS({
  "node_modules/autolinker/dist/commonjs/html-tag.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.HtmlTag = void 0;
    var utils_1 = require_utils();
    var HtmlTag = function() {
      function HtmlTag2(cfg) {
        if (cfg === void 0) {
          cfg = {};
        }
        this.tagName = "";
        this.attrs = {};
        this.innerHTML = "";
        this.whitespaceRegex = /\s+/;
        this.tagName = cfg.tagName || "";
        this.attrs = cfg.attrs || {};
        this.innerHTML = cfg.innerHtml || cfg.innerHTML || "";
      }
      HtmlTag2.prototype.setTagName = function(tagName) {
        this.tagName = tagName;
        return this;
      };
      HtmlTag2.prototype.getTagName = function() {
        return this.tagName || "";
      };
      HtmlTag2.prototype.setAttr = function(attrName, attrValue) {
        var tagAttrs = this.getAttrs();
        tagAttrs[attrName] = attrValue;
        return this;
      };
      HtmlTag2.prototype.getAttr = function(attrName) {
        return this.getAttrs()[attrName];
      };
      HtmlTag2.prototype.setAttrs = function(attrs) {
        Object.assign(this.getAttrs(), attrs);
        return this;
      };
      HtmlTag2.prototype.getAttrs = function() {
        return this.attrs || (this.attrs = {});
      };
      HtmlTag2.prototype.setClass = function(cssClass) {
        return this.setAttr("class", cssClass);
      };
      HtmlTag2.prototype.addClass = function(cssClass) {
        var classAttr = this.getClass(), whitespaceRegex = this.whitespaceRegex, classes = !classAttr ? [] : classAttr.split(whitespaceRegex), newClasses = cssClass.split(whitespaceRegex), newClass;
        while (newClass = newClasses.shift()) {
          if ((0, utils_1.indexOf)(classes, newClass) === -1) {
            classes.push(newClass);
          }
        }
        this.getAttrs()["class"] = classes.join(" ");
        return this;
      };
      HtmlTag2.prototype.removeClass = function(cssClass) {
        var classAttr = this.getClass(), whitespaceRegex = this.whitespaceRegex, classes = !classAttr ? [] : classAttr.split(whitespaceRegex), removeClasses = cssClass.split(whitespaceRegex), removeClass;
        while (classes.length && (removeClass = removeClasses.shift())) {
          var idx = (0, utils_1.indexOf)(classes, removeClass);
          if (idx !== -1) {
            classes.splice(idx, 1);
          }
        }
        this.getAttrs()["class"] = classes.join(" ");
        return this;
      };
      HtmlTag2.prototype.getClass = function() {
        return this.getAttrs()["class"] || "";
      };
      HtmlTag2.prototype.hasClass = function(cssClass) {
        return (" " + this.getClass() + " ").indexOf(" " + cssClass + " ") !== -1;
      };
      HtmlTag2.prototype.setInnerHTML = function(html) {
        this.innerHTML = html;
        return this;
      };
      HtmlTag2.prototype.setInnerHtml = function(html) {
        return this.setInnerHTML(html);
      };
      HtmlTag2.prototype.getInnerHTML = function() {
        return this.innerHTML || "";
      };
      HtmlTag2.prototype.getInnerHtml = function() {
        return this.getInnerHTML();
      };
      HtmlTag2.prototype.toAnchorString = function() {
        var tagName = this.getTagName(), attrsStr = this.buildAttrsStr();
        attrsStr = attrsStr ? " " + attrsStr : "";
        return ["<", tagName, attrsStr, ">", this.getInnerHtml(), "</", tagName, ">"].join("");
      };
      HtmlTag2.prototype.buildAttrsStr = function() {
        if (!this.attrs)
          return "";
        var attrs = this.getAttrs(), attrsArr = [];
        for (var prop in attrs) {
          if (attrs.hasOwnProperty(prop)) {
            attrsArr.push(prop + '="' + attrs[prop] + '"');
          }
        }
        return attrsArr.join(" ");
      };
      return HtmlTag2;
    }();
    exports2.HtmlTag = HtmlTag;
  }
});

// node_modules/autolinker/dist/commonjs/truncate/truncate-smart.js
var require_truncate_smart = __commonJS({
  "node_modules/autolinker/dist/commonjs/truncate/truncate-smart.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.truncateSmart = void 0;
    function truncateSmart(url2, truncateLen, ellipsisChars) {
      var ellipsisLengthBeforeParsing;
      var ellipsisLength;
      if (ellipsisChars == null) {
        ellipsisChars = "&hellip;";
        ellipsisLength = 3;
        ellipsisLengthBeforeParsing = 8;
      } else {
        ellipsisLength = ellipsisChars.length;
        ellipsisLengthBeforeParsing = ellipsisChars.length;
      }
      var parse_url = function(url3) {
        var urlObj2 = {};
        var urlSub = url3;
        var match = urlSub.match(/^([a-z]+):\/\//i);
        if (match) {
          urlObj2.scheme = match[1];
          urlSub = urlSub.substr(match[0].length);
        }
        match = urlSub.match(/^(.*?)(?=(\?|#|\/|$))/i);
        if (match) {
          urlObj2.host = match[1];
          urlSub = urlSub.substr(match[0].length);
        }
        match = urlSub.match(/^\/(.*?)(?=(\?|#|$))/i);
        if (match) {
          urlObj2.path = match[1];
          urlSub = urlSub.substr(match[0].length);
        }
        match = urlSub.match(/^\?(.*?)(?=(#|$))/i);
        if (match) {
          urlObj2.query = match[1];
          urlSub = urlSub.substr(match[0].length);
        }
        match = urlSub.match(/^#(.*?)$/i);
        if (match) {
          urlObj2.fragment = match[1];
        }
        return urlObj2;
      };
      var buildUrl = function(urlObj2) {
        var url3 = "";
        if (urlObj2.scheme && urlObj2.host) {
          url3 += urlObj2.scheme + "://";
        }
        if (urlObj2.host) {
          url3 += urlObj2.host;
        }
        if (urlObj2.path) {
          url3 += "/" + urlObj2.path;
        }
        if (urlObj2.query) {
          url3 += "?" + urlObj2.query;
        }
        if (urlObj2.fragment) {
          url3 += "#" + urlObj2.fragment;
        }
        return url3;
      };
      var buildSegment = function(segment, remainingAvailableLength3) {
        var remainingAvailableLengthHalf = remainingAvailableLength3 / 2, startOffset = Math.ceil(remainingAvailableLengthHalf), endOffset = -1 * Math.floor(remainingAvailableLengthHalf), end2 = "";
        if (endOffset < 0) {
          end2 = segment.substr(endOffset);
        }
        return segment.substr(0, startOffset) + ellipsisChars + end2;
      };
      if (url2.length <= truncateLen) {
        return url2;
      }
      var availableLength = truncateLen - ellipsisLength;
      var urlObj = parse_url(url2);
      if (urlObj.query) {
        var matchQuery = urlObj.query.match(/^(.*?)(?=(\?|\#))(.*?)$/i);
        if (matchQuery) {
          urlObj.query = urlObj.query.substr(0, matchQuery[1].length);
          url2 = buildUrl(urlObj);
        }
      }
      if (url2.length <= truncateLen) {
        return url2;
      }
      if (urlObj.host) {
        urlObj.host = urlObj.host.replace(/^www\./, "");
        url2 = buildUrl(urlObj);
      }
      if (url2.length <= truncateLen) {
        return url2;
      }
      var str = "";
      if (urlObj.host) {
        str += urlObj.host;
      }
      if (str.length >= availableLength) {
        if (urlObj.host.length == truncateLen) {
          return (urlObj.host.substr(0, truncateLen - ellipsisLength) + ellipsisChars).substr(0, availableLength + ellipsisLengthBeforeParsing);
        }
        return buildSegment(str, availableLength).substr(0, availableLength + ellipsisLengthBeforeParsing);
      }
      var pathAndQuery = "";
      if (urlObj.path) {
        pathAndQuery += "/" + urlObj.path;
      }
      if (urlObj.query) {
        pathAndQuery += "?" + urlObj.query;
      }
      if (pathAndQuery) {
        if ((str + pathAndQuery).length >= availableLength) {
          if ((str + pathAndQuery).length == truncateLen) {
            return (str + pathAndQuery).substr(0, truncateLen);
          }
          var remainingAvailableLength = availableLength - str.length;
          return (str + buildSegment(pathAndQuery, remainingAvailableLength)).substr(0, availableLength + ellipsisLengthBeforeParsing);
        } else {
          str += pathAndQuery;
        }
      }
      if (urlObj.fragment) {
        var fragment = "#" + urlObj.fragment;
        if ((str + fragment).length >= availableLength) {
          if ((str + fragment).length == truncateLen) {
            return (str + fragment).substr(0, truncateLen);
          }
          var remainingAvailableLength2 = availableLength - str.length;
          return (str + buildSegment(fragment, remainingAvailableLength2)).substr(0, availableLength + ellipsisLengthBeforeParsing);
        } else {
          str += fragment;
        }
      }
      if (urlObj.scheme && urlObj.host) {
        var scheme = urlObj.scheme + "://";
        if ((str + scheme).length < availableLength) {
          return (scheme + str).substr(0, truncateLen);
        }
      }
      if (str.length <= truncateLen) {
        return str;
      }
      var end = "";
      if (availableLength > 0) {
        end = str.substr(-1 * Math.floor(availableLength / 2));
      }
      return (str.substr(0, Math.ceil(availableLength / 2)) + ellipsisChars + end).substr(0, availableLength + ellipsisLengthBeforeParsing);
    }
    exports2.truncateSmart = truncateSmart;
  }
});

// node_modules/autolinker/dist/commonjs/truncate/truncate-middle.js
var require_truncate_middle = __commonJS({
  "node_modules/autolinker/dist/commonjs/truncate/truncate-middle.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.truncateMiddle = void 0;
    function truncateMiddle(url2, truncateLen, ellipsisChars) {
      if (url2.length <= truncateLen) {
        return url2;
      }
      var ellipsisLengthBeforeParsing;
      var ellipsisLength;
      if (ellipsisChars == null) {
        ellipsisChars = "&hellip;";
        ellipsisLengthBeforeParsing = 8;
        ellipsisLength = 3;
      } else {
        ellipsisLengthBeforeParsing = ellipsisChars.length;
        ellipsisLength = ellipsisChars.length;
      }
      var availableLength = truncateLen - ellipsisLength;
      var end = "";
      if (availableLength > 0) {
        end = url2.substr(-1 * Math.floor(availableLength / 2));
      }
      return (url2.substr(0, Math.ceil(availableLength / 2)) + ellipsisChars + end).substr(0, availableLength + ellipsisLengthBeforeParsing);
    }
    exports2.truncateMiddle = truncateMiddle;
  }
});

// node_modules/autolinker/dist/commonjs/truncate/truncate-end.js
var require_truncate_end = __commonJS({
  "node_modules/autolinker/dist/commonjs/truncate/truncate-end.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.truncateEnd = void 0;
    var utils_1 = require_utils();
    function truncateEnd(anchorText, truncateLen, ellipsisChars) {
      return (0, utils_1.ellipsis)(anchorText, truncateLen, ellipsisChars);
    }
    exports2.truncateEnd = truncateEnd;
  }
});

// node_modules/autolinker/dist/commonjs/anchor-tag-builder.js
var require_anchor_tag_builder = __commonJS({
  "node_modules/autolinker/dist/commonjs/anchor-tag-builder.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.AnchorTagBuilder = void 0;
    var html_tag_1 = require_html_tag();
    var truncate_smart_1 = require_truncate_smart();
    var truncate_middle_1 = require_truncate_middle();
    var truncate_end_1 = require_truncate_end();
    var AnchorTagBuilder = function() {
      function AnchorTagBuilder2(cfg) {
        if (cfg === void 0) {
          cfg = {};
        }
        this.newWindow = false;
        this.truncate = {};
        this.className = "";
        this.newWindow = cfg.newWindow || false;
        this.truncate = cfg.truncate || {};
        this.className = cfg.className || "";
      }
      AnchorTagBuilder2.prototype.build = function(match) {
        return new html_tag_1.HtmlTag({
          tagName: "a",
          attrs: this.createAttrs(match),
          innerHtml: this.processAnchorText(match.getAnchorText())
        });
      };
      AnchorTagBuilder2.prototype.createAttrs = function(match) {
        var attrs = {
          href: match.getAnchorHref()
        };
        var cssClass = this.createCssClass(match);
        if (cssClass) {
          attrs["class"] = cssClass;
        }
        if (this.newWindow) {
          attrs["target"] = "_blank";
          attrs["rel"] = "noopener noreferrer";
        }
        if (this.truncate) {
          if (this.truncate.length && this.truncate.length < match.getAnchorText().length) {
            attrs["title"] = match.getAnchorHref();
          }
        }
        return attrs;
      };
      AnchorTagBuilder2.prototype.createCssClass = function(match) {
        var className = this.className;
        if (!className) {
          return "";
        } else {
          var returnClasses = [className], cssClassSuffixes = match.getCssClassSuffixes();
          for (var i = 0, len = cssClassSuffixes.length; i < len; i++) {
            returnClasses.push(className + "-" + cssClassSuffixes[i]);
          }
          return returnClasses.join(" ");
        }
      };
      AnchorTagBuilder2.prototype.processAnchorText = function(anchorText) {
        anchorText = this.doTruncate(anchorText);
        return anchorText;
      };
      AnchorTagBuilder2.prototype.doTruncate = function(anchorText) {
        var truncate = this.truncate;
        if (!truncate || !truncate.length)
          return anchorText;
        var truncateLength = truncate.length, truncateLocation = truncate.location;
        if (truncateLocation === "smart") {
          return (0, truncate_smart_1.truncateSmart)(anchorText, truncateLength);
        } else if (truncateLocation === "middle") {
          return (0, truncate_middle_1.truncateMiddle)(anchorText, truncateLength);
        } else {
          return (0, truncate_end_1.truncateEnd)(anchorText, truncateLength);
        }
      };
      return AnchorTagBuilder2;
    }();
    exports2.AnchorTagBuilder = AnchorTagBuilder;
  }
});

// node_modules/autolinker/dist/commonjs/match/match.js
var require_match = __commonJS({
  "node_modules/autolinker/dist/commonjs/match/match.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.Match = void 0;
    var Match = function() {
      function Match2(cfg) {
        this.__jsduckDummyDocProp = null;
        this.matchedText = "";
        this.offset = 0;
        this.tagBuilder = cfg.tagBuilder;
        this.matchedText = cfg.matchedText;
        this.offset = cfg.offset;
      }
      Match2.prototype.getMatchedText = function() {
        return this.matchedText;
      };
      Match2.prototype.setOffset = function(offset2) {
        this.offset = offset2;
      };
      Match2.prototype.getOffset = function() {
        return this.offset;
      };
      Match2.prototype.getCssClassSuffixes = function() {
        return [this.getType()];
      };
      Match2.prototype.buildTag = function() {
        return this.tagBuilder.build(this);
      };
      return Match2;
    }();
    exports2.Match = Match;
  }
});

// node_modules/tslib/tslib.js
var require_tslib = __commonJS({
  "node_modules/tslib/tslib.js"(exports2, module2) {
    var __extends;
    var __assign;
    var __rest;
    var __decorate;
    var __param;
    var __metadata;
    var __awaiter;
    var __generator;
    var __exportStar;
    var __values;
    var __read;
    var __spread;
    var __spreadArrays;
    var __spreadArray;
    var __await;
    var __asyncGenerator;
    var __asyncDelegator;
    var __asyncValues;
    var __makeTemplateObject;
    var __importStar;
    var __importDefault;
    var __classPrivateFieldGet;
    var __classPrivateFieldSet;
    var __classPrivateFieldIn;
    var __createBinding;
    (function(factory) {
      var root = typeof global === "object" ? global : typeof self === "object" ? self : typeof this === "object" ? this : {};
      if (typeof define === "function" && define.amd) {
        define("tslib", ["exports"], function(exports3) {
          factory(createExporter(root, createExporter(exports3)));
        });
      } else if (typeof module2 === "object" && typeof module2.exports === "object") {
        factory(createExporter(root, createExporter(module2.exports)));
      } else {
        factory(createExporter(root));
      }
      function createExporter(exports3, previous) {
        if (exports3 !== root) {
          if (typeof Object.create === "function") {
            Object.defineProperty(exports3, "__esModule", { value: true });
          } else {
            exports3.__esModule = true;
          }
        }
        return function(id, v7) {
          return exports3[id] = previous ? previous(id, v7) : v7;
        };
      }
    })(function(exporter) {
      var extendStatics = Object.setPrototypeOf || { __proto__: [] } instanceof Array && function(d, b) {
        d.__proto__ = b;
      } || function(d, b) {
        for (var p in b)
          if (Object.prototype.hasOwnProperty.call(b, p))
            d[p] = b[p];
      };
      __extends = function(d, b) {
        if (typeof b !== "function" && b !== null)
          throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() {
          this.constructor = d;
        }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
      };
      __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
          s = arguments[i];
          for (var p in s)
            if (Object.prototype.hasOwnProperty.call(s, p))
              t[p] = s[p];
        }
        return t;
      };
      __rest = function(s, e) {
        var t = {};
        for (var p in s)
          if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
            t[p] = s[p];
        if (s != null && typeof Object.getOwnPropertySymbols === "function")
          for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
              t[p[i]] = s[p[i]];
          }
        return t;
      };
      __decorate = function(decorators, target, key, desc) {
        var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
        if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
          r = Reflect.decorate(decorators, target, key, desc);
        else
          for (var i = decorators.length - 1; i >= 0; i--)
            if (d = decorators[i])
              r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
        return c > 3 && r && Object.defineProperty(target, key, r), r;
      };
      __param = function(paramIndex, decorator) {
        return function(target, key) {
          decorator(target, key, paramIndex);
        };
      };
      __metadata = function(metadataKey, metadataValue) {
        if (typeof Reflect === "object" && typeof Reflect.metadata === "function")
          return Reflect.metadata(metadataKey, metadataValue);
      };
      __awaiter = function(thisArg, _arguments, P, generator) {
        function adopt(value) {
          return value instanceof P ? value : new P(function(resolve2) {
            resolve2(value);
          });
        }
        return new (P || (P = Promise))(function(resolve2, reject) {
          function fulfilled(value) {
            try {
              step2(generator.next(value));
            } catch (e) {
              reject(e);
            }
          }
          function rejected(value) {
            try {
              step2(generator["throw"](value));
            } catch (e) {
              reject(e);
            }
          }
          function step2(result) {
            result.done ? resolve2(result.value) : adopt(result.value).then(fulfilled, rejected);
          }
          step2((generator = generator.apply(thisArg, _arguments || [])).next());
        });
      };
      __generator = function(thisArg, body) {
        var _ = { label: 0, sent: function() {
          if (t[0] & 1)
            throw t[1];
          return t[1];
        }, trys: [], ops: [] }, f, y, t, g;
        return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() {
          return this;
        }), g;
        function verb(n) {
          return function(v7) {
            return step2([n, v7]);
          };
        }
        function step2(op) {
          if (f)
            throw new TypeError("Generator is already executing.");
          while (_)
            try {
              if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done)
                return t;
              if (y = 0, t)
                op = [op[0] & 2, t.value];
              switch (op[0]) {
                case 0:
                case 1:
                  t = op;
                  break;
                case 4:
                  _.label++;
                  return { value: op[1], done: false };
                case 5:
                  _.label++;
                  y = op[1];
                  op = [0];
                  continue;
                case 7:
                  op = _.ops.pop();
                  _.trys.pop();
                  continue;
                default:
                  if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) {
                    _ = 0;
                    continue;
                  }
                  if (op[0] === 3 && (!t || op[1] > t[0] && op[1] < t[3])) {
                    _.label = op[1];
                    break;
                  }
                  if (op[0] === 6 && _.label < t[1]) {
                    _.label = t[1];
                    t = op;
                    break;
                  }
                  if (t && _.label < t[2]) {
                    _.label = t[2];
                    _.ops.push(op);
                    break;
                  }
                  if (t[2])
                    _.ops.pop();
                  _.trys.pop();
                  continue;
              }
              op = body.call(thisArg, _);
            } catch (e) {
              op = [6, e];
              y = 0;
            } finally {
              f = t = 0;
            }
          if (op[0] & 5)
            throw op[1];
          return { value: op[0] ? op[1] : void 0, done: true };
        }
      };
      __exportStar = function(m, o) {
        for (var p in m)
          if (p !== "default" && !Object.prototype.hasOwnProperty.call(o, p))
            __createBinding(o, m, p);
      };
      __createBinding = Object.create ? function(o, m, k, k2) {
        if (k2 === void 0)
          k2 = k;
        var desc = Object.getOwnPropertyDescriptor(m, k);
        if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
          desc = { enumerable: true, get: function() {
            return m[k];
          } };
        }
        Object.defineProperty(o, k2, desc);
      } : function(o, m, k, k2) {
        if (k2 === void 0)
          k2 = k;
        o[k2] = m[k];
      };
      __values = function(o) {
        var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
        if (m)
          return m.call(o);
        if (o && typeof o.length === "number")
          return {
            next: function() {
              if (o && i >= o.length)
                o = void 0;
              return { value: o && o[i++], done: !o };
            }
          };
        throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
      };
      __read = function(o, n) {
        var m = typeof Symbol === "function" && o[Symbol.iterator];
        if (!m)
          return o;
        var i = m.call(o), r, ar = [], e;
        try {
          while ((n === void 0 || n-- > 0) && !(r = i.next()).done)
            ar.push(r.value);
        } catch (error) {
          e = { error };
        } finally {
          try {
            if (r && !r.done && (m = i["return"]))
              m.call(i);
          } finally {
            if (e)
              throw e.error;
          }
        }
        return ar;
      };
      __spread = function() {
        for (var ar = [], i = 0; i < arguments.length; i++)
          ar = ar.concat(__read(arguments[i]));
        return ar;
      };
      __spreadArrays = function() {
        for (var s = 0, i = 0, il = arguments.length; i < il; i++)
          s += arguments[i].length;
        for (var r = Array(s), k = 0, i = 0; i < il; i++)
          for (var a3 = arguments[i], j = 0, jl = a3.length; j < jl; j++, k++)
            r[k] = a3[j];
        return r;
      };
      __spreadArray = function(to, from, pack) {
        if (pack || arguments.length === 2)
          for (var i = 0, l = from.length, ar; i < l; i++) {
            if (ar || !(i in from)) {
              if (!ar)
                ar = Array.prototype.slice.call(from, 0, i);
              ar[i] = from[i];
            }
          }
        return to.concat(ar || Array.prototype.slice.call(from));
      };
      __await = function(v7) {
        return this instanceof __await ? (this.v = v7, this) : new __await(v7);
      };
      __asyncGenerator = function(thisArg, _arguments, generator) {
        if (!Symbol.asyncIterator)
          throw new TypeError("Symbol.asyncIterator is not defined.");
        var g = generator.apply(thisArg, _arguments || []), i, q = [];
        return i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function() {
          return this;
        }, i;
        function verb(n) {
          if (g[n])
            i[n] = function(v7) {
              return new Promise(function(a3, b) {
                q.push([n, v7, a3, b]) > 1 || resume(n, v7);
              });
            };
        }
        function resume(n, v7) {
          try {
            step2(g[n](v7));
          } catch (e) {
            settle(q[0][3], e);
          }
        }
        function step2(r) {
          r.value instanceof __await ? Promise.resolve(r.value.v).then(fulfill, reject) : settle(q[0][2], r);
        }
        function fulfill(value) {
          resume("next", value);
        }
        function reject(value) {
          resume("throw", value);
        }
        function settle(f, v7) {
          if (f(v7), q.shift(), q.length)
            resume(q[0][0], q[0][1]);
        }
      };
      __asyncDelegator = function(o) {
        var i, p;
        return i = {}, verb("next"), verb("throw", function(e) {
          throw e;
        }), verb("return"), i[Symbol.iterator] = function() {
          return this;
        }, i;
        function verb(n, f) {
          i[n] = o[n] ? function(v7) {
            return (p = !p) ? { value: __await(o[n](v7)), done: n === "return" } : f ? f(v7) : v7;
          } : f;
        }
      };
      __asyncValues = function(o) {
        if (!Symbol.asyncIterator)
          throw new TypeError("Symbol.asyncIterator is not defined.");
        var m = o[Symbol.asyncIterator], i;
        return m ? m.call(o) : (o = typeof __values === "function" ? __values(o) : o[Symbol.iterator](), i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function() {
          return this;
        }, i);
        function verb(n) {
          i[n] = o[n] && function(v7) {
            return new Promise(function(resolve2, reject) {
              v7 = o[n](v7), settle(resolve2, reject, v7.done, v7.value);
            });
          };
        }
        function settle(resolve2, reject, d, v7) {
          Promise.resolve(v7).then(function(v8) {
            resolve2({ value: v8, done: d });
          }, reject);
        }
      };
      __makeTemplateObject = function(cooked, raw) {
        if (Object.defineProperty) {
          Object.defineProperty(cooked, "raw", { value: raw });
        } else {
          cooked.raw = raw;
        }
        return cooked;
      };
      var __setModuleDefault = Object.create ? function(o, v7) {
        Object.defineProperty(o, "default", { enumerable: true, value: v7 });
      } : function(o, v7) {
        o["default"] = v7;
      };
      __importStar = function(mod2) {
        if (mod2 && mod2.__esModule)
          return mod2;
        var result = {};
        if (mod2 != null) {
          for (var k in mod2)
            if (k !== "default" && Object.prototype.hasOwnProperty.call(mod2, k))
              __createBinding(result, mod2, k);
        }
        __setModuleDefault(result, mod2);
        return result;
      };
      __importDefault = function(mod2) {
        return mod2 && mod2.__esModule ? mod2 : { "default": mod2 };
      };
      __classPrivateFieldGet = function(receiver, state, kind, f) {
        if (kind === "a" && !f)
          throw new TypeError("Private accessor was defined without a getter");
        if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver))
          throw new TypeError("Cannot read private member from an object whose class did not declare it");
        return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
      };
      __classPrivateFieldSet = function(receiver, state, value, kind, f) {
        if (kind === "m")
          throw new TypeError("Private method is not writable");
        if (kind === "a" && !f)
          throw new TypeError("Private accessor was defined without a setter");
        if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver))
          throw new TypeError("Cannot write private member to an object whose class did not declare it");
        return kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value), value;
      };
      __classPrivateFieldIn = function(state, receiver) {
        if (receiver === null || typeof receiver !== "object" && typeof receiver !== "function")
          throw new TypeError("Cannot use 'in' operator on non-object");
        return typeof state === "function" ? receiver === state : state.has(receiver);
      };
      exporter("__extends", __extends);
      exporter("__assign", __assign);
      exporter("__rest", __rest);
      exporter("__decorate", __decorate);
      exporter("__param", __param);
      exporter("__metadata", __metadata);
      exporter("__awaiter", __awaiter);
      exporter("__generator", __generator);
      exporter("__exportStar", __exportStar);
      exporter("__createBinding", __createBinding);
      exporter("__values", __values);
      exporter("__read", __read);
      exporter("__spread", __spread);
      exporter("__spreadArrays", __spreadArrays);
      exporter("__spreadArray", __spreadArray);
      exporter("__await", __await);
      exporter("__asyncGenerator", __asyncGenerator);
      exporter("__asyncDelegator", __asyncDelegator);
      exporter("__asyncValues", __asyncValues);
      exporter("__makeTemplateObject", __makeTemplateObject);
      exporter("__importStar", __importStar);
      exporter("__importDefault", __importDefault);
      exporter("__classPrivateFieldGet", __classPrivateFieldGet);
      exporter("__classPrivateFieldSet", __classPrivateFieldSet);
      exporter("__classPrivateFieldIn", __classPrivateFieldIn);
    });
  }
});

// node_modules/autolinker/dist/commonjs/match/email-match.js
var require_email_match = __commonJS({
  "node_modules/autolinker/dist/commonjs/match/email-match.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.EmailMatch = void 0;
    var tslib_1 = require_tslib();
    var match_1 = require_match();
    var EmailMatch = function(_super) {
      (0, tslib_1.__extends)(EmailMatch2, _super);
      function EmailMatch2(cfg) {
        var _this = _super.call(this, cfg) || this;
        _this.email = "";
        _this.email = cfg.email;
        return _this;
      }
      EmailMatch2.prototype.getType = function() {
        return "email";
      };
      EmailMatch2.prototype.getEmail = function() {
        return this.email;
      };
      EmailMatch2.prototype.getAnchorHref = function() {
        return "mailto:" + this.email;
      };
      EmailMatch2.prototype.getAnchorText = function() {
        return this.email;
      };
      return EmailMatch2;
    }(match_1.Match);
    exports2.EmailMatch = EmailMatch;
  }
});

// node_modules/autolinker/dist/commonjs/match/hashtag-match.js
var require_hashtag_match = __commonJS({
  "node_modules/autolinker/dist/commonjs/match/hashtag-match.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.HashtagMatch = void 0;
    var tslib_1 = require_tslib();
    var match_1 = require_match();
    var HashtagMatch = function(_super) {
      (0, tslib_1.__extends)(HashtagMatch2, _super);
      function HashtagMatch2(cfg) {
        var _this = _super.call(this, cfg) || this;
        _this.serviceName = "";
        _this.hashtag = "";
        _this.serviceName = cfg.serviceName;
        _this.hashtag = cfg.hashtag;
        return _this;
      }
      HashtagMatch2.prototype.getType = function() {
        return "hashtag";
      };
      HashtagMatch2.prototype.getServiceName = function() {
        return this.serviceName;
      };
      HashtagMatch2.prototype.getHashtag = function() {
        return this.hashtag;
      };
      HashtagMatch2.prototype.getAnchorHref = function() {
        var serviceName = this.serviceName, hashtag = this.hashtag;
        switch (serviceName) {
          case "twitter":
            return "https://twitter.com/hashtag/" + hashtag;
          case "facebook":
            return "https://www.facebook.com/hashtag/" + hashtag;
          case "instagram":
            return "https://instagram.com/explore/tags/" + hashtag;
          case "tiktok":
            return "https://www.tiktok.com/tag/" + hashtag;
          default:
            throw new Error("Unknown service name to point hashtag to: " + serviceName);
        }
      };
      HashtagMatch2.prototype.getAnchorText = function() {
        return "#" + this.hashtag;
      };
      return HashtagMatch2;
    }(match_1.Match);
    exports2.HashtagMatch = HashtagMatch;
  }
});

// node_modules/autolinker/dist/commonjs/match/mention-match.js
var require_mention_match = __commonJS({
  "node_modules/autolinker/dist/commonjs/match/mention-match.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.MentionMatch = void 0;
    var tslib_1 = require_tslib();
    var match_1 = require_match();
    var MentionMatch = function(_super) {
      (0, tslib_1.__extends)(MentionMatch2, _super);
      function MentionMatch2(cfg) {
        var _this = _super.call(this, cfg) || this;
        _this.serviceName = "twitter";
        _this.mention = "";
        _this.mention = cfg.mention;
        _this.serviceName = cfg.serviceName;
        return _this;
      }
      MentionMatch2.prototype.getType = function() {
        return "mention";
      };
      MentionMatch2.prototype.getMention = function() {
        return this.mention;
      };
      MentionMatch2.prototype.getServiceName = function() {
        return this.serviceName;
      };
      MentionMatch2.prototype.getAnchorHref = function() {
        switch (this.serviceName) {
          case "twitter":
            return "https://twitter.com/" + this.mention;
          case "instagram":
            return "https://instagram.com/" + this.mention;
          case "soundcloud":
            return "https://soundcloud.com/" + this.mention;
          case "tiktok":
            return "https://www.tiktok.com/@" + this.mention;
          default:
            throw new Error("Unknown service name to point mention to: " + this.serviceName);
        }
      };
      MentionMatch2.prototype.getAnchorText = function() {
        return "@" + this.mention;
      };
      MentionMatch2.prototype.getCssClassSuffixes = function() {
        var cssClassSuffixes = _super.prototype.getCssClassSuffixes.call(this), serviceName = this.getServiceName();
        if (serviceName) {
          cssClassSuffixes.push(serviceName);
        }
        return cssClassSuffixes;
      };
      return MentionMatch2;
    }(match_1.Match);
    exports2.MentionMatch = MentionMatch;
  }
});

// node_modules/autolinker/dist/commonjs/match/phone-match.js
var require_phone_match = __commonJS({
  "node_modules/autolinker/dist/commonjs/match/phone-match.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.PhoneMatch = void 0;
    var tslib_1 = require_tslib();
    var match_1 = require_match();
    var PhoneMatch = function(_super) {
      (0, tslib_1.__extends)(PhoneMatch2, _super);
      function PhoneMatch2(cfg) {
        var _this = _super.call(this, cfg) || this;
        _this.number = "";
        _this.plusSign = false;
        _this.number = cfg.number;
        _this.plusSign = cfg.plusSign;
        return _this;
      }
      PhoneMatch2.prototype.getType = function() {
        return "phone";
      };
      PhoneMatch2.prototype.getPhoneNumber = function() {
        return this.number;
      };
      PhoneMatch2.prototype.getNumber = function() {
        return this.getPhoneNumber();
      };
      PhoneMatch2.prototype.getAnchorHref = function() {
        return "tel:" + (this.plusSign ? "+" : "") + this.number;
      };
      PhoneMatch2.prototype.getAnchorText = function() {
        return this.matchedText;
      };
      return PhoneMatch2;
    }(match_1.Match);
    exports2.PhoneMatch = PhoneMatch;
  }
});

// node_modules/autolinker/dist/commonjs/match/url-match.js
var require_url_match = __commonJS({
  "node_modules/autolinker/dist/commonjs/match/url-match.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.UrlMatch = void 0;
    var tslib_1 = require_tslib();
    var match_1 = require_match();
    var UrlMatch = function(_super) {
      (0, tslib_1.__extends)(UrlMatch2, _super);
      function UrlMatch2(cfg) {
        var _this = _super.call(this, cfg) || this;
        _this.url = "";
        _this.urlMatchType = "scheme";
        _this.protocolUrlMatch = false;
        _this.protocolRelativeMatch = false;
        _this.stripPrefix = {
          scheme: true,
          www: true
        };
        _this.stripTrailingSlash = true;
        _this.decodePercentEncoding = true;
        _this.schemePrefixRegex = /^(https?:\/\/)?/i;
        _this.wwwPrefixRegex = /^(https?:\/\/)?(www\.)?/i;
        _this.protocolRelativeRegex = /^\/\//;
        _this.protocolPrepended = false;
        _this.urlMatchType = cfg.urlMatchType;
        _this.url = cfg.url;
        _this.protocolUrlMatch = cfg.protocolUrlMatch;
        _this.protocolRelativeMatch = cfg.protocolRelativeMatch;
        _this.stripPrefix = cfg.stripPrefix;
        _this.stripTrailingSlash = cfg.stripTrailingSlash;
        _this.decodePercentEncoding = cfg.decodePercentEncoding;
        return _this;
      }
      UrlMatch2.prototype.getType = function() {
        return "url";
      };
      UrlMatch2.prototype.getUrlMatchType = function() {
        return this.urlMatchType;
      };
      UrlMatch2.prototype.getUrl = function() {
        var url2 = this.url;
        if (!this.protocolRelativeMatch && !this.protocolUrlMatch && !this.protocolPrepended) {
          url2 = this.url = "http://" + url2;
          this.protocolPrepended = true;
        }
        return url2;
      };
      UrlMatch2.prototype.getAnchorHref = function() {
        var url2 = this.getUrl();
        return url2.replace(/&amp;/g, "&");
      };
      UrlMatch2.prototype.getAnchorText = function() {
        var anchorText = this.getMatchedText();
        if (this.protocolRelativeMatch) {
          anchorText = this.stripProtocolRelativePrefix(anchorText);
        }
        if (this.stripPrefix.scheme) {
          anchorText = this.stripSchemePrefix(anchorText);
        }
        if (this.stripPrefix.www) {
          anchorText = this.stripWwwPrefix(anchorText);
        }
        if (this.stripTrailingSlash) {
          anchorText = this.removeTrailingSlash(anchorText);
        }
        if (this.decodePercentEncoding) {
          anchorText = this.removePercentEncoding(anchorText);
        }
        return anchorText;
      };
      UrlMatch2.prototype.stripSchemePrefix = function(url2) {
        return url2.replace(this.schemePrefixRegex, "");
      };
      UrlMatch2.prototype.stripWwwPrefix = function(url2) {
        return url2.replace(this.wwwPrefixRegex, "$1");
      };
      UrlMatch2.prototype.stripProtocolRelativePrefix = function(text) {
        return text.replace(this.protocolRelativeRegex, "");
      };
      UrlMatch2.prototype.removeTrailingSlash = function(anchorText) {
        if (anchorText.charAt(anchorText.length - 1) === "/") {
          anchorText = anchorText.slice(0, -1);
        }
        return anchorText;
      };
      UrlMatch2.prototype.removePercentEncoding = function(anchorText) {
        var preProcessedEntityAnchorText = anchorText.replace(/%22/gi, "&quot;").replace(/%26/gi, "&amp;").replace(/%27/gi, "&#39;").replace(/%3C/gi, "&lt;").replace(/%3E/gi, "&gt;");
        try {
          return decodeURIComponent(preProcessedEntityAnchorText);
        } catch (e) {
          return preProcessedEntityAnchorText;
        }
      };
      return UrlMatch2;
    }(match_1.Match);
    exports2.UrlMatch = UrlMatch;
  }
});

// node_modules/autolinker/dist/commonjs/matcher/matcher.js
var require_matcher = __commonJS({
  "node_modules/autolinker/dist/commonjs/matcher/matcher.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.Matcher = void 0;
    var Matcher = function() {
      function Matcher2(cfg) {
        this.__jsduckDummyDocProp = null;
        this.tagBuilder = cfg.tagBuilder;
      }
      return Matcher2;
    }();
    exports2.Matcher = Matcher;
  }
});

// node_modules/autolinker/dist/commonjs/regex-lib.js
var require_regex_lib = __commonJS({
  "node_modules/autolinker/dist/commonjs/regex-lib.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.domainNameCharRegex = exports2.domainNameRegex = exports2.getDomainNameStr = exports2.alphaNumericAndMarksCharsStr = exports2.alphaNumericCharsStr = exports2.decimalNumbersStr = exports2.alphaCharsAndMarksStr = exports2.marksStr = exports2.emojiStr = exports2.alphaCharsStr = exports2.controlCharsRe = exports2.quoteRe = exports2.whitespaceRe = exports2.nonDigitRe = exports2.digitRe = exports2.letterRe = void 0;
    exports2.letterRe = /[A-Za-z]/;
    exports2.digitRe = /[\d]/;
    exports2.nonDigitRe = /[\D]/;
    exports2.whitespaceRe = /\s/;
    exports2.quoteRe = /['"]/;
    exports2.controlCharsRe = /[\x00-\x1F\x7F]/;
    exports2.alphaCharsStr = /A-Za-z\xAA\xB5\xBA\xC0-\xD6\xD8-\xF6\xF8-\u02C1\u02C6-\u02D1\u02E0-\u02E4\u02EC\u02EE\u0370-\u0374\u0376\u0377\u037A-\u037D\u037F\u0386\u0388-\u038A\u038C\u038E-\u03A1\u03A3-\u03F5\u03F7-\u0481\u048A-\u052F\u0531-\u0556\u0559\u0561-\u0587\u05D0-\u05EA\u05F0-\u05F2\u0620-\u064A\u066E\u066F\u0671-\u06D3\u06D5\u06E5\u06E6\u06EE\u06EF\u06FA-\u06FC\u06FF\u0710\u0712-\u072F\u074D-\u07A5\u07B1\u07CA-\u07EA\u07F4\u07F5\u07FA\u0800-\u0815\u081A\u0824\u0828\u0840-\u0858\u08A0-\u08B4\u08B6-\u08BD\u0904-\u0939\u093D\u0950\u0958-\u0961\u0971-\u0980\u0985-\u098C\u098F\u0990\u0993-\u09A8\u09AA-\u09B0\u09B2\u09B6-\u09B9\u09BD\u09CE\u09DC\u09DD\u09DF-\u09E1\u09F0\u09F1\u0A05-\u0A0A\u0A0F\u0A10\u0A13-\u0A28\u0A2A-\u0A30\u0A32\u0A33\u0A35\u0A36\u0A38\u0A39\u0A59-\u0A5C\u0A5E\u0A72-\u0A74\u0A85-\u0A8D\u0A8F-\u0A91\u0A93-\u0AA8\u0AAA-\u0AB0\u0AB2\u0AB3\u0AB5-\u0AB9\u0ABD\u0AD0\u0AE0\u0AE1\u0AF9\u0B05-\u0B0C\u0B0F\u0B10\u0B13-\u0B28\u0B2A-\u0B30\u0B32\u0B33\u0B35-\u0B39\u0B3D\u0B5C\u0B5D\u0B5F-\u0B61\u0B71\u0B83\u0B85-\u0B8A\u0B8E-\u0B90\u0B92-\u0B95\u0B99\u0B9A\u0B9C\u0B9E\u0B9F\u0BA3\u0BA4\u0BA8-\u0BAA\u0BAE-\u0BB9\u0BD0\u0C05-\u0C0C\u0C0E-\u0C10\u0C12-\u0C28\u0C2A-\u0C39\u0C3D\u0C58-\u0C5A\u0C60\u0C61\u0C80\u0C85-\u0C8C\u0C8E-\u0C90\u0C92-\u0CA8\u0CAA-\u0CB3\u0CB5-\u0CB9\u0CBD\u0CDE\u0CE0\u0CE1\u0CF1\u0CF2\u0D05-\u0D0C\u0D0E-\u0D10\u0D12-\u0D3A\u0D3D\u0D4E\u0D54-\u0D56\u0D5F-\u0D61\u0D7A-\u0D7F\u0D85-\u0D96\u0D9A-\u0DB1\u0DB3-\u0DBB\u0DBD\u0DC0-\u0DC6\u0E01-\u0E30\u0E32\u0E33\u0E40-\u0E46\u0E81\u0E82\u0E84\u0E87\u0E88\u0E8A\u0E8D\u0E94-\u0E97\u0E99-\u0E9F\u0EA1-\u0EA3\u0EA5\u0EA7\u0EAA\u0EAB\u0EAD-\u0EB0\u0EB2\u0EB3\u0EBD\u0EC0-\u0EC4\u0EC6\u0EDC-\u0EDF\u0F00\u0F40-\u0F47\u0F49-\u0F6C\u0F88-\u0F8C\u1000-\u102A\u103F\u1050-\u1055\u105A-\u105D\u1061\u1065\u1066\u106E-\u1070\u1075-\u1081\u108E\u10A0-\u10C5\u10C7\u10CD\u10D0-\u10FA\u10FC-\u1248\u124A-\u124D\u1250-\u1256\u1258\u125A-\u125D\u1260-\u1288\u128A-\u128D\u1290-\u12B0\u12B2-\u12B5\u12B8-\u12BE\u12C0\u12C2-\u12C5\u12C8-\u12D6\u12D8-\u1310\u1312-\u1315\u1318-\u135A\u1380-\u138F\u13A0-\u13F5\u13F8-\u13FD\u1401-\u166C\u166F-\u167F\u1681-\u169A\u16A0-\u16EA\u16F1-\u16F8\u1700-\u170C\u170E-\u1711\u1720-\u1731\u1740-\u1751\u1760-\u176C\u176E-\u1770\u1780-\u17B3\u17D7\u17DC\u1820-\u1877\u1880-\u1884\u1887-\u18A8\u18AA\u18B0-\u18F5\u1900-\u191E\u1950-\u196D\u1970-\u1974\u1980-\u19AB\u19B0-\u19C9\u1A00-\u1A16\u1A20-\u1A54\u1AA7\u1B05-\u1B33\u1B45-\u1B4B\u1B83-\u1BA0\u1BAE\u1BAF\u1BBA-\u1BE5\u1C00-\u1C23\u1C4D-\u1C4F\u1C5A-\u1C7D\u1C80-\u1C88\u1CE9-\u1CEC\u1CEE-\u1CF1\u1CF5\u1CF6\u1D00-\u1DBF\u1E00-\u1F15\u1F18-\u1F1D\u1F20-\u1F45\u1F48-\u1F4D\u1F50-\u1F57\u1F59\u1F5B\u1F5D\u1F5F-\u1F7D\u1F80-\u1FB4\u1FB6-\u1FBC\u1FBE\u1FC2-\u1FC4\u1FC6-\u1FCC\u1FD0-\u1FD3\u1FD6-\u1FDB\u1FE0-\u1FEC\u1FF2-\u1FF4\u1FF6-\u1FFC\u2071\u207F\u2090-\u209C\u2102\u2107\u210A-\u2113\u2115\u2119-\u211D\u2124\u2126\u2128\u212A-\u212D\u212F-\u2139\u213C-\u213F\u2145-\u2149\u214E\u2183\u2184\u2C00-\u2C2E\u2C30-\u2C5E\u2C60-\u2CE4\u2CEB-\u2CEE\u2CF2\u2CF3\u2D00-\u2D25\u2D27\u2D2D\u2D30-\u2D67\u2D6F\u2D80-\u2D96\u2DA0-\u2DA6\u2DA8-\u2DAE\u2DB0-\u2DB6\u2DB8-\u2DBE\u2DC0-\u2DC6\u2DC8-\u2DCE\u2DD0-\u2DD6\u2DD8-\u2DDE\u2E2F\u3005\u3006\u3031-\u3035\u303B\u303C\u3041-\u3096\u309D-\u309F\u30A1-\u30FA\u30FC-\u30FF\u3105-\u312D\u3131-\u318E\u31A0-\u31BA\u31F0-\u31FF\u3400-\u4DB5\u4E00-\u9FD5\uA000-\uA48C\uA4D0-\uA4FD\uA500-\uA60C\uA610-\uA61F\uA62A\uA62B\uA640-\uA66E\uA67F-\uA69D\uA6A0-\uA6E5\uA717-\uA71F\uA722-\uA788\uA78B-\uA7AE\uA7B0-\uA7B7\uA7F7-\uA801\uA803-\uA805\uA807-\uA80A\uA80C-\uA822\uA840-\uA873\uA882-\uA8B3\uA8F2-\uA8F7\uA8FB\uA8FD\uA90A-\uA925\uA930-\uA946\uA960-\uA97C\uA984-\uA9B2\uA9CF\uA9E0-\uA9E4\uA9E6-\uA9EF\uA9FA-\uA9FE\uAA00-\uAA28\uAA40-\uAA42\uAA44-\uAA4B\uAA60-\uAA76\uAA7A\uAA7E-\uAAAF\uAAB1\uAAB5\uAAB6\uAAB9-\uAABD\uAAC0\uAAC2\uAADB-\uAADD\uAAE0-\uAAEA\uAAF2-\uAAF4\uAB01-\uAB06\uAB09-\uAB0E\uAB11-\uAB16\uAB20-\uAB26\uAB28-\uAB2E\uAB30-\uAB5A\uAB5C-\uAB65\uAB70-\uABE2\uAC00-\uD7A3\uD7B0-\uD7C6\uD7CB-\uD7FB\uF900-\uFA6D\uFA70-\uFAD9\uFB00-\uFB06\uFB13-\uFB17\uFB1D\uFB1F-\uFB28\uFB2A-\uFB36\uFB38-\uFB3C\uFB3E\uFB40\uFB41\uFB43\uFB44\uFB46-\uFBB1\uFBD3-\uFD3D\uFD50-\uFD8F\uFD92-\uFDC7\uFDF0-\uFDFB\uFE70-\uFE74\uFE76-\uFEFC\uFF21-\uFF3A\uFF41-\uFF5A\uFF66-\uFFBE\uFFC2-\uFFC7\uFFCA-\uFFCF\uFFD2-\uFFD7\uFFDA-\uFFDC/.source;
    exports2.emojiStr = /\u2700-\u27bf\udde6-\uddff\ud800-\udbff\udc00-\udfff\ufe0e\ufe0f\u0300-\u036f\ufe20-\ufe23\u20d0-\u20f0\ud83c\udffb-\udfff\u200d\u3299\u3297\u303d\u3030\u24c2\ud83c\udd70-\udd71\udd7e-\udd7f\udd8e\udd91-\udd9a\udde6-\uddff\ude01-\ude02\ude1a\ude2f\ude32-\ude3a\ude50-\ude51\u203c\u2049\u25aa-\u25ab\u25b6\u25c0\u25fb-\u25fe\u00a9\u00ae\u2122\u2139\udc04\u2600-\u26FF\u2b05\u2b06\u2b07\u2b1b\u2b1c\u2b50\u2b55\u231a\u231b\u2328\u23cf\u23e9-\u23f3\u23f8-\u23fa\udccf\u2935\u2934\u2190-\u21ff/.source;
    exports2.marksStr = /\u0300-\u036F\u0483-\u0489\u0591-\u05BD\u05BF\u05C1\u05C2\u05C4\u05C5\u05C7\u0610-\u061A\u064B-\u065F\u0670\u06D6-\u06DC\u06DF-\u06E4\u06E7\u06E8\u06EA-\u06ED\u0711\u0730-\u074A\u07A6-\u07B0\u07EB-\u07F3\u0816-\u0819\u081B-\u0823\u0825-\u0827\u0829-\u082D\u0859-\u085B\u08D4-\u08E1\u08E3-\u0903\u093A-\u093C\u093E-\u094F\u0951-\u0957\u0962\u0963\u0981-\u0983\u09BC\u09BE-\u09C4\u09C7\u09C8\u09CB-\u09CD\u09D7\u09E2\u09E3\u0A01-\u0A03\u0A3C\u0A3E-\u0A42\u0A47\u0A48\u0A4B-\u0A4D\u0A51\u0A70\u0A71\u0A75\u0A81-\u0A83\u0ABC\u0ABE-\u0AC5\u0AC7-\u0AC9\u0ACB-\u0ACD\u0AE2\u0AE3\u0B01-\u0B03\u0B3C\u0B3E-\u0B44\u0B47\u0B48\u0B4B-\u0B4D\u0B56\u0B57\u0B62\u0B63\u0B82\u0BBE-\u0BC2\u0BC6-\u0BC8\u0BCA-\u0BCD\u0BD7\u0C00-\u0C03\u0C3E-\u0C44\u0C46-\u0C48\u0C4A-\u0C4D\u0C55\u0C56\u0C62\u0C63\u0C81-\u0C83\u0CBC\u0CBE-\u0CC4\u0CC6-\u0CC8\u0CCA-\u0CCD\u0CD5\u0CD6\u0CE2\u0CE3\u0D01-\u0D03\u0D3E-\u0D44\u0D46-\u0D48\u0D4A-\u0D4D\u0D57\u0D62\u0D63\u0D82\u0D83\u0DCA\u0DCF-\u0DD4\u0DD6\u0DD8-\u0DDF\u0DF2\u0DF3\u0E31\u0E34-\u0E3A\u0E47-\u0E4E\u0EB1\u0EB4-\u0EB9\u0EBB\u0EBC\u0EC8-\u0ECD\u0F18\u0F19\u0F35\u0F37\u0F39\u0F3E\u0F3F\u0F71-\u0F84\u0F86\u0F87\u0F8D-\u0F97\u0F99-\u0FBC\u0FC6\u102B-\u103E\u1056-\u1059\u105E-\u1060\u1062-\u1064\u1067-\u106D\u1071-\u1074\u1082-\u108D\u108F\u109A-\u109D\u135D-\u135F\u1712-\u1714\u1732-\u1734\u1752\u1753\u1772\u1773\u17B4-\u17D3\u17DD\u180B-\u180D\u1885\u1886\u18A9\u1920-\u192B\u1930-\u193B\u1A17-\u1A1B\u1A55-\u1A5E\u1A60-\u1A7C\u1A7F\u1AB0-\u1ABE\u1B00-\u1B04\u1B34-\u1B44\u1B6B-\u1B73\u1B80-\u1B82\u1BA1-\u1BAD\u1BE6-\u1BF3\u1C24-\u1C37\u1CD0-\u1CD2\u1CD4-\u1CE8\u1CED\u1CF2-\u1CF4\u1CF8\u1CF9\u1DC0-\u1DF5\u1DFB-\u1DFF\u20D0-\u20F0\u2CEF-\u2CF1\u2D7F\u2DE0-\u2DFF\u302A-\u302F\u3099\u309A\uA66F-\uA672\uA674-\uA67D\uA69E\uA69F\uA6F0\uA6F1\uA802\uA806\uA80B\uA823-\uA827\uA880\uA881\uA8B4-\uA8C5\uA8E0-\uA8F1\uA926-\uA92D\uA947-\uA953\uA980-\uA983\uA9B3-\uA9C0\uA9E5\uAA29-\uAA36\uAA43\uAA4C\uAA4D\uAA7B-\uAA7D\uAAB0\uAAB2-\uAAB4\uAAB7\uAAB8\uAABE\uAABF\uAAC1\uAAEB-\uAAEF\uAAF5\uAAF6\uABE3-\uABEA\uABEC\uABED\uFB1E\uFE00-\uFE0F\uFE20-\uFE2F/.source;
    exports2.alphaCharsAndMarksStr = exports2.alphaCharsStr + exports2.emojiStr + exports2.marksStr;
    exports2.decimalNumbersStr = /0-9\u0660-\u0669\u06F0-\u06F9\u07C0-\u07C9\u0966-\u096F\u09E6-\u09EF\u0A66-\u0A6F\u0AE6-\u0AEF\u0B66-\u0B6F\u0BE6-\u0BEF\u0C66-\u0C6F\u0CE6-\u0CEF\u0D66-\u0D6F\u0DE6-\u0DEF\u0E50-\u0E59\u0ED0-\u0ED9\u0F20-\u0F29\u1040-\u1049\u1090-\u1099\u17E0-\u17E9\u1810-\u1819\u1946-\u194F\u19D0-\u19D9\u1A80-\u1A89\u1A90-\u1A99\u1B50-\u1B59\u1BB0-\u1BB9\u1C40-\u1C49\u1C50-\u1C59\uA620-\uA629\uA8D0-\uA8D9\uA900-\uA909\uA9D0-\uA9D9\uA9F0-\uA9F9\uAA50-\uAA59\uABF0-\uABF9\uFF10-\uFF19/.source;
    exports2.alphaNumericCharsStr = exports2.alphaCharsAndMarksStr + exports2.decimalNumbersStr;
    exports2.alphaNumericAndMarksCharsStr = exports2.alphaCharsAndMarksStr + exports2.decimalNumbersStr;
    var ipStr = "(?:[" + exports2.decimalNumbersStr + "]{1,3}\\.){3}[" + exports2.decimalNumbersStr + "]{1,3}";
    var domainLabelStr = "[" + exports2.alphaNumericAndMarksCharsStr + "](?:[" + exports2.alphaNumericAndMarksCharsStr + "\\-_]{0,61}[" + exports2.alphaNumericAndMarksCharsStr + "])?";
    var getDomainLabelStr = function(group) {
      return "(?=(" + domainLabelStr + "))\\" + group;
    };
    var getDomainNameStr = function(group) {
      return "(?:" + getDomainLabelStr(group) + "(?:\\." + getDomainLabelStr(group + 1) + "){0,126}|" + ipStr + ")";
    };
    exports2.getDomainNameStr = getDomainNameStr;
    exports2.domainNameRegex = new RegExp("[" + exports2.alphaNumericAndMarksCharsStr + ".\\-]*[" + exports2.alphaNumericAndMarksCharsStr + "\\-]");
    exports2.domainNameCharRegex = new RegExp("[".concat(exports2.alphaNumericAndMarksCharsStr, "]"));
  }
});

// node_modules/autolinker/dist/commonjs/matcher/tld-regex.js
var require_tld_regex = __commonJS({
  "node_modules/autolinker/dist/commonjs/matcher/tld-regex.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.tldRegex = void 0;
    exports2.tldRegex = /(?:xn--vermgensberatung-pwb|xn--vermgensberater-ctb|xn--clchc0ea0b2g2a9gcd|xn--w4r85el8fhu5dnra|northwesternmutual|travelersinsurance|vermögensberatung|xn--5su34j936bgsg|xn--bck1b9a5dre4c|xn--mgbah1a3hjkrd|xn--mgbai9azgqp6j|xn--mgberp4a5d4ar|xn--xkc2dl3a5ee0h|vermögensberater|xn--fzys8d69uvgm|xn--mgba7c0bbn0a|xn--mgbcpq6gpa1a|xn--xkc2al3hye2a|americanexpress|kerryproperties|sandvikcoromant|xn--i1b6b1a6a2e|xn--kcrx77d1x4a|xn--lgbbat1ad8j|xn--mgba3a4f16a|xn--mgbaakc7dvf|xn--mgbc0a9azcg|xn--nqv7fs00ema|americanfamily|bananarepublic|cancerresearch|cookingchannel|kerrylogistics|weatherchannel|xn--54b7fta0cc|xn--6qq986b3xl|xn--80aqecdr1a|xn--b4w605ferd|xn--fiq228c5hs|xn--h2breg3eve|xn--jlq480n2rg|xn--jlq61u9w7b|xn--mgba3a3ejt|xn--mgbaam7a8h|xn--mgbayh7gpa|xn--mgbbh1a71e|xn--mgbca7dzdo|xn--mgbi4ecexp|xn--mgbx4cd0ab|xn--rvc1e0am3e|international|lifeinsurance|travelchannel|wolterskluwer|xn--cckwcxetd|xn--eckvdtc9d|xn--fpcrj9c3d|xn--fzc2c9e2c|xn--h2brj9c8c|xn--tiq49xqyj|xn--yfro4i67o|xn--ygbi2ammx|construction|lplfinancial|scholarships|versicherung|xn--3e0b707e|xn--45br5cyl|xn--4dbrk0ce|xn--80adxhks|xn--80asehdb|xn--8y0a063a|xn--gckr3f0f|xn--mgb9awbf|xn--mgbab2bd|xn--mgbgu82a|xn--mgbpl2fh|xn--mgbt3dhd|xn--mk1bu44c|xn--ngbc5azd|xn--ngbe9e0a|xn--ogbpf8fl|xn--qcka1pmc|accountants|barclaycard|blackfriday|blockbuster|bridgestone|calvinklein|contractors|creditunion|engineering|enterprises|foodnetwork|investments|kerryhotels|lamborghini|motorcycles|olayangroup|photography|playstation|productions|progressive|redumbrella|williamhill|xn--11b4c3d|xn--1ck2e1b|xn--1qqw23a|xn--2scrj9c|xn--3bst00m|xn--3ds443g|xn--3hcrj9c|xn--42c2d9a|xn--45brj9c|xn--55qw42g|xn--6frz82g|xn--80ao21a|xn--9krt00a|xn--cck2b3b|xn--czr694b|xn--d1acj3b|xn--efvy88h|xn--fct429k|xn--fjq720a|xn--flw351e|xn--g2xx48c|xn--gecrj9c|xn--gk3at1e|xn--h2brj9c|xn--hxt814e|xn--imr513n|xn--j6w193g|xn--jvr189m|xn--kprw13d|xn--kpry57d|xn--mgbbh1a|xn--mgbtx2b|xn--mix891f|xn--nyqy26a|xn--otu796d|xn--pgbs0dh|xn--q9jyb4c|xn--rhqv96g|xn--rovu88b|xn--s9brj9c|xn--ses554g|xn--t60b56a|xn--vuq861b|xn--w4rs40l|xn--xhq521b|xn--zfr164b|சிங்கப்பூர்|accountant|apartments|associates|basketball|bnpparibas|boehringer|capitalone|consulting|creditcard|cuisinella|eurovision|extraspace|foundation|healthcare|immobilien|industries|management|mitsubishi|nextdirect|properties|protection|prudential|realestate|republican|restaurant|schaeffler|tatamotors|technology|university|vlaanderen|volkswagen|xn--30rr7y|xn--3pxu8k|xn--45q11c|xn--4gbrim|xn--55qx5d|xn--5tzm5g|xn--80aswg|xn--90a3ac|xn--9dbq2a|xn--9et52u|xn--c2br7g|xn--cg4bki|xn--czrs0t|xn--czru2d|xn--fiq64b|xn--fiqs8s|xn--fiqz9s|xn--io0a7i|xn--kput3i|xn--mxtq1m|xn--o3cw4h|xn--pssy2u|xn--q7ce6a|xn--unup4y|xn--wgbh1c|xn--wgbl6a|xn--y9a3aq|accenture|alfaromeo|allfinanz|amsterdam|analytics|aquarelle|barcelona|bloomberg|christmas|community|directory|education|equipment|fairwinds|financial|firestone|fresenius|frontdoor|furniture|goldpoint|hisamitsu|homedepot|homegoods|homesense|institute|insurance|kuokgroup|lancaster|landrover|lifestyle|marketing|marshalls|melbourne|microsoft|panasonic|passagens|pramerica|richardli|shangrila|solutions|statebank|statefarm|stockholm|travelers|vacations|xn--90ais|xn--c1avg|xn--d1alf|xn--e1a4c|xn--fhbei|xn--j1aef|xn--j1amh|xn--l1acc|xn--ngbrx|xn--nqv7f|xn--p1acf|xn--qxa6a|xn--tckwe|xn--vhquv|yodobashi|موريتانيا|abudhabi|airforce|allstate|attorney|barclays|barefoot|bargains|baseball|boutique|bradesco|broadway|brussels|builders|business|capetown|catering|catholic|cipriani|cityeats|cleaning|clinique|clothing|commbank|computer|delivery|deloitte|democrat|diamonds|discount|discover|download|engineer|ericsson|etisalat|exchange|feedback|fidelity|firmdale|football|frontier|goodyear|grainger|graphics|guardian|hdfcbank|helsinki|holdings|hospital|infiniti|ipiranga|istanbul|jpmorgan|lighting|lundbeck|marriott|maserati|mckinsey|memorial|merckmsd|mortgage|observer|partners|pharmacy|pictures|plumbing|property|redstone|reliance|saarland|samsclub|security|services|shopping|showtime|softbank|software|stcgroup|supplies|training|vanguard|ventures|verisign|woodside|xn--90ae|xn--node|xn--p1ai|xn--qxam|yokohama|السعودية|abogado|academy|agakhan|alibaba|android|athleta|auction|audible|auspost|avianca|banamex|bauhaus|bentley|bestbuy|booking|brother|bugatti|capital|caravan|careers|channel|charity|chintai|citadel|clubmed|college|cologne|comcast|company|compare|contact|cooking|corsica|country|coupons|courses|cricket|cruises|dentist|digital|domains|exposed|express|farmers|fashion|ferrari|ferrero|finance|fishing|fitness|flights|florist|flowers|forsale|frogans|fujitsu|gallery|genting|godaddy|grocery|guitars|hamburg|hangout|hitachi|holiday|hosting|hoteles|hotmail|hyundai|ismaili|jewelry|juniper|kitchen|komatsu|lacaixa|lanxess|lasalle|latrobe|leclerc|limited|lincoln|markets|monster|netbank|netflix|network|neustar|okinawa|oldnavy|organic|origins|philips|pioneer|politie|realtor|recipes|rentals|reviews|rexroth|samsung|sandvik|schmidt|schwarz|science|shiksha|singles|staples|storage|support|surgery|systems|temasek|theater|theatre|tickets|tiffany|toshiba|trading|walmart|wanggou|watches|weather|website|wedding|whoswho|windows|winners|xfinity|yamaxun|youtube|zuerich|католик|اتصالات|البحرين|الجزائر|العليان|پاکستان|كاثوليك|இந்தியா|abarth|abbott|abbvie|africa|agency|airbus|airtel|alipay|alsace|alstom|amazon|anquan|aramco|author|bayern|beauty|berlin|bharti|bostik|boston|broker|camera|career|casino|center|chanel|chrome|church|circle|claims|clinic|coffee|comsec|condos|coupon|credit|cruise|dating|datsun|dealer|degree|dental|design|direct|doctor|dunlop|dupont|durban|emerck|energy|estate|events|expert|family|flickr|futbol|gallup|garden|george|giving|global|google|gratis|health|hermes|hiphop|hockey|hotels|hughes|imamat|insure|intuit|jaguar|joburg|juegos|kaufen|kinder|kindle|kosher|lancia|latino|lawyer|lefrak|living|locker|london|luxury|madrid|maison|makeup|market|mattel|mobile|monash|mormon|moscow|museum|mutual|nagoya|natura|nissan|nissay|norton|nowruz|office|olayan|online|oracle|orange|otsuka|pfizer|photos|physio|pictet|quebec|racing|realty|reisen|repair|report|review|rocher|rogers|ryukyu|safety|sakura|sanofi|school|schule|search|secure|select|shouji|soccer|social|stream|studio|supply|suzuki|swatch|sydney|taipei|taobao|target|tattoo|tennis|tienda|tjmaxx|tkmaxx|toyota|travel|unicom|viajes|viking|villas|virgin|vision|voting|voyage|vuelos|walter|webcam|xihuan|yachts|yandex|zappos|москва|онлайн|ابوظبي|ارامكو|الاردن|المغرب|امارات|فلسطين|مليسيا|भारतम्|இலங்கை|ファッション|actor|adult|aetna|amfam|amica|apple|archi|audio|autos|azure|baidu|beats|bible|bingo|black|boats|bosch|build|canon|cards|chase|cheap|cisco|citic|click|cloud|coach|codes|crown|cymru|dabur|dance|deals|delta|drive|dubai|earth|edeka|email|epson|faith|fedex|final|forex|forum|gallo|games|gifts|gives|glass|globo|gmail|green|gripe|group|gucci|guide|homes|honda|horse|house|hyatt|ikano|irish|jetzt|koeln|kyoto|lamer|lease|legal|lexus|lilly|linde|lipsy|loans|locus|lotte|lotto|macys|mango|media|miami|money|movie|music|nexus|nikon|ninja|nokia|nowtv|omega|osaka|paris|parts|party|phone|photo|pizza|place|poker|praxi|press|prime|promo|quest|radio|rehab|reise|ricoh|rocks|rodeo|rugby|salon|sener|seven|sharp|shell|shoes|skype|sling|smart|smile|solar|space|sport|stada|store|study|style|sucks|swiss|tatar|tires|tirol|tmall|today|tokyo|tools|toray|total|tours|trade|trust|tunes|tushu|ubank|vegas|video|vodka|volvo|wales|watch|weber|weibo|works|world|xerox|yahoo|ישראל|ایران|بازار|بھارت|سودان|سورية|همراه|भारोत|संगठन|বাংলা|భారత్|ഭാരതം|嘉里大酒店|aarp|able|adac|aero|akdn|ally|amex|arab|army|arpa|arte|asda|asia|audi|auto|baby|band|bank|bbva|beer|best|bike|bing|blog|blue|bofa|bond|book|buzz|cafe|call|camp|care|cars|casa|case|cash|cbre|cern|chat|citi|city|club|cool|coop|cyou|data|date|dclk|deal|dell|desi|diet|dish|docs|dvag|erni|fage|fail|fans|farm|fast|fiat|fido|film|fire|fish|flir|food|ford|free|fund|game|gbiz|gent|ggee|gift|gmbh|gold|golf|goog|guge|guru|hair|haus|hdfc|help|here|hgtv|host|hsbc|icbc|ieee|imdb|immo|info|itau|java|jeep|jobs|jprs|kddi|kids|kiwi|kpmg|kred|land|lego|lgbt|lidl|life|like|limo|link|live|loan|loft|love|ltda|luxe|maif|meet|meme|menu|mini|mint|mobi|moda|moto|name|navy|news|next|nico|nike|ollo|open|page|pars|pccw|pics|ping|pink|play|plus|pohl|porn|post|prod|prof|qpon|read|reit|rent|rest|rich|room|rsvp|ruhr|safe|sale|sarl|save|saxo|scot|seat|seek|sexy|shaw|shia|shop|show|silk|sina|site|skin|sncf|sohu|song|sony|spot|star|surf|talk|taxi|team|tech|teva|tiaa|tips|town|toys|tube|vana|visa|viva|vivo|vote|voto|wang|weir|wien|wiki|wine|work|xbox|yoga|zara|zero|zone|дети|сайт|بارت|بيتك|ڀارت|تونس|شبكة|عراق|عمان|موقع|भारत|ভারত|ভাৰত|ਭਾਰਤ|ભારત|ଭାରତ|ಭಾರತ|ලංකා|アマゾン|グーグル|クラウド|ポイント|组织机构|電訊盈科|香格里拉|aaa|abb|abc|aco|ads|aeg|afl|aig|anz|aol|app|art|aws|axa|bar|bbc|bbt|bcg|bcn|bet|bid|bio|biz|bms|bmw|bom|boo|bot|box|buy|bzh|cab|cal|cam|car|cat|cba|cbn|cbs|ceo|cfa|cfd|com|cpa|crs|dad|day|dds|dev|dhl|diy|dnp|dog|dot|dtv|dvr|eat|eco|edu|esq|eus|fan|fit|fly|foo|fox|frl|ftr|fun|fyi|gal|gap|gay|gdn|gea|gle|gmo|gmx|goo|gop|got|gov|hbo|hiv|hkt|hot|how|ibm|ice|icu|ifm|inc|ing|ink|int|ist|itv|jcb|jio|jll|jmp|jnj|jot|joy|kfh|kia|kim|kpn|krd|lat|law|lds|llc|llp|lol|lpl|ltd|man|map|mba|med|men|mil|mit|mlb|mls|mma|moe|moi|mom|mov|msd|mtn|mtr|nab|nba|nec|net|new|nfl|ngo|nhk|now|nra|nrw|ntt|nyc|obi|one|ong|onl|ooo|org|ott|ovh|pay|pet|phd|pid|pin|pnc|pro|pru|pub|pwc|red|ren|ril|rio|rip|run|rwe|sap|sas|sbi|sbs|sca|scb|ses|sew|sex|sfr|ski|sky|soy|spa|srl|stc|tab|tax|tci|tdk|tel|thd|tjx|top|trv|tui|tvs|ubs|uno|uol|ups|vet|vig|vin|vip|wed|win|wme|wow|wtc|wtf|xin|xxx|xyz|you|yun|zip|бел|ком|қаз|мкд|мон|орг|рус|срб|укр|հայ|קום|عرب|قطر|كوم|مصر|कॉम|नेट|คอม|ไทย|ລາວ|ストア|セール|みんな|中文网|亚马逊|天主教|我爱你|新加坡|淡马锡|诺基亚|飞利浦|ac|ad|ae|af|ag|ai|al|am|ao|aq|ar|as|at|au|aw|ax|az|ba|bb|bd|be|bf|bg|bh|bi|bj|bm|bn|bo|br|bs|bt|bv|bw|by|bz|ca|cc|cd|cf|cg|ch|ci|ck|cl|cm|cn|co|cr|cu|cv|cw|cx|cy|cz|de|dj|dk|dm|do|dz|ec|ee|eg|er|es|et|eu|fi|fj|fk|fm|fo|fr|ga|gb|gd|ge|gf|gg|gh|gi|gl|gm|gn|gp|gq|gr|gs|gt|gu|gw|gy|hk|hm|hn|hr|ht|hu|id|ie|il|im|in|io|iq|ir|is|it|je|jm|jo|jp|ke|kg|kh|ki|km|kn|kp|kr|kw|ky|kz|la|lb|lc|li|lk|lr|ls|lt|lu|lv|ly|ma|mc|md|me|mg|mh|mk|ml|mm|mn|mo|mp|mq|mr|ms|mt|mu|mv|mw|mx|my|mz|na|nc|ne|nf|ng|ni|nl|no|np|nr|nu|nz|om|pa|pe|pf|pg|ph|pk|pl|pm|pn|pr|ps|pt|pw|py|qa|re|ro|rs|ru|rw|sa|sb|sc|sd|se|sg|sh|si|sj|sk|sl|sm|sn|so|sr|ss|st|su|sv|sx|sy|sz|tc|td|tf|tg|th|tj|tk|tl|tm|tn|to|tr|tt|tv|tw|tz|ua|ug|uk|us|uy|uz|va|vc|ve|vg|vi|vn|vu|wf|ws|ye|yt|za|zm|zw|ελ|ευ|бг|ею|рф|გე|닷넷|닷컴|삼성|한국|コム|世界|中信|中国|中國|企业|佛山|信息|健康|八卦|公司|公益|台湾|台灣|商城|商店|商标|嘉里|在线|大拿|娱乐|家電|广东|微博|慈善|手机|招聘|政务|政府|新闻|时尚|書籍|机构|游戏|澳門|点看|移动|网址|网店|网站|网络|联通|谷歌|购物|通販|集团|食品|餐厅|香港)/;
  }
});

// node_modules/autolinker/dist/commonjs/matcher/email-matcher.js
var require_email_matcher = __commonJS({
  "node_modules/autolinker/dist/commonjs/matcher/email-matcher.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.EmailMatcher = void 0;
    var tslib_1 = require_tslib();
    var matcher_1 = require_matcher();
    var regex_lib_1 = require_regex_lib();
    var email_match_1 = require_email_match();
    var utils_1 = require_utils();
    var tld_regex_1 = require_tld_regex();
    var localPartCharRegex = new RegExp("[".concat(regex_lib_1.alphaNumericAndMarksCharsStr, "!#$%&'*+/=?^_`{|}~-]"));
    var strictTldRegex = new RegExp("^".concat(tld_regex_1.tldRegex.source, "$"));
    var EmailMatcher = function(_super) {
      (0, tslib_1.__extends)(EmailMatcher2, _super);
      function EmailMatcher2() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.localPartCharRegex = localPartCharRegex;
        _this.strictTldRegex = strictTldRegex;
        return _this;
      }
      EmailMatcher2.prototype.parseMatches = function(text) {
        var tagBuilder = this.tagBuilder, localPartCharRegex2 = this.localPartCharRegex, strictTldRegex2 = this.strictTldRegex, matches = [], len = text.length, noCurrentEmailMatch = new CurrentEmailMatch();
        var mailtoTransitions = {
          m: "a",
          a: "i",
          i: "l",
          l: "t",
          t: "o",
          o: ":"
        };
        var charIdx = 0, state = 0, currentEmailMatch = noCurrentEmailMatch;
        while (charIdx < len) {
          var char = text.charAt(charIdx);
          switch (state) {
            case 0:
              stateNonEmailAddress(char);
              break;
            case 1:
              stateMailTo(text.charAt(charIdx - 1), char);
              break;
            case 2:
              stateLocalPart(char);
              break;
            case 3:
              stateLocalPartDot(char);
              break;
            case 4:
              stateAtSign(char);
              break;
            case 5:
              stateDomainChar(char);
              break;
            case 6:
              stateDomainHyphen(char);
              break;
            case 7:
              stateDomainDot(char);
              break;
            default:
              (0, utils_1.throwUnhandledCaseError)(state);
          }
          charIdx++;
        }
        captureMatchIfValidAndReset();
        return matches;
        function stateNonEmailAddress(char2) {
          if (char2 === "m") {
            beginEmailMatch(1);
          } else if (localPartCharRegex2.test(char2)) {
            beginEmailMatch();
          } else {
          }
        }
        function stateMailTo(prevChar, char2) {
          if (prevChar === ":") {
            if (localPartCharRegex2.test(char2)) {
              state = 2;
              currentEmailMatch = new CurrentEmailMatch((0, tslib_1.__assign)((0, tslib_1.__assign)({}, currentEmailMatch), { hasMailtoPrefix: true }));
            } else {
              resetToNonEmailMatchState();
            }
          } else if (mailtoTransitions[prevChar] === char2) {
          } else if (localPartCharRegex2.test(char2)) {
            state = 2;
          } else if (char2 === ".") {
            state = 3;
          } else if (char2 === "@") {
            state = 4;
          } else {
            resetToNonEmailMatchState();
          }
        }
        function stateLocalPart(char2) {
          if (char2 === ".") {
            state = 3;
          } else if (char2 === "@") {
            state = 4;
          } else if (localPartCharRegex2.test(char2)) {
          } else {
            resetToNonEmailMatchState();
          }
        }
        function stateLocalPartDot(char2) {
          if (char2 === ".") {
            resetToNonEmailMatchState();
          } else if (char2 === "@") {
            resetToNonEmailMatchState();
          } else if (localPartCharRegex2.test(char2)) {
            state = 2;
          } else {
            resetToNonEmailMatchState();
          }
        }
        function stateAtSign(char2) {
          if (regex_lib_1.domainNameCharRegex.test(char2)) {
            state = 5;
          } else {
            resetToNonEmailMatchState();
          }
        }
        function stateDomainChar(char2) {
          if (char2 === ".") {
            state = 7;
          } else if (char2 === "-") {
            state = 6;
          } else if (regex_lib_1.domainNameCharRegex.test(char2)) {
          } else {
            captureMatchIfValidAndReset();
          }
        }
        function stateDomainHyphen(char2) {
          if (char2 === "-" || char2 === ".") {
            captureMatchIfValidAndReset();
          } else if (regex_lib_1.domainNameCharRegex.test(char2)) {
            state = 5;
          } else {
            captureMatchIfValidAndReset();
          }
        }
        function stateDomainDot(char2) {
          if (char2 === "." || char2 === "-") {
            captureMatchIfValidAndReset();
          } else if (regex_lib_1.domainNameCharRegex.test(char2)) {
            state = 5;
            currentEmailMatch = new CurrentEmailMatch((0, tslib_1.__assign)((0, tslib_1.__assign)({}, currentEmailMatch), { hasDomainDot: true }));
          } else {
            captureMatchIfValidAndReset();
          }
        }
        function beginEmailMatch(newState) {
          if (newState === void 0) {
            newState = 2;
          }
          state = newState;
          currentEmailMatch = new CurrentEmailMatch({ idx: charIdx });
        }
        function resetToNonEmailMatchState() {
          state = 0;
          currentEmailMatch = noCurrentEmailMatch;
        }
        function captureMatchIfValidAndReset() {
          if (currentEmailMatch.hasDomainDot) {
            var matchedText = text.slice(currentEmailMatch.idx, charIdx);
            if (/[-.]$/.test(matchedText)) {
              matchedText = matchedText.slice(0, -1);
            }
            var emailAddress = currentEmailMatch.hasMailtoPrefix ? matchedText.slice("mailto:".length) : matchedText;
            if (doesEmailHaveValidTld(emailAddress)) {
              matches.push(new email_match_1.EmailMatch({
                tagBuilder,
                matchedText,
                offset: currentEmailMatch.idx,
                email: emailAddress
              }));
            }
          }
          resetToNonEmailMatchState();
          function doesEmailHaveValidTld(emailAddress2) {
            var emailAddressTld = emailAddress2.split(".").pop() || "";
            var emailAddressNormalized = emailAddressTld.toLowerCase();
            var isValidTld = strictTldRegex2.test(emailAddressNormalized);
            return isValidTld;
          }
        }
      };
      return EmailMatcher2;
    }(matcher_1.Matcher);
    exports2.EmailMatcher = EmailMatcher;
    var CurrentEmailMatch = function() {
      function CurrentEmailMatch2(cfg) {
        if (cfg === void 0) {
          cfg = {};
        }
        this.idx = cfg.idx !== void 0 ? cfg.idx : -1;
        this.hasMailtoPrefix = !!cfg.hasMailtoPrefix;
        this.hasDomainDot = !!cfg.hasDomainDot;
      }
      return CurrentEmailMatch2;
    }();
  }
});

// node_modules/autolinker/dist/commonjs/matcher/url-match-validator.js
var require_url_match_validator = __commonJS({
  "node_modules/autolinker/dist/commonjs/matcher/url-match-validator.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.UrlMatchValidator = void 0;
    var regex_lib_1 = require_regex_lib();
    var UrlMatchValidator = function() {
      function UrlMatchValidator2() {
      }
      UrlMatchValidator2.isValid = function(urlMatch, protocolUrlMatch) {
        if (protocolUrlMatch && !this.isValidUriScheme(protocolUrlMatch) || this.urlMatchDoesNotHaveProtocolOrDot(urlMatch, protocolUrlMatch) || this.urlMatchDoesNotHaveAtLeastOneWordChar(urlMatch, protocolUrlMatch) && !this.isValidIpAddress(urlMatch) || this.containsMultipleDots(urlMatch)) {
          return false;
        }
        return true;
      };
      UrlMatchValidator2.isValidIpAddress = function(uriSchemeMatch) {
        var newRegex = new RegExp(this.hasFullProtocolRegex.source + this.ipRegex.source);
        var uriScheme = uriSchemeMatch.match(newRegex);
        return uriScheme !== null;
      };
      UrlMatchValidator2.containsMultipleDots = function(urlMatch) {
        var stringBeforeSlash = urlMatch;
        if (this.hasFullProtocolRegex.test(urlMatch)) {
          stringBeforeSlash = urlMatch.split("://")[1];
        }
        return stringBeforeSlash.split("/")[0].indexOf("..") > -1;
      };
      UrlMatchValidator2.isValidUriScheme = function(uriSchemeMatch) {
        var uriSchemeMatchArr = uriSchemeMatch.match(this.uriSchemeRegex), uriScheme = uriSchemeMatchArr && uriSchemeMatchArr[0].toLowerCase();
        return uriScheme !== "javascript:" && uriScheme !== "vbscript:";
      };
      UrlMatchValidator2.urlMatchDoesNotHaveProtocolOrDot = function(urlMatch, protocolUrlMatch) {
        return !!urlMatch && (!protocolUrlMatch || !this.hasFullProtocolRegex.test(protocolUrlMatch)) && urlMatch.indexOf(".") === -1;
      };
      UrlMatchValidator2.urlMatchDoesNotHaveAtLeastOneWordChar = function(urlMatch, protocolUrlMatch) {
        if (urlMatch && protocolUrlMatch) {
          return !this.hasFullProtocolRegex.test(protocolUrlMatch) && !this.hasWordCharAfterProtocolRegex.test(urlMatch);
        } else {
          return false;
        }
      };
      UrlMatchValidator2.hasFullProtocolRegex = /^[A-Za-z][-.+A-Za-z0-9]*:\/\//;
      UrlMatchValidator2.uriSchemeRegex = /^[A-Za-z][-.+A-Za-z0-9]*:/;
      UrlMatchValidator2.hasWordCharAfterProtocolRegex = new RegExp(":[^\\s]*?[" + regex_lib_1.alphaCharsStr + "]");
      UrlMatchValidator2.ipRegex = /[0-9][0-9]?[0-9]?\.[0-9][0-9]?[0-9]?\.[0-9][0-9]?[0-9]?\.[0-9][0-9]?[0-9]?(:[0-9]*)?\/?$/;
      return UrlMatchValidator2;
    }();
    exports2.UrlMatchValidator = UrlMatchValidator;
  }
});

// node_modules/autolinker/dist/commonjs/matcher/url-matcher.js
var require_url_matcher = __commonJS({
  "node_modules/autolinker/dist/commonjs/matcher/url-matcher.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.UrlMatcher = void 0;
    var tslib_1 = require_tslib();
    var matcher_1 = require_matcher();
    var regex_lib_1 = require_regex_lib();
    var tld_regex_1 = require_tld_regex();
    var url_match_1 = require_url_match();
    var url_match_validator_1 = require_url_match_validator();
    var matcherRegex = function() {
      var schemeRegex = /(?:[A-Za-z][-.+A-Za-z0-9]{0,63}:(?![A-Za-z][-.+A-Za-z0-9]{0,63}:\/\/)(?!\d+\/?)(?:\/\/)?)/, wwwRegex = /(?:www\.)/, urlSuffixRegex = new RegExp("[/?#](?:[" + regex_lib_1.alphaNumericAndMarksCharsStr + "\\-+&@#/%=~_()|'$*\\[\\]{}?!:,.;^\u2713]*[" + regex_lib_1.alphaNumericAndMarksCharsStr + "\\-+&@#/%=~_()|'$*\\[\\]{}\u2713])?");
      return new RegExp([
        "(?:",
        "(",
        schemeRegex.source,
        (0, regex_lib_1.getDomainNameStr)(2),
        ")",
        "|",
        "(",
        "(//)?",
        wwwRegex.source,
        (0, regex_lib_1.getDomainNameStr)(6),
        ")",
        "|",
        "(",
        "(//)?",
        (0, regex_lib_1.getDomainNameStr)(10) + "\\.",
        tld_regex_1.tldRegex.source,
        "(?![-" + regex_lib_1.alphaNumericCharsStr + "])",
        ")",
        ")",
        "(?::[0-9]+)?",
        "(?:" + urlSuffixRegex.source + ")?"
      ].join(""), "gi");
    }();
    var wordCharRegExp = new RegExp("[" + regex_lib_1.alphaNumericAndMarksCharsStr + "]");
    var UrlMatcher = function(_super) {
      (0, tslib_1.__extends)(UrlMatcher2, _super);
      function UrlMatcher2(cfg) {
        var _this = _super.call(this, cfg) || this;
        _this.stripPrefix = {
          scheme: true,
          www: true
        };
        _this.stripTrailingSlash = true;
        _this.decodePercentEncoding = true;
        _this.matcherRegex = matcherRegex;
        _this.wordCharRegExp = wordCharRegExp;
        _this.stripPrefix = cfg.stripPrefix;
        _this.stripTrailingSlash = cfg.stripTrailingSlash;
        _this.decodePercentEncoding = cfg.decodePercentEncoding;
        return _this;
      }
      UrlMatcher2.prototype.parseMatches = function(text) {
        var matcherRegex2 = this.matcherRegex, stripPrefix = this.stripPrefix, stripTrailingSlash = this.stripTrailingSlash, decodePercentEncoding = this.decodePercentEncoding, tagBuilder = this.tagBuilder, matches = [], match;
        var _loop_1 = function() {
          var matchStr = match[0], schemeUrlMatch = match[1], wwwUrlMatch = match[4], wwwProtocolRelativeMatch = match[5], tldProtocolRelativeMatch = match[9], offset2 = match.index, protocolRelativeMatch = wwwProtocolRelativeMatch || tldProtocolRelativeMatch, prevChar = text.charAt(offset2 - 1);
          if (!url_match_validator_1.UrlMatchValidator.isValid(matchStr, schemeUrlMatch)) {
            return "continue";
          }
          if (offset2 > 0 && prevChar === "@") {
            return "continue";
          }
          if (offset2 > 0 && protocolRelativeMatch && this_1.wordCharRegExp.test(prevChar)) {
            return "continue";
          }
          if (/\?$/.test(matchStr)) {
            matchStr = matchStr.substr(0, matchStr.length - 1);
          }
          if (this_1.matchHasUnbalancedClosingParen(matchStr)) {
            matchStr = matchStr.substr(0, matchStr.length - 1);
          } else {
            var pos = this_1.matchHasInvalidCharAfterTld(matchStr, schemeUrlMatch);
            if (pos > -1) {
              matchStr = matchStr.substr(0, pos);
            }
          }
          var foundCommonScheme = ["http://", "https://"].find(function(commonScheme) {
            return !!schemeUrlMatch && schemeUrlMatch.indexOf(commonScheme) !== -1;
          });
          if (foundCommonScheme) {
            var indexOfSchemeStart = matchStr.indexOf(foundCommonScheme);
            matchStr = matchStr.substr(indexOfSchemeStart);
            schemeUrlMatch = schemeUrlMatch.substr(indexOfSchemeStart);
            offset2 = offset2 + indexOfSchemeStart;
          }
          var urlMatchType = schemeUrlMatch ? "scheme" : wwwUrlMatch ? "www" : "tld", protocolUrlMatch = !!schemeUrlMatch;
          matches.push(new url_match_1.UrlMatch({
            tagBuilder,
            matchedText: matchStr,
            offset: offset2,
            urlMatchType,
            url: matchStr,
            protocolUrlMatch,
            protocolRelativeMatch: !!protocolRelativeMatch,
            stripPrefix,
            stripTrailingSlash,
            decodePercentEncoding
          }));
        };
        var this_1 = this;
        while ((match = matcherRegex2.exec(text)) !== null) {
          _loop_1();
        }
        return matches;
      };
      UrlMatcher2.prototype.matchHasUnbalancedClosingParen = function(matchStr) {
        var endChar = matchStr.charAt(matchStr.length - 1);
        var startChar;
        if (endChar === ")") {
          startChar = "(";
        } else if (endChar === "]") {
          startChar = "[";
        } else if (endChar === "}") {
          startChar = "{";
        } else {
          return false;
        }
        var numOpenBraces = 0;
        for (var i = 0, len = matchStr.length - 1; i < len; i++) {
          var char = matchStr.charAt(i);
          if (char === startChar) {
            numOpenBraces++;
          } else if (char === endChar) {
            numOpenBraces = Math.max(numOpenBraces - 1, 0);
          }
        }
        if (numOpenBraces === 0) {
          return true;
        }
        return false;
      };
      UrlMatcher2.prototype.matchHasInvalidCharAfterTld = function(urlMatch, schemeUrlMatch) {
        if (!urlMatch) {
          return -1;
        }
        var offset2 = 0;
        if (schemeUrlMatch) {
          offset2 = urlMatch.indexOf(":");
          urlMatch = urlMatch.slice(offset2);
        }
        var re = new RegExp("^((.?//)?[-." + regex_lib_1.alphaNumericAndMarksCharsStr + "]*[-" + regex_lib_1.alphaNumericAndMarksCharsStr + "]\\.[-" + regex_lib_1.alphaNumericAndMarksCharsStr + "]+)");
        var res = re.exec(urlMatch);
        if (res === null) {
          return -1;
        }
        offset2 += res[1].length;
        urlMatch = urlMatch.slice(res[1].length);
        if (/^[^-.A-Za-z0-9:\/?#]/.test(urlMatch)) {
          return offset2;
        }
        return -1;
      };
      return UrlMatcher2;
    }(matcher_1.Matcher);
    exports2.UrlMatcher = UrlMatcher;
  }
});

// node_modules/autolinker/dist/commonjs/matcher/hashtag-matcher.js
var require_hashtag_matcher = __commonJS({
  "node_modules/autolinker/dist/commonjs/matcher/hashtag-matcher.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.HashtagMatcher = void 0;
    var tslib_1 = require_tslib();
    var matcher_1 = require_matcher();
    var regex_lib_1 = require_regex_lib();
    var hashtag_match_1 = require_hashtag_match();
    var matcherRegex = new RegExp("#[_".concat(regex_lib_1.alphaNumericAndMarksCharsStr, "]{1,139}(?![_").concat(regex_lib_1.alphaNumericAndMarksCharsStr, "])"), "g");
    var nonWordCharRegex = new RegExp("[^" + regex_lib_1.alphaNumericAndMarksCharsStr + "]");
    var HashtagMatcher = function(_super) {
      (0, tslib_1.__extends)(HashtagMatcher2, _super);
      function HashtagMatcher2(cfg) {
        var _this = _super.call(this, cfg) || this;
        _this.serviceName = "twitter";
        _this.matcherRegex = matcherRegex;
        _this.nonWordCharRegex = nonWordCharRegex;
        _this.serviceName = cfg.serviceName;
        return _this;
      }
      HashtagMatcher2.prototype.parseMatches = function(text) {
        var matcherRegex2 = this.matcherRegex, nonWordCharRegex2 = this.nonWordCharRegex, serviceName = this.serviceName, tagBuilder = this.tagBuilder, matches = [], match;
        while ((match = matcherRegex2.exec(text)) !== null) {
          var offset2 = match.index, prevChar = text.charAt(offset2 - 1);
          if (offset2 === 0 || nonWordCharRegex2.test(prevChar)) {
            var matchedText = match[0], hashtag = match[0].slice(1);
            matches.push(new hashtag_match_1.HashtagMatch({
              tagBuilder,
              matchedText,
              offset: offset2,
              serviceName,
              hashtag
            }));
          }
        }
        return matches;
      };
      return HashtagMatcher2;
    }(matcher_1.Matcher);
    exports2.HashtagMatcher = HashtagMatcher;
  }
});

// node_modules/autolinker/dist/commonjs/matcher/phone-matcher.js
var require_phone_matcher = __commonJS({
  "node_modules/autolinker/dist/commonjs/matcher/phone-matcher.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.PhoneMatcher = void 0;
    var tslib_1 = require_tslib();
    var matcher_1 = require_matcher();
    var phone_match_1 = require_phone_match();
    var regex_lib_1 = require_regex_lib();
    var mostPhoneNumbers = /(?:(?:(?:(\+)?\d{1,3}[-\040.]?)?\(?\d{3}\)?[-\040.]?\d{3}[-\040.]?\d{4})|(?:(\+)(?:9[976]\d|8[987530]\d|6[987]\d|5[90]\d|42\d|3[875]\d|2[98654321]\d|9[8543210]|8[6421]|6[6543210]|5[87654321]|4[987654310]|3[9643210]|2[70]|7|1)[-\040.]?(?:\d[-\040.]?){6,12}\d+))([,;]+[0-9]+#?)*/;
    var japanesePhoneRe = /(0([1-9]{1}-?[1-9]\d{3}|[1-9]{2}-?\d{3}|[1-9]{2}\d{1}-?\d{2}|[1-9]{2}\d{2}-?\d{1})-?\d{4}|0[789]0-?\d{4}-?\d{4}|050-?\d{4}-?\d{4})/;
    var phoneMatcherRegex = new RegExp("".concat(mostPhoneNumbers.source, "|").concat(japanesePhoneRe.source), "g");
    var PhoneMatcher = function(_super) {
      (0, tslib_1.__extends)(PhoneMatcher2, _super);
      function PhoneMatcher2() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.matcherRegex = phoneMatcherRegex;
        return _this;
      }
      PhoneMatcher2.prototype.parseMatches = function(text) {
        var matcherRegex = this.matcherRegex, tagBuilder = this.tagBuilder, matches = [], match;
        while ((match = matcherRegex.exec(text)) !== null) {
          var matchedText = match[0], cleanNumber = matchedText.replace(/[^0-9,;#]/g, ""), plusSign = !!(match[1] || match[2]), before = match.index == 0 ? "" : text.substr(match.index - 1, 1), after = text.substr(match.index + matchedText.length, 1), contextClear = !before.match(/\d/) && !after.match(/\d/);
          if (this.testMatch(match[3]) && this.testMatch(matchedText) && contextClear) {
            matches.push(new phone_match_1.PhoneMatch({
              tagBuilder,
              matchedText,
              offset: match.index,
              number: cleanNumber,
              plusSign
            }));
          }
        }
        return matches;
      };
      PhoneMatcher2.prototype.testMatch = function(text) {
        return regex_lib_1.nonDigitRe.test(text);
      };
      return PhoneMatcher2;
    }(matcher_1.Matcher);
    exports2.PhoneMatcher = PhoneMatcher;
  }
});

// node_modules/autolinker/dist/commonjs/matcher/mention-matcher.js
var require_mention_matcher = __commonJS({
  "node_modules/autolinker/dist/commonjs/matcher/mention-matcher.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.MentionMatcher = void 0;
    var tslib_1 = require_tslib();
    var matcher_1 = require_matcher();
    var regex_lib_1 = require_regex_lib();
    var mention_match_1 = require_mention_match();
    var twitterRegex = new RegExp("@[_".concat(regex_lib_1.alphaNumericAndMarksCharsStr, "]{1,50}(?![_").concat(regex_lib_1.alphaNumericAndMarksCharsStr, "])"), "g");
    var instagramRegex = new RegExp("@[_.".concat(regex_lib_1.alphaNumericAndMarksCharsStr, "]{1,30}(?![_").concat(regex_lib_1.alphaNumericAndMarksCharsStr, "])"), "g");
    var soundcloudRegex = new RegExp("@[-_.".concat(regex_lib_1.alphaNumericAndMarksCharsStr, "]{1,50}(?![-_").concat(regex_lib_1.alphaNumericAndMarksCharsStr, "])"), "g");
    var tiktokRegex = new RegExp("@[_.".concat(regex_lib_1.alphaNumericAndMarksCharsStr, "]{1,23}[_").concat(regex_lib_1.alphaNumericAndMarksCharsStr, "](?![_").concat(regex_lib_1.alphaNumericAndMarksCharsStr, "])"), "g");
    var nonWordCharRegex = new RegExp("[^" + regex_lib_1.alphaNumericAndMarksCharsStr + "]");
    var MentionMatcher = function(_super) {
      (0, tslib_1.__extends)(MentionMatcher2, _super);
      function MentionMatcher2(cfg) {
        var _this = _super.call(this, cfg) || this;
        _this.serviceName = "twitter";
        _this.matcherRegexes = {
          twitter: twitterRegex,
          instagram: instagramRegex,
          soundcloud: soundcloudRegex,
          tiktok: tiktokRegex
        };
        _this.nonWordCharRegex = nonWordCharRegex;
        _this.serviceName = cfg.serviceName;
        return _this;
      }
      MentionMatcher2.prototype.parseMatches = function(text) {
        var serviceName = this.serviceName, matcherRegex = this.matcherRegexes[this.serviceName], nonWordCharRegex2 = this.nonWordCharRegex, tagBuilder = this.tagBuilder, matches = [], match;
        if (!matcherRegex) {
          return matches;
        }
        while ((match = matcherRegex.exec(text)) !== null) {
          var offset2 = match.index, prevChar = text.charAt(offset2 - 1);
          if (offset2 === 0 || nonWordCharRegex2.test(prevChar)) {
            var matchedText = match[0].replace(/\.+$/g, ""), mention = matchedText.slice(1);
            matches.push(new mention_match_1.MentionMatch({
              tagBuilder,
              matchedText,
              offset: offset2,
              serviceName,
              mention
            }));
          }
        }
        return matches;
      };
      return MentionMatcher2;
    }(matcher_1.Matcher);
    exports2.MentionMatcher = MentionMatcher;
  }
});

// node_modules/autolinker/dist/commonjs/htmlParser/parse-html.js
var require_parse_html = __commonJS({
  "node_modules/autolinker/dist/commonjs/htmlParser/parse-html.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.parseHtml = void 0;
    var tslib_1 = require_tslib();
    var regex_lib_1 = require_regex_lib();
    var utils_1 = require_utils();
    function parseHtml(html, _a) {
      var onOpenTag = _a.onOpenTag, onCloseTag = _a.onCloseTag, onText = _a.onText, onComment = _a.onComment, onDoctype = _a.onDoctype;
      var noCurrentTag = new CurrentTag();
      var charIdx = 0, len = html.length, state = 0, currentDataIdx = 0, currentTag = noCurrentTag;
      while (charIdx < len) {
        var char = html.charAt(charIdx);
        switch (state) {
          case 0:
            stateData(char);
            break;
          case 1:
            stateTagOpen(char);
            break;
          case 2:
            stateEndTagOpen(char);
            break;
          case 3:
            stateTagName(char);
            break;
          case 4:
            stateBeforeAttributeName(char);
            break;
          case 5:
            stateAttributeName(char);
            break;
          case 6:
            stateAfterAttributeName(char);
            break;
          case 7:
            stateBeforeAttributeValue(char);
            break;
          case 8:
            stateAttributeValueDoubleQuoted(char);
            break;
          case 9:
            stateAttributeValueSingleQuoted(char);
            break;
          case 10:
            stateAttributeValueUnquoted(char);
            break;
          case 11:
            stateAfterAttributeValueQuoted(char);
            break;
          case 12:
            stateSelfClosingStartTag(char);
            break;
          case 13:
            stateMarkupDeclarationOpen(char);
            break;
          case 14:
            stateCommentStart(char);
            break;
          case 15:
            stateCommentStartDash(char);
            break;
          case 16:
            stateComment(char);
            break;
          case 17:
            stateCommentEndDash(char);
            break;
          case 18:
            stateCommentEnd(char);
            break;
          case 19:
            stateCommentEndBang(char);
            break;
          case 20:
            stateDoctype(char);
            break;
          default:
            (0, utils_1.throwUnhandledCaseError)(state);
        }
        charIdx++;
      }
      if (currentDataIdx < charIdx) {
        emitText();
      }
      function stateData(char2) {
        if (char2 === "<") {
          startNewTag();
        }
      }
      function stateTagOpen(char2) {
        if (char2 === "!") {
          state = 13;
        } else if (char2 === "/") {
          state = 2;
          currentTag = new CurrentTag((0, tslib_1.__assign)((0, tslib_1.__assign)({}, currentTag), { isClosing: true }));
        } else if (char2 === "<") {
          startNewTag();
        } else if (regex_lib_1.letterRe.test(char2)) {
          state = 3;
          currentTag = new CurrentTag((0, tslib_1.__assign)((0, tslib_1.__assign)({}, currentTag), { isOpening: true }));
        } else {
          state = 0;
          currentTag = noCurrentTag;
        }
      }
      function stateTagName(char2) {
        if (regex_lib_1.whitespaceRe.test(char2)) {
          currentTag = new CurrentTag((0, tslib_1.__assign)((0, tslib_1.__assign)({}, currentTag), { name: captureTagName() }));
          state = 4;
        } else if (char2 === "<") {
          startNewTag();
        } else if (char2 === "/") {
          currentTag = new CurrentTag((0, tslib_1.__assign)((0, tslib_1.__assign)({}, currentTag), { name: captureTagName() }));
          state = 12;
        } else if (char2 === ">") {
          currentTag = new CurrentTag((0, tslib_1.__assign)((0, tslib_1.__assign)({}, currentTag), { name: captureTagName() }));
          emitTagAndPreviousTextNode();
        } else if (!regex_lib_1.letterRe.test(char2) && !regex_lib_1.digitRe.test(char2) && char2 !== ":") {
          resetToDataState();
        } else {
        }
      }
      function stateEndTagOpen(char2) {
        if (char2 === ">") {
          resetToDataState();
        } else if (regex_lib_1.letterRe.test(char2)) {
          state = 3;
        } else {
          resetToDataState();
        }
      }
      function stateBeforeAttributeName(char2) {
        if (regex_lib_1.whitespaceRe.test(char2)) {
        } else if (char2 === "/") {
          state = 12;
        } else if (char2 === ">") {
          emitTagAndPreviousTextNode();
        } else if (char2 === "<") {
          startNewTag();
        } else if (char2 === "=" || regex_lib_1.quoteRe.test(char2) || regex_lib_1.controlCharsRe.test(char2)) {
          resetToDataState();
        } else {
          state = 5;
        }
      }
      function stateAttributeName(char2) {
        if (regex_lib_1.whitespaceRe.test(char2)) {
          state = 6;
        } else if (char2 === "/") {
          state = 12;
        } else if (char2 === "=") {
          state = 7;
        } else if (char2 === ">") {
          emitTagAndPreviousTextNode();
        } else if (char2 === "<") {
          startNewTag();
        } else if (regex_lib_1.quoteRe.test(char2)) {
          resetToDataState();
        } else {
        }
      }
      function stateAfterAttributeName(char2) {
        if (regex_lib_1.whitespaceRe.test(char2)) {
        } else if (char2 === "/") {
          state = 12;
        } else if (char2 === "=") {
          state = 7;
        } else if (char2 === ">") {
          emitTagAndPreviousTextNode();
        } else if (char2 === "<") {
          startNewTag();
        } else if (regex_lib_1.quoteRe.test(char2)) {
          resetToDataState();
        } else {
          state = 5;
        }
      }
      function stateBeforeAttributeValue(char2) {
        if (regex_lib_1.whitespaceRe.test(char2)) {
        } else if (char2 === '"') {
          state = 8;
        } else if (char2 === "'") {
          state = 9;
        } else if (/[>=`]/.test(char2)) {
          resetToDataState();
        } else if (char2 === "<") {
          startNewTag();
        } else {
          state = 10;
        }
      }
      function stateAttributeValueDoubleQuoted(char2) {
        if (char2 === '"') {
          state = 11;
        } else {
        }
      }
      function stateAttributeValueSingleQuoted(char2) {
        if (char2 === "'") {
          state = 11;
        } else {
        }
      }
      function stateAttributeValueUnquoted(char2) {
        if (regex_lib_1.whitespaceRe.test(char2)) {
          state = 4;
        } else if (char2 === ">") {
          emitTagAndPreviousTextNode();
        } else if (char2 === "<") {
          startNewTag();
        } else {
        }
      }
      function stateAfterAttributeValueQuoted(char2) {
        if (regex_lib_1.whitespaceRe.test(char2)) {
          state = 4;
        } else if (char2 === "/") {
          state = 12;
        } else if (char2 === ">") {
          emitTagAndPreviousTextNode();
        } else if (char2 === "<") {
          startNewTag();
        } else {
          state = 4;
          reconsumeCurrentCharacter();
        }
      }
      function stateSelfClosingStartTag(char2) {
        if (char2 === ">") {
          currentTag = new CurrentTag((0, tslib_1.__assign)((0, tslib_1.__assign)({}, currentTag), { isClosing: true }));
          emitTagAndPreviousTextNode();
        } else {
          state = 4;
        }
      }
      function stateMarkupDeclarationOpen(char2) {
        if (html.substr(charIdx, 2) === "--") {
          charIdx += 2;
          currentTag = new CurrentTag((0, tslib_1.__assign)((0, tslib_1.__assign)({}, currentTag), { type: "comment" }));
          state = 14;
        } else if (html.substr(charIdx, 7).toUpperCase() === "DOCTYPE") {
          charIdx += 7;
          currentTag = new CurrentTag((0, tslib_1.__assign)((0, tslib_1.__assign)({}, currentTag), { type: "doctype" }));
          state = 20;
        } else {
          resetToDataState();
        }
      }
      function stateCommentStart(char2) {
        if (char2 === "-") {
          state = 15;
        } else if (char2 === ">") {
          resetToDataState();
        } else {
          state = 16;
        }
      }
      function stateCommentStartDash(char2) {
        if (char2 === "-") {
          state = 18;
        } else if (char2 === ">") {
          resetToDataState();
        } else {
          state = 16;
        }
      }
      function stateComment(char2) {
        if (char2 === "-") {
          state = 17;
        } else {
        }
      }
      function stateCommentEndDash(char2) {
        if (char2 === "-") {
          state = 18;
        } else {
          state = 16;
        }
      }
      function stateCommentEnd(char2) {
        if (char2 === ">") {
          emitTagAndPreviousTextNode();
        } else if (char2 === "!") {
          state = 19;
        } else if (char2 === "-") {
        } else {
          state = 16;
        }
      }
      function stateCommentEndBang(char2) {
        if (char2 === "-") {
          state = 17;
        } else if (char2 === ">") {
          emitTagAndPreviousTextNode();
        } else {
          state = 16;
        }
      }
      function stateDoctype(char2) {
        if (char2 === ">") {
          emitTagAndPreviousTextNode();
        } else if (char2 === "<") {
          startNewTag();
        } else {
        }
      }
      function resetToDataState() {
        state = 0;
        currentTag = noCurrentTag;
      }
      function startNewTag() {
        state = 1;
        currentTag = new CurrentTag({ idx: charIdx });
      }
      function emitTagAndPreviousTextNode() {
        var textBeforeTag = html.slice(currentDataIdx, currentTag.idx);
        if (textBeforeTag) {
          onText(textBeforeTag, currentDataIdx);
        }
        if (currentTag.type === "comment") {
          onComment(currentTag.idx);
        } else if (currentTag.type === "doctype") {
          onDoctype(currentTag.idx);
        } else {
          if (currentTag.isOpening) {
            onOpenTag(currentTag.name, currentTag.idx);
          }
          if (currentTag.isClosing) {
            onCloseTag(currentTag.name, currentTag.idx);
          }
        }
        resetToDataState();
        currentDataIdx = charIdx + 1;
      }
      function emitText() {
        var text = html.slice(currentDataIdx, charIdx);
        onText(text, currentDataIdx);
        currentDataIdx = charIdx + 1;
      }
      function captureTagName() {
        var startIdx = currentTag.idx + (currentTag.isClosing ? 2 : 1);
        return html.slice(startIdx, charIdx).toLowerCase();
      }
      function reconsumeCurrentCharacter() {
        charIdx--;
      }
    }
    exports2.parseHtml = parseHtml;
    var CurrentTag = function() {
      function CurrentTag2(cfg) {
        if (cfg === void 0) {
          cfg = {};
        }
        this.idx = cfg.idx !== void 0 ? cfg.idx : -1;
        this.type = cfg.type || "tag";
        this.name = cfg.name || "";
        this.isOpening = !!cfg.isOpening;
        this.isClosing = !!cfg.isClosing;
      }
      return CurrentTag2;
    }();
  }
});

// node_modules/autolinker/dist/commonjs/autolinker.js
var require_autolinker = __commonJS({
  "node_modules/autolinker/dist/commonjs/autolinker.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    var version_1 = require_version();
    var utils_1 = require_utils();
    var anchor_tag_builder_1 = require_anchor_tag_builder();
    var match_1 = require_match();
    var email_match_1 = require_email_match();
    var hashtag_match_1 = require_hashtag_match();
    var mention_match_1 = require_mention_match();
    var phone_match_1 = require_phone_match();
    var url_match_1 = require_url_match();
    var matcher_1 = require_matcher();
    var html_tag_1 = require_html_tag();
    var email_matcher_1 = require_email_matcher();
    var url_matcher_1 = require_url_matcher();
    var hashtag_matcher_1 = require_hashtag_matcher();
    var phone_matcher_1 = require_phone_matcher();
    var mention_matcher_1 = require_mention_matcher();
    var parse_html_1 = require_parse_html();
    var Autolinker3 = function() {
      function Autolinker4(cfg) {
        if (cfg === void 0) {
          cfg = {};
        }
        this.version = Autolinker4.version;
        this.urls = {};
        this.email = true;
        this.phone = true;
        this.hashtag = false;
        this.mention = false;
        this.newWindow = true;
        this.stripPrefix = {
          scheme: true,
          www: true
        };
        this.stripTrailingSlash = true;
        this.decodePercentEncoding = true;
        this.truncate = {
          length: 0,
          location: "end"
        };
        this.className = "";
        this.replaceFn = null;
        this.context = void 0;
        this.sanitizeHtml = false;
        this.matchers = null;
        this.tagBuilder = null;
        this.urls = this.normalizeUrlsCfg(cfg.urls);
        this.email = typeof cfg.email === "boolean" ? cfg.email : this.email;
        this.phone = typeof cfg.phone === "boolean" ? cfg.phone : this.phone;
        this.hashtag = cfg.hashtag || this.hashtag;
        this.mention = cfg.mention || this.mention;
        this.newWindow = typeof cfg.newWindow === "boolean" ? cfg.newWindow : this.newWindow;
        this.stripPrefix = this.normalizeStripPrefixCfg(cfg.stripPrefix);
        this.stripTrailingSlash = typeof cfg.stripTrailingSlash === "boolean" ? cfg.stripTrailingSlash : this.stripTrailingSlash;
        this.decodePercentEncoding = typeof cfg.decodePercentEncoding === "boolean" ? cfg.decodePercentEncoding : this.decodePercentEncoding;
        this.sanitizeHtml = cfg.sanitizeHtml || false;
        var mention = this.mention;
        if (mention !== false && ["twitter", "instagram", "soundcloud", "tiktok"].indexOf(mention) === -1) {
          throw new Error("invalid `mention` cfg '".concat(mention, "' - see docs"));
        }
        var hashtag = this.hashtag;
        if (hashtag !== false && ["twitter", "facebook", "instagram", "tiktok"].indexOf(hashtag) === -1) {
          throw new Error("invalid `hashtag` cfg '".concat(hashtag, "' - see docs"));
        }
        this.truncate = this.normalizeTruncateCfg(cfg.truncate);
        this.className = cfg.className || this.className;
        this.replaceFn = cfg.replaceFn || this.replaceFn;
        this.context = cfg.context || this;
      }
      Autolinker4.link = function(textOrHtml, options) {
        var autolinker3 = new Autolinker4(options);
        return autolinker3.link(textOrHtml);
      };
      Autolinker4.parse = function(textOrHtml, options) {
        var autolinker3 = new Autolinker4(options);
        return autolinker3.parse(textOrHtml);
      };
      Autolinker4.prototype.normalizeUrlsCfg = function(urls) {
        if (urls == null)
          urls = true;
        if (typeof urls === "boolean") {
          return { schemeMatches: urls, wwwMatches: urls, tldMatches: urls };
        } else {
          return {
            schemeMatches: typeof urls.schemeMatches === "boolean" ? urls.schemeMatches : true,
            wwwMatches: typeof urls.wwwMatches === "boolean" ? urls.wwwMatches : true,
            tldMatches: typeof urls.tldMatches === "boolean" ? urls.tldMatches : true
          };
        }
      };
      Autolinker4.prototype.normalizeStripPrefixCfg = function(stripPrefix) {
        if (stripPrefix == null)
          stripPrefix = true;
        if (typeof stripPrefix === "boolean") {
          return { scheme: stripPrefix, www: stripPrefix };
        } else {
          return {
            scheme: typeof stripPrefix.scheme === "boolean" ? stripPrefix.scheme : true,
            www: typeof stripPrefix.www === "boolean" ? stripPrefix.www : true
          };
        }
      };
      Autolinker4.prototype.normalizeTruncateCfg = function(truncate) {
        if (typeof truncate === "number") {
          return { length: truncate, location: "end" };
        } else {
          return (0, utils_1.defaults)(truncate || {}, {
            length: Number.POSITIVE_INFINITY,
            location: "end"
          });
        }
      };
      Autolinker4.prototype.parse = function(textOrHtml) {
        var _this = this;
        var skipTagNames = ["a", "style", "script"], skipTagsStackCount = 0, matches = [];
        (0, parse_html_1.parseHtml)(textOrHtml, {
          onOpenTag: function(tagName) {
            if (skipTagNames.indexOf(tagName) >= 0) {
              skipTagsStackCount++;
            }
          },
          onText: function(text, offset2) {
            if (skipTagsStackCount === 0) {
              var htmlCharacterEntitiesRegex = /(&nbsp;|&#160;|&lt;|&#60;|&gt;|&#62;|&quot;|&#34;|&#39;)/gi;
              var textSplit = (0, utils_1.splitAndCapture)(text, htmlCharacterEntitiesRegex);
              var currentOffset_1 = offset2;
              textSplit.forEach(function(splitText, i) {
                if (i % 2 === 0) {
                  var textNodeMatches = _this.parseText(splitText, currentOffset_1);
                  matches.push.apply(matches, textNodeMatches);
                }
                currentOffset_1 += splitText.length;
              });
            }
          },
          onCloseTag: function(tagName) {
            if (skipTagNames.indexOf(tagName) >= 0) {
              skipTagsStackCount = Math.max(skipTagsStackCount - 1, 0);
            }
          },
          onComment: function(offset2) {
          },
          onDoctype: function(offset2) {
          }
        });
        matches = this.compactMatches(matches);
        matches = this.removeUnwantedMatches(matches);
        return matches;
      };
      Autolinker4.prototype.compactMatches = function(matches) {
        matches.sort(function(a3, b) {
          return a3.getOffset() - b.getOffset();
        });
        var i = 0;
        while (i < matches.length - 1) {
          var match = matches[i], offset2 = match.getOffset(), matchedTextLength = match.getMatchedText().length, endIdx = offset2 + matchedTextLength;
          if (i + 1 < matches.length) {
            if (matches[i + 1].getOffset() === offset2) {
              var removeIdx = matches[i + 1].getMatchedText().length > matchedTextLength ? i : i + 1;
              matches.splice(removeIdx, 1);
              continue;
            }
            if (matches[i + 1].getOffset() < endIdx) {
              matches.splice(i + 1, 1);
              continue;
            }
          }
          i++;
        }
        return matches;
      };
      Autolinker4.prototype.removeUnwantedMatches = function(matches) {
        if (!this.hashtag)
          (0, utils_1.remove)(matches, function(match) {
            return match.getType() === "hashtag";
          });
        if (!this.email)
          (0, utils_1.remove)(matches, function(match) {
            return match.getType() === "email";
          });
        if (!this.phone)
          (0, utils_1.remove)(matches, function(match) {
            return match.getType() === "phone";
          });
        if (!this.mention)
          (0, utils_1.remove)(matches, function(match) {
            return match.getType() === "mention";
          });
        if (!this.urls.schemeMatches) {
          (0, utils_1.remove)(matches, function(m) {
            return m.getType() === "url" && m.getUrlMatchType() === "scheme";
          });
        }
        if (!this.urls.wwwMatches) {
          (0, utils_1.remove)(matches, function(m) {
            return m.getType() === "url" && m.getUrlMatchType() === "www";
          });
        }
        if (!this.urls.tldMatches) {
          (0, utils_1.remove)(matches, function(m) {
            return m.getType() === "url" && m.getUrlMatchType() === "tld";
          });
        }
        return matches;
      };
      Autolinker4.prototype.parseText = function(text, offset2) {
        if (offset2 === void 0) {
          offset2 = 0;
        }
        offset2 = offset2 || 0;
        var matchers = this.getMatchers(), matches = [];
        for (var i = 0, numMatchers = matchers.length; i < numMatchers; i++) {
          var textMatches = matchers[i].parseMatches(text);
          for (var j = 0, numTextMatches = textMatches.length; j < numTextMatches; j++) {
            textMatches[j].setOffset(offset2 + textMatches[j].getOffset());
          }
          matches.push.apply(matches, textMatches);
        }
        return matches;
      };
      Autolinker4.prototype.link = function(textOrHtml) {
        if (!textOrHtml) {
          return "";
        }
        if (this.sanitizeHtml) {
          textOrHtml = textOrHtml.replace(/</g, "&lt;").replace(/>/g, "&gt;");
        }
        var matches = this.parse(textOrHtml), newHtml = [], lastIndex = 0;
        for (var i = 0, len = matches.length; i < len; i++) {
          var match = matches[i];
          newHtml.push(textOrHtml.substring(lastIndex, match.getOffset()));
          newHtml.push(this.createMatchReturnVal(match));
          lastIndex = match.getOffset() + match.getMatchedText().length;
        }
        newHtml.push(textOrHtml.substring(lastIndex));
        return newHtml.join("");
      };
      Autolinker4.prototype.createMatchReturnVal = function(match) {
        var replaceFnResult;
        if (this.replaceFn) {
          replaceFnResult = this.replaceFn.call(this.context, match);
        }
        if (typeof replaceFnResult === "string") {
          return replaceFnResult;
        } else if (replaceFnResult === false) {
          return match.getMatchedText();
        } else if (replaceFnResult instanceof html_tag_1.HtmlTag) {
          return replaceFnResult.toAnchorString();
        } else {
          var anchorTag = match.buildTag();
          return anchorTag.toAnchorString();
        }
      };
      Autolinker4.prototype.getMatchers = function() {
        if (!this.matchers) {
          var tagBuilder = this.getTagBuilder();
          var matchers = [
            new hashtag_matcher_1.HashtagMatcher({
              tagBuilder,
              serviceName: this.hashtag
            }),
            new email_matcher_1.EmailMatcher({ tagBuilder }),
            new phone_matcher_1.PhoneMatcher({ tagBuilder }),
            new mention_matcher_1.MentionMatcher({
              tagBuilder,
              serviceName: this.mention
            }),
            new url_matcher_1.UrlMatcher({
              tagBuilder,
              stripPrefix: this.stripPrefix,
              stripTrailingSlash: this.stripTrailingSlash,
              decodePercentEncoding: this.decodePercentEncoding
            })
          ];
          return this.matchers = matchers;
        } else {
          return this.matchers;
        }
      };
      Autolinker4.prototype.getTagBuilder = function() {
        var tagBuilder = this.tagBuilder;
        if (!tagBuilder) {
          tagBuilder = this.tagBuilder = new anchor_tag_builder_1.AnchorTagBuilder({
            newWindow: this.newWindow,
            truncate: this.truncate,
            className: this.className
          });
        }
        return tagBuilder;
      };
      Autolinker4.version = version_1.version;
      Autolinker4.AnchorTagBuilder = anchor_tag_builder_1.AnchorTagBuilder;
      Autolinker4.HtmlTag = html_tag_1.HtmlTag;
      Autolinker4.matcher = {
        Email: email_matcher_1.EmailMatcher,
        Hashtag: hashtag_matcher_1.HashtagMatcher,
        Matcher: matcher_1.Matcher,
        Mention: mention_matcher_1.MentionMatcher,
        Phone: phone_matcher_1.PhoneMatcher,
        Url: url_matcher_1.UrlMatcher
      };
      Autolinker4.match = {
        Email: email_match_1.EmailMatch,
        Hashtag: hashtag_match_1.HashtagMatch,
        Match: match_1.Match,
        Mention: mention_match_1.MentionMatch,
        Phone: phone_match_1.PhoneMatch,
        Url: url_match_1.UrlMatch
      };
      return Autolinker4;
    }();
    exports2.default = Autolinker3;
  }
});

// node_modules/autolinker/dist/commonjs/match/index.js
var require_match2 = __commonJS({
  "node_modules/autolinker/dist/commonjs/match/index.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    var tslib_1 = require_tslib();
    (0, tslib_1.__exportStar)(require_email_match(), exports2);
    (0, tslib_1.__exportStar)(require_hashtag_match(), exports2);
    (0, tslib_1.__exportStar)(require_match(), exports2);
    (0, tslib_1.__exportStar)(require_mention_match(), exports2);
    (0, tslib_1.__exportStar)(require_phone_match(), exports2);
    (0, tslib_1.__exportStar)(require_url_match(), exports2);
  }
});

// node_modules/autolinker/dist/commonjs/matcher/index.js
var require_matcher2 = __commonJS({
  "node_modules/autolinker/dist/commonjs/matcher/index.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    var tslib_1 = require_tslib();
    (0, tslib_1.__exportStar)(require_email_matcher(), exports2);
    (0, tslib_1.__exportStar)(require_hashtag_matcher(), exports2);
    (0, tslib_1.__exportStar)(require_matcher(), exports2);
    (0, tslib_1.__exportStar)(require_mention_matcher(), exports2);
    (0, tslib_1.__exportStar)(require_phone_matcher(), exports2);
    (0, tslib_1.__exportStar)(require_url_matcher(), exports2);
  }
});

// node_modules/autolinker/dist/commonjs/index.js
var require_commonjs = __commonJS({
  "node_modules/autolinker/dist/commonjs/index.js"(exports2, module2) {
    "use strict";
    exports2 = module2.exports = require_autolinker().default;
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.Autolinker = void 0;
    var tslib_1 = require_tslib();
    var autolinker_1 = (0, tslib_1.__importDefault)(require_autolinker());
    exports2.Autolinker = autolinker_1.default;
    exports2.default = autolinker_1.default;
    (0, tslib_1.__exportStar)(require_autolinker(), exports2);
    (0, tslib_1.__exportStar)(require_anchor_tag_builder(), exports2);
    (0, tslib_1.__exportStar)(require_html_tag(), exports2);
    (0, tslib_1.__exportStar)(require_match2(), exports2);
    (0, tslib_1.__exportStar)(require_matcher2(), exports2);
  }
});

// node_modules/nosleep.js/dist/NoSleep.min.js
var require_NoSleep_min = __commonJS({
  "node_modules/nosleep.js/dist/NoSleep.min.js"(exports2, module2) {
    /*! NoSleep.min.js v0.9.0 - git.io/vfn01 - Rich Tibbett - MIT license */
    !function(A, e) {
      "object" == typeof exports2 && "object" == typeof module2 ? module2.exports = e() : "function" == typeof define && define.amd ? define([], e) : "object" == typeof exports2 ? exports2.NoSleep = e() : A.NoSleep = e();
    }("undefined" != typeof self ? self : exports2, function() {
      return function(A) {
        function e(B) {
          if (o[B])
            return o[B].exports;
          var Q = o[B] = { i: B, l: false, exports: {} };
          return A[B].call(Q.exports, Q, Q.exports, e), Q.l = true, Q.exports;
        }
        var o = {};
        return e.m = A, e.c = o, e.d = function(A2, o2, B) {
          e.o(A2, o2) || Object.defineProperty(A2, o2, { configurable: false, enumerable: true, get: B });
        }, e.n = function(A2) {
          var o2 = A2 && A2.__esModule ? function() {
            return A2.default;
          } : function() {
            return A2;
          };
          return e.d(o2, "a", o2), o2;
        }, e.o = function(A2, e2) {
          return Object.prototype.hasOwnProperty.call(A2, e2);
        }, e.p = "", e(e.s = 0);
      }([function(A, e, o) {
        "use strict";
        function B(A2, e2) {
          if (!(A2 instanceof e2))
            throw new TypeError("Cannot call a class as a function");
        }
        var Q = function() {
          function A2(A3, e2) {
            for (var o2 = 0; o2 < e2.length; o2++) {
              var B2 = e2[o2];
              B2.enumerable = B2.enumerable || false, B2.configurable = true, "value" in B2 && (B2.writable = true), Object.defineProperty(A3, B2.key, B2);
            }
          }
          return function(e2, o2, B2) {
            return o2 && A2(e2.prototype, o2), B2 && A2(e2, B2), e2;
          };
        }(), t = o(1), n = t.webm, c = t.mp4, E = "undefined" != typeof navigator && parseFloat(("" + (/CPU.*OS ([0-9_]{3,4})[0-9_]{0,1}|(CPU like).*AppleWebKit.*Mobile/i.exec(navigator.userAgent) || [0, ""])[1]).replace("undefined", "3_2").replace("_", ".").replace("_", "")) < 10 && !window.MSStream, l = function() {
          function A2() {
            var e2 = this;
            B(this, A2), E ? this.noSleepTimer = null : (this.noSleepVideo = document.createElement("video"), this.noSleepVideo.setAttribute("muted", ""), this.noSleepVideo.setAttribute("title", "No Sleep"), this.noSleepVideo.setAttribute("playsinline", ""), this._addSourceToVideo(this.noSleepVideo, "webm", n), this._addSourceToVideo(this.noSleepVideo, "mp4", c), this.noSleepVideo.addEventListener("loadedmetadata", function() {
              e2.noSleepVideo.duration <= 1 ? e2.noSleepVideo.setAttribute("loop", "") : e2.noSleepVideo.addEventListener("timeupdate", function() {
                e2.noSleepVideo.currentTime > 0.5 && (e2.noSleepVideo.currentTime = Math.random());
              });
            }));
          }
          return Q(A2, [{ key: "_addSourceToVideo", value: function(A3, e2, o2) {
            var B2 = document.createElement("source");
            B2.src = o2, B2.type = "video/" + e2, A3.appendChild(B2);
          } }, { key: "enable", value: function() {
            E ? (this.disable(), console.warn("\n        NoSleep enabled for older iOS devices. This can interrupt\n        active or long-running network requests from completing successfully.\n        See https://github.com/richtr/NoSleep.js/issues/15 for more details.\n      "), this.noSleepTimer = window.setInterval(function() {
              document.hidden || (window.location.href = window.location.href.split("#")[0], window.setTimeout(window.stop, 0));
            }, 15e3)) : this.noSleepVideo.play();
          } }, { key: "disable", value: function() {
            E ? this.noSleepTimer && (console.warn("\n          NoSleep now disabled for older iOS devices.\n        "), window.clearInterval(this.noSleepTimer), this.noSleepTimer = null) : this.noSleepVideo.pause();
          } }]), A2;
        }();
        A.exports = l;
      }, function(A, e, o) {
        "use strict";
        A.exports = { webm: "data:video/webm;base64,GkXfo0AgQoaBAUL3gQFC8oEEQvOBCEKCQAR3ZWJtQoeBAkKFgQIYU4BnQI0VSalmQCgq17FAAw9CQE2AQAZ3aGFtbXlXQUAGd2hhbW15RIlACECPQAAAAAAAFlSua0AxrkAu14EBY8WBAZyBACK1nEADdW5khkAFVl9WUDglhohAA1ZQOIOBAeBABrCBCLqBCB9DtnVAIueBAKNAHIEAAIAwAQCdASoIAAgAAUAmJaQAA3AA/vz0AAA=", mp4: "data:video/mp4;base64,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" };
      }]);
    });
  }
});

// Source/Cesium.js
var Cesium_exports = {};
__export(Cesium_exports, {
  AlphaMode: () => AlphaMode_default,
  AlphaPipelineStage: () => AlphaPipelineStage_default,
  Animation: () => Animation_default,
  AnimationViewModel: () => AnimationViewModel_default,
  Appearance: () => Appearance_default,
  ApproximateTerrainHeights: () => ApproximateTerrainHeights_default,
  ArcGISTiledElevationTerrainProvider: () => ArcGISTiledElevationTerrainProvider_default,
  ArcGisMapServerImageryProvider: () => ArcGisMapServerImageryProvider_default,
  ArcType: () => ArcType_default,
  ArticulationStageType: () => ArticulationStageType_default,
  AssociativeArray: () => AssociativeArray_default,
  AttributeCompression: () => AttributeCompression_default,
  AttributeType: () => AttributeType_default,
  AutoExposure: () => AutoExposure_default,
  AutomaticUniforms: () => AutomaticUniforms_default,
  Axis: () => Axis_default,
  AxisAlignedBoundingBox: () => AxisAlignedBoundingBox_default,
  B3dmLoader: () => B3dmLoader_default,
  B3dmParser: () => B3dmParser_default,
  BaseLayerPicker: () => BaseLayerPicker_default,
  BaseLayerPickerViewModel: () => BaseLayerPickerViewModel_default,
  BatchTable: () => BatchTable_default,
  BatchTableHierarchy: () => BatchTableHierarchy_default,
  BatchTexture: () => BatchTexture_default,
  BatchTexturePipelineStage: () => BatchTexturePipelineStage_default,
  Billboard: () => Billboard_default,
  BillboardCollection: () => BillboardCollection_default,
  BillboardGraphics: () => BillboardGraphics_default,
  BillboardVisualizer: () => BillboardVisualizer_default,
  BingMapsGeocoderService: () => BingMapsGeocoderService_default,
  BingMapsImageryProvider: () => BingMapsImageryProvider_default,
  BingMapsStyle: () => BingMapsStyle_default,
  BlendEquation: () => BlendEquation_default,
  BlendFunction: () => BlendFunction_default,
  BlendOption: () => BlendOption_default,
  BlendingState: () => BlendingState_default,
  BoundingRectangle: () => BoundingRectangle_default,
  BoundingSphere: () => BoundingSphere_default,
  BoundingSphereState: () => BoundingSphereState_default,
  BoxEmitter: () => BoxEmitter_default,
  BoxGeometry: () => BoxGeometry_default,
  BoxGeometryUpdater: () => BoxGeometryUpdater_default,
  BoxGraphics: () => BoxGraphics_default,
  BoxOutlineGeometry: () => BoxOutlineGeometry_default,
  BrdfLutGenerator: () => BrdfLutGenerator_default,
  Buffer: () => Buffer_default,
  BufferLoader: () => BufferLoader_default,
  BufferUsage: () => BufferUsage_default,
  CPUStylingPipelineStage: () => CPUStylingPipelineStage_default,
  CallbackProperty: () => CallbackProperty_default,
  Camera: () => Camera_default,
  CameraEventAggregator: () => CameraEventAggregator_default,
  CameraEventType: () => CameraEventType_default,
  CameraFlightPath: () => CameraFlightPath_default,
  Cartesian2: () => Cartesian2_default,
  Cartesian3: () => Cartesian3_default,
  Cartesian4: () => Cartesian4_default,
  Cartographic: () => Cartographic_default,
  CartographicGeocoderService: () => CartographicGeocoderService_default,
  CatmullRomSpline: () => CatmullRomSpline_default,
  Cesium3DContentGroup: () => Cesium3DContentGroup_default,
  Cesium3DTile: () => Cesium3DTile_default,
  Cesium3DTileBatchTable: () => Cesium3DTileBatchTable_default,
  Cesium3DTileColorBlendMode: () => Cesium3DTileColorBlendMode_default,
  Cesium3DTileContent: () => Cesium3DTileContent_default,
  Cesium3DTileContentFactory: () => Cesium3DTileContentFactory_default,
  Cesium3DTileContentState: () => Cesium3DTileContentState_default,
  Cesium3DTileContentType: () => Cesium3DTileContentType_default,
  Cesium3DTileFeature: () => Cesium3DTileFeature_default,
  Cesium3DTileFeatureTable: () => Cesium3DTileFeatureTable_default,
  Cesium3DTileOptimizationHint: () => Cesium3DTileOptimizationHint_default,
  Cesium3DTileOptimizations: () => Cesium3DTileOptimizations_default,
  Cesium3DTilePass: () => Cesium3DTilePass_default,
  Cesium3DTilePassState: () => Cesium3DTilePassState_default,
  Cesium3DTilePointFeature: () => Cesium3DTilePointFeature_default,
  Cesium3DTileRefine: () => Cesium3DTileRefine_default,
  Cesium3DTileStyle: () => Cesium3DTileStyle_default,
  Cesium3DTileStyleEngine: () => Cesium3DTileStyleEngine_default,
  Cesium3DTilesInspector: () => Cesium3DTilesInspector_default,
  Cesium3DTilesInspectorViewModel: () => Cesium3DTilesInspectorViewModel_default,
  Cesium3DTileset: () => Cesium3DTileset_default,
  Cesium3DTilesetCache: () => Cesium3DTilesetCache_default,
  Cesium3DTilesetGraphics: () => Cesium3DTilesetGraphics_default,
  Cesium3DTilesetHeatmap: () => Cesium3DTilesetHeatmap_default,
  Cesium3DTilesetMetadata: () => Cesium3DTilesetMetadata_default,
  Cesium3DTilesetMostDetailedTraversal: () => Cesium3DTilesetMostDetailedTraversal_default,
  Cesium3DTilesetStatistics: () => Cesium3DTilesetStatistics_default,
  Cesium3DTilesetTraversal: () => Cesium3DTilesetTraversal_default,
  Cesium3DTilesetVisualizer: () => Cesium3DTilesetVisualizer_default,
  CesiumInspector: () => CesiumInspector_default,
  CesiumInspectorViewModel: () => CesiumInspectorViewModel_default,
  CesiumTerrainProvider: () => CesiumTerrainProvider_default,
  CesiumWidget: () => CesiumWidget_default,
  Check: () => Check_default,
  CheckerboardMaterialProperty: () => CheckerboardMaterialProperty_default,
  CircleEmitter: () => CircleEmitter_default,
  CircleGeometry: () => CircleGeometry_default,
  CircleOutlineGeometry: () => CircleOutlineGeometry_default,
  ClassificationModelDrawCommand: () => ClassificationModelDrawCommand_default,
  ClassificationPipelineStage: () => ClassificationPipelineStage_default,
  ClassificationPrimitive: () => ClassificationPrimitive_default,
  ClassificationType: () => ClassificationType_default,
  ClearCommand: () => ClearCommand_default,
  ClippingPlane: () => ClippingPlane_default,
  ClippingPlaneCollection: () => ClippingPlaneCollection_default,
  Clock: () => Clock_default,
  ClockRange: () => ClockRange_default,
  ClockStep: () => ClockStep_default,
  ClockViewModel: () => ClockViewModel_default,
  CloudCollection: () => CloudCollection_default,
  CloudType: () => CloudType_default,
  Color: () => Color_default,
  ColorBlendMode: () => ColorBlendMode_default,
  ColorGeometryInstanceAttribute: () => ColorGeometryInstanceAttribute_default,
  ColorMaterialProperty: () => ColorMaterialProperty_default,
  Command: () => Command_default,
  ComponentDatatype: () => ComponentDatatype_default,
  Composite3DTileContent: () => Composite3DTileContent_default,
  CompositeEntityCollection: () => CompositeEntityCollection_default,
  CompositeMaterialProperty: () => CompositeMaterialProperty_default,
  CompositePositionProperty: () => CompositePositionProperty_default,
  CompositeProperty: () => CompositeProperty_default,
  CompressedTextureBuffer: () => CompressedTextureBuffer_default,
  ComputeCommand: () => ComputeCommand_default,
  ComputeEngine: () => ComputeEngine_default,
  ConditionsExpression: () => ConditionsExpression_default,
  ConeEmitter: () => ConeEmitter_default,
  ConstantPositionProperty: () => ConstantPositionProperty_default,
  ConstantProperty: () => ConstantProperty_default,
  ConstantSpline: () => ConstantSpline_default,
  ContentMetadata: () => ContentMetadata_default,
  Context: () => Context_default,
  ContextLimits: () => ContextLimits_default,
  CoplanarPolygonGeometry: () => CoplanarPolygonGeometry_default,
  CoplanarPolygonGeometryLibrary: () => CoplanarPolygonGeometryLibrary_default,
  CoplanarPolygonOutlineGeometry: () => CoplanarPolygonOutlineGeometry_default,
  CornerType: () => CornerType_default,
  CorridorGeometry: () => CorridorGeometry_default,
  CorridorGeometryLibrary: () => CorridorGeometryLibrary_default,
  CorridorGeometryUpdater: () => CorridorGeometryUpdater_default,
  CorridorGraphics: () => CorridorGraphics_default,
  CorridorOutlineGeometry: () => CorridorOutlineGeometry_default,
  Credit: () => Credit_default,
  CreditDisplay: () => CreditDisplay_default,
  CubeMap: () => CubeMap_default,
  CubeMapFace: () => CubeMapFace_default,
  CubicRealPolynomial: () => CubicRealPolynomial_default,
  CullFace: () => CullFace_default,
  CullingVolume: () => CullingVolume_default,
  CumulusCloud: () => CumulusCloud_default,
  CustomDataSource: () => CustomDataSource_default,
  CustomHeightmapTerrainProvider: () => CustomHeightmapTerrainProvider_default,
  CustomShader: () => CustomShader_default,
  CustomShaderMode: () => CustomShaderMode_default,
  CustomShaderPipelineStage: () => CustomShaderPipelineStage_default,
  CustomShaderTranslucencyMode: () => CustomShaderTranslucencyMode_default,
  CylinderGeometry: () => CylinderGeometry_default,
  CylinderGeometryLibrary: () => CylinderGeometryLibrary_default,
  CylinderGeometryUpdater: () => CylinderGeometryUpdater_default,
  CylinderGraphics: () => CylinderGraphics_default,
  CylinderOutlineGeometry: () => CylinderOutlineGeometry_default,
  CzmlDataSource: () => CzmlDataSource_default,
  DataSource: () => DataSource_default,
  DataSourceClock: () => DataSourceClock_default,
  DataSourceCollection: () => DataSourceCollection_default,
  DataSourceDisplay: () => DataSourceDisplay_default,
  DebugAppearance: () => DebugAppearance_default,
  DebugCameraPrimitive: () => DebugCameraPrimitive_default,
  DebugInspector: () => DebugInspector_default,
  DebugModelMatrixPrimitive: () => DebugModelMatrixPrimitive_default,
  DefaultProxy: () => DefaultProxy_default,
  DepthFunction: () => DepthFunction_default,
  DepthPlane: () => DepthPlane_default,
  DequantizationPipelineStage: () => DequantizationPipelineStage_default,
  DerivedCommand: () => DerivedCommand_default,
  DeveloperError: () => DeveloperError_default,
  DeviceOrientationCameraController: () => DeviceOrientationCameraController_default,
  DirectionalLight: () => DirectionalLight_default,
  DiscardEmptyTileImagePolicy: () => DiscardEmptyTileImagePolicy_default,
  DiscardMissingTileImagePolicy: () => DiscardMissingTileImagePolicy_default,
  DistanceDisplayCondition: () => DistanceDisplayCondition_default,
  DistanceDisplayConditionGeometryInstanceAttribute: () => DistanceDisplayConditionGeometryInstanceAttribute_default,
  DoubleEndedPriorityQueue: () => DoubleEndedPriorityQueue_default,
  DoublyLinkedList: () => DoublyLinkedList_default,
  DracoLoader: () => DracoLoader_default,
  DrawCommand: () => DrawCommand_default,
  DynamicGeometryBatch: () => DynamicGeometryBatch_default,
  DynamicGeometryUpdater: () => DynamicGeometryUpdater_default,
  EarthOrientationParameters: () => EarthOrientationParameters_default,
  EarthOrientationParametersSample: () => EarthOrientationParametersSample_default,
  EasingFunction: () => EasingFunction_default,
  EllipseGeometry: () => EllipseGeometry_default,
  EllipseGeometryLibrary: () => EllipseGeometryLibrary_default,
  EllipseGeometryUpdater: () => EllipseGeometryUpdater_default,
  EllipseGraphics: () => EllipseGraphics_default,
  EllipseOutlineGeometry: () => EllipseOutlineGeometry_default,
  Ellipsoid: () => Ellipsoid_default,
  EllipsoidGeodesic: () => EllipsoidGeodesic_default,
  EllipsoidGeometry: () => EllipsoidGeometry_default,
  EllipsoidGeometryUpdater: () => EllipsoidGeometryUpdater_default,
  EllipsoidGraphics: () => EllipsoidGraphics_default,
  EllipsoidOutlineGeometry: () => EllipsoidOutlineGeometry_default,
  EllipsoidPrimitive: () => EllipsoidPrimitive_default,
  EllipsoidRhumbLine: () => EllipsoidRhumbLine_default,
  EllipsoidSurfaceAppearance: () => EllipsoidSurfaceAppearance_default,
  EllipsoidTangentPlane: () => EllipsoidTangentPlane_default,
  EllipsoidTerrainProvider: () => EllipsoidTerrainProvider_default,
  EllipsoidalOccluder: () => EllipsoidalOccluder_default,
  Empty3DTileContent: () => Empty3DTileContent_default,
  EncodedCartesian3: () => EncodedCartesian3_default,
  Entity: () => Entity_default,
  EntityCluster: () => EntityCluster_default,
  EntityCollection: () => EntityCollection_default,
  EntityView: () => EntityView_default,
  Event: () => Event_default,
  EventHelper: () => EventHelper_default,
  Expression: () => Expression_default,
  ExpressionNodeType: () => ExpressionNodeType_default,
  ExtrapolationType: () => ExtrapolationType_default,
  FeatureDetection: () => FeatureDetection_default,
  FeatureIdPipelineStage: () => FeatureIdPipelineStage_default,
  Fog: () => Fog_default,
  ForEach: () => ForEach_default,
  FrameRateMonitor: () => FrameRateMonitor_default,
  FrameState: () => FrameState_default,
  Framebuffer: () => Framebuffer_default,
  FramebufferManager: () => FramebufferManager_default,
  FrustumCommands: () => FrustumCommands_default,
  FrustumGeometry: () => FrustumGeometry_default,
  FrustumOutlineGeometry: () => FrustumOutlineGeometry_default,
  Fullscreen: () => Fullscreen_default,
  FullscreenButton: () => FullscreenButton_default,
  FullscreenButtonViewModel: () => FullscreenButtonViewModel_default,
  GeoJsonDataSource: () => GeoJsonDataSource_default,
  GeoJsonLoader: () => GeoJsonLoader_default,
  GeocodeType: () => GeocodeType_default,
  Geocoder: () => Geocoder_default,
  GeocoderService: () => GeocoderService_default,
  GeocoderViewModel: () => GeocoderViewModel_default,
  GeographicProjection: () => GeographicProjection_default,
  GeographicTilingScheme: () => GeographicTilingScheme_default,
  Geometry: () => Geometry_default,
  Geometry3DTileContent: () => Geometry3DTileContent_default,
  GeometryAttribute: () => GeometryAttribute_default,
  GeometryAttributes: () => GeometryAttributes_default,
  GeometryFactory: () => GeometryFactory_default,
  GeometryInstance: () => GeometryInstance_default,
  GeometryInstanceAttribute: () => GeometryInstanceAttribute_default,
  GeometryOffsetAttribute: () => GeometryOffsetAttribute_default,
  GeometryPipeline: () => GeometryPipeline_default,
  GeometryPipelineStage: () => GeometryPipelineStage_default,
  GeometryType: () => GeometryType_default,
  GeometryUpdater: () => GeometryUpdater_default,
  GeometryVisualizer: () => GeometryVisualizer_default,
  GetFeatureInfoFormat: () => GetFeatureInfoFormat_default,
  Globe: () => Globe_default,
  GlobeDepth: () => GlobeDepth_default,
  GlobeSurfaceShaderSet: () => GlobeSurfaceShaderSet_default,
  GlobeSurfaceTile: () => GlobeSurfaceTile_default,
  GlobeSurfaceTileProvider: () => GlobeSurfaceTileProvider_default,
  GlobeTranslucency: () => GlobeTranslucency_default,
  GlobeTranslucencyFramebuffer: () => GlobeTranslucencyFramebuffer_default,
  GlobeTranslucencyState: () => GlobeTranslucencyState_default,
  GltfBufferViewLoader: () => GltfBufferViewLoader_default,
  GltfDracoLoader: () => GltfDracoLoader_default,
  GltfImageLoader: () => GltfImageLoader_default,
  GltfIndexBufferLoader: () => GltfIndexBufferLoader_default,
  GltfJsonLoader: () => GltfJsonLoader_default,
  GltfLoader: () => GltfLoader_default,
  GltfLoaderUtil: () => GltfLoaderUtil_default,
  GltfStructuralMetadataLoader: () => GltfStructuralMetadataLoader_default,
  GltfTextureLoader: () => GltfTextureLoader_default,
  GltfVertexBufferLoader: () => GltfVertexBufferLoader_default,
  GoogleEarthEnterpriseImageryProvider: () => GoogleEarthEnterpriseImageryProvider_default,
  GoogleEarthEnterpriseMapsProvider: () => GoogleEarthEnterpriseMapsProvider_default,
  GoogleEarthEnterpriseMetadata: () => GoogleEarthEnterpriseMetadata_default,
  GoogleEarthEnterpriseTerrainData: () => GoogleEarthEnterpriseTerrainData_default,
  GoogleEarthEnterpriseTerrainProvider: () => GoogleEarthEnterpriseTerrainProvider_default,
  GoogleEarthEnterpriseTileInformation: () => GoogleEarthEnterpriseTileInformation_default,
  GpxDataSource: () => GpxDataSource_default,
  GregorianDate: () => GregorianDate_default,
  GridImageryProvider: () => GridImageryProvider_default,
  GridMaterialProperty: () => GridMaterialProperty_default,
  GroundGeometryUpdater: () => GroundGeometryUpdater_default,
  GroundPolylineGeometry: () => GroundPolylineGeometry_default,
  GroundPolylinePrimitive: () => GroundPolylinePrimitive_default,
  GroundPrimitive: () => GroundPrimitive_default,
  GroupMetadata: () => GroupMetadata_default,
  HeadingPitchRange: () => HeadingPitchRange_default,
  HeadingPitchRoll: () => HeadingPitchRoll_default,
  Heap: () => Heap_default,
  HeightReference: () => HeightReference_default,
  HeightmapEncoding: () => HeightmapEncoding_default,
  HeightmapTerrainData: () => HeightmapTerrainData_default,
  HeightmapTessellator: () => HeightmapTessellator_default,
  HermitePolynomialApproximation: () => HermitePolynomialApproximation_default,
  HermiteSpline: () => HermiteSpline_default,
  HilbertOrder: () => HilbertOrder_default,
  HomeButton: () => HomeButton_default,
  HomeButtonViewModel: () => HomeButtonViewModel_default,
  HorizontalOrigin: () => HorizontalOrigin_default,
  I3dmLoader: () => I3dmLoader_default,
  I3dmParser: () => I3dmParser_default,
  Iau2000Orientation: () => Iau2000Orientation_default,
  Iau2006XysData: () => Iau2006XysData_default,
  Iau2006XysSample: () => Iau2006XysSample_default,
  IauOrientationAxes: () => IauOrientationAxes_default,
  IauOrientationParameters: () => IauOrientationParameters_default,
  ImageBasedLighting: () => ImageBasedLighting_default,
  ImageBasedLightingPipelineStage: () => ImageBasedLightingPipelineStage_default,
  ImageMaterialProperty: () => ImageMaterialProperty_default,
  Imagery: () => Imagery_default,
  ImageryLayer: () => ImageryLayer_default,
  ImageryLayerCollection: () => ImageryLayerCollection_default,
  ImageryLayerFeatureInfo: () => ImageryLayerFeatureInfo_default,
  ImageryProvider: () => ImageryProvider_default,
  ImageryState: () => ImageryState_default,
  Implicit3DTileContent: () => Implicit3DTileContent_default,
  ImplicitAvailabilityBitstream: () => ImplicitAvailabilityBitstream_default,
  ImplicitMetadataView: () => ImplicitMetadataView_default,
  ImplicitSubdivisionScheme: () => ImplicitSubdivisionScheme_default,
  ImplicitSubtree: () => ImplicitSubtree_default,
  ImplicitSubtreeMetadata: () => ImplicitSubtreeMetadata_default,
  ImplicitTileCoordinates: () => ImplicitTileCoordinates_default,
  ImplicitTileset: () => ImplicitTileset_default,
  IndexDatatype: () => IndexDatatype_default,
  InfoBox: () => InfoBox_default,
  InfoBoxViewModel: () => InfoBoxViewModel_default,
  InspectorShared: () => InspectorShared_default,
  InstanceAttributeSemantic: () => InstanceAttributeSemantic_default,
  InstancingPipelineStage: () => InstancingPipelineStage_default,
  InterpolationAlgorithm: () => InterpolationAlgorithm_default,
  InterpolationType: () => InterpolationType_default,
  Intersect: () => Intersect_default,
  IntersectionTests: () => IntersectionTests_default,
  Intersections2D: () => Intersections2D_default,
  Interval: () => Interval_default,
  InvertClassification: () => InvertClassification_default,
  Ion: () => Ion_default,
  IonGeocoderService: () => IonGeocoderService_default,
  IonImageryProvider: () => IonImageryProvider_default,
  IonResource: () => IonResource_default,
  IonWorldImageryStyle: () => IonWorldImageryStyle_default,
  Iso8601: () => Iso8601_default,
  JobScheduler: () => JobScheduler_default,
  JobType: () => JobType_default,
  JsonMetadataTable: () => JsonMetadataTable_default,
  JulianDate: () => JulianDate_default,
  KTX2Transcoder: () => KTX2Transcoder_default,
  KeyboardEventModifier: () => KeyboardEventModifier_default,
  KmlCamera: () => KmlCamera_default,
  KmlDataSource: () => KmlDataSource_default,
  KmlLookAt: () => KmlLookAt_default,
  KmlTour: () => KmlTour_default,
  KmlTourFlyTo: () => KmlTourFlyTo_default,
  KmlTourWait: () => KmlTourWait_default,
  Label: () => Label_default,
  LabelCollection: () => LabelCollection_default,
  LabelGraphics: () => LabelGraphics_default,
  LabelStyle: () => LabelStyle_default,
  LabelVisualizer: () => LabelVisualizer_default,
  LagrangePolynomialApproximation: () => LagrangePolynomialApproximation_default,
  LeapSecond: () => LeapSecond_default,
  Light: () => Light_default,
  LightingModel: () => LightingModel_default,
  LightingPipelineStage: () => LightingPipelineStage_default,
  LinearApproximation: () => LinearApproximation_default,
  LinearSpline: () => LinearSpline_default,
  ManagedArray: () => ManagedArray_default,
  MapMode2D: () => MapMode2D_default,
  MapProjection: () => MapProjection_default,
  MapboxImageryProvider: () => MapboxImageryProvider_default,
  MapboxStyleImageryProvider: () => MapboxStyleImageryProvider_default,
  Material: () => Material_default,
  MaterialAppearance: () => MaterialAppearance_default,
  MaterialPipelineStage: () => MaterialPipelineStage_default,
  MaterialProperty: () => MaterialProperty_default,
  Math: () => Math_default,
  Matrix2: () => Matrix2_default,
  Matrix3: () => Matrix3_default,
  Matrix4: () => Matrix4_default,
  MetadataClass: () => MetadataClass_default,
  MetadataClassProperty: () => MetadataClassProperty_default,
  MetadataComponentType: () => MetadataComponentType_default,
  MetadataEntity: () => MetadataEntity_default,
  MetadataEnum: () => MetadataEnum_default,
  MetadataEnumValue: () => MetadataEnumValue_default,
  MetadataPipelineStage: () => MetadataPipelineStage_default,
  MetadataSchema: () => MetadataSchema_default,
  MetadataSchemaLoader: () => MetadataSchemaLoader_default,
  MetadataSemantic: () => MetadataSemantic_default,
  MetadataTable: () => MetadataTable_default,
  MetadataTableProperty: () => MetadataTableProperty_default,
  MetadataType: () => MetadataType_default,
  MipmapHint: () => MipmapHint_default,
  Model: () => Model_default,
  Model3DTileContent: () => Model3DTileContent_default,
  ModelAlphaOptions: () => ModelAlphaOptions_default,
  ModelAnimation: () => ModelAnimation_default,
  ModelAnimationChannel: () => ModelAnimationChannel_default,
  ModelAnimationCollection: () => ModelAnimationCollection_default,
  ModelAnimationLoop: () => ModelAnimationLoop_default,
  ModelAnimationState: () => ModelAnimationState_default,
  ModelArticulation: () => ModelArticulation_default,
  ModelArticulationStage: () => ModelArticulationStage_default,
  ModelClippingPlanesPipelineStage: () => ModelClippingPlanesPipelineStage_default,
  ModelColorPipelineStage: () => ModelColorPipelineStage_default,
  ModelComponents: () => ModelComponents_default,
  ModelDrawCommand: () => ModelDrawCommand_default,
  ModelFeature: () => ModelFeature_default,
  ModelFeatureTable: () => ModelFeatureTable_default,
  ModelGraphics: () => ModelGraphics_default,
  ModelLightingOptions: () => ModelLightingOptions_default,
  ModelMatrixUpdateStage: () => ModelMatrixUpdateStage_default,
  ModelNode: () => ModelNode_default,
  ModelRenderResources: () => ModelRenderResources_default,
  ModelRuntimeNode: () => ModelRuntimeNode_default,
  ModelRuntimePrimitive: () => ModelRuntimePrimitive_default,
  ModelSceneGraph: () => ModelSceneGraph_default,
  ModelSilhouettePipelineStage: () => ModelSilhouettePipelineStage_default,
  ModelSkin: () => ModelSkin_default,
  ModelSplitterPipelineStage: () => ModelSplitterPipelineStage_default,
  ModelStatistics: () => ModelStatistics_default,
  ModelType: () => ModelType_default,
  ModelUtility: () => ModelUtility_default,
  ModelVisualizer: () => ModelVisualizer_default,
  Moon: () => Moon_default,
  MorphTargetsPipelineStage: () => MorphTargetsPipelineStage_default,
  MorphWeightSpline: () => MorphWeightSpline_default,
  MortonOrder: () => MortonOrder_default,
  Multiple3DTileContent: () => Multiple3DTileContent_default,
  MultisampleFramebuffer: () => MultisampleFramebuffer_default,
  NavigationHelpButton: () => NavigationHelpButton_default,
  NavigationHelpButtonViewModel: () => NavigationHelpButtonViewModel_default,
  NearFarScalar: () => NearFarScalar_default,
  NeverTileDiscardPolicy: () => NeverTileDiscardPolicy_default,
  NodeRenderResources: () => NodeRenderResources_default,
  NodeStatisticsPipelineStage: () => NodeStatisticsPipelineStage_default,
  NodeTransformationProperty: () => NodeTransformationProperty_default,
  OIT: () => OIT_default,
  Occluder: () => Occluder_default,
  OctahedralProjectedCubeMap: () => OctahedralProjectedCubeMap_default,
  OffsetGeometryInstanceAttribute: () => OffsetGeometryInstanceAttribute_default,
  OpenCageGeocoderService: () => OpenCageGeocoderService_default,
  OpenStreetMapImageryProvider: () => OpenStreetMapImageryProvider_default,
  OrderedGroundPrimitiveCollection: () => OrderedGroundPrimitiveCollection_default,
  OrientedBoundingBox: () => OrientedBoundingBox_default,
  OrthographicFrustum: () => OrthographicFrustum_default,
  OrthographicOffCenterFrustum: () => OrthographicOffCenterFrustum_default,
  Packable: () => Packable_default,
  PackableForInterpolation: () => PackableForInterpolation_default,
  Particle: () => Particle_default,
  ParticleBurst: () => ParticleBurst_default,
  ParticleEmitter: () => ParticleEmitter_default,
  ParticleSystem: () => ParticleSystem_default,
  Pass: () => Pass_default,
  PassState: () => PassState_default,
  PathGraphics: () => PathGraphics_default,
  PathVisualizer: () => PathVisualizer_default,
  PeliasGeocoderService: () => PeliasGeocoderService_default,
  PerInstanceColorAppearance: () => PerInstanceColorAppearance_default,
  PerformanceDisplay: () => PerformanceDisplay_default,
  PerformanceWatchdog: () => PerformanceWatchdog_default,
  PerformanceWatchdogViewModel: () => PerformanceWatchdogViewModel_default,
  PerspectiveFrustum: () => PerspectiveFrustum_default,
  PerspectiveOffCenterFrustum: () => PerspectiveOffCenterFrustum_default,
  PickDepth: () => PickDepth_default,
  PickDepthFramebuffer: () => PickDepthFramebuffer_default,
  PickFramebuffer: () => PickFramebuffer_default,
  Picking: () => Picking_default,
  PickingPipelineStage: () => PickingPipelineStage_default,
  PinBuilder: () => PinBuilder_default,
  PixelDatatype: () => PixelDatatype_default,
  PixelFormat: () => PixelFormat_default,
  Plane: () => Plane_default,
  PlaneGeometry: () => PlaneGeometry_default,
  PlaneGeometryUpdater: () => PlaneGeometryUpdater_default,
  PlaneGraphics: () => PlaneGraphics_default,
  PlaneOutlineGeometry: () => PlaneOutlineGeometry_default,
  PntsLoader: () => PntsLoader_default,
  PntsParser: () => PntsParser_default,
  PointCloud: () => PointCloud_default,
  PointCloudEyeDomeLighting: () => PointCloudEyeDomeLighting_default2,
  PointCloudShading: () => PointCloudShading_default,
  PointCloudStylingPipelineStage: () => PointCloudStylingPipelineStage_default,
  PointGraphics: () => PointGraphics_default,
  PointPrimitive: () => PointPrimitive_default,
  PointPrimitiveCollection: () => PointPrimitiveCollection_default,
  PointVisualizer: () => PointVisualizer_default,
  PolygonGeometry: () => PolygonGeometry_default,
  PolygonGeometryLibrary: () => PolygonGeometryLibrary_default,
  PolygonGeometryUpdater: () => PolygonGeometryUpdater_default,
  PolygonGraphics: () => PolygonGraphics_default,
  PolygonHierarchy: () => PolygonHierarchy_default,
  PolygonOutlineGeometry: () => PolygonOutlineGeometry_default,
  PolygonPipeline: () => PolygonPipeline_default,
  Polyline: () => Polyline_default,
  PolylineArrowMaterialProperty: () => PolylineArrowMaterialProperty_default,
  PolylineCollection: () => PolylineCollection_default,
  PolylineColorAppearance: () => PolylineColorAppearance_default,
  PolylineDashMaterialProperty: () => PolylineDashMaterialProperty_default,
  PolylineGeometry: () => PolylineGeometry_default,
  PolylineGeometryUpdater: () => PolylineGeometryUpdater_default,
  PolylineGlowMaterialProperty: () => PolylineGlowMaterialProperty_default,
  PolylineGraphics: () => PolylineGraphics_default,
  PolylineMaterialAppearance: () => PolylineMaterialAppearance_default,
  PolylineOutlineMaterialProperty: () => PolylineOutlineMaterialProperty_default,
  PolylinePipeline: () => PolylinePipeline_default,
  PolylineVisualizer: () => PolylineVisualizer_default,
  PolylineVolumeGeometry: () => PolylineVolumeGeometry_default,
  PolylineVolumeGeometryLibrary: () => PolylineVolumeGeometryLibrary_default,
  PolylineVolumeGeometryUpdater: () => PolylineVolumeGeometryUpdater_default,
  PolylineVolumeGraphics: () => PolylineVolumeGraphics_default,
  PolylineVolumeOutlineGeometry: () => PolylineVolumeOutlineGeometry_default,
  PositionProperty: () => PositionProperty_default,
  PositionPropertyArray: () => PositionPropertyArray_default,
  PostProcessStage: () => PostProcessStage_default,
  PostProcessStageCollection: () => PostProcessStageCollection_default,
  PostProcessStageComposite: () => PostProcessStageComposite_default,
  PostProcessStageLibrary: () => PostProcessStageLibrary_default,
  PostProcessStageSampleMode: () => PostProcessStageSampleMode_default,
  PostProcessStageTextureCache: () => PostProcessStageTextureCache_default,
  Primitive: () => Primitive_default,
  PrimitiveCollection: () => PrimitiveCollection_default,
  PrimitiveLoadPlan: () => PrimitiveLoadPlan_default,
  PrimitiveOutlineGenerator: () => PrimitiveOutlineGenerator_default,
  PrimitiveOutlinePipelineStage: () => PrimitiveOutlinePipelineStage_default,
  PrimitivePipeline: () => PrimitivePipeline_default,
  PrimitiveRenderResources: () => PrimitiveRenderResources_default,
  PrimitiveState: () => PrimitiveState_default,
  PrimitiveStatisticsPipelineStage: () => PrimitiveStatisticsPipelineStage_default,
  PrimitiveType: () => PrimitiveType_default,
  ProjectionPicker: () => ProjectionPicker_default,
  ProjectionPickerViewModel: () => ProjectionPickerViewModel_default,
  Property: () => Property_default,
  PropertyArray: () => PropertyArray_default,
  PropertyAttribute: () => PropertyAttribute_default,
  PropertyAttributeProperty: () => PropertyAttributeProperty_default,
  PropertyBag: () => PropertyBag_default,
  PropertyTable: () => PropertyTable_default,
  PropertyTexture: () => PropertyTexture_default,
  PropertyTextureProperty: () => PropertyTextureProperty_default,
  ProviderViewModel: () => ProviderViewModel_default,
  Proxy: () => Proxy_default,
  QuadraticRealPolynomial: () => QuadraticRealPolynomial_default,
  QuadtreeOccluders: () => QuadtreeOccluders_default,
  QuadtreePrimitive: () => QuadtreePrimitive_default,
  QuadtreeTile: () => QuadtreeTile_default,
  QuadtreeTileLoadState: () => QuadtreeTileLoadState_default,
  QuadtreeTileProvider: () => QuadtreeTileProvider_default,
  QuantizedMeshTerrainData: () => QuantizedMeshTerrainData_default,
  QuarticRealPolynomial: () => QuarticRealPolynomial_default,
  Quaternion: () => Quaternion_default,
  QuaternionSpline: () => QuaternionSpline_default,
  Queue: () => Queue_default,
  Ray: () => Ray_default,
  Rectangle: () => Rectangle_default,
  RectangleCollisionChecker: () => RectangleCollisionChecker_default,
  RectangleGeometry: () => RectangleGeometry_default,
  RectangleGeometryLibrary: () => RectangleGeometryLibrary_default,
  RectangleGeometryUpdater: () => RectangleGeometryUpdater_default,
  RectangleGraphics: () => RectangleGraphics_default,
  RectangleOutlineGeometry: () => RectangleOutlineGeometry_default,
  ReferenceFrame: () => ReferenceFrame_default,
  ReferenceProperty: () => ReferenceProperty_default,
  RenderState: () => RenderState_default,
  Renderbuffer: () => Renderbuffer_default,
  RenderbufferFormat: () => RenderbufferFormat_default,
  Request: () => Request_default,
  RequestErrorEvent: () => RequestErrorEvent_default,
  RequestScheduler: () => RequestScheduler_default,
  RequestState: () => RequestState_default,
  RequestType: () => RequestType_default,
  Resource: () => Resource_default,
  ResourceCache: () => ResourceCache_default,
  ResourceCacheKey: () => ResourceCacheKey_default,
  ResourceCacheStatistics: () => ResourceCacheStatistics_default,
  ResourceLoader: () => ResourceLoader_default,
  ResourceLoaderState: () => ResourceLoaderState_default,
  Rotation: () => Rotation_default,
  RuntimeError: () => RuntimeError_default,
  S2Cell: () => S2Cell_default,
  SDFSettings: () => SDFSettings_default,
  SampledPositionProperty: () => SampledPositionProperty_default,
  SampledProperty: () => SampledProperty_default,
  Sampler: () => Sampler_default,
  ScaledPositionProperty: () => ScaledPositionProperty_default,
  Scene: () => Scene_default,
  SceneFramebuffer: () => SceneFramebuffer_default,
  SceneMode: () => SceneMode_default,
  SceneMode2DPipelineStage: () => SceneMode2DPipelineStage_default,
  SceneModePicker: () => SceneModePicker_default,
  SceneModePickerViewModel: () => SceneModePickerViewModel_default,
  SceneTransforms: () => SceneTransforms_default,
  SceneTransitioner: () => SceneTransitioner_default,
  ScreenSpaceCameraController: () => ScreenSpaceCameraController_default,
  ScreenSpaceEventHandler: () => ScreenSpaceEventHandler_default,
  ScreenSpaceEventType: () => ScreenSpaceEventType_default,
  SelectedFeatureIdPipelineStage: () => SelectedFeatureIdPipelineStage_default,
  SelectionIndicator: () => SelectionIndicator_default,
  SelectionIndicatorViewModel: () => SelectionIndicatorViewModel_default,
  ShaderBuilder: () => ShaderBuilder_default,
  ShaderCache: () => ShaderCache_default,
  ShaderDestination: () => ShaderDestination_default,
  ShaderFunction: () => ShaderFunction_default,
  ShaderProgram: () => ShaderProgram_default,
  ShaderSource: () => ShaderSource_default,
  ShaderStruct: () => ShaderStruct_default,
  ShadowMap: () => ShadowMap_default,
  ShadowMapShader: () => ShadowMapShader_default,
  ShadowMode: () => ShadowMode_default,
  ShadowVolumeAppearance: () => ShadowVolumeAppearance_default,
  ShowGeometryInstanceAttribute: () => ShowGeometryInstanceAttribute_default,
  Simon1994PlanetaryPositions: () => Simon1994PlanetaryPositions_default,
  SimplePolylineGeometry: () => SimplePolylineGeometry_default,
  SingleTileImageryProvider: () => SingleTileImageryProvider_default,
  SkinningPipelineStage: () => SkinningPipelineStage_default,
  SkyAtmosphere: () => SkyAtmosphere_default,
  SkyBox: () => SkyBox_default,
  SphereEmitter: () => SphereEmitter_default,
  SphereGeometry: () => SphereGeometry_default,
  SphereOutlineGeometry: () => SphereOutlineGeometry_default,
  Spherical: () => Spherical_default,
  Spline: () => Spline_default,
  SplitDirection: () => SplitDirection_default,
  Splitter: () => Splitter_default,
  StaticGeometryColorBatch: () => StaticGeometryColorBatch_default,
  StaticGeometryPerMaterialBatch: () => StaticGeometryPerMaterialBatch_default,
  StaticGroundGeometryColorBatch: () => StaticGroundGeometryColorBatch_default,
  StaticGroundGeometryPerMaterialBatch: () => StaticGroundGeometryPerMaterialBatch_default,
  StaticGroundPolylinePerMaterialBatch: () => StaticGroundPolylinePerMaterialBatch_default,
  StaticOutlineGeometryBatch: () => StaticOutlineGeometryBatch_default,
  StencilConstants: () => StencilConstants_default,
  StencilFunction: () => StencilFunction_default,
  StencilOperation: () => StencilOperation_default,
  SteppedSpline: () => SteppedSpline_default,
  StripeMaterialProperty: () => StripeMaterialProperty_default,
  StripeOrientation: () => StripeOrientation_default,
  StructuralMetadata: () => StructuralMetadata_default,
  StyleCommandsNeeded: () => StyleCommandsNeeded_default,
  StyleExpression: () => StyleExpression_default,
  Sun: () => Sun_default,
  SunLight: () => SunLight_default,
  SunPostProcess: () => SunPostProcess_default,
  SupportedImageFormats: () => SupportedImageFormats_default,
  SvgPathBindingHandler: () => SvgPathBindingHandler_default,
  TaskProcessor: () => TaskProcessor_default,
  TerrainData: () => TerrainData_default,
  TerrainEncoding: () => TerrainEncoding_default,
  TerrainExaggeration: () => TerrainExaggeration_default,
  TerrainFillMesh: () => TerrainFillMesh_default,
  TerrainMesh: () => TerrainMesh_default,
  TerrainOffsetProperty: () => TerrainOffsetProperty_default,
  TerrainProvider: () => TerrainProvider_default,
  TerrainQuantization: () => TerrainQuantization_default,
  TerrainState: () => TerrainState_default,
  Texture: () => Texture_default,
  TextureAtlas: () => TextureAtlas_default,
  TextureCache: () => TextureCache_default,
  TextureMagnificationFilter: () => TextureMagnificationFilter_default,
  TextureManager: () => TextureManager_default,
  TextureMinificationFilter: () => TextureMinificationFilter_default,
  TextureUniform: () => TextureUniform_default,
  TextureWrap: () => TextureWrap_default,
  TileAvailability: () => TileAvailability_default,
  TileBoundingRegion: () => TileBoundingRegion_default,
  TileBoundingS2Cell: () => TileBoundingS2Cell_default,
  TileBoundingSphere: () => TileBoundingSphere_default,
  TileBoundingVolume: () => TileBoundingVolume_default,
  TileCoordinatesImageryProvider: () => TileCoordinatesImageryProvider_default,
  TileDiscardPolicy: () => TileDiscardPolicy_default,
  TileEdge: () => TileEdge_default,
  TileImagery: () => TileImagery_default,
  TileMapServiceImageryProvider: () => TileMapServiceImageryProvider_default,
  TileMetadata: () => TileMetadata_default,
  TileOrientedBoundingBox: () => TileOrientedBoundingBox_default,
  TileProviderError: () => TileProviderError_default,
  TileReplacementQueue: () => TileReplacementQueue_default,
  TileSelectionResult: () => TileSelectionResult_default,
  TileState: () => TileState_default,
  Tileset3DTileContent: () => Tileset3DTileContent_default,
  TilesetMetadata: () => TilesetMetadata_default,
  TilesetPipelineStage: () => TilesetPipelineStage_default,
  TilingScheme: () => TilingScheme_default,
  TimeConstants: () => TimeConstants_default,
  TimeDynamicImagery: () => TimeDynamicImagery_default,
  TimeDynamicPointCloud: () => TimeDynamicPointCloud_default,
  TimeInterval: () => TimeInterval_default,
  TimeIntervalCollection: () => TimeIntervalCollection_default,
  TimeIntervalCollectionPositionProperty: () => TimeIntervalCollectionPositionProperty_default,
  TimeIntervalCollectionProperty: () => TimeIntervalCollectionProperty_default,
  TimeStandard: () => TimeStandard_default,
  Timeline: () => Timeline_default,
  TimelineHighlightRange: () => TimelineHighlightRange_default,
  TimelineTrack: () => TimelineTrack_default,
  Tipsify: () => Tipsify_default,
  ToggleButtonViewModel: () => ToggleButtonViewModel_default,
  Tonemapper: () => Tonemapper_default,
  Transforms: () => Transforms_default,
  TranslationRotationScale: () => TranslationRotationScale_default,
  TranslucentTileClassification: () => TranslucentTileClassification_default,
  TridiagonalSystemSolver: () => TridiagonalSystemSolver_default,
  TrustedServers: () => TrustedServers_default,
  TweenCollection: () => TweenCollection_default,
  UniformState: () => UniformState_default,
  UniformType: () => UniformType_default,
  UrlTemplateImageryProvider: () => UrlTemplateImageryProvider_default,
  VERSION: () => VERSION,
  VRButton: () => VRButton_default,
  VRButtonViewModel: () => VRButtonViewModel_default,
  VRTheWorldTerrainProvider: () => VRTheWorldTerrainProvider_default,
  VaryingType: () => VaryingType_default,
  Vector3DTileBatch: () => Vector3DTileBatch_default,
  Vector3DTileClampedPolylines: () => Vector3DTileClampedPolylines_default,
  Vector3DTileContent: () => Vector3DTileContent_default,
  Vector3DTileGeometry: () => Vector3DTileGeometry_default,
  Vector3DTilePoints: () => Vector3DTilePoints_default,
  Vector3DTilePolygons: () => Vector3DTilePolygons_default,
  Vector3DTilePolylines: () => Vector3DTilePolylines_default,
  Vector3DTilePrimitive: () => Vector3DTilePrimitive_default,
  VelocityOrientationProperty: () => VelocityOrientationProperty_default,
  VelocityVectorProperty: () => VelocityVectorProperty_default,
  VertexArray: () => VertexArray_default,
  VertexArrayFacade: () => VertexArrayFacade_default,
  VertexAttributeSemantic: () => VertexAttributeSemantic_default,
  VertexFormat: () => VertexFormat_default,
  VerticalOrigin: () => VerticalOrigin_default,
  VideoSynchronizer: () => VideoSynchronizer_default,
  View: () => View_default,
  Viewer: () => Viewer_default,
  ViewportQuad: () => ViewportQuad_default,
  Visibility: () => Visibility_default,
  Visualizer: () => Visualizer_default,
  VulkanConstants: () => VulkanConstants_default,
  WallGeometry: () => WallGeometry_default,
  WallGeometryLibrary: () => WallGeometryLibrary_default,
  WallGeometryUpdater: () => WallGeometryUpdater_default,
  WallGraphics: () => WallGraphics_default,
  WallOutlineGeometry: () => WallOutlineGeometry_default,
  WebGLConstants: () => WebGLConstants_default,
  WebMapServiceImageryProvider: () => WebMapServiceImageryProvider_default,
  WebMapTileServiceImageryProvider: () => WebMapTileServiceImageryProvider_default,
  WebMercatorProjection: () => WebMercatorProjection_default,
  WebMercatorTilingScheme: () => WebMercatorTilingScheme_default,
  WindingOrder: () => WindingOrder_default,
  WireframeIndexGenerator: () => WireframeIndexGenerator_default,
  WireframePipelineStage: () => WireframePipelineStage_default,
  _shadersAcesTonemappingStage: () => AcesTonemappingStage_default,
  _shadersAdditiveBlend: () => AdditiveBlend_default,
  _shadersAdjustTranslucentFS: () => AdjustTranslucentFS_default,
  _shadersAllMaterialAppearanceFS: () => AllMaterialAppearanceFS_default,
  _shadersAllMaterialAppearanceVS: () => AllMaterialAppearanceVS_default,
  _shadersAmbientOcclusionGenerate: () => AmbientOcclusionGenerate_default,
  _shadersAmbientOcclusionModulate: () => AmbientOcclusionModulate_default,
  _shadersAspectRampMaterial: () => AspectRampMaterial_default,
  _shadersAtmosphereCommon: () => AtmosphereCommon_default,
  _shadersBasicMaterialAppearanceFS: () => BasicMaterialAppearanceFS_default,
  _shadersBasicMaterialAppearanceVS: () => BasicMaterialAppearanceVS_default,
  _shadersBillboardCollectionFS: () => BillboardCollectionFS_default,
  _shadersBillboardCollectionVS: () => BillboardCollectionVS_default,
  _shadersBlackAndWhite: () => BlackAndWhite_default,
  _shadersBloomComposite: () => BloomComposite_default,
  _shadersBrdfLutGeneratorFS: () => BrdfLutGeneratorFS_default,
  _shadersBrightPass: () => BrightPass_default,
  _shadersBrightness: () => Brightness_default,
  _shadersBumpMapMaterial: () => BumpMapMaterial_default,
  _shadersCPUStylingStageFS: () => CPUStylingStageFS_default,
  _shadersCPUStylingStageVS: () => CPUStylingStageVS_default,
  _shadersCheckerboardMaterial: () => CheckerboardMaterial_default,
  _shadersCloudCollectionFS: () => CloudCollectionFS_default,
  _shadersCloudCollectionVS: () => CloudCollectionVS_default,
  _shadersCloudNoiseFS: () => CloudNoiseFS_default,
  _shadersCloudNoiseVS: () => CloudNoiseVS_default,
  _shadersCompareAndPackTranslucentDepth: () => CompareAndPackTranslucentDepth_default,
  _shadersCompositeOITFS: () => CompositeOITFS_default,
  _shadersCompositeTranslucentClassification: () => CompositeTranslucentClassification_default,
  _shadersContrastBias: () => ContrastBias_default,
  _shadersCustomShaderStageFS: () => CustomShaderStageFS_default,
  _shadersCustomShaderStageVS: () => CustomShaderStageVS_default,
  _shadersCzmBuiltins: () => CzmBuiltins_default,
  _shadersDepthOfField: () => DepthOfField_default,
  _shadersDepthPlaneFS: () => DepthPlaneFS_default,
  _shadersDepthPlaneVS: () => DepthPlaneVS_default,
  _shadersDepthView: () => DepthView_default,
  _shadersDepthViewPacked: () => DepthViewPacked_default,
  _shadersDotMaterial: () => DotMaterial_default,
  _shadersEdgeDetection: () => EdgeDetection_default,
  _shadersElevationBandMaterial: () => ElevationBandMaterial_default,
  _shadersElevationContourMaterial: () => ElevationContourMaterial_default,
  _shadersElevationRampMaterial: () => ElevationRampMaterial_default,
  _shadersEllipsoidFS: () => EllipsoidFS_default,
  _shadersEllipsoidSurfaceAppearanceFS: () => EllipsoidSurfaceAppearanceFS_default,
  _shadersEllipsoidSurfaceAppearanceVS: () => EllipsoidSurfaceAppearanceVS_default,
  _shadersEllipsoidVS: () => EllipsoidVS_default,
  _shadersFXAA: () => FXAA_default,
  _shadersFXAA3_11: () => FXAA3_11_default,
  _shadersFadeMaterial: () => FadeMaterial_default,
  _shadersFeatureIdStageFS: () => FeatureIdStageFS_default,
  _shadersFeatureIdStageVS: () => FeatureIdStageVS_default,
  _shadersFilmicTonemapping: () => FilmicTonemapping_default,
  _shadersGaussianBlur1D: () => GaussianBlur1D_default,
  _shadersGeometryStageFS: () => GeometryStageFS_default,
  _shadersGeometryStageVS: () => GeometryStageVS_default,
  _shadersGlobeFS: () => GlobeFS_default,
  _shadersGlobeVS: () => GlobeVS_default,
  _shadersGridMaterial: () => GridMaterial_default,
  _shadersGroundAtmosphere: () => GroundAtmosphere_default,
  _shadersHSBToRGB: () => HSBToRGB_default,
  _shadersHSLToRGB: () => HSLToRGB_default,
  _shadersImageBasedLightingStageFS: () => ImageBasedLightingStageFS_default,
  _shadersInstancingStageCommon: () => InstancingStageCommon_default,
  _shadersInstancingStageVS: () => InstancingStageVS_default,
  _shadersLegacyInstancingStageVS: () => LegacyInstancingStageVS_default,
  _shadersLensFlare: () => LensFlare_default,
  _shadersLightingStageFS: () => LightingStageFS_default,
  _shadersMaterialStageFS: () => MaterialStageFS_default,
  _shadersMetadataStageFS: () => MetadataStageFS_default,
  _shadersMetadataStageVS: () => MetadataStageVS_default,
  _shadersModelClippingPlanesStageFS: () => ModelClippingPlanesStageFS_default,
  _shadersModelColorStageFS: () => ModelColorStageFS_default,
  _shadersModelFS: () => ModelFS_default,
  _shadersModelSilhouetteStageFS: () => ModelSilhouetteStageFS_default,
  _shadersModelSilhouetteStageVS: () => ModelSilhouetteStageVS_default,
  _shadersModelSplitterStageFS: () => ModelSplitterStageFS_default,
  _shadersModelVS: () => ModelVS_default,
  _shadersModifiedReinhardTonemapping: () => ModifiedReinhardTonemapping_default,
  _shadersMorphTargetsStageVS: () => MorphTargetsStageVS_default,
  _shadersNightVision: () => NightVision_default,
  _shadersNormalMapMaterial: () => NormalMapMaterial_default,
  _shadersOctahedralProjectionAtlasFS: () => OctahedralProjectionAtlasFS_default,
  _shadersOctahedralProjectionFS: () => OctahedralProjectionFS_default,
  _shadersOctahedralProjectionVS: () => OctahedralProjectionVS_default,
  _shadersPassThrough: () => PassThrough_default,
  _shadersPassThroughDepth: () => PassThroughDepth_default,
  _shadersPerInstanceColorAppearanceFS: () => PerInstanceColorAppearanceFS_default,
  _shadersPerInstanceColorAppearanceVS: () => PerInstanceColorAppearanceVS_default,
  _shadersPerInstanceFlatColorAppearanceFS: () => PerInstanceFlatColorAppearanceFS_default,
  _shadersPerInstanceFlatColorAppearanceVS: () => PerInstanceFlatColorAppearanceVS_default,
  _shadersPointCloudEyeDomeLighting: () => PointCloudEyeDomeLighting_default,
  _shadersPointCloudStylingStageVS: () => PointCloudStylingStageVS_default,
  _shadersPointPrimitiveCollectionFS: () => PointPrimitiveCollectionFS_default,
  _shadersPointPrimitiveCollectionVS: () => PointPrimitiveCollectionVS_default,
  _shadersPolylineArrowMaterial: () => PolylineArrowMaterial_default,
  _shadersPolylineColorAppearanceVS: () => PolylineColorAppearanceVS_default,
  _shadersPolylineCommon: () => PolylineCommon_default,
  _shadersPolylineDashMaterial: () => PolylineDashMaterial_default,
  _shadersPolylineFS: () => PolylineFS_default,
  _shadersPolylineGlowMaterial: () => PolylineGlowMaterial_default,
  _shadersPolylineMaterialAppearanceVS: () => PolylineMaterialAppearanceVS_default,
  _shadersPolylineOutlineMaterial: () => PolylineOutlineMaterial_default,
  _shadersPolylineShadowVolumeFS: () => PolylineShadowVolumeFS_default,
  _shadersPolylineShadowVolumeMorphFS: () => PolylineShadowVolumeMorphFS_default,
  _shadersPolylineShadowVolumeMorphVS: () => PolylineShadowVolumeMorphVS_default,
  _shadersPolylineShadowVolumeVS: () => PolylineShadowVolumeVS_default,
  _shadersPolylineVS: () => PolylineVS_default,
  _shadersPrimitiveOutlineStageFS: () => PrimitiveOutlineStageFS_default,
  _shadersPrimitiveOutlineStageVS: () => PrimitiveOutlineStageVS_default,
  _shadersRGBToHSB: () => RGBToHSB_default,
  _shadersRGBToHSL: () => RGBToHSL_default,
  _shadersRGBToXYZ: () => RGBToXYZ_default,
  _shadersReinhardTonemapping: () => ReinhardTonemapping_default,
  _shadersReprojectWebMercatorFS: () => ReprojectWebMercatorFS_default,
  _shadersReprojectWebMercatorVS: () => ReprojectWebMercatorVS_default,
  _shadersRimLightingMaterial: () => RimLightingMaterial_default,
  _shadersSelectedFeatureIdStageCommon: () => SelectedFeatureIdStageCommon_default,
  _shadersShadowVolumeAppearanceFS: () => ShadowVolumeAppearanceFS_default,
  _shadersShadowVolumeAppearanceVS: () => ShadowVolumeAppearanceVS_default,
  _shadersShadowVolumeFS: () => ShadowVolumeFS_default,
  _shadersSilhouette: () => Silhouette_default,
  _shadersSkinningStageVS: () => SkinningStageVS_default,
  _shadersSkyAtmosphereCommon: () => SkyAtmosphereCommon_default,
  _shadersSkyAtmosphereFS: () => SkyAtmosphereFS_default,
  _shadersSkyAtmosphereVS: () => SkyAtmosphereVS_default,
  _shadersSkyBoxFS: () => SkyBoxFS_default,
  _shadersSkyBoxVS: () => SkyBoxVS_default,
  _shadersSlopeRampMaterial: () => SlopeRampMaterial_default,
  _shadersStripeMaterial: () => StripeMaterial_default,
  _shadersSunFS: () => SunFS_default,
  _shadersSunTextureFS: () => SunTextureFS_default,
  _shadersSunVS: () => SunVS_default,
  _shadersTexturedMaterialAppearanceFS: () => TexturedMaterialAppearanceFS_default,
  _shadersTexturedMaterialAppearanceVS: () => TexturedMaterialAppearanceVS_default,
  _shadersVector3DTileClampedPolylinesFS: () => Vector3DTileClampedPolylinesFS_default,
  _shadersVector3DTileClampedPolylinesVS: () => Vector3DTileClampedPolylinesVS_default,
  _shadersVector3DTilePolylinesVS: () => Vector3DTilePolylinesVS_default,
  _shadersVectorTileVS: () => VectorTileVS_default,
  _shadersViewportQuadFS: () => ViewportQuadFS_default,
  _shadersViewportQuadVS: () => ViewportQuadVS_default,
  _shadersWater: () => Water_default,
  _shadersXYZToRGB: () => XYZToRGB_default,
  _shadersacesTonemapping: () => acesTonemapping_default,
  _shadersalphaWeight: () => alphaWeight_default,
  _shadersantialias: () => antialias_default,
  _shadersapproximateSphericalCoordinates: () => approximateSphericalCoordinates_default,
  _shadersbackFacing: () => backFacing_default,
  _shadersbranchFreeTernary: () => branchFreeTernary_default,
  _shaderscascadeColor: () => cascadeColor_default,
  _shaderscascadeDistance: () => cascadeDistance_default,
  _shaderscascadeMatrix: () => cascadeMatrix_default,
  _shaderscascadeWeights: () => cascadeWeights_default,
  _shaderscolumbusViewMorph: () => columbusViewMorph_default,
  _shaderscomputePosition: () => computePosition_default,
  _shaderscosineAndSine: () => cosineAndSine_default,
  _shadersdecompressTextureCoordinates: () => decompressTextureCoordinates_default,
  _shadersdefaultPbrMaterial: () => defaultPbrMaterial_default,
  _shadersdegreesPerRadian: () => degreesPerRadian_default,
  _shadersdepthClamp: () => depthClamp_default,
  _shadersdepthRange: () => depthRange_default,
  _shadersdepthRangeStruct: () => depthRangeStruct_default,
  _shaderseastNorthUpToEyeCoordinates: () => eastNorthUpToEyeCoordinates_default,
  _shadersellipsoidContainsPoint: () => ellipsoidContainsPoint_default,
  _shadersellipsoidWgs84TextureCoordinates: () => ellipsoidWgs84TextureCoordinates_default,
  _shadersepsilon1: () => epsilon1_default,
  _shadersepsilon2: () => epsilon2_default,
  _shadersepsilon3: () => epsilon3_default,
  _shadersepsilon4: () => epsilon4_default,
  _shadersepsilon5: () => epsilon5_default,
  _shadersepsilon6: () => epsilon6_default,
  _shadersepsilon7: () => epsilon7_default,
  _shadersequalsEpsilon: () => equalsEpsilon_default,
  _shaderseyeOffset: () => eyeOffset_default,
  _shaderseyeToWindowCoordinates: () => eyeToWindowCoordinates_default,
  _shadersfastApproximateAtan: () => fastApproximateAtan_default,
  _shadersfog: () => fog_default,
  _shadersgammaCorrect: () => gammaCorrect_default,
  _shadersgeodeticSurfaceNormal: () => geodeticSurfaceNormal_default,
  _shadersgetDefaultMaterial: () => getDefaultMaterial_default,
  _shadersgetLambertDiffuse: () => getLambertDiffuse_default,
  _shadersgetSpecular: () => getSpecular_default,
  _shadersgetWaterNoise: () => getWaterNoise_default,
  _shadershue: () => hue_default,
  _shadersinfinity: () => infinity_default,
  _shadersinverseGamma: () => inverseGamma_default,
  _shadersisEmpty: () => isEmpty_default,
  _shadersisFull: () => isFull_default,
  _shaderslatitudeToWebMercatorFraction: () => latitudeToWebMercatorFraction_default,
  _shaderslineDistance: () => lineDistance_default,
  _shaderslinearToSrgb: () => linearToSrgb_default,
  _shadersluminance: () => luminance_default,
  _shadersmaterial: () => material_default,
  _shadersmaterialInput: () => materialInput_default,
  _shadersmetersPerPixel: () => metersPerPixel_default,
  _shadersmodelMaterial: () => modelMaterial_default,
  _shadersmodelToWindowCoordinates: () => modelToWindowCoordinates_default,
  _shadersmodelVertexOutput: () => modelVertexOutput_default,
  _shadersmultiplyWithColorBalance: () => multiplyWithColorBalance_default,
  _shadersnearFarScalar: () => nearFarScalar_default,
  _shadersoctDecode: () => octDecode_default,
  _shadersoneOverPi: () => oneOverPi_default,
  _shadersoneOverTwoPi: () => oneOverTwoPi_default,
  _shaderspackDepth: () => packDepth_default,
  _shaderspassCesium3DTile: () => passCesium3DTile_default,
  _shaderspassCesium3DTileClassification: () => passCesium3DTileClassification_default,
  _shaderspassCesium3DTileClassificationIgnoreShow: () => passCesium3DTileClassificationIgnoreShow_default,
  _shaderspassClassification: () => passClassification_default,
  _shaderspassCompute: () => passCompute_default,
  _shaderspassEnvironment: () => passEnvironment_default,
  _shaderspassGlobe: () => passGlobe_default,
  _shaderspassOpaque: () => passOpaque_default,
  _shaderspassOverlay: () => passOverlay_default,
  _shaderspassTerrainClassification: () => passTerrainClassification_default,
  _shaderspassTranslucent: () => passTranslucent_default,
  _shaderspbrLighting: () => pbrLighting_default,
  _shaderspbrMetallicRoughnessMaterial: () => pbrMetallicRoughnessMaterial_default,
  _shaderspbrParameters: () => pbrParameters_default,
  _shaderspbrSpecularGlossinessMaterial: () => pbrSpecularGlossinessMaterial_default,
  _shadersphong: () => phong_default,
  _shaderspi: () => pi_default,
  _shaderspiOverFour: () => piOverFour_default,
  _shaderspiOverSix: () => piOverSix_default,
  _shaderspiOverThree: () => piOverThree_default,
  _shaderspiOverTwo: () => piOverTwo_default,
  _shadersplaneDistance: () => planeDistance_default,
  _shaderspointAlongRay: () => pointAlongRay_default,
  _shadersradiansPerDegree: () => radiansPerDegree_default,
  _shadersray: () => ray_default,
  _shadersrayEllipsoidIntersectionInterval: () => rayEllipsoidIntersectionInterval_default,
  _shadersraySegment: () => raySegment_default,
  _shadersraySphereIntersectionInterval: () => raySphereIntersectionInterval_default,
  _shadersreadDepth: () => readDepth_default,
  _shadersreadNonPerspective: () => readNonPerspective_default,
  _shadersreverseLogDepth: () => reverseLogDepth_default,
  _shadersround: () => round_default,
  _shaderssampleOctahedralProjection: () => sampleOctahedralProjection_default,
  _shaderssaturation: () => saturation_default,
  _shaderssceneMode2D: () => sceneMode2D_default,
  _shaderssceneMode3D: () => sceneMode3D_default,
  _shaderssceneModeColumbusView: () => sceneModeColumbusView_default,
  _shaderssceneModeMorphing: () => sceneModeMorphing_default,
  _shadersshadowDepthCompare: () => shadowDepthCompare_default,
  _shadersshadowParameters: () => shadowParameters_default,
  _shadersshadowVisibility: () => shadowVisibility_default,
  _shaderssignNotZero: () => signNotZero_default,
  _shaderssolarRadius: () => solarRadius_default,
  _shaderssphericalHarmonics: () => sphericalHarmonics_default,
  _shaderssrgbToLinear: () => srgbToLinear_default,
  _shaderstangentToEyeSpaceMatrix: () => tangentToEyeSpaceMatrix_default,
  _shadersthreePiOver2: () => threePiOver2_default,
  _shaderstransformPlane: () => transformPlane_default,
  _shaderstranslateRelativeToEye: () => translateRelativeToEye_default,
  _shaderstranslucentPhong: () => translucentPhong_default,
  _shaderstranspose: () => transpose_default,
  _shaderstwoPi: () => twoPi_default,
  _shadersunpackDepth: () => unpackDepth_default,
  _shadersunpackFloat: () => unpackFloat_default,
  _shadersunpackUint: () => unpackUint_default,
  _shadersvalueTransform: () => valueTransform_default,
  _shadersvertexLogDepth: () => vertexLogDepth_default,
  _shaderswebMercatorMaxLatitude: () => webMercatorMaxLatitude_default,
  _shaderswindowToEyeCoordinates: () => windowToEyeCoordinates_default,
  _shaderswriteDepthClamp: () => writeDepthClamp_default,
  _shaderswriteLogDepth: () => writeLogDepth_default,
  _shaderswriteNonPerspective: () => writeNonPerspective_default,
  addBuffer: () => addBuffer_default,
  addDefaults: () => addDefaults_default,
  addExtensionsRequired: () => addExtensionsRequired_default,
  addExtensionsUsed: () => addExtensionsUsed_default,
  addPipelineExtras: () => addPipelineExtras_default,
  addToArray: () => addToArray_default,
  appendForwardSlash: () => appendForwardSlash_default,
  arrayRemoveDuplicates: () => arrayRemoveDuplicates_default,
  barycentricCoordinates: () => barycentricCoordinates_default,
  binarySearch: () => binarySearch_default,
  buildDrawCommand: () => buildDrawCommand_default,
  buildModuleUrl: () => buildModuleUrl_default,
  cancelAnimationFrame: () => cancelAnimationFrame_default,
  clone: () => clone_default,
  combine: () => combine_default,
  computeFlyToLocationForRectangle: () => computeFlyToLocationForRectangle_default,
  createBillboardPointCallback: () => createBillboardPointCallback_default,
  createCommand: () => createCommand_default,
  createDefaultImageryProviderViewModels: () => createDefaultImageryProviderViewModels_default,
  createDefaultTerrainProviderViewModels: () => createDefaultTerrainProviderViewModels_default,
  createElevationBandMaterial: () => createElevationBandMaterial_default,
  createGuid: () => createGuid_default,
  createMaterialPropertyDescriptor: () => createMaterialPropertyDescriptor_default,
  createOsmBuildings: () => createOsmBuildings_default,
  createPropertyDescriptor: () => createPropertyDescriptor_default,
  createRawPropertyDescriptor: () => createRawPropertyDescriptor_default,
  createTangentSpaceDebugPrimitive: () => createTangentSpaceDebugPrimitive_default,
  createTaskProcessorWorker: () => createTaskProcessorWorker_default,
  createUniform: () => createUniform_default,
  createUniformArray: () => createUniformArray_default,
  createWorldImagery: () => createWorldImagery_default,
  createWorldTerrain: () => createWorldTerrain_default,
  decodeGoogleEarthEnterpriseData: () => decodeGoogleEarthEnterpriseData_default,
  decodeVectorPolylinePositions: () => decodeVectorPolylinePositions_default,
  defaultValue: () => defaultValue_default,
  defer: () => defer_default,
  defined: () => defined_default,
  deprecationWarning: () => deprecationWarning_default,
  destroyObject: () => destroyObject_default,
  exportKml: () => exportKml_default,
  findAccessorMinMax: () => findAccessorMinMax_default,
  findContentMetadata: () => findContentMetadata_default,
  findGroupMetadata: () => findGroupMetadata_default,
  findTileMetadata: () => findTileMetadata_default,
  forEachTextureInMaterial: () => forEachTextureInMaterial_default,
  formatError: () => formatError_default,
  freezeRenderState: () => freezeRenderState_default,
  getAbsoluteUri: () => getAbsoluteUri_default,
  getAccessorByteStride: () => getAccessorByteStride_default,
  getBaseUri: () => getBaseUri_default,
  getBinaryAccessor: () => getBinaryAccessor_default,
  getClipAndStyleCode: () => getClipAndStyleCode_default,
  getClippingFunction: () => getClippingFunction_default,
  getComponentReader: () => getComponentReader_default,
  getElement: () => getElement_default,
  getExtensionFromUri: () => getExtensionFromUri_default,
  getFilenameFromUri: () => getFilenameFromUri_default,
  getImageFromTypedArray: () => getImageFromTypedArray_default,
  getImagePixels: () => getImagePixels_default,
  getJsonFromTypedArray: () => getJsonFromTypedArray_default,
  getMagic: () => getMagic_default,
  getStringFromTypedArray: () => getStringFromTypedArray_default,
  getTimestamp: () => getTimestamp_default,
  hasExtension: () => hasExtension_default,
  heightReferenceOnEntityPropertyChanged: () => heightReferenceOnEntityPropertyChanged_default,
  isBitSet: () => isBitSet_default,
  isBlobUri: () => isBlobUri_default,
  isCrossOriginUrl: () => isCrossOriginUrl_default,
  isDataUri: () => isDataUri_default,
  isLeapYear: () => isLeapYear_default,
  knockout: () => knockout_default,
  knockout_3_5_1: () => knockout_3_5_1_default,
  knockout_es5: () => knockout_es5_default,
  loadAndExecuteScript: () => loadAndExecuteScript_default,
  loadCubeMap: () => loadCubeMap_default,
  loadImageFromTypedArray: () => loadImageFromTypedArray_default,
  loadKTX2: () => loadKTX2_default,
  mergeSort: () => mergeSort_default,
  modernizeShader: () => modernizeShader_default,
  moveTechniqueRenderStates: () => moveTechniqueRenderStates_default,
  moveTechniquesToExtension: () => moveTechniquesToExtension_default,
  numberOfComponentsForType: () => numberOfComponentsForType_default,
  objectToQuery: () => objectToQuery_default,
  oneTimeWarning: () => oneTimeWarning_default,
  parseBatchTable: () => parseBatchTable_default,
  parseBoundingVolumeSemantics: () => parseBoundingVolumeSemantics_default,
  parseFeatureMetadataLegacy: () => parseFeatureMetadataLegacy_default,
  parseGlb: () => parseGlb_default,
  parseResponseHeaders: () => parseResponseHeaders_default,
  parseStructuralMetadata: () => parseStructuralMetadata_default,
  pointInsideTriangle: () => pointInsideTriangle_default,
  preprocess3DTileContent: () => preprocess3DTileContent_default,
  queryToObject: () => queryToObject_default,
  readAccessorPacked: () => readAccessorPacked_default,
  removeExtension: () => removeExtension_default,
  removeExtensionsRequired: () => removeExtensionsRequired_default,
  removeExtensionsUsed: () => removeExtensionsUsed_default,
  removePipelineExtras: () => removePipelineExtras_default,
  removeUnusedElements: () => removeUnusedElements_default,
  requestAnimationFrame: () => requestAnimationFrame_default,
  resizeImageToNextPowerOfTwo: () => resizeImageToNextPowerOfTwo_default,
  sampleTerrain: () => sampleTerrain_default,
  sampleTerrainMostDetailed: () => sampleTerrainMostDetailed_default,
  scaleToGeodeticSurface: () => scaleToGeodeticSurface_default,
  subdivideArray: () => subdivideArray_default,
  subscribeAndEvaluate: () => subscribeAndEvaluate_default,
  updateAccessorComponentTypes: () => updateAccessorComponentTypes_default,
  updateVersion: () => updateVersion_default,
  usesExtension: () => usesExtension_default,
  viewerCesium3DTilesInspectorMixin: () => viewerCesium3DTilesInspectorMixin_default,
  viewerCesiumInspectorMixin: () => viewerCesiumInspectorMixin_default,
  viewerDragDropMixin: () => viewerDragDropMixin_default,
  viewerPerformanceWatchdogMixin: () => viewerPerformanceWatchdogMixin_default,
  webGLConstantToGlslType: () => webGLConstantToGlslType_default,
  wrapFunction: () => wrapFunction_default,
  writeTextToCanvas: () => writeTextToCanvas_default
});
module.exports = __toCommonJS(Cesium_exports);

// Source/Core/defined.js
function defined(value) {
  return value !== void 0 && value !== null;
}
var defined_default = defined;

// Source/Core/DeveloperError.js
function DeveloperError(message) {
  this.name = "DeveloperError";
  this.message = message;
  let stack;
  try {
    throw new Error();
  } catch (e) {
    stack = e.stack;
  }
  this.stack = stack;
}
if (defined_default(Object.create)) {
  DeveloperError.prototype = Object.create(Error.prototype);
  DeveloperError.prototype.constructor = DeveloperError;
}
DeveloperError.prototype.toString = function() {
  let str = `${this.name}: ${this.message}`;
  if (defined_default(this.stack)) {
    str += `
${this.stack.toString()}`;
  }
  return str;
};
DeveloperError.throwInstantiationError = function() {
  throw new DeveloperError(
    "This function defines an interface and should not be called directly."
  );
};
var DeveloperError_default = DeveloperError;

// Source/Core/Check.js
var Check = {};
Check.typeOf = {};
function getUndefinedErrorMessage(name) {
  return `${name} is required, actual value was undefined`;
}
function getFailedTypeErrorMessage(actual, expected, name) {
  return `Expected ${name} to be typeof ${expected}, actual typeof was ${actual}`;
}
Check.defined = function(name, test) {
  if (!defined_default(test)) {
    throw new DeveloperError_default(getUndefinedErrorMessage(name));
  }
};
Check.typeOf.func = function(name, test) {
  if (typeof test !== "function") {
    throw new DeveloperError_default(
      getFailedTypeErrorMessage(typeof test, "function", name)
    );
  }
};
Check.typeOf.string = function(name, test) {
  if (typeof test !== "string") {
    throw new DeveloperError_default(
      getFailedTypeErrorMessage(typeof test, "string", name)
    );
  }
};
Check.typeOf.number = function(name, test) {
  if (typeof test !== "number") {
    throw new DeveloperError_default(
      getFailedTypeErrorMessage(typeof test, "number", name)
    );
  }
};
Check.typeOf.number.lessThan = function(name, test, limit) {
  Check.typeOf.number(name, test);
  if (test >= limit) {
    throw new DeveloperError_default(
      `Expected ${name} to be less than ${limit}, actual value was ${test}`
    );
  }
};
Check.typeOf.number.lessThanOrEquals = function(name, test, limit) {
  Check.typeOf.number(name, test);
  if (test > limit) {
    throw new DeveloperError_default(
      `Expected ${name} to be less than or equal to ${limit}, actual value was ${test}`
    );
  }
};
Check.typeOf.number.greaterThan = function(name, test, limit) {
  Check.typeOf.number(name, test);
  if (test <= limit) {
    throw new DeveloperError_default(
      `Expected ${name} to be greater than ${limit}, actual value was ${test}`
    );
  }
};
Check.typeOf.number.greaterThanOrEquals = function(name, test, limit) {
  Check.typeOf.number(name, test);
  if (test < limit) {
    throw new DeveloperError_default(
      `Expected ${name} to be greater than or equal to ${limit}, actual value was ${test}`
    );
  }
};
Check.typeOf.object = function(name, test) {
  if (typeof test !== "object") {
    throw new DeveloperError_default(
      getFailedTypeErrorMessage(typeof test, "object", name)
    );
  }
};
Check.typeOf.bool = function(name, test) {
  if (typeof test !== "boolean") {
    throw new DeveloperError_default(
      getFailedTypeErrorMessage(typeof test, "boolean", name)
    );
  }
};
Check.typeOf.bigint = function(name, test) {
  if (typeof test !== "bigint") {
    throw new DeveloperError_default(
      getFailedTypeErrorMessage(typeof test, "bigint", name)
    );
  }
};
Check.typeOf.number.equals = function(name1, name2, test1, test2) {
  Check.typeOf.number(name1, test1);
  Check.typeOf.number(name2, test2);
  if (test1 !== test2) {
    throw new DeveloperError_default(
      `${name1} must be equal to ${name2}, the actual values are ${test1} and ${test2}`
    );
  }
};
var Check_default = Check;

// Source/Core/defaultValue.js
function defaultValue(a3, b) {
  if (a3 !== void 0 && a3 !== null) {
    return a3;
  }
  return b;
}
defaultValue.EMPTY_OBJECT = Object.freeze({});
var defaultValue_default = defaultValue;

// Source/Core/Math.js
var import_mersenne_twister = __toESM(require_mersenne_twister(), 1);
var CesiumMath = {};
CesiumMath.EPSILON1 = 0.1;
CesiumMath.EPSILON2 = 0.01;
CesiumMath.EPSILON3 = 1e-3;
CesiumMath.EPSILON4 = 1e-4;
CesiumMath.EPSILON5 = 1e-5;
CesiumMath.EPSILON6 = 1e-6;
CesiumMath.EPSILON7 = 1e-7;
CesiumMath.EPSILON8 = 1e-8;
CesiumMath.EPSILON9 = 1e-9;
CesiumMath.EPSILON10 = 1e-10;
CesiumMath.EPSILON11 = 1e-11;
CesiumMath.EPSILON12 = 1e-12;
CesiumMath.EPSILON13 = 1e-13;
CesiumMath.EPSILON14 = 1e-14;
CesiumMath.EPSILON15 = 1e-15;
CesiumMath.EPSILON16 = 1e-16;
CesiumMath.EPSILON17 = 1e-17;
CesiumMath.EPSILON18 = 1e-18;
CesiumMath.EPSILON19 = 1e-19;
CesiumMath.EPSILON20 = 1e-20;
CesiumMath.EPSILON21 = 1e-21;
CesiumMath.GRAVITATIONALPARAMETER = 3986004418e5;
CesiumMath.SOLAR_RADIUS = 6955e5;
CesiumMath.LUNAR_RADIUS = 1737400;
CesiumMath.SIXTY_FOUR_KILOBYTES = 64 * 1024;
CesiumMath.FOUR_GIGABYTES = 4 * 1024 * 1024 * 1024;
CesiumMath.sign = defaultValue_default(Math.sign, function sign(value) {
  value = +value;
  if (value === 0 || value !== value) {
    return value;
  }
  return value > 0 ? 1 : -1;
});
CesiumMath.signNotZero = function(value) {
  return value < 0 ? -1 : 1;
};
CesiumMath.toSNorm = function(value, rangeMaximum) {
  rangeMaximum = defaultValue_default(rangeMaximum, 255);
  return Math.round(
    (CesiumMath.clamp(value, -1, 1) * 0.5 + 0.5) * rangeMaximum
  );
};
CesiumMath.fromSNorm = function(value, rangeMaximum) {
  rangeMaximum = defaultValue_default(rangeMaximum, 255);
  return CesiumMath.clamp(value, 0, rangeMaximum) / rangeMaximum * 2 - 1;
};
CesiumMath.normalize = function(value, rangeMinimum, rangeMaximum) {
  rangeMaximum = Math.max(rangeMaximum - rangeMinimum, 0);
  return rangeMaximum === 0 ? 0 : CesiumMath.clamp((value - rangeMinimum) / rangeMaximum, 0, 1);
};
CesiumMath.sinh = defaultValue_default(Math.sinh, function sinh(value) {
  return (Math.exp(value) - Math.exp(-value)) / 2;
});
CesiumMath.cosh = defaultValue_default(Math.cosh, function cosh(value) {
  return (Math.exp(value) + Math.exp(-value)) / 2;
});
CesiumMath.lerp = function(p, q, time) {
  return (1 - time) * p + time * q;
};
CesiumMath.PI = Math.PI;
CesiumMath.ONE_OVER_PI = 1 / Math.PI;
CesiumMath.PI_OVER_TWO = Math.PI / 2;
CesiumMath.PI_OVER_THREE = Math.PI / 3;
CesiumMath.PI_OVER_FOUR = Math.PI / 4;
CesiumMath.PI_OVER_SIX = Math.PI / 6;
CesiumMath.THREE_PI_OVER_TWO = 3 * Math.PI / 2;
CesiumMath.TWO_PI = 2 * Math.PI;
CesiumMath.ONE_OVER_TWO_PI = 1 / (2 * Math.PI);
CesiumMath.RADIANS_PER_DEGREE = Math.PI / 180;
CesiumMath.DEGREES_PER_RADIAN = 180 / Math.PI;
CesiumMath.RADIANS_PER_ARCSECOND = CesiumMath.RADIANS_PER_DEGREE / 3600;
CesiumMath.toRadians = function(degrees) {
  if (!defined_default(degrees)) {
    throw new DeveloperError_default("degrees is required.");
  }
  return degrees * CesiumMath.RADIANS_PER_DEGREE;
};
CesiumMath.toDegrees = function(radians) {
  if (!defined_default(radians)) {
    throw new DeveloperError_default("radians is required.");
  }
  return radians * CesiumMath.DEGREES_PER_RADIAN;
};
CesiumMath.convertLongitudeRange = function(angle) {
  if (!defined_default(angle)) {
    throw new DeveloperError_default("angle is required.");
  }
  const twoPi = CesiumMath.TWO_PI;
  const simplified = angle - Math.floor(angle / twoPi) * twoPi;
  if (simplified < -Math.PI) {
    return simplified + twoPi;
  }
  if (simplified >= Math.PI) {
    return simplified - twoPi;
  }
  return simplified;
};
CesiumMath.clampToLatitudeRange = function(angle) {
  if (!defined_default(angle)) {
    throw new DeveloperError_default("angle is required.");
  }
  return CesiumMath.clamp(
    angle,
    -1 * CesiumMath.PI_OVER_TWO,
    CesiumMath.PI_OVER_TWO
  );
};
CesiumMath.negativePiToPi = function(angle) {
  if (!defined_default(angle)) {
    throw new DeveloperError_default("angle is required.");
  }
  if (angle >= -CesiumMath.PI && angle <= CesiumMath.PI) {
    return angle;
  }
  return CesiumMath.zeroToTwoPi(angle + CesiumMath.PI) - CesiumMath.PI;
};
CesiumMath.zeroToTwoPi = function(angle) {
  if (!defined_default(angle)) {
    throw new DeveloperError_default("angle is required.");
  }
  if (angle >= 0 && angle <= CesiumMath.TWO_PI) {
    return angle;
  }
  const mod2 = CesiumMath.mod(angle, CesiumMath.TWO_PI);
  if (Math.abs(mod2) < CesiumMath.EPSILON14 && Math.abs(angle) > CesiumMath.EPSILON14) {
    return CesiumMath.TWO_PI;
  }
  return mod2;
};
CesiumMath.mod = function(m, n) {
  if (!defined_default(m)) {
    throw new DeveloperError_default("m is required.");
  }
  if (!defined_default(n)) {
    throw new DeveloperError_default("n is required.");
  }
  if (n === 0) {
    throw new DeveloperError_default("divisor cannot be 0.");
  }
  if (CesiumMath.sign(m) === CesiumMath.sign(n) && Math.abs(m) < Math.abs(n)) {
    return m;
  }
  return (m % n + n) % n;
};
CesiumMath.equalsEpsilon = function(left, right, relativeEpsilon, absoluteEpsilon) {
  if (!defined_default(left)) {
    throw new DeveloperError_default("left is required.");
  }
  if (!defined_default(right)) {
    throw new DeveloperError_default("right is required.");
  }
  relativeEpsilon = defaultValue_default(relativeEpsilon, 0);
  absoluteEpsilon = defaultValue_default(absoluteEpsilon, relativeEpsilon);
  const absDiff = Math.abs(left - right);
  return absDiff <= absoluteEpsilon || absDiff <= relativeEpsilon * Math.max(Math.abs(left), Math.abs(right));
};
CesiumMath.lessThan = function(left, right, absoluteEpsilon) {
  if (!defined_default(left)) {
    throw new DeveloperError_default("first is required.");
  }
  if (!defined_default(right)) {
    throw new DeveloperError_default("second is required.");
  }
  if (!defined_default(absoluteEpsilon)) {
    throw new DeveloperError_default("absoluteEpsilon is required.");
  }
  return left - right < -absoluteEpsilon;
};
CesiumMath.lessThanOrEquals = function(left, right, absoluteEpsilon) {
  if (!defined_default(left)) {
    throw new DeveloperError_default("first is required.");
  }
  if (!defined_default(right)) {
    throw new DeveloperError_default("second is required.");
  }
  if (!defined_default(absoluteEpsilon)) {
    throw new DeveloperError_default("absoluteEpsilon is required.");
  }
  return left - right < absoluteEpsilon;
};
CesiumMath.greaterThan = function(left, right, absoluteEpsilon) {
  if (!defined_default(left)) {
    throw new DeveloperError_default("first is required.");
  }
  if (!defined_default(right)) {
    throw new DeveloperError_default("second is required.");
  }
  if (!defined_default(absoluteEpsilon)) {
    throw new DeveloperError_default("absoluteEpsilon is required.");
  }
  return left - right > absoluteEpsilon;
};
CesiumMath.greaterThanOrEquals = function(left, right, absoluteEpsilon) {
  if (!defined_default(left)) {
    throw new DeveloperError_default("first is required.");
  }
  if (!defined_default(right)) {
    throw new DeveloperError_default("second is required.");
  }
  if (!defined_default(absoluteEpsilon)) {
    throw new DeveloperError_default("absoluteEpsilon is required.");
  }
  return left - right > -absoluteEpsilon;
};
var factorials = [1];
CesiumMath.factorial = function(n) {
  if (typeof n !== "number" || n < 0) {
    throw new DeveloperError_default(
      "A number greater than or equal to 0 is required."
    );
  }
  const length3 = factorials.length;
  if (n >= length3) {
    let sum = factorials[length3 - 1];
    for (let i = length3; i <= n; i++) {
      const next = sum * i;
      factorials.push(next);
      sum = next;
    }
  }
  return factorials[n];
};
CesiumMath.incrementWrap = function(n, maximumValue, minimumValue) {
  minimumValue = defaultValue_default(minimumValue, 0);
  if (!defined_default(n)) {
    throw new DeveloperError_default("n is required.");
  }
  if (maximumValue <= minimumValue) {
    throw new DeveloperError_default("maximumValue must be greater than minimumValue.");
  }
  ++n;
  if (n > maximumValue) {
    n = minimumValue;
  }
  return n;
};
CesiumMath.isPowerOfTwo = function(n) {
  if (typeof n !== "number" || n < 0 || n > 4294967295) {
    throw new DeveloperError_default("A number between 0 and (2^32)-1 is required.");
  }
  return n !== 0 && (n & n - 1) === 0;
};
CesiumMath.nextPowerOfTwo = function(n) {
  if (typeof n !== "number" || n < 0 || n > 2147483648) {
    throw new DeveloperError_default("A number between 0 and 2^31 is required.");
  }
  --n;
  n |= n >> 1;
  n |= n >> 2;
  n |= n >> 4;
  n |= n >> 8;
  n |= n >> 16;
  ++n;
  return n;
};
CesiumMath.previousPowerOfTwo = function(n) {
  if (typeof n !== "number" || n < 0 || n > 4294967295) {
    throw new DeveloperError_default("A number between 0 and (2^32)-1 is required.");
  }
  n |= n >> 1;
  n |= n >> 2;
  n |= n >> 4;
  n |= n >> 8;
  n |= n >> 16;
  n |= n >> 32;
  n = (n >>> 0) - (n >>> 1);
  return n;
};
CesiumMath.clamp = function(value, min3, max3) {
  Check_default.typeOf.number("value", value);
  Check_default.typeOf.number("min", min3);
  Check_default.typeOf.number("max", max3);
  return value < min3 ? min3 : value > max3 ? max3 : value;
};
var randomNumberGenerator = new import_mersenne_twister.default();
CesiumMath.setRandomNumberSeed = function(seed) {
  if (!defined_default(seed)) {
    throw new DeveloperError_default("seed is required.");
  }
  randomNumberGenerator = new import_mersenne_twister.default(seed);
};
CesiumMath.nextRandomNumber = function() {
  return randomNumberGenerator.random();
};
CesiumMath.randomBetween = function(min3, max3) {
  return CesiumMath.nextRandomNumber() * (max3 - min3) + min3;
};
CesiumMath.acosClamped = function(value) {
  if (!defined_default(value)) {
    throw new DeveloperError_default("value is required.");
  }
  return Math.acos(CesiumMath.clamp(value, -1, 1));
};
CesiumMath.asinClamped = function(value) {
  if (!defined_default(value)) {
    throw new DeveloperError_default("value is required.");
  }
  return Math.asin(CesiumMath.clamp(value, -1, 1));
};
CesiumMath.chordLength = function(angle, radius) {
  if (!defined_default(angle)) {
    throw new DeveloperError_default("angle is required.");
  }
  if (!defined_default(radius)) {
    throw new DeveloperError_default("radius is required.");
  }
  return 2 * radius * Math.sin(angle * 0.5);
};
CesiumMath.logBase = function(number, base) {
  if (!defined_default(number)) {
    throw new DeveloperError_default("number is required.");
  }
  if (!defined_default(base)) {
    throw new DeveloperError_default("base is required.");
  }
  return Math.log(number) / Math.log(base);
};
CesiumMath.cbrt = defaultValue_default(Math.cbrt, function cbrt(number) {
  const result = Math.pow(Math.abs(number), 1 / 3);
  return number < 0 ? -result : result;
});
CesiumMath.log2 = defaultValue_default(Math.log2, function log2(number) {
  return Math.log(number) * Math.LOG2E;
});
CesiumMath.fog = function(distanceToCamera, density) {
  const scalar = distanceToCamera * density;
  return 1 - Math.exp(-(scalar * scalar));
};
CesiumMath.fastApproximateAtan = function(x) {
  Check_default.typeOf.number("x", x);
  return x * (-0.1784 * Math.abs(x) - 0.0663 * x * x + 1.0301);
};
CesiumMath.fastApproximateAtan2 = function(x, y) {
  Check_default.typeOf.number("x", x);
  Check_default.typeOf.number("y", y);
  let opposite;
  let t = Math.abs(x);
  opposite = Math.abs(y);
  const adjacent = Math.max(t, opposite);
  opposite = Math.min(t, opposite);
  const oppositeOverAdjacent = opposite / adjacent;
  if (isNaN(oppositeOverAdjacent)) {
    throw new DeveloperError_default("either x or y must be nonzero");
  }
  t = CesiumMath.fastApproximateAtan(oppositeOverAdjacent);
  t = Math.abs(y) > Math.abs(x) ? CesiumMath.PI_OVER_TWO - t : t;
  t = x < 0 ? CesiumMath.PI - t : t;
  t = y < 0 ? -t : t;
  return t;
};
var Math_default = CesiumMath;

// Source/Core/Cartesian3.js
function Cartesian3(x, y, z) {
  this.x = defaultValue_default(x, 0);
  this.y = defaultValue_default(y, 0);
  this.z = defaultValue_default(z, 0);
}
Cartesian3.fromSpherical = function(spherical, result) {
  Check_default.typeOf.object("spherical", spherical);
  if (!defined_default(result)) {
    result = new Cartesian3();
  }
  const clock = spherical.clock;
  const cone = spherical.cone;
  const magnitude = defaultValue_default(spherical.magnitude, 1);
  const radial = magnitude * Math.sin(cone);
  result.x = radial * Math.cos(clock);
  result.y = radial * Math.sin(clock);
  result.z = magnitude * Math.cos(cone);
  return result;
};
Cartesian3.fromElements = function(x, y, z, result) {
  if (!defined_default(result)) {
    return new Cartesian3(x, y, z);
  }
  result.x = x;
  result.y = y;
  result.z = z;
  return result;
};
Cartesian3.clone = function(cartesian11, result) {
  if (!defined_default(cartesian11)) {
    return void 0;
  }
  if (!defined_default(result)) {
    return new Cartesian3(cartesian11.x, cartesian11.y, cartesian11.z);
  }
  result.x = cartesian11.x;
  result.y = cartesian11.y;
  result.z = cartesian11.z;
  return result;
};
Cartesian3.fromCartesian4 = Cartesian3.clone;
Cartesian3.packedLength = 3;
Cartesian3.pack = function(value, array, startingIndex) {
  Check_default.typeOf.object("value", value);
  Check_default.defined("array", array);
  startingIndex = defaultValue_default(startingIndex, 0);
  array[startingIndex++] = value.x;
  array[startingIndex++] = value.y;
  array[startingIndex] = value.z;
  return array;
};
Cartesian3.unpack = function(array, startingIndex, result) {
  Check_default.defined("array", array);
  startingIndex = defaultValue_default(startingIndex, 0);
  if (!defined_default(result)) {
    result = new Cartesian3();
  }
  result.x = array[startingIndex++];
  result.y = array[startingIndex++];
  result.z = array[startingIndex];
  return result;
};
Cartesian3.packArray = function(array, result) {
  Check_default.defined("array", array);
  const length3 = array.length;
  const resultLength = length3 * 3;
  if (!defined_default(result)) {
    result = new Array(resultLength);
  } else if (!Array.isArray(result) && result.length !== resultLength) {
    throw new DeveloperError_default(
      "If result is a typed array, it must have exactly array.length * 3 elements"
    );
  } else if (result.length !== resultLength) {
    result.length = resultLength;
  }
  for (let i = 0; i < length3; ++i) {
    Cartesian3.pack(array[i], result, i * 3);
  }
  return result;
};
Cartesian3.unpackArray = function(array, result) {
  Check_default.defined("array", array);
  Check_default.typeOf.number.greaterThanOrEquals("array.length", array.length, 3);
  if (array.length % 3 !== 0) {
    throw new DeveloperError_default("array length must be a multiple of 3.");
  }
  const length3 = array.length;
  if (!defined_default(result)) {
    result = new Array(length3 / 3);
  } else {
    result.length = length3 / 3;
  }
  for (let i = 0; i < length3; i += 3) {
    const index = i / 3;
    result[index] = Cartesian3.unpack(array, i, result[index]);
  }
  return result;
};
Cartesian3.fromArray = Cartesian3.unpack;
Cartesian3.maximumComponent = function(cartesian11) {
  Check_default.typeOf.object("cartesian", cartesian11);
  return Math.max(cartesian11.x, cartesian11.y, cartesian11.z);
};
Cartesian3.minimumComponent = function(cartesian11) {
  Check_default.typeOf.object("cartesian", cartesian11);
  return Math.min(cartesian11.x, cartesian11.y, cartesian11.z);
};
Cartesian3.minimumByComponent = function(first, second, result) {
  Check_default.typeOf.object("first", first);
  Check_default.typeOf.object("second", second);
  Check_default.typeOf.object("result", result);
  result.x = Math.min(first.x, second.x);
  result.y = Math.min(first.y, second.y);
  result.z = Math.min(first.z, second.z);
  return result;
};
Cartesian3.maximumByComponent = function(first, second, result) {
  Check_default.typeOf.object("first", first);
  Check_default.typeOf.object("second", second);
  Check_default.typeOf.object("result", result);
  result.x = Math.max(first.x, second.x);
  result.y = Math.max(first.y, second.y);
  result.z = Math.max(first.z, second.z);
  return result;
};
Cartesian3.clamp = function(value, min3, max3, result) {
  Check_default.typeOf.object("value", value);
  Check_default.typeOf.object("min", min3);
  Check_default.typeOf.object("max", max3);
  Check_default.typeOf.object("result", result);
  const x = Math_default.clamp(value.x, min3.x, max3.x);
  const y = Math_default.clamp(value.y, min3.y, max3.y);
  const z = Math_default.clamp(value.z, min3.z, max3.z);
  result.x = x;
  result.y = y;
  result.z = z;
  return result;
};
Cartesian3.magnitudeSquared = function(cartesian11) {
  Check_default.typeOf.object("cartesian", cartesian11);
  return cartesian11.x * cartesian11.x + cartesian11.y * cartesian11.y + cartesian11.z * cartesian11.z;
};
Cartesian3.magnitude = function(cartesian11) {
  return Math.sqrt(Cartesian3.magnitudeSquared(cartesian11));
};
var distanceScratch = new Cartesian3();
Cartesian3.distance = function(left, right) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Cartesian3.subtract(left, right, distanceScratch);
  return Cartesian3.magnitude(distanceScratch);
};
Cartesian3.distanceSquared = function(left, right) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Cartesian3.subtract(left, right, distanceScratch);
  return Cartesian3.magnitudeSquared(distanceScratch);
};
Cartesian3.normalize = function(cartesian11, result) {
  Check_default.typeOf.object("cartesian", cartesian11);
  Check_default.typeOf.object("result", result);
  const magnitude = Cartesian3.magnitude(cartesian11);
  result.x = cartesian11.x / magnitude;
  result.y = cartesian11.y / magnitude;
  result.z = cartesian11.z / magnitude;
  if (isNaN(result.x) || isNaN(result.y) || isNaN(result.z)) {
    throw new DeveloperError_default("normalized result is not a number");
  }
  return result;
};
Cartesian3.dot = function(left, right) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  return left.x * right.x + left.y * right.y + left.z * right.z;
};
Cartesian3.multiplyComponents = function(left, right, result) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Check_default.typeOf.object("result", result);
  result.x = left.x * right.x;
  result.y = left.y * right.y;
  result.z = left.z * right.z;
  return result;
};
Cartesian3.divideComponents = function(left, right, result) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Check_default.typeOf.object("result", result);
  result.x = left.x / right.x;
  result.y = left.y / right.y;
  result.z = left.z / right.z;
  return result;
};
Cartesian3.add = function(left, right, result) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Check_default.typeOf.object("result", result);
  result.x = left.x + right.x;
  result.y = left.y + right.y;
  result.z = left.z + right.z;
  return result;
};
Cartesian3.subtract = function(left, right, result) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Check_default.typeOf.object("result", result);
  result.x = left.x - right.x;
  result.y = left.y - right.y;
  result.z = left.z - right.z;
  return result;
};
Cartesian3.multiplyByScalar = function(cartesian11, scalar, result) {
  Check_default.typeOf.object("cartesian", cartesian11);
  Check_default.typeOf.number("scalar", scalar);
  Check_default.typeOf.object("result", result);
  result.x = cartesian11.x * scalar;
  result.y = cartesian11.y * scalar;
  result.z = cartesian11.z * scalar;
  return result;
};
Cartesian3.divideByScalar = function(cartesian11, scalar, result) {
  Check_default.typeOf.object("cartesian", cartesian11);
  Check_default.typeOf.number("scalar", scalar);
  Check_default.typeOf.object("result", result);
  result.x = cartesian11.x / scalar;
  result.y = cartesian11.y / scalar;
  result.z = cartesian11.z / scalar;
  return result;
};
Cartesian3.negate = function(cartesian11, result) {
  Check_default.typeOf.object("cartesian", cartesian11);
  Check_default.typeOf.object("result", result);
  result.x = -cartesian11.x;
  result.y = -cartesian11.y;
  result.z = -cartesian11.z;
  return result;
};
Cartesian3.abs = function(cartesian11, result) {
  Check_default.typeOf.object("cartesian", cartesian11);
  Check_default.typeOf.object("result", result);
  result.x = Math.abs(cartesian11.x);
  result.y = Math.abs(cartesian11.y);
  result.z = Math.abs(cartesian11.z);
  return result;
};
var lerpScratch = new Cartesian3();
Cartesian3.lerp = function(start, end, t, result) {
  Check_default.typeOf.object("start", start);
  Check_default.typeOf.object("end", end);
  Check_default.typeOf.number("t", t);
  Check_default.typeOf.object("result", result);
  Cartesian3.multiplyByScalar(end, t, lerpScratch);
  result = Cartesian3.multiplyByScalar(start, 1 - t, result);
  return Cartesian3.add(lerpScratch, result, result);
};
var angleBetweenScratch = new Cartesian3();
var angleBetweenScratch2 = new Cartesian3();
Cartesian3.angleBetween = function(left, right) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Cartesian3.normalize(left, angleBetweenScratch);
  Cartesian3.normalize(right, angleBetweenScratch2);
  const cosine = Cartesian3.dot(angleBetweenScratch, angleBetweenScratch2);
  const sine = Cartesian3.magnitude(
    Cartesian3.cross(
      angleBetweenScratch,
      angleBetweenScratch2,
      angleBetweenScratch
    )
  );
  return Math.atan2(sine, cosine);
};
var mostOrthogonalAxisScratch = new Cartesian3();
Cartesian3.mostOrthogonalAxis = function(cartesian11, result) {
  Check_default.typeOf.object("cartesian", cartesian11);
  Check_default.typeOf.object("result", result);
  const f = Cartesian3.normalize(cartesian11, mostOrthogonalAxisScratch);
  Cartesian3.abs(f, f);
  if (f.x <= f.y) {
    if (f.x <= f.z) {
      result = Cartesian3.clone(Cartesian3.UNIT_X, result);
    } else {
      result = Cartesian3.clone(Cartesian3.UNIT_Z, result);
    }
  } else if (f.y <= f.z) {
    result = Cartesian3.clone(Cartesian3.UNIT_Y, result);
  } else {
    result = Cartesian3.clone(Cartesian3.UNIT_Z, result);
  }
  return result;
};
Cartesian3.projectVector = function(a3, b, result) {
  Check_default.defined("a", a3);
  Check_default.defined("b", b);
  Check_default.defined("result", result);
  const scalar = Cartesian3.dot(a3, b) / Cartesian3.dot(b, b);
  return Cartesian3.multiplyByScalar(b, scalar, result);
};
Cartesian3.equals = function(left, right) {
  return left === right || defined_default(left) && defined_default(right) && left.x === right.x && left.y === right.y && left.z === right.z;
};
Cartesian3.equalsArray = function(cartesian11, array, offset2) {
  return cartesian11.x === array[offset2] && cartesian11.y === array[offset2 + 1] && cartesian11.z === array[offset2 + 2];
};
Cartesian3.equalsEpsilon = function(left, right, relativeEpsilon, absoluteEpsilon) {
  return left === right || defined_default(left) && defined_default(right) && Math_default.equalsEpsilon(
    left.x,
    right.x,
    relativeEpsilon,
    absoluteEpsilon
  ) && Math_default.equalsEpsilon(
    left.y,
    right.y,
    relativeEpsilon,
    absoluteEpsilon
  ) && Math_default.equalsEpsilon(
    left.z,
    right.z,
    relativeEpsilon,
    absoluteEpsilon
  );
};
Cartesian3.cross = function(left, right, result) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Check_default.typeOf.object("result", result);
  const leftX = left.x;
  const leftY = left.y;
  const leftZ = left.z;
  const rightX = right.x;
  const rightY = right.y;
  const rightZ = right.z;
  const x = leftY * rightZ - leftZ * rightY;
  const y = leftZ * rightX - leftX * rightZ;
  const z = leftX * rightY - leftY * rightX;
  result.x = x;
  result.y = y;
  result.z = z;
  return result;
};
Cartesian3.midpoint = function(left, right, result) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Check_default.typeOf.object("result", result);
  result.x = (left.x + right.x) * 0.5;
  result.y = (left.y + right.y) * 0.5;
  result.z = (left.z + right.z) * 0.5;
  return result;
};
Cartesian3.fromDegrees = function(longitude, latitude, height, ellipsoid, result) {
  Check_default.typeOf.number("longitude", longitude);
  Check_default.typeOf.number("latitude", latitude);
  longitude = Math_default.toRadians(longitude);
  latitude = Math_default.toRadians(latitude);
  return Cartesian3.fromRadians(longitude, latitude, height, ellipsoid, result);
};
var scratchN = new Cartesian3();
var scratchK = new Cartesian3();
var wgs84RadiiSquared = new Cartesian3(
  6378137 * 6378137,
  6378137 * 6378137,
  6356752314245179e-9 * 6356752314245179e-9
);
Cartesian3.fromRadians = function(longitude, latitude, height, ellipsoid, result) {
  Check_default.typeOf.number("longitude", longitude);
  Check_default.typeOf.number("latitude", latitude);
  height = defaultValue_default(height, 0);
  const radiiSquared = defined_default(ellipsoid) ? ellipsoid.radiiSquared : wgs84RadiiSquared;
  const cosLatitude = Math.cos(latitude);
  scratchN.x = cosLatitude * Math.cos(longitude);
  scratchN.y = cosLatitude * Math.sin(longitude);
  scratchN.z = Math.sin(latitude);
  scratchN = Cartesian3.normalize(scratchN, scratchN);
  Cartesian3.multiplyComponents(radiiSquared, scratchN, scratchK);
  const gamma = Math.sqrt(Cartesian3.dot(scratchN, scratchK));
  scratchK = Cartesian3.divideByScalar(scratchK, gamma, scratchK);
  scratchN = Cartesian3.multiplyByScalar(scratchN, height, scratchN);
  if (!defined_default(result)) {
    result = new Cartesian3();
  }
  return Cartesian3.add(scratchK, scratchN, result);
};
Cartesian3.fromDegreesArray = function(coordinates, ellipsoid, result) {
  Check_default.defined("coordinates", coordinates);
  if (coordinates.length < 2 || coordinates.length % 2 !== 0) {
    throw new DeveloperError_default(
      "the number of coordinates must be a multiple of 2 and at least 2"
    );
  }
  const length3 = coordinates.length;
  if (!defined_default(result)) {
    result = new Array(length3 / 2);
  } else {
    result.length = length3 / 2;
  }
  for (let i = 0; i < length3; i += 2) {
    const longitude = coordinates[i];
    const latitude = coordinates[i + 1];
    const index = i / 2;
    result[index] = Cartesian3.fromDegrees(
      longitude,
      latitude,
      0,
      ellipsoid,
      result[index]
    );
  }
  return result;
};
Cartesian3.fromRadiansArray = function(coordinates, ellipsoid, result) {
  Check_default.defined("coordinates", coordinates);
  if (coordinates.length < 2 || coordinates.length % 2 !== 0) {
    throw new DeveloperError_default(
      "the number of coordinates must be a multiple of 2 and at least 2"
    );
  }
  const length3 = coordinates.length;
  if (!defined_default(result)) {
    result = new Array(length3 / 2);
  } else {
    result.length = length3 / 2;
  }
  for (let i = 0; i < length3; i += 2) {
    const longitude = coordinates[i];
    const latitude = coordinates[i + 1];
    const index = i / 2;
    result[index] = Cartesian3.fromRadians(
      longitude,
      latitude,
      0,
      ellipsoid,
      result[index]
    );
  }
  return result;
};
Cartesian3.fromDegreesArrayHeights = function(coordinates, ellipsoid, result) {
  Check_default.defined("coordinates", coordinates);
  if (coordinates.length < 3 || coordinates.length % 3 !== 0) {
    throw new DeveloperError_default(
      "the number of coordinates must be a multiple of 3 and at least 3"
    );
  }
  const length3 = coordinates.length;
  if (!defined_default(result)) {
    result = new Array(length3 / 3);
  } else {
    result.length = length3 / 3;
  }
  for (let i = 0; i < length3; i += 3) {
    const longitude = coordinates[i];
    const latitude = coordinates[i + 1];
    const height = coordinates[i + 2];
    const index = i / 3;
    result[index] = Cartesian3.fromDegrees(
      longitude,
      latitude,
      height,
      ellipsoid,
      result[index]
    );
  }
  return result;
};
Cartesian3.fromRadiansArrayHeights = function(coordinates, ellipsoid, result) {
  Check_default.defined("coordinates", coordinates);
  if (coordinates.length < 3 || coordinates.length % 3 !== 0) {
    throw new DeveloperError_default(
      "the number of coordinates must be a multiple of 3 and at least 3"
    );
  }
  const length3 = coordinates.length;
  if (!defined_default(result)) {
    result = new Array(length3 / 3);
  } else {
    result.length = length3 / 3;
  }
  for (let i = 0; i < length3; i += 3) {
    const longitude = coordinates[i];
    const latitude = coordinates[i + 1];
    const height = coordinates[i + 2];
    const index = i / 3;
    result[index] = Cartesian3.fromRadians(
      longitude,
      latitude,
      height,
      ellipsoid,
      result[index]
    );
  }
  return result;
};
Cartesian3.ZERO = Object.freeze(new Cartesian3(0, 0, 0));
Cartesian3.ONE = Object.freeze(new Cartesian3(1, 1, 1));
Cartesian3.UNIT_X = Object.freeze(new Cartesian3(1, 0, 0));
Cartesian3.UNIT_Y = Object.freeze(new Cartesian3(0, 1, 0));
Cartesian3.UNIT_Z = Object.freeze(new Cartesian3(0, 0, 1));
Cartesian3.prototype.clone = function(result) {
  return Cartesian3.clone(this, result);
};
Cartesian3.prototype.equals = function(right) {
  return Cartesian3.equals(this, right);
};
Cartesian3.prototype.equalsEpsilon = function(right, relativeEpsilon, absoluteEpsilon) {
  return Cartesian3.equalsEpsilon(
    this,
    right,
    relativeEpsilon,
    absoluteEpsilon
  );
};
Cartesian3.prototype.toString = function() {
  return `(${this.x}, ${this.y}, ${this.z})`;
};
var Cartesian3_default = Cartesian3;

// Source/Core/scaleToGeodeticSurface.js
var scaleToGeodeticSurfaceIntersection = new Cartesian3_default();
var scaleToGeodeticSurfaceGradient = new Cartesian3_default();
function scaleToGeodeticSurface(cartesian11, oneOverRadii, oneOverRadiiSquared, centerToleranceSquared, result) {
  if (!defined_default(cartesian11)) {
    throw new DeveloperError_default("cartesian is required.");
  }
  if (!defined_default(oneOverRadii)) {
    throw new DeveloperError_default("oneOverRadii is required.");
  }
  if (!defined_default(oneOverRadiiSquared)) {
    throw new DeveloperError_default("oneOverRadiiSquared is required.");
  }
  if (!defined_default(centerToleranceSquared)) {
    throw new DeveloperError_default("centerToleranceSquared is required.");
  }
  const positionX = cartesian11.x;
  const positionY = cartesian11.y;
  const positionZ = cartesian11.z;
  const oneOverRadiiX = oneOverRadii.x;
  const oneOverRadiiY = oneOverRadii.y;
  const oneOverRadiiZ = oneOverRadii.z;
  const x2 = positionX * positionX * oneOverRadiiX * oneOverRadiiX;
  const y2 = positionY * positionY * oneOverRadiiY * oneOverRadiiY;
  const z2 = positionZ * positionZ * oneOverRadiiZ * oneOverRadiiZ;
  const squaredNorm = x2 + y2 + z2;
  const ratio = Math.sqrt(1 / squaredNorm);
  const intersection = Cartesian3_default.multiplyByScalar(
    cartesian11,
    ratio,
    scaleToGeodeticSurfaceIntersection
  );
  if (squaredNorm < centerToleranceSquared) {
    return !isFinite(ratio) ? void 0 : Cartesian3_default.clone(intersection, result);
  }
  const oneOverRadiiSquaredX = oneOverRadiiSquared.x;
  const oneOverRadiiSquaredY = oneOverRadiiSquared.y;
  const oneOverRadiiSquaredZ = oneOverRadiiSquared.z;
  const gradient = scaleToGeodeticSurfaceGradient;
  gradient.x = intersection.x * oneOverRadiiSquaredX * 2;
  gradient.y = intersection.y * oneOverRadiiSquaredY * 2;
  gradient.z = intersection.z * oneOverRadiiSquaredZ * 2;
  let lambda = (1 - ratio) * Cartesian3_default.magnitude(cartesian11) / (0.5 * Cartesian3_default.magnitude(gradient));
  let correction = 0;
  let func;
  let denominator;
  let xMultiplier;
  let yMultiplier;
  let zMultiplier;
  let xMultiplier2;
  let yMultiplier2;
  let zMultiplier2;
  let xMultiplier3;
  let yMultiplier3;
  let zMultiplier3;
  do {
    lambda -= correction;
    xMultiplier = 1 / (1 + lambda * oneOverRadiiSquaredX);
    yMultiplier = 1 / (1 + lambda * oneOverRadiiSquaredY);
    zMultiplier = 1 / (1 + lambda * oneOverRadiiSquaredZ);
    xMultiplier2 = xMultiplier * xMultiplier;
    yMultiplier2 = yMultiplier * yMultiplier;
    zMultiplier2 = zMultiplier * zMultiplier;
    xMultiplier3 = xMultiplier2 * xMultiplier;
    yMultiplier3 = yMultiplier2 * yMultiplier;
    zMultiplier3 = zMultiplier2 * zMultiplier;
    func = x2 * xMultiplier2 + y2 * yMultiplier2 + z2 * zMultiplier2 - 1;
    denominator = x2 * xMultiplier3 * oneOverRadiiSquaredX + y2 * yMultiplier3 * oneOverRadiiSquaredY + z2 * zMultiplier3 * oneOverRadiiSquaredZ;
    const derivative = -2 * denominator;
    correction = func / derivative;
  } while (Math.abs(func) > Math_default.EPSILON12);
  if (!defined_default(result)) {
    return new Cartesian3_default(
      positionX * xMultiplier,
      positionY * yMultiplier,
      positionZ * zMultiplier
    );
  }
  result.x = positionX * xMultiplier;
  result.y = positionY * yMultiplier;
  result.z = positionZ * zMultiplier;
  return result;
}
var scaleToGeodeticSurface_default = scaleToGeodeticSurface;

// Source/Core/Cartographic.js
function Cartographic(longitude, latitude, height) {
  this.longitude = defaultValue_default(longitude, 0);
  this.latitude = defaultValue_default(latitude, 0);
  this.height = defaultValue_default(height, 0);
}
Cartographic.fromRadians = function(longitude, latitude, height, result) {
  Check_default.typeOf.number("longitude", longitude);
  Check_default.typeOf.number("latitude", latitude);
  height = defaultValue_default(height, 0);
  if (!defined_default(result)) {
    return new Cartographic(longitude, latitude, height);
  }
  result.longitude = longitude;
  result.latitude = latitude;
  result.height = height;
  return result;
};
Cartographic.fromDegrees = function(longitude, latitude, height, result) {
  Check_default.typeOf.number("longitude", longitude);
  Check_default.typeOf.number("latitude", latitude);
  longitude = Math_default.toRadians(longitude);
  latitude = Math_default.toRadians(latitude);
  return Cartographic.fromRadians(longitude, latitude, height, result);
};
var cartesianToCartographicN = new Cartesian3_default();
var cartesianToCartographicP = new Cartesian3_default();
var cartesianToCartographicH = new Cartesian3_default();
var wgs84OneOverRadii = new Cartesian3_default(
  1 / 6378137,
  1 / 6378137,
  1 / 6356752314245179e-9
);
var wgs84OneOverRadiiSquared = new Cartesian3_default(
  1 / (6378137 * 6378137),
  1 / (6378137 * 6378137),
  1 / (6356752314245179e-9 * 6356752314245179e-9)
);
var wgs84CenterToleranceSquared = Math_default.EPSILON1;
Cartographic.fromCartesian = function(cartesian11, ellipsoid, result) {
  const oneOverRadii = defined_default(ellipsoid) ? ellipsoid.oneOverRadii : wgs84OneOverRadii;
  const oneOverRadiiSquared = defined_default(ellipsoid) ? ellipsoid.oneOverRadiiSquared : wgs84OneOverRadiiSquared;
  const centerToleranceSquared = defined_default(ellipsoid) ? ellipsoid._centerToleranceSquared : wgs84CenterToleranceSquared;
  const p = scaleToGeodeticSurface_default(
    cartesian11,
    oneOverRadii,
    oneOverRadiiSquared,
    centerToleranceSquared,
    cartesianToCartographicP
  );
  if (!defined_default(p)) {
    return void 0;
  }
  let n = Cartesian3_default.multiplyComponents(
    p,
    oneOverRadiiSquared,
    cartesianToCartographicN
  );
  n = Cartesian3_default.normalize(n, n);
  const h = Cartesian3_default.subtract(cartesian11, p, cartesianToCartographicH);
  const longitude = Math.atan2(n.y, n.x);
  const latitude = Math.asin(n.z);
  const height = Math_default.sign(Cartesian3_default.dot(h, cartesian11)) * Cartesian3_default.magnitude(h);
  if (!defined_default(result)) {
    return new Cartographic(longitude, latitude, height);
  }
  result.longitude = longitude;
  result.latitude = latitude;
  result.height = height;
  return result;
};
Cartographic.toCartesian = function(cartographic2, ellipsoid, result) {
  Check_default.defined("cartographic", cartographic2);
  return Cartesian3_default.fromRadians(
    cartographic2.longitude,
    cartographic2.latitude,
    cartographic2.height,
    ellipsoid,
    result
  );
};
Cartographic.clone = function(cartographic2, result) {
  if (!defined_default(cartographic2)) {
    return void 0;
  }
  if (!defined_default(result)) {
    return new Cartographic(
      cartographic2.longitude,
      cartographic2.latitude,
      cartographic2.height
    );
  }
  result.longitude = cartographic2.longitude;
  result.latitude = cartographic2.latitude;
  result.height = cartographic2.height;
  return result;
};
Cartographic.equals = function(left, right) {
  return left === right || defined_default(left) && defined_default(right) && left.longitude === right.longitude && left.latitude === right.latitude && left.height === right.height;
};
Cartographic.equalsEpsilon = function(left, right, epsilon) {
  epsilon = defaultValue_default(epsilon, 0);
  return left === right || defined_default(left) && defined_default(right) && Math.abs(left.longitude - right.longitude) <= epsilon && Math.abs(left.latitude - right.latitude) <= epsilon && Math.abs(left.height - right.height) <= epsilon;
};
Cartographic.ZERO = Object.freeze(new Cartographic(0, 0, 0));
Cartographic.prototype.clone = function(result) {
  return Cartographic.clone(this, result);
};
Cartographic.prototype.equals = function(right) {
  return Cartographic.equals(this, right);
};
Cartographic.prototype.equalsEpsilon = function(right, epsilon) {
  return Cartographic.equalsEpsilon(this, right, epsilon);
};
Cartographic.prototype.toString = function() {
  return `(${this.longitude}, ${this.latitude}, ${this.height})`;
};
var Cartographic_default = Cartographic;

// Source/Core/Ellipsoid.js
function initialize(ellipsoid, x, y, z) {
  x = defaultValue_default(x, 0);
  y = defaultValue_default(y, 0);
  z = defaultValue_default(z, 0);
  Check_default.typeOf.number.greaterThanOrEquals("x", x, 0);
  Check_default.typeOf.number.greaterThanOrEquals("y", y, 0);
  Check_default.typeOf.number.greaterThanOrEquals("z", z, 0);
  ellipsoid._radii = new Cartesian3_default(x, y, z);
  ellipsoid._radiiSquared = new Cartesian3_default(x * x, y * y, z * z);
  ellipsoid._radiiToTheFourth = new Cartesian3_default(
    x * x * x * x,
    y * y * y * y,
    z * z * z * z
  );
  ellipsoid._oneOverRadii = new Cartesian3_default(
    x === 0 ? 0 : 1 / x,
    y === 0 ? 0 : 1 / y,
    z === 0 ? 0 : 1 / z
  );
  ellipsoid._oneOverRadiiSquared = new Cartesian3_default(
    x === 0 ? 0 : 1 / (x * x),
    y === 0 ? 0 : 1 / (y * y),
    z === 0 ? 0 : 1 / (z * z)
  );
  ellipsoid._minimumRadius = Math.min(x, y, z);
  ellipsoid._maximumRadius = Math.max(x, y, z);
  ellipsoid._centerToleranceSquared = Math_default.EPSILON1;
  if (ellipsoid._radiiSquared.z !== 0) {
    ellipsoid._squaredXOverSquaredZ = ellipsoid._radiiSquared.x / ellipsoid._radiiSquared.z;
  }
}
function Ellipsoid(x, y, z) {
  this._radii = void 0;
  this._radiiSquared = void 0;
  this._radiiToTheFourth = void 0;
  this._oneOverRadii = void 0;
  this._oneOverRadiiSquared = void 0;
  this._minimumRadius = void 0;
  this._maximumRadius = void 0;
  this._centerToleranceSquared = void 0;
  this._squaredXOverSquaredZ = void 0;
  initialize(this, x, y, z);
}
Object.defineProperties(Ellipsoid.prototype, {
  radii: {
    get: function() {
      return this._radii;
    }
  },
  radiiSquared: {
    get: function() {
      return this._radiiSquared;
    }
  },
  radiiToTheFourth: {
    get: function() {
      return this._radiiToTheFourth;
    }
  },
  oneOverRadii: {
    get: function() {
      return this._oneOverRadii;
    }
  },
  oneOverRadiiSquared: {
    get: function() {
      return this._oneOverRadiiSquared;
    }
  },
  minimumRadius: {
    get: function() {
      return this._minimumRadius;
    }
  },
  maximumRadius: {
    get: function() {
      return this._maximumRadius;
    }
  }
});
Ellipsoid.clone = function(ellipsoid, result) {
  if (!defined_default(ellipsoid)) {
    return void 0;
  }
  const radii = ellipsoid._radii;
  if (!defined_default(result)) {
    return new Ellipsoid(radii.x, radii.y, radii.z);
  }
  Cartesian3_default.clone(radii, result._radii);
  Cartesian3_default.clone(ellipsoid._radiiSquared, result._radiiSquared);
  Cartesian3_default.clone(ellipsoid._radiiToTheFourth, result._radiiToTheFourth);
  Cartesian3_default.clone(ellipsoid._oneOverRadii, result._oneOverRadii);
  Cartesian3_default.clone(ellipsoid._oneOverRadiiSquared, result._oneOverRadiiSquared);
  result._minimumRadius = ellipsoid._minimumRadius;
  result._maximumRadius = ellipsoid._maximumRadius;
  result._centerToleranceSquared = ellipsoid._centerToleranceSquared;
  return result;
};
Ellipsoid.fromCartesian3 = function(cartesian11, result) {
  if (!defined_default(result)) {
    result = new Ellipsoid();
  }
  if (!defined_default(cartesian11)) {
    return result;
  }
  initialize(result, cartesian11.x, cartesian11.y, cartesian11.z);
  return result;
};
Ellipsoid.WGS84 = Object.freeze(
  new Ellipsoid(6378137, 6378137, 6356752314245179e-9)
);
Ellipsoid.UNIT_SPHERE = Object.freeze(new Ellipsoid(1, 1, 1));
Ellipsoid.MOON = Object.freeze(
  new Ellipsoid(
    Math_default.LUNAR_RADIUS,
    Math_default.LUNAR_RADIUS,
    Math_default.LUNAR_RADIUS
  )
);
Ellipsoid.prototype.clone = function(result) {
  return Ellipsoid.clone(this, result);
};
Ellipsoid.packedLength = Cartesian3_default.packedLength;
Ellipsoid.pack = function(value, array, startingIndex) {
  Check_default.typeOf.object("value", value);
  Check_default.defined("array", array);
  startingIndex = defaultValue_default(startingIndex, 0);
  Cartesian3_default.pack(value._radii, array, startingIndex);
  return array;
};
Ellipsoid.unpack = function(array, startingIndex, result) {
  Check_default.defined("array", array);
  startingIndex = defaultValue_default(startingIndex, 0);
  const radii = Cartesian3_default.unpack(array, startingIndex);
  return Ellipsoid.fromCartesian3(radii, result);
};
Ellipsoid.prototype.geocentricSurfaceNormal = Cartesian3_default.normalize;
Ellipsoid.prototype.geodeticSurfaceNormalCartographic = function(cartographic2, result) {
  Check_default.typeOf.object("cartographic", cartographic2);
  const longitude = cartographic2.longitude;
  const latitude = cartographic2.latitude;
  const cosLatitude = Math.cos(latitude);
  const x = cosLatitude * Math.cos(longitude);
  const y = cosLatitude * Math.sin(longitude);
  const z = Math.sin(latitude);
  if (!defined_default(result)) {
    result = new Cartesian3_default();
  }
  result.x = x;
  result.y = y;
  result.z = z;
  return Cartesian3_default.normalize(result, result);
};
Ellipsoid.prototype.geodeticSurfaceNormal = function(cartesian11, result) {
  if (Cartesian3_default.equalsEpsilon(cartesian11, Cartesian3_default.ZERO, Math_default.EPSILON14)) {
    return void 0;
  }
  if (!defined_default(result)) {
    result = new Cartesian3_default();
  }
  result = Cartesian3_default.multiplyComponents(
    cartesian11,
    this._oneOverRadiiSquared,
    result
  );
  return Cartesian3_default.normalize(result, result);
};
var cartographicToCartesianNormal = new Cartesian3_default();
var cartographicToCartesianK = new Cartesian3_default();
Ellipsoid.prototype.cartographicToCartesian = function(cartographic2, result) {
  const n = cartographicToCartesianNormal;
  const k = cartographicToCartesianK;
  this.geodeticSurfaceNormalCartographic(cartographic2, n);
  Cartesian3_default.multiplyComponents(this._radiiSquared, n, k);
  const gamma = Math.sqrt(Cartesian3_default.dot(n, k));
  Cartesian3_default.divideByScalar(k, gamma, k);
  Cartesian3_default.multiplyByScalar(n, cartographic2.height, n);
  if (!defined_default(result)) {
    result = new Cartesian3_default();
  }
  return Cartesian3_default.add(k, n, result);
};
Ellipsoid.prototype.cartographicArrayToCartesianArray = function(cartographics, result) {
  Check_default.defined("cartographics", cartographics);
  const length3 = cartographics.length;
  if (!defined_default(result)) {
    result = new Array(length3);
  } else {
    result.length = length3;
  }
  for (let i = 0; i < length3; i++) {
    result[i] = this.cartographicToCartesian(cartographics[i], result[i]);
  }
  return result;
};
var cartesianToCartographicN2 = new Cartesian3_default();
var cartesianToCartographicP2 = new Cartesian3_default();
var cartesianToCartographicH2 = new Cartesian3_default();
Ellipsoid.prototype.cartesianToCartographic = function(cartesian11, result) {
  const p = this.scaleToGeodeticSurface(cartesian11, cartesianToCartographicP2);
  if (!defined_default(p)) {
    return void 0;
  }
  const n = this.geodeticSurfaceNormal(p, cartesianToCartographicN2);
  const h = Cartesian3_default.subtract(cartesian11, p, cartesianToCartographicH2);
  const longitude = Math.atan2(n.y, n.x);
  const latitude = Math.asin(n.z);
  const height = Math_default.sign(Cartesian3_default.dot(h, cartesian11)) * Cartesian3_default.magnitude(h);
  if (!defined_default(result)) {
    return new Cartographic_default(longitude, latitude, height);
  }
  result.longitude = longitude;
  result.latitude = latitude;
  result.height = height;
  return result;
};
Ellipsoid.prototype.cartesianArrayToCartographicArray = function(cartesians, result) {
  Check_default.defined("cartesians", cartesians);
  const length3 = cartesians.length;
  if (!defined_default(result)) {
    result = new Array(length3);
  } else {
    result.length = length3;
  }
  for (let i = 0; i < length3; ++i) {
    result[i] = this.cartesianToCartographic(cartesians[i], result[i]);
  }
  return result;
};
Ellipsoid.prototype.scaleToGeodeticSurface = function(cartesian11, result) {
  return scaleToGeodeticSurface_default(
    cartesian11,
    this._oneOverRadii,
    this._oneOverRadiiSquared,
    this._centerToleranceSquared,
    result
  );
};
Ellipsoid.prototype.scaleToGeocentricSurface = function(cartesian11, result) {
  Check_default.typeOf.object("cartesian", cartesian11);
  if (!defined_default(result)) {
    result = new Cartesian3_default();
  }
  const positionX = cartesian11.x;
  const positionY = cartesian11.y;
  const positionZ = cartesian11.z;
  const oneOverRadiiSquared = this._oneOverRadiiSquared;
  const beta = 1 / Math.sqrt(
    positionX * positionX * oneOverRadiiSquared.x + positionY * positionY * oneOverRadiiSquared.y + positionZ * positionZ * oneOverRadiiSquared.z
  );
  return Cartesian3_default.multiplyByScalar(cartesian11, beta, result);
};
Ellipsoid.prototype.transformPositionToScaledSpace = function(position, result) {
  if (!defined_default(result)) {
    result = new Cartesian3_default();
  }
  return Cartesian3_default.multiplyComponents(position, this._oneOverRadii, result);
};
Ellipsoid.prototype.transformPositionFromScaledSpace = function(position, result) {
  if (!defined_default(result)) {
    result = new Cartesian3_default();
  }
  return Cartesian3_default.multiplyComponents(position, this._radii, result);
};
Ellipsoid.prototype.equals = function(right) {
  return this === right || defined_default(right) && Cartesian3_default.equals(this._radii, right._radii);
};
Ellipsoid.prototype.toString = function() {
  return this._radii.toString();
};
Ellipsoid.prototype.getSurfaceNormalIntersectionWithZAxis = function(position, buffer, result) {
  Check_default.typeOf.object("position", position);
  if (!Math_default.equalsEpsilon(
    this._radii.x,
    this._radii.y,
    Math_default.EPSILON15
  )) {
    throw new DeveloperError_default(
      "Ellipsoid must be an ellipsoid of revolution (radii.x == radii.y)"
    );
  }
  Check_default.typeOf.number.greaterThan("Ellipsoid.radii.z", this._radii.z, 0);
  buffer = defaultValue_default(buffer, 0);
  const squaredXOverSquaredZ = this._squaredXOverSquaredZ;
  if (!defined_default(result)) {
    result = new Cartesian3_default();
  }
  result.x = 0;
  result.y = 0;
  result.z = position.z * (1 - squaredXOverSquaredZ);
  if (Math.abs(result.z) >= this._radii.z - buffer) {
    return void 0;
  }
  return result;
};
var abscissas = [
  0.14887433898163,
  0.43339539412925,
  0.67940956829902,
  0.86506336668898,
  0.97390652851717,
  0
];
var weights = [
  0.29552422471475,
  0.26926671930999,
  0.21908636251598,
  0.14945134915058,
  0.066671344308684,
  0
];
function gaussLegendreQuadrature(a3, b, func) {
  Check_default.typeOf.number("a", a3);
  Check_default.typeOf.number("b", b);
  Check_default.typeOf.func("func", func);
  const xMean = 0.5 * (b + a3);
  const xRange = 0.5 * (b - a3);
  let sum = 0;
  for (let i = 0; i < 5; i++) {
    const dx = xRange * abscissas[i];
    sum += weights[i] * (func(xMean + dx) + func(xMean - dx));
  }
  sum *= xRange;
  return sum;
}
Ellipsoid.prototype.surfaceArea = function(rectangle) {
  Check_default.typeOf.object("rectangle", rectangle);
  const minLongitude = rectangle.west;
  let maxLongitude = rectangle.east;
  const minLatitude = rectangle.south;
  const maxLatitude = rectangle.north;
  while (maxLongitude < minLongitude) {
    maxLongitude += Math_default.TWO_PI;
  }
  const radiiSquared = this._radiiSquared;
  const a22 = radiiSquared.x;
  const b2 = radiiSquared.y;
  const c22 = radiiSquared.z;
  const a2b2 = a22 * b2;
  return gaussLegendreQuadrature(minLatitude, maxLatitude, function(lat) {
    const sinPhi = Math.cos(lat);
    const cosPhi = Math.sin(lat);
    return Math.cos(lat) * gaussLegendreQuadrature(minLongitude, maxLongitude, function(lon) {
      const cosTheta = Math.cos(lon);
      const sinTheta = Math.sin(lon);
      return Math.sqrt(
        a2b2 * cosPhi * cosPhi + c22 * (b2 * cosTheta * cosTheta + a22 * sinTheta * sinTheta) * sinPhi * sinPhi
      );
    });
  });
};
var Ellipsoid_default = Ellipsoid;

// Source/Core/GeographicProjection.js
function GeographicProjection(ellipsoid) {
  this._ellipsoid = defaultValue_default(ellipsoid, Ellipsoid_default.WGS84);
  this._semimajorAxis = this._ellipsoid.maximumRadius;
  this._oneOverSemimajorAxis = 1 / this._semimajorAxis;
}
Object.defineProperties(GeographicProjection.prototype, {
  ellipsoid: {
    get: function() {
      return this._ellipsoid;
    }
  }
});
GeographicProjection.prototype.project = function(cartographic2, result) {
  const semimajorAxis = this._semimajorAxis;
  const x = cartographic2.longitude * semimajorAxis;
  const y = cartographic2.latitude * semimajorAxis;
  const z = cartographic2.height;
  if (!defined_default(result)) {
    return new Cartesian3_default(x, y, z);
  }
  result.x = x;
  result.y = y;
  result.z = z;
  return result;
};
GeographicProjection.prototype.unproject = function(cartesian11, result) {
  if (!defined_default(cartesian11)) {
    throw new DeveloperError_default("cartesian is required");
  }
  const oneOverEarthSemimajorAxis = this._oneOverSemimajorAxis;
  const longitude = cartesian11.x * oneOverEarthSemimajorAxis;
  const latitude = cartesian11.y * oneOverEarthSemimajorAxis;
  const height = cartesian11.z;
  if (!defined_default(result)) {
    return new Cartographic_default(longitude, latitude, height);
  }
  result.longitude = longitude;
  result.latitude = latitude;
  result.height = height;
  return result;
};
var GeographicProjection_default = GeographicProjection;

// Source/Core/Intersect.js
var Intersect = {
  OUTSIDE: -1,
  INTERSECTING: 0,
  INSIDE: 1
};
var Intersect_default = Object.freeze(Intersect);

// Source/Core/Interval.js
function Interval(start, stop2) {
  this.start = defaultValue_default(start, 0);
  this.stop = defaultValue_default(stop2, 0);
}
var Interval_default = Interval;

// Source/Core/Matrix3.js
function Matrix3(column0Row0, column1Row0, column2Row0, column0Row1, column1Row1, column2Row1, column0Row2, column1Row2, column2Row2) {
  this[0] = defaultValue_default(column0Row0, 0);
  this[1] = defaultValue_default(column0Row1, 0);
  this[2] = defaultValue_default(column0Row2, 0);
  this[3] = defaultValue_default(column1Row0, 0);
  this[4] = defaultValue_default(column1Row1, 0);
  this[5] = defaultValue_default(column1Row2, 0);
  this[6] = defaultValue_default(column2Row0, 0);
  this[7] = defaultValue_default(column2Row1, 0);
  this[8] = defaultValue_default(column2Row2, 0);
}
Matrix3.packedLength = 9;
Matrix3.pack = function(value, array, startingIndex) {
  Check_default.typeOf.object("value", value);
  Check_default.defined("array", array);
  startingIndex = defaultValue_default(startingIndex, 0);
  array[startingIndex++] = value[0];
  array[startingIndex++] = value[1];
  array[startingIndex++] = value[2];
  array[startingIndex++] = value[3];
  array[startingIndex++] = value[4];
  array[startingIndex++] = value[5];
  array[startingIndex++] = value[6];
  array[startingIndex++] = value[7];
  array[startingIndex++] = value[8];
  return array;
};
Matrix3.unpack = function(array, startingIndex, result) {
  Check_default.defined("array", array);
  startingIndex = defaultValue_default(startingIndex, 0);
  if (!defined_default(result)) {
    result = new Matrix3();
  }
  result[0] = array[startingIndex++];
  result[1] = array[startingIndex++];
  result[2] = array[startingIndex++];
  result[3] = array[startingIndex++];
  result[4] = array[startingIndex++];
  result[5] = array[startingIndex++];
  result[6] = array[startingIndex++];
  result[7] = array[startingIndex++];
  result[8] = array[startingIndex++];
  return result;
};
Matrix3.packArray = function(array, result) {
  Check_default.defined("array", array);
  const length3 = array.length;
  const resultLength = length3 * 9;
  if (!defined_default(result)) {
    result = new Array(resultLength);
  } else if (!Array.isArray(result) && result.length !== resultLength) {
    throw new DeveloperError_default(
      "If result is a typed array, it must have exactly array.length * 9 elements"
    );
  } else if (result.length !== resultLength) {
    result.length = resultLength;
  }
  for (let i = 0; i < length3; ++i) {
    Matrix3.pack(array[i], result, i * 9);
  }
  return result;
};
Matrix3.unpackArray = function(array, result) {
  Check_default.defined("array", array);
  Check_default.typeOf.number.greaterThanOrEquals("array.length", array.length, 9);
  if (array.length % 9 !== 0) {
    throw new DeveloperError_default("array length must be a multiple of 9.");
  }
  const length3 = array.length;
  if (!defined_default(result)) {
    result = new Array(length3 / 9);
  } else {
    result.length = length3 / 9;
  }
  for (let i = 0; i < length3; i += 9) {
    const index = i / 9;
    result[index] = Matrix3.unpack(array, i, result[index]);
  }
  return result;
};
Matrix3.clone = function(matrix, result) {
  if (!defined_default(matrix)) {
    return void 0;
  }
  if (!defined_default(result)) {
    return new Matrix3(
      matrix[0],
      matrix[3],
      matrix[6],
      matrix[1],
      matrix[4],
      matrix[7],
      matrix[2],
      matrix[5],
      matrix[8]
    );
  }
  result[0] = matrix[0];
  result[1] = matrix[1];
  result[2] = matrix[2];
  result[3] = matrix[3];
  result[4] = matrix[4];
  result[5] = matrix[5];
  result[6] = matrix[6];
  result[7] = matrix[7];
  result[8] = matrix[8];
  return result;
};
Matrix3.fromArray = Matrix3.unpack;
Matrix3.fromColumnMajorArray = function(values, result) {
  Check_default.defined("values", values);
  return Matrix3.clone(values, result);
};
Matrix3.fromRowMajorArray = function(values, result) {
  Check_default.defined("values", values);
  if (!defined_default(result)) {
    return new Matrix3(
      values[0],
      values[1],
      values[2],
      values[3],
      values[4],
      values[5],
      values[6],
      values[7],
      values[8]
    );
  }
  result[0] = values[0];
  result[1] = values[3];
  result[2] = values[6];
  result[3] = values[1];
  result[4] = values[4];
  result[5] = values[7];
  result[6] = values[2];
  result[7] = values[5];
  result[8] = values[8];
  return result;
};
Matrix3.fromQuaternion = function(quaternion, result) {
  Check_default.typeOf.object("quaternion", quaternion);
  const x2 = quaternion.x * quaternion.x;
  const xy = quaternion.x * quaternion.y;
  const xz = quaternion.x * quaternion.z;
  const xw = quaternion.x * quaternion.w;
  const y2 = quaternion.y * quaternion.y;
  const yz = quaternion.y * quaternion.z;
  const yw = quaternion.y * quaternion.w;
  const z2 = quaternion.z * quaternion.z;
  const zw = quaternion.z * quaternion.w;
  const w2 = quaternion.w * quaternion.w;
  const m00 = x2 - y2 - z2 + w2;
  const m01 = 2 * (xy - zw);
  const m02 = 2 * (xz + yw);
  const m10 = 2 * (xy + zw);
  const m11 = -x2 + y2 - z2 + w2;
  const m12 = 2 * (yz - xw);
  const m20 = 2 * (xz - yw);
  const m21 = 2 * (yz + xw);
  const m22 = -x2 - y2 + z2 + w2;
  if (!defined_default(result)) {
    return new Matrix3(m00, m01, m02, m10, m11, m12, m20, m21, m22);
  }
  result[0] = m00;
  result[1] = m10;
  result[2] = m20;
  result[3] = m01;
  result[4] = m11;
  result[5] = m21;
  result[6] = m02;
  result[7] = m12;
  result[8] = m22;
  return result;
};
Matrix3.fromHeadingPitchRoll = function(headingPitchRoll, result) {
  Check_default.typeOf.object("headingPitchRoll", headingPitchRoll);
  const cosTheta = Math.cos(-headingPitchRoll.pitch);
  const cosPsi = Math.cos(-headingPitchRoll.heading);
  const cosPhi = Math.cos(headingPitchRoll.roll);
  const sinTheta = Math.sin(-headingPitchRoll.pitch);
  const sinPsi = Math.sin(-headingPitchRoll.heading);
  const sinPhi = Math.sin(headingPitchRoll.roll);
  const m00 = cosTheta * cosPsi;
  const m01 = -cosPhi * sinPsi + sinPhi * sinTheta * cosPsi;
  const m02 = sinPhi * sinPsi + cosPhi * sinTheta * cosPsi;
  const m10 = cosTheta * sinPsi;
  const m11 = cosPhi * cosPsi + sinPhi * sinTheta * sinPsi;
  const m12 = -sinPhi * cosPsi + cosPhi * sinTheta * sinPsi;
  const m20 = -sinTheta;
  const m21 = sinPhi * cosTheta;
  const m22 = cosPhi * cosTheta;
  if (!defined_default(result)) {
    return new Matrix3(m00, m01, m02, m10, m11, m12, m20, m21, m22);
  }
  result[0] = m00;
  result[1] = m10;
  result[2] = m20;
  result[3] = m01;
  result[4] = m11;
  result[5] = m21;
  result[6] = m02;
  result[7] = m12;
  result[8] = m22;
  return result;
};
Matrix3.fromScale = function(scale, result) {
  Check_default.typeOf.object("scale", scale);
  if (!defined_default(result)) {
    return new Matrix3(scale.x, 0, 0, 0, scale.y, 0, 0, 0, scale.z);
  }
  result[0] = scale.x;
  result[1] = 0;
  result[2] = 0;
  result[3] = 0;
  result[4] = scale.y;
  result[5] = 0;
  result[6] = 0;
  result[7] = 0;
  result[8] = scale.z;
  return result;
};
Matrix3.fromUniformScale = function(scale, result) {
  Check_default.typeOf.number("scale", scale);
  if (!defined_default(result)) {
    return new Matrix3(scale, 0, 0, 0, scale, 0, 0, 0, scale);
  }
  result[0] = scale;
  result[1] = 0;
  result[2] = 0;
  result[3] = 0;
  result[4] = scale;
  result[5] = 0;
  result[6] = 0;
  result[7] = 0;
  result[8] = scale;
  return result;
};
Matrix3.fromCrossProduct = function(vector, result) {
  Check_default.typeOf.object("vector", vector);
  if (!defined_default(result)) {
    return new Matrix3(
      0,
      -vector.z,
      vector.y,
      vector.z,
      0,
      -vector.x,
      -vector.y,
      vector.x,
      0
    );
  }
  result[0] = 0;
  result[1] = vector.z;
  result[2] = -vector.y;
  result[3] = -vector.z;
  result[4] = 0;
  result[5] = vector.x;
  result[6] = vector.y;
  result[7] = -vector.x;
  result[8] = 0;
  return result;
};
Matrix3.fromRotationX = function(angle, result) {
  Check_default.typeOf.number("angle", angle);
  const cosAngle = Math.cos(angle);
  const sinAngle = Math.sin(angle);
  if (!defined_default(result)) {
    return new Matrix3(
      1,
      0,
      0,
      0,
      cosAngle,
      -sinAngle,
      0,
      sinAngle,
      cosAngle
    );
  }
  result[0] = 1;
  result[1] = 0;
  result[2] = 0;
  result[3] = 0;
  result[4] = cosAngle;
  result[5] = sinAngle;
  result[6] = 0;
  result[7] = -sinAngle;
  result[8] = cosAngle;
  return result;
};
Matrix3.fromRotationY = function(angle, result) {
  Check_default.typeOf.number("angle", angle);
  const cosAngle = Math.cos(angle);
  const sinAngle = Math.sin(angle);
  if (!defined_default(result)) {
    return new Matrix3(
      cosAngle,
      0,
      sinAngle,
      0,
      1,
      0,
      -sinAngle,
      0,
      cosAngle
    );
  }
  result[0] = cosAngle;
  result[1] = 0;
  result[2] = -sinAngle;
  result[3] = 0;
  result[4] = 1;
  result[5] = 0;
  result[6] = sinAngle;
  result[7] = 0;
  result[8] = cosAngle;
  return result;
};
Matrix3.fromRotationZ = function(angle, result) {
  Check_default.typeOf.number("angle", angle);
  const cosAngle = Math.cos(angle);
  const sinAngle = Math.sin(angle);
  if (!defined_default(result)) {
    return new Matrix3(
      cosAngle,
      -sinAngle,
      0,
      sinAngle,
      cosAngle,
      0,
      0,
      0,
      1
    );
  }
  result[0] = cosAngle;
  result[1] = sinAngle;
  result[2] = 0;
  result[3] = -sinAngle;
  result[4] = cosAngle;
  result[5] = 0;
  result[6] = 0;
  result[7] = 0;
  result[8] = 1;
  return result;
};
Matrix3.toArray = function(matrix, result) {
  Check_default.typeOf.object("matrix", matrix);
  if (!defined_default(result)) {
    return [
      matrix[0],
      matrix[1],
      matrix[2],
      matrix[3],
      matrix[4],
      matrix[5],
      matrix[6],
      matrix[7],
      matrix[8]
    ];
  }
  result[0] = matrix[0];
  result[1] = matrix[1];
  result[2] = matrix[2];
  result[3] = matrix[3];
  result[4] = matrix[4];
  result[5] = matrix[5];
  result[6] = matrix[6];
  result[7] = matrix[7];
  result[8] = matrix[8];
  return result;
};
Matrix3.getElementIndex = function(column, row) {
  Check_default.typeOf.number.greaterThanOrEquals("row", row, 0);
  Check_default.typeOf.number.lessThanOrEquals("row", row, 2);
  Check_default.typeOf.number.greaterThanOrEquals("column", column, 0);
  Check_default.typeOf.number.lessThanOrEquals("column", column, 2);
  return column * 3 + row;
};
Matrix3.getColumn = function(matrix, index, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.number.greaterThanOrEquals("index", index, 0);
  Check_default.typeOf.number.lessThanOrEquals("index", index, 2);
  Check_default.typeOf.object("result", result);
  const startIndex = index * 3;
  const x = matrix[startIndex];
  const y = matrix[startIndex + 1];
  const z = matrix[startIndex + 2];
  result.x = x;
  result.y = y;
  result.z = z;
  return result;
};
Matrix3.setColumn = function(matrix, index, cartesian11, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.number.greaterThanOrEquals("index", index, 0);
  Check_default.typeOf.number.lessThanOrEquals("index", index, 2);
  Check_default.typeOf.object("cartesian", cartesian11);
  Check_default.typeOf.object("result", result);
  result = Matrix3.clone(matrix, result);
  const startIndex = index * 3;
  result[startIndex] = cartesian11.x;
  result[startIndex + 1] = cartesian11.y;
  result[startIndex + 2] = cartesian11.z;
  return result;
};
Matrix3.getRow = function(matrix, index, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.number.greaterThanOrEquals("index", index, 0);
  Check_default.typeOf.number.lessThanOrEquals("index", index, 2);
  Check_default.typeOf.object("result", result);
  const x = matrix[index];
  const y = matrix[index + 3];
  const z = matrix[index + 6];
  result.x = x;
  result.y = y;
  result.z = z;
  return result;
};
Matrix3.setRow = function(matrix, index, cartesian11, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.number.greaterThanOrEquals("index", index, 0);
  Check_default.typeOf.number.lessThanOrEquals("index", index, 2);
  Check_default.typeOf.object("cartesian", cartesian11);
  Check_default.typeOf.object("result", result);
  result = Matrix3.clone(matrix, result);
  result[index] = cartesian11.x;
  result[index + 3] = cartesian11.y;
  result[index + 6] = cartesian11.z;
  return result;
};
var scaleScratch1 = new Cartesian3_default();
Matrix3.setScale = function(matrix, scale, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("scale", scale);
  Check_default.typeOf.object("result", result);
  const existingScale = Matrix3.getScale(matrix, scaleScratch1);
  const scaleRatioX = scale.x / existingScale.x;
  const scaleRatioY = scale.y / existingScale.y;
  const scaleRatioZ = scale.z / existingScale.z;
  result[0] = matrix[0] * scaleRatioX;
  result[1] = matrix[1] * scaleRatioX;
  result[2] = matrix[2] * scaleRatioX;
  result[3] = matrix[3] * scaleRatioY;
  result[4] = matrix[4] * scaleRatioY;
  result[5] = matrix[5] * scaleRatioY;
  result[6] = matrix[6] * scaleRatioZ;
  result[7] = matrix[7] * scaleRatioZ;
  result[8] = matrix[8] * scaleRatioZ;
  return result;
};
var scaleScratch2 = new Cartesian3_default();
Matrix3.setUniformScale = function(matrix, scale, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.number("scale", scale);
  Check_default.typeOf.object("result", result);
  const existingScale = Matrix3.getScale(matrix, scaleScratch2);
  const scaleRatioX = scale / existingScale.x;
  const scaleRatioY = scale / existingScale.y;
  const scaleRatioZ = scale / existingScale.z;
  result[0] = matrix[0] * scaleRatioX;
  result[1] = matrix[1] * scaleRatioX;
  result[2] = matrix[2] * scaleRatioX;
  result[3] = matrix[3] * scaleRatioY;
  result[4] = matrix[4] * scaleRatioY;
  result[5] = matrix[5] * scaleRatioY;
  result[6] = matrix[6] * scaleRatioZ;
  result[7] = matrix[7] * scaleRatioZ;
  result[8] = matrix[8] * scaleRatioZ;
  return result;
};
var scratchColumn = new Cartesian3_default();
Matrix3.getScale = function(matrix, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("result", result);
  result.x = Cartesian3_default.magnitude(
    Cartesian3_default.fromElements(matrix[0], matrix[1], matrix[2], scratchColumn)
  );
  result.y = Cartesian3_default.magnitude(
    Cartesian3_default.fromElements(matrix[3], matrix[4], matrix[5], scratchColumn)
  );
  result.z = Cartesian3_default.magnitude(
    Cartesian3_default.fromElements(matrix[6], matrix[7], matrix[8], scratchColumn)
  );
  return result;
};
var scaleScratch3 = new Cartesian3_default();
Matrix3.getMaximumScale = function(matrix) {
  Matrix3.getScale(matrix, scaleScratch3);
  return Cartesian3_default.maximumComponent(scaleScratch3);
};
var scaleScratch4 = new Cartesian3_default();
Matrix3.setRotation = function(matrix, rotation, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("result", result);
  const scale = Matrix3.getScale(matrix, scaleScratch4);
  result[0] = rotation[0] * scale.x;
  result[1] = rotation[1] * scale.x;
  result[2] = rotation[2] * scale.x;
  result[3] = rotation[3] * scale.y;
  result[4] = rotation[4] * scale.y;
  result[5] = rotation[5] * scale.y;
  result[6] = rotation[6] * scale.z;
  result[7] = rotation[7] * scale.z;
  result[8] = rotation[8] * scale.z;
  return result;
};
var scaleScratch5 = new Cartesian3_default();
Matrix3.getRotation = function(matrix, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("result", result);
  const scale = Matrix3.getScale(matrix, scaleScratch5);
  result[0] = matrix[0] / scale.x;
  result[1] = matrix[1] / scale.x;
  result[2] = matrix[2] / scale.x;
  result[3] = matrix[3] / scale.y;
  result[4] = matrix[4] / scale.y;
  result[5] = matrix[5] / scale.y;
  result[6] = matrix[6] / scale.z;
  result[7] = matrix[7] / scale.z;
  result[8] = matrix[8] / scale.z;
  return result;
};
Matrix3.multiply = function(left, right, result) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Check_default.typeOf.object("result", result);
  const column0Row0 = left[0] * right[0] + left[3] * right[1] + left[6] * right[2];
  const column0Row1 = left[1] * right[0] + left[4] * right[1] + left[7] * right[2];
  const column0Row2 = left[2] * right[0] + left[5] * right[1] + left[8] * right[2];
  const column1Row0 = left[0] * right[3] + left[3] * right[4] + left[6] * right[5];
  const column1Row1 = left[1] * right[3] + left[4] * right[4] + left[7] * right[5];
  const column1Row2 = left[2] * right[3] + left[5] * right[4] + left[8] * right[5];
  const column2Row0 = left[0] * right[6] + left[3] * right[7] + left[6] * right[8];
  const column2Row1 = left[1] * right[6] + left[4] * right[7] + left[7] * right[8];
  const column2Row2 = left[2] * right[6] + left[5] * right[7] + left[8] * right[8];
  result[0] = column0Row0;
  result[1] = column0Row1;
  result[2] = column0Row2;
  result[3] = column1Row0;
  result[4] = column1Row1;
  result[5] = column1Row2;
  result[6] = column2Row0;
  result[7] = column2Row1;
  result[8] = column2Row2;
  return result;
};
Matrix3.add = function(left, right, result) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Check_default.typeOf.object("result", result);
  result[0] = left[0] + right[0];
  result[1] = left[1] + right[1];
  result[2] = left[2] + right[2];
  result[3] = left[3] + right[3];
  result[4] = left[4] + right[4];
  result[5] = left[5] + right[5];
  result[6] = left[6] + right[6];
  result[7] = left[7] + right[7];
  result[8] = left[8] + right[8];
  return result;
};
Matrix3.subtract = function(left, right, result) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Check_default.typeOf.object("result", result);
  result[0] = left[0] - right[0];
  result[1] = left[1] - right[1];
  result[2] = left[2] - right[2];
  result[3] = left[3] - right[3];
  result[4] = left[4] - right[4];
  result[5] = left[5] - right[5];
  result[6] = left[6] - right[6];
  result[7] = left[7] - right[7];
  result[8] = left[8] - right[8];
  return result;
};
Matrix3.multiplyByVector = function(matrix, cartesian11, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("cartesian", cartesian11);
  Check_default.typeOf.object("result", result);
  const vX = cartesian11.x;
  const vY = cartesian11.y;
  const vZ = cartesian11.z;
  const x = matrix[0] * vX + matrix[3] * vY + matrix[6] * vZ;
  const y = matrix[1] * vX + matrix[4] * vY + matrix[7] * vZ;
  const z = matrix[2] * vX + matrix[5] * vY + matrix[8] * vZ;
  result.x = x;
  result.y = y;
  result.z = z;
  return result;
};
Matrix3.multiplyByScalar = function(matrix, scalar, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.number("scalar", scalar);
  Check_default.typeOf.object("result", result);
  result[0] = matrix[0] * scalar;
  result[1] = matrix[1] * scalar;
  result[2] = matrix[2] * scalar;
  result[3] = matrix[3] * scalar;
  result[4] = matrix[4] * scalar;
  result[5] = matrix[5] * scalar;
  result[6] = matrix[6] * scalar;
  result[7] = matrix[7] * scalar;
  result[8] = matrix[8] * scalar;
  return result;
};
Matrix3.multiplyByScale = function(matrix, scale, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("scale", scale);
  Check_default.typeOf.object("result", result);
  result[0] = matrix[0] * scale.x;
  result[1] = matrix[1] * scale.x;
  result[2] = matrix[2] * scale.x;
  result[3] = matrix[3] * scale.y;
  result[4] = matrix[4] * scale.y;
  result[5] = matrix[5] * scale.y;
  result[6] = matrix[6] * scale.z;
  result[7] = matrix[7] * scale.z;
  result[8] = matrix[8] * scale.z;
  return result;
};
Matrix3.multiplyByUniformScale = function(matrix, scale, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.number("scale", scale);
  Check_default.typeOf.object("result", result);
  result[0] = matrix[0] * scale;
  result[1] = matrix[1] * scale;
  result[2] = matrix[2] * scale;
  result[3] = matrix[3] * scale;
  result[4] = matrix[4] * scale;
  result[5] = matrix[5] * scale;
  result[6] = matrix[6] * scale;
  result[7] = matrix[7] * scale;
  result[8] = matrix[8] * scale;
  return result;
};
Matrix3.negate = function(matrix, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("result", result);
  result[0] = -matrix[0];
  result[1] = -matrix[1];
  result[2] = -matrix[2];
  result[3] = -matrix[3];
  result[4] = -matrix[4];
  result[5] = -matrix[5];
  result[6] = -matrix[6];
  result[7] = -matrix[7];
  result[8] = -matrix[8];
  return result;
};
Matrix3.transpose = function(matrix, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("result", result);
  const column0Row0 = matrix[0];
  const column0Row1 = matrix[3];
  const column0Row2 = matrix[6];
  const column1Row0 = matrix[1];
  const column1Row1 = matrix[4];
  const column1Row2 = matrix[7];
  const column2Row0 = matrix[2];
  const column2Row1 = matrix[5];
  const column2Row2 = matrix[8];
  result[0] = column0Row0;
  result[1] = column0Row1;
  result[2] = column0Row2;
  result[3] = column1Row0;
  result[4] = column1Row1;
  result[5] = column1Row2;
  result[6] = column2Row0;
  result[7] = column2Row1;
  result[8] = column2Row2;
  return result;
};
function computeFrobeniusNorm(matrix) {
  let norm = 0;
  for (let i = 0; i < 9; ++i) {
    const temp = matrix[i];
    norm += temp * temp;
  }
  return Math.sqrt(norm);
}
var rowVal = [1, 0, 0];
var colVal = [2, 2, 1];
function offDiagonalFrobeniusNorm(matrix) {
  let norm = 0;
  for (let i = 0; i < 3; ++i) {
    const temp = matrix[Matrix3.getElementIndex(colVal[i], rowVal[i])];
    norm += 2 * temp * temp;
  }
  return Math.sqrt(norm);
}
function shurDecomposition(matrix, result) {
  const tolerance = Math_default.EPSILON15;
  let maxDiagonal = 0;
  let rotAxis2 = 1;
  for (let i = 0; i < 3; ++i) {
    const temp = Math.abs(
      matrix[Matrix3.getElementIndex(colVal[i], rowVal[i])]
    );
    if (temp > maxDiagonal) {
      rotAxis2 = i;
      maxDiagonal = temp;
    }
  }
  let c = 1;
  let s = 0;
  const p = rowVal[rotAxis2];
  const q = colVal[rotAxis2];
  if (Math.abs(matrix[Matrix3.getElementIndex(q, p)]) > tolerance) {
    const qq = matrix[Matrix3.getElementIndex(q, q)];
    const pp = matrix[Matrix3.getElementIndex(p, p)];
    const qp = matrix[Matrix3.getElementIndex(q, p)];
    const tau = (qq - pp) / 2 / qp;
    let t;
    if (tau < 0) {
      t = -1 / (-tau + Math.sqrt(1 + tau * tau));
    } else {
      t = 1 / (tau + Math.sqrt(1 + tau * tau));
    }
    c = 1 / Math.sqrt(1 + t * t);
    s = t * c;
  }
  result = Matrix3.clone(Matrix3.IDENTITY, result);
  result[Matrix3.getElementIndex(p, p)] = result[Matrix3.getElementIndex(q, q)] = c;
  result[Matrix3.getElementIndex(q, p)] = s;
  result[Matrix3.getElementIndex(p, q)] = -s;
  return result;
}
var jMatrix = new Matrix3();
var jMatrixTranspose = new Matrix3();
Matrix3.computeEigenDecomposition = function(matrix, result) {
  Check_default.typeOf.object("matrix", matrix);
  const tolerance = Math_default.EPSILON20;
  const maxSweeps = 10;
  let count = 0;
  let sweep = 0;
  if (!defined_default(result)) {
    result = {};
  }
  const unitaryMatrix = result.unitary = Matrix3.clone(
    Matrix3.IDENTITY,
    result.unitary
  );
  const diagMatrix = result.diagonal = Matrix3.clone(matrix, result.diagonal);
  const epsilon = tolerance * computeFrobeniusNorm(diagMatrix);
  while (sweep < maxSweeps && offDiagonalFrobeniusNorm(diagMatrix) > epsilon) {
    shurDecomposition(diagMatrix, jMatrix);
    Matrix3.transpose(jMatrix, jMatrixTranspose);
    Matrix3.multiply(diagMatrix, jMatrix, diagMatrix);
    Matrix3.multiply(jMatrixTranspose, diagMatrix, diagMatrix);
    Matrix3.multiply(unitaryMatrix, jMatrix, unitaryMatrix);
    if (++count > 2) {
      ++sweep;
      count = 0;
    }
  }
  return result;
};
Matrix3.abs = function(matrix, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("result", result);
  result[0] = Math.abs(matrix[0]);
  result[1] = Math.abs(matrix[1]);
  result[2] = Math.abs(matrix[2]);
  result[3] = Math.abs(matrix[3]);
  result[4] = Math.abs(matrix[4]);
  result[5] = Math.abs(matrix[5]);
  result[6] = Math.abs(matrix[6]);
  result[7] = Math.abs(matrix[7]);
  result[8] = Math.abs(matrix[8]);
  return result;
};
Matrix3.determinant = function(matrix) {
  Check_default.typeOf.object("matrix", matrix);
  const m11 = matrix[0];
  const m21 = matrix[3];
  const m31 = matrix[6];
  const m12 = matrix[1];
  const m22 = matrix[4];
  const m32 = matrix[7];
  const m13 = matrix[2];
  const m23 = matrix[5];
  const m33 = matrix[8];
  return m11 * (m22 * m33 - m23 * m32) + m12 * (m23 * m31 - m21 * m33) + m13 * (m21 * m32 - m22 * m31);
};
Matrix3.inverse = function(matrix, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("result", result);
  const m11 = matrix[0];
  const m21 = matrix[1];
  const m31 = matrix[2];
  const m12 = matrix[3];
  const m22 = matrix[4];
  const m32 = matrix[5];
  const m13 = matrix[6];
  const m23 = matrix[7];
  const m33 = matrix[8];
  const determinant = Matrix3.determinant(matrix);
  if (Math.abs(determinant) <= Math_default.EPSILON15) {
    throw new DeveloperError_default("matrix is not invertible");
  }
  result[0] = m22 * m33 - m23 * m32;
  result[1] = m23 * m31 - m21 * m33;
  result[2] = m21 * m32 - m22 * m31;
  result[3] = m13 * m32 - m12 * m33;
  result[4] = m11 * m33 - m13 * m31;
  result[5] = m12 * m31 - m11 * m32;
  result[6] = m12 * m23 - m13 * m22;
  result[7] = m13 * m21 - m11 * m23;
  result[8] = m11 * m22 - m12 * m21;
  const scale = 1 / determinant;
  return Matrix3.multiplyByScalar(result, scale, result);
};
var scratchTransposeMatrix = new Matrix3();
Matrix3.inverseTranspose = function(matrix, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("result", result);
  return Matrix3.inverse(
    Matrix3.transpose(matrix, scratchTransposeMatrix),
    result
  );
};
Matrix3.equals = function(left, right) {
  return left === right || defined_default(left) && defined_default(right) && left[0] === right[0] && left[1] === right[1] && left[2] === right[2] && left[3] === right[3] && left[4] === right[4] && left[5] === right[5] && left[6] === right[6] && left[7] === right[7] && left[8] === right[8];
};
Matrix3.equalsEpsilon = function(left, right, epsilon) {
  epsilon = defaultValue_default(epsilon, 0);
  return left === right || defined_default(left) && defined_default(right) && Math.abs(left[0] - right[0]) <= epsilon && Math.abs(left[1] - right[1]) <= epsilon && Math.abs(left[2] - right[2]) <= epsilon && Math.abs(left[3] - right[3]) <= epsilon && Math.abs(left[4] - right[4]) <= epsilon && Math.abs(left[5] - right[5]) <= epsilon && Math.abs(left[6] - right[6]) <= epsilon && Math.abs(left[7] - right[7]) <= epsilon && Math.abs(left[8] - right[8]) <= epsilon;
};
Matrix3.IDENTITY = Object.freeze(
  new Matrix3(1, 0, 0, 0, 1, 0, 0, 0, 1)
);
Matrix3.ZERO = Object.freeze(
  new Matrix3(0, 0, 0, 0, 0, 0, 0, 0, 0)
);
Matrix3.COLUMN0ROW0 = 0;
Matrix3.COLUMN0ROW1 = 1;
Matrix3.COLUMN0ROW2 = 2;
Matrix3.COLUMN1ROW0 = 3;
Matrix3.COLUMN1ROW1 = 4;
Matrix3.COLUMN1ROW2 = 5;
Matrix3.COLUMN2ROW0 = 6;
Matrix3.COLUMN2ROW1 = 7;
Matrix3.COLUMN2ROW2 = 8;
Object.defineProperties(Matrix3.prototype, {
  length: {
    get: function() {
      return Matrix3.packedLength;
    }
  }
});
Matrix3.prototype.clone = function(result) {
  return Matrix3.clone(this, result);
};
Matrix3.prototype.equals = function(right) {
  return Matrix3.equals(this, right);
};
Matrix3.equalsArray = function(matrix, array, offset2) {
  return matrix[0] === array[offset2] && matrix[1] === array[offset2 + 1] && matrix[2] === array[offset2 + 2] && matrix[3] === array[offset2 + 3] && matrix[4] === array[offset2 + 4] && matrix[5] === array[offset2 + 5] && matrix[6] === array[offset2 + 6] && matrix[7] === array[offset2 + 7] && matrix[8] === array[offset2 + 8];
};
Matrix3.prototype.equalsEpsilon = function(right, epsilon) {
  return Matrix3.equalsEpsilon(this, right, epsilon);
};
Matrix3.prototype.toString = function() {
  return `(${this[0]}, ${this[3]}, ${this[6]})
(${this[1]}, ${this[4]}, ${this[7]})
(${this[2]}, ${this[5]}, ${this[8]})`;
};
var Matrix3_default = Matrix3;

// Source/Core/Cartesian4.js
function Cartesian4(x, y, z, w) {
  this.x = defaultValue_default(x, 0);
  this.y = defaultValue_default(y, 0);
  this.z = defaultValue_default(z, 0);
  this.w = defaultValue_default(w, 0);
}
Cartesian4.fromElements = function(x, y, z, w, result) {
  if (!defined_default(result)) {
    return new Cartesian4(x, y, z, w);
  }
  result.x = x;
  result.y = y;
  result.z = z;
  result.w = w;
  return result;
};
Cartesian4.fromColor = function(color, result) {
  Check_default.typeOf.object("color", color);
  if (!defined_default(result)) {
    return new Cartesian4(color.red, color.green, color.blue, color.alpha);
  }
  result.x = color.red;
  result.y = color.green;
  result.z = color.blue;
  result.w = color.alpha;
  return result;
};
Cartesian4.clone = function(cartesian11, result) {
  if (!defined_default(cartesian11)) {
    return void 0;
  }
  if (!defined_default(result)) {
    return new Cartesian4(cartesian11.x, cartesian11.y, cartesian11.z, cartesian11.w);
  }
  result.x = cartesian11.x;
  result.y = cartesian11.y;
  result.z = cartesian11.z;
  result.w = cartesian11.w;
  return result;
};
Cartesian4.packedLength = 4;
Cartesian4.pack = function(value, array, startingIndex) {
  Check_default.typeOf.object("value", value);
  Check_default.defined("array", array);
  startingIndex = defaultValue_default(startingIndex, 0);
  array[startingIndex++] = value.x;
  array[startingIndex++] = value.y;
  array[startingIndex++] = value.z;
  array[startingIndex] = value.w;
  return array;
};
Cartesian4.unpack = function(array, startingIndex, result) {
  Check_default.defined("array", array);
  startingIndex = defaultValue_default(startingIndex, 0);
  if (!defined_default(result)) {
    result = new Cartesian4();
  }
  result.x = array[startingIndex++];
  result.y = array[startingIndex++];
  result.z = array[startingIndex++];
  result.w = array[startingIndex];
  return result;
};
Cartesian4.packArray = function(array, result) {
  Check_default.defined("array", array);
  const length3 = array.length;
  const resultLength = length3 * 4;
  if (!defined_default(result)) {
    result = new Array(resultLength);
  } else if (!Array.isArray(result) && result.length !== resultLength) {
    throw new DeveloperError_default(
      "If result is a typed array, it must have exactly array.length * 4 elements"
    );
  } else if (result.length !== resultLength) {
    result.length = resultLength;
  }
  for (let i = 0; i < length3; ++i) {
    Cartesian4.pack(array[i], result, i * 4);
  }
  return result;
};
Cartesian4.unpackArray = function(array, result) {
  Check_default.defined("array", array);
  Check_default.typeOf.number.greaterThanOrEquals("array.length", array.length, 4);
  if (array.length % 4 !== 0) {
    throw new DeveloperError_default("array length must be a multiple of 4.");
  }
  const length3 = array.length;
  if (!defined_default(result)) {
    result = new Array(length3 / 4);
  } else {
    result.length = length3 / 4;
  }
  for (let i = 0; i < length3; i += 4) {
    const index = i / 4;
    result[index] = Cartesian4.unpack(array, i, result[index]);
  }
  return result;
};
Cartesian4.fromArray = Cartesian4.unpack;
Cartesian4.maximumComponent = function(cartesian11) {
  Check_default.typeOf.object("cartesian", cartesian11);
  return Math.max(cartesian11.x, cartesian11.y, cartesian11.z, cartesian11.w);
};
Cartesian4.minimumComponent = function(cartesian11) {
  Check_default.typeOf.object("cartesian", cartesian11);
  return Math.min(cartesian11.x, cartesian11.y, cartesian11.z, cartesian11.w);
};
Cartesian4.minimumByComponent = function(first, second, result) {
  Check_default.typeOf.object("first", first);
  Check_default.typeOf.object("second", second);
  Check_default.typeOf.object("result", result);
  result.x = Math.min(first.x, second.x);
  result.y = Math.min(first.y, second.y);
  result.z = Math.min(first.z, second.z);
  result.w = Math.min(first.w, second.w);
  return result;
};
Cartesian4.maximumByComponent = function(first, second, result) {
  Check_default.typeOf.object("first", first);
  Check_default.typeOf.object("second", second);
  Check_default.typeOf.object("result", result);
  result.x = Math.max(first.x, second.x);
  result.y = Math.max(first.y, second.y);
  result.z = Math.max(first.z, second.z);
  result.w = Math.max(first.w, second.w);
  return result;
};
Cartesian4.clamp = function(value, min3, max3, result) {
  Check_default.typeOf.object("value", value);
  Check_default.typeOf.object("min", min3);
  Check_default.typeOf.object("max", max3);
  Check_default.typeOf.object("result", result);
  const x = Math_default.clamp(value.x, min3.x, max3.x);
  const y = Math_default.clamp(value.y, min3.y, max3.y);
  const z = Math_default.clamp(value.z, min3.z, max3.z);
  const w = Math_default.clamp(value.w, min3.w, max3.w);
  result.x = x;
  result.y = y;
  result.z = z;
  result.w = w;
  return result;
};
Cartesian4.magnitudeSquared = function(cartesian11) {
  Check_default.typeOf.object("cartesian", cartesian11);
  return cartesian11.x * cartesian11.x + cartesian11.y * cartesian11.y + cartesian11.z * cartesian11.z + cartesian11.w * cartesian11.w;
};
Cartesian4.magnitude = function(cartesian11) {
  return Math.sqrt(Cartesian4.magnitudeSquared(cartesian11));
};
var distanceScratch2 = new Cartesian4();
Cartesian4.distance = function(left, right) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Cartesian4.subtract(left, right, distanceScratch2);
  return Cartesian4.magnitude(distanceScratch2);
};
Cartesian4.distanceSquared = function(left, right) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Cartesian4.subtract(left, right, distanceScratch2);
  return Cartesian4.magnitudeSquared(distanceScratch2);
};
Cartesian4.normalize = function(cartesian11, result) {
  Check_default.typeOf.object("cartesian", cartesian11);
  Check_default.typeOf.object("result", result);
  const magnitude = Cartesian4.magnitude(cartesian11);
  result.x = cartesian11.x / magnitude;
  result.y = cartesian11.y / magnitude;
  result.z = cartesian11.z / magnitude;
  result.w = cartesian11.w / magnitude;
  if (isNaN(result.x) || isNaN(result.y) || isNaN(result.z) || isNaN(result.w)) {
    throw new DeveloperError_default("normalized result is not a number");
  }
  return result;
};
Cartesian4.dot = function(left, right) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  return left.x * right.x + left.y * right.y + left.z * right.z + left.w * right.w;
};
Cartesian4.multiplyComponents = function(left, right, result) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Check_default.typeOf.object("result", result);
  result.x = left.x * right.x;
  result.y = left.y * right.y;
  result.z = left.z * right.z;
  result.w = left.w * right.w;
  return result;
};
Cartesian4.divideComponents = function(left, right, result) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Check_default.typeOf.object("result", result);
  result.x = left.x / right.x;
  result.y = left.y / right.y;
  result.z = left.z / right.z;
  result.w = left.w / right.w;
  return result;
};
Cartesian4.add = function(left, right, result) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Check_default.typeOf.object("result", result);
  result.x = left.x + right.x;
  result.y = left.y + right.y;
  result.z = left.z + right.z;
  result.w = left.w + right.w;
  return result;
};
Cartesian4.subtract = function(left, right, result) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Check_default.typeOf.object("result", result);
  result.x = left.x - right.x;
  result.y = left.y - right.y;
  result.z = left.z - right.z;
  result.w = left.w - right.w;
  return result;
};
Cartesian4.multiplyByScalar = function(cartesian11, scalar, result) {
  Check_default.typeOf.object("cartesian", cartesian11);
  Check_default.typeOf.number("scalar", scalar);
  Check_default.typeOf.object("result", result);
  result.x = cartesian11.x * scalar;
  result.y = cartesian11.y * scalar;
  result.z = cartesian11.z * scalar;
  result.w = cartesian11.w * scalar;
  return result;
};
Cartesian4.divideByScalar = function(cartesian11, scalar, result) {
  Check_default.typeOf.object("cartesian", cartesian11);
  Check_default.typeOf.number("scalar", scalar);
  Check_default.typeOf.object("result", result);
  result.x = cartesian11.x / scalar;
  result.y = cartesian11.y / scalar;
  result.z = cartesian11.z / scalar;
  result.w = cartesian11.w / scalar;
  return result;
};
Cartesian4.negate = function(cartesian11, result) {
  Check_default.typeOf.object("cartesian", cartesian11);
  Check_default.typeOf.object("result", result);
  result.x = -cartesian11.x;
  result.y = -cartesian11.y;
  result.z = -cartesian11.z;
  result.w = -cartesian11.w;
  return result;
};
Cartesian4.abs = function(cartesian11, result) {
  Check_default.typeOf.object("cartesian", cartesian11);
  Check_default.typeOf.object("result", result);
  result.x = Math.abs(cartesian11.x);
  result.y = Math.abs(cartesian11.y);
  result.z = Math.abs(cartesian11.z);
  result.w = Math.abs(cartesian11.w);
  return result;
};
var lerpScratch2 = new Cartesian4();
Cartesian4.lerp = function(start, end, t, result) {
  Check_default.typeOf.object("start", start);
  Check_default.typeOf.object("end", end);
  Check_default.typeOf.number("t", t);
  Check_default.typeOf.object("result", result);
  Cartesian4.multiplyByScalar(end, t, lerpScratch2);
  result = Cartesian4.multiplyByScalar(start, 1 - t, result);
  return Cartesian4.add(lerpScratch2, result, result);
};
var mostOrthogonalAxisScratch2 = new Cartesian4();
Cartesian4.mostOrthogonalAxis = function(cartesian11, result) {
  Check_default.typeOf.object("cartesian", cartesian11);
  Check_default.typeOf.object("result", result);
  const f = Cartesian4.normalize(cartesian11, mostOrthogonalAxisScratch2);
  Cartesian4.abs(f, f);
  if (f.x <= f.y) {
    if (f.x <= f.z) {
      if (f.x <= f.w) {
        result = Cartesian4.clone(Cartesian4.UNIT_X, result);
      } else {
        result = Cartesian4.clone(Cartesian4.UNIT_W, result);
      }
    } else if (f.z <= f.w) {
      result = Cartesian4.clone(Cartesian4.UNIT_Z, result);
    } else {
      result = Cartesian4.clone(Cartesian4.UNIT_W, result);
    }
  } else if (f.y <= f.z) {
    if (f.y <= f.w) {
      result = Cartesian4.clone(Cartesian4.UNIT_Y, result);
    } else {
      result = Cartesian4.clone(Cartesian4.UNIT_W, result);
    }
  } else if (f.z <= f.w) {
    result = Cartesian4.clone(Cartesian4.UNIT_Z, result);
  } else {
    result = Cartesian4.clone(Cartesian4.UNIT_W, result);
  }
  return result;
};
Cartesian4.equals = function(left, right) {
  return left === right || defined_default(left) && defined_default(right) && left.x === right.x && left.y === right.y && left.z === right.z && left.w === right.w;
};
Cartesian4.equalsArray = function(cartesian11, array, offset2) {
  return cartesian11.x === array[offset2] && cartesian11.y === array[offset2 + 1] && cartesian11.z === array[offset2 + 2] && cartesian11.w === array[offset2 + 3];
};
Cartesian4.equalsEpsilon = function(left, right, relativeEpsilon, absoluteEpsilon) {
  return left === right || defined_default(left) && defined_default(right) && Math_default.equalsEpsilon(
    left.x,
    right.x,
    relativeEpsilon,
    absoluteEpsilon
  ) && Math_default.equalsEpsilon(
    left.y,
    right.y,
    relativeEpsilon,
    absoluteEpsilon
  ) && Math_default.equalsEpsilon(
    left.z,
    right.z,
    relativeEpsilon,
    absoluteEpsilon
  ) && Math_default.equalsEpsilon(
    left.w,
    right.w,
    relativeEpsilon,
    absoluteEpsilon
  );
};
Cartesian4.ZERO = Object.freeze(new Cartesian4(0, 0, 0, 0));
Cartesian4.ONE = Object.freeze(new Cartesian4(1, 1, 1, 1));
Cartesian4.UNIT_X = Object.freeze(new Cartesian4(1, 0, 0, 0));
Cartesian4.UNIT_Y = Object.freeze(new Cartesian4(0, 1, 0, 0));
Cartesian4.UNIT_Z = Object.freeze(new Cartesian4(0, 0, 1, 0));
Cartesian4.UNIT_W = Object.freeze(new Cartesian4(0, 0, 0, 1));
Cartesian4.prototype.clone = function(result) {
  return Cartesian4.clone(this, result);
};
Cartesian4.prototype.equals = function(right) {
  return Cartesian4.equals(this, right);
};
Cartesian4.prototype.equalsEpsilon = function(right, relativeEpsilon, absoluteEpsilon) {
  return Cartesian4.equalsEpsilon(
    this,
    right,
    relativeEpsilon,
    absoluteEpsilon
  );
};
Cartesian4.prototype.toString = function() {
  return `(${this.x}, ${this.y}, ${this.z}, ${this.w})`;
};
var scratchF32Array = new Float32Array(1);
var scratchU8Array = new Uint8Array(scratchF32Array.buffer);
var testU32 = new Uint32Array([287454020]);
var testU8 = new Uint8Array(testU32.buffer);
var littleEndian = testU8[0] === 68;
Cartesian4.packFloat = function(value, result) {
  Check_default.typeOf.number("value", value);
  if (!defined_default(result)) {
    result = new Cartesian4();
  }
  scratchF32Array[0] = value;
  if (littleEndian) {
    result.x = scratchU8Array[0];
    result.y = scratchU8Array[1];
    result.z = scratchU8Array[2];
    result.w = scratchU8Array[3];
  } else {
    result.x = scratchU8Array[3];
    result.y = scratchU8Array[2];
    result.z = scratchU8Array[1];
    result.w = scratchU8Array[0];
  }
  return result;
};
Cartesian4.unpackFloat = function(packedFloat) {
  Check_default.typeOf.object("packedFloat", packedFloat);
  if (littleEndian) {
    scratchU8Array[0] = packedFloat.x;
    scratchU8Array[1] = packedFloat.y;
    scratchU8Array[2] = packedFloat.z;
    scratchU8Array[3] = packedFloat.w;
  } else {
    scratchU8Array[0] = packedFloat.w;
    scratchU8Array[1] = packedFloat.z;
    scratchU8Array[2] = packedFloat.y;
    scratchU8Array[3] = packedFloat.x;
  }
  return scratchF32Array[0];
};
var Cartesian4_default = Cartesian4;

// Source/Core/RuntimeError.js
function RuntimeError(message) {
  this.name = "RuntimeError";
  this.message = message;
  let stack;
  try {
    throw new Error();
  } catch (e) {
    stack = e.stack;
  }
  this.stack = stack;
}
if (defined_default(Object.create)) {
  RuntimeError.prototype = Object.create(Error.prototype);
  RuntimeError.prototype.constructor = RuntimeError;
}
RuntimeError.prototype.toString = function() {
  let str = `${this.name}: ${this.message}`;
  if (defined_default(this.stack)) {
    str += `
${this.stack.toString()}`;
  }
  return str;
};
var RuntimeError_default = RuntimeError;

// Source/Core/Matrix4.js
function Matrix4(column0Row0, column1Row0, column2Row0, column3Row0, column0Row1, column1Row1, column2Row1, column3Row1, column0Row2, column1Row2, column2Row2, column3Row2, column0Row3, column1Row3, column2Row3, column3Row3) {
  this[0] = defaultValue_default(column0Row0, 0);
  this[1] = defaultValue_default(column0Row1, 0);
  this[2] = defaultValue_default(column0Row2, 0);
  this[3] = defaultValue_default(column0Row3, 0);
  this[4] = defaultValue_default(column1Row0, 0);
  this[5] = defaultValue_default(column1Row1, 0);
  this[6] = defaultValue_default(column1Row2, 0);
  this[7] = defaultValue_default(column1Row3, 0);
  this[8] = defaultValue_default(column2Row0, 0);
  this[9] = defaultValue_default(column2Row1, 0);
  this[10] = defaultValue_default(column2Row2, 0);
  this[11] = defaultValue_default(column2Row3, 0);
  this[12] = defaultValue_default(column3Row0, 0);
  this[13] = defaultValue_default(column3Row1, 0);
  this[14] = defaultValue_default(column3Row2, 0);
  this[15] = defaultValue_default(column3Row3, 0);
}
Matrix4.packedLength = 16;
Matrix4.pack = function(value, array, startingIndex) {
  Check_default.typeOf.object("value", value);
  Check_default.defined("array", array);
  startingIndex = defaultValue_default(startingIndex, 0);
  array[startingIndex++] = value[0];
  array[startingIndex++] = value[1];
  array[startingIndex++] = value[2];
  array[startingIndex++] = value[3];
  array[startingIndex++] = value[4];
  array[startingIndex++] = value[5];
  array[startingIndex++] = value[6];
  array[startingIndex++] = value[7];
  array[startingIndex++] = value[8];
  array[startingIndex++] = value[9];
  array[startingIndex++] = value[10];
  array[startingIndex++] = value[11];
  array[startingIndex++] = value[12];
  array[startingIndex++] = value[13];
  array[startingIndex++] = value[14];
  array[startingIndex] = value[15];
  return array;
};
Matrix4.unpack = function(array, startingIndex, result) {
  Check_default.defined("array", array);
  startingIndex = defaultValue_default(startingIndex, 0);
  if (!defined_default(result)) {
    result = new Matrix4();
  }
  result[0] = array[startingIndex++];
  result[1] = array[startingIndex++];
  result[2] = array[startingIndex++];
  result[3] = array[startingIndex++];
  result[4] = array[startingIndex++];
  result[5] = array[startingIndex++];
  result[6] = array[startingIndex++];
  result[7] = array[startingIndex++];
  result[8] = array[startingIndex++];
  result[9] = array[startingIndex++];
  result[10] = array[startingIndex++];
  result[11] = array[startingIndex++];
  result[12] = array[startingIndex++];
  result[13] = array[startingIndex++];
  result[14] = array[startingIndex++];
  result[15] = array[startingIndex];
  return result;
};
Matrix4.packArray = function(array, result) {
  Check_default.defined("array", array);
  const length3 = array.length;
  const resultLength = length3 * 16;
  if (!defined_default(result)) {
    result = new Array(resultLength);
  } else if (!Array.isArray(result) && result.length !== resultLength) {
    throw new DeveloperError_default(
      "If result is a typed array, it must have exactly array.length * 16 elements"
    );
  } else if (result.length !== resultLength) {
    result.length = resultLength;
  }
  for (let i = 0; i < length3; ++i) {
    Matrix4.pack(array[i], result, i * 16);
  }
  return result;
};
Matrix4.unpackArray = function(array, result) {
  Check_default.defined("array", array);
  Check_default.typeOf.number.greaterThanOrEquals("array.length", array.length, 16);
  if (array.length % 16 !== 0) {
    throw new DeveloperError_default("array length must be a multiple of 16.");
  }
  const length3 = array.length;
  if (!defined_default(result)) {
    result = new Array(length3 / 16);
  } else {
    result.length = length3 / 16;
  }
  for (let i = 0; i < length3; i += 16) {
    const index = i / 16;
    result[index] = Matrix4.unpack(array, i, result[index]);
  }
  return result;
};
Matrix4.clone = function(matrix, result) {
  if (!defined_default(matrix)) {
    return void 0;
  }
  if (!defined_default(result)) {
    return new Matrix4(
      matrix[0],
      matrix[4],
      matrix[8],
      matrix[12],
      matrix[1],
      matrix[5],
      matrix[9],
      matrix[13],
      matrix[2],
      matrix[6],
      matrix[10],
      matrix[14],
      matrix[3],
      matrix[7],
      matrix[11],
      matrix[15]
    );
  }
  result[0] = matrix[0];
  result[1] = matrix[1];
  result[2] = matrix[2];
  result[3] = matrix[3];
  result[4] = matrix[4];
  result[5] = matrix[5];
  result[6] = matrix[6];
  result[7] = matrix[7];
  result[8] = matrix[8];
  result[9] = matrix[9];
  result[10] = matrix[10];
  result[11] = matrix[11];
  result[12] = matrix[12];
  result[13] = matrix[13];
  result[14] = matrix[14];
  result[15] = matrix[15];
  return result;
};
Matrix4.fromArray = Matrix4.unpack;
Matrix4.fromColumnMajorArray = function(values, result) {
  Check_default.defined("values", values);
  return Matrix4.clone(values, result);
};
Matrix4.fromRowMajorArray = function(values, result) {
  Check_default.defined("values", values);
  if (!defined_default(result)) {
    return new Matrix4(
      values[0],
      values[1],
      values[2],
      values[3],
      values[4],
      values[5],
      values[6],
      values[7],
      values[8],
      values[9],
      values[10],
      values[11],
      values[12],
      values[13],
      values[14],
      values[15]
    );
  }
  result[0] = values[0];
  result[1] = values[4];
  result[2] = values[8];
  result[3] = values[12];
  result[4] = values[1];
  result[5] = values[5];
  result[6] = values[9];
  result[7] = values[13];
  result[8] = values[2];
  result[9] = values[6];
  result[10] = values[10];
  result[11] = values[14];
  result[12] = values[3];
  result[13] = values[7];
  result[14] = values[11];
  result[15] = values[15];
  return result;
};
Matrix4.fromRotationTranslation = function(rotation, translation3, result) {
  Check_default.typeOf.object("rotation", rotation);
  translation3 = defaultValue_default(translation3, Cartesian3_default.ZERO);
  if (!defined_default(result)) {
    return new Matrix4(
      rotation[0],
      rotation[3],
      rotation[6],
      translation3.x,
      rotation[1],
      rotation[4],
      rotation[7],
      translation3.y,
      rotation[2],
      rotation[5],
      rotation[8],
      translation3.z,
      0,
      0,
      0,
      1
    );
  }
  result[0] = rotation[0];
  result[1] = rotation[1];
  result[2] = rotation[2];
  result[3] = 0;
  result[4] = rotation[3];
  result[5] = rotation[4];
  result[6] = rotation[5];
  result[7] = 0;
  result[8] = rotation[6];
  result[9] = rotation[7];
  result[10] = rotation[8];
  result[11] = 0;
  result[12] = translation3.x;
  result[13] = translation3.y;
  result[14] = translation3.z;
  result[15] = 1;
  return result;
};
Matrix4.fromTranslationQuaternionRotationScale = function(translation3, rotation, scale, result) {
  Check_default.typeOf.object("translation", translation3);
  Check_default.typeOf.object("rotation", rotation);
  Check_default.typeOf.object("scale", scale);
  if (!defined_default(result)) {
    result = new Matrix4();
  }
  const scaleX = scale.x;
  const scaleY = scale.y;
  const scaleZ = scale.z;
  const x2 = rotation.x * rotation.x;
  const xy = rotation.x * rotation.y;
  const xz = rotation.x * rotation.z;
  const xw = rotation.x * rotation.w;
  const y2 = rotation.y * rotation.y;
  const yz = rotation.y * rotation.z;
  const yw = rotation.y * rotation.w;
  const z2 = rotation.z * rotation.z;
  const zw = rotation.z * rotation.w;
  const w2 = rotation.w * rotation.w;
  const m00 = x2 - y2 - z2 + w2;
  const m01 = 2 * (xy - zw);
  const m02 = 2 * (xz + yw);
  const m10 = 2 * (xy + zw);
  const m11 = -x2 + y2 - z2 + w2;
  const m12 = 2 * (yz - xw);
  const m20 = 2 * (xz - yw);
  const m21 = 2 * (yz + xw);
  const m22 = -x2 - y2 + z2 + w2;
  result[0] = m00 * scaleX;
  result[1] = m10 * scaleX;
  result[2] = m20 * scaleX;
  result[3] = 0;
  result[4] = m01 * scaleY;
  result[5] = m11 * scaleY;
  result[6] = m21 * scaleY;
  result[7] = 0;
  result[8] = m02 * scaleZ;
  result[9] = m12 * scaleZ;
  result[10] = m22 * scaleZ;
  result[11] = 0;
  result[12] = translation3.x;
  result[13] = translation3.y;
  result[14] = translation3.z;
  result[15] = 1;
  return result;
};
Matrix4.fromTranslationRotationScale = function(translationRotationScale, result) {
  Check_default.typeOf.object("translationRotationScale", translationRotationScale);
  return Matrix4.fromTranslationQuaternionRotationScale(
    translationRotationScale.translation,
    translationRotationScale.rotation,
    translationRotationScale.scale,
    result
  );
};
Matrix4.fromTranslation = function(translation3, result) {
  Check_default.typeOf.object("translation", translation3);
  return Matrix4.fromRotationTranslation(Matrix3_default.IDENTITY, translation3, result);
};
Matrix4.fromScale = function(scale, result) {
  Check_default.typeOf.object("scale", scale);
  if (!defined_default(result)) {
    return new Matrix4(
      scale.x,
      0,
      0,
      0,
      0,
      scale.y,
      0,
      0,
      0,
      0,
      scale.z,
      0,
      0,
      0,
      0,
      1
    );
  }
  result[0] = scale.x;
  result[1] = 0;
  result[2] = 0;
  result[3] = 0;
  result[4] = 0;
  result[5] = scale.y;
  result[6] = 0;
  result[7] = 0;
  result[8] = 0;
  result[9] = 0;
  result[10] = scale.z;
  result[11] = 0;
  result[12] = 0;
  result[13] = 0;
  result[14] = 0;
  result[15] = 1;
  return result;
};
Matrix4.fromUniformScale = function(scale, result) {
  Check_default.typeOf.number("scale", scale);
  if (!defined_default(result)) {
    return new Matrix4(
      scale,
      0,
      0,
      0,
      0,
      scale,
      0,
      0,
      0,
      0,
      scale,
      0,
      0,
      0,
      0,
      1
    );
  }
  result[0] = scale;
  result[1] = 0;
  result[2] = 0;
  result[3] = 0;
  result[4] = 0;
  result[5] = scale;
  result[6] = 0;
  result[7] = 0;
  result[8] = 0;
  result[9] = 0;
  result[10] = scale;
  result[11] = 0;
  result[12] = 0;
  result[13] = 0;
  result[14] = 0;
  result[15] = 1;
  return result;
};
Matrix4.fromRotation = function(rotation, result) {
  Check_default.typeOf.object("rotation", rotation);
  if (!defined_default(result)) {
    result = new Matrix4();
  }
  result[0] = rotation[0];
  result[1] = rotation[1];
  result[2] = rotation[2];
  result[3] = 0;
  result[4] = rotation[3];
  result[5] = rotation[4];
  result[6] = rotation[5];
  result[7] = 0;
  result[8] = rotation[6];
  result[9] = rotation[7];
  result[10] = rotation[8];
  result[11] = 0;
  result[12] = 0;
  result[13] = 0;
  result[14] = 0;
  result[15] = 1;
  return result;
};
var fromCameraF = new Cartesian3_default();
var fromCameraR = new Cartesian3_default();
var fromCameraU = new Cartesian3_default();
Matrix4.fromCamera = function(camera, result) {
  Check_default.typeOf.object("camera", camera);
  const position = camera.position;
  const direction2 = camera.direction;
  const up = camera.up;
  Check_default.typeOf.object("camera.position", position);
  Check_default.typeOf.object("camera.direction", direction2);
  Check_default.typeOf.object("camera.up", up);
  Cartesian3_default.normalize(direction2, fromCameraF);
  Cartesian3_default.normalize(
    Cartesian3_default.cross(fromCameraF, up, fromCameraR),
    fromCameraR
  );
  Cartesian3_default.normalize(
    Cartesian3_default.cross(fromCameraR, fromCameraF, fromCameraU),
    fromCameraU
  );
  const sX = fromCameraR.x;
  const sY = fromCameraR.y;
  const sZ = fromCameraR.z;
  const fX = fromCameraF.x;
  const fY = fromCameraF.y;
  const fZ = fromCameraF.z;
  const uX = fromCameraU.x;
  const uY = fromCameraU.y;
  const uZ = fromCameraU.z;
  const positionX = position.x;
  const positionY = position.y;
  const positionZ = position.z;
  const t0 = sX * -positionX + sY * -positionY + sZ * -positionZ;
  const t1 = uX * -positionX + uY * -positionY + uZ * -positionZ;
  const t2 = fX * positionX + fY * positionY + fZ * positionZ;
  if (!defined_default(result)) {
    return new Matrix4(
      sX,
      sY,
      sZ,
      t0,
      uX,
      uY,
      uZ,
      t1,
      -fX,
      -fY,
      -fZ,
      t2,
      0,
      0,
      0,
      1
    );
  }
  result[0] = sX;
  result[1] = uX;
  result[2] = -fX;
  result[3] = 0;
  result[4] = sY;
  result[5] = uY;
  result[6] = -fY;
  result[7] = 0;
  result[8] = sZ;
  result[9] = uZ;
  result[10] = -fZ;
  result[11] = 0;
  result[12] = t0;
  result[13] = t1;
  result[14] = t2;
  result[15] = 1;
  return result;
};
Matrix4.computePerspectiveFieldOfView = function(fovY, aspectRatio, near, far, result) {
  Check_default.typeOf.number.greaterThan("fovY", fovY, 0);
  Check_default.typeOf.number.lessThan("fovY", fovY, Math.PI);
  Check_default.typeOf.number.greaterThan("near", near, 0);
  Check_default.typeOf.number.greaterThan("far", far, 0);
  Check_default.typeOf.object("result", result);
  const bottom = Math.tan(fovY * 0.5);
  const column1Row1 = 1 / bottom;
  const column0Row0 = column1Row1 / aspectRatio;
  const column2Row2 = (far + near) / (near - far);
  const column3Row2 = 2 * far * near / (near - far);
  result[0] = column0Row0;
  result[1] = 0;
  result[2] = 0;
  result[3] = 0;
  result[4] = 0;
  result[5] = column1Row1;
  result[6] = 0;
  result[7] = 0;
  result[8] = 0;
  result[9] = 0;
  result[10] = column2Row2;
  result[11] = -1;
  result[12] = 0;
  result[13] = 0;
  result[14] = column3Row2;
  result[15] = 0;
  return result;
};
Matrix4.computeOrthographicOffCenter = function(left, right, bottom, top, near, far, result) {
  Check_default.typeOf.number("left", left);
  Check_default.typeOf.number("right", right);
  Check_default.typeOf.number("bottom", bottom);
  Check_default.typeOf.number("top", top);
  Check_default.typeOf.number("near", near);
  Check_default.typeOf.number("far", far);
  Check_default.typeOf.object("result", result);
  let a3 = 1 / (right - left);
  let b = 1 / (top - bottom);
  let c = 1 / (far - near);
  const tx = -(right + left) * a3;
  const ty = -(top + bottom) * b;
  const tz = -(far + near) * c;
  a3 *= 2;
  b *= 2;
  c *= -2;
  result[0] = a3;
  result[1] = 0;
  result[2] = 0;
  result[3] = 0;
  result[4] = 0;
  result[5] = b;
  result[6] = 0;
  result[7] = 0;
  result[8] = 0;
  result[9] = 0;
  result[10] = c;
  result[11] = 0;
  result[12] = tx;
  result[13] = ty;
  result[14] = tz;
  result[15] = 1;
  return result;
};
Matrix4.computePerspectiveOffCenter = function(left, right, bottom, top, near, far, result) {
  Check_default.typeOf.number("left", left);
  Check_default.typeOf.number("right", right);
  Check_default.typeOf.number("bottom", bottom);
  Check_default.typeOf.number("top", top);
  Check_default.typeOf.number("near", near);
  Check_default.typeOf.number("far", far);
  Check_default.typeOf.object("result", result);
  const column0Row0 = 2 * near / (right - left);
  const column1Row1 = 2 * near / (top - bottom);
  const column2Row0 = (right + left) / (right - left);
  const column2Row1 = (top + bottom) / (top - bottom);
  const column2Row2 = -(far + near) / (far - near);
  const column2Row3 = -1;
  const column3Row2 = -2 * far * near / (far - near);
  result[0] = column0Row0;
  result[1] = 0;
  result[2] = 0;
  result[3] = 0;
  result[4] = 0;
  result[5] = column1Row1;
  result[6] = 0;
  result[7] = 0;
  result[8] = column2Row0;
  result[9] = column2Row1;
  result[10] = column2Row2;
  result[11] = column2Row3;
  result[12] = 0;
  result[13] = 0;
  result[14] = column3Row2;
  result[15] = 0;
  return result;
};
Matrix4.computeInfinitePerspectiveOffCenter = function(left, right, bottom, top, near, result) {
  Check_default.typeOf.number("left", left);
  Check_default.typeOf.number("right", right);
  Check_default.typeOf.number("bottom", bottom);
  Check_default.typeOf.number("top", top);
  Check_default.typeOf.number("near", near);
  Check_default.typeOf.object("result", result);
  const column0Row0 = 2 * near / (right - left);
  const column1Row1 = 2 * near / (top - bottom);
  const column2Row0 = (right + left) / (right - left);
  const column2Row1 = (top + bottom) / (top - bottom);
  const column2Row2 = -1;
  const column2Row3 = -1;
  const column3Row2 = -2 * near;
  result[0] = column0Row0;
  result[1] = 0;
  result[2] = 0;
  result[3] = 0;
  result[4] = 0;
  result[5] = column1Row1;
  result[6] = 0;
  result[7] = 0;
  result[8] = column2Row0;
  result[9] = column2Row1;
  result[10] = column2Row2;
  result[11] = column2Row3;
  result[12] = 0;
  result[13] = 0;
  result[14] = column3Row2;
  result[15] = 0;
  return result;
};
Matrix4.computeViewportTransformation = function(viewport, nearDepthRange, farDepthRange, result) {
  if (!defined_default(result)) {
    result = new Matrix4();
  }
  viewport = defaultValue_default(viewport, defaultValue_default.EMPTY_OBJECT);
  const x = defaultValue_default(viewport.x, 0);
  const y = defaultValue_default(viewport.y, 0);
  const width = defaultValue_default(viewport.width, 0);
  const height = defaultValue_default(viewport.height, 0);
  nearDepthRange = defaultValue_default(nearDepthRange, 0);
  farDepthRange = defaultValue_default(farDepthRange, 1);
  const halfWidth = width * 0.5;
  const halfHeight = height * 0.5;
  const halfDepth = (farDepthRange - nearDepthRange) * 0.5;
  const column0Row0 = halfWidth;
  const column1Row1 = halfHeight;
  const column2Row2 = halfDepth;
  const column3Row0 = x + halfWidth;
  const column3Row1 = y + halfHeight;
  const column3Row2 = nearDepthRange + halfDepth;
  const column3Row3 = 1;
  result[0] = column0Row0;
  result[1] = 0;
  result[2] = 0;
  result[3] = 0;
  result[4] = 0;
  result[5] = column1Row1;
  result[6] = 0;
  result[7] = 0;
  result[8] = 0;
  result[9] = 0;
  result[10] = column2Row2;
  result[11] = 0;
  result[12] = column3Row0;
  result[13] = column3Row1;
  result[14] = column3Row2;
  result[15] = column3Row3;
  return result;
};
Matrix4.computeView = function(position, direction2, up, right, result) {
  Check_default.typeOf.object("position", position);
  Check_default.typeOf.object("direction", direction2);
  Check_default.typeOf.object("up", up);
  Check_default.typeOf.object("right", right);
  Check_default.typeOf.object("result", result);
  result[0] = right.x;
  result[1] = up.x;
  result[2] = -direction2.x;
  result[3] = 0;
  result[4] = right.y;
  result[5] = up.y;
  result[6] = -direction2.y;
  result[7] = 0;
  result[8] = right.z;
  result[9] = up.z;
  result[10] = -direction2.z;
  result[11] = 0;
  result[12] = -Cartesian3_default.dot(right, position);
  result[13] = -Cartesian3_default.dot(up, position);
  result[14] = Cartesian3_default.dot(direction2, position);
  result[15] = 1;
  return result;
};
Matrix4.toArray = function(matrix, result) {
  Check_default.typeOf.object("matrix", matrix);
  if (!defined_default(result)) {
    return [
      matrix[0],
      matrix[1],
      matrix[2],
      matrix[3],
      matrix[4],
      matrix[5],
      matrix[6],
      matrix[7],
      matrix[8],
      matrix[9],
      matrix[10],
      matrix[11],
      matrix[12],
      matrix[13],
      matrix[14],
      matrix[15]
    ];
  }
  result[0] = matrix[0];
  result[1] = matrix[1];
  result[2] = matrix[2];
  result[3] = matrix[3];
  result[4] = matrix[4];
  result[5] = matrix[5];
  result[6] = matrix[6];
  result[7] = matrix[7];
  result[8] = matrix[8];
  result[9] = matrix[9];
  result[10] = matrix[10];
  result[11] = matrix[11];
  result[12] = matrix[12];
  result[13] = matrix[13];
  result[14] = matrix[14];
  result[15] = matrix[15];
  return result;
};
Matrix4.getElementIndex = function(column, row) {
  Check_default.typeOf.number.greaterThanOrEquals("row", row, 0);
  Check_default.typeOf.number.lessThanOrEquals("row", row, 3);
  Check_default.typeOf.number.greaterThanOrEquals("column", column, 0);
  Check_default.typeOf.number.lessThanOrEquals("column", column, 3);
  return column * 4 + row;
};
Matrix4.getColumn = function(matrix, index, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.number.greaterThanOrEquals("index", index, 0);
  Check_default.typeOf.number.lessThanOrEquals("index", index, 3);
  Check_default.typeOf.object("result", result);
  const startIndex = index * 4;
  const x = matrix[startIndex];
  const y = matrix[startIndex + 1];
  const z = matrix[startIndex + 2];
  const w = matrix[startIndex + 3];
  result.x = x;
  result.y = y;
  result.z = z;
  result.w = w;
  return result;
};
Matrix4.setColumn = function(matrix, index, cartesian11, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.number.greaterThanOrEquals("index", index, 0);
  Check_default.typeOf.number.lessThanOrEquals("index", index, 3);
  Check_default.typeOf.object("cartesian", cartesian11);
  Check_default.typeOf.object("result", result);
  result = Matrix4.clone(matrix, result);
  const startIndex = index * 4;
  result[startIndex] = cartesian11.x;
  result[startIndex + 1] = cartesian11.y;
  result[startIndex + 2] = cartesian11.z;
  result[startIndex + 3] = cartesian11.w;
  return result;
};
Matrix4.getRow = function(matrix, index, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.number.greaterThanOrEquals("index", index, 0);
  Check_default.typeOf.number.lessThanOrEquals("index", index, 3);
  Check_default.typeOf.object("result", result);
  const x = matrix[index];
  const y = matrix[index + 4];
  const z = matrix[index + 8];
  const w = matrix[index + 12];
  result.x = x;
  result.y = y;
  result.z = z;
  result.w = w;
  return result;
};
Matrix4.setRow = function(matrix, index, cartesian11, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.number.greaterThanOrEquals("index", index, 0);
  Check_default.typeOf.number.lessThanOrEquals("index", index, 3);
  Check_default.typeOf.object("cartesian", cartesian11);
  Check_default.typeOf.object("result", result);
  result = Matrix4.clone(matrix, result);
  result[index] = cartesian11.x;
  result[index + 4] = cartesian11.y;
  result[index + 8] = cartesian11.z;
  result[index + 12] = cartesian11.w;
  return result;
};
Matrix4.setTranslation = function(matrix, translation3, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("translation", translation3);
  Check_default.typeOf.object("result", result);
  result[0] = matrix[0];
  result[1] = matrix[1];
  result[2] = matrix[2];
  result[3] = matrix[3];
  result[4] = matrix[4];
  result[5] = matrix[5];
  result[6] = matrix[6];
  result[7] = matrix[7];
  result[8] = matrix[8];
  result[9] = matrix[9];
  result[10] = matrix[10];
  result[11] = matrix[11];
  result[12] = translation3.x;
  result[13] = translation3.y;
  result[14] = translation3.z;
  result[15] = matrix[15];
  return result;
};
var scaleScratch12 = new Cartesian3_default();
Matrix4.setScale = function(matrix, scale, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("scale", scale);
  Check_default.typeOf.object("result", result);
  const existingScale = Matrix4.getScale(matrix, scaleScratch12);
  const scaleRatioX = scale.x / existingScale.x;
  const scaleRatioY = scale.y / existingScale.y;
  const scaleRatioZ = scale.z / existingScale.z;
  result[0] = matrix[0] * scaleRatioX;
  result[1] = matrix[1] * scaleRatioX;
  result[2] = matrix[2] * scaleRatioX;
  result[3] = matrix[3];
  result[4] = matrix[4] * scaleRatioY;
  result[5] = matrix[5] * scaleRatioY;
  result[6] = matrix[6] * scaleRatioY;
  result[7] = matrix[7];
  result[8] = matrix[8] * scaleRatioZ;
  result[9] = matrix[9] * scaleRatioZ;
  result[10] = matrix[10] * scaleRatioZ;
  result[11] = matrix[11];
  result[12] = matrix[12];
  result[13] = matrix[13];
  result[14] = matrix[14];
  result[15] = matrix[15];
  return result;
};
var scaleScratch22 = new Cartesian3_default();
Matrix4.setUniformScale = function(matrix, scale, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.number("scale", scale);
  Check_default.typeOf.object("result", result);
  const existingScale = Matrix4.getScale(matrix, scaleScratch22);
  const scaleRatioX = scale / existingScale.x;
  const scaleRatioY = scale / existingScale.y;
  const scaleRatioZ = scale / existingScale.z;
  result[0] = matrix[0] * scaleRatioX;
  result[1] = matrix[1] * scaleRatioX;
  result[2] = matrix[2] * scaleRatioX;
  result[3] = matrix[3];
  result[4] = matrix[4] * scaleRatioY;
  result[5] = matrix[5] * scaleRatioY;
  result[6] = matrix[6] * scaleRatioY;
  result[7] = matrix[7];
  result[8] = matrix[8] * scaleRatioZ;
  result[9] = matrix[9] * scaleRatioZ;
  result[10] = matrix[10] * scaleRatioZ;
  result[11] = matrix[11];
  result[12] = matrix[12];
  result[13] = matrix[13];
  result[14] = matrix[14];
  result[15] = matrix[15];
  return result;
};
var scratchColumn2 = new Cartesian3_default();
Matrix4.getScale = function(matrix, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("result", result);
  result.x = Cartesian3_default.magnitude(
    Cartesian3_default.fromElements(matrix[0], matrix[1], matrix[2], scratchColumn2)
  );
  result.y = Cartesian3_default.magnitude(
    Cartesian3_default.fromElements(matrix[4], matrix[5], matrix[6], scratchColumn2)
  );
  result.z = Cartesian3_default.magnitude(
    Cartesian3_default.fromElements(matrix[8], matrix[9], matrix[10], scratchColumn2)
  );
  return result;
};
var scaleScratch32 = new Cartesian3_default();
Matrix4.getMaximumScale = function(matrix) {
  Matrix4.getScale(matrix, scaleScratch32);
  return Cartesian3_default.maximumComponent(scaleScratch32);
};
var scaleScratch42 = new Cartesian3_default();
Matrix4.setRotation = function(matrix, rotation, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("result", result);
  const scale = Matrix4.getScale(matrix, scaleScratch42);
  result[0] = rotation[0] * scale.x;
  result[1] = rotation[1] * scale.x;
  result[2] = rotation[2] * scale.x;
  result[3] = matrix[3];
  result[4] = rotation[3] * scale.y;
  result[5] = rotation[4] * scale.y;
  result[6] = rotation[5] * scale.y;
  result[7] = matrix[7];
  result[8] = rotation[6] * scale.z;
  result[9] = rotation[7] * scale.z;
  result[10] = rotation[8] * scale.z;
  result[11] = matrix[11];
  result[12] = matrix[12];
  result[13] = matrix[13];
  result[14] = matrix[14];
  result[15] = matrix[15];
  return result;
};
var scaleScratch52 = new Cartesian3_default();
Matrix4.getRotation = function(matrix, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("result", result);
  const scale = Matrix4.getScale(matrix, scaleScratch52);
  result[0] = matrix[0] / scale.x;
  result[1] = matrix[1] / scale.x;
  result[2] = matrix[2] / scale.x;
  result[3] = matrix[4] / scale.y;
  result[4] = matrix[5] / scale.y;
  result[5] = matrix[6] / scale.y;
  result[6] = matrix[8] / scale.z;
  result[7] = matrix[9] / scale.z;
  result[8] = matrix[10] / scale.z;
  return result;
};
Matrix4.multiply = function(left, right, result) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Check_default.typeOf.object("result", result);
  const left0 = left[0];
  const left1 = left[1];
  const left2 = left[2];
  const left3 = left[3];
  const left4 = left[4];
  const left5 = left[5];
  const left6 = left[6];
  const left7 = left[7];
  const left8 = left[8];
  const left9 = left[9];
  const left10 = left[10];
  const left11 = left[11];
  const left12 = left[12];
  const left13 = left[13];
  const left14 = left[14];
  const left15 = left[15];
  const right0 = right[0];
  const right1 = right[1];
  const right2 = right[2];
  const right3 = right[3];
  const right4 = right[4];
  const right5 = right[5];
  const right6 = right[6];
  const right7 = right[7];
  const right8 = right[8];
  const right9 = right[9];
  const right10 = right[10];
  const right11 = right[11];
  const right12 = right[12];
  const right13 = right[13];
  const right14 = right[14];
  const right15 = right[15];
  const column0Row0 = left0 * right0 + left4 * right1 + left8 * right2 + left12 * right3;
  const column0Row1 = left1 * right0 + left5 * right1 + left9 * right2 + left13 * right3;
  const column0Row2 = left2 * right0 + left6 * right1 + left10 * right2 + left14 * right3;
  const column0Row3 = left3 * right0 + left7 * right1 + left11 * right2 + left15 * right3;
  const column1Row0 = left0 * right4 + left4 * right5 + left8 * right6 + left12 * right7;
  const column1Row1 = left1 * right4 + left5 * right5 + left9 * right6 + left13 * right7;
  const column1Row2 = left2 * right4 + left6 * right5 + left10 * right6 + left14 * right7;
  const column1Row3 = left3 * right4 + left7 * right5 + left11 * right6 + left15 * right7;
  const column2Row0 = left0 * right8 + left4 * right9 + left8 * right10 + left12 * right11;
  const column2Row1 = left1 * right8 + left5 * right9 + left9 * right10 + left13 * right11;
  const column2Row2 = left2 * right8 + left6 * right9 + left10 * right10 + left14 * right11;
  const column2Row3 = left3 * right8 + left7 * right9 + left11 * right10 + left15 * right11;
  const column3Row0 = left0 * right12 + left4 * right13 + left8 * right14 + left12 * right15;
  const column3Row1 = left1 * right12 + left5 * right13 + left9 * right14 + left13 * right15;
  const column3Row2 = left2 * right12 + left6 * right13 + left10 * right14 + left14 * right15;
  const column3Row3 = left3 * right12 + left7 * right13 + left11 * right14 + left15 * right15;
  result[0] = column0Row0;
  result[1] = column0Row1;
  result[2] = column0Row2;
  result[3] = column0Row3;
  result[4] = column1Row0;
  result[5] = column1Row1;
  result[6] = column1Row2;
  result[7] = column1Row3;
  result[8] = column2Row0;
  result[9] = column2Row1;
  result[10] = column2Row2;
  result[11] = column2Row3;
  result[12] = column3Row0;
  result[13] = column3Row1;
  result[14] = column3Row2;
  result[15] = column3Row3;
  return result;
};
Matrix4.add = function(left, right, result) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Check_default.typeOf.object("result", result);
  result[0] = left[0] + right[0];
  result[1] = left[1] + right[1];
  result[2] = left[2] + right[2];
  result[3] = left[3] + right[3];
  result[4] = left[4] + right[4];
  result[5] = left[5] + right[5];
  result[6] = left[6] + right[6];
  result[7] = left[7] + right[7];
  result[8] = left[8] + right[8];
  result[9] = left[9] + right[9];
  result[10] = left[10] + right[10];
  result[11] = left[11] + right[11];
  result[12] = left[12] + right[12];
  result[13] = left[13] + right[13];
  result[14] = left[14] + right[14];
  result[15] = left[15] + right[15];
  return result;
};
Matrix4.subtract = function(left, right, result) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Check_default.typeOf.object("result", result);
  result[0] = left[0] - right[0];
  result[1] = left[1] - right[1];
  result[2] = left[2] - right[2];
  result[3] = left[3] - right[3];
  result[4] = left[4] - right[4];
  result[5] = left[5] - right[5];
  result[6] = left[6] - right[6];
  result[7] = left[7] - right[7];
  result[8] = left[8] - right[8];
  result[9] = left[9] - right[9];
  result[10] = left[10] - right[10];
  result[11] = left[11] - right[11];
  result[12] = left[12] - right[12];
  result[13] = left[13] - right[13];
  result[14] = left[14] - right[14];
  result[15] = left[15] - right[15];
  return result;
};
Matrix4.multiplyTransformation = function(left, right, result) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Check_default.typeOf.object("result", result);
  const left0 = left[0];
  const left1 = left[1];
  const left2 = left[2];
  const left4 = left[4];
  const left5 = left[5];
  const left6 = left[6];
  const left8 = left[8];
  const left9 = left[9];
  const left10 = left[10];
  const left12 = left[12];
  const left13 = left[13];
  const left14 = left[14];
  const right0 = right[0];
  const right1 = right[1];
  const right2 = right[2];
  const right4 = right[4];
  const right5 = right[5];
  const right6 = right[6];
  const right8 = right[8];
  const right9 = right[9];
  const right10 = right[10];
  const right12 = right[12];
  const right13 = right[13];
  const right14 = right[14];
  const column0Row0 = left0 * right0 + left4 * right1 + left8 * right2;
  const column0Row1 = left1 * right0 + left5 * right1 + left9 * right2;
  const column0Row2 = left2 * right0 + left6 * right1 + left10 * right2;
  const column1Row0 = left0 * right4 + left4 * right5 + left8 * right6;
  const column1Row1 = left1 * right4 + left5 * right5 + left9 * right6;
  const column1Row2 = left2 * right4 + left6 * right5 + left10 * right6;
  const column2Row0 = left0 * right8 + left4 * right9 + left8 * right10;
  const column2Row1 = left1 * right8 + left5 * right9 + left9 * right10;
  const column2Row2 = left2 * right8 + left6 * right9 + left10 * right10;
  const column3Row0 = left0 * right12 + left4 * right13 + left8 * right14 + left12;
  const column3Row1 = left1 * right12 + left5 * right13 + left9 * right14 + left13;
  const column3Row2 = left2 * right12 + left6 * right13 + left10 * right14 + left14;
  result[0] = column0Row0;
  result[1] = column0Row1;
  result[2] = column0Row2;
  result[3] = 0;
  result[4] = column1Row0;
  result[5] = column1Row1;
  result[6] = column1Row2;
  result[7] = 0;
  result[8] = column2Row0;
  result[9] = column2Row1;
  result[10] = column2Row2;
  result[11] = 0;
  result[12] = column3Row0;
  result[13] = column3Row1;
  result[14] = column3Row2;
  result[15] = 1;
  return result;
};
Matrix4.multiplyByMatrix3 = function(matrix, rotation, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("rotation", rotation);
  Check_default.typeOf.object("result", result);
  const left0 = matrix[0];
  const left1 = matrix[1];
  const left2 = matrix[2];
  const left4 = matrix[4];
  const left5 = matrix[5];
  const left6 = matrix[6];
  const left8 = matrix[8];
  const left9 = matrix[9];
  const left10 = matrix[10];
  const right0 = rotation[0];
  const right1 = rotation[1];
  const right2 = rotation[2];
  const right4 = rotation[3];
  const right5 = rotation[4];
  const right6 = rotation[5];
  const right8 = rotation[6];
  const right9 = rotation[7];
  const right10 = rotation[8];
  const column0Row0 = left0 * right0 + left4 * right1 + left8 * right2;
  const column0Row1 = left1 * right0 + left5 * right1 + left9 * right2;
  const column0Row2 = left2 * right0 + left6 * right1 + left10 * right2;
  const column1Row0 = left0 * right4 + left4 * right5 + left8 * right6;
  const column1Row1 = left1 * right4 + left5 * right5 + left9 * right6;
  const column1Row2 = left2 * right4 + left6 * right5 + left10 * right6;
  const column2Row0 = left0 * right8 + left4 * right9 + left8 * right10;
  const column2Row1 = left1 * right8 + left5 * right9 + left9 * right10;
  const column2Row2 = left2 * right8 + left6 * right9 + left10 * right10;
  result[0] = column0Row0;
  result[1] = column0Row1;
  result[2] = column0Row2;
  result[3] = 0;
  result[4] = column1Row0;
  result[5] = column1Row1;
  result[6] = column1Row2;
  result[7] = 0;
  result[8] = column2Row0;
  result[9] = column2Row1;
  result[10] = column2Row2;
  result[11] = 0;
  result[12] = matrix[12];
  result[13] = matrix[13];
  result[14] = matrix[14];
  result[15] = matrix[15];
  return result;
};
Matrix4.multiplyByTranslation = function(matrix, translation3, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("translation", translation3);
  Check_default.typeOf.object("result", result);
  const x = translation3.x;
  const y = translation3.y;
  const z = translation3.z;
  const tx = x * matrix[0] + y * matrix[4] + z * matrix[8] + matrix[12];
  const ty = x * matrix[1] + y * matrix[5] + z * matrix[9] + matrix[13];
  const tz = x * matrix[2] + y * matrix[6] + z * matrix[10] + matrix[14];
  result[0] = matrix[0];
  result[1] = matrix[1];
  result[2] = matrix[2];
  result[3] = matrix[3];
  result[4] = matrix[4];
  result[5] = matrix[5];
  result[6] = matrix[6];
  result[7] = matrix[7];
  result[8] = matrix[8];
  result[9] = matrix[9];
  result[10] = matrix[10];
  result[11] = matrix[11];
  result[12] = tx;
  result[13] = ty;
  result[14] = tz;
  result[15] = matrix[15];
  return result;
};
Matrix4.multiplyByScale = function(matrix, scale, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("scale", scale);
  Check_default.typeOf.object("result", result);
  const scaleX = scale.x;
  const scaleY = scale.y;
  const scaleZ = scale.z;
  if (scaleX === 1 && scaleY === 1 && scaleZ === 1) {
    return Matrix4.clone(matrix, result);
  }
  result[0] = scaleX * matrix[0];
  result[1] = scaleX * matrix[1];
  result[2] = scaleX * matrix[2];
  result[3] = matrix[3];
  result[4] = scaleY * matrix[4];
  result[5] = scaleY * matrix[5];
  result[6] = scaleY * matrix[6];
  result[7] = matrix[7];
  result[8] = scaleZ * matrix[8];
  result[9] = scaleZ * matrix[9];
  result[10] = scaleZ * matrix[10];
  result[11] = matrix[11];
  result[12] = matrix[12];
  result[13] = matrix[13];
  result[14] = matrix[14];
  result[15] = matrix[15];
  return result;
};
Matrix4.multiplyByUniformScale = function(matrix, scale, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.number("scale", scale);
  Check_default.typeOf.object("result", result);
  result[0] = matrix[0] * scale;
  result[1] = matrix[1] * scale;
  result[2] = matrix[2] * scale;
  result[3] = matrix[3];
  result[4] = matrix[4] * scale;
  result[5] = matrix[5] * scale;
  result[6] = matrix[6] * scale;
  result[7] = matrix[7];
  result[8] = matrix[8] * scale;
  result[9] = matrix[9] * scale;
  result[10] = matrix[10] * scale;
  result[11] = matrix[11];
  result[12] = matrix[12];
  result[13] = matrix[13];
  result[14] = matrix[14];
  result[15] = matrix[15];
  return result;
};
Matrix4.multiplyByVector = function(matrix, cartesian11, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("cartesian", cartesian11);
  Check_default.typeOf.object("result", result);
  const vX = cartesian11.x;
  const vY = cartesian11.y;
  const vZ = cartesian11.z;
  const vW = cartesian11.w;
  const x = matrix[0] * vX + matrix[4] * vY + matrix[8] * vZ + matrix[12] * vW;
  const y = matrix[1] * vX + matrix[5] * vY + matrix[9] * vZ + matrix[13] * vW;
  const z = matrix[2] * vX + matrix[6] * vY + matrix[10] * vZ + matrix[14] * vW;
  const w = matrix[3] * vX + matrix[7] * vY + matrix[11] * vZ + matrix[15] * vW;
  result.x = x;
  result.y = y;
  result.z = z;
  result.w = w;
  return result;
};
Matrix4.multiplyByPointAsVector = function(matrix, cartesian11, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("cartesian", cartesian11);
  Check_default.typeOf.object("result", result);
  const vX = cartesian11.x;
  const vY = cartesian11.y;
  const vZ = cartesian11.z;
  const x = matrix[0] * vX + matrix[4] * vY + matrix[8] * vZ;
  const y = matrix[1] * vX + matrix[5] * vY + matrix[9] * vZ;
  const z = matrix[2] * vX + matrix[6] * vY + matrix[10] * vZ;
  result.x = x;
  result.y = y;
  result.z = z;
  return result;
};
Matrix4.multiplyByPoint = function(matrix, cartesian11, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("cartesian", cartesian11);
  Check_default.typeOf.object("result", result);
  const vX = cartesian11.x;
  const vY = cartesian11.y;
  const vZ = cartesian11.z;
  const x = matrix[0] * vX + matrix[4] * vY + matrix[8] * vZ + matrix[12];
  const y = matrix[1] * vX + matrix[5] * vY + matrix[9] * vZ + matrix[13];
  const z = matrix[2] * vX + matrix[6] * vY + matrix[10] * vZ + matrix[14];
  result.x = x;
  result.y = y;
  result.z = z;
  return result;
};
Matrix4.multiplyByScalar = function(matrix, scalar, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.number("scalar", scalar);
  Check_default.typeOf.object("result", result);
  result[0] = matrix[0] * scalar;
  result[1] = matrix[1] * scalar;
  result[2] = matrix[2] * scalar;
  result[3] = matrix[3] * scalar;
  result[4] = matrix[4] * scalar;
  result[5] = matrix[5] * scalar;
  result[6] = matrix[6] * scalar;
  result[7] = matrix[7] * scalar;
  result[8] = matrix[8] * scalar;
  result[9] = matrix[9] * scalar;
  result[10] = matrix[10] * scalar;
  result[11] = matrix[11] * scalar;
  result[12] = matrix[12] * scalar;
  result[13] = matrix[13] * scalar;
  result[14] = matrix[14] * scalar;
  result[15] = matrix[15] * scalar;
  return result;
};
Matrix4.negate = function(matrix, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("result", result);
  result[0] = -matrix[0];
  result[1] = -matrix[1];
  result[2] = -matrix[2];
  result[3] = -matrix[3];
  result[4] = -matrix[4];
  result[5] = -matrix[5];
  result[6] = -matrix[6];
  result[7] = -matrix[7];
  result[8] = -matrix[8];
  result[9] = -matrix[9];
  result[10] = -matrix[10];
  result[11] = -matrix[11];
  result[12] = -matrix[12];
  result[13] = -matrix[13];
  result[14] = -matrix[14];
  result[15] = -matrix[15];
  return result;
};
Matrix4.transpose = function(matrix, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("result", result);
  const matrix1 = matrix[1];
  const matrix2 = matrix[2];
  const matrix3 = matrix[3];
  const matrix6 = matrix[6];
  const matrix7 = matrix[7];
  const matrix11 = matrix[11];
  result[0] = matrix[0];
  result[1] = matrix[4];
  result[2] = matrix[8];
  result[3] = matrix[12];
  result[4] = matrix1;
  result[5] = matrix[5];
  result[6] = matrix[9];
  result[7] = matrix[13];
  result[8] = matrix2;
  result[9] = matrix6;
  result[10] = matrix[10];
  result[11] = matrix[14];
  result[12] = matrix3;
  result[13] = matrix7;
  result[14] = matrix11;
  result[15] = matrix[15];
  return result;
};
Matrix4.abs = function(matrix, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("result", result);
  result[0] = Math.abs(matrix[0]);
  result[1] = Math.abs(matrix[1]);
  result[2] = Math.abs(matrix[2]);
  result[3] = Math.abs(matrix[3]);
  result[4] = Math.abs(matrix[4]);
  result[5] = Math.abs(matrix[5]);
  result[6] = Math.abs(matrix[6]);
  result[7] = Math.abs(matrix[7]);
  result[8] = Math.abs(matrix[8]);
  result[9] = Math.abs(matrix[9]);
  result[10] = Math.abs(matrix[10]);
  result[11] = Math.abs(matrix[11]);
  result[12] = Math.abs(matrix[12]);
  result[13] = Math.abs(matrix[13]);
  result[14] = Math.abs(matrix[14]);
  result[15] = Math.abs(matrix[15]);
  return result;
};
Matrix4.equals = function(left, right) {
  return left === right || defined_default(left) && defined_default(right) && left[12] === right[12] && left[13] === right[13] && left[14] === right[14] && left[0] === right[0] && left[1] === right[1] && left[2] === right[2] && left[4] === right[4] && left[5] === right[5] && left[6] === right[6] && left[8] === right[8] && left[9] === right[9] && left[10] === right[10] && left[3] === right[3] && left[7] === right[7] && left[11] === right[11] && left[15] === right[15];
};
Matrix4.equalsEpsilon = function(left, right, epsilon) {
  epsilon = defaultValue_default(epsilon, 0);
  return left === right || defined_default(left) && defined_default(right) && Math.abs(left[0] - right[0]) <= epsilon && Math.abs(left[1] - right[1]) <= epsilon && Math.abs(left[2] - right[2]) <= epsilon && Math.abs(left[3] - right[3]) <= epsilon && Math.abs(left[4] - right[4]) <= epsilon && Math.abs(left[5] - right[5]) <= epsilon && Math.abs(left[6] - right[6]) <= epsilon && Math.abs(left[7] - right[7]) <= epsilon && Math.abs(left[8] - right[8]) <= epsilon && Math.abs(left[9] - right[9]) <= epsilon && Math.abs(left[10] - right[10]) <= epsilon && Math.abs(left[11] - right[11]) <= epsilon && Math.abs(left[12] - right[12]) <= epsilon && Math.abs(left[13] - right[13]) <= epsilon && Math.abs(left[14] - right[14]) <= epsilon && Math.abs(left[15] - right[15]) <= epsilon;
};
Matrix4.getTranslation = function(matrix, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("result", result);
  result.x = matrix[12];
  result.y = matrix[13];
  result.z = matrix[14];
  return result;
};
Matrix4.getMatrix3 = function(matrix, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("result", result);
  result[0] = matrix[0];
  result[1] = matrix[1];
  result[2] = matrix[2];
  result[3] = matrix[4];
  result[4] = matrix[5];
  result[5] = matrix[6];
  result[6] = matrix[8];
  result[7] = matrix[9];
  result[8] = matrix[10];
  return result;
};
var scratchInverseRotation = new Matrix3_default();
var scratchMatrix3Zero = new Matrix3_default();
var scratchBottomRow = new Cartesian4_default();
var scratchExpectedBottomRow = new Cartesian4_default(0, 0, 0, 1);
Matrix4.inverse = function(matrix, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("result", result);
  const src0 = matrix[0];
  const src1 = matrix[4];
  const src2 = matrix[8];
  const src3 = matrix[12];
  const src4 = matrix[1];
  const src5 = matrix[5];
  const src6 = matrix[9];
  const src7 = matrix[13];
  const src8 = matrix[2];
  const src9 = matrix[6];
  const src10 = matrix[10];
  const src11 = matrix[14];
  const src12 = matrix[3];
  const src13 = matrix[7];
  const src14 = matrix[11];
  const src15 = matrix[15];
  let tmp0 = src10 * src15;
  let tmp1 = src11 * src14;
  let tmp2 = src9 * src15;
  let tmp3 = src11 * src13;
  let tmp4 = src9 * src14;
  let tmp5 = src10 * src13;
  let tmp6 = src8 * src15;
  let tmp7 = src11 * src12;
  let tmp8 = src8 * src14;
  let tmp9 = src10 * src12;
  let tmp10 = src8 * src13;
  let tmp11 = src9 * src12;
  const dst0 = tmp0 * src5 + tmp3 * src6 + tmp4 * src7 - (tmp1 * src5 + tmp2 * src6 + tmp5 * src7);
  const dst1 = tmp1 * src4 + tmp6 * src6 + tmp9 * src7 - (tmp0 * src4 + tmp7 * src6 + tmp8 * src7);
  const dst2 = tmp2 * src4 + tmp7 * src5 + tmp10 * src7 - (tmp3 * src4 + tmp6 * src5 + tmp11 * src7);
  const dst3 = tmp5 * src4 + tmp8 * src5 + tmp11 * src6 - (tmp4 * src4 + tmp9 * src5 + tmp10 * src6);
  const dst4 = tmp1 * src1 + tmp2 * src2 + tmp5 * src3 - (tmp0 * src1 + tmp3 * src2 + tmp4 * src3);
  const dst5 = tmp0 * src0 + tmp7 * src2 + tmp8 * src3 - (tmp1 * src0 + tmp6 * src2 + tmp9 * src3);
  const dst6 = tmp3 * src0 + tmp6 * src1 + tmp11 * src3 - (tmp2 * src0 + tmp7 * src1 + tmp10 * src3);
  const dst7 = tmp4 * src0 + tmp9 * src1 + tmp10 * src2 - (tmp5 * src0 + tmp8 * src1 + tmp11 * src2);
  tmp0 = src2 * src7;
  tmp1 = src3 * src6;
  tmp2 = src1 * src7;
  tmp3 = src3 * src5;
  tmp4 = src1 * src6;
  tmp5 = src2 * src5;
  tmp6 = src0 * src7;
  tmp7 = src3 * src4;
  tmp8 = src0 * src6;
  tmp9 = src2 * src4;
  tmp10 = src0 * src5;
  tmp11 = src1 * src4;
  const dst8 = tmp0 * src13 + tmp3 * src14 + tmp4 * src15 - (tmp1 * src13 + tmp2 * src14 + tmp5 * src15);
  const dst9 = tmp1 * src12 + tmp6 * src14 + tmp9 * src15 - (tmp0 * src12 + tmp7 * src14 + tmp8 * src15);
  const dst10 = tmp2 * src12 + tmp7 * src13 + tmp10 * src15 - (tmp3 * src12 + tmp6 * src13 + tmp11 * src15);
  const dst11 = tmp5 * src12 + tmp8 * src13 + tmp11 * src14 - (tmp4 * src12 + tmp9 * src13 + tmp10 * src14);
  const dst12 = tmp2 * src10 + tmp5 * src11 + tmp1 * src9 - (tmp4 * src11 + tmp0 * src9 + tmp3 * src10);
  const dst13 = tmp8 * src11 + tmp0 * src8 + tmp7 * src10 - (tmp6 * src10 + tmp9 * src11 + tmp1 * src8);
  const dst14 = tmp6 * src9 + tmp11 * src11 + tmp3 * src8 - (tmp10 * src11 + tmp2 * src8 + tmp7 * src9);
  const dst15 = tmp10 * src10 + tmp4 * src8 + tmp9 * src9 - (tmp8 * src9 + tmp11 * src10 + tmp5 * src8);
  let det = src0 * dst0 + src1 * dst1 + src2 * dst2 + src3 * dst3;
  if (Math.abs(det) < Math_default.EPSILON21) {
    if (Matrix3_default.equalsEpsilon(
      Matrix4.getMatrix3(matrix, scratchInverseRotation),
      scratchMatrix3Zero,
      Math_default.EPSILON7
    ) && Cartesian4_default.equals(
      Matrix4.getRow(matrix, 3, scratchBottomRow),
      scratchExpectedBottomRow
    )) {
      result[0] = 0;
      result[1] = 0;
      result[2] = 0;
      result[3] = 0;
      result[4] = 0;
      result[5] = 0;
      result[6] = 0;
      result[7] = 0;
      result[8] = 0;
      result[9] = 0;
      result[10] = 0;
      result[11] = 0;
      result[12] = -matrix[12];
      result[13] = -matrix[13];
      result[14] = -matrix[14];
      result[15] = 1;
      return result;
    }
    throw new RuntimeError_default(
      "matrix is not invertible because its determinate is zero."
    );
  }
  det = 1 / det;
  result[0] = dst0 * det;
  result[1] = dst1 * det;
  result[2] = dst2 * det;
  result[3] = dst3 * det;
  result[4] = dst4 * det;
  result[5] = dst5 * det;
  result[6] = dst6 * det;
  result[7] = dst7 * det;
  result[8] = dst8 * det;
  result[9] = dst9 * det;
  result[10] = dst10 * det;
  result[11] = dst11 * det;
  result[12] = dst12 * det;
  result[13] = dst13 * det;
  result[14] = dst14 * det;
  result[15] = dst15 * det;
  return result;
};
Matrix4.inverseTransformation = function(matrix, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("result", result);
  const matrix0 = matrix[0];
  const matrix1 = matrix[1];
  const matrix2 = matrix[2];
  const matrix4 = matrix[4];
  const matrix5 = matrix[5];
  const matrix6 = matrix[6];
  const matrix8 = matrix[8];
  const matrix9 = matrix[9];
  const matrix10 = matrix[10];
  const vX = matrix[12];
  const vY = matrix[13];
  const vZ = matrix[14];
  const x = -matrix0 * vX - matrix1 * vY - matrix2 * vZ;
  const y = -matrix4 * vX - matrix5 * vY - matrix6 * vZ;
  const z = -matrix8 * vX - matrix9 * vY - matrix10 * vZ;
  result[0] = matrix0;
  result[1] = matrix4;
  result[2] = matrix8;
  result[3] = 0;
  result[4] = matrix1;
  result[5] = matrix5;
  result[6] = matrix9;
  result[7] = 0;
  result[8] = matrix2;
  result[9] = matrix6;
  result[10] = matrix10;
  result[11] = 0;
  result[12] = x;
  result[13] = y;
  result[14] = z;
  result[15] = 1;
  return result;
};
var scratchTransposeMatrix2 = new Matrix4();
Matrix4.inverseTranspose = function(matrix, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("result", result);
  return Matrix4.inverse(
    Matrix4.transpose(matrix, scratchTransposeMatrix2),
    result
  );
};
Matrix4.IDENTITY = Object.freeze(
  new Matrix4(
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    1
  )
);
Matrix4.ZERO = Object.freeze(
  new Matrix4(
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0
  )
);
Matrix4.COLUMN0ROW0 = 0;
Matrix4.COLUMN0ROW1 = 1;
Matrix4.COLUMN0ROW2 = 2;
Matrix4.COLUMN0ROW3 = 3;
Matrix4.COLUMN1ROW0 = 4;
Matrix4.COLUMN1ROW1 = 5;
Matrix4.COLUMN1ROW2 = 6;
Matrix4.COLUMN1ROW3 = 7;
Matrix4.COLUMN2ROW0 = 8;
Matrix4.COLUMN2ROW1 = 9;
Matrix4.COLUMN2ROW2 = 10;
Matrix4.COLUMN2ROW3 = 11;
Matrix4.COLUMN3ROW0 = 12;
Matrix4.COLUMN3ROW1 = 13;
Matrix4.COLUMN3ROW2 = 14;
Matrix4.COLUMN3ROW3 = 15;
Object.defineProperties(Matrix4.prototype, {
  length: {
    get: function() {
      return Matrix4.packedLength;
    }
  }
});
Matrix4.prototype.clone = function(result) {
  return Matrix4.clone(this, result);
};
Matrix4.prototype.equals = function(right) {
  return Matrix4.equals(this, right);
};
Matrix4.equalsArray = function(matrix, array, offset2) {
  return matrix[0] === array[offset2] && matrix[1] === array[offset2 + 1] && matrix[2] === array[offset2 + 2] && matrix[3] === array[offset2 + 3] && matrix[4] === array[offset2 + 4] && matrix[5] === array[offset2 + 5] && matrix[6] === array[offset2 + 6] && matrix[7] === array[offset2 + 7] && matrix[8] === array[offset2 + 8] && matrix[9] === array[offset2 + 9] && matrix[10] === array[offset2 + 10] && matrix[11] === array[offset2 + 11] && matrix[12] === array[offset2 + 12] && matrix[13] === array[offset2 + 13] && matrix[14] === array[offset2 + 14] && matrix[15] === array[offset2 + 15];
};
Matrix4.prototype.equalsEpsilon = function(right, epsilon) {
  return Matrix4.equalsEpsilon(this, right, epsilon);
};
Matrix4.prototype.toString = function() {
  return `(${this[0]}, ${this[4]}, ${this[8]}, ${this[12]})
(${this[1]}, ${this[5]}, ${this[9]}, ${this[13]})
(${this[2]}, ${this[6]}, ${this[10]}, ${this[14]})
(${this[3]}, ${this[7]}, ${this[11]}, ${this[15]})`;
};
var Matrix4_default = Matrix4;

// Source/Core/Rectangle.js
function Rectangle(west, south, east, north) {
  this.west = defaultValue_default(west, 0);
  this.south = defaultValue_default(south, 0);
  this.east = defaultValue_default(east, 0);
  this.north = defaultValue_default(north, 0);
}
Object.defineProperties(Rectangle.prototype, {
  width: {
    get: function() {
      return Rectangle.computeWidth(this);
    }
  },
  height: {
    get: function() {
      return Rectangle.computeHeight(this);
    }
  }
});
Rectangle.packedLength = 4;
Rectangle.pack = function(value, array, startingIndex) {
  Check_default.typeOf.object("value", value);
  Check_default.defined("array", array);
  startingIndex = defaultValue_default(startingIndex, 0);
  array[startingIndex++] = value.west;
  array[startingIndex++] = value.south;
  array[startingIndex++] = value.east;
  array[startingIndex] = value.north;
  return array;
};
Rectangle.unpack = function(array, startingIndex, result) {
  Check_default.defined("array", array);
  startingIndex = defaultValue_default(startingIndex, 0);
  if (!defined_default(result)) {
    result = new Rectangle();
  }
  result.west = array[startingIndex++];
  result.south = array[startingIndex++];
  result.east = array[startingIndex++];
  result.north = array[startingIndex];
  return result;
};
Rectangle.computeWidth = function(rectangle) {
  Check_default.typeOf.object("rectangle", rectangle);
  let east = rectangle.east;
  const west = rectangle.west;
  if (east < west) {
    east += Math_default.TWO_PI;
  }
  return east - west;
};
Rectangle.computeHeight = function(rectangle) {
  Check_default.typeOf.object("rectangle", rectangle);
  return rectangle.north - rectangle.south;
};
Rectangle.fromDegrees = function(west, south, east, north, result) {
  west = Math_default.toRadians(defaultValue_default(west, 0));
  south = Math_default.toRadians(defaultValue_default(south, 0));
  east = Math_default.toRadians(defaultValue_default(east, 0));
  north = Math_default.toRadians(defaultValue_default(north, 0));
  if (!defined_default(result)) {
    return new Rectangle(west, south, east, north);
  }
  result.west = west;
  result.south = south;
  result.east = east;
  result.north = north;
  return result;
};
Rectangle.fromRadians = function(west, south, east, north, result) {
  if (!defined_default(result)) {
    return new Rectangle(west, south, east, north);
  }
  result.west = defaultValue_default(west, 0);
  result.south = defaultValue_default(south, 0);
  result.east = defaultValue_default(east, 0);
  result.north = defaultValue_default(north, 0);
  return result;
};
Rectangle.fromCartographicArray = function(cartographics, result) {
  Check_default.defined("cartographics", cartographics);
  let west = Number.MAX_VALUE;
  let east = -Number.MAX_VALUE;
  let westOverIDL = Number.MAX_VALUE;
  let eastOverIDL = -Number.MAX_VALUE;
  let south = Number.MAX_VALUE;
  let north = -Number.MAX_VALUE;
  for (let i = 0, len = cartographics.length; i < len; i++) {
    const position = cartographics[i];
    west = Math.min(west, position.longitude);
    east = Math.max(east, position.longitude);
    south = Math.min(south, position.latitude);
    north = Math.max(north, position.latitude);
    const lonAdjusted = position.longitude >= 0 ? position.longitude : position.longitude + Math_default.TWO_PI;
    westOverIDL = Math.min(westOverIDL, lonAdjusted);
    eastOverIDL = Math.max(eastOverIDL, lonAdjusted);
  }
  if (east - west > eastOverIDL - westOverIDL) {
    west = westOverIDL;
    east = eastOverIDL;
    if (east > Math_default.PI) {
      east = east - Math_default.TWO_PI;
    }
    if (west > Math_default.PI) {
      west = west - Math_default.TWO_PI;
    }
  }
  if (!defined_default(result)) {
    return new Rectangle(west, south, east, north);
  }
  result.west = west;
  result.south = south;
  result.east = east;
  result.north = north;
  return result;
};
Rectangle.fromCartesianArray = function(cartesians, ellipsoid, result) {
  Check_default.defined("cartesians", cartesians);
  ellipsoid = defaultValue_default(ellipsoid, Ellipsoid_default.WGS84);
  let west = Number.MAX_VALUE;
  let east = -Number.MAX_VALUE;
  let westOverIDL = Number.MAX_VALUE;
  let eastOverIDL = -Number.MAX_VALUE;
  let south = Number.MAX_VALUE;
  let north = -Number.MAX_VALUE;
  for (let i = 0, len = cartesians.length; i < len; i++) {
    const position = ellipsoid.cartesianToCartographic(cartesians[i]);
    west = Math.min(west, position.longitude);
    east = Math.max(east, position.longitude);
    south = Math.min(south, position.latitude);
    north = Math.max(north, position.latitude);
    const lonAdjusted = position.longitude >= 0 ? position.longitude : position.longitude + Math_default.TWO_PI;
    westOverIDL = Math.min(westOverIDL, lonAdjusted);
    eastOverIDL = Math.max(eastOverIDL, lonAdjusted);
  }
  if (east - west > eastOverIDL - westOverIDL) {
    west = westOverIDL;
    east = eastOverIDL;
    if (east > Math_default.PI) {
      east = east - Math_default.TWO_PI;
    }
    if (west > Math_default.PI) {
      west = west - Math_default.TWO_PI;
    }
  }
  if (!defined_default(result)) {
    return new Rectangle(west, south, east, north);
  }
  result.west = west;
  result.south = south;
  result.east = east;
  result.north = north;
  return result;
};
Rectangle.clone = function(rectangle, result) {
  if (!defined_default(rectangle)) {
    return void 0;
  }
  if (!defined_default(result)) {
    return new Rectangle(
      rectangle.west,
      rectangle.south,
      rectangle.east,
      rectangle.north
    );
  }
  result.west = rectangle.west;
  result.south = rectangle.south;
  result.east = rectangle.east;
  result.north = rectangle.north;
  return result;
};
Rectangle.equalsEpsilon = function(left, right, absoluteEpsilon) {
  absoluteEpsilon = defaultValue_default(absoluteEpsilon, 0);
  return left === right || defined_default(left) && defined_default(right) && Math.abs(left.west - right.west) <= absoluteEpsilon && Math.abs(left.south - right.south) <= absoluteEpsilon && Math.abs(left.east - right.east) <= absoluteEpsilon && Math.abs(left.north - right.north) <= absoluteEpsilon;
};
Rectangle.prototype.clone = function(result) {
  return Rectangle.clone(this, result);
};
Rectangle.prototype.equals = function(other) {
  return Rectangle.equals(this, other);
};
Rectangle.equals = function(left, right) {
  return left === right || defined_default(left) && defined_default(right) && left.west === right.west && left.south === right.south && left.east === right.east && left.north === right.north;
};
Rectangle.prototype.equalsEpsilon = function(other, epsilon) {
  return Rectangle.equalsEpsilon(this, other, epsilon);
};
Rectangle.validate = function(rectangle) {
  Check_default.typeOf.object("rectangle", rectangle);
  const north = rectangle.north;
  Check_default.typeOf.number.greaterThanOrEquals(
    "north",
    north,
    -Math_default.PI_OVER_TWO
  );
  Check_default.typeOf.number.lessThanOrEquals("north", north, Math_default.PI_OVER_TWO);
  const south = rectangle.south;
  Check_default.typeOf.number.greaterThanOrEquals(
    "south",
    south,
    -Math_default.PI_OVER_TWO
  );
  Check_default.typeOf.number.lessThanOrEquals("south", south, Math_default.PI_OVER_TWO);
  const west = rectangle.west;
  Check_default.typeOf.number.greaterThanOrEquals("west", west, -Math.PI);
  Check_default.typeOf.number.lessThanOrEquals("west", west, Math.PI);
  const east = rectangle.east;
  Check_default.typeOf.number.greaterThanOrEquals("east", east, -Math.PI);
  Check_default.typeOf.number.lessThanOrEquals("east", east, Math.PI);
};
Rectangle.southwest = function(rectangle, result) {
  Check_default.typeOf.object("rectangle", rectangle);
  if (!defined_default(result)) {
    return new Cartographic_default(rectangle.west, rectangle.south);
  }
  result.longitude = rectangle.west;
  result.latitude = rectangle.south;
  result.height = 0;
  return result;
};
Rectangle.northwest = function(rectangle, result) {
  Check_default.typeOf.object("rectangle", rectangle);
  if (!defined_default(result)) {
    return new Cartographic_default(rectangle.west, rectangle.north);
  }
  result.longitude = rectangle.west;
  result.latitude = rectangle.north;
  result.height = 0;
  return result;
};
Rectangle.northeast = function(rectangle, result) {
  Check_default.typeOf.object("rectangle", rectangle);
  if (!defined_default(result)) {
    return new Cartographic_default(rectangle.east, rectangle.north);
  }
  result.longitude = rectangle.east;
  result.latitude = rectangle.north;
  result.height = 0;
  return result;
};
Rectangle.southeast = function(rectangle, result) {
  Check_default.typeOf.object("rectangle", rectangle);
  if (!defined_default(result)) {
    return new Cartographic_default(rectangle.east, rectangle.south);
  }
  result.longitude = rectangle.east;
  result.latitude = rectangle.south;
  result.height = 0;
  return result;
};
Rectangle.center = function(rectangle, result) {
  Check_default.typeOf.object("rectangle", rectangle);
  let east = rectangle.east;
  const west = rectangle.west;
  if (east < west) {
    east += Math_default.TWO_PI;
  }
  const longitude = Math_default.negativePiToPi((west + east) * 0.5);
  const latitude = (rectangle.south + rectangle.north) * 0.5;
  if (!defined_default(result)) {
    return new Cartographic_default(longitude, latitude);
  }
  result.longitude = longitude;
  result.latitude = latitude;
  result.height = 0;
  return result;
};
Rectangle.intersection = function(rectangle, otherRectangle, result) {
  Check_default.typeOf.object("rectangle", rectangle);
  Check_default.typeOf.object("otherRectangle", otherRectangle);
  let rectangleEast = rectangle.east;
  let rectangleWest = rectangle.west;
  let otherRectangleEast = otherRectangle.east;
  let otherRectangleWest = otherRectangle.west;
  if (rectangleEast < rectangleWest && otherRectangleEast > 0) {
    rectangleEast += Math_default.TWO_PI;
  } else if (otherRectangleEast < otherRectangleWest && rectangleEast > 0) {
    otherRectangleEast += Math_default.TWO_PI;
  }
  if (rectangleEast < rectangleWest && otherRectangleWest < 0) {
    otherRectangleWest += Math_default.TWO_PI;
  } else if (otherRectangleEast < otherRectangleWest && rectangleWest < 0) {
    rectangleWest += Math_default.TWO_PI;
  }
  const west = Math_default.negativePiToPi(
    Math.max(rectangleWest, otherRectangleWest)
  );
  const east = Math_default.negativePiToPi(
    Math.min(rectangleEast, otherRectangleEast)
  );
  if ((rectangle.west < rectangle.east || otherRectangle.west < otherRectangle.east) && east <= west) {
    return void 0;
  }
  const south = Math.max(rectangle.south, otherRectangle.south);
  const north = Math.min(rectangle.north, otherRectangle.north);
  if (south >= north) {
    return void 0;
  }
  if (!defined_default(result)) {
    return new Rectangle(west, south, east, north);
  }
  result.west = west;
  result.south = south;
  result.east = east;
  result.north = north;
  return result;
};
Rectangle.simpleIntersection = function(rectangle, otherRectangle, result) {
  Check_default.typeOf.object("rectangle", rectangle);
  Check_default.typeOf.object("otherRectangle", otherRectangle);
  const west = Math.max(rectangle.west, otherRectangle.west);
  const south = Math.max(rectangle.south, otherRectangle.south);
  const east = Math.min(rectangle.east, otherRectangle.east);
  const north = Math.min(rectangle.north, otherRectangle.north);
  if (south >= north || west >= east) {
    return void 0;
  }
  if (!defined_default(result)) {
    return new Rectangle(west, south, east, north);
  }
  result.west = west;
  result.south = south;
  result.east = east;
  result.north = north;
  return result;
};
Rectangle.union = function(rectangle, otherRectangle, result) {
  Check_default.typeOf.object("rectangle", rectangle);
  Check_default.typeOf.object("otherRectangle", otherRectangle);
  if (!defined_default(result)) {
    result = new Rectangle();
  }
  let rectangleEast = rectangle.east;
  let rectangleWest = rectangle.west;
  let otherRectangleEast = otherRectangle.east;
  let otherRectangleWest = otherRectangle.west;
  if (rectangleEast < rectangleWest && otherRectangleEast > 0) {
    rectangleEast += Math_default.TWO_PI;
  } else if (otherRectangleEast < otherRectangleWest && rectangleEast > 0) {
    otherRectangleEast += Math_default.TWO_PI;
  }
  if (rectangleEast < rectangleWest && otherRectangleWest < 0) {
    otherRectangleWest += Math_default.TWO_PI;
  } else if (otherRectangleEast < otherRectangleWest && rectangleWest < 0) {
    rectangleWest += Math_default.TWO_PI;
  }
  const west = Math_default.negativePiToPi(
    Math.min(rectangleWest, otherRectangleWest)
  );
  const east = Math_default.negativePiToPi(
    Math.max(rectangleEast, otherRectangleEast)
  );
  result.west = west;
  result.south = Math.min(rectangle.south, otherRectangle.south);
  result.east = east;
  result.north = Math.max(rectangle.north, otherRectangle.north);
  return result;
};
Rectangle.expand = function(rectangle, cartographic2, result) {
  Check_default.typeOf.object("rectangle", rectangle);
  Check_default.typeOf.object("cartographic", cartographic2);
  if (!defined_default(result)) {
    result = new Rectangle();
  }
  result.west = Math.min(rectangle.west, cartographic2.longitude);
  result.south = Math.min(rectangle.south, cartographic2.latitude);
  result.east = Math.max(rectangle.east, cartographic2.longitude);
  result.north = Math.max(rectangle.north, cartographic2.latitude);
  return result;
};
Rectangle.contains = function(rectangle, cartographic2) {
  Check_default.typeOf.object("rectangle", rectangle);
  Check_default.typeOf.object("cartographic", cartographic2);
  let longitude = cartographic2.longitude;
  const latitude = cartographic2.latitude;
  const west = rectangle.west;
  let east = rectangle.east;
  if (east < west) {
    east += Math_default.TWO_PI;
    if (longitude < 0) {
      longitude += Math_default.TWO_PI;
    }
  }
  return (longitude > west || Math_default.equalsEpsilon(longitude, west, Math_default.EPSILON14)) && (longitude < east || Math_default.equalsEpsilon(longitude, east, Math_default.EPSILON14)) && latitude >= rectangle.south && latitude <= rectangle.north;
};
var subsampleLlaScratch = new Cartographic_default();
Rectangle.subsample = function(rectangle, ellipsoid, surfaceHeight, result) {
  Check_default.typeOf.object("rectangle", rectangle);
  ellipsoid = defaultValue_default(ellipsoid, Ellipsoid_default.WGS84);
  surfaceHeight = defaultValue_default(surfaceHeight, 0);
  if (!defined_default(result)) {
    result = [];
  }
  let length3 = 0;
  const north = rectangle.north;
  const south = rectangle.south;
  const east = rectangle.east;
  const west = rectangle.west;
  const lla = subsampleLlaScratch;
  lla.height = surfaceHeight;
  lla.longitude = west;
  lla.latitude = north;
  result[length3] = ellipsoid.cartographicToCartesian(lla, result[length3]);
  length3++;
  lla.longitude = east;
  result[length3] = ellipsoid.cartographicToCartesian(lla, result[length3]);
  length3++;
  lla.latitude = south;
  result[length3] = ellipsoid.cartographicToCartesian(lla, result[length3]);
  length3++;
  lla.longitude = west;
  result[length3] = ellipsoid.cartographicToCartesian(lla, result[length3]);
  length3++;
  if (north < 0) {
    lla.latitude = north;
  } else if (south > 0) {
    lla.latitude = south;
  } else {
    lla.latitude = 0;
  }
  for (let i = 1; i < 8; ++i) {
    lla.longitude = -Math.PI + i * Math_default.PI_OVER_TWO;
    if (Rectangle.contains(rectangle, lla)) {
      result[length3] = ellipsoid.cartographicToCartesian(lla, result[length3]);
      length3++;
    }
  }
  if (lla.latitude === 0) {
    lla.longitude = west;
    result[length3] = ellipsoid.cartographicToCartesian(lla, result[length3]);
    length3++;
    lla.longitude = east;
    result[length3] = ellipsoid.cartographicToCartesian(lla, result[length3]);
    length3++;
  }
  result.length = length3;
  return result;
};
Rectangle.subsection = function(rectangle, westLerp, southLerp, eastLerp, northLerp, result) {
  Check_default.typeOf.object("rectangle", rectangle);
  Check_default.typeOf.number.greaterThanOrEquals("westLerp", westLerp, 0);
  Check_default.typeOf.number.lessThanOrEquals("westLerp", westLerp, 1);
  Check_default.typeOf.number.greaterThanOrEquals("southLerp", southLerp, 0);
  Check_default.typeOf.number.lessThanOrEquals("southLerp", southLerp, 1);
  Check_default.typeOf.number.greaterThanOrEquals("eastLerp", eastLerp, 0);
  Check_default.typeOf.number.lessThanOrEquals("eastLerp", eastLerp, 1);
  Check_default.typeOf.number.greaterThanOrEquals("northLerp", northLerp, 0);
  Check_default.typeOf.number.lessThanOrEquals("northLerp", northLerp, 1);
  Check_default.typeOf.number.lessThanOrEquals("westLerp", westLerp, eastLerp);
  Check_default.typeOf.number.lessThanOrEquals("southLerp", southLerp, northLerp);
  if (!defined_default(result)) {
    result = new Rectangle();
  }
  if (rectangle.west <= rectangle.east) {
    const width = rectangle.east - rectangle.west;
    result.west = rectangle.west + westLerp * width;
    result.east = rectangle.west + eastLerp * width;
  } else {
    const width = Math_default.TWO_PI + rectangle.east - rectangle.west;
    result.west = Math_default.negativePiToPi(rectangle.west + westLerp * width);
    result.east = Math_default.negativePiToPi(rectangle.west + eastLerp * width);
  }
  const height = rectangle.north - rectangle.south;
  result.south = rectangle.south + southLerp * height;
  result.north = rectangle.south + northLerp * height;
  if (westLerp === 1) {
    result.west = rectangle.east;
  }
  if (eastLerp === 1) {
    result.east = rectangle.east;
  }
  if (southLerp === 1) {
    result.south = rectangle.north;
  }
  if (northLerp === 1) {
    result.north = rectangle.north;
  }
  return result;
};
Rectangle.MAX_VALUE = Object.freeze(
  new Rectangle(
    -Math.PI,
    -Math_default.PI_OVER_TWO,
    Math.PI,
    Math_default.PI_OVER_TWO
  )
);
var Rectangle_default = Rectangle;

// Source/Core/BoundingSphere.js
function BoundingSphere(center, radius) {
  this.center = Cartesian3_default.clone(defaultValue_default(center, Cartesian3_default.ZERO));
  this.radius = defaultValue_default(radius, 0);
}
var fromPointsXMin = new Cartesian3_default();
var fromPointsYMin = new Cartesian3_default();
var fromPointsZMin = new Cartesian3_default();
var fromPointsXMax = new Cartesian3_default();
var fromPointsYMax = new Cartesian3_default();
var fromPointsZMax = new Cartesian3_default();
var fromPointsCurrentPos = new Cartesian3_default();
var fromPointsScratch = new Cartesian3_default();
var fromPointsRitterCenter = new Cartesian3_default();
var fromPointsMinBoxPt = new Cartesian3_default();
var fromPointsMaxBoxPt = new Cartesian3_default();
var fromPointsNaiveCenterScratch = new Cartesian3_default();
var volumeConstant = 4 / 3 * Math_default.PI;
BoundingSphere.fromPoints = function(positions, result) {
  if (!defined_default(result)) {
    result = new BoundingSphere();
  }
  if (!defined_default(positions) || positions.length === 0) {
    result.center = Cartesian3_default.clone(Cartesian3_default.ZERO, result.center);
    result.radius = 0;
    return result;
  }
  const currentPos = Cartesian3_default.clone(positions[0], fromPointsCurrentPos);
  const xMin = Cartesian3_default.clone(currentPos, fromPointsXMin);
  const yMin = Cartesian3_default.clone(currentPos, fromPointsYMin);
  const zMin = Cartesian3_default.clone(currentPos, fromPointsZMin);
  const xMax = Cartesian3_default.clone(currentPos, fromPointsXMax);
  const yMax = Cartesian3_default.clone(currentPos, fromPointsYMax);
  const zMax = Cartesian3_default.clone(currentPos, fromPointsZMax);
  const numPositions = positions.length;
  let i;
  for (i = 1; i < numPositions; i++) {
    Cartesian3_default.clone(positions[i], currentPos);
    const x = currentPos.x;
    const y = currentPos.y;
    const z = currentPos.z;
    if (x < xMin.x) {
      Cartesian3_default.clone(currentPos, xMin);
    }
    if (x > xMax.x) {
      Cartesian3_default.clone(currentPos, xMax);
    }
    if (y < yMin.y) {
      Cartesian3_default.clone(currentPos, yMin);
    }
    if (y > yMax.y) {
      Cartesian3_default.clone(currentPos, yMax);
    }
    if (z < zMin.z) {
      Cartesian3_default.clone(currentPos, zMin);
    }
    if (z > zMax.z) {
      Cartesian3_default.clone(currentPos, zMax);
    }
  }
  const xSpan = Cartesian3_default.magnitudeSquared(
    Cartesian3_default.subtract(xMax, xMin, fromPointsScratch)
  );
  const ySpan = Cartesian3_default.magnitudeSquared(
    Cartesian3_default.subtract(yMax, yMin, fromPointsScratch)
  );
  const zSpan = Cartesian3_default.magnitudeSquared(
    Cartesian3_default.subtract(zMax, zMin, fromPointsScratch)
  );
  let diameter1 = xMin;
  let diameter2 = xMax;
  let maxSpan = xSpan;
  if (ySpan > maxSpan) {
    maxSpan = ySpan;
    diameter1 = yMin;
    diameter2 = yMax;
  }
  if (zSpan > maxSpan) {
    maxSpan = zSpan;
    diameter1 = zMin;
    diameter2 = zMax;
  }
  const ritterCenter = fromPointsRitterCenter;
  ritterCenter.x = (diameter1.x + diameter2.x) * 0.5;
  ritterCenter.y = (diameter1.y + diameter2.y) * 0.5;
  ritterCenter.z = (diameter1.z + diameter2.z) * 0.5;
  let radiusSquared = Cartesian3_default.magnitudeSquared(
    Cartesian3_default.subtract(diameter2, ritterCenter, fromPointsScratch)
  );
  let ritterRadius = Math.sqrt(radiusSquared);
  const minBoxPt = fromPointsMinBoxPt;
  minBoxPt.x = xMin.x;
  minBoxPt.y = yMin.y;
  minBoxPt.z = zMin.z;
  const maxBoxPt = fromPointsMaxBoxPt;
  maxBoxPt.x = xMax.x;
  maxBoxPt.y = yMax.y;
  maxBoxPt.z = zMax.z;
  const naiveCenter = Cartesian3_default.midpoint(
    minBoxPt,
    maxBoxPt,
    fromPointsNaiveCenterScratch
  );
  let naiveRadius = 0;
  for (i = 0; i < numPositions; i++) {
    Cartesian3_default.clone(positions[i], currentPos);
    const r = Cartesian3_default.magnitude(
      Cartesian3_default.subtract(currentPos, naiveCenter, fromPointsScratch)
    );
    if (r > naiveRadius) {
      naiveRadius = r;
    }
    const oldCenterToPointSquared = Cartesian3_default.magnitudeSquared(
      Cartesian3_default.subtract(currentPos, ritterCenter, fromPointsScratch)
    );
    if (oldCenterToPointSquared > radiusSquared) {
      const oldCenterToPoint = Math.sqrt(oldCenterToPointSquared);
      ritterRadius = (ritterRadius + oldCenterToPoint) * 0.5;
      radiusSquared = ritterRadius * ritterRadius;
      const oldToNew = oldCenterToPoint - ritterRadius;
      ritterCenter.x = (ritterRadius * ritterCenter.x + oldToNew * currentPos.x) / oldCenterToPoint;
      ritterCenter.y = (ritterRadius * ritterCenter.y + oldToNew * currentPos.y) / oldCenterToPoint;
      ritterCenter.z = (ritterRadius * ritterCenter.z + oldToNew * currentPos.z) / oldCenterToPoint;
    }
  }
  if (ritterRadius < naiveRadius) {
    Cartesian3_default.clone(ritterCenter, result.center);
    result.radius = ritterRadius;
  } else {
    Cartesian3_default.clone(naiveCenter, result.center);
    result.radius = naiveRadius;
  }
  return result;
};
var defaultProjection = new GeographicProjection_default();
var fromRectangle2DLowerLeft = new Cartesian3_default();
var fromRectangle2DUpperRight = new Cartesian3_default();
var fromRectangle2DSouthwest = new Cartographic_default();
var fromRectangle2DNortheast = new Cartographic_default();
BoundingSphere.fromRectangle2D = function(rectangle, projection, result) {
  return BoundingSphere.fromRectangleWithHeights2D(
    rectangle,
    projection,
    0,
    0,
    result
  );
};
BoundingSphere.fromRectangleWithHeights2D = function(rectangle, projection, minimumHeight, maximumHeight, result) {
  if (!defined_default(result)) {
    result = new BoundingSphere();
  }
  if (!defined_default(rectangle)) {
    result.center = Cartesian3_default.clone(Cartesian3_default.ZERO, result.center);
    result.radius = 0;
    return result;
  }
  projection = defaultValue_default(projection, defaultProjection);
  Rectangle_default.southwest(rectangle, fromRectangle2DSouthwest);
  fromRectangle2DSouthwest.height = minimumHeight;
  Rectangle_default.northeast(rectangle, fromRectangle2DNortheast);
  fromRectangle2DNortheast.height = maximumHeight;
  const lowerLeft = projection.project(
    fromRectangle2DSouthwest,
    fromRectangle2DLowerLeft
  );
  const upperRight = projection.project(
    fromRectangle2DNortheast,
    fromRectangle2DUpperRight
  );
  const width = upperRight.x - lowerLeft.x;
  const height = upperRight.y - lowerLeft.y;
  const elevation = upperRight.z - lowerLeft.z;
  result.radius = Math.sqrt(width * width + height * height + elevation * elevation) * 0.5;
  const center = result.center;
  center.x = lowerLeft.x + width * 0.5;
  center.y = lowerLeft.y + height * 0.5;
  center.z = lowerLeft.z + elevation * 0.5;
  return result;
};
var fromRectangle3DScratch = [];
BoundingSphere.fromRectangle3D = function(rectangle, ellipsoid, surfaceHeight, result) {
  ellipsoid = defaultValue_default(ellipsoid, Ellipsoid_default.WGS84);
  surfaceHeight = defaultValue_default(surfaceHeight, 0);
  if (!defined_default(result)) {
    result = new BoundingSphere();
  }
  if (!defined_default(rectangle)) {
    result.center = Cartesian3_default.clone(Cartesian3_default.ZERO, result.center);
    result.radius = 0;
    return result;
  }
  const positions = Rectangle_default.subsample(
    rectangle,
    ellipsoid,
    surfaceHeight,
    fromRectangle3DScratch
  );
  return BoundingSphere.fromPoints(positions, result);
};
BoundingSphere.fromVertices = function(positions, center, stride, result) {
  if (!defined_default(result)) {
    result = new BoundingSphere();
  }
  if (!defined_default(positions) || positions.length === 0) {
    result.center = Cartesian3_default.clone(Cartesian3_default.ZERO, result.center);
    result.radius = 0;
    return result;
  }
  center = defaultValue_default(center, Cartesian3_default.ZERO);
  stride = defaultValue_default(stride, 3);
  Check_default.typeOf.number.greaterThanOrEquals("stride", stride, 3);
  const currentPos = fromPointsCurrentPos;
  currentPos.x = positions[0] + center.x;
  currentPos.y = positions[1] + center.y;
  currentPos.z = positions[2] + center.z;
  const xMin = Cartesian3_default.clone(currentPos, fromPointsXMin);
  const yMin = Cartesian3_default.clone(currentPos, fromPointsYMin);
  const zMin = Cartesian3_default.clone(currentPos, fromPointsZMin);
  const xMax = Cartesian3_default.clone(currentPos, fromPointsXMax);
  const yMax = Cartesian3_default.clone(currentPos, fromPointsYMax);
  const zMax = Cartesian3_default.clone(currentPos, fromPointsZMax);
  const numElements = positions.length;
  let i;
  for (i = 0; i < numElements; i += stride) {
    const x = positions[i] + center.x;
    const y = positions[i + 1] + center.y;
    const z = positions[i + 2] + center.z;
    currentPos.x = x;
    currentPos.y = y;
    currentPos.z = z;
    if (x < xMin.x) {
      Cartesian3_default.clone(currentPos, xMin);
    }
    if (x > xMax.x) {
      Cartesian3_default.clone(currentPos, xMax);
    }
    if (y < yMin.y) {
      Cartesian3_default.clone(currentPos, yMin);
    }
    if (y > yMax.y) {
      Cartesian3_default.clone(currentPos, yMax);
    }
    if (z < zMin.z) {
      Cartesian3_default.clone(currentPos, zMin);
    }
    if (z > zMax.z) {
      Cartesian3_default.clone(currentPos, zMax);
    }
  }
  const xSpan = Cartesian3_default.magnitudeSquared(
    Cartesian3_default.subtract(xMax, xMin, fromPointsScratch)
  );
  const ySpan = Cartesian3_default.magnitudeSquared(
    Cartesian3_default.subtract(yMax, yMin, fromPointsScratch)
  );
  const zSpan = Cartesian3_default.magnitudeSquared(
    Cartesian3_default.subtract(zMax, zMin, fromPointsScratch)
  );
  let diameter1 = xMin;
  let diameter2 = xMax;
  let maxSpan = xSpan;
  if (ySpan > maxSpan) {
    maxSpan = ySpan;
    diameter1 = yMin;
    diameter2 = yMax;
  }
  if (zSpan > maxSpan) {
    maxSpan = zSpan;
    diameter1 = zMin;
    diameter2 = zMax;
  }
  const ritterCenter = fromPointsRitterCenter;
  ritterCenter.x = (diameter1.x + diameter2.x) * 0.5;
  ritterCenter.y = (diameter1.y + diameter2.y) * 0.5;
  ritterCenter.z = (diameter1.z + diameter2.z) * 0.5;
  let radiusSquared = Cartesian3_default.magnitudeSquared(
    Cartesian3_default.subtract(diameter2, ritterCenter, fromPointsScratch)
  );
  let ritterRadius = Math.sqrt(radiusSquared);
  const minBoxPt = fromPointsMinBoxPt;
  minBoxPt.x = xMin.x;
  minBoxPt.y = yMin.y;
  minBoxPt.z = zMin.z;
  const maxBoxPt = fromPointsMaxBoxPt;
  maxBoxPt.x = xMax.x;
  maxBoxPt.y = yMax.y;
  maxBoxPt.z = zMax.z;
  const naiveCenter = Cartesian3_default.midpoint(
    minBoxPt,
    maxBoxPt,
    fromPointsNaiveCenterScratch
  );
  let naiveRadius = 0;
  for (i = 0; i < numElements; i += stride) {
    currentPos.x = positions[i] + center.x;
    currentPos.y = positions[i + 1] + center.y;
    currentPos.z = positions[i + 2] + center.z;
    const r = Cartesian3_default.magnitude(
      Cartesian3_default.subtract(currentPos, naiveCenter, fromPointsScratch)
    );
    if (r > naiveRadius) {
      naiveRadius = r;
    }
    const oldCenterToPointSquared = Cartesian3_default.magnitudeSquared(
      Cartesian3_default.subtract(currentPos, ritterCenter, fromPointsScratch)
    );
    if (oldCenterToPointSquared > radiusSquared) {
      const oldCenterToPoint = Math.sqrt(oldCenterToPointSquared);
      ritterRadius = (ritterRadius + oldCenterToPoint) * 0.5;
      radiusSquared = ritterRadius * ritterRadius;
      const oldToNew = oldCenterToPoint - ritterRadius;
      ritterCenter.x = (ritterRadius * ritterCenter.x + oldToNew * currentPos.x) / oldCenterToPoint;
      ritterCenter.y = (ritterRadius * ritterCenter.y + oldToNew * currentPos.y) / oldCenterToPoint;
      ritterCenter.z = (ritterRadius * ritterCenter.z + oldToNew * currentPos.z) / oldCenterToPoint;
    }
  }
  if (ritterRadius < naiveRadius) {
    Cartesian3_default.clone(ritterCenter, result.center);
    result.radius = ritterRadius;
  } else {
    Cartesian3_default.clone(naiveCenter, result.center);
    result.radius = naiveRadius;
  }
  return result;
};
BoundingSphere.fromEncodedCartesianVertices = function(positionsHigh, positionsLow, result) {
  if (!defined_default(result)) {
    result = new BoundingSphere();
  }
  if (!defined_default(positionsHigh) || !defined_default(positionsLow) || positionsHigh.length !== positionsLow.length || positionsHigh.length === 0) {
    result.center = Cartesian3_default.clone(Cartesian3_default.ZERO, result.center);
    result.radius = 0;
    return result;
  }
  const currentPos = fromPointsCurrentPos;
  currentPos.x = positionsHigh[0] + positionsLow[0];
  currentPos.y = positionsHigh[1] + positionsLow[1];
  currentPos.z = positionsHigh[2] + positionsLow[2];
  const xMin = Cartesian3_default.clone(currentPos, fromPointsXMin);
  const yMin = Cartesian3_default.clone(currentPos, fromPointsYMin);
  const zMin = Cartesian3_default.clone(currentPos, fromPointsZMin);
  const xMax = Cartesian3_default.clone(currentPos, fromPointsXMax);
  const yMax = Cartesian3_default.clone(currentPos, fromPointsYMax);
  const zMax = Cartesian3_default.clone(currentPos, fromPointsZMax);
  const numElements = positionsHigh.length;
  let i;
  for (i = 0; i < numElements; i += 3) {
    const x = positionsHigh[i] + positionsLow[i];
    const y = positionsHigh[i + 1] + positionsLow[i + 1];
    const z = positionsHigh[i + 2] + positionsLow[i + 2];
    currentPos.x = x;
    currentPos.y = y;
    currentPos.z = z;
    if (x < xMin.x) {
      Cartesian3_default.clone(currentPos, xMin);
    }
    if (x > xMax.x) {
      Cartesian3_default.clone(currentPos, xMax);
    }
    if (y < yMin.y) {
      Cartesian3_default.clone(currentPos, yMin);
    }
    if (y > yMax.y) {
      Cartesian3_default.clone(currentPos, yMax);
    }
    if (z < zMin.z) {
      Cartesian3_default.clone(currentPos, zMin);
    }
    if (z > zMax.z) {
      Cartesian3_default.clone(currentPos, zMax);
    }
  }
  const xSpan = Cartesian3_default.magnitudeSquared(
    Cartesian3_default.subtract(xMax, xMin, fromPointsScratch)
  );
  const ySpan = Cartesian3_default.magnitudeSquared(
    Cartesian3_default.subtract(yMax, yMin, fromPointsScratch)
  );
  const zSpan = Cartesian3_default.magnitudeSquared(
    Cartesian3_default.subtract(zMax, zMin, fromPointsScratch)
  );
  let diameter1 = xMin;
  let diameter2 = xMax;
  let maxSpan = xSpan;
  if (ySpan > maxSpan) {
    maxSpan = ySpan;
    diameter1 = yMin;
    diameter2 = yMax;
  }
  if (zSpan > maxSpan) {
    maxSpan = zSpan;
    diameter1 = zMin;
    diameter2 = zMax;
  }
  const ritterCenter = fromPointsRitterCenter;
  ritterCenter.x = (diameter1.x + diameter2.x) * 0.5;
  ritterCenter.y = (diameter1.y + diameter2.y) * 0.5;
  ritterCenter.z = (diameter1.z + diameter2.z) * 0.5;
  let radiusSquared = Cartesian3_default.magnitudeSquared(
    Cartesian3_default.subtract(diameter2, ritterCenter, fromPointsScratch)
  );
  let ritterRadius = Math.sqrt(radiusSquared);
  const minBoxPt = fromPointsMinBoxPt;
  minBoxPt.x = xMin.x;
  minBoxPt.y = yMin.y;
  minBoxPt.z = zMin.z;
  const maxBoxPt = fromPointsMaxBoxPt;
  maxBoxPt.x = xMax.x;
  maxBoxPt.y = yMax.y;
  maxBoxPt.z = zMax.z;
  const naiveCenter = Cartesian3_default.midpoint(
    minBoxPt,
    maxBoxPt,
    fromPointsNaiveCenterScratch
  );
  let naiveRadius = 0;
  for (i = 0; i < numElements; i += 3) {
    currentPos.x = positionsHigh[i] + positionsLow[i];
    currentPos.y = positionsHigh[i + 1] + positionsLow[i + 1];
    currentPos.z = positionsHigh[i + 2] + positionsLow[i + 2];
    const r = Cartesian3_default.magnitude(
      Cartesian3_default.subtract(currentPos, naiveCenter, fromPointsScratch)
    );
    if (r > naiveRadius) {
      naiveRadius = r;
    }
    const oldCenterToPointSquared = Cartesian3_default.magnitudeSquared(
      Cartesian3_default.subtract(currentPos, ritterCenter, fromPointsScratch)
    );
    if (oldCenterToPointSquared > radiusSquared) {
      const oldCenterToPoint = Math.sqrt(oldCenterToPointSquared);
      ritterRadius = (ritterRadius + oldCenterToPoint) * 0.5;
      radiusSquared = ritterRadius * ritterRadius;
      const oldToNew = oldCenterToPoint - ritterRadius;
      ritterCenter.x = (ritterRadius * ritterCenter.x + oldToNew * currentPos.x) / oldCenterToPoint;
      ritterCenter.y = (ritterRadius * ritterCenter.y + oldToNew * currentPos.y) / oldCenterToPoint;
      ritterCenter.z = (ritterRadius * ritterCenter.z + oldToNew * currentPos.z) / oldCenterToPoint;
    }
  }
  if (ritterRadius < naiveRadius) {
    Cartesian3_default.clone(ritterCenter, result.center);
    result.radius = ritterRadius;
  } else {
    Cartesian3_default.clone(naiveCenter, result.center);
    result.radius = naiveRadius;
  }
  return result;
};
BoundingSphere.fromCornerPoints = function(corner, oppositeCorner, result) {
  Check_default.typeOf.object("corner", corner);
  Check_default.typeOf.object("oppositeCorner", oppositeCorner);
  if (!defined_default(result)) {
    result = new BoundingSphere();
  }
  const center = Cartesian3_default.midpoint(corner, oppositeCorner, result.center);
  result.radius = Cartesian3_default.distance(center, oppositeCorner);
  return result;
};
BoundingSphere.fromEllipsoid = function(ellipsoid, result) {
  Check_default.typeOf.object("ellipsoid", ellipsoid);
  if (!defined_default(result)) {
    result = new BoundingSphere();
  }
  Cartesian3_default.clone(Cartesian3_default.ZERO, result.center);
  result.radius = ellipsoid.maximumRadius;
  return result;
};
var fromBoundingSpheresScratch = new Cartesian3_default();
BoundingSphere.fromBoundingSpheres = function(boundingSpheres, result) {
  if (!defined_default(result)) {
    result = new BoundingSphere();
  }
  if (!defined_default(boundingSpheres) || boundingSpheres.length === 0) {
    result.center = Cartesian3_default.clone(Cartesian3_default.ZERO, result.center);
    result.radius = 0;
    return result;
  }
  const length3 = boundingSpheres.length;
  if (length3 === 1) {
    return BoundingSphere.clone(boundingSpheres[0], result);
  }
  if (length3 === 2) {
    return BoundingSphere.union(boundingSpheres[0], boundingSpheres[1], result);
  }
  const positions = [];
  let i;
  for (i = 0; i < length3; i++) {
    positions.push(boundingSpheres[i].center);
  }
  result = BoundingSphere.fromPoints(positions, result);
  const center = result.center;
  let radius = result.radius;
  for (i = 0; i < length3; i++) {
    const tmp2 = boundingSpheres[i];
    radius = Math.max(
      radius,
      Cartesian3_default.distance(center, tmp2.center, fromBoundingSpheresScratch) + tmp2.radius
    );
  }
  result.radius = radius;
  return result;
};
var fromOrientedBoundingBoxScratchU = new Cartesian3_default();
var fromOrientedBoundingBoxScratchV = new Cartesian3_default();
var fromOrientedBoundingBoxScratchW = new Cartesian3_default();
BoundingSphere.fromOrientedBoundingBox = function(orientedBoundingBox, result) {
  Check_default.defined("orientedBoundingBox", orientedBoundingBox);
  if (!defined_default(result)) {
    result = new BoundingSphere();
  }
  const halfAxes = orientedBoundingBox.halfAxes;
  const u3 = Matrix3_default.getColumn(halfAxes, 0, fromOrientedBoundingBoxScratchU);
  const v7 = Matrix3_default.getColumn(halfAxes, 1, fromOrientedBoundingBoxScratchV);
  const w = Matrix3_default.getColumn(halfAxes, 2, fromOrientedBoundingBoxScratchW);
  Cartesian3_default.add(u3, v7, u3);
  Cartesian3_default.add(u3, w, u3);
  result.center = Cartesian3_default.clone(orientedBoundingBox.center, result.center);
  result.radius = Cartesian3_default.magnitude(u3);
  return result;
};
var scratchFromTransformationCenter = new Cartesian3_default();
var scratchFromTransformationScale = new Cartesian3_default();
BoundingSphere.fromTransformation = function(transformation, result) {
  Check_default.typeOf.object("transformation", transformation);
  if (!defined_default(result)) {
    result = new BoundingSphere();
  }
  const center = Matrix4_default.getTranslation(
    transformation,
    scratchFromTransformationCenter
  );
  const scale = Matrix4_default.getScale(
    transformation,
    scratchFromTransformationScale
  );
  const radius = 0.5 * Cartesian3_default.magnitude(scale);
  result.center = Cartesian3_default.clone(center, result.center);
  result.radius = radius;
  return result;
};
BoundingSphere.clone = function(sphere, result) {
  if (!defined_default(sphere)) {
    return void 0;
  }
  if (!defined_default(result)) {
    return new BoundingSphere(sphere.center, sphere.radius);
  }
  result.center = Cartesian3_default.clone(sphere.center, result.center);
  result.radius = sphere.radius;
  return result;
};
BoundingSphere.packedLength = 4;
BoundingSphere.pack = function(value, array, startingIndex) {
  Check_default.typeOf.object("value", value);
  Check_default.defined("array", array);
  startingIndex = defaultValue_default(startingIndex, 0);
  const center = value.center;
  array[startingIndex++] = center.x;
  array[startingIndex++] = center.y;
  array[startingIndex++] = center.z;
  array[startingIndex] = value.radius;
  return array;
};
BoundingSphere.unpack = function(array, startingIndex, result) {
  Check_default.defined("array", array);
  startingIndex = defaultValue_default(startingIndex, 0);
  if (!defined_default(result)) {
    result = new BoundingSphere();
  }
  const center = result.center;
  center.x = array[startingIndex++];
  center.y = array[startingIndex++];
  center.z = array[startingIndex++];
  result.radius = array[startingIndex];
  return result;
};
var unionScratch = new Cartesian3_default();
var unionScratchCenter = new Cartesian3_default();
BoundingSphere.union = function(left, right, result) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  if (!defined_default(result)) {
    result = new BoundingSphere();
  }
  const leftCenter = left.center;
  const leftRadius = left.radius;
  const rightCenter = right.center;
  const rightRadius = right.radius;
  const toRightCenter = Cartesian3_default.subtract(
    rightCenter,
    leftCenter,
    unionScratch
  );
  const centerSeparation = Cartesian3_default.magnitude(toRightCenter);
  if (leftRadius >= centerSeparation + rightRadius) {
    left.clone(result);
    return result;
  }
  if (rightRadius >= centerSeparation + leftRadius) {
    right.clone(result);
    return result;
  }
  const halfDistanceBetweenTangentPoints = (leftRadius + centerSeparation + rightRadius) * 0.5;
  const center = Cartesian3_default.multiplyByScalar(
    toRightCenter,
    (-leftRadius + halfDistanceBetweenTangentPoints) / centerSeparation,
    unionScratchCenter
  );
  Cartesian3_default.add(center, leftCenter, center);
  Cartesian3_default.clone(center, result.center);
  result.radius = halfDistanceBetweenTangentPoints;
  return result;
};
var expandScratch = new Cartesian3_default();
BoundingSphere.expand = function(sphere, point, result) {
  Check_default.typeOf.object("sphere", sphere);
  Check_default.typeOf.object("point", point);
  result = BoundingSphere.clone(sphere, result);
  const radius = Cartesian3_default.magnitude(
    Cartesian3_default.subtract(point, result.center, expandScratch)
  );
  if (radius > result.radius) {
    result.radius = radius;
  }
  return result;
};
BoundingSphere.intersectPlane = function(sphere, plane) {
  Check_default.typeOf.object("sphere", sphere);
  Check_default.typeOf.object("plane", plane);
  const center = sphere.center;
  const radius = sphere.radius;
  const normal2 = plane.normal;
  const distanceToPlane = Cartesian3_default.dot(normal2, center) + plane.distance;
  if (distanceToPlane < -radius) {
    return Intersect_default.OUTSIDE;
  } else if (distanceToPlane < radius) {
    return Intersect_default.INTERSECTING;
  }
  return Intersect_default.INSIDE;
};
BoundingSphere.transform = function(sphere, transform3, result) {
  Check_default.typeOf.object("sphere", sphere);
  Check_default.typeOf.object("transform", transform3);
  if (!defined_default(result)) {
    result = new BoundingSphere();
  }
  result.center = Matrix4_default.multiplyByPoint(
    transform3,
    sphere.center,
    result.center
  );
  result.radius = Matrix4_default.getMaximumScale(transform3) * sphere.radius;
  return result;
};
var distanceSquaredToScratch = new Cartesian3_default();
BoundingSphere.distanceSquaredTo = function(sphere, cartesian11) {
  Check_default.typeOf.object("sphere", sphere);
  Check_default.typeOf.object("cartesian", cartesian11);
  const diff = Cartesian3_default.subtract(
    sphere.center,
    cartesian11,
    distanceSquaredToScratch
  );
  const distance2 = Cartesian3_default.magnitude(diff) - sphere.radius;
  if (distance2 <= 0) {
    return 0;
  }
  return distance2 * distance2;
};
BoundingSphere.transformWithoutScale = function(sphere, transform3, result) {
  Check_default.typeOf.object("sphere", sphere);
  Check_default.typeOf.object("transform", transform3);
  if (!defined_default(result)) {
    result = new BoundingSphere();
  }
  result.center = Matrix4_default.multiplyByPoint(
    transform3,
    sphere.center,
    result.center
  );
  result.radius = sphere.radius;
  return result;
};
var scratchCartesian3 = new Cartesian3_default();
BoundingSphere.computePlaneDistances = function(sphere, position, direction2, result) {
  Check_default.typeOf.object("sphere", sphere);
  Check_default.typeOf.object("position", position);
  Check_default.typeOf.object("direction", direction2);
  if (!defined_default(result)) {
    result = new Interval_default();
  }
  const toCenter = Cartesian3_default.subtract(
    sphere.center,
    position,
    scratchCartesian3
  );
  const mag = Cartesian3_default.dot(direction2, toCenter);
  result.start = mag - sphere.radius;
  result.stop = mag + sphere.radius;
  return result;
};
var projectTo2DNormalScratch = new Cartesian3_default();
var projectTo2DEastScratch = new Cartesian3_default();
var projectTo2DNorthScratch = new Cartesian3_default();
var projectTo2DWestScratch = new Cartesian3_default();
var projectTo2DSouthScratch = new Cartesian3_default();
var projectTo2DCartographicScratch = new Cartographic_default();
var projectTo2DPositionsScratch = new Array(8);
for (let n = 0; n < 8; ++n) {
  projectTo2DPositionsScratch[n] = new Cartesian3_default();
}
var projectTo2DProjection = new GeographicProjection_default();
BoundingSphere.projectTo2D = function(sphere, projection, result) {
  Check_default.typeOf.object("sphere", sphere);
  projection = defaultValue_default(projection, projectTo2DProjection);
  const ellipsoid = projection.ellipsoid;
  let center = sphere.center;
  const radius = sphere.radius;
  let normal2;
  if (Cartesian3_default.equals(center, Cartesian3_default.ZERO)) {
    normal2 = Cartesian3_default.clone(Cartesian3_default.UNIT_X, projectTo2DNormalScratch);
  } else {
    normal2 = ellipsoid.geodeticSurfaceNormal(center, projectTo2DNormalScratch);
  }
  const east = Cartesian3_default.cross(
    Cartesian3_default.UNIT_Z,
    normal2,
    projectTo2DEastScratch
  );
  Cartesian3_default.normalize(east, east);
  const north = Cartesian3_default.cross(normal2, east, projectTo2DNorthScratch);
  Cartesian3_default.normalize(north, north);
  Cartesian3_default.multiplyByScalar(normal2, radius, normal2);
  Cartesian3_default.multiplyByScalar(north, radius, north);
  Cartesian3_default.multiplyByScalar(east, radius, east);
  const south = Cartesian3_default.negate(north, projectTo2DSouthScratch);
  const west = Cartesian3_default.negate(east, projectTo2DWestScratch);
  const positions = projectTo2DPositionsScratch;
  let corner = positions[0];
  Cartesian3_default.add(normal2, north, corner);
  Cartesian3_default.add(corner, east, corner);
  corner = positions[1];
  Cartesian3_default.add(normal2, north, corner);
  Cartesian3_default.add(corner, west, corner);
  corner = positions[2];
  Cartesian3_default.add(normal2, south, corner);
  Cartesian3_default.add(corner, west, corner);
  corner = positions[3];
  Cartesian3_default.add(normal2, south, corner);
  Cartesian3_default.add(corner, east, corner);
  Cartesian3_default.negate(normal2, normal2);
  corner = positions[4];
  Cartesian3_default.add(normal2, north, corner);
  Cartesian3_default.add(corner, east, corner);
  corner = positions[5];
  Cartesian3_default.add(normal2, north, corner);
  Cartesian3_default.add(corner, west, corner);
  corner = positions[6];
  Cartesian3_default.add(normal2, south, corner);
  Cartesian3_default.add(corner, west, corner);
  corner = positions[7];
  Cartesian3_default.add(normal2, south, corner);
  Cartesian3_default.add(corner, east, corner);
  const length3 = positions.length;
  for (let i = 0; i < length3; ++i) {
    const position = positions[i];
    Cartesian3_default.add(center, position, position);
    const cartographic2 = ellipsoid.cartesianToCartographic(
      position,
      projectTo2DCartographicScratch
    );
    projection.project(cartographic2, position);
  }
  result = BoundingSphere.fromPoints(positions, result);
  center = result.center;
  const x = center.x;
  const y = center.y;
  const z = center.z;
  center.x = z;
  center.y = x;
  center.z = y;
  return result;
};
BoundingSphere.isOccluded = function(sphere, occluder) {
  Check_default.typeOf.object("sphere", sphere);
  Check_default.typeOf.object("occluder", occluder);
  return !occluder.isBoundingSphereVisible(sphere);
};
BoundingSphere.equals = function(left, right) {
  return left === right || defined_default(left) && defined_default(right) && Cartesian3_default.equals(left.center, right.center) && left.radius === right.radius;
};
BoundingSphere.prototype.intersectPlane = function(plane) {
  return BoundingSphere.intersectPlane(this, plane);
};
BoundingSphere.prototype.distanceSquaredTo = function(cartesian11) {
  return BoundingSphere.distanceSquaredTo(this, cartesian11);
};
BoundingSphere.prototype.computePlaneDistances = function(position, direction2, result) {
  return BoundingSphere.computePlaneDistances(
    this,
    position,
    direction2,
    result
  );
};
BoundingSphere.prototype.isOccluded = function(occluder) {
  return BoundingSphere.isOccluded(this, occluder);
};
BoundingSphere.prototype.equals = function(right) {
  return BoundingSphere.equals(this, right);
};
BoundingSphere.prototype.clone = function(result) {
  return BoundingSphere.clone(this, result);
};
BoundingSphere.prototype.volume = function() {
  const radius = this.radius;
  return volumeConstant * radius * radius * radius;
};
var BoundingSphere_default = BoundingSphere;

// Source/Core/getAbsoluteUri.js
var import_urijs = __toESM(require_URI(), 1);
function getAbsoluteUri(relative, base) {
  let documentObject;
  if (typeof document !== "undefined") {
    documentObject = document;
  }
  return getAbsoluteUri._implementation(relative, base, documentObject);
}
getAbsoluteUri._implementation = function(relative, base, documentObject) {
  if (!defined_default(relative)) {
    throw new DeveloperError_default("relative uri is required.");
  }
  if (!defined_default(base)) {
    if (typeof documentObject === "undefined") {
      return relative;
    }
    base = defaultValue_default(documentObject.baseURI, documentObject.location.href);
  }
  const relativeUri = new import_urijs.default(relative);
  if (relativeUri.scheme() !== "") {
    return relativeUri.toString();
  }
  return relativeUri.absoluteTo(base).toString();
};
var getAbsoluteUri_default = getAbsoluteUri;

// Source/Core/Resource.js
var import_urijs6 = __toESM(require_URI(), 1);

// Source/Core/appendForwardSlash.js
function appendForwardSlash(url2) {
  if (url2.length === 0 || url2[url2.length - 1] !== "/") {
    url2 = `${url2}/`;
  }
  return url2;
}
var appendForwardSlash_default = appendForwardSlash;

// Source/Core/clone.js
function clone(object, deep) {
  if (object === null || typeof object !== "object") {
    return object;
  }
  deep = defaultValue_default(deep, false);
  const result = new object.constructor();
  for (const propertyName in object) {
    if (object.hasOwnProperty(propertyName)) {
      let value = object[propertyName];
      if (deep) {
        value = clone(value, deep);
      }
      result[propertyName] = value;
    }
  }
  return result;
}
var clone_default = clone;

// Source/Core/combine.js
function combine(object1, object2, deep) {
  deep = defaultValue_default(deep, false);
  const result = {};
  const object1Defined = defined_default(object1);
  const object2Defined = defined_default(object2);
  let property;
  let object1Value;
  let object2Value;
  if (object1Defined) {
    for (property in object1) {
      if (object1.hasOwnProperty(property)) {
        object1Value = object1[property];
        if (object2Defined && deep && typeof object1Value === "object" && object2.hasOwnProperty(property)) {
          object2Value = object2[property];
          if (typeof object2Value === "object") {
            result[property] = combine(object1Value, object2Value, deep);
          } else {
            result[property] = object1Value;
          }
        } else {
          result[property] = object1Value;
        }
      }
    }
  }
  if (object2Defined) {
    for (property in object2) {
      if (object2.hasOwnProperty(property) && !result.hasOwnProperty(property)) {
        object2Value = object2[property];
        result[property] = object2Value;
      }
    }
  }
  return result;
}
var combine_default = combine;

// Source/Core/defer.js
function defer() {
  let resolve2;
  let reject;
  const promise = new Promise(function(res, rej) {
    resolve2 = res;
    reject = rej;
  });
  return {
    resolve: resolve2,
    reject,
    promise
  };
}
var defer_default = defer;

// Source/Core/getBaseUri.js
var import_urijs2 = __toESM(require_URI(), 1);
function getBaseUri(uri, includeQuery) {
  if (!defined_default(uri)) {
    throw new DeveloperError_default("uri is required.");
  }
  let basePath = "";
  const i = uri.lastIndexOf("/");
  if (i !== -1) {
    basePath = uri.substring(0, i + 1);
  }
  if (!includeQuery) {
    return basePath;
  }
  uri = new import_urijs2.default(uri);
  if (uri.query().length !== 0) {
    basePath += `?${uri.query()}`;
  }
  if (uri.fragment().length !== 0) {
    basePath += `#${uri.fragment()}`;
  }
  return basePath;
}
var getBaseUri_default = getBaseUri;

// Source/Core/getExtensionFromUri.js
var import_urijs3 = __toESM(require_URI(), 1);
function getExtensionFromUri(uri) {
  if (!defined_default(uri)) {
    throw new DeveloperError_default("uri is required.");
  }
  const uriObject = new import_urijs3.default(uri);
  uriObject.normalize();
  let path = uriObject.path();
  let index = path.lastIndexOf("/");
  if (index !== -1) {
    path = path.substr(index + 1);
  }
  index = path.lastIndexOf(".");
  if (index === -1) {
    path = "";
  } else {
    path = path.substr(index + 1);
  }
  return path;
}
var getExtensionFromUri_default = getExtensionFromUri;

// Source/Core/getImagePixels.js
var context2DsByWidthAndHeight = {};
function getImagePixels(image, width, height) {
  if (!defined_default(width)) {
    width = image.width;
  }
  if (!defined_default(height)) {
    height = image.height;
  }
  let context2DsByHeight = context2DsByWidthAndHeight[width];
  if (!defined_default(context2DsByHeight)) {
    context2DsByHeight = {};
    context2DsByWidthAndHeight[width] = context2DsByHeight;
  }
  let context2d = context2DsByHeight[height];
  if (!defined_default(context2d)) {
    const canvas = document.createElement("canvas");
    canvas.width = width;
    canvas.height = height;
    context2d = canvas.getContext("2d");
    context2d.globalCompositeOperation = "copy";
    context2DsByHeight[height] = context2d;
  }
  context2d.drawImage(image, 0, 0, width, height);
  return context2d.getImageData(0, 0, width, height).data;
}
var getImagePixels_default = getImagePixels;

// Source/Core/isBlobUri.js
var blobUriRegex = /^blob:/i;
function isBlobUri(uri) {
  Check_default.typeOf.string("uri", uri);
  return blobUriRegex.test(uri);
}
var isBlobUri_default = isBlobUri;

// Source/Core/isCrossOriginUrl.js
var a;
function isCrossOriginUrl(url2) {
  if (!defined_default(a)) {
    a = document.createElement("a");
  }
  a.href = window.location.href;
  const host = a.host;
  const protocol = a.protocol;
  a.href = url2;
  a.href = a.href;
  return protocol !== a.protocol || host !== a.host;
}
var isCrossOriginUrl_default = isCrossOriginUrl;

// Source/Core/isDataUri.js
var dataUriRegex = /^data:/i;
function isDataUri(uri) {
  Check_default.typeOf.string("uri", uri);
  return dataUriRegex.test(uri);
}
var isDataUri_default = isDataUri;

// Source/Core/loadAndExecuteScript.js
function loadAndExecuteScript(url2) {
  const script = document.createElement("script");
  script.async = true;
  script.src = url2;
  return new Promise((resolve2, reject) => {
    if (window.crossOriginIsolated) {
      script.setAttribute("crossorigin", "anonymous");
    }
    const head = document.getElementsByTagName("head")[0];
    script.onload = function() {
      script.onload = void 0;
      head.removeChild(script);
      resolve2();
    };
    script.onerror = function(e) {
      reject(e);
    };
    head.appendChild(script);
  });
}
var loadAndExecuteScript_default = loadAndExecuteScript;

// Source/Core/objectToQuery.js
function objectToQuery(obj) {
  if (!defined_default(obj)) {
    throw new DeveloperError_default("obj is required.");
  }
  let result = "";
  for (const propName in obj) {
    if (obj.hasOwnProperty(propName)) {
      const value = obj[propName];
      const part = `${encodeURIComponent(propName)}=`;
      if (Array.isArray(value)) {
        for (let i = 0, len = value.length; i < len; ++i) {
          result += `${part + encodeURIComponent(value[i])}&`;
        }
      } else {
        result += `${part + encodeURIComponent(value)}&`;
      }
    }
  }
  result = result.slice(0, -1);
  return result;
}
var objectToQuery_default = objectToQuery;

// Source/Core/queryToObject.js
function queryToObject(queryString) {
  if (!defined_default(queryString)) {
    throw new DeveloperError_default("queryString is required.");
  }
  const result = {};
  if (queryString === "") {
    return result;
  }
  const parts = queryString.replace(/\+/g, "%20").split(/[&;]/);
  for (let i = 0, len = parts.length; i < len; ++i) {
    const subparts = parts[i].split("=");
    const name = decodeURIComponent(subparts[0]);
    let value = subparts[1];
    if (defined_default(value)) {
      value = decodeURIComponent(value);
    } else {
      value = "";
    }
    const resultValue = result[name];
    if (typeof resultValue === "string") {
      result[name] = [resultValue, value];
    } else if (Array.isArray(resultValue)) {
      resultValue.push(value);
    } else {
      result[name] = value;
    }
  }
  return result;
}
var queryToObject_default = queryToObject;

// Source/Core/RequestState.js
var RequestState = {
  UNISSUED: 0,
  ISSUED: 1,
  ACTIVE: 2,
  RECEIVED: 3,
  CANCELLED: 4,
  FAILED: 5
};
var RequestState_default = Object.freeze(RequestState);

// Source/Core/RequestType.js
var RequestType = {
  TERRAIN: 0,
  IMAGERY: 1,
  TILES3D: 2,
  OTHER: 3
};
var RequestType_default = Object.freeze(RequestType);

// Source/Core/Request.js
function Request(options) {
  options = defaultValue_default(options, defaultValue_default.EMPTY_OBJECT);
  const throttleByServer = defaultValue_default(options.throttleByServer, false);
  const throttle = defaultValue_default(options.throttle, false);
  this.url = options.url;
  this.requestFunction = options.requestFunction;
  this.cancelFunction = options.cancelFunction;
  this.priorityFunction = options.priorityFunction;
  this.priority = defaultValue_default(options.priority, 0);
  this.throttle = throttle;
  this.throttleByServer = throttleByServer;
  this.type = defaultValue_default(options.type, RequestType_default.OTHER);
  this.serverKey = void 0;
  this.state = RequestState_default.UNISSUED;
  this.deferred = void 0;
  this.cancelled = false;
}
Request.prototype.cancel = function() {
  this.cancelled = true;
};
Request.prototype.clone = function(result) {
  if (!defined_default(result)) {
    return new Request(this);
  }
  result.url = this.url;
  result.requestFunction = this.requestFunction;
  result.cancelFunction = this.cancelFunction;
  result.priorityFunction = this.priorityFunction;
  result.priority = this.priority;
  result.throttle = this.throttle;
  result.throttleByServer = this.throttleByServer;
  result.type = this.type;
  result.serverKey = this.serverKey;
  result.state = this.RequestState.UNISSUED;
  result.deferred = void 0;
  result.cancelled = false;
  return result;
};
var Request_default = Request;

// Source/Core/parseResponseHeaders.js
function parseResponseHeaders(headerString) {
  const headers = {};
  if (!headerString) {
    return headers;
  }
  const headerPairs = headerString.split("\r\n");
  for (let i = 0; i < headerPairs.length; ++i) {
    const headerPair = headerPairs[i];
    const index = headerPair.indexOf(": ");
    if (index > 0) {
      const key = headerPair.substring(0, index);
      const val = headerPair.substring(index + 2);
      headers[key] = val;
    }
  }
  return headers;
}
var parseResponseHeaders_default = parseResponseHeaders;

// Source/Core/RequestErrorEvent.js
function RequestErrorEvent(statusCode, response, responseHeaders) {
  this.statusCode = statusCode;
  this.response = response;
  this.responseHeaders = responseHeaders;
  if (typeof this.responseHeaders === "string") {
    this.responseHeaders = parseResponseHeaders_default(this.responseHeaders);
  }
}
RequestErrorEvent.prototype.toString = function() {
  let str = "Request has failed.";
  if (defined_default(this.statusCode)) {
    str += ` Status Code: ${this.statusCode}`;
  }
  return str;
};
var RequestErrorEvent_default = RequestErrorEvent;

// Source/Core/RequestScheduler.js
var import_urijs4 = __toESM(require_URI(), 1);

// Source/Core/Event.js
function Event() {
  this._listeners = [];
  this._scopes = [];
  this._toRemove = [];
  this._insideRaiseEvent = false;
}
Object.defineProperties(Event.prototype, {
  numberOfListeners: {
    get: function() {
      return this._listeners.length - this._toRemove.length;
    }
  }
});
Event.prototype.addEventListener = function(listener, scope) {
  Check_default.typeOf.func("listener", listener);
  this._listeners.push(listener);
  this._scopes.push(scope);
  const event = this;
  return function() {
    event.removeEventListener(listener, scope);
  };
};
Event.prototype.removeEventListener = function(listener, scope) {
  Check_default.typeOf.func("listener", listener);
  const listeners = this._listeners;
  const scopes = this._scopes;
  let index = -1;
  for (let i = 0; i < listeners.length; i++) {
    if (listeners[i] === listener && scopes[i] === scope) {
      index = i;
      break;
    }
  }
  if (index !== -1) {
    if (this._insideRaiseEvent) {
      this._toRemove.push(index);
      listeners[index] = void 0;
      scopes[index] = void 0;
    } else {
      listeners.splice(index, 1);
      scopes.splice(index, 1);
    }
    return true;
  }
  return false;
};
function compareNumber(a3, b) {
  return b - a3;
}
Event.prototype.raiseEvent = function() {
  this._insideRaiseEvent = true;
  let i;
  const listeners = this._listeners;
  const scopes = this._scopes;
  let length3 = listeners.length;
  for (i = 0; i < length3; i++) {
    const listener = listeners[i];
    if (defined_default(listener)) {
      listeners[i].apply(scopes[i], arguments);
    }
  }
  const toRemove = this._toRemove;
  length3 = toRemove.length;
  if (length3 > 0) {
    toRemove.sort(compareNumber);
    for (i = 0; i < length3; i++) {
      const index = toRemove[i];
      listeners.splice(index, 1);
      scopes.splice(index, 1);
    }
    toRemove.length = 0;
  }
  this._insideRaiseEvent = false;
};
var Event_default = Event;

// Source/Core/Heap.js
function Heap(options) {
  Check_default.typeOf.object("options", options);
  Check_default.defined("options.comparator", options.comparator);
  this._comparator = options.comparator;
  this._array = [];
  this._length = 0;
  this._maximumLength = void 0;
}
Object.defineProperties(Heap.prototype, {
  length: {
    get: function() {
      return this._length;
    }
  },
  internalArray: {
    get: function() {
      return this._array;
    }
  },
  maximumLength: {
    get: function() {
      return this._maximumLength;
    },
    set: function(value) {
      Check_default.typeOf.number.greaterThanOrEquals("maximumLength", value, 0);
      const originalLength = this._length;
      if (value < originalLength) {
        const array = this._array;
        for (let i = value; i < originalLength; ++i) {
          array[i] = void 0;
        }
        this._length = value;
        array.length = value;
      }
      this._maximumLength = value;
    }
  },
  comparator: {
    get: function() {
      return this._comparator;
    }
  }
});
function swap(array, a3, b) {
  const temp = array[a3];
  array[a3] = array[b];
  array[b] = temp;
}
Heap.prototype.reserve = function(length3) {
  length3 = defaultValue_default(length3, this._length);
  this._array.length = length3;
};
Heap.prototype.heapify = function(index) {
  index = defaultValue_default(index, 0);
  const length3 = this._length;
  const comparator = this._comparator;
  const array = this._array;
  let candidate = -1;
  let inserting = true;
  while (inserting) {
    const right = 2 * (index + 1);
    const left = right - 1;
    if (left < length3 && comparator(array[left], array[index]) < 0) {
      candidate = left;
    } else {
      candidate = index;
    }
    if (right < length3 && comparator(array[right], array[candidate]) < 0) {
      candidate = right;
    }
    if (candidate !== index) {
      swap(array, candidate, index);
      index = candidate;
    } else {
      inserting = false;
    }
  }
};
Heap.prototype.resort = function() {
  const length3 = this._length;
  for (let i = Math.ceil(length3 / 2); i >= 0; --i) {
    this.heapify(i);
  }
};
Heap.prototype.insert = function(element) {
  Check_default.defined("element", element);
  const array = this._array;
  const comparator = this._comparator;
  const maximumLength = this._maximumLength;
  let index = this._length++;
  if (index < array.length) {
    array[index] = element;
  } else {
    array.push(element);
  }
  while (index !== 0) {
    const parent = Math.floor((index - 1) / 2);
    if (comparator(array[index], array[parent]) < 0) {
      swap(array, index, parent);
      index = parent;
    } else {
      break;
    }
  }
  let removedElement;
  if (defined_default(maximumLength) && this._length > maximumLength) {
    removedElement = array[maximumLength];
    this._length = maximumLength;
  }
  return removedElement;
};
Heap.prototype.pop = function(index) {
  index = defaultValue_default(index, 0);
  if (this._length === 0) {
    return void 0;
  }
  Check_default.typeOf.number.lessThan("index", index, this._length);
  const array = this._array;
  const root = array[index];
  swap(array, index, --this._length);
  this.heapify(index);
  array[this._length] = void 0;
  return root;
};
var Heap_default = Heap;

// Source/Core/RequestScheduler.js
function sortRequests(a3, b) {
  return a3.priority - b.priority;
}
var statistics = {
  numberOfAttemptedRequests: 0,
  numberOfActiveRequests: 0,
  numberOfCancelledRequests: 0,
  numberOfCancelledActiveRequests: 0,
  numberOfFailedRequests: 0,
  numberOfActiveRequestsEver: 0,
  lastNumberOfActiveRequests: 0
};
var priorityHeapLength = 20;
var requestHeap = new Heap_default({
  comparator: sortRequests
});
requestHeap.maximumLength = priorityHeapLength;
requestHeap.reserve(priorityHeapLength);
var activeRequests = [];
var numberOfActiveRequestsByServer = {};
var pageUri = typeof document !== "undefined" ? new import_urijs4.default(document.location.href) : new import_urijs4.default();
var requestCompletedEvent = new Event_default();
function RequestScheduler() {
}
RequestScheduler.maximumRequests = 50;
RequestScheduler.maximumRequestsPerServer = 6;
RequestScheduler.requestsByServer = {
  "api.cesium.com:443": 18,
  "assets.cesium.com:443": 18
};
RequestScheduler.throttleRequests = true;
RequestScheduler.debugShowStatistics = false;
RequestScheduler.requestCompletedEvent = requestCompletedEvent;
Object.defineProperties(RequestScheduler, {
  statistics: {
    get: function() {
      return statistics;
    }
  },
  priorityHeapLength: {
    get: function() {
      return priorityHeapLength;
    },
    set: function(value) {
      if (value < priorityHeapLength) {
        while (requestHeap.length > value) {
          const request = requestHeap.pop();
          cancelRequest(request);
        }
      }
      priorityHeapLength = value;
      requestHeap.maximumLength = value;
      requestHeap.reserve(value);
    }
  }
});
function updatePriority(request) {
  if (defined_default(request.priorityFunction)) {
    request.priority = request.priorityFunction();
  }
}
RequestScheduler.serverHasOpenSlots = function(serverKey, desiredRequests) {
  desiredRequests = defaultValue_default(desiredRequests, 1);
  const maxRequests = defaultValue_default(
    RequestScheduler.requestsByServer[serverKey],
    RequestScheduler.maximumRequestsPerServer
  );
  const hasOpenSlotsServer = numberOfActiveRequestsByServer[serverKey] + desiredRequests <= maxRequests;
  return hasOpenSlotsServer;
};
RequestScheduler.heapHasOpenSlots = function(desiredRequests) {
  const hasOpenSlotsHeap = requestHeap.length + desiredRequests <= priorityHeapLength;
  return hasOpenSlotsHeap;
};
function issueRequest(request) {
  if (request.state === RequestState_default.UNISSUED) {
    request.state = RequestState_default.ISSUED;
    request.deferred = defer_default();
  }
  return request.deferred.promise;
}
function getRequestReceivedFunction(request) {
  return function(results) {
    if (request.state === RequestState_default.CANCELLED) {
      return;
    }
    const deferred = request.deferred;
    --statistics.numberOfActiveRequests;
    --numberOfActiveRequestsByServer[request.serverKey];
    requestCompletedEvent.raiseEvent();
    request.state = RequestState_default.RECEIVED;
    request.deferred = void 0;
    deferred.resolve(results);
  };
}
function getRequestFailedFunction(request) {
  return function(error) {
    if (request.state === RequestState_default.CANCELLED) {
      return;
    }
    ++statistics.numberOfFailedRequests;
    --statistics.numberOfActiveRequests;
    --numberOfActiveRequestsByServer[request.serverKey];
    requestCompletedEvent.raiseEvent(error);
    request.state = RequestState_default.FAILED;
    request.deferred.reject(error);
  };
}
function startRequest(request) {
  const promise = issueRequest(request);
  request.state = RequestState_default.ACTIVE;
  activeRequests.push(request);
  ++statistics.numberOfActiveRequests;
  ++statistics.numberOfActiveRequestsEver;
  ++numberOfActiveRequestsByServer[request.serverKey];
  request.requestFunction().then(getRequestReceivedFunction(request)).catch(getRequestFailedFunction(request));
  return promise;
}
function cancelRequest(request) {
  const active = request.state === RequestState_default.ACTIVE;
  request.state = RequestState_default.CANCELLED;
  ++statistics.numberOfCancelledRequests;
  if (defined_default(request.deferred)) {
    const deferred = request.deferred;
    request.deferred = void 0;
    deferred.reject();
  }
  if (active) {
    --statistics.numberOfActiveRequests;
    --numberOfActiveRequestsByServer[request.serverKey];
    ++statistics.numberOfCancelledActiveRequests;
  }
  if (defined_default(request.cancelFunction)) {
    request.cancelFunction();
  }
}
RequestScheduler.update = function() {
  let i;
  let request;
  let removeCount = 0;
  const activeLength = activeRequests.length;
  for (i = 0; i < activeLength; ++i) {
    request = activeRequests[i];
    if (request.cancelled) {
      cancelRequest(request);
    }
    if (request.state !== RequestState_default.ACTIVE) {
      ++removeCount;
      continue;
    }
    if (removeCount > 0) {
      activeRequests[i - removeCount] = request;
    }
  }
  activeRequests.length -= removeCount;
  const issuedRequests = requestHeap.internalArray;
  const issuedLength = requestHeap.length;
  for (i = 0; i < issuedLength; ++i) {
    updatePriority(issuedRequests[i]);
  }
  requestHeap.resort();
  const openSlots = Math.max(
    RequestScheduler.maximumRequests - activeRequests.length,
    0
  );
  let filledSlots = 0;
  while (filledSlots < openSlots && requestHeap.length > 0) {
    request = requestHeap.pop();
    if (request.cancelled) {
      cancelRequest(request);
      continue;
    }
    if (request.throttleByServer && !RequestScheduler.serverHasOpenSlots(request.serverKey)) {
      cancelRequest(request);
      continue;
    }
    startRequest(request);
    ++filledSlots;
  }
  updateStatistics();
};
RequestScheduler.getServerKey = function(url2) {
  Check_default.typeOf.string("url", url2);
  let uri = new import_urijs4.default(url2);
  if (uri.scheme() === "") {
    uri = new import_urijs4.default(url2).absoluteTo(pageUri);
    uri.normalize();
  }
  let serverKey = uri.authority();
  if (!/:/.test(serverKey)) {
    serverKey = `${serverKey}:${uri.scheme() === "https" ? "443" : "80"}`;
  }
  const length3 = numberOfActiveRequestsByServer[serverKey];
  if (!defined_default(length3)) {
    numberOfActiveRequestsByServer[serverKey] = 0;
  }
  return serverKey;
};
RequestScheduler.request = function(request) {
  Check_default.typeOf.object("request", request);
  Check_default.typeOf.string("request.url", request.url);
  Check_default.typeOf.func("request.requestFunction", request.requestFunction);
  if (isDataUri_default(request.url) || isBlobUri_default(request.url)) {
    requestCompletedEvent.raiseEvent();
    request.state = RequestState_default.RECEIVED;
    return request.requestFunction();
  }
  ++statistics.numberOfAttemptedRequests;
  if (!defined_default(request.serverKey)) {
    request.serverKey = RequestScheduler.getServerKey(request.url);
  }
  if (RequestScheduler.throttleRequests && request.throttleByServer && !RequestScheduler.serverHasOpenSlots(request.serverKey)) {
    return void 0;
  }
  if (!RequestScheduler.throttleRequests || !request.throttle) {
    return startRequest(request);
  }
  if (activeRequests.length >= RequestScheduler.maximumRequests) {
    return void 0;
  }
  updatePriority(request);
  const removedRequest = requestHeap.insert(request);
  if (defined_default(removedRequest)) {
    if (removedRequest === request) {
      return void 0;
    }
    cancelRequest(removedRequest);
  }
  return issueRequest(request);
};
function updateStatistics() {
  if (!RequestScheduler.debugShowStatistics) {
    return;
  }
  if (statistics.numberOfActiveRequests === 0 && statistics.lastNumberOfActiveRequests > 0) {
    if (statistics.numberOfAttemptedRequests > 0) {
      console.log(
        `Number of attempted requests: ${statistics.numberOfAttemptedRequests}`
      );
      statistics.numberOfAttemptedRequests = 0;
    }
    if (statistics.numberOfCancelledRequests > 0) {
      console.log(
        `Number of cancelled requests: ${statistics.numberOfCancelledRequests}`
      );
      statistics.numberOfCancelledRequests = 0;
    }
    if (statistics.numberOfCancelledActiveRequests > 0) {
      console.log(
        `Number of cancelled active requests: ${statistics.numberOfCancelledActiveRequests}`
      );
      statistics.numberOfCancelledActiveRequests = 0;
    }
    if (statistics.numberOfFailedRequests > 0) {
      console.log(
        `Number of failed requests: ${statistics.numberOfFailedRequests}`
      );
      statistics.numberOfFailedRequests = 0;
    }
  }
  statistics.lastNumberOfActiveRequests = statistics.numberOfActiveRequests;
}
RequestScheduler.clearForSpecs = function() {
  while (requestHeap.length > 0) {
    const request = requestHeap.pop();
    cancelRequest(request);
  }
  const length3 = activeRequests.length;
  for (let i = 0; i < length3; ++i) {
    cancelRequest(activeRequests[i]);
  }
  activeRequests.length = 0;
  numberOfActiveRequestsByServer = {};
  statistics.numberOfAttemptedRequests = 0;
  statistics.numberOfActiveRequests = 0;
  statistics.numberOfCancelledRequests = 0;
  statistics.numberOfCancelledActiveRequests = 0;
  statistics.numberOfFailedRequests = 0;
  statistics.numberOfActiveRequestsEver = 0;
  statistics.lastNumberOfActiveRequests = 0;
};
RequestScheduler.numberOfActiveRequestsByServer = function(serverKey) {
  return numberOfActiveRequestsByServer[serverKey];
};
RequestScheduler.requestHeap = requestHeap;
var RequestScheduler_default = RequestScheduler;

// Source/Core/TrustedServers.js
var import_urijs5 = __toESM(require_URI(), 1);
var TrustedServers = {};
var _servers = {};
TrustedServers.add = function(host, port) {
  if (!defined_default(host)) {
    throw new DeveloperError_default("host is required.");
  }
  if (!defined_default(port) || port <= 0) {
    throw new DeveloperError_default("port is required to be greater than 0.");
  }
  const authority = `${host.toLowerCase()}:${port}`;
  if (!defined_default(_servers[authority])) {
    _servers[authority] = true;
  }
};
TrustedServers.remove = function(host, port) {
  if (!defined_default(host)) {
    throw new DeveloperError_default("host is required.");
  }
  if (!defined_default(port) || port <= 0) {
    throw new DeveloperError_default("port is required to be greater than 0.");
  }
  const authority = `${host.toLowerCase()}:${port}`;
  if (defined_default(_servers[authority])) {
    delete _servers[authority];
  }
};
function getAuthority(url2) {
  const uri = new import_urijs5.default(url2);
  uri.normalize();
  let authority = uri.authority();
  if (authority.length === 0) {
    return void 0;
  }
  uri.authority(authority);
  if (authority.indexOf("@") !== -1) {
    const parts = authority.split("@");
    authority = parts[1];
  }
  if (authority.indexOf(":") === -1) {
    let scheme = uri.scheme();
    if (scheme.length === 0) {
      scheme = window.location.protocol;
      scheme = scheme.substring(0, scheme.length - 1);
    }
    if (scheme === "http") {
      authority += ":80";
    } else if (scheme === "https") {
      authority += ":443";
    } else {
      return void 0;
    }
  }
  return authority;
}
TrustedServers.contains = function(url2) {
  if (!defined_default(url2)) {
    throw new DeveloperError_default("url is required.");
  }
  const authority = getAuthority(url2);
  if (defined_default(authority) && defined_default(_servers[authority])) {
    return true;
  }
  return false;
};
TrustedServers.clear = function() {
  _servers = {};
};
var TrustedServers_default = TrustedServers;

// Source/Core/Resource.js
var xhrBlobSupported = function() {
  try {
    const xhr = new XMLHttpRequest();
    xhr.open("GET", "#", true);
    xhr.responseType = "blob";
    return xhr.responseType === "blob";
  } catch (e) {
    return false;
  }
}();
function parseQuery(uri, resource, merge2, preserveQueryParameters) {
  const queryString = uri.query();
  if (queryString.length === 0) {
    return {};
  }
  let query;
  if (queryString.indexOf("=") === -1) {
    const result = {};
    result[queryString] = void 0;
    query = result;
  } else {
    query = queryToObject_default(queryString);
  }
  if (merge2) {
    resource._queryParameters = combineQueryParameters(
      query,
      resource._queryParameters,
      preserveQueryParameters
    );
  } else {
    resource._queryParameters = query;
  }
  uri.search("");
}
function stringifyQuery(uri, resource) {
  const queryObject = resource._queryParameters;
  const keys = Object.keys(queryObject);
  if (keys.length === 1 && !defined_default(queryObject[keys[0]])) {
    uri.search(keys[0]);
  } else {
    uri.search(objectToQuery_default(queryObject));
  }
}
function defaultClone(val, defaultVal) {
  if (!defined_default(val)) {
    return defaultVal;
  }
  return defined_default(val.clone) ? val.clone() : clone_default(val);
}
function checkAndResetRequest(request) {
  if (request.state === RequestState_default.ISSUED || request.state === RequestState_default.ACTIVE) {
    throw new RuntimeError_default("The Resource is already being fetched.");
  }
  request.state = RequestState_default.UNISSUED;
  request.deferred = void 0;
}
function combineQueryParameters(q12, q22, preserveQueryParameters) {
  if (!preserveQueryParameters) {
    return combine_default(q12, q22);
  }
  const result = clone_default(q12, true);
  for (const param in q22) {
    if (q22.hasOwnProperty(param)) {
      let value = result[param];
      const q2Value = q22[param];
      if (defined_default(value)) {
        if (!Array.isArray(value)) {
          value = result[param] = [value];
        }
        result[param] = value.concat(q2Value);
      } else {
        result[param] = Array.isArray(q2Value) ? q2Value.slice() : q2Value;
      }
    }
  }
  return result;
}
function Resource(options) {
  options = defaultValue_default(options, defaultValue_default.EMPTY_OBJECT);
  if (typeof options === "string") {
    options = {
      url: options
    };
  }
  Check_default.typeOf.string("options.url", options.url);
  this._url = void 0;
  this._templateValues = defaultClone(options.templateValues, {});
  this._queryParameters = defaultClone(options.queryParameters, {});
  this.headers = defaultClone(options.headers, {});
  this.request = defaultValue_default(options.request, new Request_default());
  this.proxy = options.proxy;
  this.retryCallback = options.retryCallback;
  this.retryAttempts = defaultValue_default(options.retryAttempts, 0);
  this._retryCount = 0;
  const uri = new import_urijs6.default(options.url);
  parseQuery(uri, this, true, true);
  uri.fragment("");
  this._url = uri.toString();
}
Resource.createIfNeeded = function(resource) {
  if (resource instanceof Resource) {
    return resource.getDerivedResource({
      request: resource.request
    });
  }
  if (typeof resource !== "string") {
    return resource;
  }
  return new Resource({
    url: resource
  });
};
var supportsImageBitmapOptionsPromise;
Resource.supportsImageBitmapOptions = function() {
  if (defined_default(supportsImageBitmapOptionsPromise)) {
    return supportsImageBitmapOptionsPromise;
  }
  if (typeof createImageBitmap !== "function") {
    supportsImageBitmapOptionsPromise = Promise.resolve(false);
    return supportsImageBitmapOptionsPromise;
  }
  const imageDataUri = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAIAAACQd1PeAAAABGdBTUEAAE4g3rEiDgAAACBjSFJNAAB6JgAAgIQAAPoAAACA6AAAdTAAAOpgAAA6mAAAF3CculE8AAAADElEQVQI12Ng6GAAAAEUAIngE3ZiAAAAAElFTkSuQmCC";
  supportsImageBitmapOptionsPromise = Resource.fetchBlob({
    url: imageDataUri
  }).then(function(blob) {
    const imageBitmapOptions = {
      imageOrientation: "flipY",
      premultiplyAlpha: "none",
      colorSpaceConversion: "none"
    };
    return Promise.all([
      createImageBitmap(blob, imageBitmapOptions),
      createImageBitmap(blob)
    ]);
  }).then(function(imageBitmaps) {
    const colorWithOptions = getImagePixels_default(imageBitmaps[0]);
    const colorWithDefaults = getImagePixels_default(imageBitmaps[1]);
    return colorWithOptions[1] !== colorWithDefaults[1];
  }).catch(function() {
    return false;
  });
  return supportsImageBitmapOptionsPromise;
};
Object.defineProperties(Resource, {
  isBlobSupported: {
    get: function() {
      return xhrBlobSupported;
    }
  }
});
Object.defineProperties(Resource.prototype, {
  queryParameters: {
    get: function() {
      return this._queryParameters;
    }
  },
  templateValues: {
    get: function() {
      return this._templateValues;
    }
  },
  url: {
    get: function() {
      return this.getUrlComponent(true, true);
    },
    set: function(value) {
      const uri = new import_urijs6.default(value);
      parseQuery(uri, this, false);
      uri.fragment("");
      this._url = uri.toString();
    }
  },
  extension: {
    get: function() {
      return getExtensionFromUri_default(this._url);
    }
  },
  isDataUri: {
    get: function() {
      return isDataUri_default(this._url);
    }
  },
  isBlobUri: {
    get: function() {
      return isBlobUri_default(this._url);
    }
  },
  isCrossOriginUrl: {
    get: function() {
      return isCrossOriginUrl_default(this._url);
    }
  },
  hasHeaders: {
    get: function() {
      return Object.keys(this.headers).length > 0;
    }
  }
});
Resource.prototype.toString = function() {
  return this.getUrlComponent(true, true);
};
Resource.prototype.getUrlComponent = function(query, proxy) {
  if (this.isDataUri) {
    return this._url;
  }
  const uri = new import_urijs6.default(this._url);
  if (query) {
    stringifyQuery(uri, this);
  }
  let url2 = uri.toString().replace(/%7B/g, "{").replace(/%7D/g, "}");
  const templateValues = this._templateValues;
  url2 = url2.replace(/{(.*?)}/g, function(match, key) {
    const replacement = templateValues[key];
    if (defined_default(replacement)) {
      return encodeURIComponent(replacement);
    }
    return match;
  });
  if (proxy && defined_default(this.proxy)) {
    url2 = this.proxy.getURL(url2);
  }
  return url2;
};
Resource.prototype.setQueryParameters = function(params, useAsDefault) {
  if (useAsDefault) {
    this._queryParameters = combineQueryParameters(
      this._queryParameters,
      params,
      false
    );
  } else {
    this._queryParameters = combineQueryParameters(
      params,
      this._queryParameters,
      false
    );
  }
};
Resource.prototype.appendQueryParameters = function(params) {
  this._queryParameters = combineQueryParameters(
    params,
    this._queryParameters,
    true
  );
};
Resource.prototype.setTemplateValues = function(template, useAsDefault) {
  if (useAsDefault) {
    this._templateValues = combine_default(this._templateValues, template);
  } else {
    this._templateValues = combine_default(template, this._templateValues);
  }
};
Resource.prototype.getDerivedResource = function(options) {
  const resource = this.clone();
  resource._retryCount = 0;
  if (defined_default(options.url)) {
    const uri = new import_urijs6.default(options.url);
    const preserveQueryParameters = defaultValue_default(
      options.preserveQueryParameters,
      false
    );
    parseQuery(uri, resource, true, preserveQueryParameters);
    uri.fragment("");
    if (uri.scheme() !== "") {
      resource._url = uri.toString();
    } else {
      resource._url = uri.absoluteTo(new import_urijs6.default(getAbsoluteUri_default(this._url))).toString();
    }
  }
  if (defined_default(options.queryParameters)) {
    resource._queryParameters = combine_default(
      options.queryParameters,
      resource._queryParameters
    );
  }
  if (defined_default(options.templateValues)) {
    resource._templateValues = combine_default(
      options.templateValues,
      resource.templateValues
    );
  }
  if (defined_default(options.headers)) {
    resource.headers = combine_default(options.headers, resource.headers);
  }
  if (defined_default(options.proxy)) {
    resource.proxy = options.proxy;
  }
  if (defined_default(options.request)) {
    resource.request = options.request;
  }
  if (defined_default(options.retryCallback)) {
    resource.retryCallback = options.retryCallback;
  }
  if (defined_default(options.retryAttempts)) {
    resource.retryAttempts = options.retryAttempts;
  }
  return resource;
};
Resource.prototype.retryOnError = function(error) {
  const retryCallback2 = this.retryCallback;
  if (typeof retryCallback2 !== "function" || this._retryCount >= this.retryAttempts) {
    return Promise.resolve(false);
  }
  const that = this;
  return Promise.resolve(retryCallback2(this, error)).then(function(result) {
    ++that._retryCount;
    return result;
  });
};
Resource.prototype.clone = function(result) {
  if (!defined_default(result)) {
    result = new Resource({
      url: this._url
    });
  }
  result._url = this._url;
  result._queryParameters = clone_default(this._queryParameters);
  result._templateValues = clone_default(this._templateValues);
  result.headers = clone_default(this.headers);
  result.proxy = this.proxy;
  result.retryCallback = this.retryCallback;
  result.retryAttempts = this.retryAttempts;
  result._retryCount = 0;
  result.request = this.request.clone();
  return result;
};
Resource.prototype.getBaseUri = function(includeQuery) {
  return getBaseUri_default(this.getUrlComponent(includeQuery), includeQuery);
};
Resource.prototype.appendForwardSlash = function() {
  this._url = appendForwardSlash_default(this._url);
};
Resource.prototype.fetchArrayBuffer = function() {
  return this.fetch({
    responseType: "arraybuffer"
  });
};
Resource.fetchArrayBuffer = function(options) {
  const resource = new Resource(options);
  return resource.fetchArrayBuffer();
};
Resource.prototype.fetchBlob = function() {
  return this.fetch({
    responseType: "blob"
  });
};
Resource.fetchBlob = function(options) {
  const resource = new Resource(options);
  return resource.fetchBlob();
};
Resource.prototype.fetchImage = function(options) {
  options = defaultValue_default(options, defaultValue_default.EMPTY_OBJECT);
  const preferImageBitmap = defaultValue_default(options.preferImageBitmap, false);
  const preferBlob = defaultValue_default(options.preferBlob, false);
  const flipY = defaultValue_default(options.flipY, false);
  const skipColorSpaceConversion = defaultValue_default(
    options.skipColorSpaceConversion,
    false
  );
  checkAndResetRequest(this.request);
  if (!xhrBlobSupported || this.isDataUri || this.isBlobUri || !this.hasHeaders && !preferBlob) {
    return fetchImage({
      resource: this,
      flipY,
      skipColorSpaceConversion,
      preferImageBitmap
    });
  }
  const blobPromise = this.fetchBlob();
  if (!defined_default(blobPromise)) {
    return;
  }
  let supportsImageBitmap;
  let useImageBitmap;
  let generatedBlobResource;
  let generatedBlob;
  return Resource.supportsImageBitmapOptions().then(function(result) {
    supportsImageBitmap = result;
    useImageBitmap = supportsImageBitmap && preferImageBitmap;
    return blobPromise;
  }).then(function(blob) {
    if (!defined_default(blob)) {
      return;
    }
    generatedBlob = blob;
    if (useImageBitmap) {
      return Resource.createImageBitmapFromBlob(blob, {
        flipY,
        premultiplyAlpha: false,
        skipColorSpaceConversion
      });
    }
    const blobUrl = window.URL.createObjectURL(blob);
    generatedBlobResource = new Resource({
      url: blobUrl
    });
    return fetchImage({
      resource: generatedBlobResource,
      flipY,
      skipColorSpaceConversion,
      preferImageBitmap: false
    });
  }).then(function(image) {
    if (!defined_default(image)) {
      return;
    }
    image.blob = generatedBlob;
    if (useImageBitmap) {
      return image;
    }
    window.URL.revokeObjectURL(generatedBlobResource.url);
    return image;
  }).catch(function(error) {
    if (defined_default(generatedBlobResource)) {
      window.URL.revokeObjectURL(generatedBlobResource.url);
    }
    error.blob = generatedBlob;
    return Promise.reject(error);
  });
};
function fetchImage(options) {
  const resource = options.resource;
  const flipY = options.flipY;
  const skipColorSpaceConversion = options.skipColorSpaceConversion;
  const preferImageBitmap = options.preferImageBitmap;
  const request = resource.request;
  request.url = resource.url;
  request.requestFunction = function() {
    let crossOrigin = false;
    if (!resource.isDataUri && !resource.isBlobUri) {
      crossOrigin = resource.isCrossOriginUrl;
    }
    const deferred = defer_default();
    Resource._Implementations.createImage(
      request,
      crossOrigin,
      deferred,
      flipY,
      skipColorSpaceConversion,
      preferImageBitmap
    );
    return deferred.promise;
  };
  const promise = RequestScheduler_default.request(request);
  if (!defined_default(promise)) {
    return;
  }
  return promise.catch(function(e) {
    if (request.state !== RequestState_default.FAILED) {
      return Promise.reject(e);
    }
    return resource.retryOnError(e).then(function(retry) {
      if (retry) {
        request.state = RequestState_default.UNISSUED;
        request.deferred = void 0;
        return fetchImage({
          resource,
          flipY,
          skipColorSpaceConversion,
          preferImageBitmap
        });
      }
      return Promise.reject(e);
    });
  });
}
Resource.fetchImage = function(options) {
  const resource = new Resource(options);
  return resource.fetchImage({
    flipY: options.flipY,
    skipColorSpaceConversion: options.skipColorSpaceConversion,
    preferBlob: options.preferBlob,
    preferImageBitmap: options.preferImageBitmap
  });
};
Resource.prototype.fetchText = function() {
  return this.fetch({
    responseType: "text"
  });
};
Resource.fetchText = function(options) {
  const resource = new Resource(options);
  return resource.fetchText();
};
Resource.prototype.fetchJson = function() {
  const promise = this.fetch({
    responseType: "text",
    headers: {
      Accept: "application/json,*/*;q=0.01"
    }
  });
  if (!defined_default(promise)) {
    return void 0;
  }
  return promise.then(function(value) {
    if (!defined_default(value)) {
      return;
    }
    return JSON.parse(value);
  });
};
Resource.fetchJson = function(options) {
  const resource = new Resource(options);
  return resource.fetchJson();
};
Resource.prototype.fetchXML = function() {
  return this.fetch({
    responseType: "document",
    overrideMimeType: "text/xml"
  });
};
Resource.fetchXML = function(options) {
  const resource = new Resource(options);
  return resource.fetchXML();
};
Resource.prototype.fetchJsonp = function(callbackParameterName) {
  callbackParameterName = defaultValue_default(callbackParameterName, "callback");
  checkAndResetRequest(this.request);
  let functionName;
  do {
    functionName = `loadJsonp${Math_default.nextRandomNumber().toString().substring(2, 8)}`;
  } while (defined_default(window[functionName]));
  return fetchJsonp(this, callbackParameterName, functionName);
};
function fetchJsonp(resource, callbackParameterName, functionName) {
  const callbackQuery = {};
  callbackQuery[callbackParameterName] = functionName;
  resource.setQueryParameters(callbackQuery);
  const request = resource.request;
  request.url = resource.url;
  request.requestFunction = function() {
    const deferred = defer_default();
    window[functionName] = function(data) {
      deferred.resolve(data);
      try {
        delete window[functionName];
      } catch (e) {
        window[functionName] = void 0;
      }
    };
    Resource._Implementations.loadAndExecuteScript(
      resource.url,
      functionName,
      deferred
    );
    return deferred.promise;
  };
  const promise = RequestScheduler_default.request(request);
  if (!defined_default(promise)) {
    return;
  }
  return promise.catch(function(e) {
    if (request.state !== RequestState_default.FAILED) {
      return Promise.reject(e);
    }
    return resource.retryOnError(e).then(function(retry) {
      if (retry) {
        request.state = RequestState_default.UNISSUED;
        request.deferred = void 0;
        return fetchJsonp(resource, callbackParameterName, functionName);
      }
      return Promise.reject(e);
    });
  });
}
Resource.fetchJsonp = function(options) {
  const resource = new Resource(options);
  return resource.fetchJsonp(options.callbackParameterName);
};
Resource.prototype._makeRequest = function(options) {
  const resource = this;
  checkAndResetRequest(resource.request);
  const request = resource.request;
  request.url = resource.url;
  request.requestFunction = function() {
    const responseType = options.responseType;
    const headers = combine_default(options.headers, resource.headers);
    const overrideMimeType = options.overrideMimeType;
    const method = options.method;
    const data = options.data;
    const deferred = defer_default();
    const xhr = Resource._Implementations.loadWithXhr(
      resource.url,
      responseType,
      method,
      data,
      headers,
      deferred,
      overrideMimeType
    );
    if (defined_default(xhr) && defined_default(xhr.abort)) {
      request.cancelFunction = function() {
        xhr.abort();
      };
    }
    return deferred.promise;
  };
  const promise = RequestScheduler_default.request(request);
  if (!defined_default(promise)) {
    return;
  }
  return promise.then(function(data) {
    request.cancelFunction = void 0;
    return data;
  }).catch(function(e) {
    request.cancelFunction = void 0;
    if (request.state !== RequestState_default.FAILED) {
      return Promise.reject(e);
    }
    return resource.retryOnError(e).then(function(retry) {
      if (retry) {
        request.state = RequestState_default.UNISSUED;
        request.deferred = void 0;
        return resource.fetch(options);
      }
      return Promise.reject(e);
    });
  });
};
var dataUriRegex2 = /^data:(.*?)(;base64)?,(.*)$/;
function decodeDataUriText(isBase64, data) {
  const result = decodeURIComponent(data);
  if (isBase64) {
    return atob(result);
  }
  return result;
}
function decodeDataUriArrayBuffer(isBase64, data) {
  const byteString = decodeDataUriText(isBase64, data);
  const buffer = new ArrayBuffer(byteString.length);
  const view = new Uint8Array(buffer);
  for (let i = 0; i < byteString.length; i++) {
    view[i] = byteString.charCodeAt(i);
  }
  return buffer;
}
function decodeDataUri(dataUriRegexResult, responseType) {
  responseType = defaultValue_default(responseType, "");
  const mimeType = dataUriRegexResult[1];
  const isBase64 = !!dataUriRegexResult[2];
  const data = dataUriRegexResult[3];
  let buffer;
  let parser3;
  switch (responseType) {
    case "":
    case "text":
      return decodeDataUriText(isBase64, data);
    case "arraybuffer":
      return decodeDataUriArrayBuffer(isBase64, data);
    case "blob":
      buffer = decodeDataUriArrayBuffer(isBase64, data);
      return new Blob([buffer], {
        type: mimeType
      });
    case "document":
      parser3 = new DOMParser();
      return parser3.parseFromString(
        decodeDataUriText(isBase64, data),
        mimeType
      );
    case "json":
      return JSON.parse(decodeDataUriText(isBase64, data));
    default:
      throw new DeveloperError_default(`Unhandled responseType: ${responseType}`);
  }
}
Resource.prototype.fetch = function(options) {
  options = defaultClone(options, {});
  options.method = "GET";
  return this._makeRequest(options);
};
Resource.fetch = function(options) {
  const resource = new Resource(options);
  return resource.fetch({
    responseType: options.responseType,
    overrideMimeType: options.overrideMimeType
  });
};
Resource.prototype.delete = function(options) {
  options = defaultClone(options, {});
  options.method = "DELETE";
  return this._makeRequest(options);
};
Resource.delete = function(options) {
  const resource = new Resource(options);
  return resource.delete({
    responseType: options.responseType,
    overrideMimeType: options.overrideMimeType,
    data: options.data
  });
};
Resource.prototype.head = function(options) {
  options = defaultClone(options, {});
  options.method = "HEAD";
  return this._makeRequest(options);
};
Resource.head = function(options) {
  const resource = new Resource(options);
  return resource.head({
    responseType: options.responseType,
    overrideMimeType: options.overrideMimeType
  });
};
Resource.prototype.options = function(options) {
  options = defaultClone(options, {});
  options.method = "OPTIONS";
  return this._makeRequest(options);
};
Resource.options = function(options) {
  const resource = new Resource(options);
  return resource.options({
    responseType: options.responseType,
    overrideMimeType: options.overrideMimeType
  });
};
Resource.prototype.post = function(data, options) {
  Check_default.defined("data", data);
  options = defaultClone(options, {});
  options.method = "POST";
  options.data = data;
  return this._makeRequest(options);
};
Resource.post = function(options) {
  const resource = new Resource(options);
  return resource.post(options.data, {
    responseType: options.responseType,
    overrideMimeType: options.overrideMimeType
  });
};
Resource.prototype.put = function(data, options) {
  Check_default.defined("data", data);
  options = defaultClone(options, {});
  options.method = "PUT";
  options.data = data;
  return this._makeRequest(options);
};
Resource.put = function(options) {
  const resource = new Resource(options);
  return resource.put(options.data, {
    responseType: options.responseType,
    overrideMimeType: options.overrideMimeType
  });
};
Resource.prototype.patch = function(data, options) {
  Check_default.defined("data", data);
  options = defaultClone(options, {});
  options.method = "PATCH";
  options.data = data;
  return this._makeRequest(options);
};
Resource.patch = function(options) {
  const resource = new Resource(options);
  return resource.patch(options.data, {
    responseType: options.responseType,
    overrideMimeType: options.overrideMimeType
  });
};
Resource._Implementations = {};
Resource._Implementations.loadImageElement = function(url2, crossOrigin, deferred) {
  const image = new Image();
  image.onload = function() {
    if (image.naturalWidth === 0 && image.naturalHeight === 0 && image.width === 0 && image.height === 0) {
      image.width = 300;
      image.height = 150;
    }
    deferred.resolve(image);
  };
  image.onerror = function(e) {
    deferred.reject(e);
  };
  if (crossOrigin) {
    if (TrustedServers_default.contains(url2)) {
      image.crossOrigin = "use-credentials";
    } else {
      image.crossOrigin = "";
    }
  }
  image.src = url2;
};
Resource._Implementations.createImage = function(request, crossOrigin, deferred, flipY, skipColorSpaceConversion, preferImageBitmap) {
  const url2 = request.url;
  Resource.supportsImageBitmapOptions().then(function(supportsImageBitmap) {
    if (!(supportsImageBitmap && preferImageBitmap)) {
      Resource._Implementations.loadImageElement(url2, crossOrigin, deferred);
      return;
    }
    const responseType = "blob";
    const method = "GET";
    const xhrDeferred = defer_default();
    const xhr = Resource._Implementations.loadWithXhr(
      url2,
      responseType,
      method,
      void 0,
      void 0,
      xhrDeferred,
      void 0,
      void 0,
      void 0
    );
    if (defined_default(xhr) && defined_default(xhr.abort)) {
      request.cancelFunction = function() {
        xhr.abort();
      };
    }
    return xhrDeferred.promise.then(function(blob) {
      if (!defined_default(blob)) {
        deferred.reject(
          new RuntimeError_default(
            `Successfully retrieved ${url2} but it contained no content.`
          )
        );
        return;
      }
      return Resource.createImageBitmapFromBlob(blob, {
        flipY,
        premultiplyAlpha: false,
        skipColorSpaceConversion
      });
    }).then(function(image) {
      deferred.resolve(image);
    });
  }).catch(function(e) {
    deferred.reject(e);
  });
};
Resource.createImageBitmapFromBlob = function(blob, options) {
  Check_default.defined("options", options);
  Check_default.typeOf.bool("options.flipY", options.flipY);
  Check_default.typeOf.bool("options.premultiplyAlpha", options.premultiplyAlpha);
  Check_default.typeOf.bool(
    "options.skipColorSpaceConversion",
    options.skipColorSpaceConversion
  );
  return createImageBitmap(blob, {
    imageOrientation: options.flipY ? "flipY" : "none",
    premultiplyAlpha: options.premultiplyAlpha ? "premultiply" : "none",
    colorSpaceConversion: options.skipColorSpaceConversion ? "none" : "default"
  });
};
function decodeResponse(loadWithHttpResponse, responseType) {
  switch (responseType) {
    case "text":
      return loadWithHttpResponse.toString("utf8");
    case "json":
      return JSON.parse(loadWithHttpResponse.toString("utf8"));
    default:
      return new Uint8Array(loadWithHttpResponse).buffer;
  }
}
function loadWithHttpRequest(url2, responseType, method, data, headers, deferred, overrideMimeType) {
  let URL2;
  let zlib;
  Promise.all([import("url"), import("zlib")]).then(([urlImport, zlibImport]) => {
    URL2 = urlImport.parse(url2);
    zlib = zlibImport;
    return URL2.protocol === "https:" ? import("https") : import("http");
  }).then((http) => {
    const options = {
      protocol: URL2.protocol,
      hostname: URL2.hostname,
      port: URL2.port,
      path: URL2.path,
      query: URL2.query,
      method,
      headers
    };
    http.request(options).on("response", function(res) {
      if (res.statusCode < 200 || res.statusCode >= 300) {
        deferred.reject(
          new RequestErrorEvent_default(res.statusCode, res, res.headers)
        );
        return;
      }
      const chunkArray = [];
      res.on("data", function(chunk) {
        chunkArray.push(chunk);
      });
      res.on("end", function() {
        const result = Buffer.concat(chunkArray);
        if (res.headers["content-encoding"] === "gzip") {
          zlib.gunzip(result, function(error, resultUnzipped) {
            if (error) {
              deferred.reject(
                new RuntimeError_default("Error decompressing response.")
              );
            } else {
              deferred.resolve(
                decodeResponse(resultUnzipped, responseType)
              );
            }
          });
        } else {
          deferred.resolve(decodeResponse(result, responseType));
        }
      });
    }).on("error", function(e) {
      deferred.reject(new RequestErrorEvent_default());
    }).end();
  });
}
var noXMLHttpRequest = typeof XMLHttpRequest === "undefined";
Resource._Implementations.loadWithXhr = function(url2, responseType, method, data, headers, deferred, overrideMimeType) {
  const dataUriRegexResult = dataUriRegex2.exec(url2);
  if (dataUriRegexResult !== null) {
    deferred.resolve(decodeDataUri(dataUriRegexResult, responseType));
    return;
  }
  if (noXMLHttpRequest) {
    loadWithHttpRequest(
      url2,
      responseType,
      method,
      data,
      headers,
      deferred,
      overrideMimeType
    );
    return;
  }
  const xhr = new XMLHttpRequest();
  if (TrustedServers_default.contains(url2)) {
    xhr.withCredentials = true;
  }
  xhr.open(method, url2, true);
  if (defined_default(overrideMimeType) && defined_default(xhr.overrideMimeType)) {
    xhr.overrideMimeType(overrideMimeType);
  }
  if (defined_default(headers)) {
    for (const key in headers) {
      if (headers.hasOwnProperty(key)) {
        xhr.setRequestHeader(key, headers[key]);
      }
    }
  }
  if (defined_default(responseType)) {
    xhr.responseType = responseType;
  }
  let localFile = false;
  if (typeof url2 === "string") {
    localFile = url2.indexOf("file://") === 0 || typeof window !== "undefined" && window.location.origin === "file://";
  }
  xhr.onload = function() {
    if ((xhr.status < 200 || xhr.status >= 300) && !(localFile && xhr.status === 0)) {
      deferred.reject(
        new RequestErrorEvent_default(
          xhr.status,
          xhr.response,
          xhr.getAllResponseHeaders()
        )
      );
      return;
    }
    const response = xhr.response;
    const browserResponseType = xhr.responseType;
    if (method === "HEAD" || method === "OPTIONS") {
      const responseHeaderString = xhr.getAllResponseHeaders();
      const splitHeaders = responseHeaderString.trim().split(/[\r\n]+/);
      const responseHeaders = {};
      splitHeaders.forEach(function(line) {
        const parts = line.split(": ");
        const header = parts.shift();
        responseHeaders[header] = parts.join(": ");
      });
      deferred.resolve(responseHeaders);
      return;
    }
    if (xhr.status === 204) {
      deferred.resolve();
    } else if (defined_default(response) && (!defined_default(responseType) || browserResponseType === responseType)) {
      deferred.resolve(response);
    } else if (responseType === "json" && typeof response === "string") {
      try {
        deferred.resolve(JSON.parse(response));
      } catch (e) {
        deferred.reject(e);
      }
    } else if ((browserResponseType === "" || browserResponseType === "document") && defined_default(xhr.responseXML) && xhr.responseXML.hasChildNodes()) {
      deferred.resolve(xhr.responseXML);
    } else if ((browserResponseType === "" || browserResponseType === "text") && defined_default(xhr.responseText)) {
      deferred.resolve(xhr.responseText);
    } else {
      deferred.reject(
        new RuntimeError_default("Invalid XMLHttpRequest response type.")
      );
    }
  };
  xhr.onerror = function(e) {
    deferred.reject(new RequestErrorEvent_default());
  };
  xhr.send(data);
  return xhr;
};
Resource._Implementations.loadAndExecuteScript = function(url2, functionName, deferred) {
  return loadAndExecuteScript_default(url2, functionName).catch(function(e) {
    deferred.reject(e);
  });
};
Resource._DefaultImplementations = {};
Resource._DefaultImplementations.createImage = Resource._Implementations.createImage;
Resource._DefaultImplementations.loadWithXhr = Resource._Implementations.loadWithXhr;
Resource._DefaultImplementations.loadAndExecuteScript = Resource._Implementations.loadAndExecuteScript;
Resource.DEFAULT = Object.freeze(
  new Resource({
    url: typeof document === "undefined" ? "" : document.location.href.split("?")[0]
  })
);
var Resource_default = Resource;

// Source/Core/buildModuleUrl.js
var cesiumScriptRegex = /((?:.*\/)|^)Cesium\.js(?:\?|\#|$)/;
function getBaseUrlFromCesiumScript() {
  const scripts = document.getElementsByTagName("script");
  for (let i = 0, len = scripts.length; i < len; ++i) {
    const src = scripts[i].getAttribute("src");
    const result = cesiumScriptRegex.exec(src);
    if (result !== null) {
      return result[1];
    }
  }
  return void 0;
}
var a2;
function tryMakeAbsolute(url2) {
  if (typeof document === "undefined") {
    return url2;
  }
  if (!defined_default(a2)) {
    a2 = document.createElement("a");
  }
  a2.href = url2;
  a2.href = a2.href;
  return a2.href;
}
var baseResource;
function getCesiumBaseUrl() {
  if (defined_default(baseResource)) {
    return baseResource;
  }
  let baseUrlString;
  if (typeof CESIUM_BASE_URL !== "undefined") {
    baseUrlString = CESIUM_BASE_URL;
  } else if (typeof define === "object" && defined_default(define.amd) && !define.amd.toUrlUndefined && defined_default(require.toUrl)) {
    baseUrlString = getAbsoluteUri_default(
      "..",
      buildModuleUrl("Core/buildModuleUrl.js")
    );
  } else {
    baseUrlString = getBaseUrlFromCesiumScript();
  }
  if (!defined_default(baseUrlString)) {
    throw new DeveloperError_default(
      "Unable to determine Cesium base URL automatically, try defining a global variable called CESIUM_BASE_URL."
    );
  }
  baseResource = new Resource_default({
    url: tryMakeAbsolute(baseUrlString)
  });
  baseResource.appendForwardSlash();
  return baseResource;
}
function buildModuleUrlFromRequireToUrl(moduleID) {
  return tryMakeAbsolute(require.toUrl(`../${moduleID}`));
}
function buildModuleUrlFromBaseUrl(moduleID) {
  const resource = getCesiumBaseUrl().getDerivedResource({
    url: moduleID
  });
  return resource.url;
}
var implementation;
function buildModuleUrl(relativeUrl) {
  if (!defined_default(implementation)) {
    if (typeof define === "object" && defined_default(define.amd) && !define.amd.toUrlUndefined && defined_default(require.toUrl)) {
      implementation = buildModuleUrlFromRequireToUrl;
    } else {
      implementation = buildModuleUrlFromBaseUrl;
    }
  }
  const url2 = implementation(relativeUrl);
  return url2;
}
buildModuleUrl._cesiumScriptRegex = cesiumScriptRegex;
buildModuleUrl._buildModuleUrlFromBaseUrl = buildModuleUrlFromBaseUrl;
buildModuleUrl._clearBaseResource = function() {
  baseResource = void 0;
};
buildModuleUrl.setBaseUrl = function(value) {
  baseResource = Resource_default.DEFAULT.getDerivedResource({
    url: value
  });
};
buildModuleUrl.getCesiumBaseUrl = getCesiumBaseUrl;
var buildModuleUrl_default = buildModuleUrl;

// Source/Core/Cartesian2.js
function Cartesian2(x, y) {
  this.x = defaultValue_default(x, 0);
  this.y = defaultValue_default(y, 0);
}
Cartesian2.fromElements = function(x, y, result) {
  if (!defined_default(result)) {
    return new Cartesian2(x, y);
  }
  result.x = x;
  result.y = y;
  return result;
};
Cartesian2.clone = function(cartesian11, result) {
  if (!defined_default(cartesian11)) {
    return void 0;
  }
  if (!defined_default(result)) {
    return new Cartesian2(cartesian11.x, cartesian11.y);
  }
  result.x = cartesian11.x;
  result.y = cartesian11.y;
  return result;
};
Cartesian2.fromCartesian3 = Cartesian2.clone;
Cartesian2.fromCartesian4 = Cartesian2.clone;
Cartesian2.packedLength = 2;
Cartesian2.pack = function(value, array, startingIndex) {
  Check_default.typeOf.object("value", value);
  Check_default.defined("array", array);
  startingIndex = defaultValue_default(startingIndex, 0);
  array[startingIndex++] = value.x;
  array[startingIndex] = value.y;
  return array;
};
Cartesian2.unpack = function(array, startingIndex, result) {
  Check_default.defined("array", array);
  startingIndex = defaultValue_default(startingIndex, 0);
  if (!defined_default(result)) {
    result = new Cartesian2();
  }
  result.x = array[startingIndex++];
  result.y = array[startingIndex];
  return result;
};
Cartesian2.packArray = function(array, result) {
  Check_default.defined("array", array);
  const length3 = array.length;
  const resultLength = length3 * 2;
  if (!defined_default(result)) {
    result = new Array(resultLength);
  } else if (!Array.isArray(result) && result.length !== resultLength) {
    throw new DeveloperError_default(
      "If result is a typed array, it must have exactly array.length * 2 elements"
    );
  } else if (result.length !== resultLength) {
    result.length = resultLength;
  }
  for (let i = 0; i < length3; ++i) {
    Cartesian2.pack(array[i], result, i * 2);
  }
  return result;
};
Cartesian2.unpackArray = function(array, result) {
  Check_default.defined("array", array);
  Check_default.typeOf.number.greaterThanOrEquals("array.length", array.length, 2);
  if (array.length % 2 !== 0) {
    throw new DeveloperError_default("array length must be a multiple of 2.");
  }
  const length3 = array.length;
  if (!defined_default(result)) {
    result = new Array(length3 / 2);
  } else {
    result.length = length3 / 2;
  }
  for (let i = 0; i < length3; i += 2) {
    const index = i / 2;
    result[index] = Cartesian2.unpack(array, i, result[index]);
  }
  return result;
};
Cartesian2.fromArray = Cartesian2.unpack;
Cartesian2.maximumComponent = function(cartesian11) {
  Check_default.typeOf.object("cartesian", cartesian11);
  return Math.max(cartesian11.x, cartesian11.y);
};
Cartesian2.minimumComponent = function(cartesian11) {
  Check_default.typeOf.object("cartesian", cartesian11);
  return Math.min(cartesian11.x, cartesian11.y);
};
Cartesian2.minimumByComponent = function(first, second, result) {
  Check_default.typeOf.object("first", first);
  Check_default.typeOf.object("second", second);
  Check_default.typeOf.object("result", result);
  result.x = Math.min(first.x, second.x);
  result.y = Math.min(first.y, second.y);
  return result;
};
Cartesian2.maximumByComponent = function(first, second, result) {
  Check_default.typeOf.object("first", first);
  Check_default.typeOf.object("second", second);
  Check_default.typeOf.object("result", result);
  result.x = Math.max(first.x, second.x);
  result.y = Math.max(first.y, second.y);
  return result;
};
Cartesian2.clamp = function(value, min3, max3, result) {
  Check_default.typeOf.object("value", value);
  Check_default.typeOf.object("min", min3);
  Check_default.typeOf.object("max", max3);
  Check_default.typeOf.object("result", result);
  const x = Math_default.clamp(value.x, min3.x, max3.x);
  const y = Math_default.clamp(value.y, min3.y, max3.y);
  result.x = x;
  result.y = y;
  return result;
};
Cartesian2.magnitudeSquared = function(cartesian11) {
  Check_default.typeOf.object("cartesian", cartesian11);
  return cartesian11.x * cartesian11.x + cartesian11.y * cartesian11.y;
};
Cartesian2.magnitude = function(cartesian11) {
  return Math.sqrt(Cartesian2.magnitudeSquared(cartesian11));
};
var distanceScratch3 = new Cartesian2();
Cartesian2.distance = function(left, right) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Cartesian2.subtract(left, right, distanceScratch3);
  return Cartesian2.magnitude(distanceScratch3);
};
Cartesian2.distanceSquared = function(left, right) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Cartesian2.subtract(left, right, distanceScratch3);
  return Cartesian2.magnitudeSquared(distanceScratch3);
};
Cartesian2.normalize = function(cartesian11, result) {
  Check_default.typeOf.object("cartesian", cartesian11);
  Check_default.typeOf.object("result", result);
  const magnitude = Cartesian2.magnitude(cartesian11);
  result.x = cartesian11.x / magnitude;
  result.y = cartesian11.y / magnitude;
  if (isNaN(result.x) || isNaN(result.y)) {
    throw new DeveloperError_default("normalized result is not a number");
  }
  return result;
};
Cartesian2.dot = function(left, right) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  return left.x * right.x + left.y * right.y;
};
Cartesian2.cross = function(left, right) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  return left.x * right.y - left.y * right.x;
};
Cartesian2.multiplyComponents = function(left, right, result) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Check_default.typeOf.object("result", result);
  result.x = left.x * right.x;
  result.y = left.y * right.y;
  return result;
};
Cartesian2.divideComponents = function(left, right, result) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Check_default.typeOf.object("result", result);
  result.x = left.x / right.x;
  result.y = left.y / right.y;
  return result;
};
Cartesian2.add = function(left, right, result) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Check_default.typeOf.object("result", result);
  result.x = left.x + right.x;
  result.y = left.y + right.y;
  return result;
};
Cartesian2.subtract = function(left, right, result) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Check_default.typeOf.object("result", result);
  result.x = left.x - right.x;
  result.y = left.y - right.y;
  return result;
};
Cartesian2.multiplyByScalar = function(cartesian11, scalar, result) {
  Check_default.typeOf.object("cartesian", cartesian11);
  Check_default.typeOf.number("scalar", scalar);
  Check_default.typeOf.object("result", result);
  result.x = cartesian11.x * scalar;
  result.y = cartesian11.y * scalar;
  return result;
};
Cartesian2.divideByScalar = function(cartesian11, scalar, result) {
  Check_default.typeOf.object("cartesian", cartesian11);
  Check_default.typeOf.number("scalar", scalar);
  Check_default.typeOf.object("result", result);
  result.x = cartesian11.x / scalar;
  result.y = cartesian11.y / scalar;
  return result;
};
Cartesian2.negate = function(cartesian11, result) {
  Check_default.typeOf.object("cartesian", cartesian11);
  Check_default.typeOf.object("result", result);
  result.x = -cartesian11.x;
  result.y = -cartesian11.y;
  return result;
};
Cartesian2.abs = function(cartesian11, result) {
  Check_default.typeOf.object("cartesian", cartesian11);
  Check_default.typeOf.object("result", result);
  result.x = Math.abs(cartesian11.x);
  result.y = Math.abs(cartesian11.y);
  return result;
};
var lerpScratch3 = new Cartesian2();
Cartesian2.lerp = function(start, end, t, result) {
  Check_default.typeOf.object("start", start);
  Check_default.typeOf.object("end", end);
  Check_default.typeOf.number("t", t);
  Check_default.typeOf.object("result", result);
  Cartesian2.multiplyByScalar(end, t, lerpScratch3);
  result = Cartesian2.multiplyByScalar(start, 1 - t, result);
  return Cartesian2.add(lerpScratch3, result, result);
};
var angleBetweenScratch3 = new Cartesian2();
var angleBetweenScratch22 = new Cartesian2();
Cartesian2.angleBetween = function(left, right) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Cartesian2.normalize(left, angleBetweenScratch3);
  Cartesian2.normalize(right, angleBetweenScratch22);
  return Math_default.acosClamped(
    Cartesian2.dot(angleBetweenScratch3, angleBetweenScratch22)
  );
};
var mostOrthogonalAxisScratch3 = new Cartesian2();
Cartesian2.mostOrthogonalAxis = function(cartesian11, result) {
  Check_default.typeOf.object("cartesian", cartesian11);
  Check_default.typeOf.object("result", result);
  const f = Cartesian2.normalize(cartesian11, mostOrthogonalAxisScratch3);
  Cartesian2.abs(f, f);
  if (f.x <= f.y) {
    result = Cartesian2.clone(Cartesian2.UNIT_X, result);
  } else {
    result = Cartesian2.clone(Cartesian2.UNIT_Y, result);
  }
  return result;
};
Cartesian2.equals = function(left, right) {
  return left === right || defined_default(left) && defined_default(right) && left.x === right.x && left.y === right.y;
};
Cartesian2.equalsArray = function(cartesian11, array, offset2) {
  return cartesian11.x === array[offset2] && cartesian11.y === array[offset2 + 1];
};
Cartesian2.equalsEpsilon = function(left, right, relativeEpsilon, absoluteEpsilon) {
  return left === right || defined_default(left) && defined_default(right) && Math_default.equalsEpsilon(
    left.x,
    right.x,
    relativeEpsilon,
    absoluteEpsilon
  ) && Math_default.equalsEpsilon(
    left.y,
    right.y,
    relativeEpsilon,
    absoluteEpsilon
  );
};
Cartesian2.ZERO = Object.freeze(new Cartesian2(0, 0));
Cartesian2.ONE = Object.freeze(new Cartesian2(1, 1));
Cartesian2.UNIT_X = Object.freeze(new Cartesian2(1, 0));
Cartesian2.UNIT_Y = Object.freeze(new Cartesian2(0, 1));
Cartesian2.prototype.clone = function(result) {
  return Cartesian2.clone(this, result);
};
Cartesian2.prototype.equals = function(right) {
  return Cartesian2.equals(this, right);
};
Cartesian2.prototype.equalsEpsilon = function(right, relativeEpsilon, absoluteEpsilon) {
  return Cartesian2.equalsEpsilon(
    this,
    right,
    relativeEpsilon,
    absoluteEpsilon
  );
};
Cartesian2.prototype.toString = function() {
  return `(${this.x}, ${this.y})`;
};
var Cartesian2_default = Cartesian2;

// Source/Core/GeographicTilingScheme.js
function GeographicTilingScheme(options) {
  options = defaultValue_default(options, defaultValue_default.EMPTY_OBJECT);
  this._ellipsoid = defaultValue_default(options.ellipsoid, Ellipsoid_default.WGS84);
  this._rectangle = defaultValue_default(options.rectangle, Rectangle_default.MAX_VALUE);
  this._projection = new GeographicProjection_default(this._ellipsoid);
  this._numberOfLevelZeroTilesX = defaultValue_default(
    options.numberOfLevelZeroTilesX,
    2
  );
  this._numberOfLevelZeroTilesY = defaultValue_default(
    options.numberOfLevelZeroTilesY,
    1
  );
}
Object.defineProperties(GeographicTilingScheme.prototype, {
  ellipsoid: {
    get: function() {
      return this._ellipsoid;
    }
  },
  rectangle: {
    get: function() {
      return this._rectangle;
    }
  },
  projection: {
    get: function() {
      return this._projection;
    }
  }
});
GeographicTilingScheme.prototype.getNumberOfXTilesAtLevel = function(level) {
  return this._numberOfLevelZeroTilesX << level;
};
GeographicTilingScheme.prototype.getNumberOfYTilesAtLevel = function(level) {
  return this._numberOfLevelZeroTilesY << level;
};
GeographicTilingScheme.prototype.rectangleToNativeRectangle = function(rectangle, result) {
  Check_default.defined("rectangle", rectangle);
  const west = Math_default.toDegrees(rectangle.west);
  const south = Math_default.toDegrees(rectangle.south);
  const east = Math_default.toDegrees(rectangle.east);
  const north = Math_default.toDegrees(rectangle.north);
  if (!defined_default(result)) {
    return new Rectangle_default(west, south, east, north);
  }
  result.west = west;
  result.south = south;
  result.east = east;
  result.north = north;
  return result;
};
GeographicTilingScheme.prototype.tileXYToNativeRectangle = function(x, y, level, result) {
  const rectangleRadians = this.tileXYToRectangle(x, y, level, result);
  rectangleRadians.west = Math_default.toDegrees(rectangleRadians.west);
  rectangleRadians.south = Math_default.toDegrees(rectangleRadians.south);
  rectangleRadians.east = Math_default.toDegrees(rectangleRadians.east);
  rectangleRadians.north = Math_default.toDegrees(rectangleRadians.north);
  return rectangleRadians;
};
GeographicTilingScheme.prototype.tileXYToRectangle = function(x, y, level, result) {
  const rectangle = this._rectangle;
  const xTiles = this.getNumberOfXTilesAtLevel(level);
  const yTiles = this.getNumberOfYTilesAtLevel(level);
  const xTileWidth = rectangle.width / xTiles;
  const west = x * xTileWidth + rectangle.west;
  const east = (x + 1) * xTileWidth + rectangle.west;
  const yTileHeight = rectangle.height / yTiles;
  const north = rectangle.north - y * yTileHeight;
  const south = rectangle.north - (y + 1) * yTileHeight;
  if (!defined_default(result)) {
    result = new Rectangle_default(west, south, east, north);
  }
  result.west = west;
  result.south = south;
  result.east = east;
  result.north = north;
  return result;
};
GeographicTilingScheme.prototype.positionToTileXY = function(position, level, result) {
  const rectangle = this._rectangle;
  if (!Rectangle_default.contains(rectangle, position)) {
    return void 0;
  }
  const xTiles = this.getNumberOfXTilesAtLevel(level);
  const yTiles = this.getNumberOfYTilesAtLevel(level);
  const xTileWidth = rectangle.width / xTiles;
  const yTileHeight = rectangle.height / yTiles;
  let longitude = position.longitude;
  if (rectangle.east < rectangle.west) {
    longitude += Math_default.TWO_PI;
  }
  let xTileCoordinate = (longitude - rectangle.west) / xTileWidth | 0;
  if (xTileCoordinate >= xTiles) {
    xTileCoordinate = xTiles - 1;
  }
  let yTileCoordinate = (rectangle.north - position.latitude) / yTileHeight | 0;
  if (yTileCoordinate >= yTiles) {
    yTileCoordinate = yTiles - 1;
  }
  if (!defined_default(result)) {
    return new Cartesian2_default(xTileCoordinate, yTileCoordinate);
  }
  result.x = xTileCoordinate;
  result.y = yTileCoordinate;
  return result;
};
var GeographicTilingScheme_default = GeographicTilingScheme;

// Source/Core/ApproximateTerrainHeights.js
var scratchDiagonalCartesianNE = new Cartesian3_default();
var scratchDiagonalCartesianSW = new Cartesian3_default();
var scratchDiagonalCartographic = new Cartographic_default();
var scratchCenterCartesian = new Cartesian3_default();
var scratchSurfaceCartesian = new Cartesian3_default();
var scratchBoundingSphere = new BoundingSphere_default();
var tilingScheme = new GeographicTilingScheme_default();
var scratchCorners = [
  new Cartographic_default(),
  new Cartographic_default(),
  new Cartographic_default(),
  new Cartographic_default()
];
var scratchTileXY = new Cartesian2_default();
var ApproximateTerrainHeights = {};
ApproximateTerrainHeights.initialize = function() {
  let initPromise = ApproximateTerrainHeights._initPromise;
  if (defined_default(initPromise)) {
    return initPromise;
  }
  initPromise = Resource_default.fetchJson(
    buildModuleUrl_default("Assets/approximateTerrainHeights.json")
  ).then(function(json) {
    ApproximateTerrainHeights._terrainHeights = json;
  });
  ApproximateTerrainHeights._initPromise = initPromise;
  return initPromise;
};
ApproximateTerrainHeights.getMinimumMaximumHeights = function(rectangle, ellipsoid) {
  Check_default.defined("rectangle", rectangle);
  if (!defined_default(ApproximateTerrainHeights._terrainHeights)) {
    throw new DeveloperError_default(
      "You must call ApproximateTerrainHeights.initialize and wait for the promise to resolve before using this function"
    );
  }
  ellipsoid = defaultValue_default(ellipsoid, Ellipsoid_default.WGS84);
  const xyLevel = getTileXYLevel(rectangle);
  let minTerrainHeight = ApproximateTerrainHeights._defaultMinTerrainHeight;
  let maxTerrainHeight = ApproximateTerrainHeights._defaultMaxTerrainHeight;
  if (defined_default(xyLevel)) {
    const key = `${xyLevel.level}-${xyLevel.x}-${xyLevel.y}`;
    const heights = ApproximateTerrainHeights._terrainHeights[key];
    if (defined_default(heights)) {
      minTerrainHeight = heights[0];
      maxTerrainHeight = heights[1];
    }
    ellipsoid.cartographicToCartesian(
      Rectangle_default.northeast(rectangle, scratchDiagonalCartographic),
      scratchDiagonalCartesianNE
    );
    ellipsoid.cartographicToCartesian(
      Rectangle_default.southwest(rectangle, scratchDiagonalCartographic),
      scratchDiagonalCartesianSW
    );
    Cartesian3_default.midpoint(
      scratchDiagonalCartesianSW,
      scratchDiagonalCartesianNE,
      scratchCenterCartesian
    );
    const surfacePosition = ellipsoid.scaleToGeodeticSurface(
      scratchCenterCartesian,
      scratchSurfaceCartesian
    );
    if (defined_default(surfacePosition)) {
      const distance2 = Cartesian3_default.distance(
        scratchCenterCartesian,
        surfacePosition
      );
      minTerrainHeight = Math.min(minTerrainHeight, -distance2);
    } else {
      minTerrainHeight = ApproximateTerrainHeights._defaultMinTerrainHeight;
    }
  }
  minTerrainHeight = Math.max(
    ApproximateTerrainHeights._defaultMinTerrainHeight,
    minTerrainHeight
  );
  return {
    minimumTerrainHeight: minTerrainHeight,
    maximumTerrainHeight: maxTerrainHeight
  };
};
ApproximateTerrainHeights.getBoundingSphere = function(rectangle, ellipsoid) {
  Check_default.defined("rectangle", rectangle);
  if (!defined_default(ApproximateTerrainHeights._terrainHeights)) {
    throw new DeveloperError_default(
      "You must call ApproximateTerrainHeights.initialize and wait for the promise to resolve before using this function"
    );
  }
  ellipsoid = defaultValue_default(ellipsoid, Ellipsoid_default.WGS84);
  const xyLevel = getTileXYLevel(rectangle);
  let maxTerrainHeight = ApproximateTerrainHeights._defaultMaxTerrainHeight;
  if (defined_default(xyLevel)) {
    const key = `${xyLevel.level}-${xyLevel.x}-${xyLevel.y}`;
    const heights = ApproximateTerrainHeights._terrainHeights[key];
    if (defined_default(heights)) {
      maxTerrainHeight = heights[1];
    }
  }
  const result = BoundingSphere_default.fromRectangle3D(rectangle, ellipsoid, 0);
  BoundingSphere_default.fromRectangle3D(
    rectangle,
    ellipsoid,
    maxTerrainHeight,
    scratchBoundingSphere
  );
  return BoundingSphere_default.union(result, scratchBoundingSphere, result);
};
function getTileXYLevel(rectangle) {
  Cartographic_default.fromRadians(
    rectangle.east,
    rectangle.north,
    0,
    scratchCorners[0]
  );
  Cartographic_default.fromRadians(
    rectangle.west,
    rectangle.north,
    0,
    scratchCorners[1]
  );
  Cartographic_default.fromRadians(
    rectangle.east,
    rectangle.south,
    0,
    scratchCorners[2]
  );
  Cartographic_default.fromRadians(
    rectangle.west,
    rectangle.south,
    0,
    scratchCorners[3]
  );
  let lastLevelX = 0, lastLevelY = 0;
  let currentX = 0, currentY = 0;
  const maxLevel = ApproximateTerrainHeights._terrainHeightsMaxLevel;
  let i;
  for (i = 0; i <= maxLevel; ++i) {
    let failed = false;
    for (let j = 0; j < 4; ++j) {
      const corner = scratchCorners[j];
      tilingScheme.positionToTileXY(corner, i, scratchTileXY);
      if (j === 0) {
        currentX = scratchTileXY.x;
        currentY = scratchTileXY.y;
      } else if (currentX !== scratchTileXY.x || currentY !== scratchTileXY.y) {
        failed = true;
        break;
      }
    }
    if (failed) {
      break;
    }
    lastLevelX = currentX;
    lastLevelY = currentY;
  }
  if (i === 0) {
    return void 0;
  }
  return {
    x: lastLevelX,
    y: lastLevelY,
    level: i > maxLevel ? maxLevel : i - 1
  };
}
ApproximateTerrainHeights._terrainHeightsMaxLevel = 6;
ApproximateTerrainHeights._defaultMaxTerrainHeight = 9e3;
ApproximateTerrainHeights._defaultMinTerrainHeight = -1e5;
ApproximateTerrainHeights._terrainHeights = void 0;
ApproximateTerrainHeights._initPromise = void 0;
Object.defineProperties(ApproximateTerrainHeights, {
  initialized: {
    get: function() {
      return defined_default(ApproximateTerrainHeights._terrainHeights);
    }
  }
});
var ApproximateTerrainHeights_default = ApproximateTerrainHeights;

// Source/Core/Credit.js
var import_dompurify = __toESM(require_purify_cjs(), 1);
var nextCreditId = 0;
var creditToId = {};
function Credit(html, showOnScreen) {
  Check_default.typeOf.string("html", html);
  let id;
  const key = html;
  if (defined_default(creditToId[key])) {
    id = creditToId[key];
  } else {
    id = nextCreditId++;
    creditToId[key] = id;
  }
  showOnScreen = defaultValue_default(showOnScreen, false);
  this._id = id;
  this._html = html;
  this._showOnScreen = showOnScreen;
  this._element = void 0;
}
Object.defineProperties(Credit.prototype, {
  html: {
    get: function() {
      return this._html;
    }
  },
  id: {
    get: function() {
      return this._id;
    }
  },
  showOnScreen: {
    get: function() {
      return this._showOnScreen;
    },
    set: function(value) {
      this._showOnScreen = value;
    }
  },
  element: {
    get: function() {
      if (!defined_default(this._element)) {
        const html = import_dompurify.default.sanitize(this._html);
        const div = document.createElement("div");
        div._creditId = this._id;
        div.style.display = "inline";
        div.innerHTML = html;
        const links = div.querySelectorAll("a");
        for (let i = 0; i < links.length; i++) {
          links[i].setAttribute("target", "_blank");
        }
        this._element = div;
      }
      return this._element;
    }
  }
});
Credit.equals = function(left, right) {
  return left === right || defined_default(left) && defined_default(right) && left._id === right._id && left._showOnScreen === right._showOnScreen;
};
Credit.prototype.equals = function(credit) {
  return Credit.equals(this, credit);
};
Credit.getIonCredit = function(attribution) {
  const showOnScreen = defined_default(attribution.collapsible) && !attribution.collapsible;
  const credit = new Credit(attribution.html, showOnScreen);
  credit._isIon = credit.html.indexOf("ion-credit.png") !== -1;
  return credit;
};
Credit.clone = function(credit) {
  if (defined_default(credit)) {
    return new Credit(credit.html, credit.showOnScreen);
  }
};
var Credit_default = Credit;

// Source/Core/HeightmapEncoding.js
var HeightmapEncoding = {
  NONE: 0,
  LERC: 1
};
var HeightmapEncoding_default = Object.freeze(HeightmapEncoding);

// Source/Core/AxisAlignedBoundingBox.js
function AxisAlignedBoundingBox(minimum, maximum, center) {
  this.minimum = Cartesian3_default.clone(defaultValue_default(minimum, Cartesian3_default.ZERO));
  this.maximum = Cartesian3_default.clone(defaultValue_default(maximum, Cartesian3_default.ZERO));
  if (!defined_default(center)) {
    center = Cartesian3_default.midpoint(this.minimum, this.maximum, new Cartesian3_default());
  } else {
    center = Cartesian3_default.clone(center);
  }
  this.center = center;
}
AxisAlignedBoundingBox.fromCorners = function(minimum, maximum, result) {
  Check_default.defined("minimum", minimum);
  Check_default.defined("maximum", maximum);
  if (!defined_default(result)) {
    result = new AxisAlignedBoundingBox();
  }
  result.minimum = Cartesian3_default.clone(minimum, result.minimum);
  result.maximum = Cartesian3_default.clone(maximum, result.maximum);
  result.center = Cartesian3_default.midpoint(minimum, maximum, result.center);
  return result;
};
AxisAlignedBoundingBox.fromPoints = function(positions, result) {
  if (!defined_default(result)) {
    result = new AxisAlignedBoundingBox();
  }
  if (!defined_default(positions) || positions.length === 0) {
    result.minimum = Cartesian3_default.clone(Cartesian3_default.ZERO, result.minimum);
    result.maximum = Cartesian3_default.clone(Cartesian3_default.ZERO, result.maximum);
    result.center = Cartesian3_default.clone(Cartesian3_default.ZERO, result.center);
    return result;
  }
  let minimumX = positions[0].x;
  let minimumY = positions[0].y;
  let minimumZ = positions[0].z;
  let maximumX = positions[0].x;
  let maximumY = positions[0].y;
  let maximumZ = positions[0].z;
  const length3 = positions.length;
  for (let i = 1; i < length3; i++) {
    const p = positions[i];
    const x = p.x;
    const y = p.y;
    const z = p.z;
    minimumX = Math.min(x, minimumX);
    maximumX = Math.max(x, maximumX);
    minimumY = Math.min(y, minimumY);
    maximumY = Math.max(y, maximumY);
    minimumZ = Math.min(z, minimumZ);
    maximumZ = Math.max(z, maximumZ);
  }
  const minimum = result.minimum;
  minimum.x = minimumX;
  minimum.y = minimumY;
  minimum.z = minimumZ;
  const maximum = result.maximum;
  maximum.x = maximumX;
  maximum.y = maximumY;
  maximum.z = maximumZ;
  result.center = Cartesian3_default.midpoint(minimum, maximum, result.center);
  return result;
};
AxisAlignedBoundingBox.clone = function(box, result) {
  if (!defined_default(box)) {
    return void 0;
  }
  if (!defined_default(result)) {
    return new AxisAlignedBoundingBox(box.minimum, box.maximum, box.center);
  }
  result.minimum = Cartesian3_default.clone(box.minimum, result.minimum);
  result.maximum = Cartesian3_default.clone(box.maximum, result.maximum);
  result.center = Cartesian3_default.clone(box.center, result.center);
  return result;
};
AxisAlignedBoundingBox.equals = function(left, right) {
  return left === right || defined_default(left) && defined_default(right) && Cartesian3_default.equals(left.center, right.center) && Cartesian3_default.equals(left.minimum, right.minimum) && Cartesian3_default.equals(left.maximum, right.maximum);
};
var intersectScratch = new Cartesian3_default();
AxisAlignedBoundingBox.intersectPlane = function(box, plane) {
  Check_default.defined("box", box);
  Check_default.defined("plane", plane);
  intersectScratch = Cartesian3_default.subtract(
    box.maximum,
    box.minimum,
    intersectScratch
  );
  const h = Cartesian3_default.multiplyByScalar(
    intersectScratch,
    0.5,
    intersectScratch
  );
  const normal2 = plane.normal;
  const e = h.x * Math.abs(normal2.x) + h.y * Math.abs(normal2.y) + h.z * Math.abs(normal2.z);
  const s = Cartesian3_default.dot(box.center, normal2) + plane.distance;
  if (s - e > 0) {
    return Intersect_default.INSIDE;
  }
  if (s + e < 0) {
    return Intersect_default.OUTSIDE;
  }
  return Intersect_default.INTERSECTING;
};
AxisAlignedBoundingBox.prototype.clone = function(result) {
  return AxisAlignedBoundingBox.clone(this, result);
};
AxisAlignedBoundingBox.prototype.intersectPlane = function(plane) {
  return AxisAlignedBoundingBox.intersectPlane(this, plane);
};
AxisAlignedBoundingBox.prototype.equals = function(right) {
  return AxisAlignedBoundingBox.equals(this, right);
};
var AxisAlignedBoundingBox_default = AxisAlignedBoundingBox;

// Source/Core/EllipsoidalOccluder.js
function EllipsoidalOccluder(ellipsoid, cameraPosition) {
  Check_default.typeOf.object("ellipsoid", ellipsoid);
  this._ellipsoid = ellipsoid;
  this._cameraPosition = new Cartesian3_default();
  this._cameraPositionInScaledSpace = new Cartesian3_default();
  this._distanceToLimbInScaledSpaceSquared = 0;
  if (defined_default(cameraPosition)) {
    this.cameraPosition = cameraPosition;
  }
}
Object.defineProperties(EllipsoidalOccluder.prototype, {
  ellipsoid: {
    get: function() {
      return this._ellipsoid;
    }
  },
  cameraPosition: {
    get: function() {
      return this._cameraPosition;
    },
    set: function(cameraPosition) {
      const ellipsoid = this._ellipsoid;
      const cv = ellipsoid.transformPositionToScaledSpace(
        cameraPosition,
        this._cameraPositionInScaledSpace
      );
      const vhMagnitudeSquared = Cartesian3_default.magnitudeSquared(cv) - 1;
      Cartesian3_default.clone(cameraPosition, this._cameraPosition);
      this._cameraPositionInScaledSpace = cv;
      this._distanceToLimbInScaledSpaceSquared = vhMagnitudeSquared;
    }
  }
});
var scratchCartesian = new Cartesian3_default();
EllipsoidalOccluder.prototype.isPointVisible = function(occludee) {
  const ellipsoid = this._ellipsoid;
  const occludeeScaledSpacePosition = ellipsoid.transformPositionToScaledSpace(
    occludee,
    scratchCartesian
  );
  return isScaledSpacePointVisible(
    occludeeScaledSpacePosition,
    this._cameraPositionInScaledSpace,
    this._distanceToLimbInScaledSpaceSquared
  );
};
EllipsoidalOccluder.prototype.isScaledSpacePointVisible = function(occludeeScaledSpacePosition) {
  return isScaledSpacePointVisible(
    occludeeScaledSpacePosition,
    this._cameraPositionInScaledSpace,
    this._distanceToLimbInScaledSpaceSquared
  );
};
var scratchCameraPositionInScaledSpaceShrunk = new Cartesian3_default();
EllipsoidalOccluder.prototype.isScaledSpacePointVisiblePossiblyUnderEllipsoid = function(occludeeScaledSpacePosition, minimumHeight) {
  const ellipsoid = this._ellipsoid;
  let vhMagnitudeSquared;
  let cv;
  if (defined_default(minimumHeight) && minimumHeight < 0 && ellipsoid.minimumRadius > -minimumHeight) {
    cv = scratchCameraPositionInScaledSpaceShrunk;
    cv.x = this._cameraPosition.x / (ellipsoid.radii.x + minimumHeight);
    cv.y = this._cameraPosition.y / (ellipsoid.radii.y + minimumHeight);
    cv.z = this._cameraPosition.z / (ellipsoid.radii.z + minimumHeight);
    vhMagnitudeSquared = cv.x * cv.x + cv.y * cv.y + cv.z * cv.z - 1;
  } else {
    cv = this._cameraPositionInScaledSpace;
    vhMagnitudeSquared = this._distanceToLimbInScaledSpaceSquared;
  }
  return isScaledSpacePointVisible(
    occludeeScaledSpacePosition,
    cv,
    vhMagnitudeSquared
  );
};
EllipsoidalOccluder.prototype.computeHorizonCullingPoint = function(directionToPoint, positions, result) {
  return computeHorizonCullingPointFromPositions(
    this._ellipsoid,
    directionToPoint,
    positions,
    result
  );
};
var scratchEllipsoidShrunk = Ellipsoid_default.clone(Ellipsoid_default.UNIT_SPHERE);
EllipsoidalOccluder.prototype.computeHorizonCullingPointPossiblyUnderEllipsoid = function(directionToPoint, positions, minimumHeight, result) {
  const possiblyShrunkEllipsoid = getPossiblyShrunkEllipsoid(
    this._ellipsoid,
    minimumHeight,
    scratchEllipsoidShrunk
  );
  return computeHorizonCullingPointFromPositions(
    possiblyShrunkEllipsoid,
    directionToPoint,
    positions,
    result
  );
};
EllipsoidalOccluder.prototype.computeHorizonCullingPointFromVertices = function(directionToPoint, vertices, stride, center, result) {
  return computeHorizonCullingPointFromVertices(
    this._ellipsoid,
    directionToPoint,
    vertices,
    stride,
    center,
    result
  );
};
EllipsoidalOccluder.prototype.computeHorizonCullingPointFromVerticesPossiblyUnderEllipsoid = function(directionToPoint, vertices, stride, center, minimumHeight, result) {
  const possiblyShrunkEllipsoid = getPossiblyShrunkEllipsoid(
    this._ellipsoid,
    minimumHeight,
    scratchEllipsoidShrunk
  );
  return computeHorizonCullingPointFromVertices(
    possiblyShrunkEllipsoid,
    directionToPoint,
    vertices,
    stride,
    center,
    result
  );
};
var subsampleScratch = [];
EllipsoidalOccluder.prototype.computeHorizonCullingPointFromRectangle = function(rectangle, ellipsoid, result) {
  Check_default.typeOf.object("rectangle", rectangle);
  const positions = Rectangle_default.subsample(
    rectangle,
    ellipsoid,
    0,
    subsampleScratch
  );
  const bs = BoundingSphere_default.fromPoints(positions);
  if (Cartesian3_default.magnitude(bs.center) < 0.1 * ellipsoid.minimumRadius) {
    return void 0;
  }
  return this.computeHorizonCullingPoint(bs.center, positions, result);
};
var scratchEllipsoidShrunkRadii = new Cartesian3_default();
function getPossiblyShrunkEllipsoid(ellipsoid, minimumHeight, result) {
  if (defined_default(minimumHeight) && minimumHeight < 0 && ellipsoid.minimumRadius > -minimumHeight) {
    const ellipsoidShrunkRadii = Cartesian3_default.fromElements(
      ellipsoid.radii.x + minimumHeight,
      ellipsoid.radii.y + minimumHeight,
      ellipsoid.radii.z + minimumHeight,
      scratchEllipsoidShrunkRadii
    );
    ellipsoid = Ellipsoid_default.fromCartesian3(ellipsoidShrunkRadii, result);
  }
  return ellipsoid;
}
function computeHorizonCullingPointFromPositions(ellipsoid, directionToPoint, positions, result) {
  Check_default.typeOf.object("directionToPoint", directionToPoint);
  Check_default.defined("positions", positions);
  if (!defined_default(result)) {
    result = new Cartesian3_default();
  }
  const scaledSpaceDirectionToPoint = computeScaledSpaceDirectionToPoint(
    ellipsoid,
    directionToPoint
  );
  let resultMagnitude = 0;
  for (let i = 0, len = positions.length; i < len; ++i) {
    const position = positions[i];
    const candidateMagnitude = computeMagnitude(
      ellipsoid,
      position,
      scaledSpaceDirectionToPoint
    );
    if (candidateMagnitude < 0) {
      return void 0;
    }
    resultMagnitude = Math.max(resultMagnitude, candidateMagnitude);
  }
  return magnitudeToPoint(scaledSpaceDirectionToPoint, resultMagnitude, result);
}
var positionScratch = new Cartesian3_default();
function computeHorizonCullingPointFromVertices(ellipsoid, directionToPoint, vertices, stride, center, result) {
  Check_default.typeOf.object("directionToPoint", directionToPoint);
  Check_default.defined("vertices", vertices);
  Check_default.typeOf.number("stride", stride);
  if (!defined_default(result)) {
    result = new Cartesian3_default();
  }
  stride = defaultValue_default(stride, 3);
  center = defaultValue_default(center, Cartesian3_default.ZERO);
  const scaledSpaceDirectionToPoint = computeScaledSpaceDirectionToPoint(
    ellipsoid,
    directionToPoint
  );
  let resultMagnitude = 0;
  for (let i = 0, len = vertices.length; i < len; i += stride) {
    positionScratch.x = vertices[i] + center.x;
    positionScratch.y = vertices[i + 1] + center.y;
    positionScratch.z = vertices[i + 2] + center.z;
    const candidateMagnitude = computeMagnitude(
      ellipsoid,
      positionScratch,
      scaledSpaceDirectionToPoint
    );
    if (candidateMagnitude < 0) {
      return void 0;
    }
    resultMagnitude = Math.max(resultMagnitude, candidateMagnitude);
  }
  return magnitudeToPoint(scaledSpaceDirectionToPoint, resultMagnitude, result);
}
function isScaledSpacePointVisible(occludeeScaledSpacePosition, cameraPositionInScaledSpace, distanceToLimbInScaledSpaceSquared) {
  const cv = cameraPositionInScaledSpace;
  const vhMagnitudeSquared = distanceToLimbInScaledSpaceSquared;
  const vt = Cartesian3_default.subtract(
    occludeeScaledSpacePosition,
    cv,
    scratchCartesian
  );
  const vtDotVc = -Cartesian3_default.dot(vt, cv);
  const isOccluded = vhMagnitudeSquared < 0 ? vtDotVc > 0 : vtDotVc > vhMagnitudeSquared && vtDotVc * vtDotVc / Cartesian3_default.magnitudeSquared(vt) > vhMagnitudeSquared;
  return !isOccluded;
}
var scaledSpaceScratch = new Cartesian3_default();
var directionScratch = new Cartesian3_default();
function computeMagnitude(ellipsoid, position, scaledSpaceDirectionToPoint) {
  const scaledSpacePosition = ellipsoid.transformPositionToScaledSpace(
    position,
    scaledSpaceScratch
  );
  let magnitudeSquared = Cartesian3_default.magnitudeSquared(scaledSpacePosition);
  let magnitude = Math.sqrt(magnitudeSquared);
  const direction2 = Cartesian3_default.divideByScalar(
    scaledSpacePosition,
    magnitude,
    directionScratch
  );
  magnitudeSquared = Math.max(1, magnitudeSquared);
  magnitude = Math.max(1, magnitude);
  const cosAlpha = Cartesian3_default.dot(direction2, scaledSpaceDirectionToPoint);
  const sinAlpha = Cartesian3_default.magnitude(
    Cartesian3_default.cross(direction2, scaledSpaceDirectionToPoint, direction2)
  );
  const cosBeta = 1 / magnitude;
  const sinBeta = Math.sqrt(magnitudeSquared - 1) * cosBeta;
  return 1 / (cosAlpha * cosBeta - sinAlpha * sinBeta);
}
function magnitudeToPoint(scaledSpaceDirectionToPoint, resultMagnitude, result) {
  if (resultMagnitude <= 0 || resultMagnitude === 1 / 0 || resultMagnitude !== resultMagnitude) {
    return void 0;
  }
  return Cartesian3_default.multiplyByScalar(
    scaledSpaceDirectionToPoint,
    resultMagnitude,
    result
  );
}
var directionToPointScratch = new Cartesian3_default();
function computeScaledSpaceDirectionToPoint(ellipsoid, directionToPoint) {
  if (Cartesian3_default.equals(directionToPoint, Cartesian3_default.ZERO)) {
    return directionToPoint;
  }
  ellipsoid.transformPositionToScaledSpace(
    directionToPoint,
    directionToPointScratch
  );
  return Cartesian3_default.normalize(directionToPointScratch, directionToPointScratch);
}
var EllipsoidalOccluder_default = EllipsoidalOccluder;

// Source/Core/QuadraticRealPolynomial.js
var QuadraticRealPolynomial = {};
QuadraticRealPolynomial.computeDiscriminant = function(a3, b, c) {
  if (typeof a3 !== "number") {
    throw new DeveloperError_default("a is a required number.");
  }
  if (typeof b !== "number") {
    throw new DeveloperError_default("b is a required number.");
  }
  if (typeof c !== "number") {
    throw new DeveloperError_default("c is a required number.");
  }
  const discriminant = b * b - 4 * a3 * c;
  return discriminant;
};
function addWithCancellationCheck(left, right, tolerance) {
  const difference = left + right;
  if (Math_default.sign(left) !== Math_default.sign(right) && Math.abs(difference / Math.max(Math.abs(left), Math.abs(right))) < tolerance) {
    return 0;
  }
  return difference;
}
QuadraticRealPolynomial.computeRealRoots = function(a3, b, c) {
  if (typeof a3 !== "number") {
    throw new DeveloperError_default("a is a required number.");
  }
  if (typeof b !== "number") {
    throw new DeveloperError_default("b is a required number.");
  }
  if (typeof c !== "number") {
    throw new DeveloperError_default("c is a required number.");
  }
  let ratio;
  if (a3 === 0) {
    if (b === 0) {
      return [];
    }
    return [-c / b];
  } else if (b === 0) {
    if (c === 0) {
      return [0, 0];
    }
    const cMagnitude = Math.abs(c);
    const aMagnitude = Math.abs(a3);
    if (cMagnitude < aMagnitude && cMagnitude / aMagnitude < Math_default.EPSILON14) {
      return [0, 0];
    } else if (cMagnitude > aMagnitude && aMagnitude / cMagnitude < Math_default.EPSILON14) {
      return [];
    }
    ratio = -c / a3;
    if (ratio < 0) {
      return [];
    }
    const root = Math.sqrt(ratio);
    return [-root, root];
  } else if (c === 0) {
    ratio = -b / a3;
    if (ratio < 0) {
      return [ratio, 0];
    }
    return [0, ratio];
  }
  const b2 = b * b;
  const four_ac = 4 * a3 * c;
  const radicand = addWithCancellationCheck(b2, -four_ac, Math_default.EPSILON14);
  if (radicand < 0) {
    return [];
  }
  const q = -0.5 * addWithCancellationCheck(
    b,
    Math_default.sign(b) * Math.sqrt(radicand),
    Math_default.EPSILON14
  );
  if (b > 0) {
    return [q / a3, c / q];
  }
  return [c / q, q / a3];
};
var QuadraticRealPolynomial_default = QuadraticRealPolynomial;

// Source/Core/CubicRealPolynomial.js
var CubicRealPolynomial = {};
CubicRealPolynomial.computeDiscriminant = function(a3, b, c, d) {
  if (typeof a3 !== "number") {
    throw new DeveloperError_default("a is a required number.");
  }
  if (typeof b !== "number") {
    throw new DeveloperError_default("b is a required number.");
  }
  if (typeof c !== "number") {
    throw new DeveloperError_default("c is a required number.");
  }
  if (typeof d !== "number") {
    throw new DeveloperError_default("d is a required number.");
  }
  const a22 = a3 * a3;
  const b2 = b * b;
  const c22 = c * c;
  const d2 = d * d;
  const discriminant = 18 * a3 * b * c * d + b2 * c22 - 27 * a22 * d2 - 4 * (a3 * c22 * c + b2 * b * d);
  return discriminant;
};
function computeRealRoots(a3, b, c, d) {
  const A = a3;
  const B = b / 3;
  const C = c / 3;
  const D = d;
  const AC = A * C;
  const BD = B * D;
  const B2 = B * B;
  const C2 = C * C;
  const delta1 = A * C - B2;
  const delta2 = A * D - B * C;
  const delta3 = B * D - C2;
  const discriminant = 4 * delta1 * delta3 - delta2 * delta2;
  let temp;
  let temp1;
  if (discriminant < 0) {
    let ABar;
    let CBar;
    let DBar;
    if (B2 * BD >= AC * C2) {
      ABar = A;
      CBar = delta1;
      DBar = -2 * B * delta1 + A * delta2;
    } else {
      ABar = D;
      CBar = delta3;
      DBar = -D * delta2 + 2 * C * delta3;
    }
    const s = DBar < 0 ? -1 : 1;
    const temp0 = -s * Math.abs(ABar) * Math.sqrt(-discriminant);
    temp1 = -DBar + temp0;
    const x = temp1 / 2;
    const p = x < 0 ? -Math.pow(-x, 1 / 3) : Math.pow(x, 1 / 3);
    const q = temp1 === temp0 ? -p : -CBar / p;
    temp = CBar <= 0 ? p + q : -DBar / (p * p + q * q + CBar);
    if (B2 * BD >= AC * C2) {
      return [(temp - B) / A];
    }
    return [-D / (temp + C)];
  }
  const CBarA = delta1;
  const DBarA = -2 * B * delta1 + A * delta2;
  const CBarD = delta3;
  const DBarD = -D * delta2 + 2 * C * delta3;
  const squareRootOfDiscriminant = Math.sqrt(discriminant);
  const halfSquareRootOf3 = Math.sqrt(3) / 2;
  let theta = Math.abs(Math.atan2(A * squareRootOfDiscriminant, -DBarA) / 3);
  temp = 2 * Math.sqrt(-CBarA);
  let cosine = Math.cos(theta);
  temp1 = temp * cosine;
  let temp3 = temp * (-cosine / 2 - halfSquareRootOf3 * Math.sin(theta));
  const numeratorLarge = temp1 + temp3 > 2 * B ? temp1 - B : temp3 - B;
  const denominatorLarge = A;
  const root1 = numeratorLarge / denominatorLarge;
  theta = Math.abs(Math.atan2(D * squareRootOfDiscriminant, -DBarD) / 3);
  temp = 2 * Math.sqrt(-CBarD);
  cosine = Math.cos(theta);
  temp1 = temp * cosine;
  temp3 = temp * (-cosine / 2 - halfSquareRootOf3 * Math.sin(theta));
  const numeratorSmall = -D;
  const denominatorSmall = temp1 + temp3 < 2 * C ? temp1 + C : temp3 + C;
  const root3 = numeratorSmall / denominatorSmall;
  const E = denominatorLarge * denominatorSmall;
  const F = -numeratorLarge * denominatorSmall - denominatorLarge * numeratorSmall;
  const G = numeratorLarge * numeratorSmall;
  const root2 = (C * F - B * G) / (-B * F + C * E);
  if (root1 <= root2) {
    if (root1 <= root3) {
      if (root2 <= root3) {
        return [root1, root2, root3];
      }
      return [root1, root3, root2];
    }
    return [root3, root1, root2];
  }
  if (root1 <= root3) {
    return [root2, root1, root3];
  }
  if (root2 <= root3) {
    return [root2, root3, root1];
  }
  return [root3, root2, root1];
}
CubicRealPolynomial.computeRealRoots = function(a3, b, c, d) {
  if (typeof a3 !== "number") {
    throw new DeveloperError_default("a is a required number.");
  }
  if (typeof b !== "number") {
    throw new DeveloperError_default("b is a required number.");
  }
  if (typeof c !== "number") {
    throw new DeveloperError_default("c is a required number.");
  }
  if (typeof d !== "number") {
    throw new DeveloperError_default("d is a required number.");
  }
  let roots;
  let ratio;
  if (a3 === 0) {
    return QuadraticRealPolynomial_default.computeRealRoots(b, c, d);
  } else if (b === 0) {
    if (c === 0) {
      if (d === 0) {
        return [0, 0, 0];
      }
      ratio = -d / a3;
      const root = ratio < 0 ? -Math.pow(-ratio, 1 / 3) : Math.pow(ratio, 1 / 3);
      return [root, root, root];
    } else if (d === 0) {
      roots = QuadraticRealPolynomial_default.computeRealRoots(a3, 0, c);
      if (roots.Length === 0) {
        return [0];
      }
      return [roots[0], 0, roots[1]];
    }
    return computeRealRoots(a3, 0, c, d);
  } else if (c === 0) {
    if (d === 0) {
      ratio = -b / a3;
      if (ratio < 0) {
        return [ratio, 0, 0];
      }
      return [0, 0, ratio];
    }
    return computeRealRoots(a3, b, 0, d);
  } else if (d === 0) {
    roots = QuadraticRealPolynomial_default.computeRealRoots(a3, b, c);
    if (roots.length === 0) {
      return [0];
    } else if (roots[1] <= 0) {
      return [roots[0], roots[1], 0];
    } else if (roots[0] >= 0) {
      return [0, roots[0], roots[1]];
    }
    return [roots[0], 0, roots[1]];
  }
  return computeRealRoots(a3, b, c, d);
};
var CubicRealPolynomial_default = CubicRealPolynomial;

// Source/Core/QuarticRealPolynomial.js
var QuarticRealPolynomial = {};
QuarticRealPolynomial.computeDiscriminant = function(a3, b, c, d, e) {
  if (typeof a3 !== "number") {
    throw new DeveloperError_default("a is a required number.");
  }
  if (typeof b !== "number") {
    throw new DeveloperError_default("b is a required number.");
  }
  if (typeof c !== "number") {
    throw new DeveloperError_default("c is a required number.");
  }
  if (typeof d !== "number") {
    throw new DeveloperError_default("d is a required number.");
  }
  if (typeof e !== "number") {
    throw new DeveloperError_default("e is a required number.");
  }
  const a22 = a3 * a3;
  const a32 = a22 * a3;
  const b2 = b * b;
  const b3 = b2 * b;
  const c22 = c * c;
  const c33 = c22 * c;
  const d2 = d * d;
  const d3 = d2 * d;
  const e2 = e * e;
  const e3 = e2 * e;
  const discriminant = b2 * c22 * d2 - 4 * b3 * d3 - 4 * a3 * c33 * d2 + 18 * a3 * b * c * d3 - 27 * a22 * d2 * d2 + 256 * a32 * e3 + e * (18 * b3 * c * d - 4 * b2 * c33 + 16 * a3 * c22 * c22 - 80 * a3 * b * c22 * d - 6 * a3 * b2 * d2 + 144 * a22 * c * d2) + e2 * (144 * a3 * b2 * c - 27 * b2 * b2 - 128 * a22 * c22 - 192 * a22 * b * d);
  return discriminant;
};
function original(a3, a22, a1, a0) {
  const a3Squared = a3 * a3;
  const p = a22 - 3 * a3Squared / 8;
  const q = a1 - a22 * a3 / 2 + a3Squared * a3 / 8;
  const r = a0 - a1 * a3 / 4 + a22 * a3Squared / 16 - 3 * a3Squared * a3Squared / 256;
  const cubicRoots = CubicRealPolynomial_default.computeRealRoots(
    1,
    2 * p,
    p * p - 4 * r,
    -q * q
  );
  if (cubicRoots.length > 0) {
    const temp = -a3 / 4;
    const hSquared = cubicRoots[cubicRoots.length - 1];
    if (Math.abs(hSquared) < Math_default.EPSILON14) {
      const roots = QuadraticRealPolynomial_default.computeRealRoots(1, p, r);
      if (roots.length === 2) {
        const root0 = roots[0];
        const root1 = roots[1];
        let y;
        if (root0 >= 0 && root1 >= 0) {
          const y0 = Math.sqrt(root0);
          const y1 = Math.sqrt(root1);
          return [temp - y1, temp - y0, temp + y0, temp + y1];
        } else if (root0 >= 0 && root1 < 0) {
          y = Math.sqrt(root0);
          return [temp - y, temp + y];
        } else if (root0 < 0 && root1 >= 0) {
          y = Math.sqrt(root1);
          return [temp - y, temp + y];
        }
      }
      return [];
    } else if (hSquared > 0) {
      const h = Math.sqrt(hSquared);
      const m = (p + hSquared - q / h) / 2;
      const n = (p + hSquared + q / h) / 2;
      const roots1 = QuadraticRealPolynomial_default.computeRealRoots(1, h, m);
      const roots2 = QuadraticRealPolynomial_default.computeRealRoots(1, -h, n);
      if (roots1.length !== 0) {
        roots1[0] += temp;
        roots1[1] += temp;
        if (roots2.length !== 0) {
          roots2[0] += temp;
          roots2[1] += temp;
          if (roots1[1] <= roots2[0]) {
            return [roots1[0], roots1[1], roots2[0], roots2[1]];
          } else if (roots2[1] <= roots1[0]) {
            return [roots2[0], roots2[1], roots1[0], roots1[1]];
          } else if (roots1[0] >= roots2[0] && roots1[1] <= roots2[1]) {
            return [roots2[0], roots1[0], roots1[1], roots2[1]];
          } else if (roots2[0] >= roots1[0] && roots2[1] <= roots1[1]) {
            return [roots1[0], roots2[0], roots2[1], roots1[1]];
          } else if (roots1[0] > roots2[0] && roots1[0] < roots2[1]) {
            return [roots2[0], roots1[0], roots2[1], roots1[1]];
          }
          return [roots1[0], roots2[0], roots1[1], roots2[1]];
        }
        return roots1;
      }
      if (roots2.length !== 0) {
        roots2[0] += temp;
        roots2[1] += temp;
        return roots2;
      }
      return [];
    }
  }
  return [];
}
function neumark(a3, a22, a1, a0) {
  const a1Squared = a1 * a1;
  const a2Squared = a22 * a22;
  const a3Squared = a3 * a3;
  const p = -2 * a22;
  const q = a1 * a3 + a2Squared - 4 * a0;
  const r = a3Squared * a0 - a1 * a22 * a3 + a1Squared;
  const cubicRoots = CubicRealPolynomial_default.computeRealRoots(1, p, q, r);
  if (cubicRoots.length > 0) {
    const y = cubicRoots[0];
    const temp = a22 - y;
    const tempSquared = temp * temp;
    const g1 = a3 / 2;
    const h1 = temp / 2;
    const m = tempSquared - 4 * a0;
    const mError = tempSquared + 4 * Math.abs(a0);
    const n = a3Squared - 4 * y;
    const nError = a3Squared + 4 * Math.abs(y);
    let g2;
    let h2;
    if (y < 0 || m * nError < n * mError) {
      const squareRootOfN = Math.sqrt(n);
      g2 = squareRootOfN / 2;
      h2 = squareRootOfN === 0 ? 0 : (a3 * h1 - a1) / squareRootOfN;
    } else {
      const squareRootOfM = Math.sqrt(m);
      g2 = squareRootOfM === 0 ? 0 : (a3 * h1 - a1) / squareRootOfM;
      h2 = squareRootOfM / 2;
    }
    let G;
    let g;
    if (g1 === 0 && g2 === 0) {
      G = 0;
      g = 0;
    } else if (Math_default.sign(g1) === Math_default.sign(g2)) {
      G = g1 + g2;
      g = y / G;
    } else {
      g = g1 - g2;
      G = y / g;
    }
    let H;
    let h;
    if (h1 === 0 && h2 === 0) {
      H = 0;
      h = 0;
    } else if (Math_default.sign(h1) === Math_default.sign(h2)) {
      H = h1 + h2;
      h = a0 / H;
    } else {
      h = h1 - h2;
      H = a0 / h;
    }
    const roots1 = QuadraticRealPolynomial_default.computeRealRoots(1, G, H);
    const roots2 = QuadraticRealPolynomial_default.computeRealRoots(1, g, h);
    if (roots1.length !== 0) {
      if (roots2.length !== 0) {
        if (roots1[1] <= roots2[0]) {
          return [roots1[0], roots1[1], roots2[0], roots2[1]];
        } else if (roots2[1] <= roots1[0]) {
          return [roots2[0], roots2[1], roots1[0], roots1[1]];
        } else if (roots1[0] >= roots2[0] && roots1[1] <= roots2[1]) {
          return [roots2[0], roots1[0], roots1[1], roots2[1]];
        } else if (roots2[0] >= roots1[0] && roots2[1] <= roots1[1]) {
          return [roots1[0], roots2[0], roots2[1], roots1[1]];
        } else if (roots1[0] > roots2[0] && roots1[0] < roots2[1]) {
          return [roots2[0], roots1[0], roots2[1], roots1[1]];
        }
        return [roots1[0], roots2[0], roots1[1], roots2[1]];
      }
      return roots1;
    }
    if (roots2.length !== 0) {
      return roots2;
    }
  }
  return [];
}
QuarticRealPolynomial.computeRealRoots = function(a3, b, c, d, e) {
  if (typeof a3 !== "number") {
    throw new DeveloperError_default("a is a required number.");
  }
  if (typeof b !== "number") {
    throw new DeveloperError_default("b is a required number.");
  }
  if (typeof c !== "number") {
    throw new DeveloperError_default("c is a required number.");
  }
  if (typeof d !== "number") {
    throw new DeveloperError_default("d is a required number.");
  }
  if (typeof e !== "number") {
    throw new DeveloperError_default("e is a required number.");
  }
  if (Math.abs(a3) < Math_default.EPSILON15) {
    return CubicRealPolynomial_default.computeRealRoots(b, c, d, e);
  }
  const a32 = b / a3;
  const a22 = c / a3;
  const a1 = d / a3;
  const a0 = e / a3;
  let k = a32 < 0 ? 1 : 0;
  k += a22 < 0 ? k + 1 : k;
  k += a1 < 0 ? k + 1 : k;
  k += a0 < 0 ? k + 1 : k;
  switch (k) {
    case 0:
      return original(a32, a22, a1, a0);
    case 1:
      return neumark(a32, a22, a1, a0);
    case 2:
      return neumark(a32, a22, a1, a0);
    case 3:
      return original(a32, a22, a1, a0);
    case 4:
      return original(a32, a22, a1, a0);
    case 5:
      return neumark(a32, a22, a1, a0);
    case 6:
      return original(a32, a22, a1, a0);
    case 7:
      return original(a32, a22, a1, a0);
    case 8:
      return neumark(a32, a22, a1, a0);
    case 9:
      return original(a32, a22, a1, a0);
    case 10:
      return original(a32, a22, a1, a0);
    case 11:
      return neumark(a32, a22, a1, a0);
    case 12:
      return original(a32, a22, a1, a0);
    case 13:
      return original(a32, a22, a1, a0);
    case 14:
      return original(a32, a22, a1, a0);
    case 15:
      return original(a32, a22, a1, a0);
    default:
      return void 0;
  }
};
var QuarticRealPolynomial_default = QuarticRealPolynomial;

// Source/Core/Ray.js
function Ray(origin, direction2) {
  direction2 = Cartesian3_default.clone(defaultValue_default(direction2, Cartesian3_default.ZERO));
  if (!Cartesian3_default.equals(direction2, Cartesian3_default.ZERO)) {
    Cartesian3_default.normalize(direction2, direction2);
  }
  this.origin = Cartesian3_default.clone(defaultValue_default(origin, Cartesian3_default.ZERO));
  this.direction = direction2;
}
Ray.clone = function(ray, result) {
  if (!defined_default(ray)) {
    return void 0;
  }
  if (!defined_default(result)) {
    return new Ray(ray.origin, ray.direction);
  }
  result.origin = Cartesian3_default.clone(ray.origin);
  result.direction = Cartesian3_default.clone(ray.direction);
  return result;
};
Ray.getPoint = function(ray, t, result) {
  Check_default.typeOf.object("ray", ray);
  Check_default.typeOf.number("t", t);
  if (!defined_default(result)) {
    result = new Cartesian3_default();
  }
  result = Cartesian3_default.multiplyByScalar(ray.direction, t, result);
  return Cartesian3_default.add(ray.origin, result, result);
};
var Ray_default = Ray;

// Source/Core/IntersectionTests.js
var IntersectionTests = {};
IntersectionTests.rayPlane = function(ray, plane, result) {
  if (!defined_default(ray)) {
    throw new DeveloperError_default("ray is required.");
  }
  if (!defined_default(plane)) {
    throw new DeveloperError_default("plane is required.");
  }
  if (!defined_default(result)) {
    result = new Cartesian3_default();
  }
  const origin = ray.origin;
  const direction2 = ray.direction;
  const normal2 = plane.normal;
  const denominator = Cartesian3_default.dot(normal2, direction2);
  if (Math.abs(denominator) < Math_default.EPSILON15) {
    return void 0;
  }
  const t = (-plane.distance - Cartesian3_default.dot(normal2, origin)) / denominator;
  if (t < 0) {
    return void 0;
  }
  result = Cartesian3_default.multiplyByScalar(direction2, t, result);
  return Cartesian3_default.add(origin, result, result);
};
var scratchEdge0 = new Cartesian3_default();
var scratchEdge1 = new Cartesian3_default();
var scratchPVec = new Cartesian3_default();
var scratchTVec = new Cartesian3_default();
var scratchQVec = new Cartesian3_default();
IntersectionTests.rayTriangleParametric = function(ray, p0, p1, p2, cullBackFaces) {
  if (!defined_default(ray)) {
    throw new DeveloperError_default("ray is required.");
  }
  if (!defined_default(p0)) {
    throw new DeveloperError_default("p0 is required.");
  }
  if (!defined_default(p1)) {
    throw new DeveloperError_default("p1 is required.");
  }
  if (!defined_default(p2)) {
    throw new DeveloperError_default("p2 is required.");
  }
  cullBackFaces = defaultValue_default(cullBackFaces, false);
  const origin = ray.origin;
  const direction2 = ray.direction;
  const edge0 = Cartesian3_default.subtract(p1, p0, scratchEdge0);
  const edge1 = Cartesian3_default.subtract(p2, p0, scratchEdge1);
  const p = Cartesian3_default.cross(direction2, edge1, scratchPVec);
  const det = Cartesian3_default.dot(edge0, p);
  let tvec;
  let q;
  let u3;
  let v7;
  let t;
  if (cullBackFaces) {
    if (det < Math_default.EPSILON6) {
      return void 0;
    }
    tvec = Cartesian3_default.subtract(origin, p0, scratchTVec);
    u3 = Cartesian3_default.dot(tvec, p);
    if (u3 < 0 || u3 > det) {
      return void 0;
    }
    q = Cartesian3_default.cross(tvec, edge0, scratchQVec);
    v7 = Cartesian3_default.dot(direction2, q);
    if (v7 < 0 || u3 + v7 > det) {
      return void 0;
    }
    t = Cartesian3_default.dot(edge1, q) / det;
  } else {
    if (Math.abs(det) < Math_default.EPSILON6) {
      return void 0;
    }
    const invDet = 1 / det;
    tvec = Cartesian3_default.subtract(origin, p0, scratchTVec);
    u3 = Cartesian3_default.dot(tvec, p) * invDet;
    if (u3 < 0 || u3 > 1) {
      return void 0;
    }
    q = Cartesian3_default.cross(tvec, edge0, scratchQVec);
    v7 = Cartesian3_default.dot(direction2, q) * invDet;
    if (v7 < 0 || u3 + v7 > 1) {
      return void 0;
    }
    t = Cartesian3_default.dot(edge1, q) * invDet;
  }
  return t;
};
IntersectionTests.rayTriangle = function(ray, p0, p1, p2, cullBackFaces, result) {
  const t = IntersectionTests.rayTriangleParametric(
    ray,
    p0,
    p1,
    p2,
    cullBackFaces
  );
  if (!defined_default(t) || t < 0) {
    return void 0;
  }
  if (!defined_default(result)) {
    result = new Cartesian3_default();
  }
  Cartesian3_default.multiplyByScalar(ray.direction, t, result);
  return Cartesian3_default.add(ray.origin, result, result);
};
var scratchLineSegmentTriangleRay = new Ray_default();
IntersectionTests.lineSegmentTriangle = function(v02, v13, p0, p1, p2, cullBackFaces, result) {
  if (!defined_default(v02)) {
    throw new DeveloperError_default("v0 is required.");
  }
  if (!defined_default(v13)) {
    throw new DeveloperError_default("v1 is required.");
  }
  if (!defined_default(p0)) {
    throw new DeveloperError_default("p0 is required.");
  }
  if (!defined_default(p1)) {
    throw new DeveloperError_default("p1 is required.");
  }
  if (!defined_default(p2)) {
    throw new DeveloperError_default("p2 is required.");
  }
  const ray = scratchLineSegmentTriangleRay;
  Cartesian3_default.clone(v02, ray.origin);
  Cartesian3_default.subtract(v13, v02, ray.direction);
  Cartesian3_default.normalize(ray.direction, ray.direction);
  const t = IntersectionTests.rayTriangleParametric(
    ray,
    p0,
    p1,
    p2,
    cullBackFaces
  );
  if (!defined_default(t) || t < 0 || t > Cartesian3_default.distance(v02, v13)) {
    return void 0;
  }
  if (!defined_default(result)) {
    result = new Cartesian3_default();
  }
  Cartesian3_default.multiplyByScalar(ray.direction, t, result);
  return Cartesian3_default.add(ray.origin, result, result);
};
function solveQuadratic(a3, b, c, result) {
  const det = b * b - 4 * a3 * c;
  if (det < 0) {
    return void 0;
  } else if (det > 0) {
    const denom = 1 / (2 * a3);
    const disc = Math.sqrt(det);
    const root0 = (-b + disc) * denom;
    const root1 = (-b - disc) * denom;
    if (root0 < root1) {
      result.root0 = root0;
      result.root1 = root1;
    } else {
      result.root0 = root1;
      result.root1 = root0;
    }
    return result;
  }
  const root = -b / (2 * a3);
  if (root === 0) {
    return void 0;
  }
  result.root0 = result.root1 = root;
  return result;
}
var raySphereRoots = {
  root0: 0,
  root1: 0
};
function raySphere(ray, sphere, result) {
  if (!defined_default(result)) {
    result = new Interval_default();
  }
  const origin = ray.origin;
  const direction2 = ray.direction;
  const center = sphere.center;
  const radiusSquared = sphere.radius * sphere.radius;
  const diff = Cartesian3_default.subtract(origin, center, scratchPVec);
  const a3 = Cartesian3_default.dot(direction2, direction2);
  const b = 2 * Cartesian3_default.dot(direction2, diff);
  const c = Cartesian3_default.magnitudeSquared(diff) - radiusSquared;
  const roots = solveQuadratic(a3, b, c, raySphereRoots);
  if (!defined_default(roots)) {
    return void 0;
  }
  result.start = roots.root0;
  result.stop = roots.root1;
  return result;
}
IntersectionTests.raySphere = function(ray, sphere, result) {
  if (!defined_default(ray)) {
    throw new DeveloperError_default("ray is required.");
  }
  if (!defined_default(sphere)) {
    throw new DeveloperError_default("sphere is required.");
  }
  result = raySphere(ray, sphere, result);
  if (!defined_default(result) || result.stop < 0) {
    return void 0;
  }
  result.start = Math.max(result.start, 0);
  return result;
};
var scratchLineSegmentRay = new Ray_default();
IntersectionTests.lineSegmentSphere = function(p0, p1, sphere, result) {
  if (!defined_default(p0)) {
    throw new DeveloperError_default("p0 is required.");
  }
  if (!defined_default(p1)) {
    throw new DeveloperError_default("p1 is required.");
  }
  if (!defined_default(sphere)) {
    throw new DeveloperError_default("sphere is required.");
  }
  const ray = scratchLineSegmentRay;
  Cartesian3_default.clone(p0, ray.origin);
  const direction2 = Cartesian3_default.subtract(p1, p0, ray.direction);
  const maxT = Cartesian3_default.magnitude(direction2);
  Cartesian3_default.normalize(direction2, direction2);
  result = raySphere(ray, sphere, result);
  if (!defined_default(result) || result.stop < 0 || result.start > maxT) {
    return void 0;
  }
  result.start = Math.max(result.start, 0);
  result.stop = Math.min(result.stop, maxT);
  return result;
};
var scratchQ = new Cartesian3_default();
var scratchW = new Cartesian3_default();
IntersectionTests.rayEllipsoid = function(ray, ellipsoid) {
  if (!defined_default(ray)) {
    throw new DeveloperError_default("ray is required.");
  }
  if (!defined_default(ellipsoid)) {
    throw new DeveloperError_default("ellipsoid is required.");
  }
  const inverseRadii = ellipsoid.oneOverRadii;
  const q = Cartesian3_default.multiplyComponents(inverseRadii, ray.origin, scratchQ);
  const w = Cartesian3_default.multiplyComponents(
    inverseRadii,
    ray.direction,
    scratchW
  );
  const q22 = Cartesian3_default.magnitudeSquared(q);
  const qw = Cartesian3_default.dot(q, w);
  let difference, w2, product, discriminant, temp;
  if (q22 > 1) {
    if (qw >= 0) {
      return void 0;
    }
    const qw2 = qw * qw;
    difference = q22 - 1;
    w2 = Cartesian3_default.magnitudeSquared(w);
    product = w2 * difference;
    if (qw2 < product) {
      return void 0;
    } else if (qw2 > product) {
      discriminant = qw * qw - product;
      temp = -qw + Math.sqrt(discriminant);
      const root0 = temp / w2;
      const root1 = difference / temp;
      if (root0 < root1) {
        return new Interval_default(root0, root1);
      }
      return {
        start: root1,
        stop: root0
      };
    }
    const root = Math.sqrt(difference / w2);
    return new Interval_default(root, root);
  } else if (q22 < 1) {
    difference = q22 - 1;
    w2 = Cartesian3_default.magnitudeSquared(w);
    product = w2 * difference;
    discriminant = qw * qw - product;
    temp = -qw + Math.sqrt(discriminant);
    return new Interval_default(0, temp / w2);
  }
  if (qw < 0) {
    w2 = Cartesian3_default.magnitudeSquared(w);
    return new Interval_default(0, -qw / w2);
  }
  return void 0;
};
function addWithCancellationCheck2(left, right, tolerance) {
  const difference = left + right;
  if (Math_default.sign(left) !== Math_default.sign(right) && Math.abs(difference / Math.max(Math.abs(left), Math.abs(right))) < tolerance) {
    return 0;
  }
  return difference;
}
function quadraticVectorExpression(A, b, c, x, w) {
  const xSquared = x * x;
  const wSquared = w * w;
  const l2 = (A[Matrix3_default.COLUMN1ROW1] - A[Matrix3_default.COLUMN2ROW2]) * wSquared;
  const l1 = w * (x * addWithCancellationCheck2(
    A[Matrix3_default.COLUMN1ROW0],
    A[Matrix3_default.COLUMN0ROW1],
    Math_default.EPSILON15
  ) + b.y);
  const l0 = A[Matrix3_default.COLUMN0ROW0] * xSquared + A[Matrix3_default.COLUMN2ROW2] * wSquared + x * b.x + c;
  const r1 = wSquared * addWithCancellationCheck2(
    A[Matrix3_default.COLUMN2ROW1],
    A[Matrix3_default.COLUMN1ROW2],
    Math_default.EPSILON15
  );
  const r0 = w * (x * addWithCancellationCheck2(A[Matrix3_default.COLUMN2ROW0], A[Matrix3_default.COLUMN0ROW2]) + b.z);
  let cosines;
  const solutions = [];
  if (r0 === 0 && r1 === 0) {
    cosines = QuadraticRealPolynomial_default.computeRealRoots(l2, l1, l0);
    if (cosines.length === 0) {
      return solutions;
    }
    const cosine0 = cosines[0];
    const sine0 = Math.sqrt(Math.max(1 - cosine0 * cosine0, 0));
    solutions.push(new Cartesian3_default(x, w * cosine0, w * -sine0));
    solutions.push(new Cartesian3_default(x, w * cosine0, w * sine0));
    if (cosines.length === 2) {
      const cosine1 = cosines[1];
      const sine1 = Math.sqrt(Math.max(1 - cosine1 * cosine1, 0));
      solutions.push(new Cartesian3_default(x, w * cosine1, w * -sine1));
      solutions.push(new Cartesian3_default(x, w * cosine1, w * sine1));
    }
    return solutions;
  }
  const r0Squared = r0 * r0;
  const r1Squared = r1 * r1;
  const l2Squared = l2 * l2;
  const r0r1 = r0 * r1;
  const c42 = l2Squared + r1Squared;
  const c33 = 2 * (l1 * l2 + r0r1);
  const c22 = 2 * l0 * l2 + l1 * l1 - r1Squared + r0Squared;
  const c14 = 2 * (l0 * l1 - r0r1);
  const c0 = l0 * l0 - r0Squared;
  if (c42 === 0 && c33 === 0 && c22 === 0 && c14 === 0) {
    return solutions;
  }
  cosines = QuarticRealPolynomial_default.computeRealRoots(c42, c33, c22, c14, c0);
  const length3 = cosines.length;
  if (length3 === 0) {
    return solutions;
  }
  for (let i = 0; i < length3; ++i) {
    const cosine = cosines[i];
    const cosineSquared = cosine * cosine;
    const sineSquared = Math.max(1 - cosineSquared, 0);
    const sine = Math.sqrt(sineSquared);
    let left;
    if (Math_default.sign(l2) === Math_default.sign(l0)) {
      left = addWithCancellationCheck2(
        l2 * cosineSquared + l0,
        l1 * cosine,
        Math_default.EPSILON12
      );
    } else if (Math_default.sign(l0) === Math_default.sign(l1 * cosine)) {
      left = addWithCancellationCheck2(
        l2 * cosineSquared,
        l1 * cosine + l0,
        Math_default.EPSILON12
      );
    } else {
      left = addWithCancellationCheck2(
        l2 * cosineSquared + l1 * cosine,
        l0,
        Math_default.EPSILON12
      );
    }
    const right = addWithCancellationCheck2(
      r1 * cosine,
      r0,
      Math_default.EPSILON15
    );
    const product = left * right;
    if (product < 0) {
      solutions.push(new Cartesian3_default(x, w * cosine, w * sine));
    } else if (product > 0) {
      solutions.push(new Cartesian3_default(x, w * cosine, w * -sine));
    } else if (sine !== 0) {
      solutions.push(new Cartesian3_default(x, w * cosine, w * -sine));
      solutions.push(new Cartesian3_default(x, w * cosine, w * sine));
      ++i;
    } else {
      solutions.push(new Cartesian3_default(x, w * cosine, w * sine));
    }
  }
  return solutions;
}
var firstAxisScratch = new Cartesian3_default();
var secondAxisScratch = new Cartesian3_default();
var thirdAxisScratch = new Cartesian3_default();
var referenceScratch = new Cartesian3_default();
var bCart = new Cartesian3_default();
var bScratch = new Matrix3_default();
var btScratch = new Matrix3_default();
var diScratch = new Matrix3_default();
var dScratch = new Matrix3_default();
var cScratch = new Matrix3_default();
var tempMatrix = new Matrix3_default();
var aScratch = new Matrix3_default();
var sScratch = new Cartesian3_default();
var closestScratch = new Cartesian3_default();
var surfPointScratch = new Cartographic_default();
IntersectionTests.grazingAltitudeLocation = function(ray, ellipsoid) {
  if (!defined_default(ray)) {
    throw new DeveloperError_default("ray is required.");
  }
  if (!defined_default(ellipsoid)) {
    throw new DeveloperError_default("ellipsoid is required.");
  }
  const position = ray.origin;
  const direction2 = ray.direction;
  if (!Cartesian3_default.equals(position, Cartesian3_default.ZERO)) {
    const normal2 = ellipsoid.geodeticSurfaceNormal(position, firstAxisScratch);
    if (Cartesian3_default.dot(direction2, normal2) >= 0) {
      return position;
    }
  }
  const intersects = defined_default(this.rayEllipsoid(ray, ellipsoid));
  const f = ellipsoid.transformPositionToScaledSpace(
    direction2,
    firstAxisScratch
  );
  const firstAxis = Cartesian3_default.normalize(f, f);
  const reference = Cartesian3_default.mostOrthogonalAxis(f, referenceScratch);
  const secondAxis = Cartesian3_default.normalize(
    Cartesian3_default.cross(reference, firstAxis, secondAxisScratch),
    secondAxisScratch
  );
  const thirdAxis = Cartesian3_default.normalize(
    Cartesian3_default.cross(firstAxis, secondAxis, thirdAxisScratch),
    thirdAxisScratch
  );
  const B = bScratch;
  B[0] = firstAxis.x;
  B[1] = firstAxis.y;
  B[2] = firstAxis.z;
  B[3] = secondAxis.x;
  B[4] = secondAxis.y;
  B[5] = secondAxis.z;
  B[6] = thirdAxis.x;
  B[7] = thirdAxis.y;
  B[8] = thirdAxis.z;
  const B_T = Matrix3_default.transpose(B, btScratch);
  const D_I = Matrix3_default.fromScale(ellipsoid.radii, diScratch);
  const D = Matrix3_default.fromScale(ellipsoid.oneOverRadii, dScratch);
  const C = cScratch;
  C[0] = 0;
  C[1] = -direction2.z;
  C[2] = direction2.y;
  C[3] = direction2.z;
  C[4] = 0;
  C[5] = -direction2.x;
  C[6] = -direction2.y;
  C[7] = direction2.x;
  C[8] = 0;
  const temp = Matrix3_default.multiply(
    Matrix3_default.multiply(B_T, D, tempMatrix),
    C,
    tempMatrix
  );
  const A = Matrix3_default.multiply(
    Matrix3_default.multiply(temp, D_I, aScratch),
    B,
    aScratch
  );
  const b = Matrix3_default.multiplyByVector(temp, position, bCart);
  const solutions = quadraticVectorExpression(
    A,
    Cartesian3_default.negate(b, firstAxisScratch),
    0,
    0,
    1
  );
  let s;
  let altitude;
  const length3 = solutions.length;
  if (length3 > 0) {
    let closest = Cartesian3_default.clone(Cartesian3_default.ZERO, closestScratch);
    let maximumValue = Number.NEGATIVE_INFINITY;
    for (let i = 0; i < length3; ++i) {
      s = Matrix3_default.multiplyByVector(
        D_I,
        Matrix3_default.multiplyByVector(B, solutions[i], sScratch),
        sScratch
      );
      const v7 = Cartesian3_default.normalize(
        Cartesian3_default.subtract(s, position, referenceScratch),
        referenceScratch
      );
      const dotProduct = Cartesian3_default.dot(v7, direction2);
      if (dotProduct > maximumValue) {
        maximumValue = dotProduct;
        closest = Cartesian3_default.clone(s, closest);
      }
    }
    const surfacePoint = ellipsoid.cartesianToCartographic(
      closest,
      surfPointScratch
    );
    maximumValue = Math_default.clamp(maximumValue, 0, 1);
    altitude = Cartesian3_default.magnitude(
      Cartesian3_default.subtract(closest, position, referenceScratch)
    ) * Math.sqrt(1 - maximumValue * maximumValue);
    altitude = intersects ? -altitude : altitude;
    surfacePoint.height = altitude;
    return ellipsoid.cartographicToCartesian(surfacePoint, new Cartesian3_default());
  }
  return void 0;
};
var lineSegmentPlaneDifference = new Cartesian3_default();
IntersectionTests.lineSegmentPlane = function(endPoint0, endPoint1, plane, result) {
  if (!defined_default(endPoint0)) {
    throw new DeveloperError_default("endPoint0 is required.");
  }
  if (!defined_default(endPoint1)) {
    throw new DeveloperError_default("endPoint1 is required.");
  }
  if (!defined_default(plane)) {
    throw new DeveloperError_default("plane is required.");
  }
  if (!defined_default(result)) {
    result = new Cartesian3_default();
  }
  const difference = Cartesian3_default.subtract(
    endPoint1,
    endPoint0,
    lineSegmentPlaneDifference
  );
  const normal2 = plane.normal;
  const nDotDiff = Cartesian3_default.dot(normal2, difference);
  if (Math.abs(nDotDiff) < Math_default.EPSILON6) {
    return void 0;
  }
  const nDotP0 = Cartesian3_default.dot(normal2, endPoint0);
  const t = -(plane.distance + nDotP0) / nDotDiff;
  if (t < 0 || t > 1) {
    return void 0;
  }
  Cartesian3_default.multiplyByScalar(difference, t, result);
  Cartesian3_default.add(endPoint0, result, result);
  return result;
};
IntersectionTests.trianglePlaneIntersection = function(p0, p1, p2, plane) {
  if (!defined_default(p0) || !defined_default(p1) || !defined_default(p2) || !defined_default(plane)) {
    throw new DeveloperError_default("p0, p1, p2, and plane are required.");
  }
  const planeNormal = plane.normal;
  const planeD = plane.distance;
  const p0Behind = Cartesian3_default.dot(planeNormal, p0) + planeD < 0;
  const p1Behind = Cartesian3_default.dot(planeNormal, p1) + planeD < 0;
  const p2Behind = Cartesian3_default.dot(planeNormal, p2) + planeD < 0;
  let numBehind = 0;
  numBehind += p0Behind ? 1 : 0;
  numBehind += p1Behind ? 1 : 0;
  numBehind += p2Behind ? 1 : 0;
  let u12, u22;
  if (numBehind === 1 || numBehind === 2) {
    u12 = new Cartesian3_default();
    u22 = new Cartesian3_default();
  }
  if (numBehind === 1) {
    if (p0Behind) {
      IntersectionTests.lineSegmentPlane(p0, p1, plane, u12);
      IntersectionTests.lineSegmentPlane(p0, p2, plane, u22);
      return {
        positions: [p0, p1, p2, u12, u22],
        indices: [
          0,
          3,
          4,
          1,
          2,
          4,
          1,
          4,
          3
        ]
      };
    } else if (p1Behind) {
      IntersectionTests.lineSegmentPlane(p1, p2, plane, u12);
      IntersectionTests.lineSegmentPlane(p1, p0, plane, u22);
      return {
        positions: [p0, p1, p2, u12, u22],
        indices: [
          1,
          3,
          4,
          2,
          0,
          4,
          2,
          4,
          3
        ]
      };
    } else if (p2Behind) {
      IntersectionTests.lineSegmentPlane(p2, p0, plane, u12);
      IntersectionTests.lineSegmentPlane(p2, p1, plane, u22);
      return {
        positions: [p0, p1, p2, u12, u22],
        indices: [
          2,
          3,
          4,
          0,
          1,
          4,
          0,
          4,
          3
        ]
      };
    }
  } else if (numBehind === 2) {
    if (!p0Behind) {
      IntersectionTests.lineSegmentPlane(p1, p0, plane, u12);
      IntersectionTests.lineSegmentPlane(p2, p0, plane, u22);
      return {
        positions: [p0, p1, p2, u12, u22],
        indices: [
          1,
          2,
          4,
          1,
          4,
          3,
          0,
          3,
          4
        ]
      };
    } else if (!p1Behind) {
      IntersectionTests.lineSegmentPlane(p2, p1, plane, u12);
      IntersectionTests.lineSegmentPlane(p0, p1, plane, u22);
      return {
        positions: [p0, p1, p2, u12, u22],
        indices: [
          2,
          0,
          4,
          2,
          4,
          3,
          1,
          3,
          4
        ]
      };
    } else if (!p2Behind) {
      IntersectionTests.lineSegmentPlane(p0, p2, plane, u12);
      IntersectionTests.lineSegmentPlane(p1, p2, plane, u22);
      return {
        positions: [p0, p1, p2, u12, u22],
        indices: [
          0,
          1,
          4,
          0,
          4,
          3,
          2,
          3,
          4
        ]
      };
    }
  }
  return void 0;
};
var IntersectionTests_default = IntersectionTests;

// Source/Core/Plane.js
function Plane(normal2, distance2) {
  Check_default.typeOf.object("normal", normal2);
  if (!Math_default.equalsEpsilon(
    Cartesian3_default.magnitude(normal2),
    1,
    Math_default.EPSILON6
  )) {
    throw new DeveloperError_default("normal must be normalized.");
  }
  Check_default.typeOf.number("distance", distance2);
  this.normal = Cartesian3_default.clone(normal2);
  this.distance = distance2;
}
Plane.fromPointNormal = function(point, normal2, result) {
  Check_default.typeOf.object("point", point);
  Check_default.typeOf.object("normal", normal2);
  if (!Math_default.equalsEpsilon(
    Cartesian3_default.magnitude(normal2),
    1,
    Math_default.EPSILON6
  )) {
    throw new DeveloperError_default("normal must be normalized.");
  }
  const distance2 = -Cartesian3_default.dot(normal2, point);
  if (!defined_default(result)) {
    return new Plane(normal2, distance2);
  }
  Cartesian3_default.clone(normal2, result.normal);
  result.distance = distance2;
  return result;
};
var scratchNormal = new Cartesian3_default();
Plane.fromCartesian4 = function(coefficients, result) {
  Check_default.typeOf.object("coefficients", coefficients);
  const normal2 = Cartesian3_default.fromCartesian4(coefficients, scratchNormal);
  const distance2 = coefficients.w;
  if (!Math_default.equalsEpsilon(
    Cartesian3_default.magnitude(normal2),
    1,
    Math_default.EPSILON6
  )) {
    throw new DeveloperError_default("normal must be normalized.");
  }
  if (!defined_default(result)) {
    return new Plane(normal2, distance2);
  }
  Cartesian3_default.clone(normal2, result.normal);
  result.distance = distance2;
  return result;
};
Plane.getPointDistance = function(plane, point) {
  Check_default.typeOf.object("plane", plane);
  Check_default.typeOf.object("point", point);
  return Cartesian3_default.dot(plane.normal, point) + plane.distance;
};
var scratchCartesian2 = new Cartesian3_default();
Plane.projectPointOntoPlane = function(plane, point, result) {
  Check_default.typeOf.object("plane", plane);
  Check_default.typeOf.object("point", point);
  if (!defined_default(result)) {
    result = new Cartesian3_default();
  }
  const pointDistance = Plane.getPointDistance(plane, point);
  const scaledNormal = Cartesian3_default.multiplyByScalar(
    plane.normal,
    pointDistance,
    scratchCartesian2
  );
  return Cartesian3_default.subtract(point, scaledNormal, result);
};
var scratchInverseTranspose = new Matrix4_default();
var scratchPlaneCartesian4 = new Cartesian4_default();
var scratchTransformNormal = new Cartesian3_default();
Plane.transform = function(plane, transform3, result) {
  Check_default.typeOf.object("plane", plane);
  Check_default.typeOf.object("transform", transform3);
  const normal2 = plane.normal;
  const distance2 = plane.distance;
  const inverseTranspose2 = Matrix4_default.inverseTranspose(
    transform3,
    scratchInverseTranspose
  );
  let planeAsCartesian4 = Cartesian4_default.fromElements(
    normal2.x,
    normal2.y,
    normal2.z,
    distance2,
    scratchPlaneCartesian4
  );
  planeAsCartesian4 = Matrix4_default.multiplyByVector(
    inverseTranspose2,
    planeAsCartesian4,
    planeAsCartesian4
  );
  const transformedNormal = Cartesian3_default.fromCartesian4(
    planeAsCartesian4,
    scratchTransformNormal
  );
  planeAsCartesian4 = Cartesian4_default.divideByScalar(
    planeAsCartesian4,
    Cartesian3_default.magnitude(transformedNormal),
    planeAsCartesian4
  );
  return Plane.fromCartesian4(planeAsCartesian4, result);
};
Plane.clone = function(plane, result) {
  Check_default.typeOf.object("plane", plane);
  if (!defined_default(result)) {
    return new Plane(plane.normal, plane.distance);
  }
  Cartesian3_default.clone(plane.normal, result.normal);
  result.distance = plane.distance;
  return result;
};
Plane.equals = function(left, right) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  return left.distance === right.distance && Cartesian3_default.equals(left.normal, right.normal);
};
Plane.ORIGIN_XY_PLANE = Object.freeze(new Plane(Cartesian3_default.UNIT_Z, 0));
Plane.ORIGIN_YZ_PLANE = Object.freeze(new Plane(Cartesian3_default.UNIT_X, 0));
Plane.ORIGIN_ZX_PLANE = Object.freeze(new Plane(Cartesian3_default.UNIT_Y, 0));
var Plane_default = Plane;

// Source/Core/binarySearch.js
function binarySearch(array, itemToFind, comparator) {
  Check_default.defined("array", array);
  Check_default.defined("itemToFind", itemToFind);
  Check_default.defined("comparator", comparator);
  let low = 0;
  let high = array.length - 1;
  let i;
  let comparison;
  while (low <= high) {
    i = ~~((low + high) / 2);
    comparison = comparator(array[i], itemToFind);
    if (comparison < 0) {
      low = i + 1;
      continue;
    }
    if (comparison > 0) {
      high = i - 1;
      continue;
    }
    return i;
  }
  return ~(high + 1);
}
var binarySearch_default = binarySearch;

// Source/Core/EarthOrientationParametersSample.js
function EarthOrientationParametersSample(xPoleWander, yPoleWander, xPoleOffset, yPoleOffset, ut1MinusUtc) {
  this.xPoleWander = xPoleWander;
  this.yPoleWander = yPoleWander;
  this.xPoleOffset = xPoleOffset;
  this.yPoleOffset = yPoleOffset;
  this.ut1MinusUtc = ut1MinusUtc;
}
var EarthOrientationParametersSample_default = EarthOrientationParametersSample;

// Source/Core/GregorianDate.js
function GregorianDate(year, month, day, hour, minute, second, millisecond, isLeapSecond) {
  this.year = year;
  this.month = month;
  this.day = day;
  this.hour = hour;
  this.minute = minute;
  this.second = second;
  this.millisecond = millisecond;
  this.isLeapSecond = isLeapSecond;
}
var GregorianDate_default = GregorianDate;

// Source/Core/isLeapYear.js
function isLeapYear(year) {
  if (year === null || isNaN(year)) {
    throw new DeveloperError_default("year is required and must be a number.");
  }
  return year % 4 === 0 && year % 100 !== 0 || year % 400 === 0;
}
var isLeapYear_default = isLeapYear;

// Source/Core/LeapSecond.js
function LeapSecond(date, offset2) {
  this.julianDate = date;
  this.offset = offset2;
}
var LeapSecond_default = LeapSecond;

// Source/Core/TimeConstants.js
var TimeConstants = {
  SECONDS_PER_MILLISECOND: 1e-3,
  SECONDS_PER_MINUTE: 60,
  MINUTES_PER_HOUR: 60,
  HOURS_PER_DAY: 24,
  SECONDS_PER_HOUR: 3600,
  MINUTES_PER_DAY: 1440,
  SECONDS_PER_DAY: 86400,
  DAYS_PER_JULIAN_CENTURY: 36525,
  PICOSECOND: 1e-9,
  MODIFIED_JULIAN_DATE_DIFFERENCE: 24000005e-1
};
var TimeConstants_default = Object.freeze(TimeConstants);

// Source/Core/TimeStandard.js
var TimeStandard = {
  UTC: 0,
  TAI: 1
};
var TimeStandard_default = Object.freeze(TimeStandard);

// Source/Core/JulianDate.js
var gregorianDateScratch = new GregorianDate_default();
var daysInMonth = [31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31];
var daysInLeapFeburary = 29;
function compareLeapSecondDates(leapSecond, dateToFind) {
  return JulianDate.compare(leapSecond.julianDate, dateToFind.julianDate);
}
var binarySearchScratchLeapSecond = new LeapSecond_default();
function convertUtcToTai(julianDate) {
  binarySearchScratchLeapSecond.julianDate = julianDate;
  const leapSeconds = JulianDate.leapSeconds;
  let index = binarySearch_default(
    leapSeconds,
    binarySearchScratchLeapSecond,
    compareLeapSecondDates
  );
  if (index < 0) {
    index = ~index;
  }
  if (index >= leapSeconds.length) {
    index = leapSeconds.length - 1;
  }
  let offset2 = leapSeconds[index].offset;
  if (index > 0) {
    const difference = JulianDate.secondsDifference(
      leapSeconds[index].julianDate,
      julianDate
    );
    if (difference > offset2) {
      index--;
      offset2 = leapSeconds[index].offset;
    }
  }
  JulianDate.addSeconds(julianDate, offset2, julianDate);
}
function convertTaiToUtc(julianDate, result) {
  binarySearchScratchLeapSecond.julianDate = julianDate;
  const leapSeconds = JulianDate.leapSeconds;
  let index = binarySearch_default(
    leapSeconds,
    binarySearchScratchLeapSecond,
    compareLeapSecondDates
  );
  if (index < 0) {
    index = ~index;
  }
  if (index === 0) {
    return JulianDate.addSeconds(julianDate, -leapSeconds[0].offset, result);
  }
  if (index >= leapSeconds.length) {
    return JulianDate.addSeconds(
      julianDate,
      -leapSeconds[index - 1].offset,
      result
    );
  }
  const difference = JulianDate.secondsDifference(
    leapSeconds[index].julianDate,
    julianDate
  );
  if (difference === 0) {
    return JulianDate.addSeconds(
      julianDate,
      -leapSeconds[index].offset,
      result
    );
  }
  if (difference <= 1) {
    return void 0;
  }
  return JulianDate.addSeconds(
    julianDate,
    -leapSeconds[--index].offset,
    result
  );
}
function setComponents(wholeDays, secondsOfDay, julianDate) {
  const extraDays = secondsOfDay / TimeConstants_default.SECONDS_PER_DAY | 0;
  wholeDays += extraDays;
  secondsOfDay -= TimeConstants_default.SECONDS_PER_DAY * extraDays;
  if (secondsOfDay < 0) {
    wholeDays--;
    secondsOfDay += TimeConstants_default.SECONDS_PER_DAY;
  }
  julianDate.dayNumber = wholeDays;
  julianDate.secondsOfDay = secondsOfDay;
  return julianDate;
}
function computeJulianDateComponents(year, month, day, hour, minute, second, millisecond) {
  const a3 = (month - 14) / 12 | 0;
  const b = year + 4800 + a3;
  let dayNumber = (1461 * b / 4 | 0) + (367 * (month - 2 - 12 * a3) / 12 | 0) - (3 * ((b + 100) / 100 | 0) / 4 | 0) + day - 32075;
  hour = hour - 12;
  if (hour < 0) {
    hour += 24;
  }
  const secondsOfDay = second + (hour * TimeConstants_default.SECONDS_PER_HOUR + minute * TimeConstants_default.SECONDS_PER_MINUTE + millisecond * TimeConstants_default.SECONDS_PER_MILLISECOND);
  if (secondsOfDay >= 43200) {
    dayNumber -= 1;
  }
  return [dayNumber, secondsOfDay];
}
var matchCalendarYear = /^(\d{4})$/;
var matchCalendarMonth = /^(\d{4})-(\d{2})$/;
var matchOrdinalDate = /^(\d{4})-?(\d{3})$/;
var matchWeekDate = /^(\d{4})-?W(\d{2})-?(\d{1})?$/;
var matchCalendarDate = /^(\d{4})-?(\d{2})-?(\d{2})$/;
var utcOffset = /([Z+\-])?(\d{2})?:?(\d{2})?$/;
var matchHours = /^(\d{2})(\.\d+)?/.source + utcOffset.source;
var matchHoursMinutes = /^(\d{2}):?(\d{2})(\.\d+)?/.source + utcOffset.source;
var matchHoursMinutesSeconds = /^(\d{2}):?(\d{2}):?(\d{2})(\.\d+)?/.source + utcOffset.source;
var iso8601ErrorMessage = "Invalid ISO 8601 date.";
function JulianDate(julianDayNumber, secondsOfDay, timeStandard) {
  this.dayNumber = void 0;
  this.secondsOfDay = void 0;
  julianDayNumber = defaultValue_default(julianDayNumber, 0);
  secondsOfDay = defaultValue_default(secondsOfDay, 0);
  timeStandard = defaultValue_default(timeStandard, TimeStandard_default.UTC);
  const wholeDays = julianDayNumber | 0;
  secondsOfDay = secondsOfDay + (julianDayNumber - wholeDays) * TimeConstants_default.SECONDS_PER_DAY;
  setComponents(wholeDays, secondsOfDay, this);
  if (timeStandard === TimeStandard_default.UTC) {
    convertUtcToTai(this);
  }
}
JulianDate.fromGregorianDate = function(date, result) {
  if (!(date instanceof GregorianDate_default)) {
    throw new DeveloperError_default("date must be a valid GregorianDate.");
  }
  const components = computeJulianDateComponents(
    date.year,
    date.month,
    date.day,
    date.hour,
    date.minute,
    date.second,
    date.millisecond
  );
  if (!defined_default(result)) {
    return new JulianDate(components[0], components[1], TimeStandard_default.UTC);
  }
  setComponents(components[0], components[1], result);
  convertUtcToTai(result);
  return result;
};
JulianDate.fromDate = function(date, result) {
  if (!(date instanceof Date) || isNaN(date.getTime())) {
    throw new DeveloperError_default("date must be a valid JavaScript Date.");
  }
  const components = computeJulianDateComponents(
    date.getUTCFullYear(),
    date.getUTCMonth() + 1,
    date.getUTCDate(),
    date.getUTCHours(),
    date.getUTCMinutes(),
    date.getUTCSeconds(),
    date.getUTCMilliseconds()
  );
  if (!defined_default(result)) {
    return new JulianDate(components[0], components[1], TimeStandard_default.UTC);
  }
  setComponents(components[0], components[1], result);
  convertUtcToTai(result);
  return result;
};
JulianDate.fromIso8601 = function(iso8601String, result) {
  if (typeof iso8601String !== "string") {
    throw new DeveloperError_default(iso8601ErrorMessage);
  }
  iso8601String = iso8601String.replace(",", ".");
  let tokens = iso8601String.split("T");
  let year;
  let month = 1;
  let day = 1;
  let hour = 0;
  let minute = 0;
  let second = 0;
  let millisecond = 0;
  const date = tokens[0];
  const time = tokens[1];
  let tmp2;
  let inLeapYear;
  if (!defined_default(date)) {
    throw new DeveloperError_default(iso8601ErrorMessage);
  }
  let dashCount;
  tokens = date.match(matchCalendarDate);
  if (tokens !== null) {
    dashCount = date.split("-").length - 1;
    if (dashCount > 0 && dashCount !== 2) {
      throw new DeveloperError_default(iso8601ErrorMessage);
    }
    year = +tokens[1];
    month = +tokens[2];
    day = +tokens[3];
  } else {
    tokens = date.match(matchCalendarMonth);
    if (tokens !== null) {
      year = +tokens[1];
      month = +tokens[2];
    } else {
      tokens = date.match(matchCalendarYear);
      if (tokens !== null) {
        year = +tokens[1];
      } else {
        let dayOfYear;
        tokens = date.match(matchOrdinalDate);
        if (tokens !== null) {
          year = +tokens[1];
          dayOfYear = +tokens[2];
          inLeapYear = isLeapYear_default(year);
          if (dayOfYear < 1 || inLeapYear && dayOfYear > 366 || !inLeapYear && dayOfYear > 365) {
            throw new DeveloperError_default(iso8601ErrorMessage);
          }
        } else {
          tokens = date.match(matchWeekDate);
          if (tokens !== null) {
            year = +tokens[1];
            const weekNumber = +tokens[2];
            const dayOfWeek = +tokens[3] || 0;
            dashCount = date.split("-").length - 1;
            if (dashCount > 0 && (!defined_default(tokens[3]) && dashCount !== 1 || defined_default(tokens[3]) && dashCount !== 2)) {
              throw new DeveloperError_default(iso8601ErrorMessage);
            }
            const january4 = new Date(Date.UTC(year, 0, 4));
            dayOfYear = weekNumber * 7 + dayOfWeek - january4.getUTCDay() - 3;
          } else {
            throw new DeveloperError_default(iso8601ErrorMessage);
          }
        }
        tmp2 = new Date(Date.UTC(year, 0, 1));
        tmp2.setUTCDate(dayOfYear);
        month = tmp2.getUTCMonth() + 1;
        day = tmp2.getUTCDate();
      }
    }
  }
  inLeapYear = isLeapYear_default(year);
  if (month < 1 || month > 12 || day < 1 || (month !== 2 || !inLeapYear) && day > daysInMonth[month - 1] || inLeapYear && month === 2 && day > daysInLeapFeburary) {
    throw new DeveloperError_default(iso8601ErrorMessage);
  }
  let offsetIndex;
  if (defined_default(time)) {
    tokens = time.match(matchHoursMinutesSeconds);
    if (tokens !== null) {
      dashCount = time.split(":").length - 1;
      if (dashCount > 0 && dashCount !== 2 && dashCount !== 3) {
        throw new DeveloperError_default(iso8601ErrorMessage);
      }
      hour = +tokens[1];
      minute = +tokens[2];
      second = +tokens[3];
      millisecond = +(tokens[4] || 0) * 1e3;
      offsetIndex = 5;
    } else {
      tokens = time.match(matchHoursMinutes);
      if (tokens !== null) {
        dashCount = time.split(":").length - 1;
        if (dashCount > 2) {
          throw new DeveloperError_default(iso8601ErrorMessage);
        }
        hour = +tokens[1];
        minute = +tokens[2];
        second = +(tokens[3] || 0) * 60;
        offsetIndex = 4;
      } else {
        tokens = time.match(matchHours);
        if (tokens !== null) {
          hour = +tokens[1];
          minute = +(tokens[2] || 0) * 60;
          offsetIndex = 3;
        } else {
          throw new DeveloperError_default(iso8601ErrorMessage);
        }
      }
    }
    if (minute >= 60 || second >= 61 || hour > 24 || hour === 24 && (minute > 0 || second > 0 || millisecond > 0)) {
      throw new DeveloperError_default(iso8601ErrorMessage);
    }
    const offset2 = tokens[offsetIndex];
    const offsetHours = +tokens[offsetIndex + 1];
    const offsetMinutes = +(tokens[offsetIndex + 2] || 0);
    switch (offset2) {
      case "+":
        hour = hour - offsetHours;
        minute = minute - offsetMinutes;
        break;
      case "-":
        hour = hour + offsetHours;
        minute = minute + offsetMinutes;
        break;
      case "Z":
        break;
      default:
        minute = minute + new Date(
          Date.UTC(year, month - 1, day, hour, minute)
        ).getTimezoneOffset();
        break;
    }
  }
  const isLeapSecond = second === 60;
  if (isLeapSecond) {
    second--;
  }
  while (minute >= 60) {
    minute -= 60;
    hour++;
  }
  while (hour >= 24) {
    hour -= 24;
    day++;
  }
  tmp2 = inLeapYear && month === 2 ? daysInLeapFeburary : daysInMonth[month - 1];
  while (day > tmp2) {
    day -= tmp2;
    month++;
    if (month > 12) {
      month -= 12;
      year++;
    }
    tmp2 = inLeapYear && month === 2 ? daysInLeapFeburary : daysInMonth[month - 1];
  }
  while (minute < 0) {
    minute += 60;
    hour--;
  }
  while (hour < 0) {
    hour += 24;
    day--;
  }
  while (day < 1) {
    month--;
    if (month < 1) {
      month += 12;
      year--;
    }
    tmp2 = inLeapYear && month === 2 ? daysInLeapFeburary : daysInMonth[month - 1];
    day += tmp2;
  }
  const components = computeJulianDateComponents(
    year,
    month,
    day,
    hour,
    minute,
    second,
    millisecond
  );
  if (!defined_default(result)) {
    result = new JulianDate(components[0], components[1], TimeStandard_default.UTC);
  } else {
    setComponents(components[0], components[1], result);
    convertUtcToTai(result);
  }
  if (isLeapSecond) {
    JulianDate.addSeconds(result, 1, result);
  }
  return result;
};
JulianDate.now = function(result) {
  return JulianDate.fromDate(new Date(), result);
};
var toGregorianDateScratch = new JulianDate(0, 0, TimeStandard_default.TAI);
JulianDate.toGregorianDate = function(julianDate, result) {
  if (!defined_default(julianDate)) {
    throw new DeveloperError_default("julianDate is required.");
  }
  let isLeapSecond = false;
  let thisUtc = convertTaiToUtc(julianDate, toGregorianDateScratch);
  if (!defined_default(thisUtc)) {
    JulianDate.addSeconds(julianDate, -1, toGregorianDateScratch);
    thisUtc = convertTaiToUtc(toGregorianDateScratch, toGregorianDateScratch);
    isLeapSecond = true;
  }
  let julianDayNumber = thisUtc.dayNumber;
  const secondsOfDay = thisUtc.secondsOfDay;
  if (secondsOfDay >= 43200) {
    julianDayNumber += 1;
  }
  let L = julianDayNumber + 68569 | 0;
  const N = 4 * L / 146097 | 0;
  L = L - ((146097 * N + 3) / 4 | 0) | 0;
  const I = 4e3 * (L + 1) / 1461001 | 0;
  L = L - (1461 * I / 4 | 0) + 31 | 0;
  const J = 80 * L / 2447 | 0;
  const day = L - (2447 * J / 80 | 0) | 0;
  L = J / 11 | 0;
  const month = J + 2 - 12 * L | 0;
  const year = 100 * (N - 49) + I + L | 0;
  let hour = secondsOfDay / TimeConstants_default.SECONDS_PER_HOUR | 0;
  let remainingSeconds = secondsOfDay - hour * TimeConstants_default.SECONDS_PER_HOUR;
  const minute = remainingSeconds / TimeConstants_default.SECONDS_PER_MINUTE | 0;
  remainingSeconds = remainingSeconds - minute * TimeConstants_default.SECONDS_PER_MINUTE;
  let second = remainingSeconds | 0;
  const millisecond = (remainingSeconds - second) / TimeConstants_default.SECONDS_PER_MILLISECOND;
  hour += 12;
  if (hour > 23) {
    hour -= 24;
  }
  if (isLeapSecond) {
    second += 1;
  }
  if (!defined_default(result)) {
    return new GregorianDate_default(
      year,
      month,
      day,
      hour,
      minute,
      second,
      millisecond,
      isLeapSecond
    );
  }
  result.year = year;
  result.month = month;
  result.day = day;
  result.hour = hour;
  result.minute = minute;
  result.second = second;
  result.millisecond = millisecond;
  result.isLeapSecond = isLeapSecond;
  return result;
};
JulianDate.toDate = function(julianDate) {
  if (!defined_default(julianDate)) {
    throw new DeveloperError_default("julianDate is required.");
  }
  const gDate = JulianDate.toGregorianDate(julianDate, gregorianDateScratch);
  let second = gDate.second;
  if (gDate.isLeapSecond) {
    second -= 1;
  }
  return new Date(
    Date.UTC(
      gDate.year,
      gDate.month - 1,
      gDate.day,
      gDate.hour,
      gDate.minute,
      second,
      gDate.millisecond
    )
  );
};
JulianDate.toIso8601 = function(julianDate, precision) {
  if (!defined_default(julianDate)) {
    throw new DeveloperError_default("julianDate is required.");
  }
  const gDate = JulianDate.toGregorianDate(julianDate, gregorianDateScratch);
  let year = gDate.year;
  let month = gDate.month;
  let day = gDate.day;
  let hour = gDate.hour;
  const minute = gDate.minute;
  const second = gDate.second;
  const millisecond = gDate.millisecond;
  if (year === 1e4 && month === 1 && day === 1 && hour === 0 && minute === 0 && second === 0 && millisecond === 0) {
    year = 9999;
    month = 12;
    day = 31;
    hour = 24;
  }
  let millisecondStr;
  if (!defined_default(precision) && millisecond !== 0) {
    millisecondStr = (millisecond * 0.01).toString().replace(".", "");
    return `${year.toString().padStart(4, "0")}-${month.toString().padStart(2, "0")}-${day.toString().padStart(2, "0")}T${hour.toString().padStart(2, "0")}:${minute.toString().padStart(2, "0")}:${second.toString().padStart(2, "0")}.${millisecondStr}Z`;
  }
  if (!defined_default(precision) || precision === 0) {
    return `${year.toString().padStart(4, "0")}-${month.toString().padStart(2, "0")}-${day.toString().padStart(2, "0")}T${hour.toString().padStart(2, "0")}:${minute.toString().padStart(2, "0")}:${second.toString().padStart(2, "0")}Z`;
  }
  millisecondStr = (millisecond * 0.01).toFixed(precision).replace(".", "").slice(0, precision);
  return `${year.toString().padStart(4, "0")}-${month.toString().padStart(2, "0")}-${day.toString().padStart(2, "0")}T${hour.toString().padStart(2, "0")}:${minute.toString().padStart(2, "0")}:${second.toString().padStart(2, "0")}.${millisecondStr}Z`;
};
JulianDate.clone = function(julianDate, result) {
  if (!defined_default(julianDate)) {
    return void 0;
  }
  if (!defined_default(result)) {
    return new JulianDate(
      julianDate.dayNumber,
      julianDate.secondsOfDay,
      TimeStandard_default.TAI
    );
  }
  result.dayNumber = julianDate.dayNumber;
  result.secondsOfDay = julianDate.secondsOfDay;
  return result;
};
JulianDate.compare = function(left, right) {
  if (!defined_default(left)) {
    throw new DeveloperError_default("left is required.");
  }
  if (!defined_default(right)) {
    throw new DeveloperError_default("right is required.");
  }
  const julianDayNumberDifference = left.dayNumber - right.dayNumber;
  if (julianDayNumberDifference !== 0) {
    return julianDayNumberDifference;
  }
  return left.secondsOfDay - right.secondsOfDay;
};
JulianDate.equals = function(left, right) {
  return left === right || defined_default(left) && defined_default(right) && left.dayNumber === right.dayNumber && left.secondsOfDay === right.secondsOfDay;
};
JulianDate.equalsEpsilon = function(left, right, epsilon) {
  epsilon = defaultValue_default(epsilon, 0);
  return left === right || defined_default(left) && defined_default(right) && Math.abs(JulianDate.secondsDifference(left, right)) <= epsilon;
};
JulianDate.totalDays = function(julianDate) {
  if (!defined_default(julianDate)) {
    throw new DeveloperError_default("julianDate is required.");
  }
  return julianDate.dayNumber + julianDate.secondsOfDay / TimeConstants_default.SECONDS_PER_DAY;
};
JulianDate.secondsDifference = function(left, right) {
  if (!defined_default(left)) {
    throw new DeveloperError_default("left is required.");
  }
  if (!defined_default(right)) {
    throw new DeveloperError_default("right is required.");
  }
  const dayDifference = (left.dayNumber - right.dayNumber) * TimeConstants_default.SECONDS_PER_DAY;
  return dayDifference + (left.secondsOfDay - right.secondsOfDay);
};
JulianDate.daysDifference = function(left, right) {
  if (!defined_default(left)) {
    throw new DeveloperError_default("left is required.");
  }
  if (!defined_default(right)) {
    throw new DeveloperError_default("right is required.");
  }
  const dayDifference = left.dayNumber - right.dayNumber;
  const secondDifference = (left.secondsOfDay - right.secondsOfDay) / TimeConstants_default.SECONDS_PER_DAY;
  return dayDifference + secondDifference;
};
JulianDate.computeTaiMinusUtc = function(julianDate) {
  binarySearchScratchLeapSecond.julianDate = julianDate;
  const leapSeconds = JulianDate.leapSeconds;
  let index = binarySearch_default(
    leapSeconds,
    binarySearchScratchLeapSecond,
    compareLeapSecondDates
  );
  if (index < 0) {
    index = ~index;
    --index;
    if (index < 0) {
      index = 0;
    }
  }
  return leapSeconds[index].offset;
};
JulianDate.addSeconds = function(julianDate, seconds, result) {
  if (!defined_default(julianDate)) {
    throw new DeveloperError_default("julianDate is required.");
  }
  if (!defined_default(seconds)) {
    throw new DeveloperError_default("seconds is required.");
  }
  if (!defined_default(result)) {
    throw new DeveloperError_default("result is required.");
  }
  return setComponents(
    julianDate.dayNumber,
    julianDate.secondsOfDay + seconds,
    result
  );
};
JulianDate.addMinutes = function(julianDate, minutes, result) {
  if (!defined_default(julianDate)) {
    throw new DeveloperError_default("julianDate is required.");
  }
  if (!defined_default(minutes)) {
    throw new DeveloperError_default("minutes is required.");
  }
  if (!defined_default(result)) {
    throw new DeveloperError_default("result is required.");
  }
  const newSecondsOfDay = julianDate.secondsOfDay + minutes * TimeConstants_default.SECONDS_PER_MINUTE;
  return setComponents(julianDate.dayNumber, newSecondsOfDay, result);
};
JulianDate.addHours = function(julianDate, hours, result) {
  if (!defined_default(julianDate)) {
    throw new DeveloperError_default("julianDate is required.");
  }
  if (!defined_default(hours)) {
    throw new DeveloperError_default("hours is required.");
  }
  if (!defined_default(result)) {
    throw new DeveloperError_default("result is required.");
  }
  const newSecondsOfDay = julianDate.secondsOfDay + hours * TimeConstants_default.SECONDS_PER_HOUR;
  return setComponents(julianDate.dayNumber, newSecondsOfDay, result);
};
JulianDate.addDays = function(julianDate, days, result) {
  if (!defined_default(julianDate)) {
    throw new DeveloperError_default("julianDate is required.");
  }
  if (!defined_default(days)) {
    throw new DeveloperError_default("days is required.");
  }
  if (!defined_default(result)) {
    throw new DeveloperError_default("result is required.");
  }
  const newJulianDayNumber = julianDate.dayNumber + days;
  return setComponents(newJulianDayNumber, julianDate.secondsOfDay, result);
};
JulianDate.lessThan = function(left, right) {
  return JulianDate.compare(left, right) < 0;
};
JulianDate.lessThanOrEquals = function(left, right) {
  return JulianDate.compare(left, right) <= 0;
};
JulianDate.greaterThan = function(left, right) {
  return JulianDate.compare(left, right) > 0;
};
JulianDate.greaterThanOrEquals = function(left, right) {
  return JulianDate.compare(left, right) >= 0;
};
JulianDate.prototype.clone = function(result) {
  return JulianDate.clone(this, result);
};
JulianDate.prototype.equals = function(right) {
  return JulianDate.equals(this, right);
};
JulianDate.prototype.equalsEpsilon = function(right, epsilon) {
  return JulianDate.equalsEpsilon(this, right, epsilon);
};
JulianDate.prototype.toString = function() {
  return JulianDate.toIso8601(this);
};
JulianDate.leapSeconds = [
  new LeapSecond_default(new JulianDate(2441317, 43210, TimeStandard_default.TAI), 10),
  new LeapSecond_default(new JulianDate(2441499, 43211, TimeStandard_default.TAI), 11),
  new LeapSecond_default(new JulianDate(2441683, 43212, TimeStandard_default.TAI), 12),
  new LeapSecond_default(new JulianDate(2442048, 43213, TimeStandard_default.TAI), 13),
  new LeapSecond_default(new JulianDate(2442413, 43214, TimeStandard_default.TAI), 14),
  new LeapSecond_default(new JulianDate(2442778, 43215, TimeStandard_default.TAI), 15),
  new LeapSecond_default(new JulianDate(2443144, 43216, TimeStandard_default.TAI), 16),
  new LeapSecond_default(new JulianDate(2443509, 43217, TimeStandard_default.TAI), 17),
  new LeapSecond_default(new JulianDate(2443874, 43218, TimeStandard_default.TAI), 18),
  new LeapSecond_default(new JulianDate(2444239, 43219, TimeStandard_default.TAI), 19),
  new LeapSecond_default(new JulianDate(2444786, 43220, TimeStandard_default.TAI), 20),
  new LeapSecond_default(new JulianDate(2445151, 43221, TimeStandard_default.TAI), 21),
  new LeapSecond_default(new JulianDate(2445516, 43222, TimeStandard_default.TAI), 22),
  new LeapSecond_default(new JulianDate(2446247, 43223, TimeStandard_default.TAI), 23),
  new LeapSecond_default(new JulianDate(2447161, 43224, TimeStandard_default.TAI), 24),
  new LeapSecond_default(new JulianDate(2447892, 43225, TimeStandard_default.TAI), 25),
  new LeapSecond_default(new JulianDate(2448257, 43226, TimeStandard_default.TAI), 26),
  new LeapSecond_default(new JulianDate(2448804, 43227, TimeStandard_default.TAI), 27),
  new LeapSecond_default(new JulianDate(2449169, 43228, TimeStandard_default.TAI), 28),
  new LeapSecond_default(new JulianDate(2449534, 43229, TimeStandard_default.TAI), 29),
  new LeapSecond_default(new JulianDate(2450083, 43230, TimeStandard_default.TAI), 30),
  new LeapSecond_default(new JulianDate(2450630, 43231, TimeStandard_default.TAI), 31),
  new LeapSecond_default(new JulianDate(2451179, 43232, TimeStandard_default.TAI), 32),
  new LeapSecond_default(new JulianDate(2453736, 43233, TimeStandard_default.TAI), 33),
  new LeapSecond_default(new JulianDate(2454832, 43234, TimeStandard_default.TAI), 34),
  new LeapSecond_default(new JulianDate(2456109, 43235, TimeStandard_default.TAI), 35),
  new LeapSecond_default(new JulianDate(2457204, 43236, TimeStandard_default.TAI), 36),
  new LeapSecond_default(new JulianDate(2457754, 43237, TimeStandard_default.TAI), 37)
];
var JulianDate_default = JulianDate;

// Source/Core/EarthOrientationParameters.js
function EarthOrientationParameters(options) {
  options = defaultValue_default(options, defaultValue_default.EMPTY_OBJECT);
  this._dates = void 0;
  this._samples = void 0;
  this._dateColumn = -1;
  this._xPoleWanderRadiansColumn = -1;
  this._yPoleWanderRadiansColumn = -1;
  this._ut1MinusUtcSecondsColumn = -1;
  this._xCelestialPoleOffsetRadiansColumn = -1;
  this._yCelestialPoleOffsetRadiansColumn = -1;
  this._taiMinusUtcSecondsColumn = -1;
  this._columnCount = 0;
  this._lastIndex = -1;
  this._downloadPromise = void 0;
  this._dataError = void 0;
  this._addNewLeapSeconds = defaultValue_default(options.addNewLeapSeconds, true);
  if (defined_default(options.data)) {
    onDataReady(this, options.data);
  } else if (defined_default(options.url)) {
    const resource = Resource_default.createIfNeeded(options.url);
    const that = this;
    this._downloadPromise = resource.fetchJson().then(function(eopData) {
      onDataReady(that, eopData);
    }).catch(function() {
      that._dataError = `An error occurred while retrieving the EOP data from the URL ${resource.url}.`;
    });
  } else {
    onDataReady(this, {
      columnNames: [
        "dateIso8601",
        "modifiedJulianDateUtc",
        "xPoleWanderRadians",
        "yPoleWanderRadians",
        "ut1MinusUtcSeconds",
        "lengthOfDayCorrectionSeconds",
        "xCelestialPoleOffsetRadians",
        "yCelestialPoleOffsetRadians",
        "taiMinusUtcSeconds"
      ],
      samples: []
    });
  }
}
EarthOrientationParameters.NONE = Object.freeze({
  getPromiseToLoad: function() {
    return Promise.resolve();
  },
  compute: function(date, result) {
    if (!defined_default(result)) {
      result = new EarthOrientationParametersSample_default(0, 0, 0, 0, 0);
    } else {
      result.xPoleWander = 0;
      result.yPoleWander = 0;
      result.xPoleOffset = 0;
      result.yPoleOffset = 0;
      result.ut1MinusUtc = 0;
    }
    return result;
  }
});
EarthOrientationParameters.prototype.getPromiseToLoad = function() {
  return Promise.resolve(this._downloadPromise);
};
EarthOrientationParameters.prototype.compute = function(date, result) {
  if (!defined_default(this._samples)) {
    if (defined_default(this._dataError)) {
      throw new RuntimeError_default(this._dataError);
    }
    return void 0;
  }
  if (!defined_default(result)) {
    result = new EarthOrientationParametersSample_default(0, 0, 0, 0, 0);
  }
  if (this._samples.length === 0) {
    result.xPoleWander = 0;
    result.yPoleWander = 0;
    result.xPoleOffset = 0;
    result.yPoleOffset = 0;
    result.ut1MinusUtc = 0;
    return result;
  }
  const dates = this._dates;
  const lastIndex = this._lastIndex;
  let before = 0;
  let after = 0;
  if (defined_default(lastIndex)) {
    const previousIndexDate = dates[lastIndex];
    const nextIndexDate = dates[lastIndex + 1];
    const isAfterPrevious = JulianDate_default.lessThanOrEquals(
      previousIndexDate,
      date
    );
    const isAfterLastSample = !defined_default(nextIndexDate);
    const isBeforeNext = isAfterLastSample || JulianDate_default.greaterThanOrEquals(nextIndexDate, date);
    if (isAfterPrevious && isBeforeNext) {
      before = lastIndex;
      if (!isAfterLastSample && nextIndexDate.equals(date)) {
        ++before;
      }
      after = before + 1;
      interpolate(this, dates, this._samples, date, before, after, result);
      return result;
    }
  }
  let index = binarySearch_default(dates, date, JulianDate_default.compare, this._dateColumn);
  if (index >= 0) {
    if (index < dates.length - 1 && dates[index + 1].equals(date)) {
      ++index;
    }
    before = index;
    after = index;
  } else {
    after = ~index;
    before = after - 1;
    if (before < 0) {
      before = 0;
    }
  }
  this._lastIndex = before;
  interpolate(this, dates, this._samples, date, before, after, result);
  return result;
};
function compareLeapSecondDates2(leapSecond, dateToFind) {
  return JulianDate_default.compare(leapSecond.julianDate, dateToFind);
}
function onDataReady(eop, eopData) {
  if (!defined_default(eopData.columnNames)) {
    eop._dataError = "Error in loaded EOP data: The columnNames property is required.";
    return;
  }
  if (!defined_default(eopData.samples)) {
    eop._dataError = "Error in loaded EOP data: The samples property is required.";
    return;
  }
  const dateColumn = eopData.columnNames.indexOf("modifiedJulianDateUtc");
  const xPoleWanderRadiansColumn = eopData.columnNames.indexOf(
    "xPoleWanderRadians"
  );
  const yPoleWanderRadiansColumn = eopData.columnNames.indexOf(
    "yPoleWanderRadians"
  );
  const ut1MinusUtcSecondsColumn = eopData.columnNames.indexOf(
    "ut1MinusUtcSeconds"
  );
  const xCelestialPoleOffsetRadiansColumn = eopData.columnNames.indexOf(
    "xCelestialPoleOffsetRadians"
  );
  const yCelestialPoleOffsetRadiansColumn = eopData.columnNames.indexOf(
    "yCelestialPoleOffsetRadians"
  );
  const taiMinusUtcSecondsColumn = eopData.columnNames.indexOf(
    "taiMinusUtcSeconds"
  );
  if (dateColumn < 0 || xPoleWanderRadiansColumn < 0 || yPoleWanderRadiansColumn < 0 || ut1MinusUtcSecondsColumn < 0 || xCelestialPoleOffsetRadiansColumn < 0 || yCelestialPoleOffsetRadiansColumn < 0 || taiMinusUtcSecondsColumn < 0) {
    eop._dataError = "Error in loaded EOP data: The columnNames property must include modifiedJulianDateUtc, xPoleWanderRadians, yPoleWanderRadians, ut1MinusUtcSeconds, xCelestialPoleOffsetRadians, yCelestialPoleOffsetRadians, and taiMinusUtcSeconds columns";
    return;
  }
  const samples = eop._samples = eopData.samples;
  const dates = eop._dates = [];
  eop._dateColumn = dateColumn;
  eop._xPoleWanderRadiansColumn = xPoleWanderRadiansColumn;
  eop._yPoleWanderRadiansColumn = yPoleWanderRadiansColumn;
  eop._ut1MinusUtcSecondsColumn = ut1MinusUtcSecondsColumn;
  eop._xCelestialPoleOffsetRadiansColumn = xCelestialPoleOffsetRadiansColumn;
  eop._yCelestialPoleOffsetRadiansColumn = yCelestialPoleOffsetRadiansColumn;
  eop._taiMinusUtcSecondsColumn = taiMinusUtcSecondsColumn;
  eop._columnCount = eopData.columnNames.length;
  eop._lastIndex = void 0;
  let lastTaiMinusUtc;
  const addNewLeapSeconds = eop._addNewLeapSeconds;
  for (let i = 0, len = samples.length; i < len; i += eop._columnCount) {
    const mjd = samples[i + dateColumn];
    const taiMinusUtc = samples[i + taiMinusUtcSecondsColumn];
    const day = mjd + TimeConstants_default.MODIFIED_JULIAN_DATE_DIFFERENCE;
    const date = new JulianDate_default(day, taiMinusUtc, TimeStandard_default.TAI);
    dates.push(date);
    if (addNewLeapSeconds) {
      if (taiMinusUtc !== lastTaiMinusUtc && defined_default(lastTaiMinusUtc)) {
        const leapSeconds = JulianDate_default.leapSeconds;
        const leapSecondIndex = binarySearch_default(
          leapSeconds,
          date,
          compareLeapSecondDates2
        );
        if (leapSecondIndex < 0) {
          const leapSecond = new LeapSecond_default(date, taiMinusUtc);
          leapSeconds.splice(~leapSecondIndex, 0, leapSecond);
        }
      }
      lastTaiMinusUtc = taiMinusUtc;
    }
  }
}
function fillResultFromIndex(eop, samples, index, columnCount, result) {
  const start = index * columnCount;
  result.xPoleWander = samples[start + eop._xPoleWanderRadiansColumn];
  result.yPoleWander = samples[start + eop._yPoleWanderRadiansColumn];
  result.xPoleOffset = samples[start + eop._xCelestialPoleOffsetRadiansColumn];
  result.yPoleOffset = samples[start + eop._yCelestialPoleOffsetRadiansColumn];
  result.ut1MinusUtc = samples[start + eop._ut1MinusUtcSecondsColumn];
}
function linearInterp(dx, y1, y2) {
  return y1 + dx * (y2 - y1);
}
function interpolate(eop, dates, samples, date, before, after, result) {
  const columnCount = eop._columnCount;
  if (after > dates.length - 1) {
    result.xPoleWander = 0;
    result.yPoleWander = 0;
    result.xPoleOffset = 0;
    result.yPoleOffset = 0;
    result.ut1MinusUtc = 0;
    return result;
  }
  const beforeDate = dates[before];
  const afterDate = dates[after];
  if (beforeDate.equals(afterDate) || date.equals(beforeDate)) {
    fillResultFromIndex(eop, samples, before, columnCount, result);
    return result;
  } else if (date.equals(afterDate)) {
    fillResultFromIndex(eop, samples, after, columnCount, result);
    return result;
  }
  const factor2 = JulianDate_default.secondsDifference(date, beforeDate) / JulianDate_default.secondsDifference(afterDate, beforeDate);
  const startBefore = before * columnCount;
  const startAfter = after * columnCount;
  let beforeUt1MinusUtc = samples[startBefore + eop._ut1MinusUtcSecondsColumn];
  let afterUt1MinusUtc = samples[startAfter + eop._ut1MinusUtcSecondsColumn];
  const offsetDifference = afterUt1MinusUtc - beforeUt1MinusUtc;
  if (offsetDifference > 0.5 || offsetDifference < -0.5) {
    const beforeTaiMinusUtc = samples[startBefore + eop._taiMinusUtcSecondsColumn];
    const afterTaiMinusUtc = samples[startAfter + eop._taiMinusUtcSecondsColumn];
    if (beforeTaiMinusUtc !== afterTaiMinusUtc) {
      if (afterDate.equals(date)) {
        beforeUt1MinusUtc = afterUt1MinusUtc;
      } else {
        afterUt1MinusUtc -= afterTaiMinusUtc - beforeTaiMinusUtc;
      }
    }
  }
  result.xPoleWander = linearInterp(
    factor2,
    samples[startBefore + eop._xPoleWanderRadiansColumn],
    samples[startAfter + eop._xPoleWanderRadiansColumn]
  );
  result.yPoleWander = linearInterp(
    factor2,
    samples[startBefore + eop._yPoleWanderRadiansColumn],
    samples[startAfter + eop._yPoleWanderRadiansColumn]
  );
  result.xPoleOffset = linearInterp(
    factor2,
    samples[startBefore + eop._xCelestialPoleOffsetRadiansColumn],
    samples[startAfter + eop._xCelestialPoleOffsetRadiansColumn]
  );
  result.yPoleOffset = linearInterp(
    factor2,
    samples[startBefore + eop._yCelestialPoleOffsetRadiansColumn],
    samples[startAfter + eop._yCelestialPoleOffsetRadiansColumn]
  );
  result.ut1MinusUtc = linearInterp(
    factor2,
    beforeUt1MinusUtc,
    afterUt1MinusUtc
  );
  return result;
}
var EarthOrientationParameters_default = EarthOrientationParameters;

// Source/Core/HeadingPitchRoll.js
function HeadingPitchRoll(heading, pitch, roll) {
  this.heading = defaultValue_default(heading, 0);
  this.pitch = defaultValue_default(pitch, 0);
  this.roll = defaultValue_default(roll, 0);
}
HeadingPitchRoll.fromQuaternion = function(quaternion, result) {
  if (!defined_default(quaternion)) {
    throw new DeveloperError_default("quaternion is required");
  }
  if (!defined_default(result)) {
    result = new HeadingPitchRoll();
  }
  const test = 2 * (quaternion.w * quaternion.y - quaternion.z * quaternion.x);
  const denominatorRoll = 1 - 2 * (quaternion.x * quaternion.x + quaternion.y * quaternion.y);
  const numeratorRoll = 2 * (quaternion.w * quaternion.x + quaternion.y * quaternion.z);
  const denominatorHeading = 1 - 2 * (quaternion.y * quaternion.y + quaternion.z * quaternion.z);
  const numeratorHeading = 2 * (quaternion.w * quaternion.z + quaternion.x * quaternion.y);
  result.heading = -Math.atan2(numeratorHeading, denominatorHeading);
  result.roll = Math.atan2(numeratorRoll, denominatorRoll);
  result.pitch = -Math_default.asinClamped(test);
  return result;
};
HeadingPitchRoll.fromDegrees = function(heading, pitch, roll, result) {
  if (!defined_default(heading)) {
    throw new DeveloperError_default("heading is required");
  }
  if (!defined_default(pitch)) {
    throw new DeveloperError_default("pitch is required");
  }
  if (!defined_default(roll)) {
    throw new DeveloperError_default("roll is required");
  }
  if (!defined_default(result)) {
    result = new HeadingPitchRoll();
  }
  result.heading = heading * Math_default.RADIANS_PER_DEGREE;
  result.pitch = pitch * Math_default.RADIANS_PER_DEGREE;
  result.roll = roll * Math_default.RADIANS_PER_DEGREE;
  return result;
};
HeadingPitchRoll.clone = function(headingPitchRoll, result) {
  if (!defined_default(headingPitchRoll)) {
    return void 0;
  }
  if (!defined_default(result)) {
    return new HeadingPitchRoll(
      headingPitchRoll.heading,
      headingPitchRoll.pitch,
      headingPitchRoll.roll
    );
  }
  result.heading = headingPitchRoll.heading;
  result.pitch = headingPitchRoll.pitch;
  result.roll = headingPitchRoll.roll;
  return result;
};
HeadingPitchRoll.equals = function(left, right) {
  return left === right || defined_default(left) && defined_default(right) && left.heading === right.heading && left.pitch === right.pitch && left.roll === right.roll;
};
HeadingPitchRoll.equalsEpsilon = function(left, right, relativeEpsilon, absoluteEpsilon) {
  return left === right || defined_default(left) && defined_default(right) && Math_default.equalsEpsilon(
    left.heading,
    right.heading,
    relativeEpsilon,
    absoluteEpsilon
  ) && Math_default.equalsEpsilon(
    left.pitch,
    right.pitch,
    relativeEpsilon,
    absoluteEpsilon
  ) && Math_default.equalsEpsilon(
    left.roll,
    right.roll,
    relativeEpsilon,
    absoluteEpsilon
  );
};
HeadingPitchRoll.prototype.clone = function(result) {
  return HeadingPitchRoll.clone(this, result);
};
HeadingPitchRoll.prototype.equals = function(right) {
  return HeadingPitchRoll.equals(this, right);
};
HeadingPitchRoll.prototype.equalsEpsilon = function(right, relativeEpsilon, absoluteEpsilon) {
  return HeadingPitchRoll.equalsEpsilon(
    this,
    right,
    relativeEpsilon,
    absoluteEpsilon
  );
};
HeadingPitchRoll.prototype.toString = function() {
  return `(${this.heading}, ${this.pitch}, ${this.roll})`;
};
var HeadingPitchRoll_default = HeadingPitchRoll;

// Source/Core/Iau2006XysSample.js
function Iau2006XysSample(x, y, s) {
  this.x = x;
  this.y = y;
  this.s = s;
}
var Iau2006XysSample_default = Iau2006XysSample;

// Source/Core/Iau2006XysData.js
function Iau2006XysData(options) {
  options = defaultValue_default(options, defaultValue_default.EMPTY_OBJECT);
  this._xysFileUrlTemplate = Resource_default.createIfNeeded(
    options.xysFileUrlTemplate
  );
  this._interpolationOrder = defaultValue_default(options.interpolationOrder, 9);
  this._sampleZeroJulianEphemerisDate = defaultValue_default(
    options.sampleZeroJulianEphemerisDate,
    24423965e-1
  );
  this._sampleZeroDateTT = new JulianDate_default(
    this._sampleZeroJulianEphemerisDate,
    0,
    TimeStandard_default.TAI
  );
  this._stepSizeDays = defaultValue_default(options.stepSizeDays, 1);
  this._samplesPerXysFile = defaultValue_default(options.samplesPerXysFile, 1e3);
  this._totalSamples = defaultValue_default(options.totalSamples, 27426);
  this._samples = new Array(this._totalSamples * 3);
  this._chunkDownloadsInProgress = [];
  const order = this._interpolationOrder;
  const denom = this._denominators = new Array(order + 1);
  const xTable = this._xTable = new Array(order + 1);
  const stepN = Math.pow(this._stepSizeDays, order);
  for (let i = 0; i <= order; ++i) {
    denom[i] = stepN;
    xTable[i] = i * this._stepSizeDays;
    for (let j = 0; j <= order; ++j) {
      if (j !== i) {
        denom[i] *= i - j;
      }
    }
    denom[i] = 1 / denom[i];
  }
  this._work = new Array(order + 1);
  this._coef = new Array(order + 1);
}
var julianDateScratch = new JulianDate_default(0, 0, TimeStandard_default.TAI);
function getDaysSinceEpoch(xys, dayTT, secondTT) {
  const dateTT2 = julianDateScratch;
  dateTT2.dayNumber = dayTT;
  dateTT2.secondsOfDay = secondTT;
  return JulianDate_default.daysDifference(dateTT2, xys._sampleZeroDateTT);
}
Iau2006XysData.prototype.preload = function(startDayTT, startSecondTT, stopDayTT, stopSecondTT) {
  const startDaysSinceEpoch = getDaysSinceEpoch(
    this,
    startDayTT,
    startSecondTT
  );
  const stopDaysSinceEpoch = getDaysSinceEpoch(this, stopDayTT, stopSecondTT);
  let startIndex = startDaysSinceEpoch / this._stepSizeDays - this._interpolationOrder / 2 | 0;
  if (startIndex < 0) {
    startIndex = 0;
  }
  let stopIndex = stopDaysSinceEpoch / this._stepSizeDays - this._interpolationOrder / 2 | 0 + this._interpolationOrder;
  if (stopIndex >= this._totalSamples) {
    stopIndex = this._totalSamples - 1;
  }
  const startChunk = startIndex / this._samplesPerXysFile | 0;
  const stopChunk = stopIndex / this._samplesPerXysFile | 0;
  const promises = [];
  for (let i = startChunk; i <= stopChunk; ++i) {
    promises.push(requestXysChunk(this, i));
  }
  return Promise.all(promises);
};
Iau2006XysData.prototype.computeXysRadians = function(dayTT, secondTT, result) {
  const daysSinceEpoch = getDaysSinceEpoch(this, dayTT, secondTT);
  if (daysSinceEpoch < 0) {
    return void 0;
  }
  const centerIndex = daysSinceEpoch / this._stepSizeDays | 0;
  if (centerIndex >= this._totalSamples) {
    return void 0;
  }
  const degree = this._interpolationOrder;
  let firstIndex = centerIndex - (degree / 2 | 0);
  if (firstIndex < 0) {
    firstIndex = 0;
  }
  let lastIndex = firstIndex + degree;
  if (lastIndex >= this._totalSamples) {
    lastIndex = this._totalSamples - 1;
    firstIndex = lastIndex - degree;
    if (firstIndex < 0) {
      firstIndex = 0;
    }
  }
  let isDataMissing = false;
  const samples = this._samples;
  if (!defined_default(samples[firstIndex * 3])) {
    requestXysChunk(this, firstIndex / this._samplesPerXysFile | 0);
    isDataMissing = true;
  }
  if (!defined_default(samples[lastIndex * 3])) {
    requestXysChunk(this, lastIndex / this._samplesPerXysFile | 0);
    isDataMissing = true;
  }
  if (isDataMissing) {
    return void 0;
  }
  if (!defined_default(result)) {
    result = new Iau2006XysSample_default(0, 0, 0);
  } else {
    result.x = 0;
    result.y = 0;
    result.s = 0;
  }
  const x = daysSinceEpoch - firstIndex * this._stepSizeDays;
  const work = this._work;
  const denom = this._denominators;
  const coef = this._coef;
  const xTable = this._xTable;
  let i, j;
  for (i = 0; i <= degree; ++i) {
    work[i] = x - xTable[i];
  }
  for (i = 0; i <= degree; ++i) {
    coef[i] = 1;
    for (j = 0; j <= degree; ++j) {
      if (j !== i) {
        coef[i] *= work[j];
      }
    }
    coef[i] *= denom[i];
    let sampleIndex = (firstIndex + i) * 3;
    result.x += coef[i] * samples[sampleIndex++];
    result.y += coef[i] * samples[sampleIndex++];
    result.s += coef[i] * samples[sampleIndex];
  }
  return result;
};
function requestXysChunk(xysData, chunkIndex) {
  if (xysData._chunkDownloadsInProgress[chunkIndex]) {
    return xysData._chunkDownloadsInProgress[chunkIndex];
  }
  let chunkUrl;
  const xysFileUrlTemplate = xysData._xysFileUrlTemplate;
  if (defined_default(xysFileUrlTemplate)) {
    chunkUrl = xysFileUrlTemplate.getDerivedResource({
      templateValues: {
        0: chunkIndex
      }
    });
  } else {
    chunkUrl = new Resource_default({
      url: buildModuleUrl_default(`Assets/IAU2006_XYS/IAU2006_XYS_${chunkIndex}.json`)
    });
  }
  const promise = chunkUrl.fetchJson().then(function(chunk) {
    xysData._chunkDownloadsInProgress[chunkIndex] = false;
    const samples = xysData._samples;
    const newSamples = chunk.samples;
    const startIndex = chunkIndex * xysData._samplesPerXysFile * 3;
    for (let i = 0, len = newSamples.length; i < len; ++i) {
      samples[startIndex + i] = newSamples[i];
    }
  });
  xysData._chunkDownloadsInProgress[chunkIndex] = promise;
  return promise;
}
var Iau2006XysData_default = Iau2006XysData;

// Source/Core/Fullscreen.js
var _supportsFullscreen;
var _names = {
  requestFullscreen: void 0,
  exitFullscreen: void 0,
  fullscreenEnabled: void 0,
  fullscreenElement: void 0,
  fullscreenchange: void 0,
  fullscreenerror: void 0
};
var Fullscreen = {};
Object.defineProperties(Fullscreen, {
  element: {
    get: function() {
      if (!Fullscreen.supportsFullscreen()) {
        return void 0;
      }
      return document[_names.fullscreenElement];
    }
  },
  changeEventName: {
    get: function() {
      if (!Fullscreen.supportsFullscreen()) {
        return void 0;
      }
      return _names.fullscreenchange;
    }
  },
  errorEventName: {
    get: function() {
      if (!Fullscreen.supportsFullscreen()) {
        return void 0;
      }
      return _names.fullscreenerror;
    }
  },
  enabled: {
    get: function() {
      if (!Fullscreen.supportsFullscreen()) {
        return void 0;
      }
      return document[_names.fullscreenEnabled];
    }
  },
  fullscreen: {
    get: function() {
      if (!Fullscreen.supportsFullscreen()) {
        return void 0;
      }
      return Fullscreen.element !== null;
    }
  }
});
Fullscreen.supportsFullscreen = function() {
  if (defined_default(_supportsFullscreen)) {
    return _supportsFullscreen;
  }
  _supportsFullscreen = false;
  const body = document.body;
  if (typeof body.requestFullscreen === "function") {
    _names.requestFullscreen = "requestFullscreen";
    _names.exitFullscreen = "exitFullscreen";
    _names.fullscreenEnabled = "fullscreenEnabled";
    _names.fullscreenElement = "fullscreenElement";
    _names.fullscreenchange = "fullscreenchange";
    _names.fullscreenerror = "fullscreenerror";
    _supportsFullscreen = true;
    return _supportsFullscreen;
  }
  const prefixes = ["webkit", "moz", "o", "ms", "khtml"];
  let name;
  for (let i = 0, len = prefixes.length; i < len; ++i) {
    const prefix = prefixes[i];
    name = `${prefix}RequestFullscreen`;
    if (typeof body[name] === "function") {
      _names.requestFullscreen = name;
      _supportsFullscreen = true;
    } else {
      name = `${prefix}RequestFullScreen`;
      if (typeof body[name] === "function") {
        _names.requestFullscreen = name;
        _supportsFullscreen = true;
      }
    }
    name = `${prefix}ExitFullscreen`;
    if (typeof document[name] === "function") {
      _names.exitFullscreen = name;
    } else {
      name = `${prefix}CancelFullScreen`;
      if (typeof document[name] === "function") {
        _names.exitFullscreen = name;
      }
    }
    name = `${prefix}FullscreenEnabled`;
    if (document[name] !== void 0) {
      _names.fullscreenEnabled = name;
    } else {
      name = `${prefix}FullScreenEnabled`;
      if (document[name] !== void 0) {
        _names.fullscreenEnabled = name;
      }
    }
    name = `${prefix}FullscreenElement`;
    if (document[name] !== void 0) {
      _names.fullscreenElement = name;
    } else {
      name = `${prefix}FullScreenElement`;
      if (document[name] !== void 0) {
        _names.fullscreenElement = name;
      }
    }
    name = `${prefix}fullscreenchange`;
    if (document[`on${name}`] !== void 0) {
      if (prefix === "ms") {
        name = "MSFullscreenChange";
      }
      _names.fullscreenchange = name;
    }
    name = `${prefix}fullscreenerror`;
    if (document[`on${name}`] !== void 0) {
      if (prefix === "ms") {
        name = "MSFullscreenError";
      }
      _names.fullscreenerror = name;
    }
  }
  return _supportsFullscreen;
};
Fullscreen.requestFullscreen = function(element, vrDevice) {
  if (!Fullscreen.supportsFullscreen()) {
    return;
  }
  element[_names.requestFullscreen]({ vrDisplay: vrDevice });
};
Fullscreen.exitFullscreen = function() {
  if (!Fullscreen.supportsFullscreen()) {
    return;
  }
  document[_names.exitFullscreen]();
};
Fullscreen._names = _names;
var Fullscreen_default = Fullscreen;

// Source/Core/FeatureDetection.js
var theNavigator;
if (typeof navigator !== "undefined") {
  theNavigator = navigator;
} else {
  theNavigator = {};
}
function extractVersion(versionString) {
  const parts = versionString.split(".");
  for (let i = 0, len = parts.length; i < len; ++i) {
    parts[i] = parseInt(parts[i], 10);
  }
  return parts;
}
var isChromeResult;
var chromeVersionResult;
function isChrome() {
  if (!defined_default(isChromeResult)) {
    isChromeResult = false;
    if (!isEdge()) {
      const fields = / Chrome\/([\.0-9]+)/.exec(theNavigator.userAgent);
      if (fields !== null) {
        isChromeResult = true;
        chromeVersionResult = extractVersion(fields[1]);
      }
    }
  }
  return isChromeResult;
}
function chromeVersion() {
  return isChrome() && chromeVersionResult;
}
var isSafariResult;
var safariVersionResult;
function isSafari() {
  if (!defined_default(isSafariResult)) {
    isSafariResult = false;
    if (!isChrome() && !isEdge() && / Safari\/[\.0-9]+/.test(theNavigator.userAgent)) {
      const fields = / Version\/([\.0-9]+)/.exec(theNavigator.userAgent);
      if (fields !== null) {
        isSafariResult = true;
        safariVersionResult = extractVersion(fields[1]);
      }
    }
  }
  return isSafariResult;
}
function safariVersion() {
  return isSafari() && safariVersionResult;
}
var isWebkitResult;
var webkitVersionResult;
function isWebkit() {
  if (!defined_default(isWebkitResult)) {
    isWebkitResult = false;
    const fields = / AppleWebKit\/([\.0-9]+)(\+?)/.exec(theNavigator.userAgent);
    if (fields !== null) {
      isWebkitResult = true;
      webkitVersionResult = extractVersion(fields[1]);
      webkitVersionResult.isNightly = !!fields[2];
    }
  }
  return isWebkitResult;
}
function webkitVersion() {
  return isWebkit() && webkitVersionResult;
}
var isInternetExplorerResult;
var internetExplorerVersionResult;
function isInternetExplorer() {
  if (!defined_default(isInternetExplorerResult)) {
    isInternetExplorerResult = false;
    let fields;
    if (theNavigator.appName === "Microsoft Internet Explorer") {
      fields = /MSIE ([0-9]{1,}[\.0-9]{0,})/.exec(theNavigator.userAgent);
      if (fields !== null) {
        isInternetExplorerResult = true;
        internetExplorerVersionResult = extractVersion(fields[1]);
      }
    } else if (theNavigator.appName === "Netscape") {
      fields = /Trident\/.*rv:([0-9]{1,}[\.0-9]{0,})/.exec(
        theNavigator.userAgent
      );
      if (fields !== null) {
        isInternetExplorerResult = true;
        internetExplorerVersionResult = extractVersion(fields[1]);
      }
    }
  }
  return isInternetExplorerResult;
}
function internetExplorerVersion() {
  return isInternetExplorer() && internetExplorerVersionResult;
}
var isEdgeResult;
var edgeVersionResult;
function isEdge() {
  if (!defined_default(isEdgeResult)) {
    isEdgeResult = false;
    const fields = / Edg\/([\.0-9]+)/.exec(theNavigator.userAgent);
    if (fields !== null) {
      isEdgeResult = true;
      edgeVersionResult = extractVersion(fields[1]);
    }
  }
  return isEdgeResult;
}
function edgeVersion() {
  return isEdge() && edgeVersionResult;
}
var isFirefoxResult;
var firefoxVersionResult;
function isFirefox() {
  if (!defined_default(isFirefoxResult)) {
    isFirefoxResult = false;
    const fields = /Firefox\/([\.0-9]+)/.exec(theNavigator.userAgent);
    if (fields !== null) {
      isFirefoxResult = true;
      firefoxVersionResult = extractVersion(fields[1]);
    }
  }
  return isFirefoxResult;
}
var isWindowsResult;
function isWindows() {
  if (!defined_default(isWindowsResult)) {
    isWindowsResult = /Windows/i.test(theNavigator.appVersion);
  }
  return isWindowsResult;
}
var isIPadOrIOSResult;
function isIPadOrIOS() {
  if (!defined_default(isIPadOrIOSResult)) {
    isIPadOrIOSResult = navigator.platform === "iPhone" || navigator.platform === "iPod" || navigator.platform === "iPad";
  }
  return isIPadOrIOSResult;
}
function firefoxVersion() {
  return isFirefox() && firefoxVersionResult;
}
var hasPointerEvents;
function supportsPointerEvents() {
  if (!defined_default(hasPointerEvents)) {
    hasPointerEvents = !isFirefox() && typeof PointerEvent !== "undefined" && (!defined_default(theNavigator.pointerEnabled) || theNavigator.pointerEnabled);
  }
  return hasPointerEvents;
}
var imageRenderingValueResult;
var supportsImageRenderingPixelatedResult;
function supportsImageRenderingPixelated() {
  if (!defined_default(supportsImageRenderingPixelatedResult)) {
    const canvas = document.createElement("canvas");
    canvas.setAttribute(
      "style",
      "image-rendering: -moz-crisp-edges;image-rendering: pixelated;"
    );
    const tmp2 = canvas.style.imageRendering;
    supportsImageRenderingPixelatedResult = defined_default(tmp2) && tmp2 !== "";
    if (supportsImageRenderingPixelatedResult) {
      imageRenderingValueResult = tmp2;
    }
  }
  return supportsImageRenderingPixelatedResult;
}
function imageRenderingValue() {
  return supportsImageRenderingPixelated() ? imageRenderingValueResult : void 0;
}
function supportsWebP() {
  if (!supportsWebP.initialized) {
    throw new DeveloperError_default(
      "You must call FeatureDetection.supportsWebP.initialize and wait for the promise to resolve before calling FeatureDetection.supportsWebP"
    );
  }
  return supportsWebP._result;
}
supportsWebP._promise = void 0;
supportsWebP._result = void 0;
supportsWebP.initialize = function() {
  if (defined_default(supportsWebP._promise)) {
    return supportsWebP._promise;
  }
  supportsWebP._promise = new Promise((resolve2) => {
    const image = new Image();
    image.onload = function() {
      supportsWebP._result = image.width > 0 && image.height > 0;
      resolve2(supportsWebP._result);
    };
    image.onerror = function() {
      supportsWebP._result = false;
      resolve2(supportsWebP._result);
    };
    image.src = "data:image/webp;base64,UklGRiIAAABXRUJQVlA4IBYAAAAwAQCdASoBAAEADsD+JaQAA3AAAAAA";
  });
  return supportsWebP._promise;
};
Object.defineProperties(supportsWebP, {
  initialized: {
    get: function() {
      return defined_default(supportsWebP._result);
    }
  }
});
var typedArrayTypes = [];
if (typeof ArrayBuffer !== "undefined") {
  typedArrayTypes.push(
    Int8Array,
    Uint8Array,
    Int16Array,
    Uint16Array,
    Int32Array,
    Uint32Array,
    Float32Array,
    Float64Array
  );
  if (typeof Uint8ClampedArray !== "undefined") {
    typedArrayTypes.push(Uint8ClampedArray);
  }
  if (typeof Uint8ClampedArray !== "undefined") {
    typedArrayTypes.push(Uint8ClampedArray);
  }
  if (typeof BigInt64Array !== "undefined") {
    typedArrayTypes.push(BigInt64Array);
  }
  if (typeof BigUint64Array !== "undefined") {
    typedArrayTypes.push(BigUint64Array);
  }
}
var FeatureDetection = {
  isChrome,
  chromeVersion,
  isSafari,
  safariVersion,
  isWebkit,
  webkitVersion,
  isInternetExplorer,
  internetExplorerVersion,
  isEdge,
  edgeVersion,
  isFirefox,
  firefoxVersion,
  isWindows,
  isIPadOrIOS,
  hardwareConcurrency: defaultValue_default(theNavigator.hardwareConcurrency, 3),
  supportsPointerEvents,
  supportsImageRenderingPixelated,
  supportsWebP,
  imageRenderingValue,
  typedArrayTypes
};
FeatureDetection.supportsBasis = function(scene) {
  return FeatureDetection.supportsWebAssembly() && scene.context.supportsBasis;
};
FeatureDetection.supportsFullscreen = function() {
  return Fullscreen_default.supportsFullscreen();
};
FeatureDetection.supportsTypedArrays = function() {
  return typeof ArrayBuffer !== "undefined";
};
FeatureDetection.supportsBigInt64Array = function() {
  return typeof BigInt64Array !== "undefined";
};
FeatureDetection.supportsBigUint64Array = function() {
  return typeof BigUint64Array !== "undefined";
};
FeatureDetection.supportsBigInt = function() {
  return typeof BigInt !== "undefined";
};
FeatureDetection.supportsWebWorkers = function() {
  return typeof Worker !== "undefined";
};
FeatureDetection.supportsWebAssembly = function() {
  return typeof WebAssembly !== "undefined";
};
var FeatureDetection_default = FeatureDetection;

// Source/Core/Quaternion.js
function Quaternion(x, y, z, w) {
  this.x = defaultValue_default(x, 0);
  this.y = defaultValue_default(y, 0);
  this.z = defaultValue_default(z, 0);
  this.w = defaultValue_default(w, 0);
}
var fromAxisAngleScratch = new Cartesian3_default();
Quaternion.fromAxisAngle = function(axis, angle, result) {
  Check_default.typeOf.object("axis", axis);
  Check_default.typeOf.number("angle", angle);
  const halfAngle = angle / 2;
  const s = Math.sin(halfAngle);
  fromAxisAngleScratch = Cartesian3_default.normalize(axis, fromAxisAngleScratch);
  const x = fromAxisAngleScratch.x * s;
  const y = fromAxisAngleScratch.y * s;
  const z = fromAxisAngleScratch.z * s;
  const w = Math.cos(halfAngle);
  if (!defined_default(result)) {
    return new Quaternion(x, y, z, w);
  }
  result.x = x;
  result.y = y;
  result.z = z;
  result.w = w;
  return result;
};
var fromRotationMatrixNext = [1, 2, 0];
var fromRotationMatrixQuat = new Array(3);
Quaternion.fromRotationMatrix = function(matrix, result) {
  Check_default.typeOf.object("matrix", matrix);
  let root;
  let x;
  let y;
  let z;
  let w;
  const m00 = matrix[Matrix3_default.COLUMN0ROW0];
  const m11 = matrix[Matrix3_default.COLUMN1ROW1];
  const m22 = matrix[Matrix3_default.COLUMN2ROW2];
  const trace = m00 + m11 + m22;
  if (trace > 0) {
    root = Math.sqrt(trace + 1);
    w = 0.5 * root;
    root = 0.5 / root;
    x = (matrix[Matrix3_default.COLUMN1ROW2] - matrix[Matrix3_default.COLUMN2ROW1]) * root;
    y = (matrix[Matrix3_default.COLUMN2ROW0] - matrix[Matrix3_default.COLUMN0ROW2]) * root;
    z = (matrix[Matrix3_default.COLUMN0ROW1] - matrix[Matrix3_default.COLUMN1ROW0]) * root;
  } else {
    const next = fromRotationMatrixNext;
    let i = 0;
    if (m11 > m00) {
      i = 1;
    }
    if (m22 > m00 && m22 > m11) {
      i = 2;
    }
    const j = next[i];
    const k = next[j];
    root = Math.sqrt(
      matrix[Matrix3_default.getElementIndex(i, i)] - matrix[Matrix3_default.getElementIndex(j, j)] - matrix[Matrix3_default.getElementIndex(k, k)] + 1
    );
    const quat = fromRotationMatrixQuat;
    quat[i] = 0.5 * root;
    root = 0.5 / root;
    w = (matrix[Matrix3_default.getElementIndex(k, j)] - matrix[Matrix3_default.getElementIndex(j, k)]) * root;
    quat[j] = (matrix[Matrix3_default.getElementIndex(j, i)] + matrix[Matrix3_default.getElementIndex(i, j)]) * root;
    quat[k] = (matrix[Matrix3_default.getElementIndex(k, i)] + matrix[Matrix3_default.getElementIndex(i, k)]) * root;
    x = -quat[0];
    y = -quat[1];
    z = -quat[2];
  }
  if (!defined_default(result)) {
    return new Quaternion(x, y, z, w);
  }
  result.x = x;
  result.y = y;
  result.z = z;
  result.w = w;
  return result;
};
var scratchHPRQuaternion = new Quaternion();
var scratchHeadingQuaternion = new Quaternion();
var scratchPitchQuaternion = new Quaternion();
var scratchRollQuaternion = new Quaternion();
Quaternion.fromHeadingPitchRoll = function(headingPitchRoll, result) {
  Check_default.typeOf.object("headingPitchRoll", headingPitchRoll);
  scratchRollQuaternion = Quaternion.fromAxisAngle(
    Cartesian3_default.UNIT_X,
    headingPitchRoll.roll,
    scratchHPRQuaternion
  );
  scratchPitchQuaternion = Quaternion.fromAxisAngle(
    Cartesian3_default.UNIT_Y,
    -headingPitchRoll.pitch,
    result
  );
  result = Quaternion.multiply(
    scratchPitchQuaternion,
    scratchRollQuaternion,
    scratchPitchQuaternion
  );
  scratchHeadingQuaternion = Quaternion.fromAxisAngle(
    Cartesian3_default.UNIT_Z,
    -headingPitchRoll.heading,
    scratchHPRQuaternion
  );
  return Quaternion.multiply(scratchHeadingQuaternion, result, result);
};
var sampledQuaternionAxis = new Cartesian3_default();
var sampledQuaternionRotation = new Cartesian3_default();
var sampledQuaternionTempQuaternion = new Quaternion();
var sampledQuaternionQuaternion0 = new Quaternion();
var sampledQuaternionQuaternion0Conjugate = new Quaternion();
Quaternion.packedLength = 4;
Quaternion.pack = function(value, array, startingIndex) {
  Check_default.typeOf.object("value", value);
  Check_default.defined("array", array);
  startingIndex = defaultValue_default(startingIndex, 0);
  array[startingIndex++] = value.x;
  array[startingIndex++] = value.y;
  array[startingIndex++] = value.z;
  array[startingIndex] = value.w;
  return array;
};
Quaternion.unpack = function(array, startingIndex, result) {
  Check_default.defined("array", array);
  startingIndex = defaultValue_default(startingIndex, 0);
  if (!defined_default(result)) {
    result = new Quaternion();
  }
  result.x = array[startingIndex];
  result.y = array[startingIndex + 1];
  result.z = array[startingIndex + 2];
  result.w = array[startingIndex + 3];
  return result;
};
Quaternion.packedInterpolationLength = 3;
Quaternion.convertPackedArrayForInterpolation = function(packedArray, startingIndex, lastIndex, result) {
  Quaternion.unpack(
    packedArray,
    lastIndex * 4,
    sampledQuaternionQuaternion0Conjugate
  );
  Quaternion.conjugate(
    sampledQuaternionQuaternion0Conjugate,
    sampledQuaternionQuaternion0Conjugate
  );
  for (let i = 0, len = lastIndex - startingIndex + 1; i < len; i++) {
    const offset2 = i * 3;
    Quaternion.unpack(
      packedArray,
      (startingIndex + i) * 4,
      sampledQuaternionTempQuaternion
    );
    Quaternion.multiply(
      sampledQuaternionTempQuaternion,
      sampledQuaternionQuaternion0Conjugate,
      sampledQuaternionTempQuaternion
    );
    if (sampledQuaternionTempQuaternion.w < 0) {
      Quaternion.negate(
        sampledQuaternionTempQuaternion,
        sampledQuaternionTempQuaternion
      );
    }
    Quaternion.computeAxis(
      sampledQuaternionTempQuaternion,
      sampledQuaternionAxis
    );
    const angle = Quaternion.computeAngle(sampledQuaternionTempQuaternion);
    if (!defined_default(result)) {
      result = [];
    }
    result[offset2] = sampledQuaternionAxis.x * angle;
    result[offset2 + 1] = sampledQuaternionAxis.y * angle;
    result[offset2 + 2] = sampledQuaternionAxis.z * angle;
  }
};
Quaternion.unpackInterpolationResult = function(array, sourceArray, firstIndex, lastIndex, result) {
  if (!defined_default(result)) {
    result = new Quaternion();
  }
  Cartesian3_default.fromArray(array, 0, sampledQuaternionRotation);
  const magnitude = Cartesian3_default.magnitude(sampledQuaternionRotation);
  Quaternion.unpack(sourceArray, lastIndex * 4, sampledQuaternionQuaternion0);
  if (magnitude === 0) {
    Quaternion.clone(Quaternion.IDENTITY, sampledQuaternionTempQuaternion);
  } else {
    Quaternion.fromAxisAngle(
      sampledQuaternionRotation,
      magnitude,
      sampledQuaternionTempQuaternion
    );
  }
  return Quaternion.multiply(
    sampledQuaternionTempQuaternion,
    sampledQuaternionQuaternion0,
    result
  );
};
Quaternion.clone = function(quaternion, result) {
  if (!defined_default(quaternion)) {
    return void 0;
  }
  if (!defined_default(result)) {
    return new Quaternion(
      quaternion.x,
      quaternion.y,
      quaternion.z,
      quaternion.w
    );
  }
  result.x = quaternion.x;
  result.y = quaternion.y;
  result.z = quaternion.z;
  result.w = quaternion.w;
  return result;
};
Quaternion.conjugate = function(quaternion, result) {
  Check_default.typeOf.object("quaternion", quaternion);
  Check_default.typeOf.object("result", result);
  result.x = -quaternion.x;
  result.y = -quaternion.y;
  result.z = -quaternion.z;
  result.w = quaternion.w;
  return result;
};
Quaternion.magnitudeSquared = function(quaternion) {
  Check_default.typeOf.object("quaternion", quaternion);
  return quaternion.x * quaternion.x + quaternion.y * quaternion.y + quaternion.z * quaternion.z + quaternion.w * quaternion.w;
};
Quaternion.magnitude = function(quaternion) {
  return Math.sqrt(Quaternion.magnitudeSquared(quaternion));
};
Quaternion.normalize = function(quaternion, result) {
  Check_default.typeOf.object("result", result);
  const inverseMagnitude = 1 / Quaternion.magnitude(quaternion);
  const x = quaternion.x * inverseMagnitude;
  const y = quaternion.y * inverseMagnitude;
  const z = quaternion.z * inverseMagnitude;
  const w = quaternion.w * inverseMagnitude;
  result.x = x;
  result.y = y;
  result.z = z;
  result.w = w;
  return result;
};
Quaternion.inverse = function(quaternion, result) {
  Check_default.typeOf.object("result", result);
  const magnitudeSquared = Quaternion.magnitudeSquared(quaternion);
  result = Quaternion.conjugate(quaternion, result);
  return Quaternion.multiplyByScalar(result, 1 / magnitudeSquared, result);
};
Quaternion.add = function(left, right, result) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Check_default.typeOf.object("result", result);
  result.x = left.x + right.x;
  result.y = left.y + right.y;
  result.z = left.z + right.z;
  result.w = left.w + right.w;
  return result;
};
Quaternion.subtract = function(left, right, result) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Check_default.typeOf.object("result", result);
  result.x = left.x - right.x;
  result.y = left.y - right.y;
  result.z = left.z - right.z;
  result.w = left.w - right.w;
  return result;
};
Quaternion.negate = function(quaternion, result) {
  Check_default.typeOf.object("quaternion", quaternion);
  Check_default.typeOf.object("result", result);
  result.x = -quaternion.x;
  result.y = -quaternion.y;
  result.z = -quaternion.z;
  result.w = -quaternion.w;
  return result;
};
Quaternion.dot = function(left, right) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  return left.x * right.x + left.y * right.y + left.z * right.z + left.w * right.w;
};
Quaternion.multiply = function(left, right, result) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Check_default.typeOf.object("result", result);
  const leftX = left.x;
  const leftY = left.y;
  const leftZ = left.z;
  const leftW = left.w;
  const rightX = right.x;
  const rightY = right.y;
  const rightZ = right.z;
  const rightW = right.w;
  const x = leftW * rightX + leftX * rightW + leftY * rightZ - leftZ * rightY;
  const y = leftW * rightY - leftX * rightZ + leftY * rightW + leftZ * rightX;
  const z = leftW * rightZ + leftX * rightY - leftY * rightX + leftZ * rightW;
  const w = leftW * rightW - leftX * rightX - leftY * rightY - leftZ * rightZ;
  result.x = x;
  result.y = y;
  result.z = z;
  result.w = w;
  return result;
};
Quaternion.multiplyByScalar = function(quaternion, scalar, result) {
  Check_default.typeOf.object("quaternion", quaternion);
  Check_default.typeOf.number("scalar", scalar);
  Check_default.typeOf.object("result", result);
  result.x = quaternion.x * scalar;
  result.y = quaternion.y * scalar;
  result.z = quaternion.z * scalar;
  result.w = quaternion.w * scalar;
  return result;
};
Quaternion.divideByScalar = function(quaternion, scalar, result) {
  Check_default.typeOf.object("quaternion", quaternion);
  Check_default.typeOf.number("scalar", scalar);
  Check_default.typeOf.object("result", result);
  result.x = quaternion.x / scalar;
  result.y = quaternion.y / scalar;
  result.z = quaternion.z / scalar;
  result.w = quaternion.w / scalar;
  return result;
};
Quaternion.computeAxis = function(quaternion, result) {
  Check_default.typeOf.object("quaternion", quaternion);
  Check_default.typeOf.object("result", result);
  const w = quaternion.w;
  if (Math.abs(w - 1) < Math_default.EPSILON6) {
    result.x = result.y = result.z = 0;
    return result;
  }
  const scalar = 1 / Math.sqrt(1 - w * w);
  result.x = quaternion.x * scalar;
  result.y = quaternion.y * scalar;
  result.z = quaternion.z * scalar;
  return result;
};
Quaternion.computeAngle = function(quaternion) {
  Check_default.typeOf.object("quaternion", quaternion);
  if (Math.abs(quaternion.w - 1) < Math_default.EPSILON6) {
    return 0;
  }
  return 2 * Math.acos(quaternion.w);
};
var lerpScratch4 = new Quaternion();
Quaternion.lerp = function(start, end, t, result) {
  Check_default.typeOf.object("start", start);
  Check_default.typeOf.object("end", end);
  Check_default.typeOf.number("t", t);
  Check_default.typeOf.object("result", result);
  lerpScratch4 = Quaternion.multiplyByScalar(end, t, lerpScratch4);
  result = Quaternion.multiplyByScalar(start, 1 - t, result);
  return Quaternion.add(lerpScratch4, result, result);
};
var slerpEndNegated = new Quaternion();
var slerpScaledP = new Quaternion();
var slerpScaledR = new Quaternion();
Quaternion.slerp = function(start, end, t, result) {
  Check_default.typeOf.object("start", start);
  Check_default.typeOf.object("end", end);
  Check_default.typeOf.number("t", t);
  Check_default.typeOf.object("result", result);
  let dot2 = Quaternion.dot(start, end);
  let r = end;
  if (dot2 < 0) {
    dot2 = -dot2;
    r = slerpEndNegated = Quaternion.negate(end, slerpEndNegated);
  }
  if (1 - dot2 < Math_default.EPSILON6) {
    return Quaternion.lerp(start, r, t, result);
  }
  const theta = Math.acos(dot2);
  slerpScaledP = Quaternion.multiplyByScalar(
    start,
    Math.sin((1 - t) * theta),
    slerpScaledP
  );
  slerpScaledR = Quaternion.multiplyByScalar(
    r,
    Math.sin(t * theta),
    slerpScaledR
  );
  result = Quaternion.add(slerpScaledP, slerpScaledR, result);
  return Quaternion.multiplyByScalar(result, 1 / Math.sin(theta), result);
};
Quaternion.log = function(quaternion, result) {
  Check_default.typeOf.object("quaternion", quaternion);
  Check_default.typeOf.object("result", result);
  const theta = Math_default.acosClamped(quaternion.w);
  let thetaOverSinTheta = 0;
  if (theta !== 0) {
    thetaOverSinTheta = theta / Math.sin(theta);
  }
  return Cartesian3_default.multiplyByScalar(quaternion, thetaOverSinTheta, result);
};
Quaternion.exp = function(cartesian11, result) {
  Check_default.typeOf.object("cartesian", cartesian11);
  Check_default.typeOf.object("result", result);
  const theta = Cartesian3_default.magnitude(cartesian11);
  let sinThetaOverTheta = 0;
  if (theta !== 0) {
    sinThetaOverTheta = Math.sin(theta) / theta;
  }
  result.x = cartesian11.x * sinThetaOverTheta;
  result.y = cartesian11.y * sinThetaOverTheta;
  result.z = cartesian11.z * sinThetaOverTheta;
  result.w = Math.cos(theta);
  return result;
};
var squadScratchCartesian0 = new Cartesian3_default();
var squadScratchCartesian1 = new Cartesian3_default();
var squadScratchQuaternion0 = new Quaternion();
var squadScratchQuaternion1 = new Quaternion();
Quaternion.computeInnerQuadrangle = function(q0, q12, q22, result) {
  Check_default.typeOf.object("q0", q0);
  Check_default.typeOf.object("q1", q12);
  Check_default.typeOf.object("q2", q22);
  Check_default.typeOf.object("result", result);
  const qInv = Quaternion.conjugate(q12, squadScratchQuaternion0);
  Quaternion.multiply(qInv, q22, squadScratchQuaternion1);
  const cart0 = Quaternion.log(squadScratchQuaternion1, squadScratchCartesian0);
  Quaternion.multiply(qInv, q0, squadScratchQuaternion1);
  const cart1 = Quaternion.log(squadScratchQuaternion1, squadScratchCartesian1);
  Cartesian3_default.add(cart0, cart1, cart0);
  Cartesian3_default.multiplyByScalar(cart0, 0.25, cart0);
  Cartesian3_default.negate(cart0, cart0);
  Quaternion.exp(cart0, squadScratchQuaternion0);
  return Quaternion.multiply(q12, squadScratchQuaternion0, result);
};
Quaternion.squad = function(q0, q12, s0, s1, t, result) {
  Check_default.typeOf.object("q0", q0);
  Check_default.typeOf.object("q1", q12);
  Check_default.typeOf.object("s0", s0);
  Check_default.typeOf.object("s1", s1);
  Check_default.typeOf.number("t", t);
  Check_default.typeOf.object("result", result);
  const slerp0 = Quaternion.slerp(q0, q12, t, squadScratchQuaternion0);
  const slerp1 = Quaternion.slerp(s0, s1, t, squadScratchQuaternion1);
  return Quaternion.slerp(slerp0, slerp1, 2 * t * (1 - t), result);
};
var fastSlerpScratchQuaternion = new Quaternion();
var opmu = 1.9011074535173003;
var u = FeatureDetection_default.supportsTypedArrays() ? new Float32Array(8) : [];
var v = FeatureDetection_default.supportsTypedArrays() ? new Float32Array(8) : [];
var bT = FeatureDetection_default.supportsTypedArrays() ? new Float32Array(8) : [];
var bD = FeatureDetection_default.supportsTypedArrays() ? new Float32Array(8) : [];
for (let i = 0; i < 7; ++i) {
  const s = i + 1;
  const t = 2 * s + 1;
  u[i] = 1 / (s * t);
  v[i] = s / t;
}
u[7] = opmu / (8 * 17);
v[7] = opmu * 8 / 17;
Quaternion.fastSlerp = function(start, end, t, result) {
  Check_default.typeOf.object("start", start);
  Check_default.typeOf.object("end", end);
  Check_default.typeOf.number("t", t);
  Check_default.typeOf.object("result", result);
  let x = Quaternion.dot(start, end);
  let sign2;
  if (x >= 0) {
    sign2 = 1;
  } else {
    sign2 = -1;
    x = -x;
  }
  const xm1 = x - 1;
  const d = 1 - t;
  const sqrT = t * t;
  const sqrD = d * d;
  for (let i = 7; i >= 0; --i) {
    bT[i] = (u[i] * sqrT - v[i]) * xm1;
    bD[i] = (u[i] * sqrD - v[i]) * xm1;
  }
  const cT = sign2 * t * (1 + bT[0] * (1 + bT[1] * (1 + bT[2] * (1 + bT[3] * (1 + bT[4] * (1 + bT[5] * (1 + bT[6] * (1 + bT[7]))))))));
  const cD = d * (1 + bD[0] * (1 + bD[1] * (1 + bD[2] * (1 + bD[3] * (1 + bD[4] * (1 + bD[5] * (1 + bD[6] * (1 + bD[7]))))))));
  const temp = Quaternion.multiplyByScalar(
    start,
    cD,
    fastSlerpScratchQuaternion
  );
  Quaternion.multiplyByScalar(end, cT, result);
  return Quaternion.add(temp, result, result);
};
Quaternion.fastSquad = function(q0, q12, s0, s1, t, result) {
  Check_default.typeOf.object("q0", q0);
  Check_default.typeOf.object("q1", q12);
  Check_default.typeOf.object("s0", s0);
  Check_default.typeOf.object("s1", s1);
  Check_default.typeOf.number("t", t);
  Check_default.typeOf.object("result", result);
  const slerp0 = Quaternion.fastSlerp(q0, q12, t, squadScratchQuaternion0);
  const slerp1 = Quaternion.fastSlerp(s0, s1, t, squadScratchQuaternion1);
  return Quaternion.fastSlerp(slerp0, slerp1, 2 * t * (1 - t), result);
};
Quaternion.equals = function(left, right) {
  return left === right || defined_default(left) && defined_default(right) && left.x === right.x && left.y === right.y && left.z === right.z && left.w === right.w;
};
Quaternion.equalsEpsilon = function(left, right, epsilon) {
  epsilon = defaultValue_default(epsilon, 0);
  return left === right || defined_default(left) && defined_default(right) && Math.abs(left.x - right.x) <= epsilon && Math.abs(left.y - right.y) <= epsilon && Math.abs(left.z - right.z) <= epsilon && Math.abs(left.w - right.w) <= epsilon;
};
Quaternion.ZERO = Object.freeze(new Quaternion(0, 0, 0, 0));
Quaternion.IDENTITY = Object.freeze(new Quaternion(0, 0, 0, 1));
Quaternion.prototype.clone = function(result) {
  return Quaternion.clone(this, result);
};
Quaternion.prototype.equals = function(right) {
  return Quaternion.equals(this, right);
};
Quaternion.prototype.equalsEpsilon = function(right, epsilon) {
  return Quaternion.equalsEpsilon(this, right, epsilon);
};
Quaternion.prototype.toString = function() {
  return `(${this.x}, ${this.y}, ${this.z}, ${this.w})`;
};
var Quaternion_default = Quaternion;

// Source/Core/Transforms.js
var Transforms = {};
var vectorProductLocalFrame = {
  up: {
    south: "east",
    north: "west",
    west: "south",
    east: "north"
  },
  down: {
    south: "west",
    north: "east",
    west: "north",
    east: "south"
  },
  south: {
    up: "west",
    down: "east",
    west: "down",
    east: "up"
  },
  north: {
    up: "east",
    down: "west",
    west: "up",
    east: "down"
  },
  west: {
    up: "north",
    down: "south",
    north: "down",
    south: "up"
  },
  east: {
    up: "south",
    down: "north",
    north: "up",
    south: "down"
  }
};
var degeneratePositionLocalFrame = {
  north: [-1, 0, 0],
  east: [0, 1, 0],
  up: [0, 0, 1],
  south: [1, 0, 0],
  west: [0, -1, 0],
  down: [0, 0, -1]
};
var localFrameToFixedFrameCache = {};
var scratchCalculateCartesian = {
  east: new Cartesian3_default(),
  north: new Cartesian3_default(),
  up: new Cartesian3_default(),
  west: new Cartesian3_default(),
  south: new Cartesian3_default(),
  down: new Cartesian3_default()
};
var scratchFirstCartesian = new Cartesian3_default();
var scratchSecondCartesian = new Cartesian3_default();
var scratchThirdCartesian = new Cartesian3_default();
Transforms.localFrameToFixedFrameGenerator = function(firstAxis, secondAxis) {
  if (!vectorProductLocalFrame.hasOwnProperty(firstAxis) || !vectorProductLocalFrame[firstAxis].hasOwnProperty(secondAxis)) {
    throw new DeveloperError_default(
      "firstAxis and secondAxis must be east, north, up, west, south or down."
    );
  }
  const thirdAxis = vectorProductLocalFrame[firstAxis][secondAxis];
  let resultat;
  const hashAxis = firstAxis + secondAxis;
  if (defined_default(localFrameToFixedFrameCache[hashAxis])) {
    resultat = localFrameToFixedFrameCache[hashAxis];
  } else {
    resultat = function(origin, ellipsoid, result) {
      if (!defined_default(origin)) {
        throw new DeveloperError_default("origin is required.");
      }
      if (!defined_default(result)) {
        result = new Matrix4_default();
      }
      if (Cartesian3_default.equalsEpsilon(origin, Cartesian3_default.ZERO, Math_default.EPSILON14)) {
        Cartesian3_default.unpack(
          degeneratePositionLocalFrame[firstAxis],
          0,
          scratchFirstCartesian
        );
        Cartesian3_default.unpack(
          degeneratePositionLocalFrame[secondAxis],
          0,
          scratchSecondCartesian
        );
        Cartesian3_default.unpack(
          degeneratePositionLocalFrame[thirdAxis],
          0,
          scratchThirdCartesian
        );
      } else if (Math_default.equalsEpsilon(origin.x, 0, Math_default.EPSILON14) && Math_default.equalsEpsilon(origin.y, 0, Math_default.EPSILON14)) {
        const sign2 = Math_default.sign(origin.z);
        Cartesian3_default.unpack(
          degeneratePositionLocalFrame[firstAxis],
          0,
          scratchFirstCartesian
        );
        if (firstAxis !== "east" && firstAxis !== "west") {
          Cartesian3_default.multiplyByScalar(
            scratchFirstCartesian,
            sign2,
            scratchFirstCartesian
          );
        }
        Cartesian3_default.unpack(
          degeneratePositionLocalFrame[secondAxis],
          0,
          scratchSecondCartesian
        );
        if (secondAxis !== "east" && secondAxis !== "west") {
          Cartesian3_default.multiplyByScalar(
            scratchSecondCartesian,
            sign2,
            scratchSecondCartesian
          );
        }
        Cartesian3_default.unpack(
          degeneratePositionLocalFrame[thirdAxis],
          0,
          scratchThirdCartesian
        );
        if (thirdAxis !== "east" && thirdAxis !== "west") {
          Cartesian3_default.multiplyByScalar(
            scratchThirdCartesian,
            sign2,
            scratchThirdCartesian
          );
        }
      } else {
        ellipsoid = defaultValue_default(ellipsoid, Ellipsoid_default.WGS84);
        ellipsoid.geodeticSurfaceNormal(origin, scratchCalculateCartesian.up);
        const up = scratchCalculateCartesian.up;
        const east = scratchCalculateCartesian.east;
        east.x = -origin.y;
        east.y = origin.x;
        east.z = 0;
        Cartesian3_default.normalize(east, scratchCalculateCartesian.east);
        Cartesian3_default.cross(up, east, scratchCalculateCartesian.north);
        Cartesian3_default.multiplyByScalar(
          scratchCalculateCartesian.up,
          -1,
          scratchCalculateCartesian.down
        );
        Cartesian3_default.multiplyByScalar(
          scratchCalculateCartesian.east,
          -1,
          scratchCalculateCartesian.west
        );
        Cartesian3_default.multiplyByScalar(
          scratchCalculateCartesian.north,
          -1,
          scratchCalculateCartesian.south
        );
        scratchFirstCartesian = scratchCalculateCartesian[firstAxis];
        scratchSecondCartesian = scratchCalculateCartesian[secondAxis];
        scratchThirdCartesian = scratchCalculateCartesian[thirdAxis];
      }
      result[0] = scratchFirstCartesian.x;
      result[1] = scratchFirstCartesian.y;
      result[2] = scratchFirstCartesian.z;
      result[3] = 0;
      result[4] = scratchSecondCartesian.x;
      result[5] = scratchSecondCartesian.y;
      result[6] = scratchSecondCartesian.z;
      result[7] = 0;
      result[8] = scratchThirdCartesian.x;
      result[9] = scratchThirdCartesian.y;
      result[10] = scratchThirdCartesian.z;
      result[11] = 0;
      result[12] = origin.x;
      result[13] = origin.y;
      result[14] = origin.z;
      result[15] = 1;
      return result;
    };
    localFrameToFixedFrameCache[hashAxis] = resultat;
  }
  return resultat;
};
Transforms.eastNorthUpToFixedFrame = Transforms.localFrameToFixedFrameGenerator(
  "east",
  "north"
);
Transforms.northEastDownToFixedFrame = Transforms.localFrameToFixedFrameGenerator(
  "north",
  "east"
);
Transforms.northUpEastToFixedFrame = Transforms.localFrameToFixedFrameGenerator(
  "north",
  "up"
);
Transforms.northWestUpToFixedFrame = Transforms.localFrameToFixedFrameGenerator(
  "north",
  "west"
);
var scratchHPRQuaternion2 = new Quaternion_default();
var scratchScale = new Cartesian3_default(1, 1, 1);
var scratchHPRMatrix4 = new Matrix4_default();
Transforms.headingPitchRollToFixedFrame = function(origin, headingPitchRoll, ellipsoid, fixedFrameTransform, result) {
  Check_default.typeOf.object("HeadingPitchRoll", headingPitchRoll);
  fixedFrameTransform = defaultValue_default(
    fixedFrameTransform,
    Transforms.eastNorthUpToFixedFrame
  );
  const hprQuaternion = Quaternion_default.fromHeadingPitchRoll(
    headingPitchRoll,
    scratchHPRQuaternion2
  );
  const hprMatrix = Matrix4_default.fromTranslationQuaternionRotationScale(
    Cartesian3_default.ZERO,
    hprQuaternion,
    scratchScale,
    scratchHPRMatrix4
  );
  result = fixedFrameTransform(origin, ellipsoid, result);
  return Matrix4_default.multiply(result, hprMatrix, result);
};
var scratchENUMatrix4 = new Matrix4_default();
var scratchHPRMatrix3 = new Matrix3_default();
Transforms.headingPitchRollQuaternion = function(origin, headingPitchRoll, ellipsoid, fixedFrameTransform, result) {
  Check_default.typeOf.object("HeadingPitchRoll", headingPitchRoll);
  const transform3 = Transforms.headingPitchRollToFixedFrame(
    origin,
    headingPitchRoll,
    ellipsoid,
    fixedFrameTransform,
    scratchENUMatrix4
  );
  const rotation = Matrix4_default.getMatrix3(transform3, scratchHPRMatrix3);
  return Quaternion_default.fromRotationMatrix(rotation, result);
};
var noScale = new Cartesian3_default(1, 1, 1);
var hprCenterScratch = new Cartesian3_default();
var ffScratch = new Matrix4_default();
var hprTransformScratch = new Matrix4_default();
var hprRotationScratch = new Matrix3_default();
var hprQuaternionScratch = new Quaternion_default();
Transforms.fixedFrameToHeadingPitchRoll = function(transform3, ellipsoid, fixedFrameTransform, result) {
  Check_default.defined("transform", transform3);
  ellipsoid = defaultValue_default(ellipsoid, Ellipsoid_default.WGS84);
  fixedFrameTransform = defaultValue_default(
    fixedFrameTransform,
    Transforms.eastNorthUpToFixedFrame
  );
  if (!defined_default(result)) {
    result = new HeadingPitchRoll_default();
  }
  const center = Matrix4_default.getTranslation(transform3, hprCenterScratch);
  if (Cartesian3_default.equals(center, Cartesian3_default.ZERO)) {
    result.heading = 0;
    result.pitch = 0;
    result.roll = 0;
    return result;
  }
  let toFixedFrame = Matrix4_default.inverseTransformation(
    fixedFrameTransform(center, ellipsoid, ffScratch),
    ffScratch
  );
  let transformCopy = Matrix4_default.setScale(transform3, noScale, hprTransformScratch);
  transformCopy = Matrix4_default.setTranslation(
    transformCopy,
    Cartesian3_default.ZERO,
    transformCopy
  );
  toFixedFrame = Matrix4_default.multiply(toFixedFrame, transformCopy, toFixedFrame);
  let quaternionRotation = Quaternion_default.fromRotationMatrix(
    Matrix4_default.getMatrix3(toFixedFrame, hprRotationScratch),
    hprQuaternionScratch
  );
  quaternionRotation = Quaternion_default.normalize(
    quaternionRotation,
    quaternionRotation
  );
  return HeadingPitchRoll_default.fromQuaternion(quaternionRotation, result);
};
var gmstConstant0 = 6 * 3600 + 41 * 60 + 50.54841;
var gmstConstant1 = 8640184812866e-6;
var gmstConstant2 = 0.093104;
var gmstConstant3 = -62e-7;
var rateCoef = 11772758384668e-32;
var wgs84WRPrecessing = 72921158553e-15;
var twoPiOverSecondsInDay = Math_default.TWO_PI / 86400;
var dateInUtc = new JulianDate_default();
Transforms.computeTemeToPseudoFixedMatrix = function(date, result) {
  if (!defined_default(date)) {
    throw new DeveloperError_default("date is required.");
  }
  dateInUtc = JulianDate_default.addSeconds(
    date,
    -JulianDate_default.computeTaiMinusUtc(date),
    dateInUtc
  );
  const utcDayNumber = dateInUtc.dayNumber;
  const utcSecondsIntoDay = dateInUtc.secondsOfDay;
  let t;
  const diffDays = utcDayNumber - 2451545;
  if (utcSecondsIntoDay >= 43200) {
    t = (diffDays + 0.5) / TimeConstants_default.DAYS_PER_JULIAN_CENTURY;
  } else {
    t = (diffDays - 0.5) / TimeConstants_default.DAYS_PER_JULIAN_CENTURY;
  }
  const gmst0 = gmstConstant0 + t * (gmstConstant1 + t * (gmstConstant2 + t * gmstConstant3));
  const angle = gmst0 * twoPiOverSecondsInDay % Math_default.TWO_PI;
  const ratio = wgs84WRPrecessing + rateCoef * (utcDayNumber - 24515455e-1);
  const secondsSinceMidnight = (utcSecondsIntoDay + TimeConstants_default.SECONDS_PER_DAY * 0.