/**
 * Enums.
 */

///////////////////////////////////////////////////
// KTX2 Header.
///////////////////////////////////////////////////

export enum KTX2SupercompressionScheme {
	NONE = 0,
	BASISLZ = 1,
	ZSTD = 2,
	ZLIB = 3,
};


///////////////////////////////////////////////////
// Data Format Descriptor (DFD).
///////////////////////////////////////////////////

export enum KTX2DescriptorType {
	BASICFORMAT = 0x00,
};

export enum KTX2Model {
	UNSPECIFIED = 0,
	ETC1S = 163,
	UASTC = 166,
};

export enum KTX2Primaries {
	UNSPECIFIED = 0,
	SRGB = 1,
};

export enum KTX2Transfer {
	UNSPECIFIED = 0,
	LINEAR = 1,
	SRGB = 2,
	ITU = 3,
	NTSC = 4,
	SLOG = 5,
	SLOG2 = 6,
};

export enum KTX2Flags {
	ALPHA_STRAIGHT = 0,
	ALPHA_PREMULTIPLIED = 1,
};

export enum KTX2ChannelETC1S {
	RGB = 0,
	RRR = 3,
	GGG = 4,
	AAA = 15,
};

export enum KTX2ChannelUASTC {
	RGB = 0,
	RGBA = 3,
	RRR = 4,
	RRRG = 5,
};
