/**
 * @license
 * Cesium - https://github.com/CesiumGS/cesium
 * Version 1.97
 *
 * Copyright 2011-2022 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/CesiumGS/cesium/blob/main/LICENSE.md for full licensing details.
 */
define(["./arrayRemoveDuplicates-7ccf3114","./BoundingRectangle-0ced9455","./Transforms-0c3fa360","./Matrix2-276d97d2","./ComponentDatatype-7f6d9570","./CoplanarPolygonGeometryLibrary-070cbd9e","./defaultValue-a6eb9f34","./GeometryAttribute-54019f82","./GeometryAttributes-aff51037","./GeometryInstance-52eaddec","./GeometryPipeline-f46d7519","./IndexDatatype-856d3a0c","./PolygonGeometryLibrary-5f5d3c91","./PolygonPipeline-1667c4fc","./VertexFormat-31cdbccc","./_commonjsHelpers-89c9b271","./combine-7cf28d88","./RuntimeError-07496d94","./WebGLConstants-d81b330d","./OrientedBoundingBox-60b83ce5","./EllipsoidTangentPlane-30c83574","./AxisAlignedBoundingBox-646dc833","./IntersectionTests-fbcff83c","./Plane-17fe9d66","./AttributeCompression-28a6d524","./EncodedCartesian3-32c625e4","./ArcType-b714639b","./EllipsoidRhumbLine-f1dbc710"],(function(e,t,n,o,r,a,i,s,l,c,y,p,d,u,m,g,f,b,C,h,x,P,A,L,w,G,F,v){"use strict";const E=new o.Cartesian3,_=new t.BoundingRectangle,T=new o.Cartesian2,k=new o.Cartesian2,D=new o.Cartesian3,V=new o.Cartesian3,R=new o.Cartesian3,H=new o.Cartesian3,I=new o.Cartesian3,M=new o.Cartesian3,B=new n.Quaternion,O=new o.Matrix3,z=new o.Matrix3,S=new o.Cartesian3;function N(e,t,a,c,y,d,m,g,f){const b=e.positions;let C=u.PolygonPipeline.triangulate(e.positions2D,e.holes);C.length<3&&(C=[0,1,2]);const h=p.IndexDatatype.createTypedArray(b.length,C.length);h.set(C);let x=O;if(0!==c){let e=n.Quaternion.fromAxisAngle(m,c,B);if(x=o.Matrix3.fromQuaternion(e,x),t.tangent||t.bitangent){e=n.Quaternion.fromAxisAngle(m,-c,B);const r=o.Matrix3.fromQuaternion(e,z);g=o.Cartesian3.normalize(o.Matrix3.multiplyByVector(r,g,g),g),t.bitangent&&(f=o.Cartesian3.normalize(o.Cartesian3.cross(m,g,f),f))}}else x=o.Matrix3.clone(o.Matrix3.IDENTITY,x);const P=k;t.st&&(P.x=a.x,P.y=a.y);const A=b.length,L=3*A,w=new Float64Array(L),G=t.normal?new Float32Array(L):void 0,F=t.tangent?new Float32Array(L):void 0,v=t.bitangent?new Float32Array(L):void 0,_=t.st?new Float32Array(2*A):void 0;let D=0,V=0,R=0,H=0,I=0;for(let e=0;e<A;e++){const n=b[e];if(w[D++]=n.x,w[D++]=n.y,w[D++]=n.z,t.st)if(i.defined(y)&&y.positions.length===A)_[I++]=y.positions[e].x,_[I++]=y.positions[e].y;else{const e=d(o.Matrix3.multiplyByVector(x,n,E),T);o.Cartesian2.subtract(e,P,e);const t=r.CesiumMath.clamp(e.x/a.width,0,1),i=r.CesiumMath.clamp(e.y/a.height,0,1);_[I++]=t,_[I++]=i}t.normal&&(G[V++]=m.x,G[V++]=m.y,G[V++]=m.z),t.tangent&&(F[H++]=g.x,F[H++]=g.y,F[H++]=g.z),t.bitangent&&(v[R++]=f.x,v[R++]=f.y,v[R++]=f.z)}const M=new l.GeometryAttributes;return t.position&&(M.position=new s.GeometryAttribute({componentDatatype:r.ComponentDatatype.DOUBLE,componentsPerAttribute:3,values:w})),t.normal&&(M.normal=new s.GeometryAttribute({componentDatatype:r.ComponentDatatype.FLOAT,componentsPerAttribute:3,values:G})),t.tangent&&(M.tangent=new s.GeometryAttribute({componentDatatype:r.ComponentDatatype.FLOAT,componentsPerAttribute:3,values:F})),t.bitangent&&(M.bitangent=new s.GeometryAttribute({componentDatatype:r.ComponentDatatype.FLOAT,componentsPerAttribute:3,values:v})),t.st&&(M.st=new s.GeometryAttribute({componentDatatype:r.ComponentDatatype.FLOAT,componentsPerAttribute:2,values:_})),new s.Geometry({attributes:M,indices:h,primitiveType:s.PrimitiveType.TRIANGLES})}function Q(e){const t=(e=i.defaultValue(e,i.defaultValue.EMPTY_OBJECT)).polygonHierarchy,n=e.textureCoordinates,r=i.defaultValue(e.vertexFormat,m.VertexFormat.DEFAULT);this._vertexFormat=m.VertexFormat.clone(r),this._polygonHierarchy=t,this._stRotation=i.defaultValue(e.stRotation,0),this._ellipsoid=o.Ellipsoid.clone(i.defaultValue(e.ellipsoid,o.Ellipsoid.WGS84)),this._workerName="createCoplanarPolygonGeometry",this._textureCoordinates=n,this.packedLength=d.PolygonGeometryLibrary.computeHierarchyPackedLength(t,o.Cartesian3)+m.VertexFormat.packedLength+o.Ellipsoid.packedLength+(i.defined(n)?d.PolygonGeometryLibrary.computeHierarchyPackedLength(n,o.Cartesian2):1)+2}Q.fromPositions=function(e){return new Q({polygonHierarchy:{positions:(e=i.defaultValue(e,i.defaultValue.EMPTY_OBJECT)).positions},vertexFormat:e.vertexFormat,stRotation:e.stRotation,ellipsoid:e.ellipsoid,textureCoordinates:e.textureCoordinates})},Q.pack=function(e,t,n){return n=i.defaultValue(n,0),n=d.PolygonGeometryLibrary.packPolygonHierarchy(e._polygonHierarchy,t,n,o.Cartesian3),o.Ellipsoid.pack(e._ellipsoid,t,n),n+=o.Ellipsoid.packedLength,m.VertexFormat.pack(e._vertexFormat,t,n),n+=m.VertexFormat.packedLength,t[n++]=e._stRotation,i.defined(e._textureCoordinates)?n=d.PolygonGeometryLibrary.packPolygonHierarchy(e._textureCoordinates,t,n,o.Cartesian2):t[n++]=-1,t[n++]=e.packedLength,t};const j=o.Ellipsoid.clone(o.Ellipsoid.UNIT_SPHERE),U=new m.VertexFormat,Y={polygonHierarchy:{}};return Q.unpack=function(e,t,n){t=i.defaultValue(t,0);const r=d.PolygonGeometryLibrary.unpackPolygonHierarchy(e,t,o.Cartesian3);t=r.startingIndex,delete r.startingIndex;const a=o.Ellipsoid.unpack(e,t,j);t+=o.Ellipsoid.packedLength;const s=m.VertexFormat.unpack(e,t,U);t+=m.VertexFormat.packedLength;const l=e[t++],c=-1===e[t]?void 0:d.PolygonGeometryLibrary.unpackPolygonHierarchy(e,t,o.Cartesian2);i.defined(c)?(t=c.startingIndex,delete c.startingIndex):t++;const y=e[t++];return i.defined(n)||(n=new Q(Y)),n._polygonHierarchy=r,n._ellipsoid=o.Ellipsoid.clone(a,n._ellipsoid),n._vertexFormat=m.VertexFormat.clone(s,n._vertexFormat),n._stRotation=l,n._textureCoordinates=c,n.packedLength=y,n},Q.createGeometry=function(t){const l=t._vertexFormat,u=t._polygonHierarchy,m=t._stRotation,g=t._textureCoordinates,f=i.defined(g);let b=u.positions;if(b=e.arrayRemoveDuplicates(b,o.Cartesian3.equalsEpsilon,!0),b.length<3)return;let C=D,h=V,x=R,P=I;const A=M;if(!a.CoplanarPolygonGeometryLibrary.computeProjectTo2DArguments(b,H,P,A))return;if(C=o.Cartesian3.cross(P,A,C),C=o.Cartesian3.normalize(C,C),!o.Cartesian3.equalsEpsilon(H,o.Cartesian3.ZERO,r.CesiumMath.EPSILON6)){const e=t._ellipsoid.geodeticSurfaceNormal(H,S);o.Cartesian3.dot(C,e)<0&&(C=o.Cartesian3.negate(C,C),P=o.Cartesian3.negate(P,P))}const L=a.CoplanarPolygonGeometryLibrary.createProjectPointsTo2DFunction(H,P,A),w=a.CoplanarPolygonGeometryLibrary.createProjectPointTo2DFunction(H,P,A);l.tangent&&(h=o.Cartesian3.clone(P,h)),l.bitangent&&(x=o.Cartesian3.clone(A,x));const G=d.PolygonGeometryLibrary.polygonsFromHierarchy(u,f,L,!1),F=G.hierarchy,v=G.polygons,E=f?d.PolygonGeometryLibrary.polygonsFromHierarchy(g,!0,(function(e){return e}),!1).polygons:void 0;if(0===F.length)return;b=F[0].outerRing;const T=n.BoundingSphere.fromPoints(b),k=d.PolygonGeometryLibrary.computeBoundingRectangle(C,w,b,m,_),B=[];for(let e=0;e<v.length;e++){const t=new c.GeometryInstance({geometry:N(v[e],l,k,m,f?E[e]:void 0,w,C,h,x)});B.push(t)}const O=y.GeometryPipeline.combineInstances(B)[0];O.attributes.position.values=new Float64Array(O.attributes.position.values),O.indices=p.IndexDatatype.createTypedArray(O.attributes.position.values.length/3,O.indices);const z=O.attributes;return l.position||delete z.position,new s.Geometry({attributes:z,indices:O.indices,primitiveType:O.primitiveType,boundingSphere:T})},function(e,t){return i.defined(t)&&(e=Q.unpack(e,t)),Q.createGeometry(e)}}));
