/**
 * First we will load all of this project's JavaScript dependencies which
 * includes Vue and other libraries. It is a great starting point when
 * building robust, powerful web applications using Vue and Laravel.
 */

import './bootstrap';
import { createApp } from 'vue';
import '../css/app.css'; 
import idleTimer from './idleTimer';
import { swalWarning } from './swal';
import '@public/Cesium/Widgets/widgets.css'
import Cookies from 'js-cookie';
import VuePrint from 'vue3-print-nb';
import {
    ariaToAttrs,
    getTabindexByRole,
    Live,
    useLive,
    FocusTrap,
    genId,
    useTravel,
    useHotkey,
    useGlobalHotkey,
} from "vue-a11y-utils";
import { useAuthStore } from './stores/authStore';
// import 'cesium/Build/Cesium/Widgets/widgets.css';
/**
 * Next, we will create a fresh Vue application instance. You may then begin
 * registering components with the application instance so they are ready
 * to use in your application's views. An example is included for you.
 */

const app = createApp({});

app.component('Live', Live);
app.directive('focus-trap', FocusTrap);
app.directive('aria', ariaToAttrs);
app.config.globalProperties.$a11y = {
    getTabindexByRole,
    useLive,
    genId,
    useTravel,
    useHotkey,
    useGlobalHotkey
};

import sweetAlert from 'vue-sweetalert2';
import 'sweetalert2/dist/sweetalert2.min.css';
app.use(sweetAlert);

app.config.globalProperties.$chembee = 'sets/sm/csm';
import Router from '@/router'
app.use(Router)

app.use(VuePrint)


import Mains from './pages/main.vue'
app.component('Mains', Mains);

import { createPinia } from 'pinia';
const pinia = createPinia()
app.use(pinia);

// const authStore = useAuthStore()
// await authStore.fetchUser()

app.use(idleTimer, {
    maxInactivity: 120 * 60 * 1000, // 設置最大閒置時間為 120 分鐘
    onTimeout: () => {
      // 這裡處理登出的操作
      const cookies = Cookies.get();
      for (const cookie in cookies) {
          Cookies.remove(cookie);
      }
      sessionStorage.clear();
        swalWarning('閒置超過2小時，已自動登出');
    },
    })
/**
 * The following block of code may be used to automatically register your
 * Vue components. It will recursively scan this directory for the Vue
 * components and automatically register them with their "basename".
 *
 * Eg. ./components/ExampleComponent.vue -> <example-component></example-component>
 */

// Object.entries(import.meta.glob('./**/*.vue', { eager: true })).forEach(([path, definition]) => {
//     app.component(path.split('/').pop().replace(/\.\w+$/, ''), definition.default);
// });

/**
 * Finally, we will attach the application instance to a HTML element with
 * an "id" attribute of "app". This element is included with the "auth"
 * scaffolding. Otherwise, you will need to add an element yourself.
 */

app.mount('#app');
