export default {
    data() {
        return {
            currentPage: 1,
            perPage: 10,
            hasdata: false,
        }
    },
    computed: {
        totalPages() {
            const filteredData = this.filteredData;
            this.hasdata = filteredData.length > 0;
            return Math.ceil(filteredData.length / this.perPage);
        },
        paginatedData() {
            const start = (this.currentPage - 1) * this.perPage;
            const end = start + this.perPage;
            return this.filteredData.slice(start, end);
        }
    },
    methods: {
        handlePageChange(page) {
            this.currentPage = page;
        }
    }
} 