import CryptoJS from "crypto-js";

function encryptData(data){
    const secretKey = import.meta.env.VITE_APP_SECRET_KEY;
    return CryptoJS.AES.encrypt(JSON.stringify(data),secretKey).toString();
}

function decryptData(encrypted){
    const secretKey = import.meta.env.VITE_APP_SECRET_KEY;
    const decoded = decodeURIComponent(encrypted);
    const bytes = CryptoJS.AES.decrypt(decoded, secretKey);
    return bytes.toString(CryptoJS.enc.Utf8);
    

}

function getEncryptedRouteData(data,routeName){
    const encryptedData = encryptData(data);
    const encoded = encodeURIComponent(encryptedData);

    return {
        name:routeName,
        params:{
            encrypted:encoded,
        }
    }
}




export { encryptData, decryptData, getEncryptedRouteData };
