// idleTimer.js
export default {
    install(Vue, options = {}) {
        const maxInactivity = options.maxInactivity || 120 * 60 * 1000; // 預設 120 分鐘
        let timeout;

        const resetTimer = () => {
            clearTimeout(timeout);
            timeout = setTimeout(() => {
                if (typeof options.onTimeout === "function") {
                    options.onTimeout();
                }
            }, maxInactivity);
        };

        const setupListeners = () => {
            document.addEventListener("mousemove", resetTimer);
            document.addEventListener("keypress", resetTimer);
            document.addEventListener("click", resetTimer);
            document.addEventListener("scroll", resetTimer);
        };

        const removeListeners = () => {
            document.removeEventListener("mousemove", resetTimer);
            document.removeEventListener("keypress", resetTimer);
            document.removeEventListener("click", resetTimer);
            document.removeEventListener("scroll", resetTimer);
        };

        Vue.mixin({
            mounted() {
                setupListeners();
                resetTimer();
            },
            beforeDestroy() {
                clearTimeout(timeout);
                removeListeners();
            },
        });
    },
};
