export default {
    data() {
        return {
            activeSortKey: '',
            sortOrder: 'asc'
        }
    },
    methods: {
        sortBy({ key, order }) {
            this.activeSortKey = key;
            this.sortOrder = order;
        },
        getNestedValue(obj, path) {
            return path.split('.').reduce((acc, key) => (acc ? acc[key] : undefined), obj);
        },
        sortData(data) {
            if (!this.activeSortKey) return data;
            
            return [...data].sort((a, b) => {
                let aValue = this.getNestedValue(a, this.activeSortKey);
                let bValue = this.getNestedValue(b, this.activeSortKey);

                if (this.activeSortKey === 'index') {
                    aValue = data.indexOf(a);
                    bValue = data.indexOf(b);
                    return this.sortOrder === 'asc' ? aValue - bValue : bValue - aValue;
                }

                if (typeof aValue === 'string' && typeof bValue === 'string') {
                    aValue = aValue.toLowerCase();
                    bValue = bValue.toLowerCase();
                }

                if (aValue < bValue) return this.sortOrder === 'asc' ? -1 : 1;
                if (aValue > bValue) return this.sortOrder === 'asc' ? 1 : -1;
                return 0;
            });
        }
    }
} 