import { createRouter, createWebHistory, createWebHashHistory } from "vue-router";
const Dashboard = () => import("./components/Dashboards.vue");
const AdminChemicalBase = () => import("./pages/AdminChemical/AdminChemicalBase.vue");
const ChemicalCU = () => import("./pages/AdminChemical/ChemicalCU.vue");
const ReviewCU = () => import("./pages/AdminChemical/ReviewCU.vue");
const UserChemicalBase = () => import("./pages/UserChemical/UserChemicalBase.vue");
const UserNewCU = () => import("./pages/UserChemical/UserNewCU.vue");
const UserCU = () => import("./pages/UserChemical/UserCU.vue");
const FactoryCU = () => import("./pages/Factory/FactoryCU.vue");
const Factory = () => import("./pages/Factory/Factory.vue");
const Fixed = () => import("./pages/Fixed.vue");
const UserSubBase = () => import("./pages/UserChemical/UserSubBase.vue");
const UserDecantBase = () => import("./pages/UserChemical/UserDecantBase.vue");
const UserTransferBase = () => import("./pages/UserChemical/UserTransferBase.vue");
const UserDisposalBase = () => import("./pages/UserChemical/UserDisposalBase.vue");
const UserShiftOutBase = () => import("./pages/UserChemical/UserShiftOutBase.vue");
const UserResidualBase = () => import("./pages/UserChemical/UserResidualBase.vue");
const UserNewBase = () => import("./pages/UserChemical/UserNewBase.vue");
const ReportBase = () => import("./pages/Report/ReportBase.vue");
const ReportChem = () => import("./pages/Report/ReportChem.vue");
const MoenvBase = () => import("./pages/Declare/MoenvBase.vue");
const IdaBase = () => import("./pages/Declare/IdaBase.vue");
const IdaDeclare = () => import("./pages/Declare/IdaDeclare.vue");
const OshaBase = () => import("./pages/Declare/OshaBase.vue");
const UserExportBase = () => import("./pages/UserChemical/UserExportBase.vue");
const UserSellBase = () => import("./pages/UserChemical/UserSellBase.vue");
const ApprovalDoc = () => import("./pages/Factory/ApprovalDoc.vue");
const ApprovalDocCU = () => import("./pages/Factory/ApprovalDocCU.vue");
const CtoBase = () => import("./pages/Declare/CtoBase.vue");
const DeclareChem = () => import("./pages/Declare/DeclareChem.vue");
const SupplierToxicCU = () => import("./pages/Supplier/SupplierToxicCU.vue");
const SupplierToxic = () => import("./pages/Supplier/SupplierToxic.vue");
const CtoDanger = ()=> import("./pages/Declare/CtoDanger.vue");
const toxicStatistics = ()=>import("./pages/Statistics/toxicStatistics.vue")
import { useAuthStore } from './stores/authStore';
// const threeD = () => import("./pages/ThreeD/threeD.vue");
const threeDtest = () => import("./pages/ThreeDtest/threeD.vue");

const ASSET_URL = import.meta.env.VITE_APP_ASSET_URL;
const routes = [
    {
        path: `${ASSET_URL}/dashboard`,
        meta: { breadcrumb: "Summary" },
        name: "Dashboard",
        component: Dashboard,
    },
    {
        path: `${ASSET_URL}/Factory`,
        meta: { breadcrumb: "廠區管理" },
        name: "Factory",
        component: Factory,
    },
    {
        path: `${ASSET_URL}/Factory`,
        meta: { breadcrumb: "廠區管理" },
        children: [
            {
                path: "FactoryCU",
                meta: { breadcrumb: "基本資料新增" },
                name: "FactoryAdd",
                component: FactoryCU,
            },
            {
                path: "FactoryCU/:encrypted",
                meta: { breadcrumb: "廠區管理" },
                name: "FactoryCU",
                component: FactoryCU,
            },
        ],
    },
    {
        path: `${ASSET_URL}/ApprovalDoc`,
        meta: { breadcrumb: "核可文件管理" },
        name: "ApprovalDoc",
        component: ApprovalDoc,
    },
    {
        path: `${ASSET_URL}/ApprovalDoc`,
        meta: { breadcrumb: "核可文件管理" },
        children: [
            {
                path: "ApprovalDocCU",
                meta: { breadcrumb: "核可文件新增" },
                name: "ApprovalAdd",
                component: ApprovalDocCU
            },
            {
                path: "ApprovalDocCU/:encrypted",
                meta: { breadcrumb: "核可文件編輯" },
                name: "ApprovalDocCU",
                component: ApprovalDocCU
            }
        ],
    },
    {
        path: `${ASSET_URL}/UserNewBase`,
        meta: { breadcrumb: "新增化學品" },
        name: "UserNewBase",
        component: UserNewBase,
    },
    {
        path: `${ASSET_URL}/UserNewBase`,
        meta: { breadcrumb: "新增化學品" },
        children: [
            {
                path: "UserNewCU",
                meta: { breadcrumb: "新增訂單" },
                name: "UserNewCU-add",
                component: UserNewCU,
            },
            {
                path: "UserNewCU/:encrypted",
                meta: { breadcrumb: "化學品資料" },
                name: "UserNewCU",
                component: UserNewCU,
            },
        ],
    },
    {
        path: `${ASSET_URL}/UserSubBase`,
        meta: { breadcrumb: "化學品使用" },
        name: "UserSubBase",
        component: UserSubBase,
    },
    {
        path: `${ASSET_URL}/UserDecantBase`,
        meta: { breadcrumb: "化學品分裝" },
        name: "UserDecantBase",
        component: UserDecantBase,
    },
    {
        path: `${ASSET_URL}/UserTransferBase`,
        meta: { breadcrumb: "化學品調撥" },
        name: "UserTransferBase",
        component: UserTransferBase,
    },
    {
        path: `${ASSET_URL}/UserShiftOutBase`,
        meta: { breadcrumb: "化學品轉出" },
        name: "UserShiftOutBase",
        component: UserShiftOutBase,
    },
    {
        path: `${ASSET_URL}/UserExportBase`,
        meta: { breadcrumb: "化學品輸出" },
        name: "UserExportBase",
        component: UserExportBase,
    },
    {
        path: `${ASSET_URL}/UserSellBase`,
        meta: { breadcrumb: "化學品賣出" },
        name: "UserSellBase",
        component: UserSellBase,
    },
    {
        path: `${ASSET_URL}/UserDisposalBase`,
        meta: { breadcrumb: "化學品廢棄" },
        name: "UserDisposalBase",
        component: UserDisposalBase,
    },
    {
        path: `${ASSET_URL}/UserResidualBase`,
        meta: { breadcrumb: "殘氣退回" },
        name: "UserResidualBase",
        component: UserResidualBase,
    },
    {
        path: `${ASSET_URL}/UserChemicalBase`,
        meta: { breadcrumb: "化學品基本檔" },
        name: "UserChemicalBase",
        component: UserChemicalBase,
    },
    {
        path: `${ASSET_URL}/UserChemicalBase`,
        meta: { breadcrumb: "化學品基本檔" },
        children: [
            {
                path: "UserCU",
                meta: { breadcrumb: "化學品基本資料檔申請" },
                name: "UserCU-add",
                component: UserCU,
            },
            {
                path: "UserCU/:encrypted",
                meta: { breadcrumb: "化學品申請資料" },
                name: "UserCU",
                component: UserCU,
            },
        ],
    },
    {
        path: `${ASSET_URL}/ReportBase`,
        meta: { breadcrumb: "報表區", keepAlive: true },
        name: "ReportBase",
        component: ReportBase,
    },
    {
        path: `${ASSET_URL}/ReportBase`,
        meta: { breadcrumb: "報表區", keepAlive: true },
        children: [
            {
                path: "ReportChem",
                meta: { breadcrumb: "", keepAlive: true },
                name: "ReportChem",
                component: ReportChem,
            },
            {
                path: "ReportChem/:encrypted",
                meta: { breadcrumb: "", keepAlive: true },
                name: "ReportChem",
                component: ReportChem,
                props: (route) => ({ encrypted: route.params.encrypted }),
            },
        ],
    },
    {
        path: `${ASSET_URL}/MoenvBase`,
        meta: { breadcrumb: "環境部化學署", keepAlive: true },
        name: "MoenvBase",
        component: MoenvBase,
    },
    {
        path: `${ASSET_URL}/MoenvBase`,
        meta: { breadcrumb: "環境部化學署", keepAlive: true },
        children: [
            {
                path: "DeclareChem",
                meta: { breadcrumb: "", keepAlive: true },
                name: "DeclareChem",
                component: DeclareChem,
            },
            {
                path: "DeclareChem/:encrypted",
                meta: { breadcrumb: "", keepAlive: true },
                name: "DeclareChem",
                component: DeclareChem,
                props: (route) => ({ encrypted: route.params.encrypted }),
            },
        ],
    },
    {
        path: `${ASSET_URL}/OshaBase`,
        meta: { breadcrumb: "勞動部職安署", keepAlive: true },
        name: "OshaBase",
        component: OshaBase,
    },
    {
        path: `${ASSET_URL}/CtoBase`,
        meta: { breadcrumb: "經濟部工商輔導中心", keepAlive: true },
        name: "CtoBase",
        component: CtoBase,
    },
    {
        path: `${ASSET_URL}/CtoBase`,
        meta: { breadcrumb: "經濟部工商輔導中心", keepAlive: true },
        children:[
            {
                path: "CtoDanger",
                meta: { breadcrumb: "", keepAlive: true },
                name: "CtoDanger",
                component: CtoDanger,
            },
            {
                path: "CtoDanger/:encrypted",
                meta: { breadcrumb: "", keepAlive: true },
                name: "CtoDanger",
                component: CtoDanger,
                props: (route) => ({ encrypted: route.params.encrypted }),
            },
        ]
    },
    {
        path: `${ASSET_URL}/IdaBase`,
        meta: { breadcrumb: "經濟部產業發展署", keepAlive: true },
        name: "IdaBase",
        component: IdaBase,
    },
    {
        path: `${ASSET_URL}/IdaBase`,
        meta: { breadcrumb: "經濟部產業發展署", keepAlive: true },
        children: [
            {
                path: "IdaDeclare",
                meta: { breadcrumb: "", keepAlive: true },
                name: "IdaDeclare",
                component: IdaDeclare,
            },
            {
                path: "IdaDeclare/:encrypted",
                meta: { breadcrumb: "", keepAlive: true },
                name: "IdaDeclare",
                component: IdaDeclare,
                props: (route) => ({ encrypted: route.params.encrypted }),
            },
        ],
    },
    {
        path: `${ASSET_URL}/SupplierToxic`,
        meta: { breadcrumb: "上下游廠商" },
        name: "SupplierToxic",
        component: SupplierToxic,
    },
    {
        path: `${ASSET_URL}/SupplierToxic`,
        meta: { breadcrumb: "上下游廠商" },
        children: [
            {
                path: "SupplierToxicCU",
                meta: { breadcrumb: "上下游廠商新增" },
                name: "SupplierToxicCU-add",
                component: SupplierToxicCU,
            },
            {
                path: "SupplierToxicCU/:encrypted",
                meta: { breadcrumb: "上下游廠商資料" },
                name: "SupplierToxicCU",
                component: SupplierToxicCU,
            },
        ],
    },
    {
        path: `${ASSET_URL}/Fixed`,
        meta: { breadcrumb: "網站建置中" },
        name: "Fixed",
        component: Fixed,
    },
    {
        path: `${ASSET_URL}/toxicStatistics`,
        meta: { breadcrumb: "統計資料" },
        name: "toxicStatistics",
        component: toxicStatistics,
    },
    // {
    //     path: `${ASSET_URL}/threeD`,
    //     meta: { breadcrumb: "3D" },
    //     name: "threeD",
    //     component: threeD,
    // },    
    {
        path: `${ASSET_URL}/threeDtest`,
        meta: { breadcrumb: "3D" },
        name: "threeDtest",
        component: threeDtest,
    },
    {
        path: `${ASSET_URL}/AdminChemicalBase`,
        meta: {
            breadcrumb: "化學品基本資料",
            requiresAdmin: true
        },
        name: "AdminChemicalBase",
        component: AdminChemicalBase,
    },
    {
        path: `${ASSET_URL}/AdminChemicalBase`,
        meta: { breadcrumb: "化學品基本檔" },
        children: [
            {
                path: "chemicalCU",
                component: ChemicalCU,
                name: "chemicalCU-add",
                meta: { breadcrumb: "化學品基本資料檔新增" },
            },
            {
                path: "chemicalCU/:encrypted",
                meta: { breadcrumb: "化學品資料" },
                name: "chemicalCU",
                component: ChemicalCU,
            },
            {
                path: `${ASSET_URL}/ReviewCU/:encrypted`,
                name: "ReviewCU",
                meta: { breadcrumb: "化學品基本資料檔申請審核" },
                component: ReviewCU,
            },
        ],
    },
];
const router = createRouter({
    history: createWebHistory(),
    routes,
});

router.beforeEach(async (to, from, next) => {
    const authStore = useAuthStore();
    
    // 檢查是否需要認證
    if (to.meta.requiresAuth) {
        // 嘗試獲取用戶信息
        if (!authStore.isAuthenticated) {
            try {
                await authStore.fetchUser();
            } catch (error) {
                // 如果獲取用戶信息失敗，重定向到登錄頁面
                next({ path: '/' });
                return;
            }
        }
        
        // 如果仍然未認證，重定向到登錄頁面
        if (!authStore.isAuthenticated) {
            next({ path: '/' });
            return;
        }
    }

    // 確保用戶信息已加載
    if (!authStore.user) {
        try {
            await authStore.fetchUser();
        } catch (error) {
            console.error('Error fetching user:', error);
        }
    }

    
    // 設置緩存控制頭
    document.addEventListener('DOMContentLoaded', () => {
        // 禁用瀏覽器緩存
        window.history.pushState(null, '', window.location.href);
        window.history.replaceState(null, '', window.location.href);
    });
    
    next();
});

export default router;
