import { defineStore } from 'pinia';
import axios from 'axios';
import Cookies from 'js-cookie';

export const useAuthStore = defineStore('auth', {
    state: () => ({
        user: null,
        isAuthenticated: false,
        isLoading: false
    }),

    getters: {
        isAdmin: (state) => state.user?.role === 'admin',
        userRole: (state) => state.user?.role
    },

    actions: {
        async fetchUser() {
            this.isLoading = true;
            try {
                const response = await axios.get(`/${import.meta.env.VITE_APP_API_URL}/api/getuser`, {
                    withCredentials: true,
                });

                this.user = response.data;
                this.isAuthenticated = true;

                if (this.user?.role) {
                    Cookies.set('userRole', this.user.role, { expires: 7 });
                }

                return this.user;
            } catch (error) {
                console.error('Error fetching user:', error);
                this.user = null;
                this.isAuthenticated = false;
                return null;
            } finally {
                this.isLoading = false;
            }
        },

        logoutUser() {
            this.user = null;
            this.isAuthenticated = false;
            Cookies.remove('userRole');
        }
    }
});