

import Swal from 'sweetalert2';

export function swalConfirmation(title = "確定要執行此操作嗎?", confirmText = "是", cancelText = "取消") {
    return Swal.fire({
        title: title,
        icon: "warning",
        showCancelButton: true,
        confirmButtonColor: '#4a62ae',
        confirmButtonText: confirmText,
        cancelButtonColor: '#ff5151',
        cancelButtonText: cancelText,
        reverseButtons: true,
        customClass: {
            confirmButton: 'w-24', // Tailwind 設定寬度
            cancelButton: 'w-24',
            icon:'w-32 h-32'
        }
    });
}

export function swalSuccess(title='成功',text='操作成功') {
    Swal.fire({
        title: title,
        text: text,
        icon: "success",
        timer: 800,
        showConfirmButton: false,
    });
}

export function swalWarning(message) {
    Swal.fire({
        title: '警告',
        html: message.replace(/\n/g, '<br>') || '發生錯誤',
        icon: 'warning',
        confirmButtonText: '確定',
        showCancelButton: false,
    }).then((result) => {
        if (result.isConfirmed) { 
            window.location.href = '/'; 
        }
    });
}

export function swalError(message, details) {
    Swal.fire({
        title: '錯誤',
        html: message.replace(/\n/g, '<br>') || '發生錯誤',
        icon: 'error',
        confirmButtonText: '確定',
        showCancelButton: false,
    }).then(() => {
        if (details) {
            console.error(details);  
        }
    });
}


export function handleHttpError(error) {
    if (error.response) {
        const status = error.response.status;
        const message = error.response.data.message || '伺服器錯誤';
        switch (status) {
            case 400:
                swalError(message);
                break;
            case 403:
                swalError(message);
                break;
            case 404:
                swalError(message);
                break;
            case 500:
                swalError(message);
                break;
            case 422:
                swalError(message);
                break;
            default:
                swalError(message);
                break;
        }
    } else if (error.request) {
        // 如果未收到回應，顯示網路錯誤
        swalError('未收到回應', '請檢查網路連接');
    } else {
        // 其他錯誤
        swalError('發生錯誤', error.message);
    }
}
