<?php

use App\Http\Controllers\ApprovalDocController;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\ChemicalBaseController;
use App\Http\Controllers\ChemicalDecantController;
use App\Http\Controllers\ChemicalDisposalController;
use App\Http\Controllers\ChemicalExportController;
use App\Http\Controllers\ChemicalReportController;
use App\Http\Controllers\ChemicalResidualController;
use App\Http\Controllers\ChemicalReviewController;
use App\Http\Controllers\ChemicalSellController;
use App\Http\Controllers\ChemicalShiftOutController;
use App\Http\Controllers\ChemicalSubController;
use App\Http\Controllers\ChemicalTransferController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\DeclareController;
use App\Http\Controllers\FactoryController;
use App\Http\Controllers\GetUserController;
use App\Http\Controllers\SdsBaseController;
use App\Http\Controllers\SdsReviewController;
use App\Http\Controllers\StatisticsController;
use App\Http\Controllers\SupplierController;
use App\Http\Controllers\UserNewChemController;
use App\Http\Middleware\VerifyCsrfToken;
use App\Models\ChemicalReview;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

// Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
//     return $request->user();
// });

Route::post('/register',[AuthController::class,'register']);

Route::middleware(['web','auth'])->group(function () {
    //使用者資料，認證
    Route::get('/getuser',[GetUserController::class,'getUser']); 
    Route::post('/logout',[AuthController::class,'logout']);
    Route::post('/parseToken',[AuthController::class,'parseToken']);

    //取得儀錶板
    Route::get('/moenvCount',[DashboardController::class,'moenvCount']);
    //取得公司全部操作使用者
    Route::get('/getOperateUser',[AuthController::class,'getOperateUser']);
    //取得子公司
    Route::get('/getchildcompany',[AuthController::class,'getchildcompanyForReport']);
    //化學品資料、審查、CRUD
    Route::apiResource('chemical',ChemicalBaseController::class);
    Route::apiResource('sdsbase',SdsBaseController::class);
    Route::apiResource('userReview',ChemicalReviewController::class);
    Route::apiResource('sdsReview',SdsReviewController::class);
    Route::get('/ReviewSearch',[chemicalReviewController::class,'search']);
    Route::post('/agreereview/{id}',[ChemicalBaseController::class,'agreereview']);
    Route::post('/reject/{id}',[chemicalReviewController::class,'reject']);
    Route::post('/mutidelete',[ChemicalBaseController::class,'mutidelete']);
    Route::post('/redel',[chemicalReviewController::class,'mutidelete']);
    Route::post('/import-chemical', [ChemicalBaseController::class, 'import']);
    Route::post('/importToxic', [ChemicalBaseController::class, 'importToxic']);
    Route::get('/chemicalSearch',[ChemicalBaseController::class,'search']);
    Route::post('/importSDS',[ChemicalBaseController::class,'importSDS']);
    //工廠管理CRUD
    Route::get('/getFactory/{id}',[FactoryController::class,'getFactory']);
    Route::post('/factoryStore',[FactoryController::class,'factoryStore']);
    Route::post('/bdingStore',[FactoryController::class,'bdingStore']);
    Route::post('/bdingUpdate',[FactoryController::class,'bdingUpdate']);
    Route::delete('/bdingDestory/{id}',[FactoryController::class,'bdingDestory']);
    Route::post('/areaStore',[FactoryController::class,'areaStore']);
    Route::delete('/areaDestory/{id}',[FactoryController::class,'areaDestory']);
    Route::post('/areaUpdate',[FactoryController::class,'areaUpdate']);
    Route::post('/fileUpdate',[FactoryController::class,'fileUpdate']);
    Route::get('/getFactoryAll',[FactoryController::class,'getFactoryAll']);
    Route::delete('/picDestory/{id}',[FactoryController::class,'picDestory']);
    Route::post('/listDestory',[FactoryController::class,'listDestory']);
    //格可文件管理
    Route::get('/getSelectList',[ApprovalDocController::class,'getSelectList']);
    Route::get('/getApproval',[ApprovalDocController::class,'all']);
    Route::get('/docfind/{id}',[ApprovalDocController::class,'docfind']);
    Route::post('/docCreate',[ApprovalDocController::class,'docCreate']);
    Route::post('/docListCreate',[ApprovalDocController::class,'docListCreate']);
    Route::patch('/docListUpdate',[ApprovalDocController::class,'docListUpdate']);
    Route::delete('/docListDelete/{id}',[ApprovalDocController::class,'docListDelete']);
    Route::post('/docDelete',[ApprovalDocController::class,'docDelete']);
    Route::get('/manyChemFindDoc/{id}',[ApprovalDocController::class,'manyChemFindDoc']);
    //化學品新增、刪減
    Route::get('/UserCasNo',[ChemicalBaseController::class,'UserCasNo']);
    Route::post('/chemAddStore', [UserNewChemController::class, 'chemAddStore']);
    Route::get('/getOrd', [UserNewChemController::class, 'getOrd']);
    Route::get('/getEditOrd/{id}', [UserNewChemController::class, 'getEditOrd']);
    Route::post('/chemAddDestory', [UserNewChemController::class, 'chemAddDestory']);
    Route::get('/getFactoryChem', [UserNewChemController::class, 'getFactoryChem']);
    Route::get('/getChemChange', [UserNewChemController::class, 'getChemChange']);
    Route::post('/ord_xls', [UserNewChemController::class, 'import']);

    //化學品使用
    Route::get('/getSearchSelect',[ChemicalSubController::class,'getSearchSelect']);
    Route::get('/getFactoryChemSub',[ChemicalSubController::class,'getFactoryChem']);
    Route::post('/subChem/{id}',[ChemicalSubController::class,'subChem']);
    Route::get('/getSubOperation',[ChemicalSubController::class,'getSubOperation']);
    Route::post('/subOperateUpdate/{id}',[ChemicalSubController::class,'subOperateUpdate']);
    Route::get('/getSubChange',[ChemicalSubController::class,'getSubChange']);
    Route::delete('/delOperate/{id}',[ChemicalSubController::class,'delOperate']);

    //化學品分裝
    Route::post('/decantChem/{id}',[ChemicalDecantController::class,'decantChem']);
    Route::get('/getDecantOperate',[ChemicalDecantController::class,'getDecantOperate']);

    //化學品調撥
    Route::get('/getTransferOperate',[ChemicalTransferController::class,'getTransferOperate']);
    Route::patch('/chemTransferOperate',[ChemicalTransferController::class,'chemTransferOperate']);
    
    //化學品轉出
    Route::get('/getShiftOutLog',[ChemicalShiftOutController::class,'getShiftOutLog']);
    Route::get('/getShiftOutOperate',[ChemicalShiftOutController::class,'getShiftOutOperate']);
    Route::patch('/shiftOut',[ChemicalShiftOutController::class,'shiftOut']);
    Route::delete('/shiftOutRestore',[ChemicalShiftOutController::class,'shiftOutRestore']);
    //化學品輸出
    Route::get('/getExportLog',[ChemicalExportController::class,'getExportLog']);
    Route::get('/getExportOperate',[ChemicalExportController::class,'getExportOperate']);
    Route::patch('/export',[ChemicalExportController::class,'export']);
    Route::delete('/exportRestore',[ChemicalExportController::class,'exportRestore']);
    //化學品賣出
    Route::get('/getSellLog',[ChemicalSellController::class,'getSellLog']);
    Route::get('/getSellOperate',[ChemicalSellController::class,'getSellOperate']);
    Route::patch('/sell',[ChemicalSellController::class,'sell']);
    Route::delete('/sellRestore',[ChemicalSellController::class,'sellRestore']);
    //化學品廢棄
    Route::get('/getDisposal',[ChemicalDisposalController::class,'getDisposal']);
    Route::get('/getDisposalOperate',[ChemicalDisposalController::class,'getDisposalOperate']);
    Route::get('/getDisposalLog',[ChemicalDisposalController::class,'getDisposalLog']);
    Route::patch('/disposal',[ChemicalDisposalController::class,'disposal']);
    Route::delete('/desposalRestore',[ChemicalDisposalController::class,'desposalRestore']);

    //殘氣退回
    Route::get('/getResidual',[ChemicalResidualController::class,'getResidual']);
    Route::patch('/Residual',[ChemicalResidualController::class,'Residual']);
    Route::get('/getResidualLog',[ChemicalResidualController::class,'getResidualLog']);
    Route::delete('/residualRestore',[ChemicalResidualController::class,'residualRestore']);
    //報表區
    Route::get('/getReportlist',[ChemicalReportController::class,'getReportlist']);
    Route::get('/getChemReport',[ChemicalReportController::class,'getChemReport']);
    //申報區
    Route::get('getMoenvlist',[DeclareController::class,'getMoenvlist']);
    Route::get('getMoenvReport',[DeclareController::class,'getMoenvReport']);
    Route::get('getIdaReport',[DeclareController::class,'getIdaReport']);
    Route::get('getDangerlist',[DeclareController::class,'getDangerlist']);
    Route::get('getDangerFactory',[DeclareController::class,'getDangerFactory']);
    //3D
    Route::get('/get3DFactoryChenArea', [UserNewChemController::class, 'get3DFactoryChenArea']);
    Route::get('/get3DFactoryChenBuild', [UserNewChemController::class, 'get3DFactoryChenBuild']);
    Route::get('/get3DFactoryChenFloor', [UserNewChemController::class, 'get3DFactoryChenFloor']);
    //統計
    Route::get('/getGraphData', [StatisticsController::class, 'getGraphData']);
    Route::get('/getOperateData', [StatisticsController::class, 'getOperateData']);
    //上下游廠商
    Route::get('/supAll',[SupplierController::class,'supAll']);
    Route::get('/getInfo',[UserNewChemController::class,'getInfo']);
    Route::get('/getSupEdit/{id}',[SupplierController::class,'getSupEdit']);
    Route::post('/supStore',[SupplierController::class,'supStore']);
    Route::post('/supDestory',[SupplierController::class,'supDestory']);
});









