


/** @type {import('tailwindcss').Config} */
export default {
  content: [
    "./resources/**/*.blade.php",
    "./resources/**/*.js",
    "./resources/**/*.vue",
  ],
  theme: {
    extend: {
      fontFamily: {
      },
      colors:{
        'bee':'#F2EC64',
        'twoone':'#D3D3D3',
        'banner-t':'rgb(0,71,125)',
        'banner-b':'rgb(242,236,100)',
        'edit':'#33a0c7',
        'share-in':'rgb(187,187,187)',
      },
      minHeight:{
        '36': '36rem'
      },
      backgroundImage: {
        'custom-gradient': 'linear-gradient(to bottom, rgb(0,71,125) 0%, rgb(0,71,125)  80%, rgb(242,236,100)  80%, rgb(242,236,100) 100%)',
        'factorycard': 'linear-gradient(to bottom, rgb(241,235,100) 0%, rgb(241,235,100)  25%, rgb(255,255,255)  25%, rgb(255,255,255) 100%)',
        'chemBee-sidebar': "url('@images/background/chemBee-側欄_V2.png')",
      },
      screens: {
        'print': { 'raw': 'print' },
    }
    },
  },
  variants: {
    extend: {
      borderColor: ['print'],
      backgroundColor: ['print'],
    },
  },
  plugins: [],
}