import { defineConfig } from 'vite';
import laravel from 'laravel-vite-plugin';
import vue from '@vitejs/plugin-vue';
import path from 'path';
import Components from 'unplugin-vue-components/vite'
import { HeadlessUiResolver} from 'unplugin-vue-components/resolvers'
import Icons from 'unplugin-icons/vite';
import IconsResolver from 'unplugin-icons/resolver'
//import cesium from 'vite-plugin-cesium';//開發模式須關閉
export default defineConfig({
    assetsInclude: ['**/*.glb'],
    // optimizeDeps: {
    //     exclude: ['url', 'zlib', 'https', 'http']
    //   },
    plugins: [
        laravel({
            input: [
                //'resources/sass/app.scss',
                'resources/css/app.css', 
                'resources/js/app.js',
            ],
            refresh: true,
        }),
        vue({
            template: {
                transformAssetUrls: {
                    base: null,
                    includeAbsolute: false,
                },
            },
        }),
        Components({
            resolvers: [HeadlessUiResolver(), IconsResolver()],
            dirs: ['resources/js/components']
        }),
        Icons({
            autoInstall: true,
            compiler: 'vue3',
        }),
        //cesium(), //開發模式須關閉
    ],
    resolve: {
        alias: {
            vue: 'vue/dist/vue.esm-bundler.js',
            '@images': path.resolve(__dirname, 'public/images'),
            '@js': path.resolve(__dirname, 'resource/js'),
            '@public':path.resolve(__dirname, 'public'),
        },
    },
    build: {
        chunkSizeWarningLimit: 10000,
        rollupOptions: {
            external: ['cesium'],
          },
    },
    define: {
        CESIUM_BASE_URL: JSON.stringify('/sm/csm/cesium')
    },
});
