<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\User;
use App\Models\AdminGroup;
use App\Models\AdminGroupItem;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Exception;

class AdminGroupController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $result = AdminGroup::orderBy('id')->get();
        return response()->json(['data' => $result], 200);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        DB::beginTransaction();
        try {
            $data = $request->all();
            
            $admin_group_id = AdminGroup::create([
                'name' => $data['name'],
                'product_group' => $data['product_group'],
            ])->id;

            foreach ($data['items'] as $item) {
                AdminGroupItem::create([
                    'admin_group_id' => $admin_group_id,
                    'sub_system_id' => $item['id'],
                    'state' => $item['state'] ?? false,
                ]);
            }

            DB::commit();
        } catch (Exception $e) {
            DB::rollback();
            throw $e;
        }
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        $result = AdminGroup::with('items.subSystem')->where('id', $id)->first();
        return response()->json(['data' => $result], 200);
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(AdminGroup $adminGroup)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        DB::beginTransaction();
        try {
            $data = $request->all();

            AdminGroup::where('id', $id)->update([
                'name' => $data['name'],
                'product_group' => $data['product_group'],
            ]);

            foreach ($data['items'] as $item) {
                AdminGroupItem::updateOrCreate([
                    'admin_group_id' => $id,
                    'sub_system_id' => $item['sub_system_id'],
                ], [
                    'state' => $item['state'],
                ]);
            }

            DB::commit();
        } catch (Exception $e) {
            DB::rollback();
            throw $e;
        }
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        $user_count = User::where('group_id', $id)->count();
        if ($user_count > 0) {
            return response()->json(['error' => "尚有管理員正在使用此權限組！"], 500);
        }

        AdminGroup::find($id)->delete();
    }
}
