<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Backfill;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class BackfillController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        if(Auth::user()->permission === '999' || Auth::user()->permission === '111')
            $result = Backfill::with('creator')->orderBy('id', 'desc')->get();
        else
            $result = Backfill::where('user_id', Auth::user()->id)->get();
        
        return response()->json(['data' => $result], 200);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        Backfill::create([
            'plan_text' => $request->plan_text,
            'bank_name' => $request->bank_name,
            'bank_account' => $request->bank_account,
            'user_id' => Auth::user()->id,
        ], 201);
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        $result = Backfill::find($id);
        return response()->json(['data' => $result], 200);
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Backfill $backfill)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        Backfill::where('id', $id)->update( [
            'reply'=> $request->reply,
            'reply_state'=> 1,
            'reply_user_id'=> $request->reply_user_id,
        ]);
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Backfill $backfill)
    {
        //
    }
}
