<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\News;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Storage;
use Exception;
use Carbon\Carbon;

class NewsController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $result = News::with('creator')->orderBy('post_date', 'desc')->orderBy('id', 'desc')->get();
        
        return response()->json(['data' => $result], 200);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        DB::beginTransaction();
        try {
            $news = json_decode($request->news, true);

            if (is_file($request->file_upload)) {
                $path = Storage::disk('public')->put('news', $request->file_upload);

                News::create([
                    'type' => $news['type'],
                    'title' => $news['title'],
                    'content' => $news['content'],
                    'post_date' => $news['post_date'],
                    'photo' => $path,
                    'user_id' => Auth::user()->id,
                ], 201);
            }

            DB::commit();
        } catch (Exception $e) {
            DB::rollback();
            throw $e;
        }

        
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        $result = News::with('creator')->find($id);
        return response()->json(['data' => $result], 200);
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(News $news)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        News::where('id', $id)->update( [
            'type' => $request->type,
            'title' => $request->title,
            'content' => $request->content,
            'post_date' => $request->post_date,
        ]);
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        News::where('id', $id)->delete();
    }

    public function getNewsList()
    {
        $today = Carbon::today()->toDateString();
        $result = News::with('creator')->whereDate('post_date', '<=', $today)->orderBy('post_date', 'desc')->orderBy('id', 'desc')->get();
        
        return response()->json(['success' => true, 'data' => $result], 200);
    }
}
