<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\ServiceForm;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class ServiceFormController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        if(Auth::user()->permission === '999' || Auth::user()->permission === '111')
            $result = ServiceForm::orderBy('reply_state')->orderBy('id', 'desc')->get();
        else
            $result = ServiceForm::where('user_id', Auth::user()->id)->get();
        
        return response()->json(['data' => $result], 200);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        ServiceForm::create([
            'name' => $request->name,
            'email' => $request->email,
            'title' => "聯絡通知",
            'phone' => $request->phone,
            'content' => $request->content,
            'user_id' => $request->user_id,
        ], 201);
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        $result = ServiceForm::find($id);
        return response()->json(['data' => $result], 200);
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(ServiceForm $serviceForm)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        ServiceForm::where('id', $id)->update( [
            'reply'=> $request->reply,
            'reply_state'=> 1,
            'reply_user_id'=> $request->reply_user_id,
        ]);
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(ServiceForm $serviceForm)
    {
        //
    }
}
