<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\UserPlanInterested;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class UserPlanInterestedController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $result = UserPlanInterested::with('creator')->orderBy('created_at', 'desc')->get();
        
        return response()->json(['data' => $result], 200);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $data = $request->all();

        $record = UserPlanInterested::firstOrNew([
            'user_id' => Auth::user()->id,
            'system' => $data['system'],
            'plan' => $data['plan'],
        ]);
        
        if ($record->exists) {
            $record->touch();
        } else {
            $record->save();
        }
    }

    /**
     * Display the specified resource.
     */
    public function show(UserPlanInterested $userPlanInterested)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(UserPlanInterested $userPlanInterested)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, UserPlanInterested $userPlanInterested)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(UserPlanInterested $userPlanInterested)
    {
        //
    }
}
