<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Log;
use DateTimeInterface;

class AdminGroup extends Model
{
    use HasFactory;

    protected $guarded = [];

    protected $casts = [
        'created_at' => 'datetime:Y-m-d H:i:s',
        'updated_at' => 'datetime:Y-m-d H:i:s',
    ];

    protected function serializeDate(DateTimeInterface $date)
    {
        return $date->format('Y-m-d\TH:i:sP');
    }

    public function items()
    {
        return $this->hasMany(AdminGroupItem::class, 'admin_group_id', 'id')->orderBy('id');
    }

    protected static function booted()
    {
        static::deleted(function ($model) {
            $model->items()->each(function ($item) {
                $item->delete();
            });
        });
    }
}
