<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use DateTimeInterface;

class Plan extends Model
{
    use HasFactory, SoftDeletes;

    protected $guarded = [];

    protected $casts = [
        'created_at' => 'datetime:Y-m-d H:i:s',
        'updated_at' => 'datetime:Y-m-d H:i:s',
    ];

    protected function serializeDate(DateTimeInterface $date)
    {
        return $date->format('Y-m-d\TH:i:sP');
    }

    public function subsystem()
    {
        return $this->belongsTo(SubSystem::class, 'sub_system_id', 'id');
    }

    public function items()
    {
        return $this->hasMany(PlanItem::class, 'plan_id', 'id')->orderBy('id');
    }
}
