<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use DateTimeInterface;

class SubSystem extends Model
{
    use HasFactory, SoftDeletes;

    protected $guarded = [];

    protected $casts = [
        'created_at' => 'datetime:Y-m-d H:i:s',
        'updated_at' => 'datetime:Y-m-d H:i:s',
    ];

    protected function serializeDate(DateTimeInterface $date)
    {
        return $date->format('Y-m-d\TH:i:sP');
    }

    public function plans()
    {
        return $this->hasMany(Plan::class, 'sub_system_id', 'id')->orderBy('id');
    }
    
    public function items()
    {
        return $this->hasMany(SubSystemItem::class, 'sub_system_id', 'id')->orderBy('id');
    }
}
