<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use DateTimeInterface;

class UserPlan extends Model
{
    use HasFactory;

    protected $guarded = [];

    protected $casts = [
        'created_at' => 'datetime:Y-m-d H:i:s',
        'updated_at' => 'datetime:Y-m-d H:i:s',
    ];

    protected function serializeDate(DateTimeInterface $date)
    {
        return $date->format('Y-m-d\TH:i:sP');
    }

    public function subsystem()
    {
        return $this->belongsTo(SubSystem::class, 'sub_system_id', 'id');
    }

    public function creator()
    {
        return $this->belongsTo(User::class, 'user_id', 'id');
    }

    public function items()
    {
        return $this->hasMany(UserPlanItem::class, 'user_plan_id', 'id');
    }

    public function addon()
    {
        return $this->hasMany(UserPlanAddon::class, 'user_plan_id', 'id');
    }

    public function firstRecord()
    {
        return $this->hasOne(UserPlanRecord::class, 'user_plan_id', 'id')->orderBy('id', 'asc');
    }

    public function records()
    {
        return $this->hasMany(UserPlanRecord::class, 'user_plan_id', 'id');
    }
}
