<?php

namespace App\Notifications;

use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;
use Illuminate\Support\Facades\Lang;
use Illuminate\Support\Facades\Log;

class CustomResetPassword extends Notification
{
    public $token;
    public $email;

    /**
     * Create a new notification instance.
     */
    public function __construct($token, $email)
    {
        $this->token = $token;
        $this->email = $email;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @return array<int, string>
     */
    public function via(object $notifiable): array
    {
        return ['mail'];
    }

    /**
     * Get the mail representation of the notification.
     */
    public function toMail(object $notifiable): MailMessage
    {
        $url = url("/password/reset/{$this->token}?email=" . urlencode($notifiable->email));
        Log::info(['name' => $notifiable->name, 'email' => $notifiable->email, 'url' => $url]);

        return (new MailMessage)
            ->subject("【WOOBOBEE重設密碼】請勿直接回覆!!")
            ->greeting('您好！')
            ->line("我們收到您的密碼重設請求，請點擊下方按鈕前往重設密碼！")
            ->action("重設密碼", $url)
            ->line(Lang::get('重設密碼連結將於 :count 分鐘後過期。', ['count' => config('auth.passwords.'.config('auth.defaults.passwords').'.expire')]))
            ->line("如果您沒有請求重設密碼，則無需進行操作！");
    }
}
