<?php

namespace App\Notifications;

use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Auth\Notifications\VerifyEmail;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\Config;
use Illuminate\Support\Facades\URL;
use Illuminate\Support\Facades\Log;

class CustomVerifyEmail extends VerifyEmail
{
    public function toMail($notifiable)
    {
        $verificationUrl = $this->verificationUrl($notifiable);

        return (new MailMessage)
            ->subject('【WOOBOBEE驗證信】請勿直接回覆!!')
            ->greeting('您好！')
            ->line('歡迎使用WOOBOBEE，請點擊下方按鈕來驗證您的電子郵件地址。')
            ->action('驗證電子郵件', $verificationUrl);
    }

    protected function verificationUrl($notifiable)
    {
        $originalUrl = URL::temporarySignedRoute(
            'verification.verify',
            Carbon::now()->addMinutes(Config::get('auth.verification.expire', 60)),
            ['id' => $notifiable->getKey(), 'hash' => sha1($notifiable->getEmailForVerification())]
        );

        Log::info(['name' => $notifiable->name, 'email' => $notifiable->email, 'url' => $originalUrl]);

        $urlWithoutApi = str_replace('/api/email/verify', '/email/verify', $originalUrl);

        return $urlWithoutApi;
    }
}
