<?php

namespace App\Policies;

use App\Models\User;
use Illuminate\Auth\Access\HandlesAuthorization;
use Illuminate\Support\Facades\Auth;

class AuthPolicy
{
    use HandlesAuthorization;

    private $user;

    /**
     * Create a new policy instance.
     */
    public function __construct()
    {
        $this->user = Auth::user();
    }

    /**
     * If a user is admin
     * 
     * @return bool
     */
    public function superAdmin()
    {
        return $this->user->permission === '999';
    }

    /**
     * If a user is admin
     * 
     * @return bool
     */
    public function admin()
    {
        return $this->user->permission === '111';
    }

    /**
     * If a user is parent
     * 
     * @return bool
     */
    public function parent()
    {
        return $this->user->permission === '100';
    }
}
