<?php

namespace App\Repositories;

use Illuminate\Support\Facades\DB;
use App\Models\SubSystem;
use App\Models\User;
use App\Models\UserPlan;

class UserRepository
{
    public function getUsersByPermission($permission)
    {
        return User::with('group')->where('permission', $permission)->orderBy('id')->get();
    }

    public function getUsersByBelongsId($parent_id)
    {
        return User::where('belongs', $parent_id)->orderBy('id')->get();
    }

    public function getUsersByBelongsIdAndPermission($parent_id, $permission)
    {
        return User::where('belongs', $parent_id)->where('permission', $permission)->orderBy('id')->get();
    }

    public function getUserHasSubSystem($id)
    {
        $subSystems = SubSystem::where('type', 1)->orderBy('id')->get();

        $user = User::with('systemRole.subSystem')->where('id', $id)->first();

        $subSystems->transform(function ($subSystem) use ($user) {
            $matchedRole = $user->systemRole->first(function ($role) use ($subSystem) {
                return $role->sub_system_id === $subSystem->id;
            });
    
            $state = $matchedRole ? $matchedRole->state : false;

            $subSystem->role = "";
    
            return [
                'sub_system' => $subSystem,
                'state' => $state,
                'role' => $matchedRole->role ?? "",
            ];
        });

        return $subSystems;
    }

    public function show($id)
    {
        return User::find($id);
    }

    public function create($data)
    {
        return User::create($data);
    }

    public function update($id, $data)
    {
        return User::where('id', $id)->update($data);
    }

    public function delete($id)
    {
        return User::where('id', $id)->delete();
    }

    public function subSystemPermission($id)
    {
        $user = User::with(['belongsParent', 'belongsParent.belongsParent'])->where('id', $id)->first();

        switch ($user->permission) {
            // case '999':
            //     $result = SubSystem::select('name', DB::raw('true as state'))->where('type', 1)->get();
            //     return $result;
            case '100':
                $parent_id = $id;
                break;
            case '010':
                $parent_id = optional($user->belongsParent)->id;
                break;
            case '001':
                $parent_id = optional(optional($user->belongsParent)->belongsParent)->id;
                break;
        }

        // 建立子查詢
        $subQuery = UserPlan::select('user_plans.*', 'sub_systems.id as sub_system_id')
            ->join('plans', 'plans.id', '=', 'user_plans.plan_id')
            ->join('sub_systems', 'sub_systems.id', '=', 'plans.sub_system_id')
            ->where('user_plans.user_id', $parent_id)
            ->where('user_plans.state', 1);
            
        // 主查詢
        $result = SubSystem::select('sub_systems.name', DB::raw('plan.id IS NOT NULL as state'))
            ->leftJoinSub($subQuery, 'plan', function ($join) {
                $join->on('plan.sub_system_id', '=', 'sub_systems.id');
            })
            ->where('type', 1)
            ->get();

        return $result;
    }
}
