<?php

namespace App\Services;

use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Str;
use Illuminate\Http\Request;
use Tymon\JWTAuth\Facades\JWTAuth;
use App\Models\User;
use App\Models\UserPlan;
use App\Models\UserSystemRole;

use App\Repositories\UserRepository;

class UserService
{
    private $UserRepository;

    public function __construct(
        UserRepository $UserRepository
    )
    {
        $this->UserRepository = $UserRepository;
    }

    public function getAllAdmins()
    {
        return $this->UserRepository->getUsersByPermission("111");
    }

    public function getAllParents()
    {
        return $this->UserRepository->getUsersByPermission("100");
    }

    public function getUsersByBelongsIdAndPermission($id, $permission)
    {
        return $this->UserRepository->getUsersByBelongsIdAndPermission($id, $permission);
    }

    public function getUserHasSubSystem($id)
    {
        return $this->UserRepository->getUserHasSubSystem($id);
    }

    public function show($id)
    {
        return $this->UserRepository->show($id);
    }

    public function create($data)
    {
        return $this->UserRepository->create($data);
    }

    public function update($id, $data)
    {
        return $this->UserRepository->update($id, $data);
    }

    public function delete($id)
    {
        return $this->UserRepository->delete($id);
    }

    public function subSystemPermission($id)
    {
        return $this->UserRepository->subSystemPermission($id);
    }

    public function getSubsystemToken($user) {
        $hotbeeLoginUrl = config('services.hotbee.base_url') . '/thermal/login';
        $polibeeLoginUrl = config('services.polibee.base_url') . '/api/login';

        // $credentials = [
        //     'uuid' => $user->uuid,
        // ];

        $subSystemService = resolve(SubSystemService::class);
        $parent_id = $subSystemService->getParentId($user->id);
        $user_plans = UserPlan::where('user_plans.user_id', $parent_id)->where('user_plans.state', 1)->get();

        $hotbee_token = null;
        $polibee_token = null;

        $system_role = $this->getUserHasSubSystem($user->id);
        foreach ($system_role as $item) {
            $systemState = $user_plans->filter(function ($user_plan) use ($item) {
                return $user_plan->sub_system_id == $item['sub_system']['id'];
            })->values()->first();

            if ($item['state']) {
                $credentials = [
                    'uuid' => $user->uuid,
                    'order_number' => $systemState->order_number,
                ];
            }

            // HotBee
            if ($item['sub_system']['id'] == 2 && $item['state']) {
                $response = Http::post($hotbeeLoginUrl, $credentials);

                if ($response->successful()) {
                    $hotbee_token = $response->json()['token'];
                }
            }

            // PoliBee
            if ($item['sub_system']['name'] == 1 && $item['state']) {
                $response = Http::post($polibeeLoginUrl, $credentials);

                if ($response->successful()) {
                    $polibee_token = $response->json()['token'];
                }
            }
        }

        return [
            'hotbee_token' => $hotbee_token,
            'polibee_token' => $polibee_token
        ];
    }

    // TODO 嘗試事先登入子系統，確保開通帳號資料已建置
    public function tryLoginSubSystem($user) {
        $systemRole = UserSystemRole::where('user_id', $user->id)->where('state', true)->get();

        foreach ($systemRole as $system) {
            // 這邊先只處理HB，因為需要另外開API
            if ($system->sub_system_id == 2) {
                $hotbee_token = $user->jwtToken($system->sub_system_id);

                $url = config('services.hotbee.base_url') . "/thermal/login/$hotbee_token";
                $response = Http::get($url);
            }
        }
    }
}
