<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('users', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('email');
            $table->string('password');
            $table->string('permission', 3);
            $table->string('contact_name')->nullable();
            $table->string('phone', 20)->nullable();
            $table->string('tax_number', 10)->nullable();
            $table->integer('belongs')->nullable();
            $table->string('api_token', 64)->unique();
            $table->string('uuid', 64)->unique();
            $table->integer('group_id')->nullable();
            $table->timestamp('email_verified_at')->nullable();
            $table->rememberToken();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('users');
    }
};
