<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('backfills', function (Blueprint $table) {
            $table->id();
            $table->integer('user_id');
            $table->text('plan_text');
            $table->text('bank_name');
            $table->text('bank_account');
            $table->text('reply')->nullable();
            $table->integer('reply_state')->default(0); // 0: 未回覆(預設), 1: 已回覆
            $table->integer('reply_user_id')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('backfills');
    }
};
