<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\PlanItem;

class PlanItemSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $array = Array(
            ['plan_id' => 1, 'item_id' => 1, 'amount' => 20],
            ['plan_id' => 1, 'item_id' => 2, 'amount' => 20],
            ['plan_id' => 1, 'item_id' => 3, 'amount' => 300],
            ['plan_id' => 1, 'item_id' => 4, 'amount' => 1],

            ['plan_id' => 2, 'item_id' => 1, 'amount' => 30],
            ['plan_id' => 2, 'item_id' => 2, 'amount' => 20],
            ['plan_id' => 2, 'item_id' => 3, 'amount' => 600],
            ['plan_id' => 2, 'item_id' => 4, 'amount' => 1],

            ['plan_id' => 3, 'item_id' => 1, 'amount' => 50],
            ['plan_id' => 3, 'item_id' => 2, 'amount' => 30],
            ['plan_id' => 3, 'item_id' => 3, 'amount' => 1500],
            ['plan_id' => 3, 'item_id' => 4, 'amount' => 1],

            ['plan_id' => 4, 'item_id' => 5, 'amount' => 2],
            ['plan_id' => 4, 'item_id' => 6, 'amount' => 400],
            ['plan_id' => 4, 'item_id' => 7, 'amount' => 1],

            ['plan_id' => 5, 'item_id' => 5, 'amount' => 4],
            ['plan_id' => 5, 'item_id' => 6, 'amount' => 500],
            ['plan_id' => 5, 'item_id' => 7, 'amount' => 1],

            ['plan_id' => 6, 'item_id' => 5, 'amount' => 8],
            ['plan_id' => 6, 'item_id' => 6, 'amount' => 1600],
            ['plan_id' => 6, 'item_id' => 7, 'amount' => 1],
        );

        foreach ($array as $value) {
            PlanItem::create($value);
        }
    }
}
