import './bootstrap';
import { createApp } from 'vue';

import App from './components/App.vue';
import router from './router.js';
import store from '@/store'
import VueSweetalert2 from 'vue-sweetalert2';
import { library } from "@fortawesome/fontawesome-svg-core";
import { fas } from "@fortawesome/free-solid-svg-icons";
import { FontAwesomeIcon } from "@fortawesome/vue-fontawesome";
import { createI18n } from 'vue-i18n'
import zh_TW from './locales/zh-TW.json'
import zh_CN from './locales/zh-CN.json'   

const i18n = createI18n({
  legacy: false, // ensure using Vue 3 composition API
  locale: 'zh_TW',
  fallbackLocale: 'zh_CN',
  messages: {
    zh_TW,
    zh_CN
  }
});

import * as DataTable from "datatables.net-dt";
$.extend(true, $.fn.dataTable.defaults, {
  searching: true,
  lengthChange: false,
  order: [[0, "asc"]],
  pageLength: 10,
  language: {
    sEmptyTable: "尚無資料",
    zeroRecords: "尚無資料",
    info: "共 _TOTAL_ 項",
    infoEmpty: "共 0 項",
    infoFiltered: "(從 _MAX_ 項結果中過濾)",
    paginate: {
      first: "第一頁",
      previous: "上一頁",
      next: "下一頁",
      last: "最後一頁",
    },
  },
});

library.add(fas);

createApp(App)
  .component('font-awesome-icon', FontAwesomeIcon)
  .use(i18n)
  .use(router)
  .use(store)
  .use(DataTable)
  .use(VueSweetalert2)
  .mount('#app');