import store from "@/store";

function isAuthenticated() {
    return store.state.auth.authenticated;
}

function isSuperAdmin() {
    return store.state.auth.user?.permission === "999";
}

function isAdmin() {
    return isSuperAdmin() || store.state.auth.user?.permission === "111";
}

function isParent() {
    return store.state.auth.user?.permission === "100";
}

function isSub() {
    return store.state.auth.user?.permission === "010";
}

function isUser() {
    return store.state.auth.user?.permission === "001";
}

function systemRole() {
    let roles = store.state.auth.user?.system_role;

    const stateMap = {};
    switch (true) {
        case isSuperAdmin():
            roles.forEach(role => {
                stateMap[role.sub_system.id] = true;
            });
            break;
        case isAdmin():
            const items = store.state.auth.user?.group?.items;
            items.forEach(item => {
                stateMap[item.sub_system_id] = item.state;
            });
            break;
        default:
            roles.forEach(role => {
                stateMap[role.sub_system.id] = role.state;
            });
    }
    return stateMap;
}

export {
    isAuthenticated,
    isSuperAdmin,
    isAdmin,
    isParent,
    isSub,
    isUser,
    systemRole,
};
