import Swal from 'sweetalert2';

export function sendSuccessSwal(next) {
    return Swal.fire({
        title: "成功",
        icon: "success",
        confirmButtonText: "確認",
        customClass: {
            confirmButton: "btn btn-success"
        },
        buttonsStyling: false,
    }).then(next);
}

export function sendFailedSwal(err) {
    let text = "權限異常";
    let content = "";
    let action = () => {window.location = "/";};
    if (err) {
        switch (err.response.status) {
            case 404:
                text = "查無此頁";
                break;
            case 403:
                text = "權限異常";
                break;
            case 401:
            case 419:
                return ;
                text = "狀態已過期";
                action = () => {window.location = "/";}
                break;
            case 500:
                text = "發生錯誤";
                content = err.response.data.error ?? "";
                action = () => {}
                break;
            default:
                text = "發生錯誤";
                action = () => {}
        }
    }

    return Swal.fire({
        title: text,
        text: content,
        icon: "error",
        confirmButtonText: "確認",
        customClass: {
            confirmButton: "btn btn-danger"
        },
        buttonsStyling: false,
        //text: text,
    }).then(action);
}

export function swalDelete(next) {
    return Swal.fire({
        title: "確認刪除？",
        icon: "warning",
        confirmButtonText: "確認",
        cancelButtonText: "取消",
        customClass: {
            confirmButton: "btn btn-danger ms-3",
            cancelButton: 'btn btn-secondary'
        },
        showCancelButton: true,
        reverseButtons: true,
        buttonsStyling: false,
    }).then(next);
}

export function swalCancel(next) {
    return Swal.fire({
        title: "確認取消？",
        icon: "warning",
        confirmButtonText: "確認",
        cancelButtonText: "取消",
        customClass: {
            confirmButton: "btn btn-danger ms-3",
            cancelButton: 'btn btn-secondary'
        },
        showCancelButton: true,
        reverseButtons: true,
        buttonsStyling: false,
    }).then(next);
}

export function swalWarning(content) {
    return Swal.fire({
        title: "警告",
        text: content,
        icon: "warning",
        confirmButtonText: "確認",
        customClass: {
            confirmButton: "btn btn-secondary"
        },
        buttonsStyling: false,
    });
}

export function swalInfo(content) {
    return Swal.fire({
        title: "提示",
        html: content,
        icon: "info",
        confirmButtonText: "確認",
        customClass: {
            confirmButton: "btn btn-info"
        },
        buttonsStyling: false,
    });
}


// export function swalDeleteInfo(
//     title = "",
//     text = "注意，刪除後就不能再回來了！",
//     icon = "warning",
//     showCancelButton = true,
//     confirmButtonText = "確認",
//     cancelButtonText = "取消"
// ) {
//     return {
//         title: title,
//         text: text,
//         icon: icon,
//         showCancelButton: showCancelButton,
//         confirmButtonText: confirmButtonText,
//         cancelButtonText: cancelButtonText,
//     };
// }

// export function swalDelete(
//     title = "注意，刪除後就不能再回來了！",
//     text = "",
//     icon = "warning"
// ) {
//     return swal({
//         title: title,
//         text: text,
//         icon: icon,
//         dangerMode: true,
//         buttons: ["取消", "確認"],
//     });
// }

// export function popSwal(
//     title = "",
//     text = "",
//     icon = "info",
//     dangerMode = false,
//     buttons = ["取消", "確認"]
// ) {
//     return swal({
//         title: title,
//         text: text,
//         icon: icon,
//         dangerMode: dangerMode,
//         buttons: buttons,
//     });
// }
