import { createStore } from 'vuex'
import createPersistedState from 'vuex-persistedstate'
import auth from '@/store/auth'

const store = createStore({
    plugins:[
        createPersistedState()
    ],
    modules:{
        auth
    },
    state: {
        loading: false,
        sidebar: 1,
        serviceform: {
            type: "@add",
            id: 0,
        },
    },
    mutations:{
        SET_LOADING (state, value) {
            state.loading = value
        },
        SET_SIDEBAR (state, value) {
            state.sidebar = value
        },
        SET_SERVICEFORM (state, value) {
            state.serviceform = value
        }
    },
})

export default store