const ASSET_URL = import.meta.env.VITE_ASSET_URL

export async function introspectToken(token) {
  try {
    const response = await fetch(`${ASSET_URL}/api/sso/token/verify`, {
      method: 'POST',
      headers: { 'Content-Type': 'application/json' },
      body: JSON.stringify({ token }),
    });

    const result = await response.json();
    return result.active === true;
  } catch (error) {
    console.error('Token introspection failed:', error);
    return false;
  }
}