<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

use App\Http\Controllers\Api\UserController;
use App\Http\Controllers\Api\ServiceFormController;
use App\Http\Controllers\Api\SubSystemController;
use App\Http\Controllers\Api\BackfillController;
use App\Http\Controllers\Api\UserPlanController;
use App\Http\Controllers\Api\AdminGroupController;
use App\Http\Controllers\Api\NewsController;
use App\Http\Controllers\Api\PlanController;
use App\Http\Controllers\Api\UserPlanInterestedController;
use App\Http\Controllers\Api\VersionController;

use App\Http\Controllers\Auth\VerificationController;
use App\Http\Controllers\Auth\ForgotPasswordController;

use App\Http\Controllers\Api\SSOController;
use App\Http\Controllers\Api\SSOForAPPController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

Route::get('/app/sso/callback', [SSOForAPPController::class, 'handleCallback']);
Route::get('/sso/callback', [SSOController::class, 'handleCallback']);
Route::post('/sso/token/verify', [SSOController::class, 'verifyToken']);
Route::post('/sso/ida/addLoginLog', [SSOController::class, 'addLoginLog']);


Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});

Route::post('login', [UserController::class, 'login']);

Route::get('email/verify/{id}/{hash}', [VerificationController::class, 'verify'])->name('verification.verify');
Route::post('email/resend', [VerificationController::class, 'resend'])->name('verification.resend');
Route::post('password/send', [ForgotPasswordController::class, 'sendResetLinkEmail']);
Route::post('password/reset', [ForgotPasswordController::class, 'reset'])->name('password.reset');

Route::middleware('auth:api')->group(function () {
    Route::post('logout', [UserController::class, 'logout']);

    Route::get('getUser', [UserController::class, 'getUser']);

    Route::post('userResetPassword', [UserController::class, 'userResetPassword']);

    Route::get('getSubSystemWithItem', [SubSystemController::class, 'getSubSystemWithItem']);
    Route::get('getSubSystemWithPlan', [SubSystemController::class, 'getSubSystemWithPlan']);
    Route::get('getAllUserSubSystemWithPlan', [SubSystemController::class, 'getAllUserSubSystemWithPlan']);
    Route::get('getOneUserSubSystemWithPlan/{user_id}', [SubSystemController::class, 'getOneUserSubSystemWithPlan']);
    Route::get('getOneUserSubSystemState/{user_id}', [SubSystemController::class, 'getOneUserSubSystemState']);
    Route::get('checkHasSubSystemPermision/{user_id}', [SubSystemController::class, 'checkHasSubSystemPermision']);
    Route::get('getSubSystemGroups', [SubSystemController::class, 'getSubSystemGroups']);
    Route::get('getSubSystemUsage', [SubSystemController::class, 'getSubSystemUsage']);

    Route::post('getSubSystemWithStatistics', [SubSystemController::class, 'getSubSystemWithStatistics']);
    Route::post('getSubSystemWithStatisticsDetail', [SubSystemController::class, 'getSubSystemWithStatisticsDetail']);
    Route::post('getUserPermissionStatistics', [UserController::class, 'getUserPermissionStatistics']);

    Route::get('getUserSubHasSystemRole/{system_id}/{type}/{user_id}', [SubSystemController::class, 'getUserSubHasSystemRole']);

    Route::get('checkUserPlanExpiry', [UserPlanController::class, 'checkUserPlanExpiry']);

    Route::get('getOneUserPlan/{user_plan_id}', [UserPlanController::class, 'getOneUserPlan']);

    Route::post('userPlanActivate', [UserPlanController::class, 'userPlanActivate']);
    Route::post('userPlanUpdate', [UserPlanController::class, 'userPlanUpdate']);
    Route::post('userPlanCancel/{user_plan_id}', [UserPlanController::class, 'userPlanCancel']);
    Route::get('getUserPlanRecord/{user_plan_id}', [UserPlanController::class, 'getUserPlanRecord']);

    
    Route::apiResource('subSystem', SubSystemController::class);
    Route::apiResource('adminGroup', AdminGroupController::class);
    Route::apiResource('backfill', BackfillController::class);
    Route::apiResource('news', NewsController::class);
    Route::apiResource('plan', PlanController::class);
    Route::apiResource('userPlanInterested', UserPlanInterestedController::class);

    //---------------------------------------

    Route::get('/getJwtToken', [UserController::class, 'getJwtToken']);
    Route::get('/getJwtTokenByUserId/{id}', [UserController::class, 'getJwtTokenByUserId']);

    Route::get('/getAllAdmins', [UserController::class, 'getAllAdmins']);
    Route::get('/getAllParents', [UserController::class, 'getAllParents']);
    Route::get('/getSubByParentId/{parent_id}', [UserController::class, 'getSubByParentId']);
    Route::get('/getUserBySubId/{sub_id}', [UserController::class, 'getUserBySubId']);

    Route::get('/getParentsHasSubSystem/{id}', [UserController::class, 'getParentsHasSubSystem']);
    Route::get('/getUserHasSubSystem/{id}', [UserController::class, 'getUserHasSubSystem']);

    Route::apiResource('user', UserController::class);

    Route::get('getServiceForm', [ServiceFormController::class, 'index']);
});

Route::apiResource('serviceForm', ServiceFormController::class);

Route::get('getNewsList', [NewsController::class, 'getNewsList']);
Route::get('getNewsById/{id}', [NewsController::class, 'show']);

Route::get('/app/version', [VersionController::class, 'check']);
Route::get('/callEncryptDate/{date}', [VersionController::class, 'callEncryptDate']);

// Route::get('/testUserAdd', [UserController::class, 'testUserAdd']);