import { defineConfig, loadEnv } from 'vite';
import laravel from 'laravel-vite-plugin';
import vue from '@vitejs/plugin-vue';
import path from 'path';

export default defineConfig(({ mode }) => {
    const env = loadEnv(mode, process.cwd(), '');
    const rawAssetUrl = env.VITE_ASSET_URL || '';
    const assetUrl = rawAssetUrl === '/' ? '' : rawAssetUrl.replace(/\/+$/, '');
    
    return {
        base: `${assetUrl}/build/`,
        plugins: [
            laravel({
                input: ['resources/css/app.css', 'resources/js/app.js'],
                refresh: true,
            }),
            vue({
                template: {
                    transformAssetUrls: {
                        base: null,
                        includeAbsolute: false,
                    },
                    compilerOptions: {
                        isCustomElement: (tag) => tag === 'l-loading'
                    }
                },
            }),
        ],
        resolve: {
            alias: {
                '@images': path.resolve(__dirname, 'public/images'),
            },
        },
        build: {
            chunkSizeWarningLimit: 3500,
        },
    };
});